/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.cti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.cti.HeaderIO;
import edu.uthscsa.ric.volume.formats.cti.ImageSubheader;
import edu.uthscsa.ric.volume.formats.cti.MainHeader;
import edu.uthscsa.ric.volume.formats.cti.Subheader;
import edu.uthscsa.ric.volume.formats.dicom.Dictionary;
import edu.uthscsa.ric.volume.formats.dicom.Tag;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class CTI
implements ReadableHeader {
    private File headerFile;
    private MainHeader mainheader;
    private Vector<ImageSubheader> associatedFileSubHeaders;
    private Vector<Integer> associatedFileOffsets;
    private Vector<MainHeader> associatedFileMainHeaders;
    private Vector<Subheader> subheaders;
    private Vector<URI> associatedFiles;
    public static final String LUT_EXPLANATION = "ECAT Calibration Factor * Image Sub Header Scale Factor";
    public static final String LUT_LABEL = "ECAT";
    public static final String MAGIC_NUMBER = "MATRIX72";
    public static final String MANUFACTURER = "Siemens";
    public static final String MEASUREMENT_UNIT = "Bq/cc";
    public static final String NAME = "CTI";
    public static final String ORIENTATION = "XYZ---";
    public static final String PREFERRED_EXTENSION = ".v";
    public static final String RII_CTI_FILENAME_PREFIX = "Z";
    public static final String RII_TRANSMISSION_SCAN_IDENTIFIER = "trm";
    public static final int VOXEL_SIZE_MULTIPLIER = 10;

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        ImageDescription id = new ImageDescription(this.mainheader.patientId, this.mainheader.patientName, this.mainheader.scanStart, "");
        Map<Long, String> dicomMetadataMap = this.generateDicomItems();
        this.readRIIInfo(dicomMetadataMap, this.associatedFiles.size() == 0);
        id.setDicomItems(dicomMetadataMap);
        if (this.associatedFiles.size() > 0) {
            id.setAssociatedFiles(this.associatedFiles.toArray(new URI[this.associatedFiles.size()]));
        }
        id.setFile(this.headerFile.toURI());
        return id;
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions id = new ImageDimensions((int)this.getImageSubheader().dimX, (int)this.getImageSubheader().dimY, (int)this.mainheader.numPlanes, 1);
        id.setImageOffset((int)(512L * this.getImageSubheader().dataFirst));
        if (this.associatedFileOffsets.size() > 0) {
            id.setTimepoints(this.associatedFiles.size());
            Integer[] offsets = this.associatedFileOffsets.toArray(new Integer[this.associatedFileOffsets.size()]);
            int[] offsetInts = new int[offsets.length];
            for (int ctr = 0; ctr < offsets.length; ++ctr) {
                offsetInts[ctr] = offsets[ctr];
            }
            id.setImageOffsets(offsetInts);
        }
        return id;
    }

    public URI getImageFile() {
        return this.headerFile.toURI();
    }

    public ImageRange getImageRange() {
        ImageRange ir = new ImageRange((double)this.getImageSubheader().imageMin, (double)this.getImageSubheader().imageMax, (double)this.getImageSubheader().imageMin, (double)this.getImageSubheader().imageMax);
        if (this.associatedFiles.size() > 0) {
            int numSlices = this.mainheader.numPlanes;
            int numSeriesPoints = this.associatedFiles.size();
            float[] scales = new float[numSlices * numSeriesPoints];
            float[] intercepts = new float[numSlices * numSeriesPoints];
            for (int ctrT = 0; ctrT < numSeriesPoints; ++ctrT) {
                MainHeader main = this.associatedFileMainHeaders.get(ctrT);
                ImageSubheader sub = this.associatedFileSubHeaders.get(ctrT);
                for (int ctr = 0; ctr < numSlices; ++ctr) {
                    scales[ctrT * numSlices + ctr] = main.ecatCalibrationFactor * sub.scaleFactor;
                }
            }
            ir.setDataScaleSlopes(scales);
            ir.setDataScaleIntercepts(intercepts);
        } else {
            int numSlices = this.mainheader.numPlanes;
            float[] scales = new float[numSlices];
            float[] intercepts = new float[numSlices];
            for (int ctr = 0; ctr < numSlices; ++ctr) {
                scales[ctr] = this.mainheader.ecatCalibrationFactor * this.getImageSubheader().scaleFactor;
            }
            ir.setDataScaleSlopes(scales);
            ir.setDataScaleIntercepts(intercepts);
        }
        return ir;
    }

    public ImageType getImageType() {
        ImageType it = null;
        if (this.getImageSubheader().dataType == 1) {
            it = new ImageType(1, 3, 8, false);
        } else if (this.getImageSubheader().dataType == 2) {
            it = new ImageType(2, 3, 16, true);
        } else if (this.getImageSubheader().dataType == 6) {
            it = new ImageType(2, 2, 16, false);
        }
        return it;
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getOrientation() {
        return ORIENTATION;
    }

    public int getOrientationCertainty() {
        return 1;
    }

    public Coordinate getOrigin() {
        return new Coordinate((double)(this.getImageSubheader().offsetX * 10.0f), (double)(this.getImageSubheader().offsetY * 10.0f), (double)(this.getImageSubheader().offsetZ * 10.0f));
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return PREFERRED_EXTENSION;
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        MainHeader main = this.associatedFileMainHeaders.get(seriesPoint);
        Subheader sub = this.associatedFileSubHeaders.get(seriesPoint);
        StringBuffer sb = new StringBuffer();
        sb.append(main.toString()).append('\n').append(sub.toString()).append('\n');
        return sb.toString();
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = new VoxelDimensions((double)(10.0f * this.getImageSubheader().pixelSizeX), (double)(10.0f * this.getImageSubheader().pixelSizeY), (double)(10.0f * this.getImageSubheader().pixelSizeZ), 0.0);
        vd.setSpatialUnit(2);
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        RandomAccessFile fileReader = null;
        boolean isFormat = false;
        try {
            fileReader = new RandomAccessFile(file, "r");
            byte[] firstBytes = new byte[MAGIC_NUMBER.length()];
            int bytesRead = fileReader.read(firstBytes);
            String str = null;
            if (bytesRead > 0) {
                str = new String(firstBytes, 0, bytesRead);
            }
            if (MAGIC_NUMBER.equals(str)) {
                isFormat = true;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return isFormat;
    }

    public void readHeader(File fileVal, File tempDir) throws InvalidHeaderException {
        File file = fileVal;
        File[] possibleAssociatedFiles = this.findSeriesFiles(file);
        this.associatedFiles = new Vector();
        this.associatedFileOffsets = new Vector();
        this.associatedFileMainHeaders = new Vector();
        this.associatedFileSubHeaders = new Vector();
        if (CollectionUtilities.isNotEmpty((Object)possibleAssociatedFiles)) {
            this.headerFile = file = possibleAssociatedFiles[0];
            this.subheaders = new Vector();
            this.mainheader = this.readFile(file, this.subheaders);
            Vector<Subheader> subs = new Vector<Subheader>();
            MainHeader main = this.readFile(file, subs);
            for (File nextFile : possibleAssociatedFiles) {
                subs = new Vector();
                main = this.readFile(nextFile, subs);
                this.associatedFiles.add(nextFile.toURI());
                this.associatedFileOffsets.add((int)(512L * ((ImageSubheader)subs.get((int)0)).dataFirst));
                this.associatedFileMainHeaders.add(main);
                this.associatedFileSubHeaders.add((ImageSubheader)subs.get(0));
            }
        } else {
            this.headerFile = file;
            this.subheaders = new Vector();
            this.mainheader = this.readFile(file, this.subheaders);
        }
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.readHeader(new File(uri), tempDir);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mainheader.toString()).append('\n');
        Iterator<Subheader> it = this.subheaders.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private File[] findSeriesFiles(File file) {
        File dir = file.getParentFile();
        String filename = file.getName();
        if (filename.startsWith(RII_CTI_FILENAME_PREFIX)) {
            final String[] selectedNames = this.getStudyAndSeriesNames(filename);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.indexOf(CTI.RII_TRANSMISSION_SCAN_IDENTIFIER) == -1 && name.endsWith(CTI.PREFERRED_EXTENSION)) {
                        String[] names = CTI.this.getStudyAndSeriesNames(name);
                        if (selectedNames != null && names != null) {
                            return selectedNames[0].equals(names[0]) && selectedNames[1].equals(names[1]);
                        }
                    }
                    return false;
                }
            };
            Object[] files = dir.listFiles(filter);
            if (files != null) {
                Arrays.sort(files);
            }
            return files;
        }
        return null;
    }

    private Map<Long, String> generateDicomItems() {
        HashMap<Long, String> dicomItems = new HashMap<Long, String>();
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_MANUFACTURER), MANUFACTURER);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_MANUFACTURER_MODEL_NAME), String.valueOf(this.mainheader.systemType));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_DEVICE_SERIAL_NUMBER), String.valueOf(this.mainheader.serialNumber));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_SOFTWARE_VERIONS), String.valueOf(this.mainheader.softwareVersion));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_DATA_COLLECTION_DIAMETER), String.valueOf(this.mainheader.transaxialFov * 10.0f));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_GANTRY_DETECTOR_TILT), String.valueOf(this.mainheader.gantryTilt));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_GANTRY_DETECTOR_SLEW), String.valueOf(this.mainheader.gantryRotation));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_TABLE_HIEGHT), String.valueOf(this.mainheader.bedElevation * 10.0f));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_TABLE_POSITION), String.valueOf(this.mainheader.initBedPosition * 10.0f));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0054_RADIONUCLIDE_CODE_SQ), this.mainheader.isotopeName);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_RADIOPHARMA_START_TIME), String.valueOf(this.mainheader.doseStartTime * 1000L));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_RADIONUCLIDE_HALF_LIFE), String.valueOf(this.mainheader.isotopeHalfLife));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0054_RADIOPHARMA_CODE_SQ), this.mainheader.radiopharmaceutical);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_ACQUISITION_DATETIME), String.valueOf(this.mainheader.scanStartTime * 1000L));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_ACQUISITION_DURATION), String.valueOf((int)((double)((ImageSubheader)this.subheaders.get((int)0)).frameDuration / 1000.0)));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0010_PATIENT_BIRTH_DATE), String.valueOf(this.mainheader.patientBirthDate * 1000L));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0010_PATIENT_SEX), this.mainheader.patientSex);
        if (this.isEmmision()) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0054_COUNTS_SOURCE), "EMISSION");
        } else if (this.isTransmission()) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0054_COUNTS_SOURCE), "TRANSMISSION");
        } else {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0054_COUNTS_SOURCE), "UNKNOWN");
        }
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_SERIES_DESCRIPTION), this.mainheader.acqTypeS);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0028_LUT_EXPLANATION), LUT_EXPLANATION);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0040_LUT_LABEL), LUT_LABEL);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0040_MEASUREMENT_UNITS_CODE_SQ), MEASUREMENT_UNIT);
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_STUDY_DATE), String.valueOf(this.mainheader.scanStart.getTime()));
        dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_STUDY_TIME), String.valueOf(this.mainheader.scanStart.getTime()));
        return dicomItems;
    }

    private ImageSubheader getImageSubheader() {
        return (ImageSubheader)this.subheaders.get(0);
    }

    private String[] getStudyAndSeriesNames(String filename) {
        String[] parts = filename.split("_");
        String[] names = null;
        if (parts.length > 1) {
            names = new String[]{parts[0], parts[1]};
        }
        if (parts.length > 2) {
            names[1] = names[1] + parts[2];
        }
        return names;
    }

    private boolean isEmmision() {
        return this.mainheader.acquisitionType == 3 || this.mainheader.acquisitionType == 4 || this.mainheader.acquisitionType == 5 || this.mainheader.acquisitionType == 7;
    }

    private boolean isTransmission() {
        return this.mainheader.acquisitionType == 2 || this.mainheader.acquisitionType == 6;
    }

    private MainHeader readFile(File file, Vector<Subheader> subs) {
        HeaderIO headerio = new HeaderIO();
        MainHeader main = headerio.readMain(file.toString());
        subs.addAll(headerio.getSubheaders(file.toString(), main.fileType));
        return main;
    }

    private void readRIIInfo(Map<Long, String> dicomItems, boolean doImageId) {
        String filename = this.headerFile.getName();
        if (filename.indexOf(46) != -1) {
            filename = filename.substring(0, filename.lastIndexOf(46));
        }
        if (filename.startsWith(RII_CTI_FILENAME_PREFIX) && filename.indexOf(95) != -1) {
            String[] parts = filename.split("_");
            if (parts.length > 1) {
                String seriesStr = parts[1];
                if (parts.length > 2) {
                    seriesStr = seriesStr + parts[2];
                }
                seriesStr = seriesStr.replaceAll("[^\\d]", "");
                if (StringUtils.isNotBlank((CharSequence)(seriesStr = seriesStr.replaceFirst("^0+(?!$)", "")))) {
                    dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0020_SERIES_ID), seriesStr);
                }
            }
            if (doImageId) {
                boolean basicImage = false;
                boolean sumImage = false;
                boolean transmissionImage = false;
                if (parts.length > 2) {
                    if (parts[2].length() == 5) {
                        if (parts[2].indexOf(RII_TRANSMISSION_SCAN_IDENTIFIER) != -1) {
                            transmissionImage = true;
                        } else if (parts.length > 3) {
                            basicImage = true;
                        }
                    } else if (parts[2].length() == 2 && parts.length > 3 && parts[3].length() == 2) {
                        sumImage = true;
                    }
                }
                String imageStr = "";
                if (basicImage) {
                    imageStr = parts[3];
                    imageStr = imageStr.replaceFirst("^0+(?!$)", "");
                    imageStr = imageStr.replaceAll("[^\\d]", "0");
                } else if (sumImage) {
                    imageStr = "1" + parts[2] + parts[3];
                    imageStr = imageStr.replaceAll("[^\\d]", "0");
                } else if (transmissionImage) {
                    imageStr = "99999";
                }
                if (StringUtils.isNotBlank((CharSequence)imageStr)) {
                    dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0020_IMAGE_NUMBER), imageStr);
                }
            }
        }
    }
}

