/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.analyze;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageIntent;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class AVW
implements EditableHeader,
ReadableHeader,
WritableHeader {
    private URI headerFile;
    private boolean isCompressedFile;
    private boolean littleEndian;
    private byte orient;
    private byte[] auxFile;
    private byte[] calUnits;
    private byte[] description;
    private byte[] expDate;
    private byte[] expTime;
    private byte[] generated;
    private byte[] patientID;
    private byte[] scanNum;
    private byte[] voxUnits;
    private float calMax;
    private float calMin;
    private float roiScale;
    private float voxOffset;
    private int compressed;
    private int fieldSkip;
    private int globalMax;
    private int globalMin;
    private int omax;
    private int omin;
    private int smax;
    private int smin;
    private int startField;
    private int verified;
    private int views;
    private int volsAdded;
    private short bitPix;
    private short dataType;
    private short originX;
    private short originY;
    private short originZ;
    private final float[] pixDim;
    private final short[] dim = new short[8];
    private static final byte[] EMPTY = new byte[100];
    public static final List<String> VALID_ORIENTATIONS = CollectionUtilities.immutable((String[])new String[]{"XYZ+++", "XZY+++", "YZX+++", "XYZ+-+", "XZY+-+", "YZX+-+"});
    public static final String ANONYMIZED = "ANONYMIZED";
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String NAME = "Analyze";
    public static final String PREFERRED_EXTENSION = "hdr";
    public static final String PREFERRED_IMAGE_EXTENSION = "img";
    public static final String SPATIAL_UNITS_METER_STRING = "met";
    public static final String SPATIAL_UNITS_MICRON_STRING = "mic";
    public static final String SPATIAL_UNITS_MM_STRING = "mm";
    public static final String TEXT_AUXILIARY_FILE = "Auxiliary File";
    public static final String TEXT_BITS_PER_VOXEL = "Bits Per Voxel";
    public static final String TEXT_CALIBRATION = "Calibrated (Max, Min)";
    public static final String TEXT_CAL_UNITS = "Calibration Unit";
    public static final String TEXT_COMPRESSED = "Compressed";
    public static final String TEXT_DATATYPE = "Datatype";
    public static final String TEXT_DESCRIPTION = "Description";
    public static final String TEXT_EXPERIMENT_TIME = "Experiment Time (Date, Time)";
    public static final String TEXT_FIELD_SKIP = "Field Skip";
    public static final String TEXT_GENERATED = "Generated";
    public static final String TEXT_GLOBAL_RANGE = "Global (Max, Min)";
    public static final String TEXT_IMAGE_DIMENSIONS = "Image Dimensions";
    public static final String TEXT_IMAGE_OFFSET = "Image Offset";
    public static final String TEXT_ORIENT = "Orientation";
    public static final String TEXT_ORIGIN = "Origin";
    public static final String TEXT_ORIGINAL = "Original (Max, Min)";
    public static final String TEXT_PATIENT_ID = "Patient ID";
    public static final String TEXT_ROI_SCALE = "Scale";
    public static final String TEXT_SCALED = "Scaled (Max, Min)";
    public static final String TEXT_SCAN_NUM = "Scan Number";
    public static final String TEXT_START_FIELD = "Start Field";
    public static final String TEXT_VERIFIED = "Verified";
    public static final String TEXT_VIEWS = "Views";
    public static final String TEXT_VOLS_ADDED = "Vols Added";
    public static final String TEXT_VOXEL_DIMENSIONS = "Voxel Dimensions";
    public static final String TEXT_VOX_UNITS = "Voxel Unit";
    public static final byte HKEY = 0;
    public static final byte REGULAR = 114;
    public static final int DT_ALL = 255;
    public static final int DT_BINARY = 1;
    public static final int DT_COMPLEX = 32;
    public static final int DT_DOUBLE = 64;
    public static final int DT_FLOAT = 16;
    public static final int DT_NONE = 0;
    public static final int DT_RGB = 128;
    public static final int DT_SIGNED_INT = 8;
    public static final int DT_SIGNED_SHORT = 4;
    public static final int DT_UNKNOWN = 0;
    public static final int DT_UNSIGNED_CHAR = 2;
    public static final int EXTENTS_CODE = 16384;
    public static final int HEADER_FILE_SIZE = 348;
    public static final int ORIENT_COR_FLIP = 4;
    public static final int ORIENT_COR_UNFLIP = 1;
    public static final int ORIENT_SAG_FLIP = 5;
    public static final int ORIENT_SAG_UNFLIP = 2;
    public static final int ORIENT_TRAN_FLIP = 3;
    public static final int ORIENT_TRAN_UNFLIP = 0;
    public static final short SESSION_ERROR_CODE = 0;

    private static String validateOrientation(String orientation) {
        for (String orient : VALID_ORIENTATIONS) {
            if (!orientation.equals(orient)) continue;
            return orientation;
        }
        return VALID_ORIENTATIONS.get(0);
    }

    public AVW() {
        this.pixDim = new float[8];
    }

    public Map<String, List<String>> anonymize() {
        this.description = ANONYMIZED.getBytes();
        this.generated = ANONYMIZED.getBytes();
        this.scanNum = ANONYMIZED.getBytes();
        this.patientID = ANONYMIZED.getBytes();
        return this.getEditableFieldValues();
    }

    public boolean canCompress() {
        return false;
    }

    public File formatImageFile(File headerFile) {
        return new File(this.makeImageURI(headerFile.toURI()));
    }

    public List<String> getAnonymizableFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TEXT_DESCRIPTION);
        list.add(TEXT_GENERATED);
        list.add(TEXT_SCAN_NUM);
        list.add(TEXT_PATIENT_ID);
        return list;
    }

    public Map<String, List<String>> getEditableFieldValues() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put(TEXT_IMAGE_DIMENSIONS, Arrays.asList(String.valueOf(this.dim[0]), String.valueOf(this.dim[1]), String.valueOf(this.dim[2]), String.valueOf(this.dim[3]), String.valueOf(this.dim[4]), String.valueOf(this.dim[5]), String.valueOf(this.dim[6]), String.valueOf(this.dim[7])));
        try {
            map.put(TEXT_VOX_UNITS, Arrays.asList(new String(this.voxUnits, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_CAL_UNITS, Arrays.asList(new String(this.calUnits, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put(TEXT_DATATYPE, Arrays.asList(String.valueOf(this.dataType)));
        map.put(TEXT_BITS_PER_VOXEL, Arrays.asList(String.valueOf(this.bitPix)));
        map.put(TEXT_VOXEL_DIMENSIONS, Arrays.asList(String.valueOf(this.pixDim[0]), String.valueOf(this.pixDim[1]), String.valueOf(this.pixDim[2]), String.valueOf(this.pixDim[3]), String.valueOf(this.pixDim[4]), String.valueOf(this.pixDim[5]), String.valueOf(this.pixDim[6]), String.valueOf(this.pixDim[7])));
        map.put(TEXT_IMAGE_OFFSET, Arrays.asList(String.valueOf(this.voxOffset)));
        map.put(TEXT_ROI_SCALE, Arrays.asList(String.valueOf(this.roiScale)));
        map.put(TEXT_CALIBRATION, Arrays.asList(String.valueOf(this.calMax), String.valueOf(this.calMin)));
        map.put(TEXT_COMPRESSED, Arrays.asList(String.valueOf(this.compressed)));
        map.put(TEXT_VERIFIED, Arrays.asList(String.valueOf(this.verified)));
        map.put(TEXT_GLOBAL_RANGE, Arrays.asList(String.valueOf(this.globalMax), String.valueOf(this.globalMin)));
        try {
            map.put(TEXT_DESCRIPTION, Arrays.asList(new String(this.description, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_AUXILIARY_FILE, Arrays.asList(new String(this.auxFile, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put(TEXT_ORIENT, Arrays.asList(String.valueOf(this.orient)));
        map.put(TEXT_ORIGIN, Arrays.asList(String.valueOf(this.originX), String.valueOf(this.originY), String.valueOf(this.originZ)));
        try {
            map.put(TEXT_GENERATED, Arrays.asList(new String(this.generated, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_SCAN_NUM, Arrays.asList(new String(this.scanNum, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_PATIENT_ID, Arrays.asList(new String(this.patientID, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_EXPERIMENT_TIME, Arrays.asList(new String(this.expDate, CHARACTER_ENCODING).trim(), new String(this.expTime, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put(TEXT_VIEWS, Arrays.asList(String.valueOf(this.views)));
        map.put(TEXT_VOLS_ADDED, Arrays.asList(String.valueOf(this.volsAdded)));
        map.put(TEXT_START_FIELD, Arrays.asList(String.valueOf(this.startField)));
        map.put(TEXT_FIELD_SKIP, Arrays.asList(String.valueOf(this.fieldSkip)));
        map.put(TEXT_ORIGINAL, Arrays.asList(String.valueOf(this.omax), String.valueOf(this.omin)));
        map.put(TEXT_SCALED, Arrays.asList(String.valueOf(this.smax), String.valueOf(this.smin)));
        return map;
    }

    public Map<String, List<EditableHeader.CodeOption>> getHumanReadableFieldOptions() {
        LinkedHashMap<String, List<EditableHeader.CodeOption>> map = new LinkedHashMap<String, List<EditableHeader.CodeOption>>();
        ArrayList<EditableHeader.CodeOption> dataTypeOptions = new ArrayList<EditableHeader.CodeOption>();
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Binary"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Unsigned 8-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "Signed 16-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(8), "Signed 32-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(16), "Float 32-bit"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(32), "Complex"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(64), "Float 64-bit"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(128), "RGB"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(255), "All"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), "Unknown"));
        Collections.sort(dataTypeOptions);
        map.put(TEXT_DATATYPE, dataTypeOptions);
        ArrayList<EditableHeader.CodeOption> orientationOptions = new ArrayList<EditableHeader.CodeOption>();
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(0), "Transverse Unflipped [XYZ+++]"));
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Coronal Unflipped [XZY+++]"));
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Sagittal Unflipped [YZX+++]"));
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Transverse Flipped [XYZ+-+]"));
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "Coronal Flipped [XZY+-+]"));
        orientationOptions.add(new EditableHeader.CodeOption(String.valueOf(5), "Sagittal Flipped [YZX+-+]"));
        Collections.sort(orientationOptions);
        map.put(TEXT_ORIENT, orientationOptions);
        return map;
    }

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        ImageDescription imageDescription = new ImageDescription(new String(StringUtilities.convertToPrintableASCII((byte[])this.scanNum)), new String(StringUtilities.convertToPrintableASCII((byte[])this.patientID)), new String(StringUtilities.convertToPrintableASCII((byte[])this.expTime)), new String(StringUtilities.convertToPrintableASCII((byte[])this.expDate)), new String(StringUtilities.convertToPrintableASCII((byte[])this.description)));
        imageDescription.setFile(this.headerFile);
        return imageDescription;
    }

    public String getImageDescriptionString() {
        return new String(StringUtilities.convertToPrintableASCII((byte[])this.description));
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions imageDimensions = new ImageDimensions((int)this.dim[1], (int)this.dim[2], (int)this.dim[3], (int)this.dim[4]);
        imageDimensions.setImageOffset((int)this.voxOffset);
        return imageDimensions;
    }

    public URI getImageFile() {
        return this.makeImageURI(this.headerFile);
    }

    public ImageIntent getImageIntent() {
        return new ImageIntent();
    }

    public ImageRange getImageRange() {
        float scale = 1.0f;
        if (this.roiScale != 0.0f) {
            scale = this.roiScale;
        }
        ImageRange imageRange = new ImageRange((double)((float)this.globalMin * scale), (double)((float)this.globalMax * scale), (double)this.calMin, (double)this.calMax);
        short numSlices = this.dim[3];
        short numPoints = this.dim[4];
        if (numSlices == 0) {
            numSlices = 1;
        }
        if (numPoints == 0) {
            numPoints = 1;
        }
        imageRange.setGlobalDataScaleSlope(numSlices * numPoints, scale);
        imageRange.setGlobalDataScaleIntercept(numSlices * numPoints, 0.0f);
        return imageRange;
    }

    public ImageType getImageType() {
        return new ImageType(this.getNumBytesPerVoxel(), this.getByteTypeValue(), this.getNumBytesPerVoxel() * 8, this.littleEndian);
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getOrientation() {
        return this.getOrientation(false);
    }

    public int getOrientationCertainty() {
        int orientationCertainty = 0;
        if (this.orient >= 0 && this.orient < 6 && Orientation.isValidOrientationString(this.getOrientation(true)) && (this.orient != 0 || !this.getOrientation(true).equals(Orientation.getDefaultOrientation("AVW")))) {
            ++orientationCertainty;
        }
        if (this.originX != 0 && this.originY != 0 && this.originZ != 0) {
            ++orientationCertainty;
        }
        return orientationCertainty;
    }

    public Coordinate getOrigin() {
        Coordinate origin = new Coordinate((double)this.originX, (double)this.originY, (double)this.originZ);
        if (!origin.isAllZeros()) {
            origin.setValuesRound((double)(this.originX - 1), (double)(this.originY - 1), (double)(this.originZ - 1));
        }
        return origin;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return ".hdr";
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public int[] getSupportedBytesForType(int type) {
        if (type == 2) {
            return new int[]{2, 4};
        }
        if (type == 3) {
            return new int[]{1};
        }
        if (type == 4) {
            return new int[]{4};
        }
        return null;
    }

    public String[] getSupportedOrientations() {
        return CollectionUtilities.array(VALID_ORIENTATIONS);
    }

    public int[] getSupportedTypesForBytes(int bytes) {
        if (bytes == 1) {
            return new int[]{3};
        }
        if (bytes == 2) {
            return new int[]{2};
        }
        if (bytes == 4) {
            return new int[]{2, 4};
        }
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions voxelDimensions = new VoxelDimensions((double)this.getPixDim(1), (double)this.getPixDim(2), (double)this.getPixDim(3), (double)this.getPixDim(4));
        if (new String(this.voxUnits).indexOf(SPATIAL_UNITS_MM_STRING) != -1) {
            voxelDimensions.setSpatialUnit(2);
        } else if (new String(this.voxUnits).indexOf(SPATIAL_UNITS_METER_STRING) != -1) {
            voxelDimensions.setSpatialUnit(1);
        } else if (new String(this.voxUnits).indexOf(SPATIAL_UNITS_MICRON_STRING) != -1) {
            voxelDimensions.setSpatialUnit(3);
        } else {
            voxelDimensions.setSpatialUnit(0);
        }
        voxelDimensions.setTemporalUnit(0);
        return voxelDimensions;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isSupportedBigEndian() {
        return true;
    }

    public boolean isSupportedDataScaleIntercept() {
        return false;
    }

    public boolean isSupportedDataScaleSlope() {
        return true;
    }

    public boolean isSupportedLittleEndian() {
        return true;
    }

    public boolean isSupportedMultipleDataScales() {
        return false;
    }

    public boolean isTextEditableHeader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        boolean success = false;
        boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
        boolean isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)file);
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        byte[] byteArray = new byte[348];
        try {
            fileIn = FileUtilities.getInputStream((URI)file.toURI(), (boolean)isGZIPFile);
            FileUtilities.readFully((InputStream)fileIn, (byte[])byteArray);
            byteBuffer = ByteBuffer.wrap(byteArray);
            if (byteBuffer.getInt(0) == 348 || ByteUtilities.swap((int)byteBuffer.getInt(0)) == 348) {
                byte[] magic = new byte[4];
                for (int ctr = 0; ctr < magic.length; ++ctr) {
                    magic[ctr] = byteBuffer.get(344 + ctr);
                }
                success = !Arrays.equals(magic, NIFTI.getMagicNumber1()) && !Arrays.equals(magic, NIFTI.getMagicNumber2());
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return success;
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.readHeader(file.toURI(), tempDir);
    }

    public void readHeader(URI file, File tempDir) throws InvalidHeaderException {
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        this.headerFile = file;
        try {
            int ctr;
            int bytesRead;
            boolean isGZIPFile;
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
            this.isCompressedFile = isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)new File(file));
            fileIn = FileUtilities.getInputStream((URI)file, (boolean)this.isCompressedFile);
            byte[] byteArray = new byte[348];
            for (int totalBytesRead = bytesRead = fileIn.read(byteArray); totalBytesRead < 348; totalBytesRead += bytesRead) {
                bytesRead = fileIn.read(byteArray, totalBytesRead, 348 - totalBytesRead);
            }
            byteBuffer = ByteBuffer.wrap(byteArray);
            if (byteBuffer.getInt(0) == 348) {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else if (ByteUtilities.swap((int)byteBuffer.getInt(0)) == 348) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                throw new InvalidHeaderException("Does not appear to be a valid AVW file: Size field does not equal 348.");
            }
            this.littleEndian = byteBuffer.order().toString().equals(ByteOrder.LITTLE_ENDIAN.toString());
            this.dim[0] = byteBuffer.getShort(40);
            this.dim[1] = byteBuffer.getShort(42);
            this.dim[2] = byteBuffer.getShort(44);
            this.dim[3] = byteBuffer.getShort(46);
            this.dim[4] = byteBuffer.getShort(48);
            this.dim[5] = byteBuffer.getShort(50);
            this.dim[6] = byteBuffer.getShort(52);
            this.dim[7] = byteBuffer.getShort(54);
            this.voxUnits = new byte[4];
            this.voxUnits[0] = byteBuffer.get(56);
            this.voxUnits[1] = byteBuffer.get(57);
            this.voxUnits[2] = byteBuffer.get(58);
            this.voxUnits[3] = byteBuffer.get(59);
            this.calUnits = new byte[8];
            this.calUnits[0] = byteBuffer.get(60);
            this.calUnits[1] = byteBuffer.get(61);
            this.calUnits[2] = byteBuffer.get(62);
            this.calUnits[3] = byteBuffer.get(63);
            this.calUnits[4] = byteBuffer.get(64);
            this.calUnits[5] = byteBuffer.get(65);
            this.calUnits[6] = byteBuffer.get(66);
            this.calUnits[7] = byteBuffer.get(67);
            this.dataType = byteBuffer.getShort(70);
            this.bitPix = byteBuffer.getShort(72);
            this.pixDim[0] = byteBuffer.getFloat(76);
            this.pixDim[1] = byteBuffer.getFloat(80);
            this.pixDim[2] = byteBuffer.getFloat(84);
            this.pixDim[3] = byteBuffer.getFloat(88);
            this.pixDim[4] = byteBuffer.getFloat(92);
            this.pixDim[5] = byteBuffer.getFloat(96);
            this.pixDim[6] = byteBuffer.getFloat(100);
            this.pixDim[7] = byteBuffer.getFloat(104);
            this.voxOffset = byteBuffer.getFloat(108);
            this.roiScale = byteBuffer.getFloat(112);
            this.calMax = byteBuffer.getFloat(124);
            this.calMin = byteBuffer.getFloat(128);
            this.compressed = byteBuffer.getInt(132);
            this.verified = byteBuffer.getInt(136);
            this.globalMax = byteBuffer.getInt(140);
            this.globalMin = byteBuffer.getInt(144);
            this.description = new byte[80];
            for (ctr = 0; ctr < 80; ++ctr) {
                this.description[ctr] = byteBuffer.get(148 + ctr);
            }
            this.auxFile = new byte[24];
            for (ctr = 0; ctr < 24; ++ctr) {
                this.auxFile[ctr] = byteBuffer.get(228 + ctr);
            }
            this.orient = byteBuffer.get(252);
            this.originX = byteBuffer.getShort(253);
            this.originY = byteBuffer.getShort(255);
            this.originZ = byteBuffer.getShort(257);
            this.generated = new byte[10];
            for (ctr = 0; ctr < 10; ++ctr) {
                this.generated[ctr] = byteBuffer.get(263 + ctr);
            }
            this.scanNum = new byte[10];
            for (ctr = 0; ctr < 10; ++ctr) {
                this.scanNum[ctr] = byteBuffer.get(273 + ctr);
            }
            this.patientID = new byte[10];
            for (ctr = 0; ctr < 10; ++ctr) {
                this.patientID[ctr] = byteBuffer.get(283 + ctr);
            }
            this.expDate = new byte[10];
            for (ctr = 0; ctr < 10; ++ctr) {
                this.expDate[ctr] = byteBuffer.get(293 + ctr);
            }
            this.expTime = new byte[10];
            for (ctr = 0; ctr < 10; ++ctr) {
                this.expTime[ctr] = byteBuffer.get(303 + ctr);
            }
            this.views = byteBuffer.getInt(316);
            this.volsAdded = byteBuffer.getInt(320);
            this.startField = byteBuffer.getInt(324);
            this.fieldSkip = byteBuffer.getInt(328);
            this.omax = byteBuffer.getInt(332);
            this.omin = byteBuffer.getInt(336);
            this.smax = byteBuffer.getInt(340);
            this.smin = byteBuffer.getInt(344);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public void setEditableFieldValue(String name, String value, int index) {
        if (name.equals(TEXT_IMAGE_DIMENSIONS)) {
            this.dim[index] = (short)Integer.parseInt(value);
        } else if (name.equals(TEXT_VOX_UNITS)) {
            try {
                this.voxUnits = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_CAL_UNITS)) {
            try {
                this.calUnits = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_DATATYPE)) {
            this.dataType = (short)Integer.parseInt(value);
        } else if (name.equals(TEXT_BITS_PER_VOXEL)) {
            this.bitPix = (short)Integer.parseInt(value);
        } else if (name.equals(TEXT_VOXEL_DIMENSIONS)) {
            this.pixDim[index] = (float)Double.parseDouble(value);
        } else if (name.equals(TEXT_IMAGE_OFFSET)) {
            this.voxOffset = Integer.parseInt(value);
        } else if (name.equals(TEXT_ROI_SCALE)) {
            this.roiScale = (float)Double.parseDouble(value);
        } else if (name.equals(TEXT_CALIBRATION)) {
            if (index == 0) {
                this.calMax = (float)Double.parseDouble(value);
            } else {
                this.calMin = (float)Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_COMPRESSED)) {
            this.compressed = Integer.parseInt(value);
        } else if (name.equals(TEXT_VERIFIED)) {
            this.verified = Integer.parseInt(value);
        } else if (name.equals(TEXT_GLOBAL_RANGE)) {
            if (index == 0) {
                this.globalMax = Integer.parseInt(value);
            } else {
                this.globalMin = Integer.parseInt(value);
            }
        } else if (name.equals(TEXT_DESCRIPTION)) {
            try {
                this.description = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_AUXILIARY_FILE)) {
            try {
                this.auxFile = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_ORIENT)) {
            this.orient = (byte)Integer.parseInt(value);
        } else if (name.equals(TEXT_ORIGIN)) {
            if (index == 0) {
                this.originX = (short)Integer.parseInt(value);
            } else if (index == 1) {
                this.originY = (short)Integer.parseInt(value);
            } else if (index == 2) {
                this.originZ = (short)Integer.parseInt(value);
            }
        } else if (name.equals(TEXT_GENERATED)) {
            try {
                this.generated = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_SCAN_NUM)) {
            try {
                this.scanNum = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_PATIENT_ID)) {
            try {
                this.patientID = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_EXPERIMENT_TIME)) {
            try {
                this.expDate = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_VIEWS)) {
            this.views = Integer.parseInt(value);
        } else if (name.equals(TEXT_VOLS_ADDED)) {
            this.volsAdded = Integer.parseInt(value);
        } else if (name.equals(TEXT_START_FIELD)) {
            this.startField = Integer.parseInt(value);
        } else if (name.equals(TEXT_FIELD_SKIP)) {
            this.fieldSkip = Integer.parseInt(value);
        } else if (name.equals(TEXT_ORIGINAL)) {
            if (index == 0) {
                this.omax = Integer.parseInt(value);
            } else {
                this.omin = Integer.parseInt(value);
            }
        } else if (name.equals(TEXT_SCALED)) {
            if (index == 0) {
                this.smax = Integer.parseInt(value);
            } else {
                this.smin = Integer.parseInt(value);
            }
        }
    }

    public String toString() {
        String string = "";
        DecimalFormat fmt = new DecimalFormat("0.0####");
        String NEWLINE = "\"\n";
        string = string + "Image Dimensions (1-8): " + this.dim[0] + ", " + this.dim[1] + ", " + this.dim[2] + ", " + this.dim[3] + ", " + this.dim[4] + ", " + this.dim[5] + ", " + this.dim[6] + ", " + this.dim[7] + "\n";
        string = string + "Voxel Units: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.voxUnits)) + "\"    " + "Display Units: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.calUnits)) + "\"\n";
        string = string + "Datatype = " + this.dataType + "\n";
        string = string + "Bits Per Voxel = " + this.bitPix + "\n";
        string = string + "Voxel Dimensions (1-8): " + fmt.format(this.pixDim[0]) + ", " + fmt.format(this.pixDim[1]) + ", " + fmt.format(this.pixDim[2]) + ", " + fmt.format(this.pixDim[3]) + ", " + fmt.format(this.pixDim[4]) + ", " + fmt.format(this.pixDim[5]) + ", " + fmt.format(this.pixDim[6]) + ", " + fmt.format(this.pixDim[7]) + "\n";
        string = string + "Image Offset = " + this.voxOffset + "\n";
        string = string + "Scale = " + fmt.format(this.roiScale) + "\n";
        string = string + "Calibrated Range:  Max = " + this.calMax + "  Min = " + this.calMin + "\n";
        string = string + "Compressed = " + this.compressed + "    Verified = " + this.verified + "\n";
        string = string + "Global Range:  Max = " + this.globalMax + "  Min = " + this.globalMin + "\n";
        string = string + "Description: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.description)) + "\"\n";
        string = string + "Auxiliary File: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.auxFile)) + "\"\n";
        string = string + "Orientation = " + this.orient + "\n";
        string = string + "Origin: (" + this.originX + ", " + this.originY + ", " + this.originZ + ")\n";
        string = string + "Generated: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.generated)) + "\"\n";
        string = string + "Scan Number: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.scanNum)) + "\"\n";
        string = string + "Patient ID: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.patientID)) + "\"\n";
        string = string + "Experiment Date: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.expDate)) + "\"\n";
        string = string + "Experiment Time: \"" + new String(StringUtilities.convertToPrintableASCII((byte[])this.expTime)) + "\"\n";
        string = string + "Views = " + this.views + "\n";
        string = string + "Volumes Added = " + this.volsAdded + "\n";
        string = string + "Start Field = " + this.startField + "\n";
        string = string + "Field Skip = " + this.fieldSkip + "\n";
        string = string + "Original Max = " + this.omax + "    Original Min = " + this.omin + "\n";
        string = string + "Scaled Max = " + this.smax + "    Scaled Min = " + this.smin + "\n\n";
        return string;
    }

    public boolean willWriteImage() {
        return false;
    }

    public void writeHeader() {
        try {
            this.writeHeader(null, null, null, null, null, this.isCompressedFile, null, null, null, new File(this.headerFile), null, null, null);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public byte[] writeHeader(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) throws IOException, VolumeIOException {
        if (id != null) {
            this.updateDims4D((short)id.getCols(), (short)id.getRows(), (short)id.getSlices(), (short)id.getTimepoints());
            this.voxOffset = id.getImageOffset();
        }
        if (vd != null) {
            this.updatePixDims4D((float)vd.getColSize(true), (float)vd.getRowSize(true), (float)vd.getSliceThickness(true), (float)vd.getTR());
            this.updateVoxUnits(vd.getSpatialUnit());
        }
        if (it != null) {
            this.updateDataType(it.getNumBytesPerVoxel(), ImageType.getByteTypeString((int)it.getByteType()), it.isLittleEndian());
        }
        if (ir != null) {
            this.updateDisplayRange((float)ir.getDisplayMax(), (float)ir.getDisplayMin());
            this.updateMaxMin((int)ir.getImageMax(), (int)ir.getImageMin());
            this.roiScale = ir.hasGlobalDataScaleSlope() ? ir.getDataScaleSlopes()[0] : 1.0f;
            if (ir.hasGlobalDataScaleIntercept() && ir.getDataScaleIntercepts()[0] != 0.0f) {
                AppLogger.warn((String)"AVW writer does not support data scale intercept!");
            }
        }
        if (orientation != null) {
            this.updateOrientation(orientation);
        }
        if (origin != null) {
            this.updateOrigin((short)origin.xDbl, (short)origin.yDbl, (short)origin.zDbl);
        }
        if (des != null) {
            this.description = des.getDescription().getBytes(CHARACTER_ENCODING);
            this.patientID = des.getName().getBytes(CHARACTER_ENCODING);
            this.scanNum = des.getID().getBytes(CHARACTER_ENCODING);
            this.expDate = des.getStudyDateString().getBytes(CHARACTER_ENCODING);
            this.expTime = des.getStudyTimeString().getBytes(CHARACTER_ENCODING);
        }
        this.isCompressedFile = compress;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[348]);
        if (this.littleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.putInt(348);
        byteBuffer.put(EMPTY, 0, 10);
        byteBuffer.put(EMPTY, 0, 18);
        byteBuffer.putInt(16384);
        byteBuffer.putShort((short)0);
        byteBuffer.put((byte)114);
        byteBuffer.put((byte)0);
        byteBuffer.putShort(this.dim[0]);
        byteBuffer.putShort(this.dim[1]);
        byteBuffer.putShort(this.dim[2]);
        byteBuffer.putShort(this.dim[3]);
        byteBuffer.putShort(this.dim[4]);
        byteBuffer.putShort(this.dim[5]);
        byteBuffer.putShort(this.dim[6]);
        byteBuffer.putShort(this.dim[7]);
        if (this.voxUnits == null) {
            this.voxUnits = new byte[4];
        }
        byteBuffer.put(this.voxUnits, 0, 4);
        if (this.calUnits == null) {
            this.calUnits = new byte[8];
        }
        byteBuffer.put(this.calUnits, 0, 8);
        byteBuffer.put(EMPTY, 0, 2);
        byteBuffer.putShort(this.dataType);
        byteBuffer.putShort(this.bitPix);
        byteBuffer.put(EMPTY, 0, 2);
        byteBuffer.putFloat(this.pixDim[0]);
        byteBuffer.putFloat(this.pixDim[1]);
        byteBuffer.putFloat(this.pixDim[2]);
        byteBuffer.putFloat(this.pixDim[3]);
        byteBuffer.putFloat(this.pixDim[4]);
        byteBuffer.putFloat(this.pixDim[5]);
        byteBuffer.putFloat(this.pixDim[6]);
        byteBuffer.putFloat(this.pixDim[7]);
        byteBuffer.putFloat(this.voxOffset);
        byteBuffer.putFloat(this.roiScale);
        byteBuffer.put(EMPTY, 0, 4);
        byteBuffer.put(EMPTY, 0, 4);
        byteBuffer.putFloat(this.calMax);
        byteBuffer.putFloat(this.calMin);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(this.globalMax);
        byteBuffer.putInt(this.globalMin);
        if (this.description == null || this.description.length == 0) {
            this.description = new byte[80];
        }
        if (this.description.length < 80) {
            byteBuffer.put(this.description, 0, this.description.length);
            byteBuffer.put(EMPTY, 0, 80 - this.description.length);
        } else {
            byteBuffer.put(this.description, 0, 80);
        }
        if (this.auxFile == null || this.auxFile.length == 0) {
            this.auxFile = new byte[24];
        }
        if (this.auxFile.length < 24) {
            byteBuffer.put(this.auxFile, 0, this.auxFile.length);
            byteBuffer.put(EMPTY, 0, 24 - this.auxFile.length);
        } else {
            byteBuffer.put(this.auxFile, 0, 24);
        }
        byteBuffer.put(this.orient);
        byteBuffer.putShort(this.originX);
        byteBuffer.putShort(this.originY);
        byteBuffer.putShort(this.originZ);
        byteBuffer.put(EMPTY, 0, 4);
        if (this.generated == null || this.generated.length == 0) {
            this.generated = new byte[10];
        }
        if (this.generated.length < 10) {
            byteBuffer.put(this.generated, 0, this.generated.length);
            byteBuffer.put(EMPTY, 0, 10 - this.generated.length);
        } else {
            byteBuffer.put(this.generated, 0, 10);
        }
        if (this.scanNum == null || this.scanNum.length == 0) {
            this.scanNum = new byte[10];
        }
        if (this.scanNum.length < 10) {
            byteBuffer.put(this.scanNum, 0, this.scanNum.length);
            byteBuffer.put(EMPTY, 0, 10 - this.scanNum.length);
        } else {
            byteBuffer.put(this.scanNum, 0, 10);
        }
        if (this.patientID == null || this.patientID.length == 0) {
            this.patientID = new byte[10];
        }
        if (this.patientID.length < 10) {
            byteBuffer.put(this.patientID, 0, this.patientID.length);
            byteBuffer.put(EMPTY, 0, 10 - this.patientID.length);
        } else {
            byteBuffer.put(this.patientID, 0, 10);
        }
        if (this.expDate == null || this.expDate.length == 0) {
            this.expDate = new byte[10];
        }
        if (this.expDate.length < 10) {
            byteBuffer.put(this.expDate, 0, this.expDate.length);
            byteBuffer.put(EMPTY, 0, 10 - this.expDate.length);
        } else {
            byteBuffer.put(this.expDate, 0, 10);
        }
        if (this.expTime == null || this.expTime.length == 0) {
            this.expTime = new byte[10];
        }
        if (this.expTime.length < 10) {
            byteBuffer.put(this.expTime, 0, this.expTime.length);
            byteBuffer.put(EMPTY, 0, 10 - this.expTime.length);
        } else {
            byteBuffer.put(this.expTime, 0, 10);
        }
        byteBuffer.put(EMPTY, 0, 3);
        byteBuffer.putInt(this.views);
        byteBuffer.putInt(this.volsAdded);
        byteBuffer.putInt(this.startField);
        byteBuffer.putInt(this.fieldSkip);
        byteBuffer.putInt(this.omax);
        byteBuffer.putInt(this.omin);
        byteBuffer.putInt(this.smax);
        byteBuffer.putInt(this.smin);
        FilterOutputStream fileOut = null;
        try {
            File writeFile = headerFile;
            if (this.isCompressedFile) {
                if (!CompressionUtilities.usesGZIPFileExtension((File)writeFile)) {
                    writeFile = new File(writeFile.getParent(), writeFile.getName() + ".gz");
                }
                fileOut = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(writeFile)));
            } else {
                fileOut = new BufferedOutputStream(new FileOutputStream(writeFile));
            }
            this.headerFile = writeFile.toURI();
            fileOut.write(byteBuffer.array());
        }
        catch (FileNotFoundException ex) {
            throw new VolumeIOException((Exception)ex);
        }
        catch (IOException ex) {
            throw new VolumeIOException((Exception)ex);
        }
        finally {
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return CollectionUtilities.EMPTY_BYTE_ARRAY;
    }

    public byte[][] writeSeriesHeaders(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) {
        return new byte[0][0];
    }

    private int getByteTypeValue() {
        if (this.dataType == 1) {
            return 1;
        }
        if (this.dataType == 2) {
            return 3;
        }
        if (this.dataType == 4) {
            return 2;
        }
        if (this.dataType == 8) {
            return 2;
        }
        if (this.dataType == 16) {
            return 4;
        }
        if (this.dataType == 32) {
            return 5;
        }
        if (this.dataType == 64) {
            return 4;
        }
        if (this.dataType == 128) {
            return 6;
        }
        if (this.globalMax == 127 + Math.abs(-128) && this.globalMin == 0) {
            return 3;
        }
        if (this.globalMax == 127 && this.globalMin == -128) {
            return 2;
        }
        if (this.globalMax == Short.MAX_VALUE + Math.abs(Short.MIN_VALUE) && this.globalMin == 0) {
            return 3;
        }
        if (this.globalMax == Short.MAX_VALUE && this.globalMin == Short.MIN_VALUE) {
            return 2;
        }
        if (this.globalMax == Integer.MAX_VALUE + Math.abs(Integer.MIN_VALUE) && this.globalMin == 0) {
            return 3;
        }
        if (this.globalMax == Integer.MAX_VALUE && this.globalMin == Integer.MIN_VALUE) {
            return 2;
        }
        if (this.bitPix == 32) {
            return 4;
        }
        return 0;
    }

    private int getNumBytesPerVoxel() {
        if (this.dataType == 2) {
            return 1;
        }
        if (this.dataType == 4) {
            return 2;
        }
        if (this.dataType == 8) {
            return 4;
        }
        if (this.dataType == 16) {
            return 4;
        }
        if (this.dataType == 32) {
            return 8;
        }
        if (this.dataType == 64) {
            return 8;
        }
        if (this.dataType == 128) {
            return 3;
        }
        return this.bitPix / 8;
    }

    private String getOrientation(boolean useNegVox) {
        String anOrientation = null;
        if (this.orient == 0) {
            anOrientation = "XYZ+++";
        } else if (this.orient == 1) {
            anOrientation = "XZY+++";
        } else if (this.orient == 2) {
            anOrientation = "YZX+++";
        } else if (this.orient == 3) {
            anOrientation = "XYZ+-+";
        } else if (this.orient == 4) {
            anOrientation = "XZY+-+";
        } else if (this.orient == 5) {
            anOrientation = "YZX+-+";
        } else {
            return null;
        }
        if (useNegVox) {
            char[] charArray = anOrientation.toCharArray();
            if (this.pixDim[1] < 0.0f) {
                charArray[3] = charArray[3] == '-' ? 43 : 45;
            }
            if (this.pixDim[2] < 0.0f) {
                charArray[4] = charArray[4] == '-' ? 43 : 45;
            }
            if (this.pixDim[3] < 0.0f) {
                charArray[5] = charArray[5] == '-' ? 43 : 45;
            }
            anOrientation = new String(charArray);
        }
        return anOrientation;
    }

    private float getPixDim(int index) {
        return this.pixDim[index];
    }

    private URI makeImageURI(URI headerURI) {
        URI imageURI = null;
        try {
            String scheme = headerURI.getScheme();
            String userInfo = headerURI.getUserInfo();
            String host = headerURI.getHost();
            int port = headerURI.getPort();
            String path = headerURI.getPath();
            String name = FileUtilities.getName((URI)headerURI);
            imageURI = this.isCompressedFile ? new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(".hdr.gz")) + ".img.gz", null, null) : (name.indexOf(46) == -1 ? new URI(scheme, userInfo, host, port, path + ".img", null, null) : new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(46)) + ".img", null, null));
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
        return imageURI;
    }

    private void updateDataType(int numBytesPerVoxel, String byteType, boolean bool) {
        this.dataType = numBytesPerVoxel == 1 && byteType.equals(ImageType.getByteTypeString((int)3)) ? (short)2 : (numBytesPerVoxel == 2 && byteType.equals(ImageType.getByteTypeString((int)2)) ? (short)4 : (numBytesPerVoxel == 4 && byteType.equals(ImageType.getByteTypeString((int)2)) ? (short)8 : (numBytesPerVoxel == 4 && byteType.equals(ImageType.getByteTypeString((int)4)) ? (short)16 : (numBytesPerVoxel == 8 && byteType.equals(ImageType.getByteTypeString((int)4)) ? (short)64 : (short)0))));
        this.bitPix = (short)(numBytesPerVoxel * 8);
        this.littleEndian = bool;
    }

    private void updateDims4D(short dim1, short dim2, short dim3, short dim4) {
        this.dim[0] = 4;
        this.dim[1] = dim1;
        this.dim[2] = dim2;
        this.dim[3] = dim3;
        this.dim[4] = dim4;
    }

    private void updateDisplayRange(float aMax, float aMin) {
        this.calMin = aMin;
        this.calMax = aMax;
    }

    private void updateMaxMin(int aMax, int aMin) {
        this.globalMin = aMin;
        this.globalMax = aMax;
    }

    private void updateOrientation(String orientation) {
        String orientationString = AVW.validateOrientation(orientation);
        this.orient = (byte)Orientation.convertNEMAtoAVW(orientationString);
        for (int ctr = 0; ctr < this.pixDim.length; ++ctr) {
            this.pixDim[ctr] = Math.abs(this.pixDim[ctr]);
        }
    }

    private void updateOrigin(short val1, short val2, short val3) {
        this.originX = (short)(val1 + 1);
        this.originY = (short)(val2 + 1);
        this.originZ = (short)(val3 + 1);
    }

    private void updatePixDims4D(float dim1, float dim2, float dim3, float dim4) {
        this.pixDim[1] = dim1;
        this.pixDim[2] = dim2;
        this.pixDim[3] = dim3;
        this.pixDim[4] = dim4;
    }

    private void updateVoxUnits(int val) {
        if (val == 2) {
            this.voxUnits = "mm  ".getBytes();
        } else if (val == 1) {
            this.voxUnits = "met ".getBytes();
        } else if (val == 3) {
            this.voxUnits = "mic ".getBytes();
        }
    }
}

