/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.afni;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.afni.Attribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class AFNI
implements ReadableHeader {
    private URI headerURI;
    private boolean compressed;
    private final Map<String, Attribute> attributeMap = new TreeMap<String, Attribute>();
    private final Vector<Attribute> allAttributes = new Vector();
    public static final List<Integer> AFNI_DATATYPES = CollectionUtilities.immutable((Integer[])new Integer[]{3, 3, 2, 4});
    public static final List<Integer> AFNI_DATATYPES_BYTES = CollectionUtilities.immutable((Integer[])new Integer[]{1, 2, 4, 4});
    public static final String AFNI_BIG_ENDIAN = "LSB_FIRST";
    public static final String AFNI_HEADER_EXT = ".HEAD";
    public static final String AFNI_IMAGE_EXT = ".BRIK";
    public static final String AFNI_LITTLE_ENDIAN = "MSB_FIRST";
    public static final String BYTE_ORDER_ID = "BYTEORDER_STRING";
    public static final String CODE_ID = "IDCODE_STRINolG";
    public static final String DATATYPE_ID = "BRICK_TYPES";
    public static final String DATA_SCALE_ID = "BRICK_FLOAT_FACS";
    public static final String DATE_ID = "IDCODE_DATE";
    public static final String HEADER_EXT = ".HEAD";
    public static final String IMAGE_DIMS_ID = "DATASET_DIMENSIONS";
    public static final String IMAGE_EXT = ".BRIK";
    public static final String IMAGE_TIMEPOINTS_ID = "TAXIS_NUMS";
    public static final String LINE_COUNT_ID = "count =";
    public static final String LINE_NAME_ID = "name =";
    public static final String LINE_TYPE_ID = "type =";
    public static final String MIN_MANGO_SUPPORTED = "3.1";
    public static final String NAME = "AFNI";
    public static final String ORIENTATION_ID = "ORIENT_SPECIFIC";
    public static final String ORIGIN_ID = "ORIGIN";
    public static final String PLUGIN_URL = "http://rii.uthscsa.edu/mango/plugin_afni.html";
    public static final String RANGE_ID = "BRICK_STATS";
    public static final String RANK_ID = "DATASET_RANK";
    public static final String SCENE_DATA_ID = "SCENE_DATA";
    public static final String TR_ID = "TAXIS_FLOATS";
    public static final String TYPESTRING_DEFAULT = "3DIM_HEAD_ANAT";
    public static final String TYPESTRING_ID = "TYPESTRING";
    public static final String VERSION = "1.0.1";
    public static final String VOXEL_DIMS_ID = "DELTA";
    public static final int AFNI_DEFAULT_DATATYPE = 1;
    public static final int AFNI_TIME_AXIS_MSEC = 77001;
    public static final int AFNI_TIME_AXIS_SEC = 77002;
    public static final int ORI_A2P_TYPE = 3;
    public static final int ORI_I2S_TYPE = 4;
    public static final int ORI_L2R_TYPE = 1;
    public static final int ORI_P2A_TYPE = 2;
    public static final int ORI_R2L_TYPE = 0;
    public static final int ORI_S2I_TYPE = 5;

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        String id = "";
        Attribute idAtt = this.attributeMap.get(CODE_ID);
        if (idAtt != null) {
            id = idAtt.getData().toString();
        }
        String date = "";
        Attribute dateAtt = this.attributeMap.get(DATE_ID);
        if (dateAtt != null) {
            date = dateAtt.getData().toString();
        }
        ImageDescription des = new ImageDescription(id, "", "", date, "");
        des.setFile(this.headerURI);
        return des;
    }

    public ImageDimensions getImageDimensions() {
        Attribute dimsAtt = this.attributeMap.get(IMAGE_DIMS_ID);
        int[] dims = (int[])dimsAtt.getData();
        int timepoints = 1;
        Attribute timepointsAtt = this.attributeMap.get(IMAGE_TIMEPOINTS_ID);
        if (timepointsAtt != null) {
            timepoints = ((int[])timepointsAtt.getData())[0];
        }
        return new ImageDimensions(dims[0], dims[1], dims[2], timepoints);
    }

    public URI getImageFile() {
        if (this.headerURI != null) {
            String scheme = this.headerURI.getScheme();
            String userInfo = this.headerURI.getUserInfo();
            String host = this.headerURI.getHost();
            int port = this.headerURI.getPort();
            String path = this.headerURI.getPath();
            String name = FileUtilities.getName((URI)this.headerURI);
            URI imageURI = null;
            try {
                imageURI = this.compressed ? new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(".HEAD.gz")) + ".BRIK.gz", null, null) : (name.indexOf(46) == -1 ? new URI(scheme, userInfo, host, port, path + ".BRIK", null, null) : new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(46)) + ".BRIK", null, null));
            }
            catch (URISyntaxException ex) {
                AppLogger.error((Throwable)ex);
            }
            return imageURI;
        }
        return null;
    }

    public ImageRange getImageRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        Attribute dimsAtt = this.attributeMap.get(RANGE_ID);
        if (dimsAtt != null) {
            double[] ranges = (double[])dimsAtt.getData();
            for (int ctr = 0; ctr < ranges.length; ctr += 2) {
                if (ranges[ctr] < min) {
                    min = ranges[ctr];
                }
                if (!(ranges[ctr + 1] > max)) continue;
                max = ranges[ctr];
            }
        } else {
            max = 0.0;
            min = 0.0;
        }
        ImageRange ir = new ImageRange(min, max, min, max);
        Attribute scaleAtt = this.attributeMap.get(DATA_SCALE_ID);
        ImageDimensions id = this.getImageDimensions();
        int slices = id.getSlices();
        int timepoints = id.getTimepoints();
        if (scaleAtt != null) {
            double[] scales = (double[])scaleAtt.getData();
            if (scales.length == timepoints) {
                float[] slopes = new float[slices * timepoints];
                float[] intercepts = new float[slices * timepoints];
                for (int ctrT = 0; ctrT < timepoints; ++ctrT) {
                    for (int ctrS = 0; ctrS < slices; ++ctrS) {
                        float scale = (float)scales[ctrT];
                        if (scale == 0.0f) {
                            scale = 1.0f;
                        }
                        slopes[ctrT * slices + ctrS] = scale;
                        intercepts[ctrT * slices + ctrS] = 0.0f;
                    }
                }
                ir.setDataScaleSlopes(slopes);
                ir.setDataScaleIntercepts(intercepts);
            } else {
                ir.setGlobalDataScaleIntercept(slices * timepoints, 0.0f);
                ir.setGlobalDataScaleSlope(slices * timepoints, 1.0f);
            }
        } else {
            ir.setGlobalDataScaleIntercept(slices * timepoints, 0.0f);
            ir.setGlobalDataScaleSlope(slices * timepoints, 1.0f);
        }
        return ir;
    }

    public ImageType getImageType() {
        int datatype = 1;
        Attribute datatypeAtt = this.attributeMap.get(DATATYPE_ID);
        if (datatypeAtt != null) {
            datatype = ((int[])datatypeAtt.getData())[0];
        }
        boolean littleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        Attribute orderAtt = this.attributeMap.get(BYTE_ORDER_ID);
        if (orderAtt != null) {
            littleEndian = orderAtt.getData().toString().equals(AFNI_LITTLE_ENDIAN);
        }
        return new ImageType(AFNI_DATATYPES_BYTES.get(datatype).intValue(), AFNI_DATATYPES.get(datatype).intValue(), AFNI_DATATYPES_BYTES.get(datatype) * 8, littleEndian);
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOrientation() {
        Attribute orientAtt = this.attributeMap.get(ORIENTATION_ID);
        StringBuffer orientation = new StringBuffer();
        if (orientAtt != null) {
            int[] orientCodes;
            for (int orientCode : orientCodes = (int[])orientAtt.getData()) {
                orientation.append(this.getOrientationOrder(orientCode));
            }
            for (int orientCode : orientCodes) {
                orientation.append(this.getOrientationSense(orientCode));
            }
        }
        return orientation.toString();
    }

    public int getOrientationCertainty() {
        if (this.attributeMap.get(ORIENTATION_ID) != null) {
            return 2;
        }
        return 0;
    }

    public Coordinate getOrigin() {
        Attribute orientAtt = this.attributeMap.get(ORIENTATION_ID);
        Attribute originAtt = this.attributeMap.get(ORIGIN_ID);
        Coordinate origin = new Coordinate();
        if (orientAtt != null && originAtt != null) {
            VoxelDimensions vd = this.getVoxelDimensions();
            int[] orientCodes = (int[])orientAtt.getData();
            double[] originCodes = (double[])originAtt.getData();
            double[] originVals = new double[3];
            originVals[this.getOrientationIndex((int)orientCodes[0])] = (int)Math.round(Math.abs(originCodes[0]) / vd.getColSize(true));
            originVals[this.getOrientationIndex((int)orientCodes[1])] = (int)Math.round(Math.abs(originCodes[1]) / vd.getRowSize(true));
            originVals[this.getOrientationIndex((int)orientCodes[2])] = (int)Math.round(Math.abs(originCodes[2]) / vd.getSliceThickness(true));
            origin.setValues(originVals[0], originVals[1], originVals[2]);
        }
        return origin;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        try {
            return new URL(PLUGIN_URL);
        }
        catch (MalformedURLException ex) {
            AppLogger.warn((Throwable)ex);
            return null;
        }
    }

    public String getPreferredFileExtension() {
        return ".HEAD";
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return VERSION;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = null;
        Attribute dimsAtt = this.attributeMap.get(VOXEL_DIMS_ID);
        if (dimsAtt != null) {
            double[] dims = (double[])dimsAtt.getData();
            double tr = 0.0;
            Attribute timeAxis = this.attributeMap.get(TR_ID);
            if (timeAxis != null) {
                tr = ((double[])timeAxis.getData())[1];
            }
            vd = new VoxelDimensions(Math.abs(dims[0]), Math.abs(dims[1]), Math.abs(dims[2]), Math.abs(tr));
            vd.setSpatialUnit(2);
            Attribute timepointsAtt = this.attributeMap.get(IMAGE_TIMEPOINTS_ID);
            if (timepointsAtt != null) {
                int timeUnit = ((int[])timepointsAtt.getData())[2];
                if (timeUnit == 77001) {
                    vd.setTemporalUnit(16);
                } else if (timeUnit == 77002) {
                    vd.setTemporalUnit(8);
                } else {
                    vd.setTemporalUnit(0);
                }
            }
        }
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isThisFormat(File file) {
        return file.toString().endsWith(".HEAD") || file.toString().endsWith(".HEAD.gz");
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.readHeader(file.toURI(), tempDir);
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.allAttributes.clear();
        this.attributeMap.clear();
        BufferedReader reader = null;
        this.headerURI = uri;
        try {
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)uri.toString());
            boolean isPossibleGZIPFile = FileUtilities.uriIsFile((URI)uri) && CompressionUtilities.isPossibleGZIPFile((File)new File(uri));
            this.compressed = usesGZIPExtension || isPossibleGZIPFile;
            reader = FileUtilities.getReader((URI)uri, (boolean)this.compressed);
            String name = null;
            String type = null;
            String count = null;
            String data = "";
            StringBuffer buf = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                if (this.isType(line, buf)) {
                    if (type != null) {
                        Attribute att = new Attribute(name, type, count, this.cleanString(data));
                        this.allAttributes.add(att);
                        this.attributeMap.put(name, att);
                        type = null;
                        count = null;
                        name = null;
                        data = "";
                    }
                    type = buf.toString();
                } else if (this.isName(line, buf)) {
                    name = buf.toString();
                } else if (this.isCount(line, buf)) {
                    count = buf.toString();
                } else if (name != null && type != null && count != null) {
                    data = data + line;
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new InvalidHeaderException("There was a problem reading that header: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AFNI (http://afni.nimh.nih.gov/afni)\n\n");
        Iterator<Attribute> it = this.allAttributes.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString() + "\n");
        }
        return sb.toString();
    }

    private String cleanString(String original) {
        String str = original.trim();
        str = str.replaceAll("\n", " ");
        str = str.replaceAll("\t", " ");
        str = str.replaceAll("( )+", " ");
        return str;
    }

    private int getOrientationIndex(int val) {
        if (val == 0 || val == 1) {
            return 0;
        }
        if (val == 2 || val == 3) {
            return 1;
        }
        if (val == 4 || val == 5) {
            return 2;
        }
        return -1;
    }

    private String getOrientationOrder(int val) {
        if (val == 0 || val == 1) {
            return "X";
        }
        if (val == 2 || val == 3) {
            return "Y";
        }
        if (val == 4 || val == 5) {
            return "Z";
        }
        return "";
    }

    private String getOrientationSense(int val) {
        if (val == 0) {
            return "-";
        }
        if (val == 1) {
            return "+";
        }
        if (val == 2) {
            return "+";
        }
        if (val == 3) {
            return "-";
        }
        if (val == 4) {
            return "+";
        }
        if (val == 5) {
            return "-";
        }
        return "";
    }

    private boolean isCount(String line, StringBuffer buf) {
        return this.lineIsOfKind(line, LINE_COUNT_ID, buf);
    }

    private boolean isName(String line, StringBuffer buf) {
        return this.lineIsOfKind(line, LINE_NAME_ID, buf);
    }

    private boolean isType(String line, StringBuffer buf) {
        return this.lineIsOfKind(line, LINE_TYPE_ID, buf);
    }

    private boolean lineIsOfKind(String originalLine, String kind, StringBuffer buf) {
        String line = this.cleanString(originalLine);
        if (line.startsWith(kind)) {
            int equalsIndex = line.indexOf(61);
            buf.replace(0, buf.length(), line.substring(equalsIndex + 1).trim());
            return true;
        }
        return false;
    }
}

