/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.Orientation;
import java.nio.ByteBuffer;

public class VoxelValue {
    private ByteBuffer tempBuffer;
    private ByteBuffer[] buffers;
    private Image image;
    private ImageDimensions imageDimensions;
    private boolean nativeDataType;
    private double[] timingRatios;
    private float variableTimingSize;
    private float[] cumulativeTimes;
    private float[] dataScaleIntercept;
    private float[] dataScaleSlope;
    private float[] volumeTimes;
    private int numTimepoints;
    private int numVoxelsVolume;
    private int sliceSizeBytes;
    private int typeNumBytes;
    private int volSize;
    private int volSizeBytes;
    private int xDim;
    private int xIncrement;
    private int xIncrementBytes;
    private int xMax;
    private int yDim;
    private int yIncrement;
    private int yIncrementBytes;
    private int yMax;
    private int zDim;
    private int zIncrement;
    private int zIncrementBytes;
    private int zMax;
    private final ImageRange imageRange;
    private final ImageType imageType;
    private final Orientation orientation;
    private final int[] timingIndices = new int[2];
    public static final int DEFAULT_NUM_BYTES = 4;
    public static final int SINC_WIDTH = 11;
    public static final int SINC_WIDTH_HALF = 5;
    public static final int SINC_WIDTH_HALF_NEG = -5;

    protected VoxelValue(Image image, ImageType imageType, ImageRange imageRange, ImageDimensions imageDimensions, Orientation orientation) {
        this.image = image;
        this.imageRange = imageRange;
        this.imageDimensions = imageDimensions;
        this.orientation = orientation;
        this.imageType = imageType;
        this.nativeDataType = imageType.isReadOnly() || image.isNativeIntegerType() || imageType.isRGBMode();
        this.typeNumBytes = this.nativeDataType ? imageType.getNumBytesPerVoxel() : 4;
        this.reconcile();
    }

    public boolean isVariableTiming() {
        return this.volumeTimes != null;
    }

    public void setCumulativeTimes(float[] times) {
        this.cumulativeTimes = times;
    }

    public void setTempBuffer(ByteBuffer temp) {
        this.tempBuffer = temp;
    }

    public void setVariableTimingSize(float time) {
        this.variableTimingSize = time;
    }

    public void setVolumeTimes(float[] times) {
        this.volumeTimes = times;
    }

    private double getBufferValueAt(long offsetBytes) {
        int bufferIndex = (int)(this.numTimepoints > 1 ? offsetBytes / (long)this.volSizeBytes : 0L);
        int volIndexBytes = (int)(this.numTimepoints > 1 ? offsetBytes % (long)this.volSizeBytes : offsetBytes);
        if (this.nativeDataType) {
            return this.getNativeIntegerValueAtByteIndex(volIndexBytes, bufferIndex);
        }
        return this.buffers[bufferIndex].getFloat(volIndexBytes);
    }

    private double getBufferValueAt(ByteBuffer buffer, long offsetBytes) {
        int volIndexBytes = (int)(this.numTimepoints > 1 ? offsetBytes % (long)this.volSizeBytes : offsetBytes);
        if (this.nativeDataType) {
            return this.getNativeIntegerValueAt(buffer, volIndexBytes);
        }
        return buffer.getFloat(volIndexBytes);
    }

    private double getBufferValueAt(long offsetBytes, int bufferIndex) {
        int volIndexBytes = (int)(this.numTimepoints > 1 ? offsetBytes % (long)this.volSizeBytes : offsetBytes);
        if (this.nativeDataType) {
            return this.getNativeIntegerValueAtByteIndex(volIndexBytes, bufferIndex);
        }
        return this.buffers[bufferIndex].getFloat(volIndexBytes);
    }

    private double getPartialValue(ByteBuffer bufferCurrent, int offsetA, int offsetB, boolean limitA, boolean limitB, boolean useDataScale, double frac, int timeOffset) {
        double tempValB;
        if (limitA) {
            return 0.0;
        }
        int dataScaleIndexA = (offsetA + timeOffset) / this.sliceSizeBytes;
        double dataScaleSlopeValA = useDataScale ? (double)this.dataScaleSlope[dataScaleIndexA] : 1.0;
        double dataScaleInterceptValA = useDataScale ? (double)this.dataScaleIntercept[dataScaleIndexA] : 0.0;
        double tempValA = (this.getBufferValueAt(bufferCurrent, (long)offsetA) * dataScaleSlopeValA + dataScaleInterceptValA) * (1.0 - frac);
        if (limitB) {
            tempValB = 0.0;
        } else {
            int dataScaleIndexB = (offsetB + timeOffset) / this.sliceSizeBytes;
            double dataScaleSlopeValB = useDataScale ? (double)this.dataScaleSlope[dataScaleIndexB] : 1.0;
            double dataScaleInterceptValB = useDataScale ? (double)this.dataScaleIntercept[dataScaleIndexB] : 0.0;
            tempValB = (this.getBufferValueAt(bufferCurrent, (long)offsetB) * dataScaleSlopeValB + dataScaleInterceptValB) * frac;
        }
        return tempValA + tempValB;
    }

    private double[] getRatiosForTimeRange(double start, double size, double[] ratiosVal, int[] indices) {
        float[] timeOffsets = this.cumulativeTimes;
        float[] times = this.volumeTimes;
        double[] ratios = ratiosVal;
        int indexStart = -1;
        int indexEnd = timeOffsets.length - 1;
        double end = start + size;
        for (int ctr = 0; ctr < timeOffsets.length; ++ctr) {
            double offsetStart = timeOffsets[ctr];
            double offsetEnd = timeOffsets[ctr] + times[ctr];
            if (start >= offsetStart && start < offsetEnd) {
                indexStart = ctr;
            }
            if (!(end > offsetStart) || !(end <= offsetEnd)) continue;
            indexEnd = ctr;
        }
        int indexRange = indexEnd - indexStart + 1;
        if (ratios == null || ratios.length != indexRange) {
            ratios = new double[indexRange];
        }
        double currentStart = start;
        for (int ctr = 0; ctr < ratios.length; ++ctr) {
            int index = indexStart + ctr;
            double currentEnd = index == indexEnd ? end : (double)(timeOffsets[index] + times[index]);
            double length = currentEnd - currentStart;
            ratios[ctr] = length / size;
            currentStart = currentEnd;
        }
        indices[0] = indexStart;
        indices[1] = indexEnd;
        return ratios;
    }

    private double getValueAt(double xLoc, double yLoc, double zLoc, double timepoint, boolean useDataScale) {
        int tInt = (int)timepoint;
        double fracT = timepoint - (double)tInt;
        boolean interpolateT = fracT != 0.0;
        double returnVal = 0.0;
        if (this.isVariableTiming()) {
            this.timingRatios = this.getRatiosForTimeRange(timepoint, this.variableTimingSize, this.timingRatios, this.timingIndices);
            for (int ctr = 0; ctr < this.timingRatios.length; ++ctr) {
                returnVal += this.getValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * (this.timingIndices[0] + ctr), useDataScale) * this.timingRatios[ctr];
            }
        } else if (interpolateT) {
            double firstVal = this.getValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * tInt, useDataScale);
            double secondVal = this.getValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * (tInt + 1), useDataScale);
            returnVal = firstVal * (1.0 - fracT) + secondVal * fracT;
        } else {
            returnVal = this.getValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * tInt, useDataScale);
        }
        return returnVal;
    }

    private double getValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, useDataScale, false);
    }

    private double getValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean useTemp) {
        ByteBuffer bufferCurrent = null;
        if (useTemp) {
            bufferCurrent = this.tempBuffer;
        } else {
            int bufferIndex;
            int n = bufferIndex = this.numTimepoints > 1 ? timeOffset / this.volSize : 0;
            if (bufferIndex >= this.buffers.length) {
                return 0.0;
            }
            bufferCurrent = this.buffers[bufferIndex];
        }
        int timeOffsetBytes = timeOffset * this.typeNumBytes;
        int xInt = (int)xLoc;
        int yInt = (int)yLoc;
        int zInt = (int)zLoc;
        boolean xLimit = xInt == this.xMax;
        boolean yLimit = yInt == this.yMax;
        boolean zLimit = zInt == this.zMax;
        double fracX = xLoc - (double)xInt;
        double fracY = yLoc - (double)yInt;
        double fracZ = zLoc - (double)zInt;
        double fracRemainderX = 1.0 - fracX;
        double fracRemainderY = 1.0 - fracY;
        boolean interpolateX = fracX != 0.0;
        boolean interpolateY = fracY != 0.0;
        boolean interpolateZ = fracZ != 0.0;
        double value = 0.0;
        if (interpolateX && interpolateY && interpolateZ) {
            int xInc = xInt * this.xIncrementBytes;
            int xPlusInc = (xInt + 1) * this.xIncrementBytes;
            int yInc = yInt * this.yIncrementBytes;
            int yPlusInc = (yInt + 1) * this.yIncrementBytes;
            int zInc = zInt * this.zIncrementBytes;
            int offset11A = xInc + yInc + zInc;
            int offset11B = offset11A + this.zIncrementBytes;
            double tempVal11 = this.getPartialValue(bufferCurrent, offset11A, offset11B, false, zLimit, useDataScale, fracZ, timeOffsetBytes);
            int offset12A = xInc + yPlusInc + zInc;
            int offset12B = offset12A + this.zIncrementBytes;
            double tempVal12 = this.getPartialValue(bufferCurrent, offset12A, offset12B, yLimit, zLimit, useDataScale, fracZ, timeOffsetBytes);
            double value1 = tempVal11 * fracRemainderY + tempVal12 * fracY;
            int offset21A = xPlusInc + yInc + zInc;
            int offset21B = offset21A + this.zIncrementBytes;
            double tempVal21 = this.getPartialValue(bufferCurrent, offset21A, offset21B, xLimit, zLimit, useDataScale, fracZ, timeOffsetBytes);
            int offset22A = xPlusInc + yPlusInc + zInc;
            int offset22B = offset22A + this.zIncrementBytes;
            double tempVal22 = this.getPartialValue(bufferCurrent, offset22A, offset22B, xLimit || yLimit, zLimit, useDataScale, fracZ, timeOffsetBytes);
            double value2 = tempVal21 * fracRemainderY + tempVal22 * fracY;
            value = value1 * fracRemainderX + value2 * fracX;
        } else if (interpolateX && interpolateY && !interpolateZ) {
            int offset = yInt * this.yIncrementBytes + zInt * this.zIncrementBytes;
            int offsetA = xInt * this.xIncrementBytes + offset;
            int offsetB = offsetA + this.yIncrementBytes;
            double tempValA = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, yLimit, useDataScale, fracY, timeOffsetBytes);
            offsetA = (xInt + 1) * this.xIncrementBytes + offset;
            offsetB = offsetA + this.yIncrementBytes;
            double tempValB = this.getPartialValue(bufferCurrent, offsetA, offsetB, xLimit, yLimit, useDataScale, fracY, timeOffsetBytes);
            value = tempValA * fracRemainderX + tempValB * fracX;
        } else if (interpolateX && !interpolateY && interpolateZ) {
            int offset = yInt * this.yIncrementBytes + zInt * this.zIncrementBytes;
            int offsetA = xInt * this.xIncrementBytes + offset;
            int offsetB = offsetA + this.zIncrementBytes;
            double tempValA = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, zLimit, useDataScale, fracZ, timeOffsetBytes);
            offsetA = (xInt + 1) * this.xIncrementBytes + offset;
            offsetB = offsetA + this.zIncrementBytes;
            double tempValB = this.getPartialValue(bufferCurrent, offsetA, offsetB, xLimit, zLimit, useDataScale, fracZ, timeOffsetBytes);
            value = tempValA * fracRemainderX + tempValB * fracX;
        } else if (!interpolateX && interpolateY && interpolateZ) {
            int offset = xInt * this.xIncrementBytes + zInt * this.zIncrementBytes;
            int offsetA = yInt * this.yIncrementBytes + offset;
            int offsetB = offsetA + this.zIncrementBytes;
            double tempValA = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, zLimit, useDataScale, fracZ, timeOffsetBytes);
            offsetA = (yInt + 1) * this.yIncrementBytes + offset;
            offsetB = offsetA + this.zIncrementBytes;
            double tempValB = this.getPartialValue(bufferCurrent, offsetA, offsetB, yLimit, zLimit, useDataScale, fracZ, timeOffsetBytes);
            value = tempValA * fracRemainderY + tempValB * fracY;
        } else if (!interpolateX && !interpolateY && interpolateZ) {
            int offsetA = xInt * this.xIncrementBytes + (yInt * this.yIncrementBytes + zInt * this.zIncrementBytes);
            int offsetB = offsetA + this.zIncrementBytes;
            value = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, zLimit, useDataScale, fracZ, timeOffsetBytes);
        } else if (!interpolateX && interpolateY && !interpolateZ) {
            int offsetA = xInt * this.xIncrementBytes + (yInt * this.yIncrementBytes + zInt * this.zIncrementBytes);
            int offsetB = offsetA + this.yIncrementBytes;
            value = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, yLimit, useDataScale, fracY, timeOffsetBytes);
        } else if (interpolateX && !interpolateY && !interpolateZ) {
            int offsetA = xInt * this.xIncrementBytes + (yInt * this.yIncrementBytes + zInt * this.zIncrementBytes);
            int offsetB = offsetA + this.xIncrementBytes;
            value = this.getPartialValue(bufferCurrent, offsetA, offsetB, false, xLimit, useDataScale, fracX, timeOffsetBytes);
        } else {
            long offsetT = xInt * this.xIncrement + yInt * this.yIncrement + zInt * this.zIncrement + timeOffset;
            value = useTemp ? (useDataScale ? this.getValueAtOffsetTemp((int)offsetT) : this.getRawValueAtOffsetTemp((int)offsetT)) : (useDataScale ? this.getValueForOffset(offsetT) : this.getRawValueForOffset(offsetT));
        }
        return value;
    }

    private void makeWeights(double[] data, double frac) {
        for (int ctr = -5; ctr <= 5; ++ctr) {
            double temp = Math.PI * ((double)ctr - frac);
            data[ctr + 5] = temp == 0.0 ? 1.0 : Math.sin(temp) / temp;
        }
    }

    private void reconcileBuffer() {
        if (this.image != null) {
            this.buffers = this.image.getWorkBuffers();
            this.numTimepoints = this.imageDimensions.getTimepoints();
            this.sliceSizeBytes = this.imageDimensions.getNumVoxelsSlice() * this.typeNumBytes;
            this.volSize = this.imageDimensions.getNumVoxelsVolume();
            this.volSizeBytes = this.volSize * this.typeNumBytes;
        }
    }

    private double sincInterpolate(int xLoc, int yLoc, int zLoc, int timeOffset, boolean useDataScale, boolean doX, boolean doY, boolean doZ, double[] sincWeightsHolder) {
        int offsetX = yLoc * this.yIncrement + zLoc * this.zIncrement;
        int offsetY = xLoc * this.xIncrement + zLoc * this.zIncrement;
        int offsetZ = xLoc * this.xIncrement + yLoc * this.yIncrement;
        double ratioSum = 0.0;
        double valueSum = 0.0;
        int bufferIndex = this.numTimepoints > 1 ? timeOffset / this.volSize : 0;
        for (int ctr = -5; ctr <= 5; ++ctr) {
            double value = 0.0;
            double ratio = sincWeightsHolder[ctr + 5];
            ratioSum += ratio;
            if (doX && (xLoc + ctr < 0 || xLoc + ctr >= this.xDim || yLoc < 0 || yLoc >= this.yDim || zLoc < 0 || zLoc >= this.zDim)) {
                value = 0.0;
            } else if (doY && (xLoc < 0 || xLoc >= this.xDim || yLoc + ctr < 0 || yLoc + ctr >= this.yDim || zLoc < 0 || zLoc >= this.zDim)) {
                value = 0.0;
            } else if (doZ && (xLoc < 0 || xLoc >= this.xDim || yLoc < 0 || yLoc >= this.yDim || zLoc + ctr < 0 || zLoc + ctr >= this.zDim)) {
                value = 0.0;
            } else {
                int offset = doX ? (xLoc + ctr) * this.xIncrement + offsetX : (doY ? (yLoc + ctr) * this.yIncrement + offsetY : (zLoc + ctr) * this.zIncrement + offsetZ);
                int offsetBytes = offset * this.typeNumBytes;
                int dataScaleIndex = offsetBytes / this.sliceSizeBytes;
                float dataScaleSlopeVal = useDataScale ? this.dataScaleSlope[dataScaleIndex] : 1.0f;
                float dataScaleInterceptVal = useDataScale ? this.dataScaleIntercept[dataScaleIndex] : 0.0f;
                value = this.getBufferValueAt(offsetBytes, bufferIndex) * (double)dataScaleSlopeVal + (double)dataScaleInterceptVal;
            }
            valueSum += value * ratio;
        }
        return valueSum *= 1.0 / ratioSum;
    }

    private double sincInterpolateStored1D(double[] sincWeightsHolder, double[] sincHolder1D) {
        double ratioSum = 0.0;
        double valueSum = 0.0;
        for (int ctr = -5; ctr <= 5; ++ctr) {
            int ctrPlus = ctr + 5;
            double ratio = sincWeightsHolder[ctrPlus];
            ratioSum += ratio;
            double value = sincHolder1D[ctrPlus];
            valueSum += value * ratio;
        }
        return valueSum *= 1.0 / ratioSum;
    }

    private double sincInterpolateStored2D(int index, double[] sincWeightsHolder, double[][] sincHolder2D) {
        double ratioSum = 0.0;
        double valueSum = 0.0;
        for (int ctr = -5; ctr <= 5; ++ctr) {
            int ctrPlus = ctr + 5;
            double ratio = sincWeightsHolder[ctrPlus];
            ratioSum += ratio;
            double value = sincHolder2D[index][ctrPlus];
            valueSum += value * ratio;
        }
        return valueSum *= 1.0 / ratioSum;
    }

    protected void clear() {
        this.image = null;
        this.buffers = null;
        this.imageDimensions = null;
    }

    protected double formatValue(long offset, int timepoint, double value) {
        long offsetBytes = offset * (long)this.typeNumBytes + (long)timepoint * (long)this.volSizeBytes;
        int dataScaleIndex = (int)(offsetBytes / (long)this.sliceSizeBytes);
        return value * (double)this.dataScaleSlope[dataScaleIndex] + (double)this.dataScaleIntercept[dataScaleIndex];
    }

    protected long getNativeIntegerValueAt(int offset) {
        int bufferIndex = this.numTimepoints > 1 ? offset / this.volSize : 0;
        return this.getNativeIntegerValueAt(offset, bufferIndex);
    }

    protected long getNativeIntegerValueAt(int offset, int seriesIndex) {
        if (this.nativeDataType) {
            if (this.typeNumBytes == 1) {
                return (long)this.buffers[seriesIndex].get(offset) & 0xFFL;
            }
            if (this.typeNumBytes == 2) {
                return (long)this.buffers[seriesIndex].getShort(offset * 2) & 0xFFFFL;
            }
            if (this.typeNumBytes == 4) {
                return (long)this.buffers[seriesIndex].getInt(offset * 4) & 0xFFFFFFFFL;
            }
            if (this.typeNumBytes == 8) {
                return this.buffers[seriesIndex].getLong(offset * 8);
            }
        }
        return -1L;
    }

    protected long getNativeIntegerValueAtByteIndex(int offset, int seriesIndex) {
        if (this.nativeDataType) {
            if (this.typeNumBytes == 1) {
                return (long)this.buffers[seriesIndex].get(offset) & 0xFFL;
            }
            if (this.typeNumBytes == 2) {
                return (long)this.buffers[seriesIndex].getShort(offset) & 0xFFFFL;
            }
            if (this.typeNumBytes == 4) {
                return (long)this.buffers[seriesIndex].getInt(offset) & 0xFFFFFFFFL;
            }
            if (this.typeNumBytes == 8) {
                return this.buffers[seriesIndex].getLong(offset);
            }
        }
        return -1L;
    }

    protected long getNativeIntegerValueAt(ByteBuffer buffer, int offset) {
        if (this.nativeDataType) {
            if (this.typeNumBytes == 1) {
                return (long)buffer.get(offset) & 0xFFL;
            }
            if (this.typeNumBytes == 2) {
                return (long)buffer.getShort(offset * 2) & 0xFFFFL;
            }
            if (this.typeNumBytes == 4) {
                return (long)buffer.getInt(offset * 4) & 0xFFFFFFFFL;
            }
            if (this.typeNumBytes == 8) {
                return buffer.getLong(offset * 8);
            }
        }
        return -1L;
    }

    protected double getRawValueAt(double xLoc, double yLoc, double zLoc, double tLoc) {
        return this.getValueAt(xLoc, yLoc, zLoc, tLoc, false);
    }

    protected double getRawValueAt(double xLoc, double yLoc, double zLoc, int timeOffset) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, false);
    }

    protected double getRawValueAtOffsetTemp(long offset) {
        return this.getBufferValueAt(this.tempBuffer, offset * (long)this.typeNumBytes);
    }

    protected double getRawValueForOffset(long offset) {
        return this.getBufferValueAt(offset * (long)this.typeNumBytes);
    }

    protected double getSincValueAt(double xLoc, double yLoc, double zLoc, double timepoint, boolean useDataScale) {
        int tInt = (int)timepoint;
        double fracT = timepoint - (double)tInt;
        boolean interpolateT = fracT != 0.0;
        double returnVal = 0.0;
        if (interpolateT) {
            double firstVal = this.getSincValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * tInt, useDataScale);
            double secondVal = this.getSincValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * (tInt + 1), useDataScale);
            returnVal = firstVal * (1.0 - fracT) + secondVal * fracT;
        } else {
            returnVal = this.getSincValueAt(xLoc, yLoc, zLoc, this.numVoxelsVolume * tInt, useDataScale);
        }
        return returnVal;
    }

    protected double getSincValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale) {
        int xInt = (int)xLoc;
        int yInt = (int)yLoc;
        int zInt = (int)zLoc;
        double fracX = xLoc - (double)xInt;
        double fracY = yLoc - (double)yInt;
        double fracZ = zLoc - (double)zInt;
        boolean interpolateX = fracX != 0.0;
        boolean interpolateY = fracY != 0.0;
        boolean interpolateZ = fracZ != 0.0;
        double[] sincWeightsHolder = new double[11];
        double value = 0.0;
        if (interpolateX && interpolateY && interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracX);
            double[][] sincHolder2D = new double[11][11];
            for (int ctrZ = -5; ctrZ <= 5; ++ctrZ) {
                for (int ctrY = -5; ctrY <= 5; ++ctrY) {
                    sincHolder2D[ctrZ + 5][ctrY + 5] = this.sincInterpolate(xInt, yInt + ctrY, zInt + ctrZ, timeOffset, useDataScale, true, false, false, sincWeightsHolder);
                }
            }
            this.makeWeights(sincWeightsHolder, fracY);
            double[] sincHolder1D = new double[11];
            for (int ctrZ = -5; ctrZ <= 5; ++ctrZ) {
                sincHolder1D[ctrZ + 5] = this.sincInterpolateStored2D(5 + ctrZ, sincWeightsHolder, sincHolder2D);
            }
            this.makeWeights(sincWeightsHolder, fracZ);
            value = this.sincInterpolateStored1D(sincWeightsHolder, sincHolder1D);
        } else if (interpolateX && interpolateY && !interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracX);
            double[] sincHolder1D = new double[11];
            for (int ctr = -5; ctr <= 5; ++ctr) {
                sincHolder1D[ctr + 5] = this.sincInterpolate(xInt, yInt + ctr, zInt, timeOffset, useDataScale, true, false, false, sincWeightsHolder);
            }
            this.makeWeights(sincWeightsHolder, fracY);
            value = this.sincInterpolateStored1D(sincWeightsHolder, sincHolder1D);
        } else if (interpolateX && !interpolateY && interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracX);
            double[] sincHolder1D = new double[11];
            for (int ctr = -5; ctr <= 5; ++ctr) {
                sincHolder1D[ctr + 5] = this.sincInterpolate(xInt, yInt, zInt + ctr, timeOffset, useDataScale, true, false, false, sincWeightsHolder);
            }
            this.makeWeights(sincWeightsHolder, fracZ);
            value = this.sincInterpolateStored1D(sincWeightsHolder, sincHolder1D);
        } else if (!interpolateX && interpolateY && interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracY);
            double[] sincHolder1D = new double[11];
            for (int ctr = -5; ctr <= 5; ++ctr) {
                sincHolder1D[ctr + 5] = this.sincInterpolate(xInt, yInt, zInt + ctr, timeOffset, useDataScale, false, true, false, sincWeightsHolder);
            }
            this.makeWeights(sincWeightsHolder, fracZ);
            value = this.sincInterpolateStored1D(sincWeightsHolder, sincHolder1D);
        } else if (interpolateX && !interpolateY && !interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracX);
            value = this.sincInterpolate(xInt, yInt, zInt, timeOffset, useDataScale, true, false, false, sincWeightsHolder);
        } else if (!interpolateX && interpolateY && !interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracY);
            value = this.sincInterpolate(xInt, yInt, zInt, timeOffset, useDataScale, false, true, false, sincWeightsHolder);
        } else if (!interpolateX && !interpolateY && interpolateZ) {
            this.makeWeights(sincWeightsHolder, fracZ);
            value = this.sincInterpolate(xInt, yInt, zInt, timeOffset, useDataScale, false, false, true, sincWeightsHolder);
        } else {
            value = useDataScale ? this.getValueForOffset(xInt * this.xIncrement + yInt * this.yIncrement + zInt * this.zIncrement + timeOffset) : this.getRawValueForOffset(xInt * this.xIncrement + yInt * this.yIncrement + zInt * this.zIncrement + timeOffset);
        }
        return value;
    }

    protected double getTempRawValueAt(double xLoc, double yLoc, double zLoc, int timeOffset) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, false, true);
    }

    protected double getTempValueAt(double xLoc, double yLoc, double zLoc, int timeOffset) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, true, true);
    }

    protected double getValueAt(double xLoc, double yLoc, double zLoc, double tLoc) {
        return this.getValueAt(xLoc, yLoc, zLoc, tLoc, true);
    }

    protected double getValueAt(double xLoc, double yLoc, double zLoc, int timeOffset) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, true);
    }

    protected double getValueAtOffsetTemp(int offset) {
        int offsetBytes = offset * this.typeNumBytes;
        int dataScaleIndex = offsetBytes / this.sliceSizeBytes;
        return this.getBufferValueAt(this.tempBuffer, (long)offsetBytes) * (double)this.dataScaleSlope[dataScaleIndex] + (double)this.dataScaleIntercept[dataScaleIndex];
    }

    protected double getValueForOffset(long offset) {
        double value = 0.0;
        int dataScaleIndex = -1;
        try {
            if (offset == -1L) {
                return 0.0;
            }
            long offsetBytes = offset * (long)this.typeNumBytes;
            dataScaleIndex = (int)(offsetBytes / (long)this.sliceSizeBytes);
            return this.getBufferValueAt(offsetBytes) * (double)this.dataScaleSlope[dataScaleIndex] + (double)this.dataScaleIntercept[dataScaleIndex];
        }
        catch (Exception ex) {
            value = -1.0;
            return value;
        }
    }

    protected void putRawValueAtOffsetTemp(int offset, double value) {
        this.tempBuffer.putFloat(offset * this.typeNumBytes, (float)value);
    }

    protected void putValueAtOffset(long offset, double value) {
        long offsetBytes = offset * (long)this.typeNumBytes;
        int bufferIndex = (int)(this.numTimepoints > 1 ? offsetBytes / (long)this.volSizeBytes : 0L);
        int volIndexBytes = (int)(this.numTimepoints > 1 ? offsetBytes % (long)this.volSizeBytes : offsetBytes);
        int dataScaleIndex = (int)(offsetBytes / (long)this.sliceSizeBytes);
        try {
            this.buffers[bufferIndex].putFloat(volIndexBytes, (float)((value - (double)this.dataScaleIntercept[dataScaleIndex]) / (double)this.dataScaleSlope[dataScaleIndex]));
        }
        catch (Exception ex) {
            AppLogger.errorMinimal((Throwable)ex);
        }
    }

    protected final void reconcile() {
        if (this.imageType.isRGBPalette() || this.typeNumBytes == 3 && this.imageType.getByteType() == 6) {
            this.typeNumBytes = 4;
        }
        this.xIncrement = this.orientation.getXIncrement();
        this.yIncrement = this.orientation.getYIncrement();
        this.zIncrement = this.orientation.getZIncrement();
        this.xIncrementBytes = this.xIncrement * this.typeNumBytes;
        this.yIncrementBytes = this.yIncrement * this.typeNumBytes;
        this.zIncrementBytes = this.zIncrement * this.typeNumBytes;
        this.xDim = this.imageDimensions.getX();
        this.yDim = this.imageDimensions.getY();
        this.zDim = this.imageDimensions.getZ();
        this.xMax = this.xDim - 1;
        this.yMax = this.yDim - 1;
        this.zMax = this.zDim - 1;
        this.numVoxelsVolume = this.imageDimensions.getNumVoxelsVolume();
        this.dataScaleSlope = this.imageRange.getDataScaleSlopes();
        this.dataScaleIntercept = this.imageRange.getDataScaleIntercepts();
        this.reconcileBuffer();
    }

    protected void setAsNativeIntegerType() {
        this.nativeDataType = true;
        this.typeNumBytes = this.imageType.getNumBytesPerVoxel();
        this.reconcile();
    }

    protected double unformatValue(double value) {
        return (value - (double)this.dataScaleIntercept[0]) / (double)this.dataScaleSlope[0];
    }

    protected double unformatValue(long offset, double value) {
        long offsetBytes = offset * (long)this.typeNumBytes;
        int dataScaleIndex = (int)(offsetBytes / (long)this.sliceSizeBytes);
        return (value - (double)this.dataScaleIntercept[dataScaleIndex]) / (double)this.dataScaleSlope[dataScaleIndex];
    }
}

