/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageData;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.range.VolumeRangeOp;

public class VolumeData
implements ImageData {
    private Coordinate origin;
    private boolean useDataScale;
    private boolean overlay;
    private boolean usingTransform;
    private boolean worldMode;
    private double max;
    private double min;
    private int timepoint;
    private double xSize;
    private double ySize;
    private double zSize;
    private final VolumeManager manager;
    private final Volume volume;

    public VolumeData(VolumeManager manager) {
        this.manager = manager;
        this.volume = (Volume)manager.getCurrentVolume();
        this.initialize();
    }

    public VolumeData(VolumeManager manager, Volume volume) {
        this.manager = manager;
        this.volume = volume;
        this.initialize();
    }

    public void findVolumeRange(int timepoint) {
        ImageBounds ib = this.volume.getImageBounds();
        ib.setRangeT(timepoint, timepoint);
        VolumeRangeOp op = new VolumeRangeOp(this.manager, this.volume);
        Range range = op.process(ib);
        this.min = range.getMin();
        this.max = range.getMax();
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    @Override
    public double getValue(int ctrX, int ctrY, int ctrZ) {
        return this.getValue(ctrX, ctrY, ctrZ, this.timepoint);
    }

    @Override
    public double getValue(int ctrX, int ctrY, int ctrZ, int ctrT) {
        if (this.worldMode) {
            double worldX = (double)(ctrX - this.origin.xInt) * this.xSize;
            double worldY = (double)(this.origin.yInt - ctrY) * this.ySize;
            double worldZ = (double)(this.origin.zInt - ctrZ) * this.zSize;
            return this.volume.getVoxelValueAtCoordinate(worldX, worldY, worldZ, ctrT, this.usingTransform);
        }
        if (this.overlay) {
            return this.volume.getVoxelValueAtMM((double)ctrX * this.xSize, (double)ctrY * this.ySize, (double)ctrZ * this.zSize, ctrT, this.usingTransform, true);
        }
        return this.volume.getVoxelValueAtIndex(ctrX, ctrY, ctrZ, ctrT, this.usingTransform);
    }

    public void putValue(int ctrX, int ctrY, int ctrZ, int ctrT, double value) {
        this.volume.putVoxelValueAtIndex(ctrX, ctrY, ctrZ, ctrT, value);
    }

    public double getValueTemp(int ctrX, int ctrY, int ctrZ) {
        if (this.worldMode) {
            double worldX = (double)(ctrX - this.origin.xInt) * this.xSize;
            double worldY = (double)(this.origin.yInt - ctrY) * this.ySize;
            double worldZ = (double)(this.origin.zInt - ctrZ) * this.zSize;
            return this.volume.getVoxelValueAtCoordinateTemp(worldX, worldY, worldZ, this.usingTransform, true);
        }
        if (this.overlay) {
            return this.volume.getVoxelValueAtMMTemp((double)ctrX * this.xSize, (double)ctrY * this.ySize, (double)ctrZ * this.zSize, this.useDataScale, this.usingTransform);
        }
        return this.volume.getVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, this.useDataScale);
    }

    public double getValueMMTemp(double ctrX, double ctrY, double ctrZ) {
        if (this.worldMode) {
            double worldX = (ctrX / this.xSize - (double)this.origin.xInt) * this.xSize;
            double worldY = ((double)this.origin.yInt - ctrY / this.ySize) * this.ySize;
            double worldZ = ((double)this.origin.zInt - ctrZ / this.zSize) * this.zSize;
            return this.volume.getVoxelValueAtCoordinateTemp(worldX, worldY, worldZ, this.usingTransform, this.useDataScale);
        }
        return this.volume.getVoxelValueAtMMTemp(ctrX, ctrY, ctrZ, this.useDataScale, this.usingTransform);
    }

    public double getValueMM(double ctrX, double ctrY, double ctrZ) {
        return this.getValueMM(ctrX, ctrY, ctrZ, this.timepoint);
    }

    public double getValueMM(double ctrX, double ctrY, double ctrZ, int ctrT) {
        if (this.worldMode) {
            double worldX = (ctrX / this.xSize - (double)this.origin.xInt) * this.xSize;
            double worldY = ((double)this.origin.yInt - ctrY / this.ySize) * this.ySize;
            double worldZ = ((double)this.origin.zInt - ctrZ / this.zSize) * this.zSize;
            return this.volume.getVoxelValueAtCoordinate(worldX, worldY, worldZ, ctrT, this.usingTransform);
        }
        return this.volume.getVoxelValueAtMM(ctrX, ctrY, ctrZ, ctrT, this.usingTransform, true);
    }

    public void convertIndexToWorldCoordinate(Coordinate coor) {
        coor.setValues((coor.xDbl - (double)this.origin.xInt) * this.xSize, ((double)this.origin.yInt - coor.yDbl) * this.ySize, ((double)this.origin.zInt - coor.zDbl) * this.zSize);
    }

    public void convertMMToWorldCoordinate(Coordinate coor) {
        coor.setValues((coor.xDbl / this.xSize - (double)this.origin.xInt) * this.xSize, ((double)this.origin.yInt - coor.yDbl / this.ySize) * this.ySize, ((double)this.origin.zInt - coor.zDbl / this.zSize) * this.zSize);
    }

    public void convertWorldToIndexCoordinate(Coordinate coor) {
        coor.setValues((double)Math.round(coor.xDbl / this.xSize + (double)this.origin.xInt), (double)Math.round(coor.yDbl / -this.ySize + (double)this.origin.yInt), (double)Math.round(coor.zDbl / -this.zSize + (double)this.origin.zInt));
    }

    public long getNativeIntegerValue(int ctrX, int ctrY, int ctrZ) {
        return this.getNativeIntegerValue(ctrX, ctrY, ctrZ, this.timepoint);
    }

    public long getNativeIntegerValue(int ctrX, int ctrY, int ctrZ, int ctrT) {
        if (this.worldMode) {
            double worldX = (double)(ctrX - this.origin.xInt) * this.xSize;
            double worldY = (double)(this.origin.yInt - ctrY) * this.ySize;
            double worldZ = (double)(this.origin.zInt - ctrZ) * this.zSize;
            return this.volume.getNativeIntegerValueAtCoordinate(worldX, worldY, worldZ, ctrT);
        }
        if (this.overlay) {
            return this.volume.getNativeIntegerValueAtMM((double)ctrX * this.xSize, (double)ctrY * this.ySize, (double)ctrZ * this.zSize, ctrT);
        }
        return this.volume.getNativeIntegerValueAtIndex(ctrX, ctrY, ctrZ, ctrT);
    }

    public boolean isWorldMode() {
        return this.worldMode;
    }

    public void setMMMode(boolean isMMMode) {
        this.overlay = isMMMode;
    }

    public void setWorldMode(boolean isWorldMode) {
        this.worldMode = isWorldMode;
    }

    public void setUsingTransform(boolean usingTransform) {
        this.usingTransform = usingTransform;
    }

    public int getOffsetAt(int xLoc, int yLoc, int zLoc, int ctrT) {
        int offset = (int)this.volume.convertIndexToOffset(xLoc, yLoc, zLoc);
        int volSize = this.volume.getImageDimensions().getNumVoxelsVolume();
        return offset + ctrT * volSize;
    }

    private void initialize() {
        if (this.manager != null) {
            this.worldMode = this.manager.isWorldMode();
            this.origin = this.manager.getBaseVolume().getOrigin();
            this.xSize = this.manager.getBaseVolume().getVoxelDimensions().getXSize();
            this.ySize = this.manager.getBaseVolume().getVoxelDimensions().getYSize();
            this.zSize = this.manager.getBaseVolume().getVoxelDimensions().getZSize();
            this.timepoint = this.volume.getCurrentTimepoint();
            this.usingTransform = this.manager.isVolumeUsingTransform((ImageVolume)this.volume);
            this.overlay = this.manager.isVolumeOverlay((ImageVolume)this.volume);
        } else {
            this.origin = this.volume.getOrigin();
            this.xSize = this.volume.getVoxelDimensions().getXSize();
            this.ySize = this.volume.getVoxelDimensions().getYSize();
            this.zSize = this.volume.getVoxelDimensions().getZSize();
            this.timepoint = this.volume.getCurrentTimepoint();
        }
        this.useDataScale = true;
    }

    public boolean isUseDataScaleTemp() {
        return this.useDataScale;
    }

    public void setUseDataScaleTemp(boolean useDataScale) {
        this.useDataScale = useDataScale;
    }

    public void updateOrigin() {
        this.origin = this.manager.getBaseVolume().getOrigin();
    }
}

