/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.ClusterFilter;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageListener;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.VoxelValue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;

public class Image {
    private ByteBuffer tempBuffer;
    private ByteBuffer[] workBuffers;
    private ImageListener listener;
    private ProgressBar pb;
    private ProgressBarListener pbListener;
    private boolean backgroundLoading;
    private boolean nativeDataType;
    private boolean readOnly;
    private boolean isRGBMode;
    private long nativeDataTypeSaveMask = -1L;
    private final byte[] buffer = new byte[6144];
    private static final int BUFFER_SIZE = 6144;
    private static boolean cli;

    public static ByteBuffer makeBuffer(int size) {
        ByteBuffer bb = null;
        try {
            bb = ByteBuffer.allocateDirect(size);
            bb.order(ByteOrder.nativeOrder());
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            bb = ByteBuffer.allocate(size);
        }
        return bb;
    }

    public static ByteBuffer[] makeBuffers(int size, int numTimepoints) {
        ByteBuffer[] buffersNew = null;
        buffersNew = new ByteBuffer[numTimepoints];
        for (int ctr = 0; ctr < numTimepoints; ++ctr) {
            buffersNew[ctr] = Image.makeBuffer(size);
        }
        return buffersNew;
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    public ByteBuffer getTempBuffer() {
        return this.tempBuffer;
    }

    public boolean isBackgroundLoading() {
        return this.backgroundLoading;
    }

    public boolean isNativeIntegerType() {
        return this.nativeDataType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setBackgroundLoading(boolean backgroundLoading) {
        this.backgroundLoading = backgroundLoading;
    }

    public void setBuffers(ByteBuffer[] buffers) {
        this.workBuffers = buffers;
    }

    public void setProgressBarListener(ProgressBarListener aListener) {
        this.pbListener = aListener;
    }

    public void setUser(ImageListener aListener) {
        this.listener = aListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatenateToWorkBuffer(URI[] multiFile, int[] multiImageOffset, ImageDimensions id, ImageType it, boolean reverting) {
        int numVoxelsInSlice = id.getNumVoxelsSlice();
        int numVoxelsVolume = id.getNumVoxelsVolume();
        int numTimepoints = id.getTimepoints();
        int sliceSize = numVoxelsInSlice * it.getNumBytesPerVoxel();
        int numBytes = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        long mask = it.createBitMask();
        int iterations = id.getSlices() * numTimepoints / multiFile.length;
        int numFilesPerVolume = multiFile.length / numTimepoints;
        boolean error = false;
        if (!reverting) {
            this.makeWorkBuffer(numVoxelsVolume * 4, numTimepoints);
        }
        byte[] buf = new byte[sliceSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
        if (it.isLittleEndian()) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        if (!Volume.isDisableRGB() && numType == 6) {
            this.setRGBMode(true);
            this.nativeDataType = true;
        }
        block11: for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
            int multiFileIndex;
            ByteBuffer workBuffer = this.workBuffers[ctrT];
            for (int ctrS = 0; ctrS < numFilesPerVolume && (multiFileIndex = ctrT * numFilesPerVolume + ctrS) < multiFile.length; ++ctrS) {
                BufferedInputStream input = null;
                try {
                    boolean fileIsReadable;
                    URI file = multiFile[multiFileIndex];
                    boolean bl = fileIsReadable = FileUtilities.exists((URI)file) && FileUtilities.canRead((URI)file);
                    if (fileIsReadable) {
                        long bytesSkipped;
                        input = FileUtilities.getInputStream((URI)file, (boolean)false);
                        long bytesToSkip = multiImageOffset[multiFileIndex];
                        for (long totalBytesSkipped = bytesSkipped = input.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                            bytesSkipped = input.skip(bytesToSkip - totalBytesSkipped);
                        }
                        for (int ctr = 0; ctr < iterations; ++ctr) {
                            int c;
                            int b;
                            int a;
                            int ctrV;
                            int bytesRead;
                            for (int totalBytesRead = bytesRead = input.read(buf); totalBytesRead < sliceSize; totalBytesRead += bytesRead) {
                                bytesRead = input.read(buf, totalBytesRead, sliceSize - totalBytesRead);
                            }
                            if (numBytes == 1 && (numType == 3 || numType == 2)) {
                                for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                    workBuffer.putFloat((long)byteBuffer.get(ctrV * numBytes) & mask);
                                }
                                continue;
                            }
                            if (numBytes == 2 && (numType == 3 || numType == 2)) {
                                for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                    workBuffer.putFloat((long)byteBuffer.getShort(ctrV * numBytes) & mask);
                                }
                                continue;
                            }
                            if (numBytes == 4 && (numType == 3 || numType == 2)) {
                                for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                    workBuffer.putFloat((long)byteBuffer.getInt(ctrV * numBytes) & mask);
                                }
                                continue;
                            }
                            if (numBytes == 4 && numType == 4) {
                                for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                    workBuffer.putFloat(byteBuffer.getFloat(ctrV * numBytes));
                                }
                                continue;
                            }
                            if (numType != 6) continue;
                            if (this.isRGBMode) {
                                for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                    a = 0xFF & byteBuffer.get(ctrV * numBytes);
                                    b = 0xFF & byteBuffer.get(ctrV * numBytes + 1);
                                    c = 0xFF & byteBuffer.get(ctrV * numBytes + 2);
                                    workBuffer.putInt(c | b << 8 | a << 16);
                                }
                                continue;
                            }
                            for (ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                                a = 0xFF & byteBuffer.get(ctrV * numBytes);
                                b = 0xFF & byteBuffer.get(ctrV * numBytes + 1);
                                c = 0xFF & byteBuffer.get(ctrV * numBytes + 2);
                                workBuffer.putFloat((float)(a + b + c) / 3.0f);
                            }
                        }
                        continue;
                    }
                    for (int ctr = 0; ctr < iterations; ++ctr) {
                        for (int ctrV = 0; ctrV < numVoxelsInSlice; ++ctrV) {
                            workBuffer.putFloat(0.0f);
                        }
                    }
                    continue;
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                    error = true;
                    continue block11;
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    input = null;
                }
            }
        }
        if (reverting) {
            this.listener.imageRevertedToSaved(!error);
        }
    }

    private void copyFileToWorkBuffer(final URI file, final ImageDimensions id, final ImageType it, final boolean reverting, final boolean forceLoadInThread) {
        int numTimepoints = id.getTimepoints();
        if (!reverting) {
            this.makeWorkBuffer(id.getNumVoxelsVolume() * 4, numTimepoints);
        }
        if (numTimepoints > 1) {
            if (cli || forceLoadInThread) {
                this.doCopyFileToWorkBuffer(file, id, it, false, false, false, forceLoadInThread);
            } else {
                this.doCopyFileToWorkBuffer(file, id, it, reverting, false, true, forceLoadInThread);
                Thread workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Image.this.doCopyFileToWorkBuffer(file, id, it, reverting, true, false, forceLoadInThread);
                    }
                }, "Image.copyFileToWorkBuffer() Thread");
                workThread.start();
            }
        } else {
            this.doCopyFileToWorkBuffer(file, id, it, reverting, false, false, forceLoadInThread);
        }
    }

    private void copyNativeTypeToWorkBuffer(URI file, ImageDimensions id, ImageType it) {
        this.makeWorkBuffer(id.getNumVoxelsVolume() * it.getNumBytesPerVoxel(), id.getTimepoints());
        this.doCopyNativeTypeToWorkBuffer(file, id, it, it.isCompressed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyFileToWorkBuffer(URI file, ImageDimensions id, ImageType it, boolean reverting, boolean loadingInBackground, boolean forceFirstOnly, boolean forceLoadInThread) {
        BufferedInputStream input = null;
        int numBytes = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        long mask = it.createBitMask();
        boolean fileIsReadable = !FileUtilities.uriIsFile((URI)file) || new File(file).exists() && new File(file).canRead();
        int numTimepointsImage = id.getTimepoints();
        int numSlices = id.getSlices();
        int sliceSize = id.getCols() * id.getRows();
        this.setBackgroundLoading(loadingInBackground);
        int skip = 0;
        int minT = 0;
        int maxT = id.getTimepoints() - 1;
        if (forceFirstOnly) {
            maxT = 0;
            minT = 0;
        } else if (!(cli || forceLoadInThread || forceFirstOnly || numTimepointsImage <= 1)) {
            skip = id.getNumVoxelsVolume() * numBytes;
            minT = 1;
        }
        if (!Volume.isDisableRGB() && numType == 6) {
            this.setRGBMode(true);
            this.nativeDataType = true;
        }
        try {
            if (fileIsReadable) {
                long bytesSkipped;
                input = FileUtilities.getInputStream((URI)file, (boolean)it.isCompressed());
                long bytesToSkip = id.getImageOffset() + skip;
                for (long totalBytesSkipped = bytesSkipped = input.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = input.skip(bytesToSkip - totalBytesSkipped);
                }
                byte[] bufferArray = new byte[sliceSize * numBytes];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bufferArray);
                if (it.isLittleEndian()) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                if (reverting) {
                    this.rewindWorkBuffers();
                }
                float[] floatArray = new float[sliceSize];
                for (int ctrT = minT; ctrT <= maxT; ++ctrT) {
                    FloatBuffer workBuffer = this.workBuffers[ctrT].asFloatBuffer();
                    if (loadingInBackground != this.backgroundLoading) break;
                    for (int ctrS = 0; ctrS < numSlices; ++ctrS) {
                        int floatIndex = 0;
                        int totalBytesRead = input.read(bufferArray);
                        if (totalBytesRead != -1) {
                            while (totalBytesRead < bufferArray.length) {
                                totalBytesRead += input.read(bufferArray, totalBytesRead, bufferArray.length - totalBytesRead);
                            }
                        }
                        for (int ctr = 0; ctr < sliceSize; ++ctr) {
                            int c;
                            int b;
                            int a;
                            if (numBytes == 1 && (numType == 3 || numType == 2)) {
                                floatArray[floatIndex++] = (long)byteBuffer.get(ctr * numBytes) & mask;
                                continue;
                            }
                            if (numBytes == 2 && (numType == 3 || numType == 2)) {
                                floatArray[floatIndex++] = (long)byteBuffer.getShort(ctr * numBytes) & mask;
                                continue;
                            }
                            if (numBytes == 4 && (numType == 3 || numType == 2)) {
                                floatArray[floatIndex++] = (long)byteBuffer.getInt(ctr * numBytes) & mask;
                                continue;
                            }
                            if (numBytes == 4 && numType == 4) {
                                floatArray[floatIndex++] = byteBuffer.getFloat(ctr * numBytes);
                                continue;
                            }
                            if (numBytes == 8 && (numType == 3 || numType == 2)) {
                                floatArray[floatIndex++] = byteBuffer.getLong(ctr * numBytes) & mask;
                                continue;
                            }
                            if (numBytes == 8 && numType == 4) {
                                floatArray[floatIndex++] = (float)byteBuffer.getDouble(ctr * numBytes);
                                continue;
                            }
                            if (numType != 6) continue;
                            if (this.isRGBMode) {
                                a = 0xFF & byteBuffer.get(ctr * numBytes);
                                b = 0xFF & byteBuffer.get(ctr * numBytes + 1);
                                c = 0xFF & byteBuffer.get(ctr * numBytes + 2);
                                floatArray[floatIndex++] = Float.intBitsToFloat(c | b << 8 | a << 16);
                                continue;
                            }
                            a = 0xFF & byteBuffer.get(ctr * numBytes);
                            b = 0xFF & byteBuffer.get(ctr * numBytes + 1);
                            c = 0xFF & byteBuffer.get(ctr * numBytes + 2);
                            floatArray[floatIndex++] = (float)(a + b + c) / 3.0f;
                        }
                        workBuffer.put(floatArray);
                    }
                    if (!loadingInBackground) continue;
                    this.listener.volumeDataLoaded(ctrT);
                }
                if (reverting) {
                    this.listener.imageRevertedToSaved(true);
                }
                if (loadingInBackground) {
                    this.listener.volumeDataLoaded(numTimepointsImage - 1);
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            if (reverting) {
                this.listener.imageRevertedToSaved(false);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            AppLogger.error((Throwable)ex);
            if (reverting) {
                this.listener.imageRevertedToSaved(false);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyNativeTypeToWorkBuffer(URI file, ImageDimensions id, ImageType it, boolean isCompressed) {
        BufferedInputStream input = null;
        int numBytes = it.getNumBytesPerVoxel();
        boolean fileIsReadable = !FileUtilities.uriIsFile((URI)file) || new File(file).exists() && new File(file).canRead();
        int numSlices = id.getSlices();
        int sliceSize = id.getCols() * id.getRows();
        boolean skip = false;
        boolean minT = false;
        int maxT = id.getTimepoints() - 1;
        try {
            if (fileIsReadable) {
                long bytesSkipped;
                input = FileUtilities.getInputStream((URI)file, (boolean)isCompressed);
                long bytesToSkip = id.getImageOffset() + 0;
                for (long totalBytesSkipped = bytesSkipped = input.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = input.skip(bytesToSkip - totalBytesSkipped);
                }
                byte[] bufferArray = new byte[sliceSize * numBytes];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bufferArray);
                if (it.isLittleEndian()) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                byte[] byteArray = null;
                short[] shortArray = null;
                int[] intArray = null;
                long[] longArray = null;
                if (numBytes == 1) {
                    byteArray = new byte[sliceSize];
                } else if (numBytes == 2) {
                    shortArray = new short[sliceSize];
                } else if (numBytes == 4) {
                    intArray = new int[sliceSize];
                } else if (numBytes == 8) {
                    longArray = new long[sliceSize];
                }
                for (int ctrT = 0; ctrT <= maxT; ++ctrT) {
                    ByteBuffer byteArrayBuffer = null;
                    ShortBuffer shortArrayBuffer = null;
                    IntBuffer intArrayBuffer = null;
                    LongBuffer longArrayBuffer = null;
                    byteArrayBuffer = this.workBuffers[ctrT];
                    shortArrayBuffer = this.workBuffers[ctrT].asShortBuffer();
                    intArrayBuffer = this.workBuffers[ctrT].asIntBuffer();
                    longArrayBuffer = this.workBuffers[ctrT].asLongBuffer();
                    for (int ctrS = 0; ctrS < numSlices; ++ctrS) {
                        int index = 0;
                        int totalBytesRead = input.read(bufferArray);
                        if (totalBytesRead != -1) {
                            while (totalBytesRead < bufferArray.length) {
                                totalBytesRead += input.read(bufferArray, totalBytesRead, bufferArray.length - totalBytesRead);
                            }
                        }
                        for (int ctr = 0; ctr < sliceSize; ++ctr) {
                            if (numBytes == 1) {
                                byteArray[index++] = byteBuffer.get(ctr * numBytes);
                                continue;
                            }
                            if (numBytes == 2) {
                                shortArray[index++] = byteBuffer.getShort(ctr * numBytes);
                                continue;
                            }
                            if (numBytes == 4) {
                                intArray[index++] = byteBuffer.getInt(ctr * numBytes);
                                continue;
                            }
                            if (numBytes != 8) continue;
                            longArray[index++] = byteBuffer.getLong(ctr * numBytes);
                        }
                        if (numBytes == 1) {
                            byteArrayBuffer.put(byteArray);
                            continue;
                        }
                        if (numBytes == 2) {
                            shortArrayBuffer.put(shortArray);
                            continue;
                        }
                        if (numBytes == 4) {
                            intArrayBuffer.put(intArray);
                            continue;
                        }
                        if (numBytes != 8) continue;
                        longArrayBuffer.put(longArray);
                    }
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteWorkBufferToCompressedFile(File outfile, VoxelValue voxelValue, ImageDimensions id, ImageType it, byte[] headerArray, boolean sameThread) {
        int numBytesLoaded;
        long numVoxelsTimeseries = id.getNumVoxelsTimeseries();
        int numBytesOriginal = numBytesLoaded = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        if (numBytesLoaded == 3 && numType == 6) {
            numBytesLoaded = 4;
        }
        long numIterations = numVoxelsTimeseries * (long)numBytesLoaded / 6144L;
        int remainder = (int)(numVoxelsTimeseries * (long)numBytesLoaded) % 6144;
        int numVoxelsPerIteration = 6144 / numBytesLoaded;
        int numVoxelsInRemainder = remainder / numBytesLoaded;
        boolean littleEndianByteOrder = it.isLittleEndian();
        boolean error = false;
        ProgressBar pb = new ProgressBar(this.pbListener, "Writing file");
        pb.init(0, 0, (int)numIterations);
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outfile)));
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer);
            if (littleEndianByteOrder) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (CollectionUtilities.isNotEmpty((Object)headerArray)) {
                output.write(headerArray);
            }
            int ctr = 0;
            while ((long)ctr < numIterations) {
                int ctrBytes;
                pb.setValue(ctr);
                long offset = ctr * numVoxelsPerIteration;
                byteBuffer.rewind();
                if (numBytesOriginal == 1 && (numType == 3 || numType == 2)) {
                    for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                        byteBuffer.put((byte)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytesOriginal == 2 && (numType == 3 || numType == 2)) {
                    for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                        byteBuffer.putShort((short)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytesOriginal == 4 && (numType == 3 || numType == 2)) {
                    for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                        byteBuffer.putInt((int)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytesOriginal == 4 && numType == 4) {
                    for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                        byteBuffer.putFloat((float)voxelValue.getRawValueForOffset(offset + (long)ctrBytes));
                    }
                } else if (numBytesOriginal == 3 && numType == 6) {
                    for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                        long value = voxelValue.getNativeIntegerValueAt((int)(offset + (long)ctrBytes));
                        byteBuffer.put((byte)(value >> 16 & 0xFFL));
                        byteBuffer.put((byte)(value >> 8 & 0xFFL));
                        byteBuffer.put((byte)(value >> 0 & 0xFFL));
                    }
                }
                output.write(this.buffer);
                ++ctr;
            }
            long offset = numIterations * (long)numVoxelsPerIteration;
            byteBuffer.rewind();
            if (numBytesOriginal == 1 && (numType == 3 || numType == 2)) {
                for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                    byteBuffer.put((byte)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                }
            } else if (numBytesOriginal == 2 && (numType == 3 || numType == 2)) {
                for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                    byteBuffer.putShort((short)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                }
            } else if (numBytesOriginal == 4 && (numType == 3 || numType == 2)) {
                for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                    byteBuffer.putInt((int)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                }
            } else if (numBytesOriginal == 4 && numType == 4) {
                for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                    byteBuffer.putFloat((float)voxelValue.getRawValueForOffset(offset + (long)ctrBytes));
                }
            } else if (numBytesOriginal == 3 && numType == 6) {
                for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                    long value = voxelValue.getNativeIntegerValueAt((int)(offset + (long)ctrBytes));
                    byteBuffer.put((byte)(value >> 16 & 0xFFL));
                    byteBuffer.put((byte)(value >> 8 & 0xFFL));
                    byteBuffer.put((byte)(value >> 0 & 0xFFL));
                }
            }
            output.write(this.buffer, 0, remainder);
            pb.setIndeterminateMode(true);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            error = true;
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            error = true;
        }
        finally {
            pb.setValue(pb.getMax());
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (this.listener != null) {
            this.listener.imageSaved(!error, false, pb, null, false, sameThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteWorkBufferToFile(File outfile, VoxelValue voxelValue, ImageDimensions id, ImageType it, byte[] headerArray, boolean imageIsDirty, boolean sameThread) {
        long numVoxels = id.getNumVoxelsTimeseries();
        int numBytes = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        long numIterations = numVoxels * (long)numBytes / 6144L;
        int remainder = (int)(numVoxels * (long)numBytes % 6144L);
        int numVoxelsPerIteration = 6144 / numBytes;
        int numVoxelsInRemainder = remainder / numBytes;
        boolean littleEndianByteOrder = it.isLittleEndian();
        boolean error = false;
        ProgressBar pb = new ProgressBar(this.pbListener, "Writing file");
        pb.init(0, 0, (int)numIterations);
        RandomAccessFile output = null;
        try {
            output = new RandomAccessFile(outfile, "rw");
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer);
            if (littleEndianByteOrder) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (CollectionUtilities.isNotEmpty((Object)headerArray)) {
                output.write(headerArray);
            } else {
                output.seek(id.getImageOffset());
            }
            if (imageIsDirty) {
                int ctr = 0;
                while ((long)ctr < numIterations) {
                    int ctrBytes;
                    pb.setValue(ctr);
                    long offset = ctr * numVoxelsPerIteration;
                    byteBuffer.rewind();
                    if (numBytes == 1 && (numType == 3 || numType == 2)) {
                        for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                            byteBuffer.put((byte)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                        }
                    } else if (numBytes == 2 && (numType == 3 || numType == 2)) {
                        for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                            byteBuffer.putShort((short)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                        }
                    } else if (numBytes == 4 && (numType == 3 || numType == 2)) {
                        for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                            byteBuffer.putInt((int)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                        }
                    } else if (numBytes == 4 && numType == 4) {
                        for (ctrBytes = 0; ctrBytes < numVoxelsPerIteration; ++ctrBytes) {
                            byteBuffer.putFloat((float)voxelValue.getRawValueForOffset(offset + (long)ctrBytes));
                        }
                    }
                    output.write(this.buffer);
                    ++ctr;
                }
                long offset = numIterations * (long)numVoxelsPerIteration;
                byteBuffer.rewind();
                if (numBytes == 1 && (numType == 3 || numType == 2)) {
                    for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                        byteBuffer.put((byte)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytes == 2 && (numType == 3 || numType == 2)) {
                    for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                        byteBuffer.putShort((short)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytes == 4 && (numType == 3 || numType == 2)) {
                    for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                        byteBuffer.putInt((int)Math.round(voxelValue.getRawValueForOffset(offset + (long)ctrBytes)));
                    }
                } else if (numBytes == 4 && numType == 4) {
                    for (int ctrBytes = 0; ctrBytes < numVoxelsInRemainder; ++ctrBytes) {
                        byteBuffer.putFloat((float)voxelValue.getRawValueForOffset(offset + (long)ctrBytes));
                    }
                }
                output.write(this.buffer, 0, remainder);
            }
            pb.setIndeterminateMode(true);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            error = true;
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            error = true;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (this.listener != null) {
            this.listener.imageSaved(!error, false, pb, null, false, sameThread);
        }
    }

    private void makeWorkBuffer(int volSizeInBytes, int numTimepoints) {
        ByteBuffer[] buffersNew = null;
        if (this.workBuffers != null && this.workBuffers.length == numTimepoints) {
            boolean allValidSize = true;
            for (int ctr = 0; ctr < numTimepoints; ++ctr) {
                this.workBuffers[ctr].rewind();
                if (this.workBuffers[ctr].limit() == volSizeInBytes) continue;
                allValidSize = false;
                break;
            }
            if (allValidSize) {
                buffersNew = this.workBuffers;
            }
        }
        if (buffersNew == null) {
            buffersNew = Image.makeBuffers(volSizeInBytes, numTimepoints);
        }
        this.workBuffers = buffersNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readASCIIFileToWorkBuffer(URI file, ImageDimensions id, boolean reverting) {
        BufferedInputStream input = null;
        int numVoxelsVolume = id.getNumVoxelsVolume();
        int voxelCtr = 0;
        try {
            boolean fileIsReadable;
            ByteBuffer workBuffer = this.workBuffers[0];
            boolean bl = fileIsReadable = FileUtilities.exists((URI)file) && FileUtilities.canRead((URI)file);
            if (!reverting || !fileIsReadable) {
                this.makeWorkBuffer(numVoxelsVolume * 4, 1);
            } else {
                workBuffer.rewind();
            }
            if (fileIsReadable) {
                long bytesSkipped;
                input = FileUtilities.getInputStream((URI)file, (boolean)false);
                long bytesToSkip = id.getImageOffset();
                for (long totalBytesSkipped = bytesSkipped = input.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = input.skip(bytesToSkip - totalBytesSkipped);
                }
                String currentToken = "";
                int bytesRead = input.read(this.buffer);
                while (bytesRead != -1 && voxelCtr < numVoxelsVolume) {
                    StringTokenizer tokenizer = new StringTokenizer(currentToken + new String(this.buffer, 0, bytesRead));
                    currentToken = tokenizer.nextToken();
                    while (tokenizer.hasMoreTokens() && voxelCtr < numVoxelsVolume) {
                        workBuffer.putFloat(Float.parseFloat(currentToken));
                        ++voxelCtr;
                        currentToken = tokenizer.nextToken();
                    }
                    bytesRead = input.read(this.buffer);
                }
                if (voxelCtr < numVoxelsVolume) {
                    if (reverting) {
                        float temp = Float.parseFloat(currentToken);
                        workBuffer.putFloat(temp);
                    } else {
                        workBuffer.putFloat(Float.parseFloat(currentToken));
                    }
                }
            }
            if (reverting) {
                this.listener.imageRevertedToSaved(true);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            if (reverting) {
                this.listener.imageRevertedToSaved(false);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    private void rewindWorkBuffers() {
        if (this.workBuffers != null) {
            for (ByteBuffer workBuffer : this.workBuffers) {
                workBuffer.rewind();
            }
        }
    }

    protected void clear() {
        this.workBuffers = null;
        this.tempBuffer = null;
        this.listener = null;
        this.pbListener = null;
    }

    protected void copyDataToTempBuffer(int timepoint, int numVoxels, int numBytes) {
        if (timepoint < this.workBuffers.length) {
            int sizePerTimepoint = numVoxels * numBytes;
            int numIterations = sizePerTimepoint / 6144;
            int remainder = sizePerTimepoint % 6144;
            ByteBuffer workBuffer = this.workBuffers[timepoint];
            workBuffer.position(0);
            this.tempBuffer.position(0);
            for (int ctr = 0; ctr < numIterations; ++ctr) {
                workBuffer.get(this.buffer);
                this.tempBuffer.put(this.buffer);
            }
            if (remainder > 0) {
                workBuffer.get(this.buffer, 0, remainder);
                this.tempBuffer.put(this.buffer, 0, remainder);
            }
            for (ByteBuffer workBuffer2 : this.workBuffers) {
                workBuffer2.position(0);
            }
            this.tempBuffer.position(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer doWriteWorkBufferToFile(File outputFile, byte[] headerArray, Volume volume, VoxelValue voxelValue, ClusterFilter clusterFilter, int transformNum, boolean useTransform, boolean isWorldMode, boolean isInverse, boolean orientationChanged, String newOrientation, Coordinate origin, ImageDimensions id, ImageBounds ib, double resliceX, double resliceY, double resliceZ, double resliceT, double timeSize, ImageType it, boolean overwriting, boolean applyDataScalesVal, boolean isOverlayMode, boolean overlayMMmode, int overlayMMtransform, boolean nearestNeighbor, boolean trilinear, boolean sync, boolean useThreshold, double threshold, boolean useMix, boolean fitPrecision, boolean maintainZero, boolean fixPrecision, boolean isCopy, int imageTrailer, boolean savingMultiFileSeries, boolean forceCompression, boolean skipNotify, boolean sameThread) {
        int zAdd;
        int zMultiply;
        int yAdd;
        int yMultiply;
        int xAdd;
        int xMultiply;
        int currentTransform;
        int timepointsOld;
        ByteBuffer outputBuffer = null;
        Volume currentVol = null;
        boolean applyDataScales = applyDataScalesVal;
        int numBytes = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        boolean littleEndianByteOrder = it.isLittleEndian();
        if (isCopy) {
            numBytes = 4;
            numType = 4;
            littleEndianByteOrder = false;
        }
        if ((timepointsOld = id.getTimepoints()) < 1) {
            timepointsOld = 1;
        }
        int xDimNew = ib.getMaxX() - ib.getMinX() + 1;
        int yDimNew = ib.getMaxY() - ib.getMinY() + 1;
        int zDimNew = ib.getMaxZ() - ib.getMinZ() + 1;
        int xDimNewStart = ib.getMinX();
        int yDimNewStart = ib.getMinY();
        int zDimNewStart = ib.getMinZ();
        int numVoxels = xDimNew * yDimNew * zDimNew;
        int tStart = ib.getMinT();
        int tEnd = ib.getMaxT();
        int tDim = tEnd - tStart + 1;
        if (tDim < 1) {
            tDim = 1;
        }
        double xSize = resliceX;
        double ySize = resliceY;
        double zSize = resliceZ;
        double tSize = resliceT;
        boolean variableTiming = volume.isVariableVolumeTiming();
        if (variableTiming) {
            tSize = timeSize;
        } else if (tSize == 0.0) {
            tSize = 1.0;
        }
        double oldTotalTime = volume.getRealTimeAcrossVolumes();
        Volume overlay = null;
        if (isOverlayMode) {
            currentVol = overlay = clusterFilter.getVolume();
            currentTransform = overlayMMtransform;
            applyDataScales = true;
        } else {
            currentVol = volume;
            currentTransform = transformNum;
        }
        double imageMax = currentVol.getImageMax();
        double imageMin = currentVol.getImageMin();
        double typeUnsignedMax = it.getTypeMax(true);
        double typeUnsignedMin = it.getTypeMin(true);
        double typeRealMin = it.getTypeMin(false);
        double typeImageOffset = 0.0;
        double typeImageRatio = 0.0;
        double ovlyMixRatio = 0.0;
        double anatMixRatio = 0.0;
        double mixDiff = 0.0;
        if (fitPrecision) {
            if (maintainZero) {
                double imagePositive = 0.0;
                double imageNegative = 0.0;
                double imageRange = 0.0;
                if (imageMax > 0.0) {
                    imagePositive = imageMax;
                }
                if (imageMin < 0.0) {
                    imageNegative = Math.abs(imageMin);
                }
                imageRange = imagePositive > imageNegative ? imagePositive * 2.0 : Math.abs(imageNegative) * 2.0;
                double typeRange = typeUnsignedMax - typeUnsignedMin;
                typeImageRatio = typeRange / imageRange;
                typeImageOffset = 0.0;
            } else if (fixPrecision) {
                typeImageRatio = 1.0;
                if (it.getByteType() == 2) {
                    typeImageOffset = 0.0;
                } else if (it.getByteType() == 3) {
                    typeImageOffset = it.getTypeMin(false, true);
                }
            } else {
                double imageRange = imageMax - imageMin;
                double typeRange = typeUnsignedMax - typeUnsignedMin;
                typeImageRatio = typeRange / imageRange;
                typeImageOffset = imageMin - typeUnsignedMin;
            }
        } else if (useMix) {
            double anatDiff = Math.abs(volume.getImageMax() - volume.getImageMin());
            double ovlyDiff = Math.abs(overlay.getImageMax() - threshold);
            if (it.getNumBytesPerVoxel() == 1) {
                mixDiff = 63.0;
            } else if (it.getNumBytesPerVoxel() == 2) {
                mixDiff = 16383.0;
            } else if (it.getNumBytesPerVoxel() == 4) {
                mixDiff = 1.073741823E9;
            }
            anatMixRatio = anatDiff / mixDiff;
            ovlyMixRatio = ovlyDiff / mixDiff;
        }
        int imageOffset = CollectionUtilities.isNotEmpty((Object)headerArray) ? headerArray.length : 0;
        int zIncrement = 0;
        int yIncrement = 0;
        int xIncrement = 0;
        if (newOrientation.charAt(0) == 'X') {
            xIncrement = 1;
        } else if (newOrientation.charAt(0) == 'Y') {
            yIncrement = 1;
        } else if (newOrientation.charAt(0) == 'Z') {
            zIncrement = 1;
        }
        if (newOrientation.charAt(1) == 'X') {
            if (newOrientation.charAt(0) == 'Y') {
                xIncrement = yDimNew;
            } else if (newOrientation.charAt(0) == 'Z') {
                xIncrement = zDimNew;
            }
        } else if (newOrientation.charAt(1) == 'Y') {
            if (newOrientation.charAt(0) == 'X') {
                yIncrement = xDimNew;
            } else if (newOrientation.charAt(0) == 'Z') {
                yIncrement = zDimNew;
            }
        } else if (newOrientation.charAt(1) == 'Z') {
            if (newOrientation.charAt(0) == 'X') {
                zIncrement = xDimNew;
            } else if (newOrientation.charAt(0) == 'Y') {
                zIncrement = yDimNew;
            }
        }
        if (newOrientation.charAt(2) == 'X') {
            xIncrement = yDimNew * zDimNew;
        } else if (newOrientation.charAt(2) == 'Y') {
            yIncrement = xDimNew * zDimNew;
        } else if (newOrientation.charAt(2) == 'Z') {
            zIncrement = xDimNew * yDimNew;
        }
        if (newOrientation.charAt(newOrientation.indexOf(88) + 3) == '+') {
            xMultiply = 1;
            xAdd = 0;
        } else {
            xMultiply = -1;
            xAdd = xDimNew - 1;
        }
        if (newOrientation.charAt(newOrientation.indexOf(89) + 3) == '-') {
            yMultiply = 1;
            yAdd = 0;
        } else {
            yMultiply = -1;
            yAdd = yDimNew - 1;
        }
        if (newOrientation.charAt(newOrientation.indexOf(90) + 3) == '-') {
            zMultiply = 1;
            zAdd = 0;
        } else {
            zMultiply = -1;
            zAdd = zDimNew - 1;
        }
        this.pb = null;
        if (!savingMultiFileSeries && this.pbListener != null && !skipNotify) {
            this.pb = new ProgressBar(this.pbListener, "Writing file");
        }
        try {
            outputBuffer = ByteBuffer.allocateDirect(imageOffset + numVoxels * (isCopy ? tDim : 1) * numBytes + imageTrailer);
            if (littleEndianByteOrder) {
                outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                outputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (CollectionUtilities.isNotEmpty((Object)headerArray)) {
                outputBuffer.put(headerArray);
            }
            if (this.pb != null) {
                this.pb.init(0, 0, zDimNew * tDim);
            }
            FilterOutputStream output = null;
            try {
                if ((it.isCompressed() || forceCompression) && !isCopy) {
                    output = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)));
                } else if (!isCopy) {
                    output = new BufferedOutputStream(new FileOutputStream(outputFile));
                }
                for (int ctrT = 0; ctrT < tDim; ++ctrT) {
                    int timeOffsetOut = ctrT * xDimNew * yDimNew * zDimNew;
                    for (int ctrZ = 0; ctrZ < zDimNew; ++ctrZ) {
                        for (int ctrY = 0; ctrY < yDimNew; ++ctrY) {
                            for (int ctrX = 0; ctrX < xDimNew; ++ctrX) {
                                int offsetFile;
                                if (this.nativeDataType) {
                                    long value = currentVol.getNativeIntegerValueAtIndex(ctrX, ctrY, ctrZ, ctrT) & this.nativeDataTypeSaveMask;
                                    offsetFile = imageOffset + ((ctrX * xMultiply + xAdd) * xIncrement + (ctrY * yMultiply + yAdd) * yIncrement + (ctrZ * zMultiply + zAdd) * zIncrement + (isCopy ? ctrT * timeOffsetOut : 0)) * numBytes;
                                    if (numBytes == 1) {
                                        outputBuffer.put(offsetFile, (byte)value);
                                        continue;
                                    }
                                    if (numBytes == 2) {
                                        outputBuffer.putShort(offsetFile, (short)value);
                                        continue;
                                    }
                                    if (numBytes == 3) {
                                        outputBuffer.put(offsetFile, (byte)(value >> 16 & 0xFFL));
                                        outputBuffer.put(offsetFile + 1, (byte)(value >> 8 & 0xFFL));
                                        outputBuffer.put(offsetFile + 2, (byte)(value >> 0 & 0xFFL));
                                        continue;
                                    }
                                    if (numBytes == 4) {
                                        outputBuffer.putInt(offsetFile, (int)value);
                                        continue;
                                    }
                                    if (numBytes != 8) continue;
                                    outputBuffer.putLong(offsetFile, value);
                                    continue;
                                }
                                double value = !variableTiming && (double)tStart + (double)ctrT * tSize >= (double)timepointsOld ? 0.0 : (variableTiming && (double)tStart + (double)ctrT * tSize >= oldTotalTime ? 0.0 : (isWorldMode ? currentVol.getVoxelValueAtCoordinate((double)(ctrX + xDimNewStart - origin.xInt) * xSize, (double)(origin.yInt - (ctrY + yDimNewStart)) * ySize, (double)(origin.zInt - (ctrZ + zDimNewStart)) * zSize, (double)tStart + (double)ctrT * tSize, transformNum, useTransform, applyDataScales, nearestNeighbor, trilinear, sync) : currentVol.getVoxelValueAtMM((double)(ctrX + xDimNewStart) * xSize, (double)(ctrY + yDimNewStart) * ySize, (double)(ctrZ + zDimNewStart) * zSize, (double)tStart + (double)ctrT * tSize, applyDataScales, currentTransform != -1, currentTransform, nearestNeighbor, trilinear, sync)));
                                if (useThreshold) {
                                    if (value < threshold) {
                                        value = 0.0;
                                    } else if (!clusterFilter.passesClusterFilter(ctrX, ctrY, ctrZ, xDimNew + 1, yDimNew + 1)) {
                                        value = 0.0;
                                    }
                                }
                                if (fitPrecision) {
                                    value = maintainZero ? (typeRealMin == 0.0 && value <= 0.0 ? 0.0 : (value *= typeImageRatio)) : (value - typeImageOffset) * typeImageRatio + typeRealMin;
                                } else if (useMix) {
                                    double anatValue = (double)tStart + (double)ctrT * tSize >= (double)timepointsOld ? 0.0 : (isWorldMode ? volume.getVoxelValueAtCoordinate((double)(ctrX + xDimNewStart - origin.xInt) * xSize, (double)(origin.yInt - (ctrY + yDimNewStart)) * ySize, (double)(origin.zInt - (ctrZ + zDimNewStart)) * zSize, (double)tStart + (double)ctrT * tSize, transformNum, useTransform, applyDataScales, nearestNeighbor, trilinear, sync) : volume.getVoxelValueAtMM((double)(ctrX + xDimNewStart) * xSize, (double)(ctrY + yDimNewStart) * ySize, (double)(ctrZ + zDimNewStart) * zSize, (double)tStart + (double)ctrT * tSize, applyDataScales, false, overlayMMtransform, nearestNeighbor, trilinear, sync));
                                    value = value != 0.0 ? (value - threshold) / ovlyMixRatio + mixDiff : anatValue / anatMixRatio;
                                }
                                offsetFile = imageOffset + ((ctrX * xMultiply + xAdd) * xIncrement + (ctrY * yMultiply + yAdd) * yIncrement + (ctrZ * zMultiply + zAdd) * zIncrement + (isCopy ? ctrT * timeOffsetOut : 0)) * numBytes;
                                if (numBytes == 1 && (numType == 3 || numType == 2)) {
                                    outputBuffer.put(offsetFile, (byte)Math.round(value));
                                    continue;
                                }
                                if (numBytes == 2 && (numType == 3 || numType == 2)) {
                                    outputBuffer.putShort(offsetFile, (short)Math.round(value));
                                    continue;
                                }
                                if (numBytes == 4 && (numType == 3 || numType == 2)) {
                                    outputBuffer.putInt(offsetFile, (int)Math.round(value));
                                    continue;
                                }
                                if (numBytes != 4 || numType != 4) continue;
                                outputBuffer.putFloat(offsetFile, (float)value);
                            }
                        }
                        if (this.pb == null) continue;
                        this.pb.setValue(ctrZ + ctrT * zDimNew);
                    }
                    if (isCopy) continue;
                    boolean firstVolume = ctrT == 0;
                    int bufferSize = outputBuffer.limit() - (firstVolume ? 0 : imageOffset);
                    int numIterations = bufferSize / 6144;
                    int numRemainder = bufferSize % 6144;
                    outputBuffer.rewind();
                    if (!firstVolume) {
                        outputBuffer.position(imageOffset);
                    }
                    for (int ctr = 0; ctr < numIterations; ++ctr) {
                        outputBuffer.get(this.buffer);
                        output.write(this.buffer);
                    }
                    outputBuffer.get(this.buffer, 0, numRemainder);
                    ((BufferedOutputStream)output).write(this.buffer, 0, numRemainder);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            if (this.pb != null) {
                this.pb.setIndeterminateMode(true);
            }
            if (!savingMultiFileSeries && !skipNotify) {
                this.listener.imageSaved(true, true, this.pb, overlay, isCopy, sameThread);
            }
        }
        catch (FileNotFoundException ex) {
            if (this.pb != null) {
                this.pb.setValue(this.pb.getMax());
            }
            AppLogger.error((Throwable)ex);
            this.listener.imageSaved(false, false, this.pb, null, isCopy, sameThread);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            this.listener.imageSaved(false, false, this.pb, null, isCopy, sameThread);
        }
        finally {
            this.nativeDataTypeSaveMask = -1L;
        }
        return outputBuffer;
    }

    protected void fixVariableSpacing(ImageDimensions id, VoxelDimensions vd, ImageRange ir, float[] sliceSpacing, float[] ratios) {
    }

    protected ByteBuffer[] getWorkBuffers() {
        return this.workBuffers;
    }

    protected boolean hasTempBuffer() {
        return this.tempBuffer != null;
    }

    protected ByteBuffer makeTempBuffer(int numVoxels, int numBytes) {
        try {
            this.tempBuffer = ByteBuffer.allocateDirect(numVoxels * numBytes);
            this.tempBuffer.order(ByteOrder.nativeOrder());
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            this.tempBuffer = ByteBuffer.allocate(numVoxels * numBytes);
        }
        return this.tempBuffer;
    }

    protected void readFile(Header header, URI file, boolean forceLoadInThread, boolean readOnly) throws VolumeIOException {
        ImageDimensions id = header.getImageDimensions();
        ImageType it = header.getImageType();
        boolean isAscii = it.isAscii();
        boolean isMultiFileFormat = header.isMultiFileFormat();
        this.readOnly = readOnly;
        if (readOnly && (it.getByteType() == 2 || it.getByteType() == 3)) {
            this.nativeDataType = true;
            this.copyNativeTypeToWorkBuffer(file, id, it);
        } else if (isAscii) {
            this.readASCIIFileToWorkBuffer(file, id, false);
        } else if (isMultiFileFormat) {
            this.concatenateToWorkBuffer(header.getMultiImageFiles(), header.getMultiImageOffsets(), id, it, false);
        } else {
            this.copyFileToWorkBuffer(file, id, it, false, forceLoadInThread);
        }
    }

    protected void setAsNativeIntegerType() {
        this.nativeDataType = true;
    }

    protected void writeDataToFile(File outfile, VoxelValue vv, Orientation orient, ImageDimensions id, ImageType it, byte[] headerArray) throws VolumeIOException {
        int ctr;
        int numVoxels = (int)id.getNumVoxelsTimeseries();
        int numBytes = it.getNumBytesPerVoxel();
        int numType = it.getByteType();
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(numVoxels * numBytes);
        if (it.isLittleEndian()) {
            newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            newBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        if (numBytes == 1 && (numType == 3 || numType == 2)) {
            for (ctr = 0; ctr < numVoxels; ++ctr) {
                newBuffer.put(ctr, (byte)Math.round(vv.getRawValueForOffset(ctr)));
            }
        } else if (numBytes == 2 && (numType == 3 || numType == 2)) {
            for (ctr = 0; ctr < numVoxels; ++ctr) {
                newBuffer.putShort(ctr * 2, (short)Math.round(vv.getRawValueForOffset(ctr)));
            }
        } else if (numBytes == 4 && (numType == 3 || numType == 2)) {
            for (ctr = 0; ctr < numVoxels; ++ctr) {
                newBuffer.putInt(ctr * 4, (int)Math.round(vv.getRawValueForOffset(ctr)));
            }
        } else if (numBytes == 4 && numType == 4) {
            for (ctr = 0; ctr < numVoxels; ++ctr) {
                newBuffer.putFloat(ctr * 4, (float)vv.getRawValueForOffset(ctr));
            }
        }
        FilterOutputStream output = null;
        try {
            output = it.isCompressed() ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outfile))) : new BufferedOutputStream(new FileOutputStream(outfile));
            int bufferSize = newBuffer.limit();
            int numIterations = bufferSize / 6144;
            int numRemainder = bufferSize % 6144;
            if (CollectionUtilities.isNotEmpty((Object)headerArray)) {
                output.write(headerArray);
            }
            newBuffer.rewind();
            for (int ctr2 = 0; ctr2 < numIterations; ++ctr2) {
                newBuffer.get(this.buffer);
                output.write(this.buffer);
            }
            newBuffer.get(this.buffer, 0, numRemainder);
            ((BufferedOutputStream)output).write(this.buffer, 0, numRemainder);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new VolumeIOException((Exception)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    protected void writeWorkBufferToFile(final File outfile, final byte[] headerArray, final Volume volume, final VoxelValue voxelValue, final ClusterFilter overlay, final int transformNum, final boolean useTransform, final boolean isWorldTransform, final boolean isInverse, final boolean orientationChanged, final String newOrientation, final Coordinate worldOrigin, final ImageDimensions id, final ImageBounds ib, final double resliceX, final double resliceY, final double resliceZ, final double resliceT, final double timeSize, final ImageType it, final boolean overwriting, final boolean applyDataScales, final boolean isOverlayMode, final boolean overlayMMmode, final int overlayMMtransform, final boolean nearestNeighbor, final boolean trilinear, final boolean sync, final boolean useThreshold, final double threshold, final boolean useMix, final boolean fitPrecision, final boolean maintainZero, final boolean fixPrecision, final int imageTrailer) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Image.this.doWriteWorkBufferToFile(outfile, headerArray, volume, voxelValue, overlay, transformNum, useTransform, isWorldTransform, isInverse, orientationChanged, newOrientation, worldOrigin, id, ib, resliceX, resliceY, resliceZ, resliceT, timeSize, it, overwriting, applyDataScales, isOverlayMode, overlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, false, imageTrailer, false, false, false, false);
            }
        }, "Image.writeWorkBufferToFile() Thread");
        workThread.start();
    }

    protected void writeWorkBufferToFile(final File outfile, final VoxelValue voxelValue, final ImageDimensions id, final ImageType it, final byte[] headerArray, final boolean imageIsDirty, final boolean sameThread) {
        if (sameThread) {
            if (it.isCompressed()) {
                this.doWriteWorkBufferToCompressedFile(outfile, voxelValue, id, it, headerArray, sameThread);
            } else {
                this.doWriteWorkBufferToFile(outfile, voxelValue, id, it, headerArray, imageIsDirty, sameThread);
            }
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (it.isCompressed()) {
                        Image.this.doWriteWorkBufferToCompressedFile(outfile, voxelValue, id, it, headerArray, sameThread);
                    } else {
                        Image.this.doWriteWorkBufferToFile(outfile, voxelValue, id, it, headerArray, imageIsDirty, sameThread);
                    }
                }
            }, "Image.writeWorkBufferToFile() Thread");
            workThread.start();
        }
    }

    public static boolean isCli() {
        return cli;
    }

    public static void setCli(boolean cli) {
        Image.cli = cli;
    }

    public boolean isRGBMode() {
        return this.isRGBMode;
    }

    public void setRGBMode(boolean isRGBMode) {
        this.isRGBMode = isRGBMode;
    }

    public long getNativeDataTypeSaveMask() {
        return this.nativeDataTypeSaveMask;
    }

    public void setNativeDataTypeSaveMask(long nativeDataTypeSaveMask) {
        this.nativeDataTypeSaveMask = nativeDataTypeSaveMask;
    }
}

