/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageIntent;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.analyze.AVW;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.formats.dicom.Parser;
import edu.uthscsa.ric.volume.formats.dicom.Series;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Header {
    private Coordinate origin;
    private Coordinate originOriginal;
    private ImageDescription imageDescription;
    private ImageDimensions imageDimensions;
    private ImageIntent imageIntent;
    private ImageRange imageRange;
    private ImageType imageType;
    private ReadableHeader readable;
    private String orientation;
    private URI imageFile;
    private VoxelDimensions voxelDimensions;
    private boolean oldReadableWarned;
    private int orientationCertainty;
    public static final List<String> COMMON_EXTENSIONS = CollectionUtilities.immutable((String[])new String[]{"des", "hdr", "nii", "dcm", "img", "nii.gz", "hdr.gz"});
    public static final List<String> COMMON_EXTENSIONS_SEPARATE_FILE = CollectionUtilities.immutable((String[])new String[]{"des", "hdr", "hdr.gz"});
    public static final List<String> EXTENSIONS_VALID_FOR_WRITING = CollectionUtilities.immutable((String[])new String[]{"des", "hdr", "nii"});
    public static final List<String> SKIP_EXTENSIONS_FOR_READING = CollectionUtilities.immutable((String[])new String[]{"roi.gz"});
    public static final List<String> SKIP_EXTENSIONS_FOR_READING_REASON = CollectionUtilities.immutable((String[])new String[]{"This is a ROI file.  Use File > Load ROI or drag\nthis file from the Image Browser on to an\nimage of the same dimensions."});
    public static final Vector<ReadableHeader> LOADED_READABLE_FORMATS = new Vector();
    public static final Vector<WritableHeader> LOADED_WRITABLE_FORMATS = new Vector();
    public static final double SLICE_SPACING_THRESHOLD = 0.05;
    public static final double VARIABLE_SPACING_FACTOR = 3.0;
    public static final double VOLUME_TIMING_THRESHOLD = 0.05;
    public static final int DICOM_SEARCH_SUBFOLDER_LIMIT = 4;
    public static final int ORIENTATION_CERTAINTY_HIGH = 2;
    public static final int ORIENTATION_CERTAINTY_LOW = 1;
    public static final int ORIENTATION_CERTAINTY_UNKNOWN = 0;
    public static final String DICOMDIR = "DICOMDIR";

    public static List<String> getWritableHeaderFormatNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (WritableHeader format : LOADED_WRITABLE_FORMATS) {
            names.add(format.getPluginName());
        }
        return names;
    }

    public static int calculateNumVolumesForVariableTiming(float[] volumeTiming, int numVolsVal) {
        double smallestTime;
        int numVols = numVolsVal;
        double timeAcrossVols = Header.getRealTimeAcrossVolumes(volumeTiming);
        int numVolsTemp = (int)Math.ceil(timeAcrossVols / (smallestTime = Header.getSmallestVolumeTiming(volumeTiming)));
        if ((double)numVolsTemp <= (double)numVols * 3.0) {
            numVols = numVolsTemp;
        }
        return numVols;
    }

    public static String detectHeaderType(File headerFile) {
        return Header.detectHeaderType(headerFile.toURI());
    }

    public static void doReadDICOMFolder(File dir, TreeMap<String, Vector<DICOM>> map, int levelVal) throws IOException {
        File[] files;
        int level = levelVal;
        if (++level > 4) {
            return;
        }
        if (dir.isDirectory() && (files = dir.listFiles((FileFilter)Series.DICOM_FILE_FILTER)) != null) {
            for (File file : files) {
                Vector<Object> value;
                if (file.isDirectory()) {
                    Header.doReadDICOMFolder(file, map, level);
                    continue;
                }
                Parser tempIO = new Parser(true);
                List elements = tempIO.parse(file.toURI());
                if (elements == null || elements.size() <= 0) continue;
                DICOM tempDicom = new DICOM();
                tempDicom.addElements(elements);
                tempDicom.setImageFile(file.toURI());
                String key = tempDicom.getSessionID() + tempDicom.getVolumeID();
                if (key == null || key.equals("")) continue;
                key = file.getParent() + key;
                if (map.containsKey(key)) {
                    value = map.get(key);
                    value.add(tempDicom);
                    continue;
                }
                value = new Vector();
                value.add(tempDicom);
                map.put(key, value);
            }
        }
    }

    public static double getSmallestVolumeTiming(float[] volumeTiming) {
        double time = Double.MAX_VALUE;
        if (volumeTiming != null) {
            for (float element : volumeTiming) {
                if (!((double)element < time)) continue;
                time = element;
            }
        }
        return time;
    }

    public WritableHeader getWritableHeader(String name) {
        if (this.readable != null && this.readable.getPluginName().equals(name) && this.readable instanceof WritableHeader) {
            return (WritableHeader)this.readable;
        }
        return Header.makeWritableHeader(name);
    }

    public static WritableHeader makeWritableHeader(String name) {
        Object wh = null;
        Enumeration<WritableHeader> en = LOADED_WRITABLE_FORMATS.elements();
        while (en.hasMoreElements()) {
            WritableHeader awh = en.nextElement();
            if (!PluginManagerDialog.getPluginName(awh).equals(name)) continue;
            wh = awh;
            break;
        }
        WritableHeader writableHeader = null;
        if (wh != null) {
            Class<?> c = wh.getClass();
            try {
                writableHeader = (WritableHeader)c.newInstance();
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InstantiationException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return writableHeader;
    }

    public static String findWritableNameForExtension(File file) {
        String extension = FileUtilities.getFullExtension((File)file);
        if (extension.indexOf(".gz") != -1) {
            extension = extension.substring(0, extension.indexOf(".gz"));
        }
        Vector<WritableHeader> formats = LOADED_WRITABLE_FORMATS;
        for (WritableHeader wh : formats) {
            if (wh.getPreferredFileExtension().indexOf(extension) == -1) continue;
            return wh.getPluginName();
        }
        return null;
    }

    public static float[] makeSliceSpacing(float[] positions, int numSlicesPerVolume) {
        float[] sliceSpacing = null;
        if (numSlicesPerVolume > 1 && positions != null && positions.length % numSlicesPerVolume == 0) {
            sliceSpacing = new float[positions.length];
            int numTimepoints = positions.length / numSlicesPerVolume;
            for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
                float lastDiff = 0.0f;
                for (int ctr = 0; ctr < numSlicesPerVolume; ++ctr) {
                    int offset = ctrT * numSlicesPerVolume + ctr;
                    if (ctr == numSlicesPerVolume - 1) {
                        sliceSpacing[offset] = sliceSpacing[offset - 1];
                        continue;
                    }
                    float diff = positions[offset + 1] - positions[offset];
                    if (ctr > 0 && Math.signum(diff) != Math.signum(lastDiff)) {
                        return null;
                    }
                    lastDiff = diff;
                    sliceSpacing[offset] = Math.abs(diff);
                }
            }
        }
        return sliceSpacing;
    }

    public static TreeMap<String, Vector<DICOM>> readDICOMFolder(File dir) throws IOException {
        TreeMap<String, Vector<DICOM>> map = new TreeMap<String, Vector<DICOM>>();
        Header.doReadDICOMFolder(dir, map);
        return map;
    }

    public static File scanForDICOMDIR(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase(DICOMDIR)) continue;
                return file;
            }
        }
        return null;
    }

    private static String detectHeaderType(URI headerFile) {
        String formatName = null;
        if (FileUtilities.uriIsFile((URI)headerFile)) {
            for (ReadableHeader rh : LOADED_READABLE_FORMATS) {
                if (!rh.isThisFormat(new File(headerFile))) continue;
                formatName = rh.getPluginName();
                break;
            }
        } else {
            String name = FileUtilities.getName((URI)headerFile);
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)headerFile.toString());
            if (name.indexOf(46) != -1) {
                String ext = name.substring(name.indexOf(46));
                if (usesGZIPExtension) {
                    ext = ext.substring(0, ext.lastIndexOf(46));
                }
                if (LOADED_READABLE_FORMATS.size() > 0) {
                    for (ReadableHeader rh : LOADED_READABLE_FORMATS) {
                        if (ext.indexOf(rh.getPreferredFileExtension()) == -1) continue;
                        formatName = rh.getPluginName();
                        break;
                    }
                }
            } else {
                formatName = "DICOM";
            }
        }
        if (StringUtils.isBlank(formatName)) {
            formatName = "DICOM";
        }
        return formatName;
    }

    private static void doReadDICOMFolder(File dir, TreeMap<String, Vector<DICOM>> map) throws IOException {
        Header.doReadDICOMFolder(dir, map, 0);
    }

    private static double getSmallestSliceSpacing(float[] sliceSpacing) {
        double spacing = Double.MAX_VALUE;
        if (sliceSpacing != null) {
            for (float element : sliceSpacing) {
                if (!((double)element < spacing)) continue;
                spacing = element;
            }
        }
        return spacing;
    }

    protected static void addReadableHeader(ReadableHeader rh) {
        LOADED_READABLE_FORMATS.add(rh);
    }

    protected static void addWritableHeader(WritableHeader wh) {
        LOADED_WRITABLE_FORMATS.add(wh);
    }

    protected static boolean checkSliceSpacingAcrossTimepoints(float[] spacing, int numSlices, int numTimepoints) {
        for (int ctr = 0; ctr < numSlices; ++ctr) {
            float first = spacing[ctr];
            for (int ctrT = 1; ctrT < numTimepoints; ++ctrT) {
                if (first == spacing[ctr + numSlices * ctrT]) continue;
                return false;
            }
        }
        return true;
    }

    protected static float[] convertSliceSpacingToRatios(float[] spacing, int numSlices) {
        float[] ratios = null;
        if (spacing != null) {
            ratios = new float[numSlices];
            double smallestSpacing = Header.getSmallestSliceSpacing(spacing);
            for (int ctr = 0; ctr < ratios.length; ++ctr) {
                ratios[ctr] = (float)((double)spacing[ctr] / smallestSpacing);
            }
        }
        return ratios;
    }

    protected static double getRealTimeAcrossVolumes(float[] volumeTiming) {
        if (volumeTiming != null) {
            double time = 0.0;
            for (float element : volumeTiming) {
                time += (double)element;
            }
            return time;
        }
        return -1.0;
    }

    public Header() {
    }

    public Header(File aFile) throws InvalidHeaderException {
        this(aFile.toURI());
    }

    public Header(ImageType newImageType, ImageDimensions newImageDimensions, VoxelDimensions newVoxelDimensions) {
        this(newImageType, newImageDimensions, newVoxelDimensions, null);
    }

    public Header(ImageType newImageType, ImageDimensions newImageDimensions, VoxelDimensions newVoxelDimensions, ImageRange newImageRange) {
        this.setValues(newImageType, newImageDimensions, newVoxelDimensions);
        if (newImageRange == null) {
            this.imageRange = new ImageRange(0.0, 0.0, 0.0, 0.0);
            this.imageRange.setGlobalDataScaleSlope(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), 1.0f);
            this.imageRange.setGlobalDataScaleIntercept(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), 0.0f);
        } else {
            this.imageRange = newImageRange;
            int numScaleVals = newImageDimensions.getSlices() * newImageDimensions.getTimepoints();
            if (this.imageRange.hasGlobalDataScaleSlope()) {
                this.imageRange.setGlobalDataScaleSlope(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), this.imageRange.getDataScaleSlopes()[0]);
            } else if (this.imageRange.getDataScaleSlopes() == null || this.imageRange.getDataScaleSlopes().length != numScaleVals) {
                this.imageRange.setGlobalDataScaleSlope(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), 1.0f);
            }
            if (this.imageRange.hasGlobalDataScaleIntercept()) {
                this.imageRange.setGlobalDataScaleIntercept(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), this.imageRange.getDataScaleIntercepts()[0]);
            } else if (this.imageRange.getDataScaleIntercepts() == null || this.imageRange.getDataScaleIntercepts().length != numScaleVals) {
                this.imageRange.setGlobalDataScaleIntercept(newImageDimensions.getSlices() * newImageDimensions.getTimepoints(), 0.0f);
            }
        }
        if (this.origin == null) {
            this.origin = new Coordinate(0.0, 0.0, 0.0);
        }
        if (this.originOriginal == null) {
            this.originOriginal = new Coordinate(0.0, 0.0, 0.0);
        }
        this.imageIntent = new ImageIntent();
        this.imageDescription = new ImageDescription();
    }

    public Header(URI aFile) throws InvalidHeaderException {
        this.readFile(aFile, null);
    }

    public void clear() {
        this.imageDimensions = null;
        this.voxelDimensions = null;
        this.imageType = null;
        this.imageRange = null;
        this.imageIntent = null;
        this.imageDescription = null;
        this.origin = null;
        this.orientation = null;
        this.imageFile = null;
        this.readable = null;
    }

    public void createFromDICOMHeaders(DICOM[] dicoms) throws InvalidHeaderException, IOException {
        Series dcm = new Series();
        dcm.buildDCM(dicoms[0], new ArrayList<DICOM>(Arrays.asList(dicoms)));
        this.buildFromReadable((ReadableHeader)dcm);
    }

    public void createFromDICOMFiles(URI[] files) throws IOException, InvalidHeaderException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (URI file : files) {
            uris.add(file);
        }
        Series dcm = new Series();
        dcm.buildDICOMFromURIs((URI)uris.get(0), uris);
        this.buildFromReadable((ReadableHeader)dcm);
    }

    public String getAllDescriptiveData(int sliceNum) {
        String des = this.imageDescription.getAllID() + " " + this.imageDescription.getStudyDateString() + " " + this.imageDescription.getDescription();
        if (des != null) {
            des = des.trim();
        }
        return des;
    }

    public float[] getCumulativeTimes() {
        float[] cumulativeTimes = null;
        float[] volumeTimes = null;
        if (this.readable != null && (volumeTimes = this.readable.getVoxelDimensions().getVariableTiming()) != null) {
            cumulativeTimes = new float[volumeTimes.length];
            float totalTime = 0.0f;
            for (int ctr = 0; ctr < volumeTimes.length; ++ctr) {
                cumulativeTimes[ctr] = totalTime;
                totalTime += volumeTimes[ctr];
            }
        }
        return cumulativeTimes;
    }

    public float[] getDataScaleIntercepts() {
        return this.imageRange.getDataScaleIntercepts();
    }

    public float[] getDataScaleSlopes() {
        return this.imageRange.getDataScaleSlopes();
    }

    public double getDisplayMax() {
        return this.imageRange.getDisplayMax();
    }

    public double getDisplayMin() {
        return this.imageRange.getDisplayMin();
    }

    public ImageDescription getImageDescription() {
        return this.imageDescription;
    }

    public ImageDimensions getImageDimensions() {
        return this.imageDimensions;
    }

    public URI getImageFile() {
        return this.imageFile;
    }

    public String getImageFilename() {
        return FileUtilities.getName((URI)this.imageFile);
    }

    public ImageIntent getImageIntent() {
        return this.imageIntent;
    }

    public double getImageMax() {
        return this.imageRange.getImageMax();
    }

    public double getImageMin() {
        return this.imageRange.getImageMin();
    }

    public ImageRange getImageRange() {
        return this.imageRange;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public String getLoadedHeaderType() {
        if (this.readable != null) {
            if (StringUtils.isNotBlank((CharSequence)this.imageDescription.getImageTypeDescription())) {
                return this.readable.getPluginName() + " (" + this.imageDescription.getImageTypeDescription() + ")";
            }
            return this.readable.getPluginName();
        }
        return "None";
    }

    public boolean isLoadedHeadertypeWritable() {
        return this.readable != null && this.readable instanceof WritableHeader;
    }

    public URI[] getMultiImageFiles() {
        if (this.readable != null) {
            return this.readable.getImageDescription().getAssociatedFiles();
        }
        return null;
    }

    public int[] getMultiImageOffsets() {
        if (this.readable != null) {
            return this.readable.getImageDimensions().getImageOffsets();
        }
        return null;
    }

    public boolean isNIFTI() {
        return this.readable instanceof NIFTI;
    }

    public boolean isAVW() {
        return this.readable instanceof AVW;
    }

    public NIFTI getNIFTIObject() {
        if (this.isNIFTI()) {
            return (NIFTI)this.readable;
        }
        return null;
    }

    public int getOrientationCertainty() {
        return this.orientationCertainty;
    }

    public String getOrientationString() {
        return this.orientation;
    }

    public Coordinate getOrigin() {
        return this.origin;
    }

    public Coordinate getOriginOriginal() {
        return this.originOriginal;
    }

    public ReadableHeader getReadable() {
        return this.readable;
    }

    public float[] getSliceSpacing() {
        if (this.readable != null) {
            return this.readable.getVoxelDimensions().getVariableSpacing();
        }
        return null;
    }

    public String getTimeUnitString() {
        int unit = this.voxelDimensions.getTemporalUnit();
        String unitStr = null;
        unitStr = unit == 8 ? "s" : (unit == 16 ? "ms" : (unit == 24 ? "\u03bcs" : "s"));
        return unitStr;
    }

    public int getVolumeSizeBytes() {
        return this.imageDimensions.getNumVoxelsVolume() * this.imageType.getNumBytesPerVoxel();
    }

    public int getVolumeSizeVoxels() {
        return this.imageDimensions.getNumVoxelsVolume();
    }

    public float[] getVolumeTiming() {
        if (this.readable != null) {
            return this.readable.getVoxelDimensions().getVariableTiming();
        }
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.voxelDimensions;
    }

    public boolean hasExtension(int code) {
        if (this.isNIFTI()) {
            int flag = this.getNIFTIObject().getExtensionFlag();
            return flag == code;
        }
        return false;
    }

    public boolean isMultiFileFormat() {
        return this.readable != null && this.readable.getImageDimensions().getImageOffsets() != null && this.readable.getImageDimensions().getImageOffsets().length > 1;
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public boolean isVariableSliceSpacing() {
        float[] sliceSpacing = this.getSliceSpacing();
        if (sliceSpacing != null) {
            for (int ctr = 1; ctr < sliceSpacing.length; ++ctr) {
                if (!((double)(Math.abs(sliceSpacing[ctr] - sliceSpacing[ctr - 1]) / Math.abs(sliceSpacing[ctr])) > 0.05)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVariableVolumeTiming() {
        float[] volumeTimes = this.getVolumeTiming();
        if (volumeTimes != null) {
            for (int ctr = 1; ctr < volumeTimes.length; ++ctr) {
                if (volumeTimes[ctr] == 0.0f || !((double)(Math.abs(volumeTimes[ctr] - volumeTimes[ctr - 1]) / Math.abs(volumeTimes[ctr])) > 0.05)) continue;
                return true;
            }
        }
        return false;
    }

    public URI readFile(File headerFile) throws InvalidHeaderException {
        return this.readFile(headerFile.toURI());
    }

    public void setGlobalDefaultDataScales(int numPoints) {
        this.imageRange.setGlobalDataScaleSlope(numPoints, 1.0f);
        this.imageRange.setGlobalDataScaleIntercept(numPoints, 0.0f);
    }

    public void setImageDescription(String string) {
        this.imageDescription.setDescription(string);
    }

    public void setImageFile(File aFile) {
        this.imageFile = aFile.toURI();
    }

    public void setImageFile(URI aFile) {
        this.imageFile = aFile;
    }

    public void copyNIFTIOrientation(NIFTI nifti) {
        NIFTI niftiNew = new NIFTI();
        niftiNew.setOrientation(nifti);
        this.readable = niftiNew;
    }

    public void setOrientation(String aOrientation) {
        this.orientation = aOrientation;
    }

    public void setOrientationCertainty(int val) {
        this.orientationCertainty = val;
    }

    public void setOrigin(Coordinate origin) {
        this.origin = new Coordinate(origin);
    }

    public void setOriginOriginal(Coordinate origin) {
        this.originOriginal = new Coordinate(origin);
    }

    public String toString() {
        if (this.readable != null) {
            return this.readable.toString();
        }
        return "";
    }

    private URI readFile(URI headerFile) throws InvalidHeaderException {
        return this.readFile(headerFile, null);
    }

    public URI readFile(File headerFile, File tempDir) throws InvalidHeaderException {
        this.readReadableFile(headerFile.toURI(), Header.detectHeaderType(headerFile), tempDir);
        return headerFile.toURI();
    }

    public URI readFile(URI headerFile, File tempDir) throws InvalidHeaderException {
        this.readReadableFile(headerFile, Header.detectHeaderType(headerFile), tempDir);
        return headerFile;
    }

    private void readReadableFile(URI file, String loadedFormatName, File tempDir) throws InvalidHeaderException {
        Enumeration<ReadableHeader> formats = LOADED_READABLE_FORMATS.elements();
        Object readable = null;
        while (formats.hasMoreElements()) {
            ReadableHeader temp = formats.nextElement();
            if (!temp.getPluginName().equals(loadedFormatName)) continue;
            readable = temp;
        }
        if (!FileUtilities.exists((URI)file)) {
            throw new InvalidHeaderException("File doesn't exist!");
        }
        Class<?> c = readable.getClass();
        try {
            readable = (ReadableHeader)c.newInstance();
            readable.readHeader(file, tempDir);
        }
        catch (InstantiationException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            throw new InvalidHeaderException(ex.getMessage(), ex);
        }
        this.buildFromReadable((ReadableHeader)readable);
    }

    private void buildFromReadable(ReadableHeader readable) {
        this.readable = readable;
        this.imageDimensions = readable.getImageDimensions();
        this.voxelDimensions = readable.getVoxelDimensions();
        this.imageType = readable.getImageType();
        this.imageIntent = new ImageIntent();
        this.imageRange = readable.getImageRange();
        this.imageDescription = readable.getImageDescription();
        this.orientation = readable.getOrientation();
        this.origin = readable.getOrigin();
        this.originOriginal = new Coordinate(this.origin);
        this.orientationCertainty = readable.getOrientationCertainty();
        this.imageFile = readable.getImageFile();
        if (this.imageRange.getDataScaleSlopes() == null) {
            this.imageRange.setGlobalDataScaleSlope(this.imageDimensions.getSlices(), 1.0f);
        }
        if (this.imageRange.getDataScaleIntercepts() == null) {
            this.imageRange.setGlobalDataScaleIntercept(this.imageDimensions.getSlices(), 0.0f);
        }
    }

    private void setValues(ImageType newImageType, ImageDimensions newImageDimensions, VoxelDimensions newVoxelDimensions) {
        if (this.imageType != null) {
            this.imageType.setValues(newImageType);
        } else {
            try {
                this.imageType = (ImageType)newImageType.clone();
            }
            catch (CloneNotSupportedException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (this.imageDimensions != null) {
            this.imageDimensions.setValues(newImageDimensions);
        } else {
            try {
                this.imageDimensions = (ImageDimensions)newImageDimensions.clone();
            }
            catch (CloneNotSupportedException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (this.voxelDimensions != null) {
            this.voxelDimensions.setValues(newVoxelDimensions);
        } else {
            try {
                this.voxelDimensions = (VoxelDimensions)newVoxelDimensions.clone();
            }
            catch (CloneNotSupportedException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    protected void anonymize() {
        this.imageDescription.anonymize();
    }

    protected Header copy() {
        Header hdr = new Header();
        try {
            hdr.imageDimensions = (ImageDimensions)this.imageDimensions.clone();
            hdr.voxelDimensions = (VoxelDimensions)this.voxelDimensions.clone();
            hdr.imageType = (ImageType)this.imageType.clone();
            hdr.imageRange = (ImageRange)this.imageRange.clone();
            hdr.imageIntent = (ImageIntent)this.imageIntent.clone();
            hdr.imageDescription = (ImageDescription)this.imageDescription.clone();
            hdr.origin = new Coordinate(this.origin);
            hdr.orientation = this.orientation;
            hdr.imageFile = this.imageFile;
            hdr.orientationCertainty = this.orientationCertainty;
            hdr.readable = this.readable;
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return hdr;
    }

    protected Header copyAndReplace(ImageType it, ImageRange ir) {
        Header hdr = this.copy();
        hdr.imageType = it;
        hdr.imageRange = ir;
        return hdr;
    }

    protected String getAllImageID(int sliceNum) {
        return this.imageDescription.getAllID();
    }

    protected String getAllImageTime(int sliceNum) {
        return this.imageDescription.getStudyDateString();
    }

    protected String getImageDescription(int sliceNum) {
        return this.imageDescription.getDescription();
    }

    protected double getRealTimeOffset(int volIndex) {
        if (this.isVariableVolumeTiming()) {
            float[] times = this.getCumulativeTimes();
            if (volIndex < times.length) {
                return times[volIndex];
            }
            return -1.0;
        }
        return this.voxelDimensions.getTR() * (double)volIndex;
    }

    protected boolean canBeSaved() {
        return this.readable instanceof WritableHeader;
    }

    protected boolean isValid(StringBuffer buf) {
        if (this.imageDimensions == null || !this.imageDimensions.isValid(buf)) {
            return false;
        }
        if (this.voxelDimensions == null || !this.voxelDimensions.isValid(buf)) {
            return false;
        }
        if (this.imageType == null || !this.imageType.isValid(buf)) {
            return false;
        }
        return this.imageFile != null && this.imageFile.getPath().length() > 0;
    }

    protected void setDisplayMaxMin(double max, double min) {
        this.imageRange.setDisplayMax(max);
        this.imageRange.setDisplayMin(min);
    }

    protected void setImageMaxMin(double max, double min) {
        this.imageRange.setImageMax(max);
        this.imageRange.setImageMin(min);
    }

    protected void setImageMaxMinOffsets(long maxOffset, long minOffset) {
        this.imageRange.setImageMaxOffset(maxOffset);
        this.imageRange.setImageMinOffset(minOffset);
    }

    protected void unsetMultiFileFormat() {
        if (this.readable != null) {
            this.readable.getImageDescription().setAssociatedFiles(null);
            this.readable.getImageDimensions().setImageOffsets(null);
        }
    }

    public boolean isRGB() {
        return this.imageType.getByteType() == 6 || this.imageType.isRGBPalette();
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        if (this.readable != null && !this.oldReadableWarned) {
            try {
                return this.readable.getSliceMetadata(slice, seriesPoint);
            }
            catch (AbstractMethodError | NoSuchMethodError err) {
                this.oldReadableWarned = true;
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
        }
        return null;
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        if (this.readable != null && !this.oldReadableWarned) {
            try {
                return this.readable.getSliceAnnotation(slice, seriesPoint);
            }
            catch (AbstractMethodError | NoSuchMethodError err) {
                this.oldReadableWarned = true;
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
        }
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }
}

