/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.points.manager;

import edu.uthscsa.ric.roi.PointsSpecialManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.PointListener;
import edu.uthscsa.ric.roi.points.PointUser;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Color;
import java.awt.Point;

public class POISpecialManager
implements PointsSpecialManager {
    private final PointUser user;
    private final PointListener listener;
    private final POI[] pointsAxial;
    private final POI[] pointsCoronal;
    private final POI[] pointsSagittal;
    private final int xDim;
    private final int yDim;
    private final int zDim;

    public POISpecialManager(int dimX, int dimY, int dimZ, PointListener listener, PointUser user) {
        this.xDim = dimX;
        this.yDim = dimY;
        this.zDim = dimZ;
        this.pointsAxial = new POI[this.zDim];
        this.pointsCoronal = new POI[this.yDim];
        this.pointsSagittal = new POI[this.xDim];
        this.listener = listener;
        this.user = user;
    }

    public void addImmutablePoint(Coordinate coor, Color aColor) {
        POI aPOI = new POI(coor.xInt, coor.yInt, coor.zInt, -1, true);
        aPOI.setSpecialColor(aColor);
        this.addPOI(aPOI);
    }

    public void addPoint(Coordinate coor, Color aColor) {
        POI aPOI = new POI(coor.xInt, coor.yInt, coor.zInt, -1, false);
        aPOI.setSpecialColor(aColor);
        this.addPOI(aPOI);
    }

    public Coordinate[] getPoints(Color aColor) {
        POI currentPOI;
        int ctr;
        int count = 0;
        int index = 0;
        Coordinate[] coorsToReturn = null;
        for (ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (currentPOI.getSpecialColor() != aColor) continue;
                ++count;
            }
        }
        if (count > 0) {
            coorsToReturn = new Coordinate[count];
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                if (this.pointsAxial[ctr] == null) continue;
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    if (currentPOI.getSpecialColor() != aColor) continue;
                    coorsToReturn[index++] = new Coordinate((double)currentPOI.getX(), (double)currentPOI.getY(), (double)currentPOI.getZ());
                }
            }
        }
        return coorsToReturn;
    }

    public POI getPOIs(int slice, int sliceDirection) {
        if (sliceDirection == 0) {
            return this.pointsAxial[slice];
        }
        if (sliceDirection == 1) {
            return this.pointsCoronal[slice];
        }
        if (sliceDirection == 2) {
            return this.pointsSagittal[slice];
        }
        return null;
    }

    public boolean hasPoints(int slice, int sliceDirection) {
        if (sliceDirection == 0) {
            return this.pointsAxial[slice] != null;
        }
        if (sliceDirection == 1) {
            return this.pointsCoronal[slice] != null;
        }
        if (sliceDirection == 2) {
            return this.pointsSagittal[slice] != null;
        }
        return false;
    }

    public void removePoint(Coordinate coor, Color aColor) {
        for (POI current = this.pointsAxial[coor.zInt]; current != null; current = current.getNextAxial()) {
            if (current.getX() != coor.xInt || current.getY() != coor.yInt || current.getSpecialColor() != aColor) continue;
            this.removePOI(current);
        }
    }

    public void setPointHighlightState(Coordinate coor, Color aColor, boolean highlight) {
        for (POI current = this.pointsAxial[coor.zInt]; current != null; current = current.getNextAxial()) {
            if (current.getX() != coor.xInt || current.getY() != coor.yInt || current.getSpecialColor() != aColor) continue;
            current.setHighlighted(highlight);
        }
    }

    public void updatePOI(POI updatingPOI) {
        int xLoc = updatingPOI.getX();
        int yLoc = updatingPOI.getY();
        int zLoc = updatingPOI.getZ();
        if (xLoc < 0) {
            xLoc = 0;
        } else if (xLoc >= this.xDim) {
            xLoc = this.xDim - 1;
        }
        if (yLoc < 0) {
            yLoc = 0;
        } else if (yLoc >= this.yDim) {
            yLoc = this.yDim - 1;
        }
        if (zLoc < 0) {
            zLoc = 0;
        } else if (zLoc >= this.zDim) {
            zLoc = this.zDim - 1;
        }
        updatingPOI.updatePOI(new Point(xLoc, yLoc), zLoc, 0);
        this.removePOI(updatingPOI);
        updatingPOI.clearNext();
        updatingPOI.reconcileSlices();
        this.addPOI(updatingPOI);
    }

    private void addPOI(POI poi) {
        poi.setSpecialState(true);
        poi.setSelectedState(true);
        if (poi.getX() >= 0 && poi.getX() < this.xDim && poi.getY() >= 0 && poi.getY() < this.yDim && poi.getZ() >= 0 && poi.getZ() < this.zDim) {
            POI current;
            if (this.pointsAxial[poi.axialSlice] == null) {
                this.pointsAxial[poi.axialSlice] = poi;
            } else {
                current = this.pointsAxial[poi.axialSlice];
                while (current.getNextAxial() != null) {
                    current = current.getNextAxial();
                }
                current.setNextAxial(poi);
            }
            if (this.pointsCoronal[poi.coronalSlice] == null) {
                this.pointsCoronal[poi.coronalSlice] = poi;
            } else {
                current = this.pointsCoronal[poi.coronalSlice];
                while (current.getNextCoronal() != null) {
                    current = current.getNextCoronal();
                }
                current.setNextCoronal(poi);
            }
            if (this.pointsSagittal[poi.sagittalSlice] == null) {
                this.pointsSagittal[poi.sagittalSlice] = poi;
            } else {
                current = this.pointsSagittal[poi.sagittalSlice];
                while (current.getNextSagittal() != null) {
                    current = current.getNextSagittal();
                }
                current.setNextSagittal(poi);
            }
        }
        poi.setListenerAndUser(this.user, this.listener);
    }

    private void removePOI(POI poi) {
        POI current;
        POI previous = null;
        for (current = this.pointsAxial[poi.axialSlice]; current != null; current = current.getNextAxial()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextAxial(current.getNextAxial());
                } else {
                    this.pointsAxial[poi.axialSlice] = current.getNextAxial();
                }
            }
            previous = current;
        }
        previous = null;
        for (current = this.pointsCoronal[poi.coronalSlice]; current != null; current = current.getNextCoronal()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextCoronal(current.getNextCoronal());
                } else {
                    this.pointsCoronal[poi.coronalSlice] = current.getNextCoronal();
                }
            }
            previous = current;
        }
        previous = null;
        for (current = this.pointsSagittal[poi.sagittalSlice]; current != null; current = current.getNextSagittal()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextSagittal(current.getNextSagittal());
                } else {
                    this.pointsSagittal[poi.sagittalSlice] = current.getNextSagittal();
                }
            }
            previous = current;
        }
    }
}

