/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.points.manager;

import edu.uthscsa.ric.roi.Point;
import edu.uthscsa.ric.roi.PointsManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.PointListener;
import edu.uthscsa.ric.roi.points.PointUser;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class POIManager
implements PointsManager {
    private boolean hasRedo;
    private boolean hasUndo;
    private boolean isDirty;
    private boolean isUsed;
    private final PointListener listener;
    private final PointUser user;
    private final POI[] pointsAxial;
    private final POI[] pointsCoronal;
    private final POI[] pointsRedo;
    private final POI[] pointsSagittal;
    private final POI[] pointsUndo;
    private final double xSize;
    private final double ySize;
    private final double zSize;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    public static final int POI_HEADER = -9998;
    public static final int POI_HEADER_SIZE = 4;

    public POIManager(int dimX, int dimY, int dimZ, double sizeX, double sizeY, double sizeZ, PointListener listener, PointUser user) {
        this.xDim = dimX;
        this.yDim = dimY;
        this.zDim = dimZ;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.zSize = sizeZ;
        this.pointsAxial = new POI[this.zDim];
        this.pointsCoronal = new POI[this.yDim];
        this.pointsSagittal = new POI[this.xDim];
        this.pointsUndo = new POI[this.zDim];
        this.pointsRedo = new POI[this.zDim];
        this.listener = listener;
        this.user = user;
    }

    public void addPOI(POI poi, boolean doStoreUndoCopy) {
        this.addPOI(poi, doStoreUndoCopy, false);
    }

    public void addPOI(POI poi, boolean doStoreUndoCopy, boolean notify) {
        this.isUsed = true;
        if (poi.getX() >= 0 && poi.getX() < this.xDim && poi.getY() >= 0 && poi.getY() < this.yDim && poi.getZ() >= 0 && poi.getZ() < this.zDim) {
            POI current;
            if (doStoreUndoCopy) {
                this.storeUndoCopy();
            }
            if (this.pointsAxial[poi.axialSlice] == null) {
                this.pointsAxial[poi.axialSlice] = poi;
            } else {
                current = this.pointsAxial[poi.axialSlice];
                while (current.getNextAxial() != null) {
                    current = current.getNextAxial();
                }
                current.setNextAxial(poi);
            }
            if (this.pointsCoronal[poi.coronalSlice] == null) {
                this.pointsCoronal[poi.coronalSlice] = poi;
            } else {
                current = this.pointsCoronal[poi.coronalSlice];
                while (current.getNextCoronal() != null) {
                    current = current.getNextCoronal();
                }
                current.setNextCoronal(poi);
            }
            if (this.pointsSagittal[poi.sagittalSlice] == null) {
                this.pointsSagittal[poi.sagittalSlice] = poi;
            } else {
                current = this.pointsSagittal[poi.sagittalSlice];
                while (current.getNextSagittal() != null) {
                    current = current.getNextSagittal();
                }
                current.setNextSagittal(poi);
            }
        }
        poi.setListenerAndUser(this.user, this.listener);
        if (notify && this.listener != null) {
            this.listener.pointAdded(poi);
        }
    }

    public void addPoint(Coordinate coor, int aColor) {
        this.addPOI(new POI(coor.xInt, coor.yInt, coor.zInt, aColor));
    }

    public void deselectAll() {
        this.setSelectedStateAll(false);
    }

    public Vector<POI> findAllPOIsWithinBounds(Rectangle bounds, int slice, int sliceDirection) {
        POI[] pointsSlice = null;
        if (sliceDirection == 0) {
            pointsSlice = this.pointsAxial;
        } else if (sliceDirection == 1) {
            pointsSlice = this.pointsCoronal;
        } else if (sliceDirection == 2) {
            pointsSlice = this.pointsSagittal;
        } else {
            return null;
        }
        Vector<POI> poisWithinBounds = new Vector<POI>();
        if (pointsSlice[slice] != null) {
            for (POI currentPOI = pointsSlice[slice]; currentPOI != null; currentPOI = currentPOI.getNext(sliceDirection)) {
                if (sliceDirection == 0) {
                    if (!bounds.contains(currentPOI.xLoc, currentPOI.yLoc)) continue;
                    poisWithinBounds.add(currentPOI);
                    continue;
                }
                if (sliceDirection == 1) {
                    if (!bounds.contains(currentPOI.xLoc, currentPOI.zLoc)) continue;
                    poisWithinBounds.add(currentPOI);
                    continue;
                }
                if (sliceDirection != 2 || !bounds.contains(currentPOI.yLoc, currentPOI.zLoc)) continue;
                poisWithinBounds.add(currentPOI);
            }
        }
        return poisWithinBounds;
    }

    public POI[] getAllPOIs() {
        POI currentPOI;
        int ctr;
        int count = 0;
        int index = 0;
        POI[] poisToReturn = null;
        for (ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                ++count;
            }
        }
        if (count > 0) {
            poisToReturn = new POI[count];
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                if (this.pointsAxial[ctr] == null) continue;
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    poisToReturn[index++] = currentPOI;
                }
            }
        }
        return poisToReturn;
    }

    public Coordinate[] getAllSelectedPoints() {
        POI currentPOI;
        int ctr;
        int count = 0;
        int index = 0;
        Coordinate[] coorsToReturn = null;
        for (ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (!currentPOI.isSelected()) continue;
                ++count;
            }
        }
        if (count > 0) {
            coorsToReturn = new Coordinate[count];
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                if (this.pointsAxial[ctr] == null) continue;
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    if (!currentPOI.isSelected()) continue;
                    coorsToReturn[index++] = new Coordinate((double)currentPOI.getX(), (double)currentPOI.getY(), (double)currentPOI.getZ());
                }
            }
        }
        return coorsToReturn;
    }

    public POI[] getAllSelectedPOIs() {
        POI currentPOI;
        int ctr;
        int count = 0;
        int index = 0;
        POI[] poisToReturn = null;
        for (ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (!currentPOI.isSelected()) continue;
                ++count;
            }
        }
        if (count > 0) {
            poisToReturn = new POI[count];
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                if (this.pointsAxial[ctr] == null) continue;
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    if (!currentPOI.isSelected()) continue;
                    poisToReturn[index++] = currentPOI;
                }
            }
        }
        return poisToReturn;
    }

    public List<Point> getSelectedPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (!currentPOI.isSelected()) continue;
                points.add(currentPOI);
            }
        }
        return points;
    }

    public List<Point> getUsedPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                points.add(currentPOI);
            }
        }
        return points;
    }

    public POI[] getAllSelectedPOIsClone() {
        POI[] returnPOIs = new POI[this.zDim];
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (!currentPOI.isSelected()) continue;
                if (returnPOIs[ctr] == null) {
                    returnPOIs[ctr] = currentPOI.copy();
                    continue;
                }
                POI nextEmpty = returnPOIs[ctr];
                while (nextEmpty.getNextAxial() != null) {
                    nextEmpty = nextEmpty.getNextAxial();
                }
                nextEmpty.setNextAxial(currentPOI.copy());
            }
        }
        return returnPOIs;
    }

    public int getAxialSliceNumber() {
        return this.user.getAxialSliceNumber();
    }

    public int getCoronalSliceNumber() {
        return this.user.getCoronalSliceNumber();
    }

    public byte[] getData() {
        if (!this.hasPoints()) {
            return null;
        }
        ByteBuffer buffer = null;
        try {
            POI currentPOI;
            int ctr;
            int count = 0;
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    count += 5;
                }
            }
            buffer = ByteBuffer.allocate(count * 2);
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                for (currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    buffer.putShort((short)-9998);
                    buffer.putShort((short)currentPOI.getColor());
                    buffer.putShort((short)currentPOI.getX());
                    buffer.putShort((short)currentPOI.getY());
                    buffer.putShort((short)currentPOI.getZ());
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return buffer.array();
    }

    public POI getFirstPOI(int startDirection, int color) {
        block7: {
            block8: {
                block6: {
                    if (startDirection != 0) break block6;
                    for (int ctr = 0; ctr < this.zDim; ++ctr) {
                        for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                            if (currentPOI.getColor() != color) continue;
                            return currentPOI;
                        }
                    }
                    break block7;
                }
                if (startDirection != 1) break block8;
                for (int ctr = 0; ctr < this.yDim; ++ctr) {
                    for (POI currentPOI = this.pointsCoronal[ctr]; currentPOI != null; currentPOI = currentPOI.getNextCoronal()) {
                        if (currentPOI.getColor() != color) continue;
                        return currentPOI;
                    }
                }
                break block7;
            }
            if (startDirection != 2) break block7;
            for (int ctr = 0; ctr < this.xDim; ++ctr) {
                for (POI currentPOI = this.pointsSagittal[ctr]; currentPOI != null; currentPOI = currentPOI.getNextSagittal()) {
                    if (currentPOI.getColor() != color) continue;
                    return currentPOI;
                }
            }
        }
        return null;
    }

    public int getMainSliceDirection() {
        return this.user.getSliceDirection();
    }

    public int getMainSliceNumber() {
        return this.user.getSliceNumber();
    }

    public POI getNextPOI(int startSlice, int startDirection, POI poi) {
        block19: {
            POI currentPOI;
            int ctr;
            int color;
            int foundSlice;
            block20: {
                POI currentPOI2;
                int ctr2;
                block18: {
                    POI currentPOI3;
                    int ctr3;
                    foundSlice = -1;
                    color = poi.getColor();
                    if (startDirection != 0) break block18;
                    for (ctr3 = 0; ctr3 < this.zDim; ++ctr3) {
                        for (currentPOI3 = this.pointsAxial[ctr3]; currentPOI3 != null; currentPOI3 = currentPOI3.getNextAxial()) {
                            if (foundSlice != -1 && currentPOI3.getColor() == color) {
                                return currentPOI3;
                            }
                            if (currentPOI3 != poi) continue;
                            foundSlice = ctr3;
                        }
                    }
                    for (ctr3 = 0; ctr3 < foundSlice; ++ctr3) {
                        for (currentPOI3 = this.pointsAxial[ctr3]; currentPOI3 != null; currentPOI3 = currentPOI3.getNextAxial()) {
                            if (foundSlice != -1 && currentPOI3.getColor() == color) {
                                return currentPOI3;
                            }
                            if (currentPOI3 != poi) continue;
                            foundSlice = ctr3;
                        }
                    }
                    break block19;
                }
                if (startDirection != 1) break block20;
                for (ctr2 = 0; ctr2 < this.yDim; ++ctr2) {
                    for (currentPOI2 = this.pointsCoronal[ctr2]; currentPOI2 != null; currentPOI2 = currentPOI2.getNextCoronal()) {
                        if (foundSlice != -1 && currentPOI2.getColor() == color) {
                            return currentPOI2;
                        }
                        if (currentPOI2 != poi) continue;
                        foundSlice = ctr2;
                    }
                }
                for (ctr2 = 0; ctr2 < foundSlice; ++ctr2) {
                    for (currentPOI2 = this.pointsCoronal[ctr2]; currentPOI2 != null; currentPOI2 = currentPOI2.getNextCoronal()) {
                        if (foundSlice != -1 && currentPOI2.getColor() == color) {
                            return currentPOI2;
                        }
                        if (currentPOI2 != poi) continue;
                        foundSlice = ctr2;
                    }
                }
                break block19;
            }
            if (startDirection != 2) break block19;
            for (ctr = 0; ctr < this.xDim; ++ctr) {
                for (currentPOI = this.pointsSagittal[ctr]; currentPOI != null; currentPOI = currentPOI.getNextSagittal()) {
                    if (foundSlice != -1 && currentPOI.getColor() == color) {
                        return currentPOI;
                    }
                    if (currentPOI != poi) continue;
                    foundSlice = ctr;
                }
            }
            for (ctr = 0; ctr < foundSlice; ++ctr) {
                for (currentPOI = this.pointsSagittal[ctr]; currentPOI != null; currentPOI = currentPOI.getNextSagittal()) {
                    if (foundSlice != -1 && currentPOI.getColor() == color) {
                        return currentPOI;
                    }
                    if (currentPOI != poi) continue;
                    foundSlice = ctr;
                }
            }
        }
        return null;
    }

    public int getPointCount(int aColor) {
        int count = 0;
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (currentPOI.getColor() != aColor) continue;
                ++count;
            }
        }
        return count;
    }

    public Coordinate[] getPoints(int aColor) {
        int count = this.getPointCount(aColor);
        int index = 0;
        Coordinate[] coorsToReturn = null;
        if (count > 0) {
            coorsToReturn = new Coordinate[count];
            for (int ctr = 0; ctr < this.zDim; ++ctr) {
                if (this.pointsAxial[ctr] == null) continue;
                for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    if (currentPOI.getColor() != aColor) continue;
                    coorsToReturn[index++] = new Coordinate((double)currentPOI.getX(), (double)currentPOI.getY(), (double)currentPOI.getZ());
                }
            }
        }
        return coorsToReturn;
    }

    public POI getPOIs(int slice, int sliceDirection) {
        if (sliceDirection == 0) {
            return this.pointsAxial[slice];
        }
        if (sliceDirection == 1) {
            return this.pointsCoronal[slice];
        }
        if (sliceDirection == 2) {
            return this.pointsSagittal[slice];
        }
        return null;
    }

    public int getSagittalSliceNumber() {
        return this.user.getSagittalSliceNumber();
    }

    public double getXSize() {
        return this.xSize;
    }

    public double getYSize() {
        return this.ySize;
    }

    public double getZSize() {
        return this.zSize;
    }

    public boolean hasLabels() {
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (!StringUtils.isNotBlank((CharSequence)currentPOI.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPoints() {
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasPoints(int slice, int sliceDirection) {
        if (sliceDirection == 0) {
            return this.pointsAxial[slice] != null;
        }
        if (sliceDirection == 1) {
            return this.pointsCoronal[slice] != null;
        }
        if (sliceDirection == 2) {
            return this.pointsSagittal[slice] != null;
        }
        return false;
    }

    public boolean hasRedo() {
        return this.hasRedo;
    }

    public boolean hasSelected() {
        POI[] pOIArray = this.pointsAxial;
        int n = pOIArray.length;
        for (int i = 0; i < n; ++i) {
            POI element;
            for (POI current = element = pOIArray[i]; current != null; current = current.getNextAxial()) {
                if (!current.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasUndo() {
        return this.hasUndo;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void putData(byte[] someData) {
        short current = 0;
        ByteBuffer buffer = ByteBuffer.wrap(someData);
        try {
            while (buffer.hasRemaining()) {
                current = buffer.getShort();
                if (current != -9998) continue;
                short aColor = buffer.getShort();
                short aX = buffer.getShort();
                short aY = buffer.getShort();
                short aZ = buffer.getShort();
                this.addPOI(new POI(aX, aY, aZ, aColor), false);
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public static int countPoints(byte[] someData) {
        short current = 0;
        int count = 0;
        ByteBuffer buffer = ByteBuffer.wrap(someData);
        try {
            while (buffer.hasRemaining()) {
                current = buffer.getShort();
                if (current != -9998) continue;
                ++count;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return count;
    }

    public void redo() {
        this.hasUndo = true;
        this.hasRedo = false;
        this.isDirty = true;
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            this.pointsUndo[ctr] = this.pointsAxial[ctr];
            this.pointsAxial[ctr] = this.pointsRedo[ctr];
            this.pointsRedo[ctr] = null;
        }
        this.reconcileWithAxial();
        this.deselectAll();
        if (this.user != null) {
            this.user.updateAllPoints();
        }
    }

    public void reflectPOIs(int sliceDirection, boolean vertical, int line, int color, boolean onlySelected) {
        block16: {
            int ctr;
            block17: {
                int ctr2;
                block15: {
                    int ctr3;
                    this.storeUndoCopy();
                    if (sliceDirection != 0) break block15;
                    int count = 0;
                    int ctrNew = 0;
                    for (int ctr4 = 0; ctr4 < this.zDim; ++ctr4) {
                        for (POI current = this.pointsAxial[ctr4]; current != null; current = current.getNextAxial()) {
                            if (onlySelected && !current.isSelected()) continue;
                            ++count;
                        }
                    }
                    POI[] newPOIs = new POI[count];
                    for (ctr3 = 0; ctr3 < this.zDim; ++ctr3) {
                        for (POI current = this.pointsAxial[ctr3]; current != null; current = current.getNextAxial()) {
                            if (onlySelected && !current.isSelected()) continue;
                            POI clonedCopy = null;
                            clonedCopy = current.copy();
                            clonedCopy.reflectPOI(sliceDirection, vertical, line);
                            clonedCopy.setSelectedState(false);
                            clonedCopy.setColor(color);
                            newPOIs[ctrNew++] = clonedCopy;
                        }
                    }
                    for (ctr3 = 0; ctr3 < ctrNew; ++ctr3) {
                        if (newPOIs[ctr3].getX() < 0 || newPOIs[ctr3].getX() >= this.xDim || newPOIs[ctr3].getY() < 0 || newPOIs[ctr3].getY() >= this.yDim || newPOIs[ctr3].getZ() < 0 || newPOIs[ctr3].getZ() >= this.zDim) continue;
                        this.addPOI(newPOIs[ctr3], false, true);
                    }
                    break block16;
                }
                if (sliceDirection != 1) break block17;
                int count = 0;
                int ctrNew = 0;
                for (int ctr5 = 0; ctr5 < this.zDim; ++ctr5) {
                    for (POI current = this.pointsCoronal[ctr5]; current != null; current = current.getNextCoronal()) {
                        if (onlySelected && !current.isSelected()) continue;
                        ++count;
                    }
                }
                POI[] newPOIs = new POI[count];
                for (ctr2 = 0; ctr2 < this.zDim; ++ctr2) {
                    for (POI current = this.pointsCoronal[ctr2]; current != null; current = current.getNextCoronal()) {
                        if (onlySelected && !current.isSelected()) continue;
                        POI clonedCopy = null;
                        clonedCopy = current.copy();
                        clonedCopy.reflectPOI(sliceDirection, vertical, line);
                        clonedCopy.setSelectedState(false);
                        clonedCopy.setColor(color);
                        newPOIs[ctrNew++] = clonedCopy;
                    }
                }
                for (ctr2 = 0; ctr2 < ctrNew; ++ctr2) {
                    if (newPOIs[ctr2].getX() < 0 || newPOIs[ctr2].getX() >= this.xDim || newPOIs[ctr2].getY() < 0 || newPOIs[ctr2].getY() >= this.yDim || newPOIs[ctr2].getZ() < 0 || newPOIs[ctr2].getZ() >= this.zDim) continue;
                    this.addPOI(newPOIs[ctr2], false, true);
                }
                break block16;
            }
            if (sliceDirection != 2) break block16;
            int count = 0;
            int ctrNew = 0;
            for (int ctr6 = 0; ctr6 < this.zDim; ++ctr6) {
                for (POI current = this.pointsSagittal[ctr6]; current != null; current = current.getNextSagittal()) {
                    if (onlySelected && !current.isSelected()) continue;
                    ++count;
                }
            }
            POI[] newPOIs = new POI[count];
            for (ctr = 0; ctr < this.zDim; ++ctr) {
                for (POI current = this.pointsSagittal[ctr]; current != null; current = current.getNextSagittal()) {
                    if (onlySelected && !current.isSelected()) continue;
                    POI clonedCopy = null;
                    clonedCopy = current.copy();
                    clonedCopy.reflectPOI(sliceDirection, vertical, line);
                    clonedCopy.setSelectedState(false);
                    clonedCopy.setColor(color);
                    newPOIs[ctrNew++] = clonedCopy;
                }
            }
            for (ctr = 0; ctr < ctrNew; ++ctr) {
                if (newPOIs[ctr].getX() < 0 || newPOIs[ctr].getX() >= this.xDim || newPOIs[ctr].getY() < 0 || newPOIs[ctr].getY() >= this.yDim || newPOIs[ctr].getZ() < 0 || newPOIs[ctr].getZ() >= this.zDim) continue;
                this.addPOI(newPOIs[ctr], false, true);
            }
        }
    }

    public void reflectSlicePOIs(int sliceDirection, int sliceNum, boolean vertical, int line, int color, boolean onlySelected) {
        block10: {
            block11: {
                block9: {
                    this.storeUndoCopy();
                    if (sliceDirection != 0) break block9;
                    int count = 0;
                    int ctrNew = 0;
                    for (POI current = this.pointsAxial[sliceNum]; current != null; current = current.getNextAxial()) {
                        if (onlySelected && !current.isSelected()) continue;
                        ++count;
                    }
                    POI[] newPOIs = new POI[count];
                    for (POI current = this.pointsAxial[sliceNum]; current != null; current = current.getNextAxial()) {
                        if (onlySelected && !current.isSelected()) continue;
                        POI clonedCopy = null;
                        clonedCopy = current.copy();
                        clonedCopy.reflectPOI(sliceDirection, vertical, line);
                        clonedCopy.setSelectedState(false);
                        clonedCopy.setColor(color);
                        newPOIs[ctrNew++] = clonedCopy;
                    }
                    for (int ctr = 0; ctr < ctrNew; ++ctr) {
                        if (newPOIs[ctr].getX() < 0 || newPOIs[ctr].getX() >= this.xDim || newPOIs[ctr].getY() < 0 || newPOIs[ctr].getY() >= this.yDim || newPOIs[ctr].getZ() < 0 || newPOIs[ctr].getZ() >= this.zDim) continue;
                        this.addPOI(newPOIs[ctr], false, true);
                    }
                    break block10;
                }
                if (sliceDirection != 1) break block11;
                int count = 0;
                int ctrNew = 0;
                for (POI current = this.pointsCoronal[sliceNum]; current != null; current = current.getNextCoronal()) {
                    if (onlySelected && !current.isSelected()) continue;
                    ++count;
                }
                POI[] newPOIs = new POI[count];
                for (POI current = this.pointsCoronal[sliceNum]; current != null; current = current.getNextCoronal()) {
                    if (onlySelected && !current.isSelected()) continue;
                    POI clonedCopy = null;
                    clonedCopy = current.copy();
                    clonedCopy.reflectPOI(sliceDirection, vertical, line);
                    clonedCopy.setSelectedState(false);
                    clonedCopy.setColor(color);
                    newPOIs[ctrNew++] = clonedCopy;
                }
                for (int ctr = 0; ctr < ctrNew; ++ctr) {
                    if (newPOIs[ctr].getX() < 0 || newPOIs[ctr].getX() >= this.xDim || newPOIs[ctr].getY() < 0 || newPOIs[ctr].getY() >= this.yDim || newPOIs[ctr].getZ() < 0 || newPOIs[ctr].getZ() >= this.zDim) continue;
                    this.addPOI(newPOIs[ctr], false, true);
                }
                break block10;
            }
            if (sliceDirection != 2) break block10;
            int count = 0;
            int ctrNew = 0;
            for (POI current = this.pointsSagittal[sliceNum]; current != null; current = current.getNextSagittal()) {
                if (onlySelected && !current.isSelected()) continue;
                ++count;
            }
            POI[] newPOIs = new POI[count];
            for (POI current = this.pointsSagittal[sliceNum]; current != null; current = current.getNextSagittal()) {
                if (onlySelected && !current.isSelected()) continue;
                POI clonedCopy = null;
                clonedCopy = current.copy();
                clonedCopy.reflectPOI(sliceDirection, vertical, line);
                clonedCopy.setSelectedState(false);
                clonedCopy.setColor(color);
                newPOIs[ctrNew++] = clonedCopy;
            }
            for (int ctr = 0; ctr < ctrNew; ++ctr) {
                if (newPOIs[ctr].getX() < 0 || newPOIs[ctr].getX() >= this.xDim || newPOIs[ctr].getY() < 0 || newPOIs[ctr].getY() >= this.yDim || newPOIs[ctr].getZ() < 0 || newPOIs[ctr].getZ() >= this.zDim) continue;
                this.addPOI(newPOIs[ctr], false, true);
            }
        }
    }

    public void removePOI(POI poi, boolean storeCopy, boolean notifyUser) {
        POI current;
        if (storeCopy) {
            this.storeUndoCopy();
        }
        POI previous = null;
        for (current = this.pointsAxial[poi.axialSlice]; current != null; current = current.getNextAxial()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextAxial(current.getNextAxial());
                } else {
                    this.pointsAxial[poi.axialSlice] = current.getNextAxial();
                }
            }
            previous = current;
        }
        previous = null;
        for (current = this.pointsCoronal[poi.coronalSlice]; current != null; current = current.getNextCoronal()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextCoronal(current.getNextCoronal());
                } else {
                    this.pointsCoronal[poi.coronalSlice] = current.getNextCoronal();
                }
            }
            previous = current;
        }
        previous = null;
        for (current = this.pointsSagittal[poi.sagittalSlice]; current != null; current = current.getNextSagittal()) {
            if (current == poi) {
                if (previous != null) {
                    previous.setNextSagittal(current.getNextSagittal());
                } else {
                    this.pointsSagittal[poi.sagittalSlice] = current.getNextSagittal();
                }
            }
            previous = current;
        }
        if (notifyUser) {
            poi.notifyUserOfDeletion();
        }
    }

    public void removePoint(Coordinate coor, int aColor) {
        for (POI current = this.pointsAxial[coor.zInt]; current != null; current = current.getNextAxial()) {
            if (current.getX() != coor.xInt || current.getY() != coor.yInt || current.getColor() != aColor) continue;
            this.removePOI(current);
        }
    }

    public void removeSelectedPOIs() {
        this.storeUndoCopy();
        POI[] pOIArray = this.pointsAxial;
        int n = pOIArray.length;
        for (int i = 0; i < n; ++i) {
            POI element;
            for (POI current = element = pOIArray[i]; current != null; current = current.getNextAxial()) {
                if (!current.isSelected()) continue;
                this.removePOI(current, false, true);
            }
        }
    }

    public void removeSelectedPOIsInSlice(int slice, int sliceDirection) {
        block4: {
            block5: {
                block3: {
                    this.storeUndoCopy();
                    if (sliceDirection != 0) break block3;
                    for (POI current = this.pointsAxial[slice]; current != null; current = current.getNextAxial()) {
                        if (!current.isSelected()) continue;
                        this.removePOI(current, false, true);
                    }
                    break block4;
                }
                if (sliceDirection != 1) break block5;
                for (POI current = this.pointsCoronal[slice]; current != null; current = current.getNextCoronal()) {
                    if (!current.isSelected()) continue;
                    this.removePOI(current, false, true);
                }
                break block4;
            }
            if (sliceDirection != 2) break block4;
            for (POI current = this.pointsSagittal[slice]; current != null; current = current.getNextSagittal()) {
                if (!current.isSelected()) continue;
                this.removePOI(current, false, true);
            }
        }
    }

    public void resetClipboards() {
        this.hasRedo = false;
        this.hasUndo = false;
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            this.pointsRedo[ctr] = null;
            this.pointsUndo[ctr] = null;
        }
    }

    public void selectAll() {
        this.setSelectedStateAll(true);
    }

    public void setDirty(boolean bool) {
        this.isDirty = bool;
    }

    public void setPOIs(List<POI> pois) {
        Iterator<POI> it = pois.iterator();
        while (it.hasNext()) {
            this.addPOI(it.next(), false, false);
        }
    }

    public void storeUndoCopy() {
        this.isDirty = true;
        this.hasUndo = true;
        this.hasRedo = false;
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            this.pointsUndo[ctr] = null;
            if (this.pointsAxial[ctr] == null) continue;
            this.pointsUndo[ctr] = this.pointsAxial[ctr].copy();
            this.pointsUndo[ctr].setSelectedState(false);
            POI currentUndoPOI = this.pointsUndo[ctr];
            for (POI currentPOI = this.pointsAxial[ctr].getNextAxial(); currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                POI nextPOI = currentPOI.copy();
                nextPOI.setSelectedState(false);
                currentUndoPOI.setNextAxial(nextPOI);
                currentUndoPOI = nextPOI;
            }
        }
    }

    public void translate(int slice, int sliceDirection, int xTrans, int yTrans, int aColor) {
        block6: {
            boolean storedCopy;
            block8: {
                block7: {
                    POI somePOIs = this.getPOIs(slice, sliceDirection);
                    storedCopy = false;
                    if (somePOIs == null) break block6;
                    if (sliceDirection != 0) break block7;
                    for (POI currentPOI = somePOIs; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                        if (!currentPOI.isSelected() || currentPOI.getColor() != aColor) continue;
                        if (!storedCopy) {
                            this.storeUndoCopy();
                            storedCopy = true;
                        }
                        currentPOI.xLoc += xTrans;
                        currentPOI.yLoc += yTrans;
                        this.updatePOI(currentPOI);
                        this.listener.pointChangingStopped(currentPOI);
                    }
                    break block6;
                }
                if (sliceDirection != 1) break block8;
                for (POI currentPOI = somePOIs; currentPOI != null; currentPOI = currentPOI.getNextCoronal()) {
                    if (!currentPOI.isSelected() || currentPOI.getColor() != aColor) continue;
                    if (!storedCopy) {
                        this.storeUndoCopy();
                        storedCopy = true;
                    }
                    currentPOI.xLoc += xTrans;
                    currentPOI.zLoc += yTrans;
                    this.updatePOI(currentPOI);
                    this.listener.pointChangingStopped(currentPOI);
                }
                break block6;
            }
            if (sliceDirection != 2) break block6;
            for (POI currentPOI = somePOIs; currentPOI != null; currentPOI = currentPOI.getNextSagittal()) {
                if (!currentPOI.isSelected() || currentPOI.getColor() != aColor) continue;
                if (!storedCopy) {
                    this.storeUndoCopy();
                    storedCopy = true;
                }
                currentPOI.yLoc += xTrans;
                currentPOI.zLoc += yTrans;
                this.updatePOI(currentPOI);
                this.listener.pointChangingStopped(currentPOI);
            }
        }
    }

    public void undo() {
        this.hasUndo = false;
        this.hasRedo = true;
        this.isDirty = true;
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            this.pointsRedo[ctr] = this.pointsAxial[ctr];
            this.pointsAxial[ctr] = this.pointsUndo[ctr];
            this.pointsUndo[ctr] = null;
        }
        this.reconcileWithAxial();
        this.deselectAll();
        if (this.user != null) {
            this.user.updateAllPoints();
        }
    }

    public void updatePOI(POI updatingPOI) {
        int xLoc = updatingPOI.getX();
        int yLoc = updatingPOI.getY();
        int zLoc = updatingPOI.getZ();
        if (xLoc < 0) {
            xLoc = 0;
        } else if (xLoc >= this.xDim) {
            xLoc = this.xDim - 1;
        }
        if (yLoc < 0) {
            yLoc = 0;
        } else if (yLoc >= this.yDim) {
            yLoc = this.yDim - 1;
        }
        if (zLoc < 0) {
            zLoc = 0;
        } else if (zLoc >= this.zDim) {
            zLoc = this.zDim - 1;
        }
        updatingPOI.updatePOI(new java.awt.Point(xLoc, yLoc), zLoc, 0);
        this.isDirty = true;
        this.removePOI(updatingPOI, false);
        updatingPOI.clearNext();
        updatingPOI.reconcileSlices();
        this.addPOI(updatingPOI, false);
    }

    private void addPOI(POI poi) {
        this.addPOI(poi, true, false);
    }

    private void reconcileWithAxial() {
        int ctr;
        for (ctr = 0; ctr < this.yDim; ++ctr) {
            this.pointsCoronal[ctr] = null;
        }
        for (ctr = 0; ctr < this.xDim; ++ctr) {
            this.pointsSagittal[ctr] = null;
        }
        for (ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                currentPOI.setNextCoronal(null);
                currentPOI.setNextSagittal(null);
                int yLoc = currentPOI.getY();
                if (this.pointsCoronal[yLoc] == null) {
                    this.pointsCoronal[yLoc] = currentPOI;
                } else {
                    POI currentPOICor = this.pointsCoronal[yLoc];
                    while (currentPOICor.getNextCoronal() != null) {
                        currentPOICor = currentPOICor.getNextCoronal();
                    }
                    currentPOICor.setNextCoronal(currentPOI);
                }
                int xLoc = currentPOI.getX();
                if (this.pointsSagittal[xLoc] == null) {
                    this.pointsSagittal[xLoc] = currentPOI;
                    continue;
                }
                POI currentPOISag = this.pointsSagittal[xLoc];
                while (currentPOISag.getNextSagittal() != null) {
                    currentPOISag = currentPOISag.getNextSagittal();
                }
                currentPOISag.setNextSagittal(currentPOI);
            }
        }
    }

    private void removePOI(POI poi) {
        this.removePOI(poi, true);
    }

    private void removePOI(POI poi, boolean storeCopy) {
        this.removePOI(poi, storeCopy, false);
    }

    private void setSelectedStateAll(boolean bool) {
        POI[] pOIArray = this.pointsAxial;
        int n = pOIArray.length;
        for (int i = 0; i < n; ++i) {
            POI element;
            for (POI current = element = pOIArray[i]; current != null; current = current.getNextAxial()) {
                current.setSelectedState(bool);
            }
        }
    }

    public String getAllLabelsForColor(int colorIndex) {
        StringBuffer sb = new StringBuffer("<html>");
        for (int ctr = 0; ctr < this.zDim; ++ctr) {
            if (this.pointsAxial[ctr] == null) continue;
            for (POI currentPOI = this.pointsAxial[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                if (currentPOI.getColor() != colorIndex) continue;
                sb.append(currentPOI.getLabel(true));
                sb.append("<br>");
            }
        }
        sb.append("</html>");
        return sb.toString();
    }
}

