/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.points.display;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class POIPathIterator
implements PathIterator {
    private Color selectedColor;
    private boolean done;
    private final AffineTransform transform;
    private final Color specialColor;
    private final Graphics2D g2d;
    private final Point point;
    private final Point2D.Double tempTransformedPoint;
    private final Point2D.Double transformedPoint;
    private final boolean isActive;
    private final boolean isHighlighted;
    private final boolean isImmutable;
    private final boolean isSelected;
    private final boolean isSpecial;
    private static Ellipse2D.Double handle = new Ellipse2D.Double();
    private static Ellipse2D.Double handleOutter = new Ellipse2D.Double();
    private static Rectangle2D.Double pointRect = new Rectangle2D.Double(0.0, 0.0, 3.0, 3.0);
    private static final Color INACTIVE_COLOR = Color.DARK_GRAY;
    private static float[] tempFlt = new float[2];

    protected POIPathIterator(Point aPoint, AffineTransform aTransform, boolean selected, boolean special, boolean highlighted, boolean immutable, Color aColor, boolean active, Graphics2D ag2d) {
        this.point = aPoint;
        this.transform = aTransform;
        this.isSelected = selected;
        this.isHighlighted = highlighted;
        this.isSpecial = special;
        this.isImmutable = immutable;
        this.specialColor = aColor;
        this.isActive = active;
        this.g2d = ag2d;
        this.transformedPoint = new Point2D.Double();
        this.tempTransformedPoint = new Point2D.Double();
    }

    @Override
    public int currentSegment(double[] coords) {
        int type = this.currentSegment(tempFlt);
        coords[0] = tempFlt[0];
        coords[1] = tempFlt[1];
        return type;
    }

    @Override
    public int currentSegment(float[] coords) {
        this.tempTransformedPoint.setLocation((double)this.point.x + 0.5, (double)this.point.y + 0.5);
        this.transform.transform(this.tempTransformedPoint, this.transformedPoint);
        coords[0] = (float)this.transformedPoint.getX();
        coords[1] = (float)this.transformedPoint.getY();
        if (this.g2d != null) {
            Color oldColor = this.g2d.getColor();
            if (this.specialColor != null) {
                this.g2d.setColor(this.specialColor);
            }
            if (this.isHighlighted) {
                this.g2d.setColor(Color.WHITE);
            }
            pointRect.setRect((int)this.transformedPoint.x - 1, (int)this.transformedPoint.y - 1, 5.0, 5.0);
            handle.setFrame((int)this.transformedPoint.x - 2, (int)this.transformedPoint.y - 2, 7.0, 7.0);
            handleOutter.setFrame((int)this.transformedPoint.x - 3, (int)this.transformedPoint.y - 3, 9.0, 9.0);
            this.selectedColor = this.isActive || this.isHighlighted || this.isSpecial && !this.isImmutable ? Color.WHITE : INACTIVE_COLOR;
            if (this.isSpecial) {
                if (this.isHighlighted) {
                    if (this.isImmutable) {
                        this.g2d.fill(handle);
                    } else {
                        this.g2d.draw(handle);
                    }
                    this.g2d.setColor(this.selectedColor);
                    this.g2d.draw(handleOutter);
                } else {
                    this.g2d.fill(handle);
                    if (!this.isImmutable) {
                        this.g2d.setColor(this.selectedColor);
                        this.g2d.draw(handleOutter);
                    }
                }
            } else {
                this.g2d.fill(handle);
                if (this.isSelected) {
                    this.g2d.setColor(this.selectedColor);
                    this.g2d.draw(handleOutter);
                }
            }
            this.g2d.setColor(oldColor);
        }
        this.done = true;
        return 0;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
    }
}

