/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.points.clipboard;

import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.manager.POIManager;

public class POIClipboard {
    private POI[] pois;
    private boolean singleSliceMode;
    private double xSize;
    private double ySize;
    private double zSize;
    private int copyDirection;
    private int copySlice;
    private int numSlices;
    private int pasteColor;

    public boolean canPaste() {
        return this.hasContents();
    }

    public void copy(POIManager manager, int slices, double sizeX, double sizeY, double sizeZ, boolean mode, int direction, int slice) {
        POI[] copiedPOIs = manager.getAllSelectedPOIsClone();
        this.pois = copiedPOIs;
        this.numSlices = slices;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.zSize = sizeZ;
        this.singleSliceMode = mode;
        this.copyDirection = direction;
        this.copySlice = slice;
    }

    public long getCopyMask() {
        long copyMask = 0L;
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (POI currentPOI = this.pois[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                copyMask |= 1L << currentPOI.getColor();
            }
        }
        return copyMask;
    }

    public boolean hasContents() {
        return this.pois != null;
    }

    public void paste(POIManager manager) {
        manager.storeUndoCopy();
        if (this.singleSliceMode) {
            int pasteSlice = this.copyDirection == 0 ? manager.getAxialSliceNumber() : (this.copyDirection == 1 ? manager.getCoronalSliceNumber() : manager.getSagittalSliceNumber());
            for (int ctr = 0; ctr < this.numSlices; ++ctr) {
                for (POI currentPOI = this.pois[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    if (!this.isCopySlice(currentPOI)) continue;
                    double xLocMM = (double)currentPOI.getX() * this.xSize;
                    double yLocMM = (double)currentPOI.getY() * this.ySize;
                    double zLocMM = (double)currentPOI.getZ() * this.zSize;
                    int xLoc = (int)(xLocMM / manager.getXSize());
                    int yLoc = (int)(yLocMM / manager.getYSize());
                    int zLoc = (int)(zLocMM / manager.getZSize());
                    POI poiToAdd = this.copyDirection == 0 ? currentPOI.copyAndPlace(xLoc, yLoc, pasteSlice) : (this.copyDirection == 1 ? currentPOI.copyAndPlace(xLoc, pasteSlice, zLoc) : currentPOI.copyAndPlace(pasteSlice, yLoc, zLoc));
                    if (this.pasteColor != -1) {
                        poiToAdd.setColor(this.pasteColor);
                    }
                    manager.addPOI(poiToAdd, false);
                }
            }
        } else {
            for (int ctr = 0; ctr < this.numSlices; ++ctr) {
                for (POI currentPOI = this.pois[ctr]; currentPOI != null; currentPOI = currentPOI.getNextAxial()) {
                    double xLocMM = (double)currentPOI.getX() * this.xSize;
                    double yLocMM = (double)currentPOI.getY() * this.ySize;
                    double zLocMM = (double)currentPOI.getZ() * this.zSize;
                    int xLoc = (int)(xLocMM / manager.getXSize());
                    int yLoc = (int)(yLocMM / manager.getYSize());
                    int zLoc = (int)(zLocMM / manager.getZSize());
                    POI poiToAdd = currentPOI.copyAndPlace(xLoc, yLoc, zLoc);
                    if (this.pasteColor != -1) {
                        poiToAdd.setColor(this.pasteColor);
                    }
                    manager.addPOI(poiToAdd, false);
                }
            }
        }
    }

    public void reset() {
        this.pois = null;
    }

    public void setPasteColor(int aColor) {
        this.pasteColor = aColor;
    }

    public void setPasteColorAsCopyColor() {
        this.pasteColor = -1;
    }

    private boolean isCopySlice(POI poi) {
        int slice = this.copyDirection == 0 ? poi.getZ() : (this.copyDirection == 1 ? poi.getY() : poi.getX());
        return slice == this.copySlice;
    }
}

