/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.points;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.roi.Point;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.points.PointListener;
import edu.uthscsa.ric.roi.points.PointUser;
import edu.uthscsa.ric.roi.points.display.POIShape;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import edu.uthscsa.ric.volume.operations.stats.PointStatROIOp;
import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.commons.lang3.StringUtils;

public class POI
implements Point,
ROI {
    private Color specialColor;
    private Graphics2D g2d;
    private POI nextPOIAxial;
    private POI nextPOICoronal;
    private POI nextPOISagittal;
    private PointUser user;
    private PointListener listener;
    private String name;
    private boolean isHighlighted;
    private boolean isImmutable;
    private boolean isSelected;
    private boolean isSpecial;
    private VolumeData volData;
    private final POIShape axialShape;
    private final POIShape coronalShape;
    private final POIShape sagittalShape;
    public int axialSlice;
    public int color;
    public int coronalSlice;
    public int sagittalSlice;
    public int xLoc;
    public int yLoc;
    public int zLoc;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter();

    public POI(int locX, int locY, int locZ, int aColor) {
        this(locX, locY, locZ, aColor, false);
    }

    public POI(int locX, int locY, int locZ, int aColor, boolean immutable) {
        this.xLoc = this.sagittalSlice = locX;
        this.yLoc = this.coronalSlice = locY;
        this.zLoc = this.axialSlice = locZ;
        this.axialShape = new POIShape(this.xLoc, this.yLoc, this);
        this.coronalShape = new POIShape(this.xLoc, this.zLoc, this);
        this.sagittalShape = new POIShape(this.yLoc, this.zLoc, this);
        this.color = aColor;
        this.isImmutable = immutable;
    }

    public void clearNext() {
        this.nextPOISagittal = null;
        this.nextPOICoronal = null;
        this.nextPOIAxial = null;
    }

    public POI copy() {
        POI poi = new POI(this.xLoc, this.yLoc, this.zLoc, this.color);
        poi.isSpecial = this.isSpecial;
        poi.isHighlighted = false;
        poi.isSelected = false;
        poi.specialColor = this.specialColor;
        poi.setListenerAndUser(this.user, this.listener);
        return poi;
    }

    public POI copyAndPlace(int locX, int locY, int locZ) {
        POI poi = new POI(locX, locY, locZ, this.color);
        poi.isSpecial = this.isSpecial;
        poi.isHighlighted = false;
        poi.isSelected = false;
        poi.specialColor = this.specialColor;
        poi.setListenerAndUser(this.user, this.listener);
        return poi;
    }

    public POIShape getAxialShape() {
        return this.axialShape;
    }

    public int getColor() {
        return this.color;
    }

    public POIShape getCoronalShape() {
        return this.coronalShape;
    }

    public String getDefaultLabel() {
        Coordinate coor = new Coordinate();
        boolean isWorldMode = this.user.isWorldMode();
        coor.setValues((double)this.xLoc, (double)this.yLoc, (double)this.zLoc);
        if (isWorldMode) {
            this.volData.convertIndexToWorldCoordinate(coor);
        }
        return "Point (" + FORMATTER.format(coor.xDbl) + ", " + FORMATTER.format(coor.yDbl) + ", " + FORMATTER.format(coor.zDbl) + ")";
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }

    public String getLabel(boolean canUseDefault) {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name;
        }
        if (canUseDefault) {
            return this.getDefaultLabel();
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public POI getNext(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getNextAxial();
        }
        if (sliceDirection == 1) {
            return this.getNextCoronal();
        }
        if (sliceDirection == 2) {
            return this.getNextSagittal();
        }
        return null;
    }

    public POI getNextAxial() {
        return this.nextPOIAxial;
    }

    public POI getNextCoronal() {
        return this.nextPOICoronal;
    }

    public POI getNextSagittal() {
        return this.nextPOISagittal;
    }

    public ImageBounds getROIBounds(boolean useSeries) {
        return new ImageBounds(this.xLoc, this.xLoc, this.yLoc, this.yLoc, this.zLoc, this.zLoc);
    }

    public POIShape getSagittalShape() {
        return this.sagittalShape;
    }

    public POIShape getShape(int direction) {
        if (direction == 0) {
            return this.getAxialShape();
        }
        if (direction == 1) {
            return this.getCoronalShape();
        }
        if (direction == 2) {
            return this.getSagittalShape();
        }
        return null;
    }

    public Color getSpecialColor() {
        return this.specialColor;
    }

    public AnalysisImpl getStats() {
        return this.getStats(0);
    }

    public AnalysisImpl getStats(int timepointVal) {
        PointStatROIOp op = new PointStatROIOp(this.user, (Volume)this.user.getCurrentVolume(), this.user.getROIManager().getBuffer());
        return (AnalysisImpl)op.process(this, timepointVal);
    }

    public PointUser getUser() {
        return this.user;
    }

    public int getX() {
        return this.xLoc;
    }

    public int getY() {
        return this.yLoc;
    }

    public int getZ() {
        return this.zLoc;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public void notifyUserOfDeletion() {
        if (this.listener != null) {
            this.listener.pointDeleted(this);
        }
    }

    public void reconcileSlices() {
        this.sagittalSlice = this.xLoc;
        this.coronalSlice = this.yLoc;
        this.axialSlice = this.zLoc;
    }

    public void reflectPOI(int sliceDirection, boolean verticalLine, int line) {
        if (sliceDirection == 0) {
            if (verticalLine) {
                this.xLoc += (line - this.xLoc) * 2;
            } else {
                this.yLoc += (line - this.yLoc) * 2;
            }
        } else if (sliceDirection == 1) {
            if (verticalLine) {
                this.xLoc += (line - this.xLoc) * 2;
            } else {
                this.zLoc += (line - this.zLoc) * 2;
            }
        } else if (sliceDirection == 2) {
            if (verticalLine) {
                this.yLoc += (line - this.yLoc) * 2;
            } else {
                this.zLoc += (line - this.zLoc) * 2;
            }
        }
        this.updatePOI(new java.awt.Point(this.xLoc, this.yLoc), this.zLoc, 0);
    }

    public void setColor(int val) {
        this.color = val;
    }

    public void setGraphics(Graphics2D ag2d) {
        this.g2d = ag2d;
    }

    public void setHighlighted(boolean bool) {
        this.isHighlighted = bool;
    }

    public void setImmutable(boolean bool) {
        this.isImmutable = bool;
    }

    public void setName(String name) {
        this.name = name;
        if (this.listener != null) {
            this.listener.pointLabelChanged(this);
        }
    }

    public void setNextAxial(POI aPOI) {
        this.nextPOIAxial = aPOI;
    }

    public void setNextCoronal(POI aPOI) {
        this.nextPOICoronal = aPOI;
    }

    public void setNextSagittal(POI aPOI) {
        this.nextPOISagittal = aPOI;
    }

    public void setSelectedState(boolean bool) {
        this.setSelectedState(bool, false);
    }

    public void setSpecialColor(Color aColor) {
        this.specialColor = aColor;
    }

    public void setSpecialState(boolean bool) {
        this.isSpecial = bool;
    }

    public void setListenerAndUser(PointUser user, PointListener listener) {
        this.user = user;
        this.listener = listener;
        this.volData = new VolumeData(user);
    }

    public void setX(int x) {
        this.xLoc = x;
    }

    public void setY(int y) {
        this.yLoc = y;
    }

    public void setZ(int z) {
        this.zLoc = z;
    }

    public void toggleSelectedState() {
        this.isSelected = !this.isSelected;
    }

    public String toString() {
        return this.getLabel(true);
    }

    public void updatePOI(java.awt.Point aPoint, int currentSlice, int sliceDirection) {
        if (sliceDirection == 0) {
            this.axialShape.xLoc = this.coronalShape.xLoc = aPoint.x;
            this.xLoc = this.coronalShape.xLoc;
            this.axialShape.yLoc = this.sagittalShape.xLoc = aPoint.y;
            this.yLoc = this.sagittalShape.xLoc;
            this.coronalShape.yLoc = this.sagittalShape.yLoc = currentSlice;
            this.zLoc = this.sagittalShape.yLoc;
        } else if (sliceDirection == 1) {
            this.axialShape.xLoc = this.coronalShape.xLoc = aPoint.x;
            this.xLoc = this.coronalShape.xLoc;
            this.axialShape.yLoc = this.sagittalShape.xLoc = currentSlice;
            this.yLoc = this.sagittalShape.xLoc;
            this.coronalShape.yLoc = this.sagittalShape.yLoc = aPoint.y;
            this.zLoc = this.sagittalShape.yLoc;
        } else if (sliceDirection == 2) {
            this.axialShape.xLoc = this.coronalShape.xLoc = currentSlice;
            this.xLoc = this.coronalShape.xLoc;
            this.axialShape.yLoc = this.sagittalShape.xLoc = aPoint.x;
            this.yLoc = this.sagittalShape.xLoc;
            this.coronalShape.yLoc = this.sagittalShape.yLoc = aPoint.y;
            this.zLoc = this.sagittalShape.yLoc;
        }
    }

    private void setSelectedState(boolean bool, boolean forceSpecial) {
        if (bool || !this.isSpecial || forceSpecial) {
            this.isSelected = bool;
        }
    }
}

