/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.manager;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ConvexHull3D;
import edu.uthscsa.ric.roi.EquivalentSet;
import edu.uthscsa.ric.roi.EquivalentSetManager;
import edu.uthscsa.ric.roi.Metadata;
import edu.uthscsa.ric.roi.MetadataUser;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.ROIMaskManager;
import edu.uthscsa.ric.roi.ROIOperationTreeNode;
import edu.uthscsa.ric.roi.mask.Mask;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.buffers.ROIByteBuffer;
import edu.uthscsa.ric.roi.mask.buffers.ROIIntBuffer;
import edu.uthscsa.ric.roi.mask.buffers.ROILongBuffer;
import edu.uthscsa.ric.roi.mask.buffers.ROIShortBuffer;
import edu.uthscsa.ric.roi.mask.clipboard.ROIClipboard;
import edu.uthscsa.ric.roi.mask.clipboard.ROIClipboardUser;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import edu.uthscsa.ric.roi.mask.manager.ROIData;
import edu.uthscsa.ric.roi.mask.manager.ROIListener;
import edu.uthscsa.ric.roi.mask.manager.ROIUser;
import edu.uthscsa.ric.roi.mask.manager.Solid;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageData;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.LabelList;
import edu.uthscsa.ric.volume.LabelListener;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;

public class ROIManager
implements ROIMaskManager,
ColorManager,
LabelManager {
    private ByteBuffer workBuffer;
    private ImageBounds undoBounds;
    private LabelListener labelListener;
    private Mask[] rois;
    private AbstractROIBuffer roiBuffer;
    private ROIListener listener;
    private ROIShape[] axialROIShape;
    private ROIShape[] coronalROIShape;
    private ROIShape[] sagittalROIShape;
    private ROIShape[] axialROIShapeSurface;
    private ROIShape[] coronalROIShapeSurface;
    private ROIShape[] sagittalROIShapeSurface;
    private final ROIUser user;
    private Volume loadedROIVolume;
    private boolean editingDisabled;
    private boolean hasRedo;
    private boolean hasUndo;
    private boolean isDirty;
    private int axialSelectedSlice;
    private int coronalSelectedSlice;
    private int currentROI;
    private int kernelSize;
    private int sagittalSelectedSlice;
    private int undoDirection;
    private int[] xyBuffer;
    private int[] xzBuffer;
    private int[] yzBuffer;
    private final Map<Integer, Solid> solidShapeMap;
    private final HashMap<Integer, ClusterRejectionData> clusterData = new HashMap(64);
    private final LabelList labels;
    private final ROIClipboard editClipboard;
    private final ROIClipboard redoClipboard;
    private final ROIClipboard undoClipboard;
    private final byte[][] axialROIShapeData;
    private final byte[][] coronalROIShapeData;
    private final byte[][] sagittalROIShapeData;
    private final byte[][] axialROIShapeDataSurface;
    private final byte[][] coronalROIShapeDataSurface;
    private final byte[][] sagittalROIShapeDataSurface;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    private final int[] axialBuffer2;
    private final int[] axialBuffer;
    public static final String MANGO_ROI_DESCRIPTION = "Mango ROI";
    public static final String MESSAGE_ADDED = "added";
    public static final String MESSAGE_CALCULATED = "calculated";
    public static final String MESSAGE_CLEARED = "cleared";
    public static final String MESSAGE_COPIED = "copied";
    public static final String MESSAGE_CREATED = "created";
    public static final String MESSAGE_DILATED = "dilated";
    public static final String MESSAGE_ERODED = "eroded";
    public static final String MESSAGE_FILTERED = "filtered";
    public static final String MESSAGE_GREW = "grew";
    public static final String MESSAGE_IMPORTED = "imported";
    public static final String MESSAGE_LOADED = "loaded";
    public static final String MESSAGE_PASTED = "pasted";
    public static final String MESSAGE_PRESERVED = "preserved";
    public static final String MESSAGE_PROPAGATED = "propagated";
    public static final String MESSAGE_REFLECTED = "reflected";
    public static final String MESSAGE_REMOVED = "removed";
    public static final String MESSAGE_SHAPE_ADDED = "shape added";
    public static final String MESSAGE_SHAPE_EDITED = "shape edited";
    public static final String MESSAGE_SHAPE_EDIT_PROPAGATED = "shape edit propagated";
    public static final String MESSAGE_SHRINK_WRAPPED = "shrink wrapped";
    public static final String MESSAGE_UNDONE = "undone";
    public static final String PROGRESS_DESCRIPTION_ADD = "Adding";
    public static final String PROGRESS_DESCRIPTION_CALCULATE = "Calculating";
    public static final String PROGRESS_DESCRIPTION_CLEAR = "Clearing";
    public static final String PROGRESS_DESCRIPTION_COPY = "Copying";
    public static final String PROGRESS_DESCRIPTION_DILATE = "Dilating";
    public static final String PROGRESS_DESCRIPTION_ERODE = "Eroding";
    public static final String PROGRESS_DESCRIPTION_FILTER = "Filtering ROI";
    public static final String PROGRESS_DESCRIPTION_FIND = "Finding Region";
    public static final String PROGRESS_DESCRIPTION_FIND_CLUSTERS = "Finding Clusters";
    public static final String PROGRESS_DESCRIPTION_IMPORT = "Importing";
    public static final String PROGRESS_DESCRIPTION_LOAD = "Loading";
    public static final String PROGRESS_DESCRIPTION_MAKE = "Making ROI";
    public static final String PROGRESS_DESCRIPTION_PASTE = "Pasting";
    public static final String PROGRESS_DESCRIPTION_PRESERVE = "Preserving";
    public static final String PROGRESS_DESCRIPTION_PROPAGATE = "Propagating";
    public static final String PROGRESS_DESCRIPTION_REFLECT = "Reflecting";
    public static final String PROGRESS_DESCRIPTION_REMOVE = "Removing";
    public static final String PROGRESS_DESCRIPTION_SCAN = "Scanning";
    public static final String PROGRESS_DESCRIPTION_SHRINKWRAP = "Shrink Wrapping";
    public static final String PROGRESS_DESCRIPTION_UNDO = "Undoing";
    public static final String PROGRESS_DESCRIPTION_UPDATE = "Updating";
    public static final String ROI_FILE_EXTENSION = ".roi";
    public static final String WARNING_MESSAGE_NO_DATA = "No data was found in that range!";
    public static final String WARNING_TITLE = "ROI Operation Warning";
    public static final byte DOWN = -128;
    public static final byte MASK = 16;
    public static final byte RECENT = 8;
    public static final byte RIGHT = 64;
    public static final byte UNDO = 1;
    public static final int ALL_SLICES = -1;
    public static final int NO_SLICES = -2;
    public static final int DEFAULT_KERNEL_SIZE = 3;
    public static final int NIFTI_ECODE = 0;
    public static final int ROI_DRAW = 4;
    public static final int ROI_EDIT = 8;
    public static final int ROI_ELLIPSE = 2;
    public static final int ROI_ERASE = 16;
    public static final int ROI_FILL = 32;
    public static final int ROI_MAGIC_WAND = 1024;
    public static final int ROI_MAGIC_WAND_COPY = 32768;
    public static final int ROI_MAGIC_WAND_DELETE = 2048;
    public static final int ROI_MAGIC_WAND_DILATE = 16384;
    public static final int ROI_MAGIC_WAND_ERODE = 8192;
    public static final int ROI_MAGIC_WAND_PRESERVE = 4096;
    public static final int ROI_POLYLINE = 128;
    public static final int ROI_RECTANGLE = 1;
    public static final int ROI_SHAPE = 64;
    public static final int ROI_TOOL_EDIT_ELLIPSE = 10;
    public static final int ROI_TOOL_EDIT_RECTANGLE = 9;
    public static final int ROI_TOOL_ERASE_ELLIPSE = 18;
    public static final int ROI_TOOL_ERASE_RECTANGLE = 17;
    public static final int ROI_TOOL_FILL_ELLIPSE = 38;
    public static final int ROI_TOOL_FILL_RECTANGLE = 37;
    public static final int ROI_TOOL_LOI = 384;
    public static final int ROI_TOOL_MAGIC_WAND = 1024;
    public static final int ROI_TOOL_MAGIC_WAND_COPY = 33792;
    public static final int ROI_TOOL_MAGIC_WAND_DELETE = 3072;
    public static final int ROI_TOOL_MAGIC_WAND_DILATE = 17408;
    public static final int ROI_TOOL_MAGIC_WAND_ERODE = 9216;
    public static final int ROI_TOOL_MAGIC_WAND_PRESERVE = 5120;
    public static final int ROI_TOOL_NULL = 0;
    public static final int ROI_TOOL_POI = 512;
    public static final int ROI_TOOL_SHAPE_ELLIPSE = 70;
    public static final int ROI_TOOL_SHAPE_POLYLINE = 132;
    public static final int ROI_TOOL_SHAPE_RECTANGLE = 69;
    public static final List<Integer> ROI_TYPES = CollectionUtilities.immutable((Integer[])new Integer[]{0, 10, 18, 38, 9, 17, 37, 69, 70, 132, 384, 512, 1024, 5120, 3072, 9216, 9216, 33792});
    private static final long[] MASKS = AbstractROIBuffer.getMasks();

    public static void findConnectedLabels(boolean[] contains, EquivalentSetManager equivSetManager, int seed) {
        EquivalentSet seedSet = equivSetManager.getSeedSet(seed);
        if (seedSet != null) {
            contains[seed] = true;
            Vector<Integer> labels = seedSet.getLabels();
            int numItems = labels.size();
            for (int ctr = 0; ctr < numItems; ++ctr) {
                contains[labels.get((int)ctr).intValue()] = true;
            }
        }
    }

    public static int rejectSmallClusters(boolean[] contains, EquivalentSetManager equivSetManager, double size) {
        Iterator<EquivalentSet> it = equivSetManager.getAllSets().iterator();
        int numClusters = 0;
        while (it.hasNext()) {
            EquivalentSet set = it.next();
            int count = equivSetManager.getCountsInSet(set);
            if (!((double)count >= size) || count <= 0) continue;
            ++numClusters;
            Vector<Integer> labels = set.getLabels();
            int numItems = labels.size();
            for (int ctr = 0; ctr < numItems; ++ctr) {
                contains[labels.get((int)ctr).intValue()] = true;
            }
        }
        return numClusters;
    }

    public static double rejectSmallClusters(boolean[] contains, EquivalentSetManager equivSetManager, int num) {
        Iterator<EquivalentSet> it = equivSetManager.getAllSetsOrdered().iterator();
        int numClusters = 0;
        double size = 0.0;
        while (it.hasNext()) {
            EquivalentSet set = it.next();
            if (numClusters >= num || !((size = (double)equivSetManager.getCountsInSet(set)) > 0.0)) continue;
            ++numClusters;
            Vector<Integer> labels = set.getLabels();
            int numItems = labels.size();
            for (int ctr = 0; ctr < numItems; ++ctr) {
                contains[labels.get((int)ctr).intValue()] = true;
            }
        }
        return size;
    }

    public ROIManager(ROIListener listener, ROIUser user, ROIClipboard clipboard, int dimX, int dimY, int dimZ) {
        int ctr;
        this.listener = listener;
        this.user = user;
        this.xDim = dimX + 1;
        this.yDim = dimY + 1;
        this.zDim = dimZ + 1;
        this.xyBuffer = new int[this.xDim * this.yDim];
        this.xzBuffer = new int[this.xDim * this.zDim];
        this.yzBuffer = new int[this.yDim * this.zDim];
        this.axialBuffer = new int[this.xDim * this.yDim];
        this.axialBuffer2 = new int[this.xDim * this.yDim];
        this.undoClipboard = new ROIClipboard();
        this.redoClipboard = new ROIClipboard();
        this.editClipboard = clipboard;
        this.roiBuffer = new ROIByteBuffer(this.xDim, this.yDim, this.zDim);
        this.axialROIShapeData = new byte[64][];
        this.coronalROIShapeData = new byte[64][];
        this.sagittalROIShapeData = new byte[64][];
        this.axialROIShapeDataSurface = new byte[64][];
        this.coronalROIShapeDataSurface = new byte[64][];
        this.sagittalROIShapeDataSurface = new byte[64][];
        this.axialROIShape = new ROIShape[64];
        this.coronalROIShape = new ROIShape[64];
        this.sagittalROIShape = new ROIShape[64];
        this.axialROIShapeSurface = new ROIShape[64];
        this.coronalROIShapeSurface = new ROIShape[64];
        this.sagittalROIShapeSurface = new ROIShape[64];
        for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            this.axialROIShape[ctr] = new ROIShape(ctr);
            this.coronalROIShape[ctr] = new ROIShape(ctr);
            this.sagittalROIShape[ctr] = new ROIShape(ctr);
            this.axialROIShapeSurface[ctr] = new ROIShape(ctr);
            this.coronalROIShapeSurface[ctr] = new ROIShape(ctr);
            this.sagittalROIShapeSurface[ctr] = new ROIShape(ctr);
        }
        this.rois = new Mask[this.roiBuffer.getMaximumColors()];
        for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            this.rois[ctr] = new Mask(this, ctr);
        }
        this.labels = new LabelList(this.roiBuffer.getMaximumColors(), false);
        this.kernelSize = 3;
        this.solidShapeMap = new HashMap<Integer, Solid>();
    }

    public void addMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, long mask) {
        int offset = xLoc + this.xDim * (yLoc + this.yDim * zLoc);
        this.roiBuffer.put(offset, tLoc, this.roiBuffer.getCurrent(offset) | mask);
    }

    public void addMaskValue(int xLoc, int yLoc, int zLoc, long mask) {
        int offset = xLoc + this.xDim * (yLoc + this.yDim * zLoc);
        this.roiBuffer.putCurrent(offset, this.roiBuffer.getCurrent(offset) | mask);
    }

    @Deprecated
    public void addROIMaskValue(int xLoc, int yLoc, int zLoc, byte roiVal) {
        int offsetROI = xLoc + this.xDim * (yLoc + this.yDim * zLoc);
        long inited = this.roiBuffer.getInited();
        if ((inited & (long)roiVal) != (long)roiVal) {
            this.initROIMask(roiVal);
        }
        if (this.roiBuffer.hasBuffer()) {
            long oldMaskData = this.roiBuffer.getCurrent(offsetROI);
            this.roiBuffer.putCurrent(offsetROI, oldMaskData | (long)(roiVal & 0xFF));
        }
    }

    @Deprecated
    public void addROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, byte roiVal) {
        int offsetROI = xLoc + this.xDim * (yLoc + this.yDim * zLoc);
        long inited = this.roiBuffer.getInited();
        if ((inited & (long)roiVal) != (long)roiVal) {
            this.initROIMask(roiVal);
        }
        long oldMaskData = this.roiBuffer.getCurrent(offsetROI);
        if (this.isUsing4dROI()) {
            this.roiBuffer.put(xLoc + this.xDim * (yLoc + this.yDim * zLoc), tLoc, oldMaskData | (long)(roiVal & 0xFF));
        } else {
            this.addROIMaskValue(xLoc, yLoc, zLoc, roiVal);
        }
    }

    public void addShape(final Coordinate startPoint, final int sizeX, final int sizeY, final int sizeZ, final double originalSize, final boolean isCube, final boolean isSphere) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doAddShape(startPoint, sizeX, sizeY, sizeZ, originalSize, isCube, isSphere);
            }
        }, "ROIManager.addShape() Thread");
        workThread.start();
    }

    public void runAddShape(Coordinate startPoint, int sizeX, int sizeY, int sizeZ, double originalSize, boolean isCube, boolean isSphere) {
        this.doAddShape(startPoint, sizeX, sizeY, sizeZ, originalSize, isCube, isSphere);
    }

    public void addShape2D(Coordinate startPoint, int sliceDirection, int sizeX, int sizeY, int sizeZ, double originalSize, boolean isSquare, boolean isCircle) {
        boolean addShape = (this.roiBuffer.getUsed() & MASKS[this.currentROI]) == 0L;
        this.willUseROI(this.currentROI);
        if (isSquare) {
            int distanceMinX = -1 * (sizeX / 2);
            int distanceMinY = -1 * (sizeY / 2);
            int distanceMinZ = -1 * (sizeZ / 2);
            int distanceMaxX = sizeX / 2 - (sizeX % 2 == 0 ? 1 : 0);
            int distanceMaxY = sizeY / 2 - (sizeY % 2 == 0 ? 1 : 0);
            int distanceMaxZ = sizeZ / 2 - (sizeZ % 2 == 0 ? 1 : 0);
            if (sliceDirection == 0) {
                this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, startPoint.zInt, startPoint.zInt), false, sliceDirection);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (ctrY + this.yDim * startPoint.zInt);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        double diffX = startPoint.xInt - ctrX;
                        double diffY = startPoint.yInt - ctrY;
                        double diffZ = 0.0;
                        if (diffX >= (double)distanceMinX && diffX <= (double)distanceMaxX && diffY >= (double)distanceMinY && diffY <= (double)distanceMaxY && 0.0 >= (double)distanceMinZ && 0.0 <= (double)distanceMaxZ) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            } else if (sliceDirection == 1) {
                this.willChangeROI(new ImageBounds(0, this.xDim - 2, startPoint.yInt, startPoint.yInt, 0, this.zDim - 2), false, sliceDirection);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (startPoint.yInt + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        double diffX = startPoint.xInt - ctrX;
                        double diffY = 0.0;
                        double diffZ = startPoint.zInt - ctrZ;
                        if (diffX >= (double)distanceMinX && diffX <= (double)distanceMaxX && 0.0 >= (double)distanceMinY && 0.0 <= (double)distanceMaxY && diffZ >= (double)distanceMinZ && diffZ <= (double)distanceMaxZ) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            } else if (sliceDirection == 2) {
                this.willChangeROI(new ImageBounds(startPoint.xInt, startPoint.xInt, 0, this.yDim - 2, 0, this.zDim - 2), false, sliceDirection);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        int offset = startPoint.xInt + this.xDim * (ctrY + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        double diffX = 0.0;
                        double diffY = startPoint.yInt - ctrY;
                        double diffZ = startPoint.zInt - ctrZ;
                        if (0.0 >= (double)distanceMinX && 0.0 <= (double)distanceMaxX && diffY >= (double)distanceMinY && diffY <= (double)distanceMaxY && diffZ >= (double)distanceMinZ && diffZ <= (double)distanceMaxZ) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            }
        } else if (isCircle) {
            Coordinate startCoor = new Coordinate();
            Coordinate currentCoor = new Coordinate();
            Volume volume = (Volume)this.user.getBaseVolume();
            double xSize = volume.getXSize();
            double ySize = volume.getYSize();
            double zSize = volume.getZSize();
            startCoor.setValues((double)startPoint.xInt * xSize, (double)startPoint.yInt * ySize, (double)startPoint.zInt * zSize);
            double radius = originalSize;
            if (sliceDirection == 0) {
                this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, startPoint.zInt, startPoint.zInt), false, sliceDirection);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (ctrY + this.yDim * startPoint.zInt);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        currentCoor.setValues((double)ctrX * xSize, (double)ctrY * ySize, (double)startPoint.zInt * zSize);
                        if (startCoor.distance(currentCoor) <= radius) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            } else if (sliceDirection == 1) {
                this.willChangeROI(new ImageBounds(0, this.xDim - 2, startPoint.yInt, startPoint.yInt, 0, this.zDim - 2), false, sliceDirection);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (startPoint.yInt + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        currentCoor.setValues((double)ctrX * xSize, (double)startPoint.yInt * ySize, (double)ctrZ * zSize);
                        if (startCoor.distance(currentCoor) <= radius) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            } else if (sliceDirection == 2) {
                this.willChangeROI(new ImageBounds(startPoint.xInt, startPoint.xInt, 0, this.yDim - 2, 0, this.zDim - 2), false, sliceDirection);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        int offset = startPoint.xInt + this.xDim * (ctrY + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        currentCoor.setValues((double)startPoint.xInt * xSize, (double)ctrY * ySize, (double)ctrZ * zSize);
                        if (startCoor.distance(currentCoor) <= radius) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_ADDED, MASKS[this.currentROI], -1);
        if (addShape) {
            Solid solid = new Solid(originalSize, isSquare ? 1 : 0);
            this.solidShapeMap.put(this.currentROI, solid);
        }
    }

    public void clear() {
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            this.axialROIShape[ctr].clear();
            this.coronalROIShape[ctr].clear();
            this.sagittalROIShape[ctr].clear();
            this.axialROIShapeSurface[ctr].clear();
            this.coronalROIShapeSurface[ctr].clear();
            this.sagittalROIShapeSurface[ctr].clear();
            this.sagittalROIShapeData[ctr] = null;
            this.coronalROIShapeData[ctr] = null;
            this.axialROIShapeData[ctr] = null;
            this.sagittalROIShapeDataSurface[ctr] = null;
            this.coronalROIShapeDataSurface[ctr] = null;
            this.axialROIShapeDataSurface[ctr] = null;
        }
        this.listener = null;
        this.sagittalROIShape = null;
        this.coronalROIShape = null;
        this.axialROIShape = null;
        this.sagittalROIShapeSurface = null;
        this.coronalROIShapeSurface = null;
        this.axialROIShapeSurface = null;
        this.yzBuffer = null;
        this.xzBuffer = null;
        this.xyBuffer = null;
    }

    public void clear(long mask, boolean skipResetClipboards, boolean sameThread) {
        this.clearRegion(new ImageBounds(0, this.xDim - 1, 0, this.yDim - 1, 0, this.zDim - 1), mask, skipResetClipboards, sameThread);
    }

    public void clear(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, long mask, boolean skipResetClipboards, boolean sameThread) {
        this.clearRegion(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), mask, skipResetClipboards, sameThread);
    }

    public void clearSelected(boolean skipResetClipboards) {
        this.clearRegion(new ImageBounds(0, this.xDim - 1, 0, this.yDim - 1, 0, this.zDim - 1), this.roiBuffer.getSelected(), skipResetClipboards, false);
    }

    public void clearSelected(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, boolean skipResetClipboards, boolean sameThread) {
        if (sameThread) {
            this.doClearRegion(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), this.roiBuffer.getSelected(), skipResetClipboards);
        } else {
            this.clearRegion(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), this.roiBuffer.getSelected(), skipResetClipboards, false);
        }
    }

    public void clearUsedROIs() {
        this.setUsedROIs(0L, false);
    }

    public void close2D(final int sliceNum, final int sliceDirection, final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runClose2D(sliceNum, sliceDirection, kernel, mask);
            }
        }, "ROIManager.close2D() Thread");
        workThread.start();
    }

    public void runClose2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.doDilate2D(sliceNum, sliceDirection, kernel, true, mask);
        this.doErode2D(sliceNum, sliceDirection, kernel, false, mask);
    }

    public void close3D(final int kernel, final long mask) {
        this.makeROIFileBuffer3D();
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runClose3D(kernel, mask);
            }
        }, "ROIManager.close3D() Thread");
        workThread.start();
    }

    public void runClose3D(int kernel, long mask) {
        this.doDilate3D(kernel, true, mask);
        this.doErode3D(kernel, false, mask);
    }

    public void copy(boolean sameThread) {
        this.editClipboard.setCurrentUser((ROIClipboardUser)((Object)this.listener));
        this.editClipboard.setCopyMask(this.roiBuffer.getSelected(), this.roiBuffer.getMaximumColors());
        if (this.user.isMultiSliceMode()) {
            if (sameThread) {
                if (this.isUsing4dROI()) {
                    this.editClipboard.setDimensions(this.getXDim(), this.getYDim(), this.getZDim(), this.roiBuffer.getSeriesLength(), this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize(), this.user.getOrigin());
                    this.doCopySeries();
                } else {
                    this.editClipboard.setDimensions(this.getXDim(), this.getYDim(), this.getZDim(), 1, this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize(), this.user.getOrigin());
                    this.doCopy();
                }
            } else {
                Thread workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (ROIManager.this.isUsing4dROI()) {
                            ROIManager.this.editClipboard.setDimensions(ROIManager.this.getXDim(), ROIManager.this.getYDim(), ROIManager.this.getZDim(), ROIManager.this.roiBuffer.getSeriesLength(), ROIManager.this.user.getBaseVolume().getXSize(), ROIManager.this.user.getBaseVolume().getYSize(), ROIManager.this.user.getBaseVolume().getZSize(), ROIManager.this.user.getOrigin());
                            ROIManager.this.doCopySeries();
                        } else {
                            ROIManager.this.editClipboard.setDimensions(ROIManager.this.getXDim(), ROIManager.this.getYDim(), ROIManager.this.getZDim(), 1, ROIManager.this.user.getBaseVolume().getXSize(), ROIManager.this.user.getBaseVolume().getYSize(), ROIManager.this.user.getBaseVolume().getZSize(), ROIManager.this.user.getOrigin());
                            ROIManager.this.doCopy();
                        }
                    }
                }, "ROIManager.copy() Thread");
                workThread.start();
            }
        } else {
            this.roiBuffer.rewind();
            this.editClipboard.initializePutting();
            this.editingDisabled = true;
            this.editClipboard.setCopyType(0);
            int sliceDirection = this.user.getSliceDirection();
            int zMin = 0;
            int yMin = 0;
            int xMin = 0;
            int xMax = this.xDim - 1;
            int yMax = this.yDim - 1;
            int zMax = this.zDim - 1;
            if (sliceDirection == 0) {
                zMin = zMax = this.axialSelectedSlice;
                this.editClipboard.setDimensions(this.getXDim(), this.getYDim(), this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize());
            } else if (sliceDirection == 1) {
                yMin = yMax = this.coronalSelectedSlice;
                this.editClipboard.setDimensions(this.getXDim(), this.getZDim(), this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getZSize());
            } else if (sliceDirection == 2) {
                xMin = xMax = this.sagittalSelectedSlice;
                this.editClipboard.setDimensions(this.getYDim(), this.getZDim(), this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize());
            }
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        this.editClipboard.put(this.roiBuffer.getCurrent(ctrX + this.xDim * (ctrY + this.yDim * ctrZ)));
                    }
                }
            }
            this.editClipboard.finishPutting();
            this.editingDisabled = false;
        }
        this.editClipboard.setLabels(this.labels.getLabelModelCopy());
    }

    public void deselectAll() {
        this.deselectAll(true);
    }

    public void dilate2D(final int sliceNum, final int sliceDirection, final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runDilate2D(sliceNum, sliceDirection, kernel, mask);
            }
        }, "ROIManager.dilate2D() Thread");
        workThread.start();
    }

    public void runDilate2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.doDilate2D(sliceNum, sliceDirection, kernel, true, mask);
    }

    public void dilate3D(final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runDilate3D(kernel, mask);
            }
        }, "ROIManager.dilate3D() Thread");
        workThread.start();
    }

    public void runDilate3D(int kernel, long mask) {
        this.makeROIFileBuffer3D();
        this.doDilate3D(kernel, true, mask);
    }

    public void doClusterROI(ClusterRejectionData data, int[] clusterDataMap, Map<Integer, ClusterStat> clusterMap, long colorMask, long clearMask, int increaseColors) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
        boolean doIncreaseColors = increaseColors > this.roiBuffer.getMaximumColors();
        pb.start(bounds.getMinZ(), bounds.getMinZ(), bounds.getMaxZ(), doIncreaseColors);
        if (doIncreaseColors) {
            pb.setIndeterminateMode(true);
            this.increaseColors(increaseColors);
            pb.setIndeterminateMode(false);
        }
        if (colorMask != 0L) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((colorMask >>> ctr & 1L) != 1L) continue;
                this.willUseROI(ctr);
            }
        } else {
            this.willUseROI(this.currentROI);
        }
        this.willChangeROI(bounds, false, 0);
        for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
            pb.setValue(ctrZ);
            for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                    int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                    long oldMaskData = this.roiBuffer.getCurrent(offsetROI);
                    this.undoClipboard.put(oldMaskData);
                    int label = data.buffer.get(offsetROI);
                    int clusterId = clusterDataMap[label];
                    ClusterStat cluster = clusterMap.get(clusterId);
                    long roiData = oldMaskData & (clearMask ^ 0xFFFFFFFFFFFFFFFFL);
                    if (cluster != null) {
                        int roiIndex = this.currentROI;
                        if (cluster.roiColor != -1) {
                            roiIndex = cluster.roiColor;
                        }
                        roiData |= MASKS[roiIndex];
                    }
                    this.roiBuffer.putCurrent(offsetROI, roiData);
                }
            }
        }
        this.updateUsedROIs(clearMask);
        this.finishedChangingROI(MESSAGE_CREATED, colorMask != 0L ? colorMask : MASKS[this.currentROI], -1);
        pb.setValue(pb.getMax());
    }

    public void doFilterClusterROI(ClusterRejectionData crd, int roiColor) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.willChangeROI(bounds, false, 0);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_FILTER);
        pb.start(bounds.getMinZ(), bounds.getMinZ(), bounds.getMaxZ());
        for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
            pb.setValue(ctrZ);
            for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                    int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                    long oldMaskData = this.roiBuffer.getCurrent(offsetROI);
                    this.undoClipboard.put(oldMaskData);
                    int value = crd.buffer.get(offsetROI);
                    if (crd.contains[value]) continue;
                    this.roiBuffer.putCurrent(offsetROI, oldMaskData & (MASKS[roiColor] ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }
        this.finishedChangingROI(MESSAGE_FILTERED, MASKS[roiColor], -1);
        pb.setValue(pb.getMax());
    }

    public void doMakeBoundRangeROI(ImageBounds bounds, double thresholdMin, double thresholdMax, boolean useBounds, long boundMask, int color) {
        VolumeData volData = new VolumeData(this.user);
        this.willUseROI(color);
        this.willChangeROI(bounds, false, 0);
        ProgressMeter pb = null;
        boolean showProgress = this.needsProgressMeter();
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(bounds.getMinZ(), bounds.getMinZ(), bounds.getMaxZ());
        }
        long roiMask = MASKS[color];
        long roiMaskInverse = roiMask ^ 0xFFFFFFFFFFFFFFFFL;
        for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
            if (showProgress) {
                pb.setValue(ctrZ);
            }
            for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                    int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                    long oldMaskData = this.roiBuffer.getCurrent(offsetROI);
                    this.undoClipboard.put(oldMaskData);
                    double current = volData.getValue(ctrX, ctrY, ctrZ);
                    if (current <= thresholdMax && current >= thresholdMin && (!useBounds || (oldMaskData & boundMask) != 0L)) {
                        this.roiBuffer.putCurrent(offsetROI, oldMaskData | roiMask);
                        continue;
                    }
                    this.roiBuffer.putCurrent(offsetROI, oldMaskData & roiMaskInverse);
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CREATED, MASKS[color], -1);
        if (showProgress) {
            pb.setValue(pb.getMax());
        }
    }

    public void doMakeConvexHullROI(ImageBounds bounds, double minVal, double maxVal, boolean doRange, boolean excludeZero, boolean isSliceOnly, boolean within, long withinMask, int withinOutput, boolean isSeries, boolean isDynamicThreshold) {
        VolumeData volData = new VolumeData(this.user);
        double min = minVal;
        double max = maxVal;
        if (within) {
            this.willUseROI(withinOutput);
        } else {
            this.willUseROI(this.currentROI);
        }
        this.willChangeROI(bounds, isSeries, 0);
        double thresholdMinPercentMax = min;
        double thresholdMaxPercentMax = max;
        boolean showProgressSeries = isSeries;
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                min = volData.getMax() * (thresholdMinPercentMax / 100.0);
                max = volData.getMax() * (thresholdMaxPercentMax / 100.0);
            }
            if (showProgress) {
                pb.setIndeterminateMode(true);
            }
            ConvexHull3D ch = new ConvexHull3D(this, this.user);
            if (within) {
                ch.makeConvexHullROI(isSliceOnly, isSeries, ctrT, withinMask);
            } else {
                ch.makeConvexHull(min, max, doRange, excludeZero, isSliceOnly, ctrT, this.roiBuffer.getSelected());
            }
            ImageBounds chBounds = ch.getBounds();
            if (showProgress) {
                pb.setIndeterminateMode(false);
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.undoClipboard.put(oldMaskData);
                        if (within) {
                            if ((oldMaskData & withinMask) != 0L) {
                                this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[withinOutput]);
                                continue;
                            }
                            if (!chBounds.inBounds(ctrX, ctrY, ctrZ) || !ch.intersects(ctrX, ctrY, ctrZ)) continue;
                            this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[withinOutput]);
                            continue;
                        }
                        double value = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        if (!(!(value >= min) || doRange && !(value <= max) || excludeZero && value == 0.0)) {
                            this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (!chBounds.inBounds(ctrX, ctrY, ctrZ) || !ch.intersects(ctrX, ctrY, ctrZ)) continue;
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[this.currentROI]);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CREATED, within ? withinMask : MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    public boolean doMakeRangeROI(ImageBounds bounds, double thresholdMin, double thresholdMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        return this.doMakeRangeROI(bounds, thresholdMin, thresholdMax, excludeZero, false, isSeries, isDynamicThreshold);
    }

    public boolean doMakeShrinkWrap(double thresholdMin, double thresholdMax, boolean excludeZero, boolean within, long withinMask, int withinOutput, int direction, boolean isSeries, boolean isDynamicThreshold) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (within) {
            this.willUseROI(withinOutput);
        } else {
            this.willUseROI(this.currentROI);
        }
        this.willChangeROI(bounds, isSeries, direction);
        if (direction == 0) {
            return this.doMakeShrinkWrapAxial(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
        }
        if (direction == 1) {
            return this.doMakeShrinkWrapCoronal(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
        }
        return this.doMakeShrinkWrapSagittal(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
    }

    public boolean doMakeThresholdROI(ImageBounds bounds, double threshold, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        return this.doMakeThresholdROI(bounds, threshold, excludeZero, false, isSeries, isDynamicThreshold);
    }

    public boolean doShrinkWrap3d(double thresholdMin, double thresholdMax, Volume volume, boolean within, long withinMask, int withinOutput, boolean excludeZero, boolean showProgressVal, boolean isSeries, boolean isDynamicThreshold) {
        boolean[] foundData = new boolean[1];
        boolean showProgress = showProgressVal;
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (within) {
            this.willUseROI(withinOutput);
        } else {
            this.willUseROI(this.currentROI);
        }
        this.willChangeROI(bounds, isSeries, 0);
        boolean showProgressSeries = isSeries;
        boolean bl = !showProgressSeries;
        ProgressMeter pb = null;
        if (showProgress &= bl) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_FIND);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_FIND);
            pb.start(0, 0, bounds.getMaxT());
        }
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setDescription(PROGRESS_DESCRIPTION_SHRINKWRAP);
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            ImageBounds boundsROI = null;
            boundsROI = within ? this.roiBuffer.getROIBounds(withinMask, roiT) : new ImageBounds(bounds);
            boundsROI.setRangeT(ctrT, ctrT);
            boolean[] contains = null;
            contains = this.findSetOfConnectedLabelsShrinkWrap3D(thresholdMin, thresholdMax, boundsROI, showProgressSeries ? null : pb, excludeZero, foundData, isDynamicThreshold, within, withinMask);
            if (showProgress) {
                pb.setDescription(PROGRESS_DESCRIPTION_SHRINKWRAP);
            }
            IntBuffer storageBuffer = this.workBuffer.asIntBuffer();
            int[] slice = this.getResetSliceBuffer(0);
            storageBuffer.rewind();
            for (int ctrZ = 0; ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetROIZ = this.xDim * this.yDim * ctrZ;
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                storageBuffer.get(slice);
                for (int ctrY = 0; ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetROIY = this.xDim * ctrY;
                    for (int ctrX = 0; ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + offsetROIY;
                        int offsetROIByteArray = offsetROI + offsetROIZ;
                        long oldMaskData = this.roiBuffer.get(offsetROIByteArray, roiT);
                        this.undoClipboard.put(oldMaskData);
                        if (within) {
                            if (!contains[slice[offsetROI]]) {
                                this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[withinOutput]);
                                continue;
                            }
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[withinOutput] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (!contains[slice[offsetROI]]) {
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_SHRINK_WRAPPED, within ? withinMask : MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData[0];
    }

    public void erode2D(final int sliceNum, final int sliceDirection, final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runErode2D(sliceNum, sliceDirection, kernel, mask);
            }
        }, "ROIManager.erode2D() Thread");
        workThread.start();
    }

    public void runErode2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.doErode2D(sliceNum, sliceDirection, kernel, true, mask);
    }

    public void erode3D(final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runErode3D(kernel, mask);
            }
        }, "ROIManager.erode3D() Thread");
        workThread.start();
    }

    public void runErode3D(int kernel, long mask) {
        this.makeROIFileBuffer3D();
        this.doErode3D(kernel, true, mask);
    }

    public int findComponentMapROI(int roiColor, IntBuffer storageBuffer, EquivalentSetManager equivSetManager) {
        ROIData volData = new ROIData(this, MASKS[roiColor]);
        return this.findComponentMap(1.0, false, storageBuffer, equivSetManager, volData);
    }

    public int findComponentMapVolume(double min, boolean isNegative, Volume volume, IntBuffer storageBuffer, EquivalentSetManager equivSetManager) {
        VolumeData volData = new VolumeData(this.user, volume);
        return this.findComponentMap(min, isNegative, storageBuffer, equivSetManager, volData);
    }

    public long findMaxBitValue() {
        return this.roiBuffer.findMaxBitValue();
    }

    public Coordinate4D findROI(int roiNum, Coordinate startLoc, int sliceDirection, boolean current) {
        boolean startingFromTop;
        long mask = 1L << roiNum;
        boolean isSeries = this.isUsing4dROI();
        int maxT = isSeries ? this.roiBuffer.getSeriesLength() - 1 : 0;
        int startT = 0;
        int startZ = 0;
        int startY = 0;
        int startX = 0;
        if (startLoc != null) {
            if (isSeries && startLoc instanceof Coordinate4D) {
                Coordinate4D coord = (Coordinate4D)startLoc;
                startT = coord.seriesPoint + (current ? 0 : 1);
            } else if (sliceDirection == 0) {
                startZ = startLoc.zInt + (current ? 0 : 1);
            } else if (sliceDirection == 1) {
                startY = startLoc.yInt + (current ? 0 : 1);
            } else if (sliceDirection == 2) {
                startX = startLoc.xInt + (current ? 0 : 1);
            }
        }
        for (int ctrT = startT; ctrT <= maxT; ++ctrT) {
            for (int ctrZ = startZ; ctrZ < this.zDim; ++ctrZ) {
                int offsetZ = this.xDim * this.yDim * ctrZ;
                for (int ctrY = startY; ctrY < this.yDim; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = startX; ctrX < this.xDim; ++ctrX) {
                        long maskVal = this.roiBuffer.get(ctrX + offsetY + offsetZ, ctrT);
                        if ((maskVal & mask) == 0L) continue;
                        return new Coordinate4D((double)ctrX, (double)ctrY, (double)ctrZ, ctrT);
                    }
                }
            }
        }
        boolean bl = startingFromTop = startLoc == null;
        if (!startingFromTop) {
            return this.findROI(roiNum, null, -1, current);
        }
        return null;
    }

    public ROI getROI(int color) {
        return this.rois[color];
    }

    public List<ROI> getSelectedMasks() {
        ArrayList<ROI> someROIs = new ArrayList<ROI>();
        long selectedROIs = this.roiBuffer.getSelected();
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((selectedROIs & 1L << ctr) == 0L) continue;
            someROIs.add(this.rois[ctr]);
        }
        return someROIs;
    }

    public List<ROI> getUsedMasks() {
        ArrayList<ROI> someROIs = new ArrayList<ROI>();
        long usedROIs = this.roiBuffer.getUsed();
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((usedROIs & 1L << ctr) == 0L) continue;
            someROIs.add(this.rois[ctr]);
        }
        return someROIs;
    }

    public AbstractROIBuffer getBuffer() {
        return this.roiBuffer;
    }

    public ROIClipboard getClipboard() {
        return this.undoClipboard;
    }

    public synchronized ClusterRejectionData getClusterData(int index) {
        return this.clusterData.get(index);
    }

    public int getCurrentROI() {
        return this.currentROI;
    }

    public int getHighestUsedIndex() {
        int highest = 0;
        long usedROIs = this.roiBuffer.getUsed();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((usedROIs & 1L << ctr) == 0L) continue;
            highest = ctr;
        }
        return highest;
    }

    public ImageBounds getImageBounds() {
        return new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
    }

    public int getIndexForLabel(String label) {
        int length = this.labels.getLength();
        for (int ctr = 0; ctr < length; ++ctr) {
            if (!this.getLabel(ctr, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, length)).equals(label)) continue;
            return ctr;
        }
        return -1;
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public String getLabel(int index, String defaultStr) {
        String label = this.labels.getLabel(index);
        if (StringUtils.isBlank((CharSequence)label)) {
            return defaultStr;
        }
        return label;
    }

    public ByteBuffer getLabelBuffer() {
        return this.workBuffer;
    }

    public byte[] getLabelData() {
        return this.labels.getData();
    }

    public LabelList getLabels() {
        return this.labels;
    }

    public Volume getLoadedROIVolume() {
        return this.loadedROIVolume;
    }

    public long getMaskValue(int xLoc, int yLoc, int zLoc) {
        return this.roiBuffer.getCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc));
    }

    public long getMaskValue(int xLoc, int yLoc, int zLoc, int tLoc) {
        return this.roiBuffer.get(xLoc + this.xDim * (yLoc + this.yDim * zLoc), tLoc);
    }

    public int getMaximumColors() {
        return this.roiBuffer.getMaximumColors();
    }

    public int getNumSelected() {
        int count = 0;
        long selectedROIs = this.roiBuffer.getSelected();
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((selectedROIs & 1L << ctr) == 0L) continue;
            ++count;
        }
        return count;
    }

    public int getNumUsed() {
        int count = 0;
        long usedROIs = this.roiBuffer.getUsed();
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((usedROIs & 1L << ctr) == 0L) continue;
            ++count;
        }
        return count;
    }

    public ImageBounds getROIBounds(long mask) {
        return this.roiBuffer.getROIBoundsCurrent(mask);
    }

    public Color getROIColor(int index) {
        return ROIColor.getColor(index);
    }

    public AbstractROIBuffer getROIDataBuffer() {
        return this.roiBuffer;
    }

    public String getROILabel(int index) {
        return this.getLabel(index, ROIDefaultLabels.getDefaultLabelDisplayOrder(index, this.roiBuffer.getMaximumColors()));
    }

    @Deprecated
    public ByteBuffer getROIMaskBuffer() {
        return this.roiBuffer.getByteBuffers()[0];
    }

    @Deprecated
    public byte getROIMaskValue(int xLoc, int yLoc, int zLoc) {
        if (this.roiBuffer.hasBuffer()) {
            return (byte)this.roiBuffer.getCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc));
        }
        return 0;
    }

    @Deprecated
    public byte getROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc) {
        if (this.isUsing4dROI()) {
            return (byte)this.roiBuffer.get(xLoc + this.xDim * (yLoc + this.yDim * zLoc), tLoc);
        }
        return this.getROIMaskValue(xLoc, yLoc, zLoc);
    }

    public Vector<Integer> getSelectedIndices(boolean currentLast, boolean currentFirst) {
        Vector<Integer> indices = new Vector<Integer>();
        long selectedROIs = this.roiBuffer.getSelected();
        boolean currentUsed = false;
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((selectedROIs & 1L << ctr) == 0L) continue;
            if (ctr == this.currentROI) {
                if (currentLast || currentFirst) {
                    currentUsed = true;
                    continue;
                }
                indices.add(ctr);
                continue;
            }
            indices.add(ctr);
        }
        if (currentUsed) {
            if (currentLast) {
                indices.add(this.currentROI);
            } else {
                indices.add(0, this.currentROI);
            }
        }
        return indices;
    }

    public long getSelectedMask() {
        return this.roiBuffer.getSelected();
    }

    public long getAvailableMask() {
        if (this.getSelectedMask() != 0L) {
            return this.getSelectedMask();
        }
        return this.getUsedMask();
    }

    public long getSelectedMaskInRange(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        long selectedMaskInRange = 0L;
        long selectedROIs = this.roiBuffer.getSelected();
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            int offsetZ = this.xDim * this.yDim * ctrZ;
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                int offsetY = this.xDim * ctrY;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    if ((selectedMaskInRange |= this.roiBuffer.getCurrent(ctrX + offsetY + offsetZ) & selectedROIs) != selectedROIs) continue;
                    return selectedROIs;
                }
            }
        }
        return selectedMaskInRange;
    }

    @Deprecated
    public byte getSelectedROIs() {
        return (byte)this.roiBuffer.getSelected();
    }

    public int getSelectedSlice(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.axialSelectedSlice;
        }
        if (sliceDirection == 1) {
            return this.coronalSelectedSlice;
        }
        return this.sagittalSelectedSlice;
    }

    public ROIShape[] getShape(int sliceNum, int sliceDirection, AffineTransform transform) {
        return this.getShape(sliceNum, sliceDirection, transform, -1, false);
    }

    public ROIShape[] getShape(int sliceNum, int sliceDirection, AffineTransform transform, int roiNum, boolean surface) {
        int value;
        ClusterRejectionData crd;
        int ctr;
        int bufferOffset;
        int offset;
        int ctrX;
        int bufferOffsetY;
        int sliceOffsetY;
        int ctrY;
        int bufferOffsetSlice;
        int ctr2;
        byte[][] data;
        ROIShape[] shape;
        ROIShape[] returnShape = null;
        boolean hasClusterData = this.hasClusterData();
        long used = this.roiBuffer.getUsed();
        if (sliceDirection == 0) {
            shape = null;
            data = null;
            if (surface) {
                shape = this.axialROIShapeSurface;
                data = this.axialROIShapeDataSurface;
            } else {
                shape = this.axialROIShape;
                data = this.axialROIShapeData;
            }
            if (roiNum != -1) {
                shape[roiNum].shapeWillChange();
            } else {
                for (ctr2 = 0; ctr2 < this.roiBuffer.getMaximumColors(); ++ctr2) {
                    shape[ctr2].shapeWillChange();
                }
            }
            bufferOffsetSlice = sliceNum * this.xDim * this.yDim;
            for (ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                sliceOffsetY = this.xDim * ctrY;
                bufferOffsetY = this.xDim * ctrY;
                if (ctrY == 0) {
                    for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        offset = ctrX + sliceOffsetY;
                        bufferOffset = ctrX + bufferOffsetY + bufferOffsetSlice;
                        for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                            byte[] byArray = data[ctr];
                            int n = offset;
                            byArray[n] = (byte)(byArray[n] & 1);
                            if ((this.roiBuffer.getCurrent(bufferOffset) & MASKS[ctr]) != MASKS[ctr]) continue;
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray2 = data[ctr];
                                    int n2 = offset;
                                    byArray2[n2] = (byte)(byArray2[n2] | 0x10);
                                    continue;
                                }
                                value = crd.buffer.get(bufferOffset);
                                if (!crd.contains[value]) continue;
                                byte[] byArray3 = data[ctr];
                                int n3 = offset;
                                byArray3[n3] = (byte)(byArray3[n3] | 0x10);
                                continue;
                            }
                            byte[] byArray4 = data[ctr];
                            int n4 = offset;
                            byArray4[n4] = (byte)(byArray4[n4] | 0x10);
                        }
                    }
                }
                for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    offset = ctrX + sliceOffsetY;
                    bufferOffset = ctrX + bufferOffsetY + bufferOffsetSlice;
                    for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                        if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                        byte[] byArray = data[ctr];
                        int n = offset + this.xDim;
                        byArray[n] = (byte)(byArray[n] & 1);
                        if ((this.roiBuffer.getCurrent(bufferOffset + this.xDim) & MASKS[ctr]) == MASKS[ctr]) {
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray5 = data[ctr];
                                    int n5 = offset + this.xDim;
                                    byArray5[n5] = (byte)(byArray5[n5] | 0x10);
                                } else {
                                    value = crd.buffer.get(bufferOffset + this.xDim);
                                    if (crd.contains[value]) {
                                        byte[] byArray6 = data[ctr];
                                        int n6 = offset + this.xDim;
                                        byArray6[n6] = (byte)(byArray6[n6] | 0x10);
                                    }
                                }
                            } else {
                                byte[] byArray7 = data[ctr];
                                int n7 = offset + this.xDim;
                                byArray7[n7] = (byte)(byArray7[n7] | 0x10);
                            }
                        }
                        if ((data[ctr][offset] & 0x10) != 16) continue;
                        this.makeAxialPath(ctrX, ctrY, ctr, surface);
                    }
                }
            }
            returnShape = shape;
        } else if (sliceDirection == 1) {
            shape = null;
            data = null;
            if (surface) {
                shape = this.coronalROIShapeSurface;
                data = this.coronalROIShapeDataSurface;
            } else {
                shape = this.coronalROIShape;
                data = this.coronalROIShapeData;
            }
            if (roiNum != -1) {
                shape[roiNum].shapeWillChange();
            } else {
                for (ctr2 = 0; ctr2 < this.roiBuffer.getMaximumColors(); ++ctr2) {
                    shape[ctr2].shapeWillChange();
                }
            }
            bufferOffsetSlice = sliceNum * this.xDim;
            for (ctrY = 0; ctrY < this.zDim - 1; ++ctrY) {
                sliceOffsetY = this.xDim * ctrY;
                bufferOffsetY = this.xDim * this.yDim * ctrY;
                if (ctrY == 0) {
                    for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        offset = ctrX + sliceOffsetY;
                        bufferOffset = ctrX + bufferOffsetSlice + bufferOffsetY;
                        for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                            byte[] byArray = data[ctr];
                            int n = offset;
                            byArray[n] = (byte)(byArray[n] & 1);
                            if ((this.roiBuffer.getCurrent(bufferOffset) & MASKS[ctr]) != MASKS[ctr]) continue;
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray8 = data[ctr];
                                    int n8 = offset;
                                    byArray8[n8] = (byte)(byArray8[n8] | 0x10);
                                    continue;
                                }
                                value = crd.buffer.get(bufferOffset);
                                if (!crd.contains[value]) continue;
                                byte[] byArray9 = data[ctr];
                                int n9 = offset;
                                byArray9[n9] = (byte)(byArray9[n9] | 0x10);
                                continue;
                            }
                            byte[] byArray10 = data[ctr];
                            int n10 = offset;
                            byArray10[n10] = (byte)(byArray10[n10] | 0x10);
                        }
                    }
                }
                for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    offset = ctrX + sliceOffsetY;
                    bufferOffset = ctrX + bufferOffsetSlice + bufferOffsetY;
                    for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                        if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                        byte[] byArray = data[ctr];
                        int n = offset + this.xDim;
                        byArray[n] = (byte)(byArray[n] & 1);
                        if ((this.roiBuffer.getCurrent(bufferOffset + this.xDim * this.yDim) & MASKS[ctr]) == MASKS[ctr]) {
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray11 = data[ctr];
                                    int n11 = offset + this.xDim;
                                    byArray11[n11] = (byte)(byArray11[n11] | 0x10);
                                } else {
                                    value = crd.buffer.get(bufferOffset + this.xDim * this.yDim);
                                    if (crd.contains[value]) {
                                        byte[] byArray12 = data[ctr];
                                        int n12 = offset + this.xDim;
                                        byArray12[n12] = (byte)(byArray12[n12] | 0x10);
                                    }
                                }
                            } else {
                                byte[] byArray13 = data[ctr];
                                int n13 = offset + this.xDim;
                                byArray13[n13] = (byte)(byArray13[n13] | 0x10);
                            }
                        }
                        if ((data[ctr][offset] & 0x10) != 16) continue;
                        this.makeCoronalPath(ctrX, ctrY, ctr, surface);
                    }
                }
            }
            returnShape = shape;
        } else {
            shape = null;
            data = null;
            if (surface) {
                shape = this.sagittalROIShapeSurface;
                data = this.sagittalROIShapeDataSurface;
            } else {
                shape = this.sagittalROIShape;
                data = this.sagittalROIShapeData;
            }
            if (roiNum != -1) {
                shape[roiNum].shapeWillChange();
            } else {
                for (ctr2 = 0; ctr2 < this.roiBuffer.getMaximumColors(); ++ctr2) {
                    shape[ctr2].shapeWillChange();
                }
            }
            bufferOffsetSlice = sliceNum;
            for (ctrY = 0; ctrY < this.zDim - 1; ++ctrY) {
                sliceOffsetY = this.yDim * ctrY;
                bufferOffsetY = this.xDim * this.yDim * ctrY;
                if (ctrY == 0) {
                    for (ctrX = 0; ctrX < this.yDim; ++ctrX) {
                        offset = ctrX + sliceOffsetY;
                        bufferOffset = bufferOffsetSlice + ctrX * this.xDim + bufferOffsetY;
                        for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                            byte[] byArray = data[ctr];
                            int n = offset;
                            byArray[n] = (byte)(byArray[n] & 1);
                            if ((this.roiBuffer.getCurrent(bufferOffset) & MASKS[ctr]) != MASKS[ctr]) continue;
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray14 = data[ctr];
                                    int n14 = offset;
                                    byArray14[n14] = (byte)(byArray14[n14] | 0x10);
                                    continue;
                                }
                                value = crd.buffer.get(bufferOffset);
                                if (!crd.contains[value]) continue;
                                byte[] byArray15 = data[ctr];
                                int n15 = offset;
                                byArray15[n15] = (byte)(byArray15[n15] | 0x10);
                                continue;
                            }
                            byte[] byArray16 = data[ctr];
                            int n16 = offset;
                            byArray16[n16] = (byte)(byArray16[n16] | 0x10);
                        }
                    }
                }
                for (ctrX = 0; ctrX < this.yDim; ++ctrX) {
                    offset = ctrX + sliceOffsetY;
                    bufferOffset = bufferOffsetSlice + ctrX * this.xDim + bufferOffsetY;
                    for (ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                        if ((used & 1L << ctr) == 0L || roiNum != -1 && ctr != roiNum) continue;
                        byte[] byArray = data[ctr];
                        int n = offset + this.yDim;
                        byArray[n] = (byte)(byArray[n] & 1);
                        if ((this.roiBuffer.getCurrent(bufferOffset + this.xDim * this.yDim) & MASKS[ctr]) == MASKS[ctr]) {
                            ClusterRejectionData clusterRejectionData = crd = hasClusterData ? this.getClusterData(ctr) : null;
                            if (crd != null) {
                                if (crd.hiding || crd.contains == null) {
                                    byte[] byArray17 = data[ctr];
                                    int n17 = offset + this.yDim;
                                    byArray17[n17] = (byte)(byArray17[n17] | 0x10);
                                } else {
                                    value = crd.buffer.get(bufferOffset + this.xDim * this.yDim);
                                    if (crd.contains[value]) {
                                        byte[] byArray18 = data[ctr];
                                        int n18 = offset + this.yDim;
                                        byArray18[n18] = (byte)(byArray18[n18] | 0x10);
                                    }
                                }
                            } else {
                                byte[] byArray19 = data[ctr];
                                int n19 = offset + this.yDim;
                                byArray19[n19] = (byte)(byArray19[n19] | 0x10);
                            }
                        }
                        if ((data[ctr][offset] & 0x10) != 16) continue;
                        this.makeSagittalPath(ctrX, ctrY, ctr, surface);
                    }
                }
            }
            returnShape = shape;
        }
        for (int ctr3 = 0; ctr3 < this.roiBuffer.getMaximumColors(); ++ctr3) {
            if ((this.roiBuffer.getUsed() & 1L << ctr3) == 0L || roiNum != -1 && ctr3 != roiNum) continue;
            returnShape[ctr3].setScreenTransform(transform);
        }
        return returnShape;
    }

    public int getSize() {
        return this.xDim * this.yDim * this.zDim;
    }

    public Vector<Integer> getUsedIndices() {
        return this.getUsedIndices(false, false);
    }

    public Vector<Integer> getUsedIndicesCurrentFirst() {
        return this.getUsedIndices(false, true);
    }

    public Vector<Integer> getUsedIndicesCurrentLast() {
        return this.getUsedIndices(true, false);
    }

    public long getUsedMask() {
        return this.roiBuffer.getUsed();
    }

    @Deprecated
    public byte getUsedROIs() {
        return (byte)this.roiBuffer.getUsed();
    }

    public ROIListener getListener() {
        return this.listener;
    }

    public ROIUser getUser() {
        return this.user;
    }

    public int getXDim() {
        return this.xDim;
    }

    public int getYDim() {
        return this.yDim;
    }

    public int getZDim() {
        return this.zDim;
    }

    public boolean hasClusterData() {
        return this.clusterData.size() > 0;
    }

    public boolean hasLabels() {
        return this.labels.hasData();
    }

    public boolean hasRedo() {
        return this.hasRedo;
    }

    public boolean hasROI() {
        return this.roiBuffer.getUsed() != 0L;
    }

    public boolean hasROI(int num) {
        return (this.roiBuffer.getUsed() & MASKS[num]) != 0L;
    }

    public boolean hasSelected() {
        return this.roiBuffer.getSelected() != 0L;
    }

    public boolean hasSelectedInRange(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        if (this.roiBuffer.hasBuffer()) {
            long selectedROIs = this.roiBuffer.getSelected();
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                int offsetZ = this.xDim * this.yDim * ctrZ;
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        if ((this.roiBuffer.getCurrent(ctrX + offsetY + offsetZ) & selectedROIs) == 0L) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean hasUndo() {
        return this.hasUndo;
    }

    public void importROI(final Volume importVolume, final boolean forceWorld, final boolean isMangoROI) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doImportROI(importVolume, forceWorld, isMangoROI);
            }
        }, "ROIManager.importROI() Thread");
        workThread.start();
    }

    public void increaseColors() {
        if (this.roiBuffer instanceof ROIByteBuffer) {
            ROIShortBuffer shortBuffer = this.roiBuffer.hasBuffer() ? new ROIShortBuffer((ROIByteBuffer)this.roiBuffer) : new ROIShortBuffer(this.xDim, this.yDim, this.zDim);
            this.colorsWillChange(16);
            this.roiBuffer = shortBuffer;
        } else if (this.roiBuffer instanceof ROIShortBuffer) {
            ROIIntBuffer intBuffer = this.roiBuffer.hasBuffer() ? new ROIIntBuffer((ROIShortBuffer)this.roiBuffer) : new ROIIntBuffer(this.xDim, this.yDim, this.zDim);
            this.colorsWillChange(32);
            this.roiBuffer = intBuffer;
        } else if (this.roiBuffer instanceof ROIIntBuffer) {
            ROILongBuffer longBuffer = this.roiBuffer.hasBuffer() ? new ROILongBuffer((ROIIntBuffer)this.roiBuffer) : new ROILongBuffer(this.xDim, this.yDim, this.zDim);
            this.colorsWillChange(64);
            this.roiBuffer = longBuffer;
        }
        if (this.listener != null) {
            this.listener.willAddMoreROIColors(this.roiBuffer.getMaximumColors());
        }
    }

    public void initCurrentROI() {
        this.initROI(this.currentROI);
    }

    public void initMask(long mask) {
        if ((this.roiBuffer.getUsed() & mask) != mask) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((mask >>> ctr & 1L) != 1L) continue;
                this.willUseROI(ctr);
            }
        }
    }

    public void initROI(int ctrVal) {
        if (!this.roiBuffer.hasBuffer()) {
            this.makeROIBuffer();
        }
        int ctr = ctrVal;
        this.roiBuffer.addUsed(MASKS[ctr %= this.roiBuffer.getMaximumColors()]);
        this.roiBuffer.addInited(MASKS[ctr]);
        if (this.axialROIShapeData[ctr] == null) {
            this.axialROIShapeData[ctr] = new byte[this.xDim * this.yDim];
            this.coronalROIShapeData[ctr] = new byte[this.xDim * this.zDim];
            this.sagittalROIShapeData[ctr] = new byte[this.yDim * this.zDim];
            this.axialROIShape[ctr].setData(this.xDim, this.yDim, this.axialROIShapeData[ctr]);
            this.coronalROIShape[ctr].setData(this.xDim, this.zDim, this.coronalROIShapeData[ctr]);
            this.sagittalROIShape[ctr].setData(this.yDim, this.zDim, this.sagittalROIShapeData[ctr]);
        }
        if (this.axialROIShapeDataSurface[ctr] == null) {
            this.axialROIShapeDataSurface[ctr] = new byte[this.xDim * this.yDim];
            this.coronalROIShapeDataSurface[ctr] = new byte[this.xDim * this.zDim];
            this.sagittalROIShapeDataSurface[ctr] = new byte[this.yDim * this.zDim];
            this.axialROIShapeSurface[ctr].setData(this.xDim, this.yDim, this.axialROIShapeDataSurface[ctr]);
            this.coronalROIShapeSurface[ctr].setData(this.xDim, this.zDim, this.coronalROIShapeDataSurface[ctr]);
            this.sagittalROIShapeSurface[ctr].setData(this.yDim, this.zDim, this.sagittalROIShapeDataSurface[ctr]);
        }
    }

    @Deprecated
    public void initROIMask(byte roiVal) {
        if ((this.roiBuffer.getUsed() & (long)roiVal) != (long)roiVal) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((roiVal >>> ctr & 1) != 1) continue;
                this.willUseROI(ctr);
            }
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isEditingDisabled() {
        return this.editingDisabled;
    }

    public boolean isHighlighted(int roiNum) {
        long mask = 1L << roiNum;
        return (this.roiBuffer.getHighlighted() & mask) != 0L;
    }

    public boolean isInside(int xLoc, int yLoc, int zLoc) {
        return this.roiBuffer.getCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc)) != 0L;
    }

    public boolean isInside(int xLoc, int yLoc, int zLoc, int roiNum) {
        return (this.roiBuffer.getCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc)) & 1L << roiNum) != 0L;
    }

    public boolean isInsideSelected(int xLoc, int yLoc, int zLoc) {
        return (this.roiBuffer.getCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc)) & this.roiBuffer.getSelected()) != 0L;
    }

    public boolean isInsideSelectedROIs(int offset) {
        return (this.roiBuffer.getCurrent(offset) & this.roiBuffer.getSelected()) != 0L;
    }

    public boolean isMultiSelected() {
        int count = 0;
        long selectedROIs = this.roiBuffer.getSelected();
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((selectedROIs >> ctr & 1L) != 1L) continue;
            ++count;
        }
        return count > 1;
    }

    public boolean isSelected(int color) {
        return (this.roiBuffer.getSelected() & MASKS[color]) != 0L;
    }

    public boolean isSelected(int roiNum, int sliceNum, int sliceDirection) {
        boolean sliceMatch = false;
        if ((this.roiBuffer.getSelected() & MASKS[roiNum]) != 0L) {
            if (sliceDirection == 0) {
                sliceMatch = sliceNum == this.axialSelectedSlice;
            } else if (sliceDirection == 1) {
                sliceMatch = sliceNum == this.coronalSelectedSlice;
            } else if (sliceDirection == 2) {
                sliceMatch = sliceNum == this.sagittalSelectedSlice;
            }
            return sliceMatch;
        }
        return false;
    }

    public boolean isSelectedSlice(int sliceNum, int sliceDirection) {
        boolean sliceMatch = false;
        if (sliceDirection == 0) {
            sliceMatch = sliceNum == this.axialSelectedSlice;
        } else if (sliceDirection == 1) {
            sliceMatch = sliceNum == this.coronalSelectedSlice;
        } else if (sliceDirection == 2) {
            sliceMatch = sliceNum == this.sagittalSelectedSlice;
        }
        return sliceMatch;
    }

    public boolean isUsed(int color) {
        return (this.roiBuffer.getUsed() & MASKS[color]) != 0L;
    }

    public boolean isSolidShape(int color) {
        return this.solidShapeMap.containsKey(color);
    }

    public boolean isUsing4dROI() {
        return this.roiBuffer.getSeriesLength() > 1;
    }

    public Solid getSolid(int color) {
        return this.solidShapeMap.get(color);
    }

    public void labelChanged() {
        if (this.labelListener != null) {
            this.labelListener.labelChanged();
        }
        this.setDirty(true);
    }

    public void loadROI(final Volume importVolume, final String metadata) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doLoadROI(importVolume, metadata, false);
            }
        }, "ROIManager.loadROI() Thread");
        workThread.start();
    }

    public void makeBoundRangeROI(final double thresholdMin, final double thresholdMax, final boolean useBounds, final long boundMask, final int color) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doMakeBoundRangeROI(new ImageBounds(0, ROIManager.this.xDim - 2, 0, ROIManager.this.yDim - 2, 0, ROIManager.this.zDim - 2), thresholdMin, thresholdMax, useBounds, boundMask, color);
            }
        }, "ROIManager.makeBoundRangeROI() Thread");
        workThread.start();
    }

    public void makeBoundRangeROI(int sliceNum, int sliceDirection, double thresholdMin, double thresholdMax, boolean useBounds, long boundsMask, int color) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        this.doMakeBoundRangeROI(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), thresholdMin, thresholdMax, useBounds, boundsMask, color);
    }

    public void makeBuffer(int volSize, int sliceSize) {
        if (!this.roiBuffer.hasBuffer() || this.roiBuffer.getSeriesLength() != 1) {
            this.roiBuffer.makeBuffer(volSize, sliceSize);
        }
    }

    public void makeBufferSeries(int timepoints, int volSize, int sliceSize) {
        if (!this.roiBuffer.hasBuffer() || this.roiBuffer.getSeriesLength() == 1) {
            this.roiBuffer.makeBufferSeries(timepoints, volSize, sliceSize);
        }
    }

    public void makeConvexHullROI(final double thresholdLower, final double thresholdUpper, final boolean excludeZero, final boolean within, final long withinMask, final int withinOutput, final boolean doRange, final boolean isSeries, final boolean isDynamicThreshold) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runConvexHull(thresholdLower, thresholdUpper, excludeZero, within, withinMask, withinOutput, doRange, isSeries, isDynamicThreshold);
            }
        }, "ROIManager.makeConvexHullROI() Thread");
        workThread.start();
    }

    public void runConvexHull(double thresholdLower, double thresholdUpper, boolean excludeZero, boolean within, long withinMask, int withinOutput, boolean doRange, boolean isSeries, boolean isDynamicThreshold) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.doMakeConvexHullROI(bounds, thresholdLower, thresholdUpper, doRange, excludeZero, false, within, withinMask, withinOutput, isSeries, isDynamicThreshold);
    }

    public void runConvexHullROI(int sliceNum, int sliceDirection, double thresholdLower, double thresholdUpper, boolean excludeZero, boolean within, long withinMask, int withinOutput, boolean doRange, boolean isSeries, boolean isDynamicThreshold) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        ImageBounds bounds = new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax);
        this.doMakeConvexHullROI(bounds, thresholdLower, thresholdUpper, doRange, excludeZero, true, within, withinMask, withinOutput, isSeries, isDynamicThreshold);
    }

    public void makeLogicalROI(final Logical logical) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doMakeLogicalROI(logical, new ImageBounds(0, ROIManager.this.xDim - 2, 0, ROIManager.this.yDim - 2, 0, ROIManager.this.zDim - 2));
            }
        }, "ROIManager.makeLogicalROI() Thread");
        workThread.start();
    }

    public void makeLogicalROI(Logical logical, int sliceNum, int sliceDirection) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        this.doMakeLogicalROI(logical, new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax));
    }

    public void makeRangeROI(final double thresholdMin, final double thresholdMax, final boolean excludeROI, final boolean isSeries, final boolean isDynamicThreshold) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean foundData = ROIManager.this.runRangeROI(thresholdMin, thresholdMax, excludeROI, isSeries, isDynamicThreshold);
                if (!foundData && ROIManager.this.listener != null) {
                    ROIManager.this.listener.showWarningDialog(ROIManager.WARNING_MESSAGE_NO_DATA, ROIManager.WARNING_TITLE);
                }
            }
        }, "ROIManager.makeRangeROI() Thread");
        workThread.start();
    }

    public boolean runRangeROI(double thresholdMin, double thresholdMax, boolean excludeROI, boolean isSeries, boolean isDynamicThreshold) {
        return this.doMakeRangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), thresholdMin, thresholdMax, excludeROI, isSeries, isDynamicThreshold);
    }

    public void makeRangeROI(int sliceNum, int sliceDirection, double thresholdMin, double thresholdMax, boolean excludeROI, boolean isSeries, boolean isDynamicThreshold) {
        boolean foundData = this.runRangeROI(sliceNum, sliceDirection, thresholdMin, thresholdMax, excludeROI, isSeries, isDynamicThreshold);
        if (!foundData && this.listener != null) {
            this.listener.showWarningDialog(WARNING_MESSAGE_NO_DATA, WARNING_TITLE);
        }
    }

    public boolean runRangeROI(int sliceNum, int sliceDirection, double thresholdMin, double thresholdMax, boolean excludeROI, boolean isSeries, boolean isDynamicThreshold) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (sliceDirection == 0) {
            bounds.setRangeZ(sliceNum, sliceNum);
        } else if (sliceDirection == 1) {
            bounds.setRangeY(sliceNum, sliceNum);
        } else if (sliceDirection == 2) {
            bounds.setRangeX(sliceNum, sliceNum);
        }
        return this.doMakeRangeROI(bounds, thresholdMin, thresholdMax, excludeROI, isSeries, isDynamicThreshold);
    }

    public void makeThresholdROI(final double threshold, final boolean excludeZero, final boolean isSeries, final boolean isDynamicThreshold) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean foundData = ROIManager.this.runThresholdROI(threshold, excludeZero, isSeries, isDynamicThreshold);
                if (!foundData && ROIManager.this.listener != null) {
                    ROIManager.this.listener.showWarningDialog(ROIManager.WARNING_MESSAGE_NO_DATA, ROIManager.WARNING_TITLE);
                }
            }
        }, "ROIManager.makeThresholdROI() Thread");
        workThread.start();
    }

    public boolean runThresholdROI(double threshold, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        return this.doMakeThresholdROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), threshold, excludeZero, isSeries, isDynamicThreshold);
    }

    public void makeThresholdROI(int sliceNum, int sliceDirection, double threshold, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        boolean foundData = this.runThresholdROI(sliceNum, sliceDirection, threshold, excludeZero, isSeries, isDynamicThreshold);
        if (!foundData && this.listener != null) {
            this.listener.showWarningDialog(WARNING_MESSAGE_NO_DATA, WARNING_TITLE);
        }
    }

    public boolean runThresholdROI(int sliceNum, int sliceDirection, double threshold, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (sliceDirection == 0) {
            bounds.setRangeZ(sliceNum, sliceNum);
        } else if (sliceDirection == 1) {
            bounds.setRangeY(sliceNum, sliceNum);
        } else if (sliceDirection == 2) {
            bounds.setRangeX(sliceNum, sliceNum);
        }
        return this.doMakeThresholdROI(bounds, threshold, excludeZero, isSeries, isDynamicThreshold);
    }

    public void open2D(final int sliceNum, final int sliceDirection, final int kernel, final long mask) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runOpen2D(sliceNum, sliceDirection, kernel, mask);
            }
        }, "ROIManager.open2D() Thread");
        workThread.start();
    }

    public void runOpen2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.doErode2D(sliceNum, sliceDirection, kernel, true, mask);
        this.doDilate2D(sliceNum, sliceDirection, kernel, false, mask);
    }

    public void open3D(final int kernel, final long mask) {
        this.makeROIFileBuffer3D();
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runOpen3D(kernel, mask);
            }
        }, "ROIManager.open3D() Thread");
        workThread.start();
    }

    public void runOpen3D(int kernel, long mask) {
        this.doErode3D(kernel, true, mask);
        this.doDilate3D(kernel, false, mask);
    }

    public void operationROI(ROIOperationTreeNode op, boolean sameThread) {
        if (sameThread) {
            this.doOperationROI(op, new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2));
        } else {
            this.operationROI(op, new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2));
        }
    }

    public void operationROI(ROIOperationTreeNode op, int sliceNum, int sliceDirection, boolean sameThread) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        if (sameThread) {
            this.doOperationROI(op, new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax));
        } else {
            this.operationROI(op, new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax));
        }
    }

    public void paste(boolean sameThread) {
        long copyMask = this.editClipboard.getCopyMask();
        boolean isCopyMultiSelected = this.editClipboard.isMultiSelectionCopied();
        String[] copiedLabels = this.editClipboard.getLabels();
        if (isCopyMultiSelected) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((copyMask >> ctr & 1L) != 1L || copiedLabels == null) continue;
                this.labels.setLabel(ctr, copiedLabels[ctr]);
            }
        } else {
            int copyIndex = BitUtilities.findHighestOneBitIndex((long)copyMask);
            int pastIndex = BitUtilities.findHighestOneBitIndex((long)MASKS[this.currentROI]);
            this.labels.setLabel(pastIndex, copiedLabels[copyIndex]);
        }
        if (this.editClipboard.isSliceCopy()) {
            this.pasteSlice();
        } else if (this.editClipboard.isVolumeCopy()) {
            if (sameThread) {
                this.doPasteVolume();
            } else {
                this.pasteVolume();
            }
        } else if (this.editClipboard.isSeriesCopy()) {
            if (this.editClipboard.isSameDim(this.xDim, this.yDim, this.zDim) && this.editClipboard.isSameSize(this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize())) {
                if (sameThread) {
                    this.doPasteSeries();
                } else {
                    this.pasteSeries();
                }
            } else if (this.listener != null) {
                this.listener.showWarningDialog("A series can only be pasted onto a image of the same dimensions.", "Paste Error");
            }
        }
    }

    public void propagate(final int sliceDirection, final int sliceNum, final int startSlice, final int endSlice, final long roiMask, final int outputColorIndex) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runPropagate(sliceDirection, sliceNum, startSlice, endSlice, roiMask, outputColorIndex);
            }
        }, "ROIManager.propagate() Thread");
        workThread.start();
    }

    public void runPropagate(int sliceDirection, int sliceNum, int startSlice, int endSlice, long roiMask, int outputColorIndex) {
        this.doPropagate(sliceDirection, sliceNum, startSlice, endSlice, roiMask, outputColorIndex);
    }

    public void propagateSetShape(int sliceDirection, AffineTransform shapeTrans, AffineTransform screenTrans, int adjustingROI) {
        this.propagateSetShape(sliceDirection, shapeTrans, screenTrans, adjustingROI, true);
    }

    public void propagateSetShape(final int sliceDirection, final AffineTransform shapeTrans, final AffineTransform screenTrans, final int adjustingROI, final boolean reset) {
        if (this.isEditingDisabled()) {
            return;
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doPropagateSetShape(sliceDirection, shapeTrans, screenTrans, adjustingROI, reset);
            }
        }, "ROIManager.propagateSetShape() Thread");
        workThread.start();
    }

    public void reflect(int sliceDirection, int axis, boolean isVertical) {
        this.reflect(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), sliceDirection, axis, isVertical);
    }

    public void runReflection(int sliceDirection, int axis, boolean vertical) {
        this.doReflection(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), sliceDirection, axis, vertical);
    }

    public void reflect(int sliceNum, int sliceDirection, int axis, boolean isVertical) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        this.reflect(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), sliceDirection, axis, isVertical);
    }

    public void runReflectSlice(int sliceNum, int sliceDirection, int axis, boolean isVertical) {
        int zMin = 0;
        int yMin = 0;
        int xMin = 0;
        int xMax = this.xDim - 2;
        int yMax = this.yDim - 2;
        int zMax = this.zDim - 2;
        if (sliceDirection == 0) {
            zMin = zMax = sliceNum;
        } else if (sliceDirection == 1) {
            yMin = yMax = sliceNum;
        } else if (sliceDirection == 2) {
            xMin = xMax = sliceNum;
        }
        this.doReflection(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), sliceDirection, axis, isVertical);
    }

    public void replaceMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, long mask) {
        this.roiBuffer.put(xLoc + this.xDim * (yLoc + this.yDim * zLoc), tLoc, mask);
    }

    public void replaceMaskValue(int xLoc, int yLoc, int zLoc, long mask) {
        this.roiBuffer.putCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc), mask);
    }

    @Deprecated
    public void replaceROIMaskValue(int xLoc, int yLoc, int zLoc, byte roiVal) {
        long inited = this.roiBuffer.getInited();
        if ((inited & (long)roiVal) != (long)roiVal) {
            this.initROIMask(roiVal);
        }
        if (this.roiBuffer.hasBuffer()) {
            this.roiBuffer.putCurrent(xLoc + this.xDim * (yLoc + this.yDim * zLoc), roiVal & 0xFF);
        }
    }

    @Deprecated
    public void replaceROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, byte roiVal) {
        long inited = this.roiBuffer.getInited();
        if ((inited & (long)roiVal) != (long)roiVal) {
            this.initROIMask(roiVal);
        }
        if (this.isUsing4dROI()) {
            this.roiBuffer.put(xLoc + this.xDim * (yLoc + this.yDim * zLoc), tLoc, roiVal & 0xFF);
        } else {
            this.replaceROIMaskValue(xLoc, yLoc, zLoc, roiVal);
        }
    }

    public void resetClipboards() {
        this.hasRedo = false;
        this.hasUndo = false;
        this.undoClipboard.reset();
        this.redoClipboard.reset();
    }

    public void roiMaskOperationCompleted() {
        this.roiMaskOperationCompleted(null);
    }

    public void roiMaskOperationCompleted(final String message) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ROIManager.this.listener != null) {
                    ROIManager.this.listener.resetAllClipboardsUndo();
                }
                ROIManager.this.hasUndo = false;
                ROIManager.this.hasRedo = false;
                ROIManager.this.roiBuffer.setUsed(ROIManager.this.roiBuffer.isEmptyOf(ROIManager.this.roiBuffer.getUsed()));
                ROIManager.this.setDirty(ROIManager.this.roiBuffer.getUsed() != 0L);
                if (ROIManager.this.listener != null) {
                    ROIManager.this.listener.roiHasChanged(ROIManager.this.rois[ROIManager.this.currentROI], message, ROIManager.this.roiBuffer.getUsed(), -1);
                }
            }
        });
    }

    public void selectAll() {
        this.roiBuffer.selectAll();
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    public void selectAllInRange(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        this.selectSome(this.getMaskInRange(xMin, xMax, yMin, yMax, zMin, zMax));
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    public void selectedComponenCopy2D(Point startPoint, int sliceDirection, int sliceNum) {
        this.selectedComponentAction2D(startPoint, sliceDirection, sliceNum, false, false, false, true, false, false, -1.0, -1.0);
    }

    public void selectedComponenDilate2D(Point startPoint, int sliceDirection, int sliceNum, boolean isSmart, double min, double max) {
        this.selectedComponentAction2D(startPoint, sliceDirection, sliceNum, false, true, false, false, false, isSmart, min, max);
    }

    public void selectedComponenErode2D(Point startPoint, int sliceDirection, int sliceNum, boolean isSmart, double min, double max) {
        this.selectedComponentAction2D(startPoint, sliceDirection, sliceNum, false, false, true, false, false, isSmart, min, max);
    }

    public void selectedComponentCopy3D(Coordinate coor) {
        this.makeROIFileBuffer3D();
        this.selectedComponentAction3D(coor, false, false, false, false, true, false, -1.0, -1.0);
    }

    public void selectedComponentDilate3D(Coordinate coor, boolean isSmart, double min, double max) {
        this.makeROIFileBuffer3D();
        this.selectedComponentAction3D(coor, false, false, true, false, false, isSmart, min, max);
    }

    public void selectedComponentErode3D(Coordinate coor, boolean isSmart, double min, double max) {
        this.makeROIFileBuffer3D();
        this.selectedComponentAction3D(coor, false, false, false, true, false, isSmart, min, max);
    }

    public void selectedComponentRemove2D(Point startPoint, int sliceDirection, int sliceNum, boolean removeThis) {
        this.selectedComponentAction2D(startPoint, sliceDirection, sliceNum, removeThis, false, false, false, false, false, -1.0, -1.0);
    }

    public void selectedComponentRemove3D(Coordinate coor, boolean removeThis) {
        this.makeROIFileBuffer3D();
        this.selectedComponentAction3D(coor, false, removeThis, false, false, false, false, -1.0, -1.0);
    }

    public void selectedComponentValues2D(Point startPoint, int sliceDirection, int sliceNum, boolean isSmart, double min, double max) {
        if (sliceDirection == 0) {
            this.selectedComponentAction2DValueAxial(startPoint, sliceDirection, sliceNum, min, max);
        } else if (sliceDirection == 1) {
            this.selectedComponentAction2DValueCoronal(startPoint, sliceDirection, sliceNum, min, max);
        } else {
            this.selectedComponentAction2DValueSagittal(startPoint, sliceDirection, sliceNum, min, max);
        }
    }

    public void selectedComponentValues3D(Coordinate coor, boolean isSmart, double min, double max) {
        this.makeROIFileBuffer3D();
        this.selectedComponentAction3D(coor, true, false, false, false, false, isSmart, min, max);
    }

    public void selectNextUsedROIColor() {
        int ctr;
        long usedROIs = this.roiBuffer.getUsed();
        int colorNew = -1;
        for (ctr = this.currentROI + 1; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((usedROIs & 1L << ctr) == 0L) continue;
            colorNew = ctr;
            break;
        }
        if (colorNew != -1) {
            for (ctr = 0; ctr < this.currentROI; ++ctr) {
                if ((usedROIs & 1L << ctr) == 0L) continue;
                colorNew = ctr;
                break;
            }
        }
        if (colorNew != -1) {
            this.currentROI = colorNew;
        } else {
            ++this.currentROI;
            this.currentROI %= this.roiBuffer.getMaximumColors();
        }
    }

    public void selectSome(long mask) {
        long selectedROIs = mask;
        this.roiBuffer.setSelected(selectedROIs &= this.roiBuffer.getUsed());
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    public void select(int color) {
        this.roiBuffer.setSelected(this.roiBuffer.getSelected() | 1L << color);
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    public void setAsSaved() {
        this.setDirty(false);
    }

    public void setBufferSeriesIndex(int index) {
        if (this.isUsing4dROI()) {
            this.roiBuffer.setSeriesIndex(index);
        }
    }

    public synchronized void setClusterData(ClusterRejectionData crd, int index) {
        if (crd == null) {
            this.clusterData.remove(index);
        } else {
            this.clusterData.put(index, crd);
        }
    }

    public void setCurrentROI(int num) {
        this.currentROI = num;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setHighlighted(boolean bool, int roiNum) {
        long mask = 1L << roiNum;
        if (bool) {
            this.roiBuffer.addHighlighted(mask);
        } else {
            this.roiBuffer.removeHighlighted(mask);
        }
    }

    public void setKernelSize(int val) {
        this.kernelSize = val;
    }

    public void setLabel(int index, String label) {
        this.setLabel(index, label, true);
    }

    public void setLabel(int index, String label, boolean notify) {
        this.labels.setLabel(index, label);
        if (notify) {
            this.labelChanged();
        }
    }

    public void setLabelBuffer(ByteBuffer buffer) {
        this.workBuffer = buffer;
    }

    public void setLabelData(byte[] data) {
        this.labels.setData(data);
        this.labelChanged();
    }

    public void setLabelListener(LabelListener listener) {
        this.labelListener = listener;
    }

    public void setLoadedROIVolume(Volume vol) {
        this.loadedROIVolume = vol;
    }

    public void setSelectedSlice(int sliceNum, int sliceDirection) {
        if (sliceDirection == 0) {
            this.axialSelectedSlice = sliceNum;
        } else if (sliceDirection == 1) {
            this.coronalSelectedSlice = sliceNum;
        } else if (sliceDirection == 2) {
            this.sagittalSelectedSlice = sliceNum;
        }
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    public void setShape(int sliceNum, int sliceDirection, boolean isSmart, double min, double max, boolean paint) {
        this.setShape(sliceNum, sliceDirection, isSmart, min, max, paint, 0, 0, false);
    }

    public void setShape(int sliceNum, int sliceDirection, boolean isSmart, double min, double max, boolean paint, int toolRangeAboveVal, int toolRangeBelowVal, boolean isEllipse) {
        VolumeData volData = new VolumeData(this.user);
        this.willUseROI(this.currentROI);
        int toolRangeAbove = toolRangeAboveVal;
        int toolRangeBelow = toolRangeBelowVal;
        if (sliceDirection == 0) {
            if (toolRangeAbove == -1) {
                toolRangeAbove = this.zDim;
            }
            if (toolRangeBelow == -1) {
                toolRangeBelow = this.zDim;
            }
            int sliceMin = Math.max(0, sliceNum - toolRangeAbove);
            int sliceMax = Math.min(this.zDim - 2, sliceNum + toolRangeBelow);
            this.willChangeROI(new ImageBounds(0, this.xDim - 1, 0, this.yDim - 1, sliceMin, sliceMax), false, sliceDirection);
            for (int ctrS = sliceMin; ctrS <= sliceMax; ++ctrS) {
                int sliceOffset = this.xDim * this.yDim * ctrS;
                for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        int offset = ctrX + offsetY + sliceOffset;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (isSmart) {
                            double current = volData.getValue(ctrX, ctrY, ctrS);
                            if (paint) {
                                if ((this.axialROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) != 0L || !(current >= min) || !(current <= max)) continue;
                                this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if ((this.axialROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) == 0L || !(current >= min) || !(current <= max)) continue;
                            this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if ((this.axialROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8) continue;
                        if (paint) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        } else if (sliceDirection == 1) {
            if (toolRangeAbove == -1) {
                toolRangeAbove = this.yDim;
            }
            if (toolRangeBelow == -1) {
                toolRangeBelow = this.yDim;
            }
            int sliceMin = Math.max(0, sliceNum - toolRangeAbove);
            int sliceMax = Math.min(this.yDim - 2, sliceNum + toolRangeBelow);
            this.willChangeROI(new ImageBounds(0, this.xDim - 1, sliceMin, sliceMax, 0, this.zDim - 1), false, sliceDirection);
            for (int ctrS = sliceMin; ctrS <= sliceMax; ++ctrS) {
                int sliceOffset = this.xDim * ctrS;
                for (int ctrY = 0; ctrY < this.zDim; ++ctrY) {
                    int offsetY = this.xDim * this.yDim * ctrY;
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        int offset = ctrX + sliceOffset + offsetY;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (isSmart) {
                            double current = volData.getValue(ctrX, ctrS, ctrY);
                            if (paint) {
                                if ((this.coronalROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) != 0L || !(current >= min) || !(current <= max)) continue;
                                this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if ((this.coronalROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) == 0L || !(current >= min) || !(current <= max)) continue;
                            this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if ((this.coronalROIShapeData[this.currentROI][ctrX + this.xDim * ctrY] & 8) != 8) continue;
                        if (paint) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        } else {
            if (toolRangeAbove == -1) {
                toolRangeAbove = this.xDim;
            }
            if (toolRangeBelow == -1) {
                toolRangeBelow = this.xDim;
            }
            int sliceMin = Math.max(0, sliceNum - toolRangeAbove);
            int sliceMax = Math.min(this.xDim - 2, sliceNum + toolRangeBelow);
            this.willChangeROI(new ImageBounds(sliceMin, sliceMax, 0, this.yDim - 1, 0, this.zDim - 1), false, sliceDirection);
            for (int ctrS = sliceMin; ctrS <= sliceMax; ++ctrS) {
                for (int ctrY = 0; ctrY < this.zDim; ++ctrY) {
                    int offsetY = this.xDim * this.yDim * ctrY;
                    for (int ctrX = 0; ctrX < this.yDim; ++ctrX) {
                        int offset = ctrS + this.xDim * ctrX + offsetY;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (isSmart) {
                            double current = volData.getValue(ctrS, ctrX, ctrY);
                            if (paint) {
                                if ((this.sagittalROIShapeData[this.currentROI][ctrX + this.yDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) != 0L || !(current >= min) || !(current <= max)) continue;
                                this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if ((this.sagittalROIShapeData[this.currentROI][ctrX + this.yDim * ctrY] & 8) != 8 || (oldMaskData & MASKS[this.currentROI]) == 0L || !(current >= min) || !(current <= max)) continue;
                            this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if ((this.sagittalROIShapeData[this.currentROI][ctrX + this.yDim * ctrY] & 8) != 8) continue;
                        if (paint) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_SHAPE_EDITED, MASKS[this.currentROI], sliceNum);
        this.updateUsedROIs(this.roiBuffer.getUsed());
    }

    public void setShape(int sliceNum, int sliceDirection, ROIShape shape, int adjustingROI) {
        this.setShape(sliceNum, sliceDirection, shape, adjustingROI, true);
    }

    public void setShape(int sliceNum, int sliceDirection, ROIShape shape, int adjustingROI, boolean reset) {
        this.roiBuffer.addUsed(MASKS[adjustingROI]);
        if (sliceDirection == 0) {
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, sliceNum, sliceNum), false, sliceDirection, false, !reset);
            int sliceOffset = this.xDim * this.yDim * sliceNum;
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetY = this.xDim * ctrY;
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    int offset = ctrX + offsetY + sliceOffset;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (shape.transformedShapeContains(ctrX, ctrY)) {
                        this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        } else if (sliceDirection == 1) {
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, sliceNum, sliceNum, 0, this.zDim - 2), false, sliceDirection, false, !reset);
            int sliceOffset = this.xDim * sliceNum;
            for (int ctrY = 0; ctrY < this.zDim - 1; ++ctrY) {
                int offsetY = this.xDim * this.yDim * ctrY;
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    int offset = ctrX + sliceOffset + offsetY;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (shape.transformedShapeContains(ctrX, ctrY)) {
                        this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        } else {
            this.willChangeROI(new ImageBounds(sliceNum, sliceNum, 0, this.yDim - 2, 0, this.zDim - 2), false, sliceDirection, false, !reset);
            for (int ctrY = 0; ctrY < this.zDim - 1; ++ctrY) {
                int offsetY = this.xDim * this.yDim * ctrY;
                for (int ctrX = 0; ctrX < this.yDim - 1; ++ctrX) {
                    int offset = sliceNum + this.xDim * ctrX + offsetY;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (shape.transformedShapeContains(ctrX, ctrY)) {
                        this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }
        this.finishedChangingROI(MESSAGE_SHAPE_EDITED, MASKS[adjustingROI], sliceNum);
        this.updateUsedROIs(this.roiBuffer.getSelected());
    }

    public void setShape(int sliceNum, int sliceDirection, Shape shape, boolean resetClipboards, boolean isSmart, double min, double max) {
        VolumeData volData = null;
        if (isSmart) {
            volData = new VolumeData(this.user);
        }
        Rectangle bounds = shape.getBounds();
        this.roiBuffer.addUsed(MASKS[this.currentROI]);
        if (sliceDirection == 0) {
            int xMin = Math.max(0, bounds.x);
            int xMax = Math.min(this.xDim - 1, bounds.x + bounds.width);
            int yMin = Math.max(0, bounds.y);
            int yMax = Math.min(this.yDim - 1, bounds.y + bounds.height);
            this.willChangeROI(new ImageBounds(xMin, xMax - 1, yMin, yMax - 1, sliceNum, sliceNum), false, sliceDirection, false, !resetClipboards);
            int sliceOffset = this.xDim * this.yDim * sliceNum;
            for (int ctrY = yMin; ctrY < yMax; ++ctrY) {
                int offsetY = this.xDim * ctrY;
                for (int ctrX = xMin; ctrX < xMax; ++ctrX) {
                    int offset = ctrX + offsetY + sliceOffset;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (!shape.contains((double)ctrX + 0.5, (double)ctrY + 0.5)) continue;
                    if (isSmart) {
                        double current = volData.getValue(ctrX, ctrY, sliceNum);
                        if (current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                }
            }
        } else if (sliceDirection == 1) {
            int xMin = Math.max(0, bounds.x);
            int xMax = Math.min(this.xDim - 1, bounds.x + bounds.width);
            int yMin = Math.max(0, bounds.y);
            int yMax = Math.min(this.zDim - 1, bounds.y + bounds.height);
            this.willChangeROI(new ImageBounds(xMin, xMax - 1, sliceNum, sliceNum, yMin, yMax - 1), false, sliceDirection, false, !resetClipboards);
            int sliceOffset = this.xDim * sliceNum;
            for (int ctrY = yMin; ctrY < yMax; ++ctrY) {
                int offsetY = this.xDim * this.yDim * ctrY;
                for (int ctrX = xMin; ctrX < xMax; ++ctrX) {
                    int offset = ctrX + sliceOffset + offsetY;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (!shape.contains((double)ctrX + 0.5, (double)ctrY + 0.5)) continue;
                    if (isSmart) {
                        double current = volData.getValue(ctrX, sliceNum, ctrY);
                        if (current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                }
            }
        } else {
            int xMin = Math.max(0, bounds.x);
            int xMax = Math.min(this.yDim - 1, bounds.x + bounds.width);
            int yMin = Math.max(0, bounds.y);
            int yMax = Math.min(this.zDim - 1, bounds.y + bounds.height);
            this.willChangeROI(new ImageBounds(sliceNum, sliceNum, xMin, xMax - 1, yMin, yMax - 1), false, sliceDirection, false, !resetClipboards);
            for (int ctrY = yMin; ctrY < yMax; ++ctrY) {
                int offsetY = this.xDim * this.yDim * ctrY;
                for (int ctrX = xMin; ctrX < xMax; ++ctrX) {
                    int offset = sliceNum + this.xDim * ctrX + offsetY;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    if (!shape.contains((double)ctrX + 0.5, (double)ctrY + 0.5)) continue;
                    if (isSmart) {
                        double current = volData.getValue(sliceNum, ctrX, ctrY);
                        if (current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[this.currentROI]);
                }
            }
        }
        this.finishedChangingROI(MESSAGE_SHAPE_ADDED, MASKS[this.currentROI], sliceNum);
        this.updateUsedROIs(this.roiBuffer.getUsed());
    }

    public void setUseROISeries(boolean useSeries) {
        this.updateROIBufferSeries(useSeries);
    }

    public boolean shrinkWrap2D(int sliceNum, final int sliceDirection, final double thresholdMin, final double thresholdMax, final boolean within, final long withinMask, final int withinOutput, final boolean excludeZero, final boolean isSeries, final boolean isDynamicThreshold, boolean sync) {
        final ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        boolean foundData = false;
        if (sliceNum != -1) {
            if (sliceDirection == 0) {
                bounds.setRangeZ(sliceNum, sliceNum);
            } else if (sliceDirection == 1) {
                bounds.setRangeY(sliceNum, sliceNum);
            } else if (sliceDirection == 2) {
                bounds.setRangeX(sliceNum, sliceNum);
            }
        } else if (within) {
            ImageBounds ibROI = this.roiBuffer.getROIBoundsCurrent(this.roiBuffer.getSelected());
            if (sliceDirection == 0) {
                bounds.setRangeZ(ibROI.getMinZ(), ibROI.getMaxZ());
            } else if (sliceDirection == 1) {
                bounds.setRangeY(ibROI.getMinY(), ibROI.getMaxY());
            } else if (sliceDirection == 2) {
                bounds.setRangeX(ibROI.getMinX(), ibROI.getMaxX());
            }
        }
        if (within) {
            this.willUseROI(withinOutput);
        } else {
            this.willUseROI(this.currentROI);
        }
        if (sliceNum == -1) {
            if (sync) {
                this.willChangeROI(bounds, isSeries, sliceDirection);
                if (sliceDirection == 0) {
                    foundData = this.doMakeShrinkWrapAxial(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                } else if (sliceDirection == 1) {
                    foundData = this.doMakeShrinkWrapCoronal(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                } else if (sliceDirection == 2) {
                    foundData = this.doMakeShrinkWrapSagittal(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                }
                if (!foundData && !within && this.listener != null) {
                    this.listener.showWarningDialog(WARNING_MESSAGE_NO_DATA, WARNING_TITLE);
                }
                this.finishedChangingROI(MESSAGE_IMPORTED, within ? withinMask : MASKS[this.currentROI], -1);
            } else {
                Thread workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ROIManager.this.willChangeROI(bounds, isSeries, sliceDirection);
                        boolean foundData = false;
                        if (sliceDirection == 0) {
                            foundData = ROIManager.this.doMakeShrinkWrapAxial(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                        } else if (sliceDirection == 1) {
                            foundData = ROIManager.this.doMakeShrinkWrapCoronal(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                        } else if (sliceDirection == 2) {
                            foundData = ROIManager.this.doMakeShrinkWrapSagittal(thresholdMin, thresholdMax, bounds, true, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
                        }
                        if (!foundData && !within && ROIManager.this.listener != null) {
                            ROIManager.this.listener.showWarningDialog(ROIManager.WARNING_MESSAGE_NO_DATA, ROIManager.WARNING_TITLE);
                        }
                        ROIManager.this.finishedChangingROI(ROIManager.MESSAGE_IMPORTED, within ? withinMask : MASKS[ROIManager.this.currentROI], -1);
                    }
                }, "ROIManager.shrinkWrap2D() Thread");
                workThread.start();
            }
        } else {
            foundData = false;
            this.willChangeROI(bounds, isSeries, sliceDirection);
            if (sliceDirection == 0) {
                foundData = this.doMakeShrinkWrapAxial(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
            } else if (sliceDirection == 1) {
                foundData = this.doMakeShrinkWrapCoronal(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
            } else if (sliceDirection == 2) {
                foundData = this.doMakeShrinkWrapSagittal(thresholdMin, thresholdMax, bounds, false, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
            }
            if (!foundData && this.listener != null) {
                this.listener.showWarningDialog(WARNING_MESSAGE_NO_DATA, WARNING_TITLE);
            }
            this.finishedChangingROI(MESSAGE_IMPORTED, within ? withinMask : MASKS[this.currentROI], -1);
        }
        return foundData;
    }

    public void shrinkWrap3D(final double thresholdMin, final double thresholdMax, final Volume volume, final boolean within, final long withinMask, final int withinOutput, final boolean excludeZero, final boolean isSeries, final boolean isDynamicThreshold) {
        this.makeROIFileBuffer3D();
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.runShrinkWrap3D(thresholdMin, thresholdMax, volume, within, withinMask, withinOutput, excludeZero, isSeries, isDynamicThreshold);
            }
        }, "ROIManager.shrinkWrap3D() Thread");
        workThread.start();
    }

    private boolean makeROIFileBuffer3D() {
        ByteBuffer roiBuffer3D = null;
        if (this.getLabelBuffer() == null) {
            roiBuffer3D = ROIManager.createROIFileBuffer3D(this.xDim, this.yDim, this.zDim);
            this.setLabelBuffer(roiBuffer3D);
        }
        return roiBuffer3D != null;
    }

    public static ByteBuffer createROIFileBuffer3D(int xDim, int yDim, int zDim) {
        ByteBuffer buffer = null;
        try {
            buffer = Image.makeBuffer(xDim * yDim * zDim * 4);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
        }
        return buffer;
    }

    public boolean runShrinkWrap3D(double thresholdMin, double thresholdMax, Volume volume, boolean within, long withinMask, int withinOutput, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        this.makeROIFileBuffer3D();
        boolean foundData = this.doShrinkWrap3d(thresholdMin, thresholdMax, volume, within, withinMask, withinOutput, excludeZero, true, isSeries, isDynamicThreshold);
        if (!foundData && !within && this.listener != null) {
            this.listener.showWarningDialog(WARNING_MESSAGE_NO_DATA, WARNING_TITLE);
        }
        return foundData;
    }

    public boolean toggleSelectedState(int num) {
        boolean bool = !this.isSelected(num);
        this.setSelectedState(num, bool);
        return bool;
    }

    public boolean makeROIBuffer() {
        try {
            Volume volume = (Volume)this.user.getBaseVolume();
            int sliceSize = (volume.getXDim() + 1) * (volume.getYDim() + 1);
            int volSize = sliceSize * (volume.getZDim() + 1);
            this.makeBuffer(volSize, sliceSize);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            return false;
        }
        return true;
    }

    public boolean makeROISeriesBuffer() {
        try {
            Volume currentVolume = (Volume)this.user.getCurrentVolume();
            Volume volume = (Volume)this.user.getBaseVolume();
            int currentTimepoint = currentVolume.getCurrentTimepoint();
            int timepoints = currentVolume.getNumTimepoints();
            int sliceSize = (volume.getXDim() + 1) * (volume.getYDim() + 1);
            int volSize = sliceSize * (volume.getZDim() + 1);
            this.makeBufferSeries(timepoints, volSize, sliceSize);
            this.setBufferSeriesIndex(currentTimepoint);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            return false;
        }
        return true;
    }

    public void updateROIBufferSeries(boolean isSeries) {
        if (isSeries ^ this.isUsing4dROI()) {
            this.clearUsedROIs();
        }
        Volume currentVolume = (Volume)this.user.getCurrentVolume();
        if (isSeries && currentVolume.getNumTimepoints() > 1) {
            this.makeROISeriesBuffer();
        } else {
            this.makeROIBuffer();
        }
        JVMUtilities.clearGarbage();
        if (this.listener != null) {
            this.listener.roiSeriesStatusChanged();
        }
    }

    public void toggleSelectedState(int roiNum, int sliceNum, int sliceDirection) {
        boolean sliceMatch = false;
        if (sliceDirection == 0) {
            if (this.axialSelectedSlice == sliceNum) {
                this.toggleSelectedState(roiNum);
                sliceMatch = true;
            }
        } else if (sliceDirection == 1) {
            if (this.coronalSelectedSlice == sliceNum) {
                this.toggleSelectedState(roiNum);
                sliceMatch = true;
            }
        } else if (sliceDirection == 2 && this.sagittalSelectedSlice == sliceNum) {
            this.toggleSelectedState(roiNum);
            sliceMatch = true;
        }
        if (!sliceMatch) {
            this.deselectAll();
            this.setSelectedSlice(sliceNum, sliceDirection);
            this.setSelectedState(roiNum, true);
        }
    }

    public void setSelectedState(int roiNum, int sliceNum, int sliceDirection, boolean select) {
        boolean sliceMatch = false;
        if (sliceDirection == 0) {
            if (this.axialSelectedSlice == sliceNum) {
                this.setSelectedState(roiNum, select);
                sliceMatch = true;
            }
        } else if (sliceDirection == 1) {
            if (this.coronalSelectedSlice == sliceNum) {
                this.setSelectedState(roiNum, select);
                sliceMatch = true;
            }
        } else if (sliceDirection == 2 && this.sagittalSelectedSlice == sliceNum) {
            this.setSelectedState(roiNum, select);
            sliceMatch = true;
        }
        if (!sliceMatch) {
            this.deselectAll();
            this.setSelectedSlice(sliceNum, sliceDirection);
            this.setSelectedState(roiNum, select);
        }
    }

    public void undoROI(boolean sameThread) {
        if (sameThread) {
            this.doUndoROI();
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ROIManager.this.doUndoROI();
                }
            }, "ROIManager.undoROI() Thread");
            workThread.start();
        }
    }

    private void clearRegion(final ImageBounds bounds, final long mask, final boolean skipResetClipboards, boolean sameThread) {
        if (sameThread) {
            this.doClearRegion(bounds, mask, skipResetClipboards);
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ROIManager.this.doClearRegion(bounds, mask, skipResetClipboards);
                }
            }, "ROIManager.clearRegion() Thread");
            workThread.start();
        }
    }

    public void doClearSelected(boolean skipResetClipboards) {
        this.doClearRegion(new ImageBounds(0, this.xDim - 1, 0, this.yDim - 1, 0, this.zDim - 1), this.roiBuffer.getSelected(), skipResetClipboards);
    }

    private void colorsWillChange(final int numColorsNew) {
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doColorsWillChange(numColorsNew);
            }
        });
    }

    private void deselectAll(boolean notify) {
        this.roiBuffer.clearSelected();
        if (notify && this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    private void doAddShape(Coordinate startPoint, int sizeX, int sizeY, int sizeZ, double originalSize, boolean isCube, boolean isSphere) {
        boolean addShape = (this.roiBuffer.getUsed() & MASKS[this.currentROI]) == 0L;
        this.willUseROI(this.currentROI);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_ADD);
        if (isCube) {
            int distanceMinX = -1 * (sizeX / 2);
            int distanceMinY = -1 * (sizeY / 2);
            int distanceMinZ = -1 * (sizeZ / 2);
            int distanceMaxX = sizeX / 2 - (sizeX % 2 == 0 ? 1 : 0);
            int distanceMaxY = sizeY / 2 - (sizeY % 2 == 0 ? 1 : 0);
            int distanceMaxZ = sizeZ / 2 - (sizeZ % 2 == 0 ? 1 : 0);
            int startSlice = Math.max(0, startPoint.zInt + distanceMinZ - 1);
            int endSlice = Math.min(this.zDim - 2, startPoint.zInt + distanceMaxZ + 1);
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, startSlice, endSlice), false, 0);
            pb.start(0, 0, endSlice - startSlice - 1);
            for (int ctrZ = startSlice; ctrZ <= endSlice; ++ctrZ) {
                pb.setValue(ctrZ - startSlice);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        double diffX = startPoint.xInt - ctrX;
                        double diffY = startPoint.yInt - ctrY;
                        double diffZ = startPoint.zInt - ctrZ;
                        if (diffX >= (double)distanceMinX && diffX <= (double)distanceMaxX && diffY >= (double)distanceMinY && diffY <= (double)distanceMaxY && diffZ >= (double)distanceMinZ && diffZ <= (double)distanceMaxZ) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            }
        } else if (isSphere) {
            Coordinate startCoor = new Coordinate();
            Coordinate currentCoor = new Coordinate();
            Volume volume = (Volume)this.user.getBaseVolume();
            double xSize = volume.getXSize();
            double ySize = volume.getYSize();
            double zSize = volume.getZSize();
            startCoor.setValues((double)startPoint.xInt * xSize, (double)startPoint.yInt * ySize, (double)startPoint.zInt * zSize);
            int sizeZf = sizeZ;
            int startSlice = Math.max(0, startPoint.zInt - sizeZf - 1);
            int endSlice = Math.min(this.zDim - 2, startPoint.zInt + sizeZf + 1);
            double radius = originalSize;
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, startSlice, endSlice), false, 0);
            pb.start(0, 0, endSlice - startSlice - 1);
            for (int ctrZ = startSlice; ctrZ <= endSlice; ++ctrZ) {
                pb.setValue(ctrZ - startSlice);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long maskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(maskData);
                        currentCoor.setValues((double)ctrX * xSize, (double)ctrY * ySize, (double)ctrZ * zSize);
                        if (startCoor.distance(currentCoor) <= radius) {
                            maskData |= MASKS[this.currentROI];
                        }
                        this.roiBuffer.putCurrent(offset, maskData);
                    }
                }
            }
        }
        pb.setValue(pb.getMax());
        if (addShape) {
            Solid solid = new Solid(originalSize, isCube ? 3 : 2);
            this.solidShapeMap.put(this.currentROI, solid);
        }
        this.finishedChangingROI(MESSAGE_ADDED, MASKS[this.currentROI], -1);
    }

    private void doClearRegion(ImageBounds bounds, long mask, boolean skipResetClipboard) {
        this.willChangeROI(bounds, this.isUsing4dROI(), 0, false, skipResetClipboard);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_CLEAR);
            pb.start(0, 0, bounds.getMaxT());
        } else if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_CLEAR);
            pb.start(bounds.getMinZ(), bounds.getMinZ(), bounds.getMaxZ());
        }
        this.undoClipboard.setLabels(this.labels.getLabelModelCopy());
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetZ = this.xDim * this.yDim * ctrZ;
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offset = ctrX + offsetY + offsetZ;
                        long oldMaskData = this.roiBuffer.get(offset, roiT);
                        this.undoClipboard.put(oldMaskData);
                        this.roiBuffer.put(offset, roiT, oldMaskData & (mask ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((mask & 1L << ctr) == 0L) continue;
            this.setLabel(ctr, null);
        }
        this.updateUsedROIs(mask);
        this.deselectAll(true);
        this.finishedChangingROI(MESSAGE_CLEARED, mask, -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doColorsWillChange(int numColorsNew) {
        int ctr;
        int numColorsOld = this.roiBuffer.getMaximumColors();
        this.undoClipboard.makeHelper(numColorsNew);
        this.redoClipboard.makeHelper(numColorsNew);
        if (this.editClipboard != null) {
            this.editClipboard.makeHelper(numColorsNew);
        }
        this.resetClipboards();
        Mask[] roisNew = new Mask[numColorsNew];
        for (ctr = 0; ctr < numColorsOld; ++ctr) {
            roisNew[ctr] = this.rois[ctr];
        }
        for (ctr = numColorsOld; ctr < numColorsNew; ++ctr) {
            this.axialROIShape[ctr] = new ROIShape(ctr);
            this.coronalROIShape[ctr] = new ROIShape(ctr);
            this.sagittalROIShape[ctr] = new ROIShape(ctr);
            this.axialROIShapeSurface[ctr] = new ROIShape(ctr);
            this.coronalROIShapeSurface[ctr] = new ROIShape(ctr);
            this.sagittalROIShapeSurface[ctr] = new ROIShape(ctr);
            roisNew[ctr] = new Mask(this, ctr);
        }
        this.labels.increaseSize(numColorsNew);
        this.rois = roisNew;
    }

    private void doCopy() {
        this.editClipboard.initializePutting();
        this.roiBuffer.rewind();
        this.editingDisabled = true;
        this.editClipboard.setCopyType(1);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_COPY);
        pb.start(0, 0, this.zDim);
        for (int ctrBuf = 0; ctrBuf < this.zDim; ++ctrBuf) {
            byte[] slice = this.roiBuffer.getNextSliceCurrent();
            this.editClipboard.put(slice, slice.length);
            pb.setValue(ctrBuf);
        }
        pb.setValue(pb.getMax());
        this.editClipboard.finishPutting();
        this.editingDisabled = false;
        if (this.listener != null) {
            this.listener.roiHasChanged(this.rois[this.currentROI], MESSAGE_COPIED, 0L, -2);
        }
    }

    private void doCopySeries() {
        int numTimepoints = this.roiBuffer.getSeriesLength();
        this.editClipboard.initializePutting();
        this.roiBuffer.rewind();
        this.editingDisabled = true;
        this.editClipboard.setCopyType(2);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_COPY);
        pb.start(0, 0, numTimepoints);
        for (int ctr = 0; ctr < numTimepoints; ++ctr) {
            for (int ctrBuf = 0; ctrBuf < this.zDim; ++ctrBuf) {
                byte[] slice = this.roiBuffer.getNextSlice(ctr);
                this.editClipboard.put(slice, slice.length);
            }
            pb.setValue(ctr);
        }
        pb.setValue(pb.getMax());
        this.editClipboard.finishPutting();
        this.editingDisabled = false;
        if (this.listener != null) {
            this.listener.roiHasChanged(this.rois[this.currentROI], MESSAGE_COPIED, 0L, -2);
        }
    }

    private void doDilate2D(int sliceNum, int sliceDirection, int kernel, boolean doClipboard, long mask) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (sliceDirection == 0) {
            bounds.setRangeZ(sliceNum, sliceNum);
        } else if (sliceDirection == 1) {
            bounds.setRangeY(sliceNum, sliceNum);
        } else if (sliceDirection == 2) {
            bounds.setRangeX(sliceNum, sliceNum);
        }
        this.willChangeROI(bounds, this.isUsing4dROI(), sliceDirection, !doClipboard);
        boolean showProgressSeries = this.isUsing4dROI();
        ProgressMeter pb = null;
        if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_DILATE);
            pb.start(0, 0, bounds.getMaxT());
        }
        int kernelHalf = kernel / 2;
        if (sliceDirection == 0) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrX;
                int ctrY;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * ctrY + this.xDim * this.yDim * sliceNum;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                    if (Math.abs(ctrSliceY) + Math.abs(ctrSliceX) > kernelHalf || ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY()) continue;
                                    int n = ctrX + ctrSliceX + (ctrY + ctrSliceY) * this.xDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        long newMask = 0L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrY * this.xDim + ctrX] & MASKS[ctrR]) == 0L) continue;
                            newMask |= MASKS[ctrR];
                        }
                        int offsetROI = ctrX + this.xDim * ctrY + this.xDim * this.yDim * sliceNum;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | newMask);
                    }
                }
            }
        } else if (sliceDirection == 1) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrX;
                int ctrZ;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * sliceNum + this.xDim * this.yDim * ctrZ;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                    if (Math.abs(ctrSliceZ) + Math.abs(ctrSliceX) > kernelHalf || ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ()) continue;
                                    int n = ctrX + ctrSliceX + (ctrZ + ctrSliceZ) * this.xDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        long newMask = 0L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrZ * this.xDim + ctrX] & MASKS[ctrR]) == 0L) continue;
                            newMask |= MASKS[ctrR];
                        }
                        int offsetROI = ctrX + this.xDim * sliceNum + this.xDim * this.yDim * ctrZ;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | newMask);
                    }
                }
            }
        } else if (sliceDirection == 2) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrY;
                int ctrZ;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        int offsetROI = sliceNum + this.xDim * ctrY + this.xDim * this.yDim * ctrZ;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                    if (Math.abs(ctrSliceZ) + Math.abs(ctrSliceY) > kernelHalf || ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ()) continue;
                                    int n = ctrY + ctrSliceY + (ctrZ + ctrSliceZ) * this.yDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        long newMask = 0L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrZ * this.yDim + ctrY] & MASKS[ctrR]) == 0L) continue;
                            newMask |= MASKS[ctrR];
                        }
                        int offsetROI = sliceNum + this.xDim * ctrY + this.xDim * this.yDim * ctrZ;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | newMask);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_DILATED, !doClipboard, mask, -1);
        if (showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doDilate3D(int kernel, boolean doClipboard, long mask) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.willChangeROI(bounds, this.isUsing4dROI(), 0, !doClipboard);
        this.roiBuffer.makeCopyBuffer(this.xDim * this.yDim * this.zDim);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_DILATE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_DILATE);
            pb.start(0, 0, bounds.getMaxT());
        }
        int kernelHalf = kernel / 2;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int ctrZ;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            this.roiBuffer.clearCopyBuffer();
            for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                int kOffsetZ = (ctrZ + ctrSliceZ) * this.xDim * this.yDim;
                                for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                    int kOffsetY = (ctrY + ctrSliceY) * this.xDim;
                                    for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                        int kOffset = ctrX + ctrSliceX + kOffsetY + kOffsetZ;
                                        if (Math.abs(ctrSliceY) + Math.abs(ctrSliceX) + Math.abs(ctrSliceZ) > kernelHalf || ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ()) continue;
                                        this.roiBuffer.putCopy(kOffset, this.roiBuffer.getCopy(kOffset) | MASKS[ctr]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetZ = this.xDim * this.yDim * ctrZ;
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + offsetY + offsetZ;
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | this.roiBuffer.getCopy(offsetROI));
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_DILATED, !doClipboard, mask, -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doErode2D(int sliceNum, int sliceDirection, int kernel, boolean doClipboard, long mask) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (sliceDirection == 0) {
            bounds.setRangeZ(sliceNum, sliceNum);
        } else if (sliceDirection == 1) {
            bounds.setRangeY(sliceNum, sliceNum);
        } else if (sliceDirection == 2) {
            bounds.setRangeX(sliceNum, sliceNum);
        }
        this.willChangeROI(bounds, this.isUsing4dROI(), sliceDirection, !doClipboard);
        boolean showProgressSeries = this.isUsing4dROI();
        ProgressMeter pb = null;
        if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_ERODE);
            pb.start(0, 0, bounds.getMaxT());
        }
        int kernelHalf = kernel / 2;
        if (sliceDirection == 0) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrX;
                int ctrY;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * sliceNum);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                    if (Math.abs(ctrSliceY) + Math.abs(ctrSliceX) > kernelHalf) continue;
                                    if (ctrX + ctrSliceX == 0 || ctrX + ctrSliceX == bounds.getMaxX() || ctrY + ctrSliceY == 0 || ctrY + ctrSliceY == bounds.getMaxY()) {
                                        int n = ctrX + ctrY * this.xDim;
                                        slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                        continue;
                                    }
                                    if (ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY() || (this.roiBuffer.get(ctrX + ctrSliceX + this.xDim * (ctrY + ctrSliceY) + this.xDim * this.yDim * sliceNum, roiT) & MASKS[ctr]) != 0L) continue;
                                    int n = ctrX + ctrY * this.xDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        long newMask = -1L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrY * this.xDim + ctrX] & MASKS[ctrR]) == 0L) continue;
                            newMask &= MASKS[ctrR] ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * sliceNum);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData & newMask);
                    }
                }
            }
        } else if (sliceDirection == 1) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrX;
                int ctrZ;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (sliceNum + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                    if (Math.abs(ctrSliceZ) + Math.abs(ctrSliceX) > kernelHalf) continue;
                                    if (ctrX + ctrSliceX == 0 || ctrX + ctrSliceX == bounds.getMaxX() || ctrZ + ctrSliceZ == 0 || ctrZ + ctrSliceZ == bounds.getMaxZ()) {
                                        int n = ctrX + ctrZ * this.xDim;
                                        slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                        continue;
                                    }
                                    if (ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ() || (this.roiBuffer.get(ctrX + ctrSliceX + this.xDim * sliceNum + this.xDim * this.yDim * (ctrZ + ctrSliceZ), roiT) & MASKS[ctr]) != 0L) continue;
                                    int n = ctrX + ctrZ * this.xDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        long newMask = -1L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrZ * this.xDim + ctrX] & MASKS[ctrR]) == 0L) continue;
                            newMask &= MASKS[ctrR] ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        int offsetROI = ctrX + this.xDim * (sliceNum + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData & newMask);
                    }
                }
            }
        } else if (sliceDirection == 2) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                int ctrY;
                int ctrZ;
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                int[] slice = this.getResetSliceBuffer(sliceDirection);
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        int offsetROI = sliceNum + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                    if (Math.abs(ctrSliceZ) + Math.abs(ctrSliceY) > kernelHalf) continue;
                                    if (ctrY + ctrSliceY == 0 || ctrY + ctrSliceY == bounds.getMaxY() || ctrZ + ctrSliceZ == 0 || ctrZ + ctrSliceZ == bounds.getMaxZ()) {
                                        int n = ctrY + ctrZ * this.yDim;
                                        slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                        continue;
                                    }
                                    if (ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ() || (this.roiBuffer.get(sliceNum + this.xDim * (ctrY + ctrSliceY) + this.xDim * this.yDim * (ctrZ + ctrSliceZ), roiT) & MASKS[ctr]) != 0L) continue;
                                    int n = ctrY + ctrZ * this.yDim;
                                    slice[n] = (int)((long)slice[n] | MASKS[ctr]);
                                }
                            }
                        }
                    }
                }
                for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        long newMask = -1L;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || ((long)slice[ctrZ * this.yDim + ctrY] & MASKS[ctrR]) == 0L) continue;
                            newMask &= MASKS[ctrR] ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        int offsetROI = sliceNum + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData & newMask);
                    }
                }
            }
        }
        this.updateUsedROIs(this.roiBuffer.getSelected());
        this.finishedChangingROI(MESSAGE_ERODED, !doClipboard, mask, -1);
        if (showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doErode3D(int kernel, boolean doClipboard, long mask) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.willChangeROI(bounds, this.isUsing4dROI(), 0, !doClipboard);
        this.roiBuffer.makeCopyBuffer(this.xDim * this.yDim * this.zDim);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_ERODE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_ERODE);
            pb.start(0, 0, bounds.getMaxT());
        }
        int kernelHalf = kernel / 2;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int ctrZ;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            this.roiBuffer.clearCopyBuffer();
            for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        if (doClipboard) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        block4: for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                            if ((mask & MASKS[ctr]) == 0L || (oldMaskData & MASKS[ctr]) == 0L) continue;
                            for (int ctrSliceZ = -1 * kernelHalf; ctrSliceZ <= kernelHalf; ++ctrSliceZ) {
                                int kOffsetZ = (ctrZ + ctrSliceZ) * this.xDim * this.yDim;
                                for (int ctrSliceY = -1 * kernelHalf; ctrSliceY <= kernelHalf; ++ctrSliceY) {
                                    int kOffsetY = (ctrY + ctrSliceY) * this.xDim;
                                    for (int ctrSliceX = -1 * kernelHalf; ctrSliceX <= kernelHalf; ++ctrSliceX) {
                                        int kOffset;
                                        if (Math.abs(ctrSliceX) + Math.abs(ctrSliceY) + Math.abs(ctrSliceZ) > kernelHalf) continue;
                                        if (ctrX + ctrSliceX == 0 || ctrX + ctrSliceX == bounds.getMaxX() || ctrY + ctrSliceY == 0 || ctrY + ctrSliceY == bounds.getMaxY() || ctrZ + ctrSliceZ == 0 || ctrZ + ctrSliceZ == bounds.getMaxZ()) {
                                            this.roiBuffer.putCopy(offsetROI, this.roiBuffer.getCopy(offsetROI) | MASKS[ctr]);
                                            continue block4;
                                        }
                                        if (ctrX + ctrSliceX < 0 || ctrX + ctrSliceX > bounds.getMaxX() || ctrY + ctrSliceY < 0 || ctrY + ctrSliceY > bounds.getMaxY() || ctrZ + ctrSliceZ < 0 || ctrZ + ctrSliceZ > bounds.getMaxZ() || (this.roiBuffer.get(kOffset = ctrX + ctrSliceX + kOffsetY + kOffsetZ, roiT) & MASKS[ctr]) != 0L) continue;
                                        this.roiBuffer.putCopy(offsetROI, this.roiBuffer.getCopy(offsetROI) | MASKS[ctr]);
                                        continue block4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetZ = ctrZ * this.xDim * this.yDim;
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetY = ctrY * this.xDim;
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        long newMask = -1L;
                        int offsetROI = ctrX + offsetY + offsetZ;
                        for (int ctrR = 0; ctrR < this.roiBuffer.getMaximumColors(); ++ctrR) {
                            if ((mask & MASKS[ctrR]) == 0L || (this.roiBuffer.getCopy(offsetROI) & MASKS[ctrR]) == 0L) continue;
                            newMask &= MASKS[ctrR] ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData & newMask);
                    }
                }
            }
        }
        this.updateUsedROIs(mask);
        this.finishedChangingROI(MESSAGE_ERODED, !doClipboard, mask, -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    public void doImportROI(Volume importVolume, boolean forceWorld, boolean isMangoROI) {
        boolean isSingleColor;
        boolean isSeries;
        VolumeData volData;
        volData.setWorldMode((volData = new VolumeData(this.user, importVolume)).isWorldMode() || forceWorld);
        volData.setMMMode(true);
        ImageType imageType = importVolume.getImageType();
        long typeMask = imageType.createBitMask();
        Coordinate4D foundCoor = null;
        long loadingMask = 0L;
        boolean hadUsed = this.roiBuffer.getUsed() != 0L;
        int numTimepointsImport = importVolume.getNumTimepoints();
        int numTimepointsCurrent = this.user.getCurrentVolume().getSeriesLength();
        int numTimepoints = Math.min(numTimepointsImport, numTimepointsCurrent);
        boolean bl = isSeries = numTimepoints > 1;
        if (isSeries ^ this.isUsing4dROI()) {
            this.updateROIBufferSeries(isSeries);
        }
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.willChangeROI(bounds, isSeries, 0);
        bounds.setRangeT(0, numTimepoints - 1);
        this.setUndoBounds(bounds, 0);
        boolean showProgressSeries = isSeries;
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_IMPORT);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_IMPORT);
            pb.start(0, 0, numTimepoints);
        }
        double loadingMin = Double.MAX_VALUE;
        double loadingMax = -1.7976931348623157E308;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        if (!bounds.inBounds(ctrX, ctrY, ctrZ)) continue;
                        if (isMangoROI) {
                            loadingMask |= volData.getNativeIntegerValue(ctrX, ctrY, ctrZ, ctrT) & typeMask;
                            continue;
                        }
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        int currentInt = (int)Math.round(current);
                        if (current < loadingMin) {
                            loadingMin = current;
                        }
                        if (current > loadingMax) {
                            loadingMax = current;
                        }
                        if (currentInt < 1 || currentInt > 64) continue;
                        loadingMask |= MASKS[currentInt - 1];
                    }
                }
            }
        }
        int foundColors = Long.bitCount(loadingMask);
        boolean bl2 = isSingleColor = foundColors == 1;
        if (isSingleColor) {
            loadingMask = MASKS[this.currentROI];
        } else if (!isMangoROI) {
            loadingMask = MASKS[this.currentROI];
        }
        this.increaseColors(BitUtilities.findNeededPrecision((long)loadingMask));
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((loadingMask >> ctr & 1L) != 1L) continue;
            this.willUseROI(ctr);
        }
        long loadingMaskInverse = loadingMask ^ 0xFFFFFFFFFFFFFFFFL;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        long currentByte = 0L;
                        if (isMangoROI) {
                            currentByte = volData.getNativeIntegerValue(ctrX, ctrY, ctrZ, ctrT) & typeMask;
                            if (isSingleColor && currentByte != 0L) {
                                currentByte = loadingMask;
                            }
                        } else {
                            double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                            if (current != 0.0) {
                                currentByte = loadingMask;
                            }
                        }
                        this.undoClipboard.put(oldMaskData);
                        oldMaskData &= loadingMaskInverse;
                        if (currentByte == 0L) continue;
                        if (foundCoor == null) {
                            foundCoor = new Coordinate4D((double)ctrX, (double)ctrY, (double)ctrZ, ctrT);
                        }
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | currentByte);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_IMPORTED, loadingMask, -1);
        if (this.listener != null) {
            this.listener.importROICompleted(importVolume, (Coordinate)foundCoor);
        }
        if (!hadUsed) {
            this.setDirty(false);
        }
        this.loadedROIVolume = importVolume;
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    public boolean doLoadROI(Volume importVolume, String metadata, boolean sameThread) {
        boolean isSingleColor;
        boolean showProgressSeries;
        this.makeROIBuffer();
        Coordinate4D foundCoor = null;
        long loadingMask = 0L;
        boolean hadUsed = this.roiBuffer.getUsed() != 0L;
        int numTimepoints = importVolume.getNumTimepoints();
        boolean isSeries = numTimepoints > 1;
        ImageType imageType = importVolume.getImageType();
        long typeMask = imageType.createBitMask();
        if (isSeries ^ this.isUsing4dROI()) {
            this.updateROIBufferSeries(isSeries);
        }
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        this.willChangeROI(bounds, isSeries, 0);
        bounds.setRangeT(0, Math.min(numTimepoints, this.user.getBaseVolume().getSeriesLength()) - 1);
        if (!hadUsed) {
            this.setDirty(false);
        }
        boolean showProgress = !(showProgressSeries = isSeries) && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_SCAN);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_SCAN);
            pb.start(0, 0, numTimepoints);
        }
        int[] xCount = new int[this.xDim];
        int[] yCount = new int[this.yDim];
        int[] zCount = new int[this.zDim];
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        if (!bounds.inBounds(ctrX, ctrY, ctrZ)) continue;
                        long mask = importVolume.getNativeIntegerValueAtIndex(ctrX, ctrY, ctrZ, ctrT) & typeMask;
                        loadingMask |= mask;
                        if (mask == 0L) continue;
                        int n = ctrX;
                        xCount[n] = xCount[n] + 1;
                        int n2 = ctrY;
                        yCount[n2] = yCount[n2] + 1;
                        int n3 = ctrZ;
                        zCount[n3] = zCount[n3] + 1;
                        if (foundCoor != null) continue;
                        foundCoor = new Coordinate4D((double)ctrX, (double)ctrY, (double)ctrZ, ctrT);
                    }
                }
            }
        }
        if (foundCoor != null && foundCoor.seriesPoint == 0) {
            int xLoc = CollectionUtilities.findIndexOfMax((int[])xCount);
            int yLoc = CollectionUtilities.findIndexOfMax((int[])yCount);
            int zLoc = CollectionUtilities.findIndexOfMax((int[])zCount);
            foundCoor = new Coordinate4D((double)xLoc, (double)yLoc, (double)zLoc, 0);
        }
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_LOAD);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_LOAD);
            pb.start(0, 0, numTimepoints);
        }
        int foundColors = Long.bitCount(loadingMask);
        boolean bl = isSingleColor = foundColors == 1;
        if (isSingleColor) {
            loadingMask = MASKS[this.currentROI];
        }
        this.increaseColors(BitUtilities.findNeededPrecision((long)loadingMask));
        for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
            if ((loadingMask >> ctr & 1L) != 1L) continue;
            this.willUseROI(ctr);
        }
        long loadingMaskInverse = loadingMask ^ 0xFFFFFFFFFFFFFFFFL;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ + this.zDim);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.undoClipboard.put(oldMaskData);
                        long newMaskData = oldMaskData & loadingMaskInverse;
                        long current = 0L;
                        if (bounds.inBounds(ctrX, ctrY, ctrZ)) {
                            current = importVolume.getNativeIntegerValueAtIndex(ctrX, ctrY, ctrZ, ctrT) & typeMask;
                        }
                        if (isSingleColor) {
                            if (current != 0L) {
                                this.roiBuffer.put(offsetROI, roiT, loadingMask | newMaskData);
                                continue;
                            }
                            this.roiBuffer.put(offsetROI, roiT, newMaskData);
                            continue;
                        }
                        this.roiBuffer.put(offsetROI, roiT, current | newMaskData);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_LOADED, loadingMask, -1);
        if (this.listener != null) {
            this.listener.loadROICompleted(importVolume, (Coordinate)foundCoor, metadata, !hadUsed, isSingleColor, sameThread);
        }
        this.loadedROIVolume = importVolume;
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return isSingleColor;
    }

    private boolean doMakeRangeROI(ImageBounds bounds, double thresholdMinVal, double thresholdMaxVal, boolean excludeZero, boolean noProgressMeter, boolean isSeries, boolean isDynamicThreshold) {
        VolumeData volData = new VolumeData(this.user);
        this.willUseROI(this.currentROI);
        this.willChangeROI(bounds, isSeries, 0);
        double thresholdMin = thresholdMinVal;
        double thresholdMax = thresholdMaxVal;
        double thresholdMinPercentMax = thresholdMin;
        double thresholdMaxPercentMax = thresholdMax;
        boolean showProgressSeries = isSeries && !noProgressMeter;
        boolean showProgress = !showProgressSeries && this.needsProgressMeter() && !noProgressMeter;
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        boolean foundData = false;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                thresholdMin = volData.getMax() * (thresholdMinPercentMax / 100.0);
                thresholdMax = volData.getMax() * (thresholdMaxPercentMax / 100.0);
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.undoClipboard.put(oldMaskData);
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        if (!(current <= thresholdMax) || !(current >= thresholdMin) || excludeZero && current == 0.0) continue;
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[this.currentROI]);
                        foundData = true;
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CREATED, MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData;
    }

    private boolean doMakeShrinkWrapAxial(double thresholdMinVal, double thresholdMaxVal, ImageBounds bounds, boolean showProgressVal, boolean within, long withinMask, int withinOutput, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        VolumeData volData = new VolumeData(this.user);
        double thresholdMin = thresholdMinVal;
        double thresholdMax = thresholdMaxVal;
        double thresholdMinPercentMax = thresholdMin;
        double thresholdMaxPercentMax = thresholdMax;
        boolean showProgress = showProgressVal;
        boolean showProgressSeries = isSeries;
        boolean bl = !showProgressSeries;
        ProgressMeter pb = null;
        if (showProgress &= bl) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        boolean foundData = false;
        int[] slice = this.getResetSliceBuffer(0);
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int yDimDataMax;
            int xDimDataMax;
            int yDimDataMin;
            int xDimDataMin;
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                thresholdMin = volData.getMax() * (thresholdMinPercentMax / 100.0);
                thresholdMax = volData.getMax() * (thresholdMaxPercentMax / 100.0);
            }
            if (within) {
                ImageBounds ib = this.roiBuffer.getROIBounds(withinMask, roiT);
                xDimDataMin = ib.getMinX();
                yDimDataMin = ib.getMinY();
                xDimDataMax = ib.getMaxX();
                yDimDataMax = ib.getMaxY();
            } else {
                xDimDataMin = 0;
                xDimDataMax = this.xDim;
                yDimDataMin = 0;
                yDimDataMax = this.yDim;
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetROI;
                int ctrX;
                int componentCtr = 1;
                EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
                equivSetManager.addStartVal(1);
                int offsetROIZ = this.xDim * this.yDim * ctrZ;
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetROIY = this.xDim * ctrY;
                    int offsetROIYMinusY = this.xDim * (ctrY - 1);
                    for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        boolean outside;
                        offsetROI = ctrX + offsetROIY;
                        int offsetROIMinusX = ctrX - 1 + offsetROIY;
                        int offsetROIMinusY = ctrX + offsetROIYMinusY;
                        slice[offsetROI] = 0;
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        boolean bl2 = outside = current < thresholdMin || current > thresholdMax || excludeZero && current == 0.0;
                        if (within) {
                            outside |= (this.getMaskValue(ctrX, ctrY, ctrZ, ctrT) & withinMask) == 0L;
                        }
                        if (outside) {
                            if (ctrX <= xDimDataMin || ctrY <= yDimDataMin || ctrX > xDimDataMax || ctrY > yDimDataMax) {
                                slice[offsetROI] = 1;
                                continue;
                            }
                            if (ctrX == xDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusX] == slice[offsetROI] || slice[offsetROIMinusX] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROI]);
                                continue;
                            }
                            if (ctrY == yDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusY] == slice[offsetROI] || slice[offsetROIMinusY] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROI]);
                                continue;
                            }
                            if (slice[offsetROIMinusX] != 0 && slice[offsetROIMinusY] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusX];
                                if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                                continue;
                            }
                            if (slice[offsetROIMinusX] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusX];
                                continue;
                            }
                            if (slice[offsetROIMinusY] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusY];
                                continue;
                            }
                            equivSetManager.incrementSetMap();
                            slice[offsetROI] = ++componentCtr;
                            continue;
                        }
                        foundData = true;
                    }
                }
                boolean[] contains = new boolean[componentCtr + 1];
                ROIManager.findConnectedLabels(contains, equivSetManager, 1);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    int offsetROIY = this.xDim * ctrY;
                    for (ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        offsetROI = ctrX + offsetROIY;
                        int offsetROIByteArray = offsetROI + offsetROIZ;
                        long oldMaskData = this.roiBuffer.get(offsetROIByteArray, roiT);
                        this.undoClipboard.put(oldMaskData);
                        if (within) {
                            if (!contains[slice[offsetROI]]) {
                                this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[withinOutput]);
                                continue;
                            }
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[withinOutput] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (!contains[slice[offsetROI]]) {
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData;
    }

    private boolean doMakeShrinkWrapCoronal(double thresholdMinVal, double thresholdMaxVal, ImageBounds bounds, boolean showProgressVal, boolean within, long withinMask, int withinOutput, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        VolumeData volData = new VolumeData(this.user);
        double thresholdMin = thresholdMinVal;
        double thresholdMax = thresholdMaxVal;
        double thresholdMinPercentMax = thresholdMin;
        double thresholdMaxPercentMax = thresholdMax;
        boolean showProgress = showProgressVal;
        boolean showProgressSeries = isSeries;
        boolean bl = !showProgressSeries;
        ProgressMeter pb = null;
        if (showProgress &= bl) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        boolean foundData = false;
        int[] slice = this.getResetSliceBuffer(1);
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int zDimDataMax;
            int xDimDataMax;
            int zDimDataMin;
            int xDimDataMin;
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                thresholdMin = volData.getMax() * (thresholdMinPercentMax / 100.0);
                thresholdMax = volData.getMax() * (thresholdMaxPercentMax / 100.0);
            }
            if (within) {
                ImageBounds ib = this.roiBuffer.getROIBounds(withinMask, roiT);
                xDimDataMin = ib.getMinX();
                zDimDataMin = ib.getMinZ();
                xDimDataMax = ib.getMaxX();
                zDimDataMax = ib.getMaxZ();
            } else {
                xDimDataMin = 0;
                xDimDataMax = this.xDim;
                zDimDataMin = 0;
                zDimDataMax = this.zDim;
            }
            for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                int componentCtr = 1;
                EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
                equivSetManager.addStartVal(1);
                int offsetROIY = ctrY * this.xDim;
                if (showProgress) {
                    pb.setValue(ctrY);
                }
                for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    int offsetROIZ = ctrZ * this.xDim;
                    int offsetROIZMinusZ = (ctrZ - 1) * this.xDim;
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        boolean outside;
                        int offsetROI = ctrX + offsetROIZ;
                        int offsetROIMinusX = ctrX - 1 + offsetROIZ;
                        int offsetROIMinusZ = ctrX + offsetROIZMinusZ;
                        slice[offsetROI] = 0;
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        boolean bl2 = outside = current < thresholdMin || current > thresholdMax || excludeZero && current == 0.0;
                        if (within) {
                            outside |= (this.getMaskValue(ctrX, ctrY, ctrZ, ctrT) & withinMask) == 0L;
                        }
                        if (outside) {
                            if (ctrX <= xDimDataMin || ctrZ <= zDimDataMin || ctrX > xDimDataMax || ctrZ > zDimDataMax) {
                                slice[offsetROI] = 1;
                                continue;
                            }
                            if (ctrX == xDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusX] == slice[offsetROI] || slice[offsetROIMinusX] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROI]);
                                continue;
                            }
                            if (ctrZ == zDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusZ] == slice[offsetROI] || slice[offsetROIMinusZ] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusZ], slice[offsetROI]);
                                continue;
                            }
                            if (slice[offsetROIMinusX] != 0 && slice[offsetROIMinusZ] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusX];
                                if (slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                                continue;
                            }
                            if (slice[offsetROIMinusX] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusX];
                                continue;
                            }
                            if (slice[offsetROIMinusZ] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusZ];
                                continue;
                            }
                            equivSetManager.incrementSetMap();
                            slice[offsetROI] = ++componentCtr;
                            continue;
                        }
                        foundData = true;
                    }
                }
                boolean[] contains = new boolean[componentCtr + 1];
                ROIManager.findConnectedLabels(contains, equivSetManager, 1);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    int offsetROIZ = this.xDim * ctrZ;
                    int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        int offsetROI = ctrX + offsetROIZ;
                        int offsetROIByteArray = ctrX + offsetROIY + offsetROIByteArrayZ;
                        long oldMaskData = this.roiBuffer.get(offsetROIByteArray, roiT);
                        this.undoClipboard.put(oldMaskData);
                        if (within) {
                            if (!contains[slice[offsetROI]]) {
                                this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[withinOutput]);
                                continue;
                            }
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[withinOutput] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (!contains[slice[offsetROI]]) {
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData;
    }

    private boolean doMakeShrinkWrapSagittal(double thresholdMinVal, double thresholdMaxVal, ImageBounds bounds, boolean showProgressVal, boolean within, long withinMask, int withinOutput, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        VolumeData volData = new VolumeData(this.user);
        boolean showProgress = showProgressVal;
        double thresholdMin = thresholdMinVal;
        double thresholdMax = thresholdMaxVal;
        double thresholdMinPercentMax = thresholdMin;
        double thresholdMaxPercentMax = thresholdMax;
        boolean showProgressSeries = isSeries;
        boolean bl = !showProgressSeries;
        ProgressMeter pb = null;
        if (showProgress &= bl) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        boolean foundData = false;
        int[] slice = this.getResetSliceBuffer(2);
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int zDimDataMax;
            int yDimDataMax;
            int zDimDataMin;
            int yDimDataMin;
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                thresholdMin = volData.getMax() * (thresholdMinPercentMax / 100.0);
                thresholdMax = volData.getMax() * (thresholdMaxPercentMax / 100.0);
            }
            if (within) {
                ImageBounds ib = this.roiBuffer.getROIBounds(withinMask, roiT);
                yDimDataMin = ib.getMinY();
                zDimDataMin = ib.getMinZ();
                yDimDataMax = ib.getMaxY();
                zDimDataMax = ib.getMaxZ();
            } else {
                yDimDataMin = 0;
                yDimDataMax = this.yDim;
                zDimDataMin = 0;
                zDimDataMax = this.zDim;
            }
            for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                int componentCtr = 1;
                EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
                equivSetManager.addStartVal(1);
                if (showProgress) {
                    pb.setValue(ctrX);
                }
                for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    int offsetROIZ = this.yDim * ctrZ;
                    int offsetROIZMinusZ = this.yDim * (ctrZ - 1);
                    for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        boolean outside;
                        int offsetROI = ctrY + offsetROIZ;
                        int offsetROIMinusY = ctrY - 1 + offsetROIZ;
                        int offsetROIMinusZ = ctrY + offsetROIZMinusZ;
                        slice[offsetROI] = 0;
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        boolean bl2 = outside = current < thresholdMin || current > thresholdMax || excludeZero && current == 0.0;
                        if (within) {
                            outside |= (this.getMaskValue(ctrX, ctrY, ctrZ, ctrT) & withinMask) == 0L;
                        }
                        if (outside) {
                            if (ctrY <= yDimDataMin || ctrZ <= zDimDataMin || ctrY > yDimDataMax || ctrZ > zDimDataMax) {
                                slice[offsetROI] = 1;
                                continue;
                            }
                            if (ctrY == yDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusY] == slice[offsetROI] || slice[offsetROIMinusY] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROI]);
                                continue;
                            }
                            if (ctrZ == zDimDataMax) {
                                slice[offsetROI] = 1;
                                if (slice[offsetROIMinusZ] == slice[offsetROI] || slice[offsetROIMinusZ] == 0) continue;
                                equivSetManager.addPair(slice[offsetROIMinusZ], slice[offsetROI]);
                                continue;
                            }
                            if (slice[offsetROIMinusY] != 0 && slice[offsetROIMinusZ] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusY];
                                if (slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                                equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                                continue;
                            }
                            if (slice[offsetROIMinusY] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusY];
                                continue;
                            }
                            if (slice[offsetROIMinusZ] != 0) {
                                slice[offsetROI] = slice[offsetROIMinusZ];
                                continue;
                            }
                            equivSetManager.incrementSetMap();
                            slice[offsetROI] = ++componentCtr;
                            continue;
                        }
                        foundData = true;
                    }
                }
                boolean[] contains = new boolean[componentCtr + 1];
                ROIManager.findConnectedLabels(contains, equivSetManager, 1);
                for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                    int offsetROIZ = this.yDim * ctrZ;
                    int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        int offsetROI = ctrY + offsetROIZ;
                        int offsetROIByteArray = ctrX + this.xDim * ctrY + offsetROIByteArrayZ;
                        long oldMaskData = this.roiBuffer.get(offsetROIByteArray, roiT);
                        this.undoClipboard.put(oldMaskData);
                        if (within) {
                            if (!contains[slice[offsetROI]]) {
                                this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[withinOutput]);
                                continue;
                            }
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[withinOutput] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (!contains[slice[offsetROI]]) {
                            this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.put(offsetROIByteArray, roiT, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData;
    }

    public void doMakeLogicalROI(Logical logical, ImageBounds bounds) {
        this.willUseROI(this.currentROI);
        this.willChangeROI(bounds, false, 0);
        List allOverlays = this.user.getOverlays();
        int logicalHash = logical.hashCode();
        boolean showProgress = this.needsProgressMeter();
        ProgressMeter progress = null;
        if (showProgress) {
            progress = this.user.makeProgressMeter();
            progress.setDescription(PROGRESS_DESCRIPTION_MAKE);
            progress.start(0, 0, this.zDim);
        }
        VolumeData[] volsData = new VolumeData[allOverlays.size()];
        for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
            volsData[ctr] = new VolumeData(this.user, (Volume)allOverlays.get(ctr));
        }
        for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
            if (progress != null) {
                progress.setValue(ctrZ);
            }
            for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                    int overlaysHash = 0;
                    int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                    long oldMaskData = this.roiBuffer.get(offsetROI, 0);
                    this.undoClipboard.put(oldMaskData);
                    for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
                        boolean logicalContains;
                        Volume volume = (Volume)allOverlays.get(ctr);
                        double value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                        double overlayScreenMin = this.user.getVolumeDisplayRangeMin(volume);
                        boolean isNegative = this.user.isVolumeDisplayNegative(volume);
                        boolean aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                        if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                            overlaysHash = 0;
                            break;
                        }
                        if (!aboveThreshold || !logicalContains) continue;
                        overlaysHash += volume.hashCode();
                    }
                    if (logicalHash != overlaysHash) continue;
                    this.roiBuffer.put(offsetROI, 0, oldMaskData | MASKS[this.currentROI]);
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CREATED, MASKS[this.currentROI], -1);
        if (showProgress) {
            progress.setValue(progress.getMax());
        }
    }

    private boolean doMakeThresholdROI(ImageBounds bounds, double threhsoldVal, boolean excludeZero, boolean noProgressMeter, boolean isSeries, boolean isDynamicThreshold) {
        double threshold = threhsoldVal;
        VolumeData volData = new VolumeData(this.user);
        this.willUseROI(this.currentROI);
        this.willChangeROI(bounds, isSeries, 0);
        double thresholdMinPercentMax = threshold;
        boolean showProgressSeries = isSeries && !noProgressMeter;
        boolean showProgress = !showProgressSeries && this.needsProgressMeter() && !noProgressMeter;
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_MAKE);
            pb.start(0, 0, bounds.getMaxT());
        }
        boolean foundData = false;
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            int roiT;
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int n = roiT = this.isUsing4dROI() ? ctrT : 0;
            if (isDynamicThreshold) {
                volData.findVolumeRange(ctrT);
                threshold = volData.getMax() * (thresholdMinPercentMax / 100.0);
            }
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offsetROI = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.get(offsetROI, roiT);
                        this.undoClipboard.put(oldMaskData);
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        if (!(current >= threshold) || excludeZero && current == 0.0) continue;
                        this.roiBuffer.put(offsetROI, roiT, oldMaskData | MASKS[this.currentROI]);
                        foundData = true;
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CREATED, MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
        return foundData;
    }

    private void doOperationROI(ROIOperationTreeNode op, ImageBounds bounds) {
        this.willUseROI(this.currentROI);
        this.willChangeROI(bounds, this.isUsing4dROI(), 0);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_CALCULATE);
            pb.start(0, 0, this.zDim);
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_CALCULATE);
            pb.start(0, 0, bounds.getMaxT());
        }
        for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
            if (showProgressSeries) {
                pb.setValue(ctrT);
            }
            int roiT = this.isUsing4dROI() ? ctrT : 0;
            for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                int offsetZ = this.xDim * this.yDim * ctrZ;
                if (showProgress) {
                    pb.setValue(ctrZ);
                }
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                        int offset = ctrX + offsetY + offsetZ;
                        long oldMaskData = this.roiBuffer.get(offset, roiT);
                        long operationData = op.getResult(oldMaskData) ? MASKS[this.currentROI] : 0L;
                        this.undoClipboard.put(oldMaskData);
                        this.roiBuffer.put(offset, roiT, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL) | operationData);
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_CALCULATED, MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doPasteSeries() {
        this.editClipboard.initializeGetting();
        if (!this.isUsing4dROI()) {
            this.updateROIBufferSeries(true);
        }
        long copyMask = this.editClipboard.getCopyMask();
        boolean isCopyMultiSelected = this.editClipboard.isMultiSelectionCopied();
        long currentColorPasteMask = MASKS[this.currentROI];
        this.increaseColors(this.editClipboard.getCopyMaskMaxColors());
        if (isCopyMultiSelected) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((copyMask >> ctr & 1L) != 1L) continue;
                this.willUseROI(ctr);
            }
        } else {
            this.willUseROI(this.currentROI);
        }
        ImageBounds bounds = new ImageBounds(0, this.xDim - 1, 0, this.yDim - 1, 0, this.zDim - 1);
        this.willChangeROI(bounds, true, 0);
        int copiedTimepoints = this.editClipboard.getT();
        int currentTimepoints = this.isUsing4dROI() ? this.roiBuffer.getSeriesLength() : 1;
        int timepoints = Math.min(copiedTimepoints, currentTimepoints);
        bounds.setRangeT(0, timepoints - 1);
        this.setUndoBounds(bounds, 0);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_PASTE);
        pb.start(0, 0, timepoints);
        long pastedMask = 0L;
        for (int ctrT = 0; ctrT < timepoints; ++ctrT) {
            pb.setValue(ctrT);
            for (int ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        int offsetBuffer = ctrX + this.xDim * ctrY;
                        int offset = offsetBuffer + this.xDim * this.yDim * ctrZ;
                        long oldMaskData = this.roiBuffer.get(offset, ctrT);
                        long pasteMask = this.editClipboard.get();
                        pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                        pastedMask |= pasteMask;
                        this.undoClipboard.put(oldMaskData);
                        this.roiBuffer.put(offset, ctrT, oldMaskData | pasteMask);
                    }
                }
            }
        }
        pb.setValue(pb.getMax());
        this.editClipboard.finishGetting();
        this.finishedChangingROI(MESSAGE_PASTED, pastedMask, -1);
        this.deselectAll();
    }

    private void doPasteVolume() {
        this.editClipboard.initializeGetting();
        int pastedX = this.editClipboard.getX();
        int pastedY = this.editClipboard.getY();
        int pastedZ = this.editClipboard.getZ();
        double pastedXSize = this.editClipboard.getXSize();
        double pastedYSize = this.editClipboard.getYSize();
        double pastedZSize = this.editClipboard.getZSize();
        double thisXSize = this.user.getBaseVolume().getXSize();
        double thisYSize = this.user.getBaseVolume().getYSize();
        double thisZSize = this.user.getBaseVolume().getZSize();
        double xRatio = thisXSize / pastedXSize;
        double yRatio = thisYSize / pastedYSize;
        double zRatio = thisZSize / pastedZSize;
        boolean isWorldMode = this.user.isWorldMode();
        Coordinate originPasted = this.editClipboard.getOrigin();
        Coordinate origin = this.user.getOrigin();
        long copyMask = this.editClipboard.getCopyMask();
        boolean isCopyMultiSelected = this.editClipboard.isMultiSelectionCopied();
        long currentColorPasteMask = MASKS[this.currentROI];
        this.increaseColors(this.editClipboard.getCopyMaskMaxColors());
        if (isCopyMultiSelected) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((copyMask >> ctr & 1L) != 1L) continue;
                this.willUseROI(ctr);
            }
        } else {
            this.willUseROI(this.currentROI);
        }
        byte[] pasteBuffer = this.editClipboard.makePasteBuffer(pastedX * pastedY);
        this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), this.isUsing4dROI(), 0);
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_PASTE);
        long pastedMask = 0L;
        if (isWorldMode) {
            if (zRatio < 1.0) {
                int zDiff = (int)((double)Math.round(originPasted.zDbl * pastedZSize - origin.zDbl * thisZSize) / -thisZSize);
                double yDiff = (originPasted.yDbl * pastedYSize - origin.yDbl * thisYSize) / pastedYSize;
                double xDiff = (originPasted.xDbl * pastedXSize - origin.xDbl * thisXSize) / pastedXSize;
                int pasteIndexZ = Integer.MIN_VALUE;
                pb.start(0, 0, this.zDim);
                for (int ctrZ = zDiff; ctrZ < this.zDim - 1; ++ctrZ) {
                    int pasteIndexZCurrent = (int)Math.round((double)ctrZ * zRatio);
                    if (pasteIndexZCurrent > pasteIndexZ) {
                        this.editClipboard.get(pasteBuffer);
                    }
                    pasteIndexZ = pasteIndexZCurrent;
                    pb.setValue(Math.max(0, ctrZ));
                    if (ctrZ < 0) continue;
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                            long pasteMask;
                            int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                            long oldMaskData = this.roiBuffer.getCurrent(offset);
                            this.undoClipboard.put(oldMaskData);
                            int pasteIndexY = (int)Math.round((double)ctrY * yRatio + yDiff);
                            int pasteIndexX = (int)Math.round((double)ctrX * xRatio + xDiff);
                            if (pasteIndexX < pastedX && pasteIndexX >= 0 && pasteIndexY < pastedY && pasteIndexY >= 0) {
                                pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                                pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                            } else {
                                pasteMask = 0L;
                            }
                            pastedMask |= pasteMask;
                            this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                        }
                    }
                }
            } else {
                double zDiff = (originPasted.zDbl * pastedZSize - origin.zDbl * thisZSize) / thisZSize;
                double yDiff = (originPasted.yDbl * pastedYSize - origin.yDbl * thisYSize) / pastedYSize;
                double xDiff = (originPasted.xDbl * pastedXSize - origin.xDbl * thisXSize) / pastedXSize;
                int pasteIndexZ = Integer.MIN_VALUE;
                pb.start(0, 0, pastedZ);
                for (int ctrZ = 0; ctrZ < pastedZ; ++ctrZ) {
                    int pasteIndexZCurrent = (int)Math.round((double)ctrZ * (1.0 / zRatio) - zDiff);
                    boolean storeUndo = pasteIndexZCurrent > pasteIndexZ;
                    pasteIndexZ = pasteIndexZCurrent;
                    this.editClipboard.get(pasteBuffer);
                    pb.setValue(Math.max(0, ctrZ));
                    if (pasteIndexZ >= this.zDim - 1 || pasteIndexZ < 0 || ctrZ < 0) continue;
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                            long pasteMask;
                            int offset = ctrX + this.xDim * ctrY + this.xDim * this.yDim * pasteIndexZ;
                            long oldMaskData = this.roiBuffer.getCurrent(offset);
                            if (storeUndo) {
                                this.undoClipboard.put(oldMaskData);
                            }
                            int pasteIndexY = (int)Math.round((double)ctrY * yRatio + yDiff);
                            int pasteIndexX = (int)Math.round((double)ctrX * xRatio + xDiff);
                            if (pasteIndexX < pastedX && pasteIndexX >= 0 && pasteIndexY < pastedY && pasteIndexY >= 0) {
                                pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                                pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                            } else {
                                pasteMask = 0L;
                            }
                            pastedMask |= pasteMask;
                            this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                        }
                    }
                }
            }
        } else if (zRatio < 1.0) {
            int pasteIndexZ = -1;
            pb.start(0, 0, this.zDim);
            for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                int pasteIndexZCurrent = (int)Math.round((double)ctrZ * zRatio);
                if (pasteIndexZCurrent > pasteIndexZ) {
                    this.editClipboard.get(pasteBuffer);
                }
                pasteIndexZ = pasteIndexZCurrent;
                pb.setValue(ctrZ);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        long pasteMask;
                        int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        int pasteIndexY = (int)Math.round((double)ctrY * yRatio);
                        int pasteIndexX = (int)Math.round((double)ctrX * xRatio);
                        if (pasteIndexX < pastedX && pasteIndexY < pastedY) {
                            pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                            pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                        } else {
                            pasteMask = 0L;
                        }
                        pastedMask |= pasteMask;
                        this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                    }
                }
            }
        } else {
            int pasteIndexZ = -1;
            pb.start(0, 0, pastedZ);
            for (int ctrZ = 0; ctrZ < pastedZ; ++ctrZ) {
                int pasteIndexZCurrent = (int)Math.round((double)ctrZ * (1.0 / zRatio));
                boolean storeUndo = pasteIndexZCurrent > pasteIndexZ;
                pasteIndexZ = pasteIndexZCurrent;
                if (pasteIndexZ >= this.zDim - 1) continue;
                this.editClipboard.get(pasteBuffer);
                pb.setValue(ctrZ);
                for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                        long pasteMask;
                        int offset = ctrX + this.xDim * ctrY + this.xDim * this.yDim * pasteIndexZ;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        if (storeUndo) {
                            this.undoClipboard.put(oldMaskData);
                        }
                        int pasteIndexY = (int)Math.round((double)ctrY * yRatio);
                        int pasteIndexX = (int)Math.round((double)ctrX * xRatio);
                        if (pasteIndexX < pastedX && pasteIndexY < pastedY) {
                            pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                            pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                        } else {
                            pasteMask = 0L;
                        }
                        pastedMask |= pasteMask;
                        this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                    }
                }
            }
        }
        pb.setValue(pb.getMax());
        this.editClipboard.finishGetting();
        this.finishedChangingROI(MESSAGE_PASTED, pastedMask, -1);
        this.deselectAll();
    }

    private void doPropagate(int sliceDirection, int sliceNum, int startSlice, int endSlice, long roiMask, int outputColor) {
        ImageBounds bounds = new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2);
        if (sliceDirection == 0) {
            bounds.setRangeZ(startSlice, endSlice);
        } else if (sliceDirection == 1) {
            bounds.setRangeY(startSlice, endSlice);
        } else if (sliceDirection == 2) {
            bounds.setRangeX(startSlice, endSlice);
        }
        int outputColorIndex = outputColor;
        if (outputColorIndex == -1) {
            outputColorIndex = this.currentROI;
        }
        long selectedMask = roiMask;
        boolean isCurrentUsed = this.isUsed(outputColorIndex);
        if (!isCurrentUsed) {
            this.willUseROI(outputColorIndex);
        }
        this.willChangeROI(bounds, this.isUsing4dROI(), sliceDirection);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries;
        ProgressMeter pb = null;
        if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_PROPAGATE);
            pb.start(0, 0, bounds.getMaxT());
        } else {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_PROPAGATE);
            pb.start(0, 0, endSlice - startSlice - 1);
        }
        if (sliceDirection == 0) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                for (int ctrZ = startSlice; ctrZ <= endSlice; ++ctrZ) {
                    if (showProgress) {
                        pb.setValue(ctrZ - startSlice);
                    }
                    for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                        for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                            int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                            long maskData = this.getMaskValue(ctrX, ctrY, ctrZ, ctrT);
                            long maskDataSlice = this.getMaskValue(ctrX, ctrY, sliceNum, ctrT);
                            this.undoClipboard.put(maskData);
                            if (isCurrentUsed) {
                                if ((maskDataSlice & selectedMask) != 0L) {
                                    maskData |= (long)(1 << outputColorIndex);
                                }
                            } else {
                                maskData |= maskDataSlice & selectedMask;
                            }
                            this.roiBuffer.putCurrent(offset, maskData);
                        }
                    }
                }
            }
        } else if (sliceDirection == 1) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                for (int ctrY = startSlice; ctrY <= endSlice; ++ctrY) {
                    if (showProgress) {
                        pb.setValue(ctrY - startSlice);
                    }
                    for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                        for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                            int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                            long maskData = this.getMaskValue(ctrX, ctrY, ctrZ, ctrT);
                            long maskDataSlice = this.getMaskValue(ctrX, sliceNum, ctrZ);
                            this.undoClipboard.put(maskData);
                            if (isCurrentUsed) {
                                if ((maskDataSlice & selectedMask) != 0L) {
                                    maskData |= (long)(1 << outputColorIndex);
                                }
                            } else {
                                maskData |= maskDataSlice & selectedMask;
                            }
                            this.roiBuffer.putCurrent(offset, maskData);
                        }
                    }
                }
            }
        } else if (sliceDirection == 2) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                for (int ctrX = startSlice; ctrX <= endSlice; ++ctrX) {
                    if (showProgress) {
                        pb.setValue(ctrX - startSlice);
                    }
                    for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
                        for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                            int offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                            long maskData = this.getMaskValue(ctrX, ctrY, ctrZ, ctrT);
                            long maskDataSlice = this.getMaskValue(sliceNum, ctrY, ctrZ);
                            this.undoClipboard.put(maskData);
                            if (isCurrentUsed) {
                                if ((maskDataSlice & selectedMask) != 0L) {
                                    maskData |= (long)(1 << outputColorIndex);
                                }
                            } else {
                                maskData |= maskDataSlice & selectedMask;
                            }
                            this.roiBuffer.putCurrent(offset, maskData);
                        }
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_PROPAGATED, isCurrentUsed ? this.roiBuffer.getSelected() : MASKS[this.currentROI], -1);
        pb.setValue(pb.getMax());
    }

    private void doPropagateSetShape(int sliceDirection, AffineTransform shapeTrans, AffineTransform screenTrans, int adjustingROI, boolean reset) {
        ImageBounds bounds = this.roiBuffer.getROIBoundsCurrent(this.roiBuffer.getSelected());
        if (bounds == null) {
            return;
        }
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_UPDATE);
        if (sliceDirection == 0) {
            pb.start(zMin, zMin, zMax);
        } else if (sliceDirection == 1) {
            pb.start(yMin, yMin, yMax);
        } else {
            pb.start(xMin, xMin, xMax);
        }
        ROIShape shape = null;
        if (sliceDirection == 0) {
            Rectangle sliceBounds = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
            Rectangle transformedSliceBounds = shapeTrans.createTransformedShape(sliceBounds).getBounds();
            Rectangle unionBounds = sliceBounds.union(transformedSliceBounds).getBounds();
            xMin = Math.max(0, unionBounds.x);
            xMax = Math.min(this.xDim - 2, unionBounds.x + unionBounds.width);
            yMin = Math.max(0, unionBounds.y);
            yMax = Math.min(this.yDim - 2, unionBounds.y + unionBounds.height);
            this.willChangeROI(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), false, sliceDirection, false, !reset);
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                pb.setValue(ctrZ);
                int sliceOffset = this.xDim * this.yDim * ctrZ;
                shape = this.getShape(ctrZ, 0, screenTrans, adjustingROI, false)[adjustingROI];
                shape.setShapeTransform(shapeTrans);
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        int offset = ctrX + offsetY + sliceOffset;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (shape.transformedShapeContains(ctrX, ctrY)) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        } else if (sliceDirection == 1) {
            Rectangle sliceBounds = new Rectangle(xMin, zMin, xMax - xMin + 1, zMax - zMin + 1);
            Rectangle transformedSliceBounds = shapeTrans.createTransformedShape(sliceBounds).getBounds();
            Rectangle unionBounds = sliceBounds.union(transformedSliceBounds).getBounds();
            xMin = Math.max(0, unionBounds.x);
            xMax = Math.min(this.xDim - 2, unionBounds.x + unionBounds.width);
            zMin = Math.max(0, unionBounds.y);
            zMax = Math.min(this.zDim - 2, unionBounds.y + unionBounds.height);
            this.willChangeROI(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), false, sliceDirection, false, !reset);
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                pb.setValue(ctrY);
                int sliceOffset = this.xDim * ctrY;
                shape = this.getShape(ctrY, 1, screenTrans, adjustingROI, false)[adjustingROI];
                shape.setShapeTransform(shapeTrans);
                for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                    int offsetZ = this.xDim * this.yDim * ctrZ;
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        int offset = ctrX + sliceOffset + offsetZ;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (shape.transformedShapeContains(ctrX, ctrZ)) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        } else {
            Rectangle sliceBounds = new Rectangle(yMin, zMin, yMax - yMin + 1, zMax - zMin + 1);
            Rectangle transformedSliceBounds = shapeTrans.createTransformedShape(sliceBounds).getBounds();
            Rectangle unionBounds = sliceBounds.union(transformedSliceBounds).getBounds();
            yMin = Math.max(0, unionBounds.x);
            yMax = Math.min(this.yDim - 2, unionBounds.x + unionBounds.width);
            zMin = Math.max(0, unionBounds.y);
            zMax = Math.min(this.zDim - 2, unionBounds.y + unionBounds.height);
            this.willChangeROI(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax), false, sliceDirection, false, !reset);
            for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                pb.setValue(ctrX);
                shape = this.getShape(ctrX, 2, screenTrans, adjustingROI, false)[adjustingROI];
                shape.setShapeTransform(shapeTrans);
                for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                    int offsetZ = this.xDim * this.yDim * ctrZ;
                    for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                        int offset = ctrX + this.xDim * ctrY + offsetZ;
                        long oldMaskData = this.roiBuffer.getCurrent(offset);
                        this.undoClipboard.put(oldMaskData);
                        if (shape.transformedShapeContains(ctrY, ctrZ)) {
                            this.roiBuffer.putCurrent(offset, oldMaskData | MASKS[adjustingROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offset, oldMaskData & (MASKS[adjustingROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
        }
        shape.setShapeTransform(new AffineTransform());
        this.finishedChangingROI(MESSAGE_SHAPE_EDIT_PROPAGATED, MASKS[adjustingROI], -1);
        this.updateUsedROIs(this.roiBuffer.getSelected());
    }

    private void doReflection(ImageBounds bounds, int sliceDirection, int axis, boolean isVertical) {
        boolean isCurrentUsed = this.isUsed(this.currentROI);
        if (!isCurrentUsed) {
            this.willUseROI(this.currentROI);
        }
        this.willChangeROI(bounds, this.isUsing4dROI(), sliceDirection, false, true);
        boolean showProgressSeries = this.isUsing4dROI();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_REFLECT);
            pb.start(0, 0, bounds.getMaxT());
        } else if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_REFLECT);
            if (sliceDirection == 0) {
                pb.start(0, 0, this.zDim);
            } else if (sliceDirection == 1) {
                pb.start(0, 0, this.yDim);
            } else {
                pb.start(0, 0, this.xDim);
            }
        }
        long[] slice = this.makeLongSliceBuffer(sliceDirection);
        long selectedROIs = this.roiBuffer.getSelected();
        if (sliceDirection == 0) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                for (int ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                    int offset;
                    int offsetX;
                    int ctrX;
                    int offsetY;
                    int ctrY;
                    int offsetZ = this.xDim * this.yDim * ctrZ;
                    if (showProgress) {
                        pb.setValue(ctrZ);
                    }
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        offsetY = ctrY * this.xDim;
                        for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                            int flip;
                            offsetX = ctrX;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            this.undoClipboard.put(oldMaskData);
                            if (isVertical) {
                                flip = axis - ctrX + axis;
                                int offsetReflectionX = flip >= 0 && flip < this.xDim - 1 ? flip : -1;
                                if (offsetReflectionX != -1 && (oldMaskData & selectedROIs) != 0L) {
                                    slice[offsetY + offsetReflectionX] = oldMaskData & selectedROIs;
                                    continue;
                                }
                                if (offsetReflectionX == -1) continue;
                                slice[offsetY + offsetReflectionX] = 0L;
                                continue;
                            }
                            flip = axis - ctrY + axis;
                            int offsetReflectionY = flip >= 0 && flip < this.yDim - 1 ? flip * this.xDim : -1;
                            if (offsetReflectionY != -1 && (oldMaskData & selectedROIs) != 0L) {
                                slice[offsetReflectionY + offsetX] = oldMaskData & selectedROIs;
                                continue;
                            }
                            if (offsetReflectionY == -1) continue;
                            slice[offsetReflectionY + offsetX] = 0L;
                        }
                    }
                    for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                        offsetY = ctrY * this.xDim;
                        for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                            offsetX = ctrX;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            if (slice[offsetY + offsetX] == 0L) continue;
                            if (isCurrentUsed) {
                                this.roiBuffer.put(offset, roiT, oldMaskData | slice[offsetY + offsetX]);
                                continue;
                            }
                            this.roiBuffer.put(offset, roiT, oldMaskData | MASKS[this.currentROI]);
                        }
                    }
                }
            }
        } else if (sliceDirection == 1) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                for (int ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                    int offset;
                    int offsetX;
                    int ctrX;
                    int offsetZ;
                    int ctrZ;
                    int offsetY = this.xDim * ctrY;
                    if (showProgress) {
                        pb.setValue(ctrY);
                    }
                    for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                        offsetZ = ctrZ * this.yDim * this.xDim;
                        for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                            int flip;
                            offsetX = ctrX;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            this.undoClipboard.put(oldMaskData);
                            if (isVertical) {
                                flip = axis - ctrX + axis;
                                int offsetReflectionX = flip >= 0 && flip < this.xDim - 1 ? flip : -1;
                                if (offsetReflectionX != -1 && (oldMaskData & selectedROIs) != 0L) {
                                    slice[ctrZ * this.xDim + offsetReflectionX] = oldMaskData & selectedROIs;
                                    continue;
                                }
                                if (offsetReflectionX == -1) continue;
                                slice[ctrZ * this.xDim + offsetReflectionX] = 0L;
                                continue;
                            }
                            flip = axis - ctrZ + axis;
                            int offsetReflectionZ = flip >= 0 && flip < this.zDim - 1 ? flip * this.xDim : -1;
                            if (offsetReflectionZ != -1 && (oldMaskData & selectedROIs) != 0L) {
                                slice[offsetReflectionZ + offsetX] = oldMaskData & selectedROIs;
                                continue;
                            }
                            if (offsetReflectionZ == -1) continue;
                            slice[offsetReflectionZ + offsetX] = 0L;
                        }
                    }
                    for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                        offsetZ = ctrZ * this.yDim * this.xDim;
                        for (ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                            offsetX = ctrX;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            if (slice[ctrZ * this.xDim + offsetX] == 0L) continue;
                            if (isCurrentUsed) {
                                this.roiBuffer.put(offset, roiT, oldMaskData | slice[ctrZ * this.xDim + offsetX]);
                                continue;
                            }
                            this.roiBuffer.put(offset, roiT, oldMaskData | MASKS[this.currentROI]);
                        }
                    }
                }
            }
        } else if (sliceDirection == 2) {
            for (int ctrT = bounds.getMinT(); ctrT <= bounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                int roiT = this.isUsing4dROI() ? ctrT : 0;
                for (int ctrX = bounds.getMinX(); ctrX <= bounds.getMaxX(); ++ctrX) {
                    int offset;
                    int offsetY;
                    int ctrY;
                    int offsetZ;
                    int ctrZ;
                    int offsetX = ctrX;
                    if (showProgress) {
                        pb.setValue(ctrX);
                    }
                    for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                        offsetZ = ctrZ * this.yDim * this.xDim;
                        for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                            int flip;
                            offsetY = ctrY * this.xDim;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            this.undoClipboard.put(oldMaskData);
                            if (isVertical) {
                                flip = axis - ctrY + axis;
                                int offsetReflectionY = flip >= 0 && flip < this.yDim - 1 ? flip : -1;
                                if (offsetReflectionY != -1 && (oldMaskData & selectedROIs) != 0L) {
                                    slice[ctrZ * this.yDim + offsetReflectionY] = oldMaskData & selectedROIs;
                                    continue;
                                }
                                if (offsetReflectionY == -1) continue;
                                slice[ctrZ * this.yDim + offsetReflectionY] = 0L;
                                continue;
                            }
                            flip = axis - ctrZ + axis;
                            int offsetReflectionZ = flip >= 0 && flip < this.zDim - 1 ? flip * this.yDim : -1;
                            if (offsetReflectionZ != -1 && (oldMaskData & selectedROIs) != 0L) {
                                slice[offsetReflectionZ + ctrY] = oldMaskData & selectedROIs;
                                continue;
                            }
                            if (offsetReflectionZ == -1) continue;
                            slice[offsetReflectionZ + ctrY] = 0L;
                        }
                    }
                    for (ctrZ = bounds.getMinZ(); ctrZ <= bounds.getMaxZ(); ++ctrZ) {
                        offsetZ = ctrZ * this.yDim * this.xDim;
                        for (ctrY = bounds.getMinY(); ctrY <= bounds.getMaxY(); ++ctrY) {
                            offsetY = ctrY * this.xDim;
                            offset = offsetZ + offsetY + offsetX;
                            long oldMaskData = this.roiBuffer.get(offset, roiT);
                            if (slice[ctrZ * this.yDim + ctrY] == 0L) continue;
                            if (isCurrentUsed) {
                                this.roiBuffer.put(offset, roiT, oldMaskData | slice[ctrZ * this.yDim + ctrY]);
                                continue;
                            }
                            this.roiBuffer.put(offset, roiT, oldMaskData | MASKS[this.currentROI]);
                        }
                    }
                }
            }
        }
        this.finishedChangingROI(MESSAGE_REFLECTED, isCurrentUsed ? this.roiBuffer.getSelected() : MASKS[this.currentROI], -1);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private void doSelectedComponentAction3D(Coordinate coordinate, boolean isInValueRange, boolean removeThis, boolean dilate, boolean erode, boolean copy, boolean isSmart, double min, double max) {
        VolumeData volData = new VolumeData(this.user);
        if (isInValueRange) {
            this.willUseROI(this.currentROI);
        }
        IntBuffer storageBuffer = this.workBuffer.asIntBuffer();
        int[] sliceMinusOne = this.axialBuffer;
        int[] slice = this.xyBuffer;
        int[] slicePlusOne = this.axialBuffer2;
        if (!copy) {
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, 0, this.zDim - 2), false, 0);
        }
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_FIND);
        boolean[] contains = null;
        contains = isInValueRange ? this.findSetOfConnectedValues3D(coordinate, isSmart, min, max, pb) : this.findSetOfConnectedLabels3D(coordinate, pb);
        if (copy) {
            this.editClipboard.setCurrentUser((ROIClipboardUser)((Object)this.user));
            this.editClipboard.setCopyMask(MASKS[this.currentROI], this.roiBuffer.getMaximumColors());
            this.editClipboard.setDimensions(this.xDim, this.yDim, this.zDim, 1, this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize());
            this.editClipboard.initializePutting();
            this.roiBuffer.rewind();
            this.editClipboard.setCopyType(1);
        }
        int xLimit = copy ? this.xDim : this.xDim - 1;
        int yLimit = copy ? this.yDim : this.yDim - 1;
        int zLimit = copy ? this.zDim : this.zDim - 1;
        storageBuffer.rewind();
        storageBuffer.get(slice);
        if (dilate) {
            pb.setDescription(PROGRESS_DESCRIPTION_DILATE);
        } else if (erode) {
            pb.setDescription(PROGRESS_DESCRIPTION_ERODE);
        } else if (copy) {
            pb.setDescription(PROGRESS_DESCRIPTION_COPY);
        } else if (isInValueRange) {
            pb.setDescription(PROGRESS_DESCRIPTION_ADD);
        } else if (removeThis) {
            pb.setDescription(PROGRESS_DESCRIPTION_REMOVE);
        } else {
            pb.setDescription(PROGRESS_DESCRIPTION_PRESERVE);
        }
        for (int ctrZ = 0; ctrZ < zLimit; ++ctrZ) {
            pb.setValue(ctrZ);
            int offsetROIZ = this.xDim * this.yDim * ctrZ;
            if (ctrZ < this.zDim - 1) {
                storageBuffer.get(slicePlusOne);
            }
            for (int ctrY = 0; ctrY < yLimit; ++ctrY) {
                int offsetROIY = this.xDim * ctrY;
                for (int ctrX = 0; ctrX < xLimit; ++ctrX) {
                    double current;
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIByteArray = offsetROI + offsetROIZ;
                    long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                    if (!copy) {
                        this.undoClipboard.put(oldMaskData);
                    }
                    if (dilate) {
                        if (isSmart) {
                            current = volData.getValue(ctrX, ctrY, ctrZ);
                            if (contains[slice[offsetROI]]) continue;
                            if (ctrX > 0 && contains[slice[offsetROI - 1]] && current >= min && current <= max) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]] && current >= min && current <= max) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if (ctrY > 0 && contains[slice[offsetROI - this.xDim]] && current >= min && current <= max) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if (ctrY < this.yDim - 1 && contains[slice[offsetROI + this.xDim]] && current >= min && current <= max) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if (ctrZ > 0 && contains[sliceMinusOne[offsetROI]] && current >= min && current <= max) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                                continue;
                            }
                            if (ctrZ >= this.zDim - 1 || !contains[slicePlusOne[offsetROI]] || !(current >= min) || !(current <= max)) continue;
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (contains[slice[offsetROI]]) continue;
                        if (ctrX > 0 && contains[slice[offsetROI - 1]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrY > 0 && contains[slice[offsetROI - this.xDim]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrY < this.yDim - 1 && contains[slice[offsetROI + this.xDim]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ > 0 && contains[sliceMinusOne[offsetROI]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || !contains[slicePlusOne[offsetROI]]) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (erode) {
                        if (isSmart) {
                            current = volData.getValue(ctrX, ctrY, ctrZ);
                            if (!contains[slice[offsetROI]]) continue;
                            if ((ctrX == 0 || ctrY == 0 || ctrZ == 0) && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrX > 0 && !contains[slice[offsetROI - 1]] && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]] && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrY > 0 && !contains[slice[offsetROI - this.xDim]] && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrY < this.yDim - 1 && !contains[slice[offsetROI + this.xDim]] && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrZ > 0 && !contains[sliceMinusOne[offsetROI]] && (current <= min || current >= max)) {
                                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                                continue;
                            }
                            if (ctrZ >= this.zDim - 1 || contains[slicePlusOne[offsetROI]] || !(current <= min) && !(current >= max)) continue;
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (!contains[slice[offsetROI]]) continue;
                        if (ctrX == 0 || ctrY == 0 || ctrZ == 0) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX > 0 && !contains[slice[offsetROI - 1]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY > 0 && !contains[slice[offsetROI - this.xDim]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY < this.yDim - 1 && !contains[slice[offsetROI + this.xDim]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ > 0 && !contains[sliceMinusOne[offsetROI]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || contains[slicePlusOne[offsetROI]]) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (copy) {
                        if (contains[slice[offsetROI]]) {
                            this.editClipboard.put(oldMaskData);
                            continue;
                        }
                        this.editClipboard.put(0L);
                        continue;
                    }
                    if (isInValueRange) {
                        if (contains[slice[offsetROI]]) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData);
                        continue;
                    }
                    if (!removeThis && !contains[slice[offsetROI]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (!removeThis || !contains[slice[offsetROI]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            int[] temp = sliceMinusOne;
            sliceMinusOne = slice;
            slice = slicePlusOne;
            slicePlusOne = temp;
        }
        if (copy) {
            this.editClipboard.finishPutting();
        } else {
            if (dilate) {
                this.finishedChangingROI(MESSAGE_DILATED, MASKS[this.currentROI], -1);
            } else if (erode) {
                this.finishedChangingROI(MESSAGE_ERODED, MASKS[this.currentROI], -1);
            } else if (isInValueRange) {
                this.finishedChangingROI(MESSAGE_ADDED, MASKS[this.currentROI], -1);
            } else if (removeThis) {
                this.finishedChangingROI(MESSAGE_REMOVED, MASKS[this.currentROI], -1);
            } else {
                this.finishedChangingROI(MESSAGE_PRESERVED, MASKS[this.currentROI], -1);
            }
            this.updateUsedROIs(this.roiBuffer.getSelected());
        }
        pb.setValue(pb.getMax());
    }

    private void doUndoROI() {
        int ctr;
        int ctrZ;
        long currentByte;
        int offset;
        int ctrX;
        int tLoc;
        int ctrT;
        ROIClipboard gettingClipboard;
        ROIClipboard puttingClipboard;
        boolean isSeriesUndo;
        this.setDirty(true);
        this.editingDisabled = true;
        boolean showProgressSeries = isSeriesUndo = this.undoBounds.getMinT() != this.undoBounds.getMaxT();
        boolean showProgress = !showProgressSeries && this.needsProgressMeter();
        ProgressMeter pb = null;
        if (showProgress) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_UNDO);
            if (this.undoDirection == 0) {
                pb.start(0, 0, this.zDim);
            } else if (this.undoDirection == 1) {
                pb.start(0, 0, this.yDim);
            } else {
                pb.start(0, 0, this.xDim);
            }
        } else if (showProgressSeries) {
            pb = this.user.makeProgressMeter();
            pb.setDescription(PROGRESS_DESCRIPTION_UNDO);
            pb.start(0, 0, this.undoBounds.getMaxT());
        }
        this.updateROIBufferSeries(isSeriesUndo || this.isUsing4dROI());
        if (this.hasUndo) {
            puttingClipboard = this.redoClipboard;
            gettingClipboard = this.undoClipboard;
        } else {
            puttingClipboard = this.undoClipboard;
            gettingClipboard = this.redoClipboard;
        }
        gettingClipboard.initializeGetting();
        puttingClipboard.initializePutting();
        this.hasRedo = this.hasUndo;
        this.hasUndo = !this.hasUndo;
        long found = 0L;
        if (this.undoDirection == 0) {
            for (ctrT = this.undoBounds.getMinT(); ctrT <= this.undoBounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                tLoc = isSeriesUndo ? ctrT : (this.isUsing4dROI() ? this.undoBounds.getMaxT() : 0);
                for (int ctrZ2 = this.undoBounds.getMinZ(); ctrZ2 <= this.undoBounds.getMaxZ(); ++ctrZ2) {
                    if (showProgress) {
                        pb.setValue(ctrZ2);
                    }
                    for (int ctrY = this.undoBounds.getMinY(); ctrY <= this.undoBounds.getMaxY(); ++ctrY) {
                        for (ctrX = this.undoBounds.getMinX(); ctrX <= this.undoBounds.getMaxX(); ++ctrX) {
                            offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ2);
                            puttingClipboard.put(this.roiBuffer.get(offset, tLoc));
                            currentByte = gettingClipboard.get();
                            found |= currentByte;
                            this.roiBuffer.put(offset, tLoc, currentByte);
                        }
                    }
                }
            }
        } else if (this.undoDirection == 1) {
            for (ctrT = this.undoBounds.getMinT(); ctrT <= this.undoBounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                tLoc = isSeriesUndo ? ctrT : (this.isUsing4dROI() ? this.undoBounds.getMaxT() : 0);
                for (int ctrY = this.undoBounds.getMinY(); ctrY <= this.undoBounds.getMaxY(); ++ctrY) {
                    if (showProgress) {
                        pb.setValue(ctrY);
                    }
                    for (ctrZ = this.undoBounds.getMinZ(); ctrZ <= this.undoBounds.getMaxZ(); ++ctrZ) {
                        for (ctrX = this.undoBounds.getMinX(); ctrX <= this.undoBounds.getMaxX(); ++ctrX) {
                            offset = ctrX + this.xDim * (ctrY + this.yDim * ctrZ);
                            puttingClipboard.put(this.roiBuffer.get(offset, tLoc));
                            currentByte = gettingClipboard.get();
                            found |= currentByte;
                            this.roiBuffer.put(offset, tLoc, currentByte);
                        }
                    }
                }
            }
        } else if (this.undoDirection == 2) {
            for (ctrT = this.undoBounds.getMinT(); ctrT <= this.undoBounds.getMaxT(); ++ctrT) {
                if (showProgressSeries) {
                    pb.setValue(ctrT);
                }
                tLoc = isSeriesUndo ? ctrT : (this.isUsing4dROI() ? this.undoBounds.getMaxT() : 0);
                for (int ctrX2 = this.undoBounds.getMinX(); ctrX2 <= this.undoBounds.getMaxX(); ++ctrX2) {
                    if (showProgress) {
                        pb.setValue(ctrX2);
                    }
                    for (ctrZ = this.undoBounds.getMinZ(); ctrZ <= this.undoBounds.getMaxZ(); ++ctrZ) {
                        for (int ctrY = this.undoBounds.getMinY(); ctrY <= this.undoBounds.getMaxY(); ++ctrY) {
                            offset = ctrX2 + this.xDim * (ctrY + this.yDim * ctrZ);
                            puttingClipboard.put(this.roiBuffer.get(offset, tLoc));
                            currentByte = gettingClipboard.get();
                            found |= currentByte;
                            this.roiBuffer.put(offset, tLoc, currentByte);
                        }
                    }
                }
            }
        }
        gettingClipboard.finishGetting();
        puttingClipboard.finishPutting();
        String[] undoLabels = gettingClipboard.getLabels();
        if (undoLabels != null) {
            puttingClipboard.setLabels(this.labels.getLabelModelCopy());
            for (ctr = 0; ctr < undoLabels.length; ++ctr) {
                this.labels.setLabel(ctr, undoLabels[ctr]);
            }
            gettingClipboard.setLabels(null);
        }
        this.finishedChangingROI(MESSAGE_UNDONE, true, found, -1);
        this.deselectAll(true);
        for (ctr = 0; ctr < 64; ++ctr) {
            if ((found & 1L << ctr) == 0L) continue;
            this.willUseROI(ctr);
        }
        this.updateUsedROIs(this.getUsedMask() | found);
        if (showProgress || showProgressSeries) {
            pb.setValue(pb.getMax());
        }
    }

    private int findComponentMap(double min, boolean isNegative, IntBuffer storageBuffer, EquivalentSetManager equivSetManager, ImageData volData) {
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] sliceUpper = this.xyBuffer;
        int[] slice = this.axialBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
            sliceUpper[ctr] = 0;
        }
        ProgressMeter pb = this.user.makeProgressMeter();
        pb.setDescription(PROGRESS_DESCRIPTION_FIND_CLUSTERS);
        pb.start(0, 0, this.zDim);
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            pb.setValue(ctrZ);
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROIY = this.xDim * ctrY;
                int offsetROIYMinusY = this.xDim * (ctrY - 1);
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    double current = volData.getValue(ctrX, ctrY, ctrZ);
                    if ((isNegative && current <= min || !isNegative && current >= min) && current != 0.0) {
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] != slice[offsetROIMinusY]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            }
                            if (slice[offsetROIMinusX] != sliceUpper[offsetROI]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            }
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        if (ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = sliceUpper[offsetROI];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        equivSetManager.incrementSetMap();
                        slice[offsetROI] = ++componentCtr;
                        equivSetManager.count(slice[offsetROI]);
                        equivSetManager.addPair(componentCtr, componentCtr);
                        continue;
                    }
                    slice[offsetROI] = 0;
                }
            }
            storageBuffer.put(slice, 0, slice.length);
            int[] temp = sliceUpper;
            sliceUpper = slice;
            slice = temp;
        }
        pb.setValue(pb.getMax());
        return componentCtr;
    }

    private boolean[] findSetOfConnectedLabels3D(Coordinate coor, ProgressMeter pb) {
        IntBuffer storageBuffer = this.workBuffer.asIntBuffer();
        EquivalentSetManager equivSetManager = new EquivalentSetManager(true);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] sliceUpper = this.xyBuffer;
        int[] slice = this.axialBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
            sliceUpper[ctr] = 0;
        }
        pb.start(0, 0, this.zDim);
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            int offsetROIZ = this.xDim * this.yDim * ctrZ;
            pb.setValue(ctrZ);
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROIY = this.xDim * ctrY;
                int offsetROIYMinusY = this.xDim * (ctrY - 1);
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    if ((this.roiBuffer.getCurrent(offsetROI + offsetROIZ) & MASKS[this.currentROI]) != 0L) {
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] != slice[offsetROIMinusY]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            }
                            if (slice[offsetROIMinusX] != sliceUpper[offsetROI]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            }
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            continue;
                        }
                        if (ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = sliceUpper[offsetROI];
                            continue;
                        }
                        equivSetManager.incrementSetMap();
                        slice[offsetROI] = ++componentCtr;
                        equivSetManager.addPair(slice[offsetROI], slice[offsetROI]);
                        continue;
                    }
                    slice[offsetROI] = 0;
                }
            }
            storageBuffer.put(slice, 0, slice.length);
            int[] temp = sliceUpper;
            sliceUpper = slice;
            slice = temp;
        }
        int seed = storageBuffer.get(coor.xInt + coor.yInt * this.xDim + coor.zInt * this.xDim * this.yDim);
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        return contains;
    }

    private boolean[] findSetOfConnectedLabelsShrinkWrap3D(double thresholdMinVal, double thresholdMaxVal, ImageBounds bounds, ProgressMeter pb, boolean excludeZero, boolean[] foundData, boolean isDynamicThreshold, boolean within, long withinMask) {
        VolumeData volData = new VolumeData(this.user);
        double thresholdMin = thresholdMinVal;
        double thresholdMax = thresholdMaxVal;
        double thresholdMinPercentMax = thresholdMin;
        double thresholdMaxPercentMax = thresholdMax;
        if (isDynamicThreshold) {
            volData.findVolumeRange(bounds.getMinT());
            thresholdMin = volData.getMax() * (thresholdMinPercentMax / 100.0);
            thresholdMax = volData.getMax() * (thresholdMaxPercentMax / 100.0);
        }
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(1);
        int componentCtr = 1;
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        IntBuffer storageBuffer = this.workBuffer.asIntBuffer();
        int[] sliceUpper = this.xyBuffer;
        int[] slice = this.axialBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
            sliceUpper[ctr] = 0;
        }
        if (pb != null) {
            pb.start(0, 0, this.zDim);
        }
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            if (pb != null) {
                pb.setValue(ctrZ);
            }
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROIY = this.xDim * ctrY;
                int offsetROIYMinusY = this.xDim * (ctrY - 1);
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    boolean outside;
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    double current = volData.getValue(ctrX, ctrY, ctrZ, bounds.getMinT());
                    boolean bl = outside = current < thresholdMin || current > thresholdMax || excludeZero && current == 0.0;
                    if (within) {
                        long currentROI = this.getMaskValue(ctrX, ctrY, ctrZ, bounds.getMinT());
                        outside |= (currentROI & withinMask) == 0L;
                    }
                    if (outside) {
                        if (ctrX <= xMin || ctrY <= yMin || ctrZ <= zMin || ctrX > xMax || ctrY > yMax || ctrZ > zMax) {
                            slice[offsetROI] = 1;
                            continue;
                        }
                        if (ctrX == xMax) {
                            slice[offsetROI] = 1;
                            if (slice[offsetROIMinusX] == slice[offsetROI] || slice[offsetROIMinusX] == 0) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROI]);
                            continue;
                        }
                        if (ctrY == yMax) {
                            slice[offsetROI] = 1;
                            if (slice[offsetROIMinusY] == slice[offsetROI] || slice[offsetROIMinusY] == 0) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROI]);
                            continue;
                        }
                        if (ctrZ == zMax) {
                            slice[offsetROI] = 1;
                            if (sliceUpper[offsetROI] == slice[offsetROI] || sliceUpper[offsetROI] == 0) continue;
                            equivSetManager.addPair(sliceUpper[offsetROI], slice[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] != slice[offsetROIMinusY]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            }
                            if (slice[offsetROIMinusX] != sliceUpper[offsetROI]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            }
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            continue;
                        }
                        if (ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = sliceUpper[offsetROI];
                            continue;
                        }
                        equivSetManager.incrementSetMap();
                        slice[offsetROI] = ++componentCtr;
                        continue;
                    }
                    slice[offsetROI] = 0;
                    foundData[0] = true;
                }
            }
            storageBuffer.put(slice, 0, slice.length);
            int[] temp = sliceUpper;
            sliceUpper = slice;
            slice = temp;
        }
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, 1);
        return contains;
    }

    private boolean[] findSetOfConnectedValues3D(Coordinate coor, boolean isSmart, double min, double max, ProgressMeter pb) {
        VolumeData volData = new VolumeData(this.user);
        IntBuffer storageBuffer = this.workBuffer.asIntBuffer();
        double coorValue = volData.getValue(coor.xInt, coor.yInt, coor.zInt);
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] sliceUpper = this.xyBuffer;
        int[] slice = this.axialBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
            sliceUpper[ctr] = 0;
        }
        pb.start(0, 0, this.zDim);
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            pb.setValue(ctrZ);
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROIY = this.xDim * ctrY;
                int offsetROIYMinusY = this.xDim * (ctrY - 1);
                for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    double current = volData.getValue(ctrX, ctrY, ctrZ);
                    if (!isSmart && current == coorValue || isSmart && current >= min && current <= max) {
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] != slice[offsetROIMinusY]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            }
                            if (slice[offsetROIMinusX] != sliceUpper[offsetROI]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            }
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusX] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            equivSetManager.count(slice[offsetROI]);
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        if (ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = sliceUpper[offsetROI];
                            equivSetManager.count(slice[offsetROI]);
                            continue;
                        }
                        equivSetManager.incrementSetMap();
                        slice[offsetROI] = ++componentCtr;
                        equivSetManager.count(slice[offsetROI]);
                        equivSetManager.addPair(componentCtr, componentCtr);
                        continue;
                    }
                    slice[offsetROI] = 0;
                }
            }
            storageBuffer.put(slice, 0, slice.length);
            int[] temp = sliceUpper;
            sliceUpper = slice;
            slice = temp;
        }
        int seed = storageBuffer.get(coor.xInt + coor.yInt * this.xDim + coor.zInt * this.xDim * this.yDim);
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        return contains;
    }

    private void finishedChangingROI(String message, long changedMask, int changedSlice) {
        this.finishedChangingROI(message, false, changedMask, changedSlice);
    }

    private void finishedChangingROI(String message, boolean skipClipboard, long changedMask, int changedSlice) {
        this.editingDisabled = false;
        if (changedMask > 0L) {
            if (this.listener != null) {
                this.listener.roiHasChanged(this.rois[BitUtilities.findHighestOneBitIndex((long)changedMask)], message, changedMask, changedSlice);
            }
        } else if (this.listener != null) {
            this.listener.roiHasChanged(this.rois[this.currentROI], message, changedMask, changedSlice);
        }
        if (!skipClipboard) {
            this.undoClipboard.finishPutting();
        }
    }

    private long getMaskInRange(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        long maskInRange = 0L;
        long usedROIs = this.roiBuffer.getUsed();
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            int offsetZ = this.xDim * this.yDim * ctrZ;
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                int offsetY = this.xDim * ctrY;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    if ((maskInRange |= this.roiBuffer.getCurrent(ctrX + offsetY + offsetZ)) != usedROIs) continue;
                    return usedROIs;
                }
            }
        }
        return maskInRange;
    }

    private int[] getResetSliceBuffer(int direction) {
        int[] slice = null;
        if (direction == 0) {
            slice = this.xyBuffer;
        } else if (direction == 1) {
            slice = this.xzBuffer;
        } else if (direction == 2) {
            slice = this.yzBuffer;
        }
        if (slice != null) {
            for (int ctr = 0; ctr < slice.length; ++ctr) {
                slice[ctr] = 0;
            }
        }
        return slice;
    }

    private Vector<Integer> getUsedIndices(boolean currentLast, boolean currentFirst) {
        Vector<Integer> indices = new Vector<Integer>();
        long usedROIs = this.roiBuffer.getUsed();
        boolean currentUsed = false;
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((usedROIs & 1L << ctr) == 0L) continue;
            if (ctr == this.currentROI) {
                if (currentLast || currentFirst) {
                    currentUsed = true;
                    continue;
                }
                indices.add(ctr);
                continue;
            }
            indices.add(ctr);
        }
        if (currentUsed) {
            if (currentLast) {
                indices.add(this.currentROI);
            } else if (currentFirst) {
                indices.insertElementAt(this.currentROI, 0);
            }
        }
        return indices;
    }

    private void increaseColors(int numColors) {
        if (numColors > this.roiBuffer.getMaximumColors()) {
            if (numColors == 16) {
                this.increaseColors();
            } else if (numColors == 32) {
                if (this.roiBuffer.getMaximumColors() == 8) {
                    ROIIntBuffer intBuffer = this.roiBuffer.hasBuffer() ? new ROIIntBuffer((ROIByteBuffer)this.roiBuffer) : new ROIIntBuffer(this.xDim, this.yDim, this.zDim);
                    this.colorsWillChange(32);
                    this.roiBuffer = intBuffer;
                } else if (this.roiBuffer.getMaximumColors() == 16) {
                    this.increaseColors();
                }
            } else if (numColors == 64) {
                if (this.roiBuffer.getMaximumColors() == 8) {
                    ROILongBuffer longBuffer = this.roiBuffer.hasBuffer() ? new ROILongBuffer((ROIByteBuffer)this.roiBuffer) : new ROILongBuffer(this.xDim, this.yDim, this.zDim);
                    this.colorsWillChange(64);
                    this.roiBuffer = longBuffer;
                } else if (this.roiBuffer.getMaximumColors() == 16) {
                    ROILongBuffer longBuffer = this.roiBuffer.hasBuffer() ? new ROILongBuffer((ROIShortBuffer)this.roiBuffer) : new ROILongBuffer(this.xDim, this.yDim, this.zDim);
                    this.colorsWillChange(64);
                    this.roiBuffer = longBuffer;
                } else {
                    this.increaseColors();
                }
            }
            if (this.listener != null) {
                this.listener.willAddMoreROIColors(numColors);
            }
        }
    }

    private void makeAxialPath(int xLoc, int yLoc, int roiID, boolean surface) {
        int offset = xLoc + this.xDim * yLoc;
        int offsetMinusX = offset - 1;
        int offsetPlusX = offset + 1;
        int offsetMinusY = offset - this.xDim;
        int offsetPlusY = offset + this.xDim;
        byte[][] data = null;
        data = surface ? this.axialROIShapeDataSurface : this.axialROIShapeData;
        if (xLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (yLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (xLoc > 0 && (data[roiID][offsetMinusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (xLoc < this.xDim - 1 && (data[roiID][offsetPlusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusX;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (yLoc > 0 && (data[roiID][offsetMinusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (yLoc < this.yDim - 1 && (data[roiID][offsetPlusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusY;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
    }

    private void makeCoronalPath(int xLoc, int zLoc, int roiID, boolean surface) {
        int offset = xLoc + this.xDim * zLoc;
        int offsetMinusX = offset - 1;
        int offsetPlusX = offset + 1;
        int offsetMinusY = offset - this.xDim;
        int offsetPlusY = offset + this.xDim;
        byte[][] data = null;
        data = surface ? this.coronalROIShapeDataSurface : this.coronalROIShapeData;
        if (xLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (zLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (xLoc > 0 && (data[roiID][offsetMinusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (xLoc < this.xDim - 1 && (data[roiID][offsetPlusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusX;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (zLoc > 0 && (data[roiID][offsetMinusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (zLoc < this.zDim - 1 && (data[roiID][offsetPlusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusY;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
    }

    private long[] makeLongSliceBuffer(int direction) {
        long[] slice = null;
        if (direction == 0) {
            slice = new long[this.xyBuffer.length];
        } else if (direction == 1) {
            slice = new long[this.xzBuffer.length];
        } else if (direction == 2) {
            slice = new long[this.yzBuffer.length];
        }
        return slice;
    }

    private void makeSagittalPath(int yLoc, int zLoc, int roiID, boolean surface) {
        int offset = yLoc + this.yDim * zLoc;
        int offsetMinusX = offset - 1;
        int offsetPlusX = offset + 1;
        int offsetMinusY = offset - this.yDim;
        int offsetPlusY = offset + this.yDim;
        byte[][] data = null;
        data = surface ? this.sagittalROIShapeDataSurface : this.sagittalROIShapeData;
        if (yLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (zLoc == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (yLoc > 0 && (data[roiID][offsetMinusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (yLoc < this.yDim - 1 && (data[roiID][offsetPlusX] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusX;
            byArray[n] = (byte)(byArray[n] | 0xFFFFFF80);
        }
        if (zLoc > 0 && (data[roiID][offsetMinusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offset;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
        if (zLoc < this.zDim - 1 && (data[roiID][offsetPlusY] & 0x10) == 0) {
            byte[] byArray = data[roiID];
            int n = offsetPlusY;
            byArray[n] = (byte)(byArray[n] | 0x40);
        }
    }

    private boolean needsProgressMeter() {
        return this.undoBounds != null && !this.undoBounds.isSingleSlice();
    }

    private void operationROI(final ROIOperationTreeNode op, final ImageBounds bounds) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doOperationROI(op, bounds);
            }
        }, "ROIManager.operationROI() Thread");
        workThread.start();
    }

    private void pasteSeries() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doPasteSeries();
            }
        }, "ROIManager.pasteSeries() Thread");
        workThread.start();
    }

    private void pasteSlice() {
        this.editClipboard.initializeGetting();
        int pastedX = this.editClipboard.getX();
        int pastedY = this.editClipboard.getY();
        double pastedXSize = this.editClipboard.getXSize();
        double pastedYSize = this.editClipboard.getYSize();
        int sliceDirection = this.user.getSliceDirection();
        int xMin = 0;
        int yMin = 0;
        int zMin = 0;
        int xMax = this.xDim - 1;
        int yMax = this.yDim - 1;
        int zMax = this.zDim - 1;
        long copyMask = this.editClipboard.getCopyMask();
        boolean isCopyMultiSelected = this.editClipboard.isMultiSelectionCopied();
        long currentColorPasteMask = MASKS[this.currentROI];
        this.increaseColors(this.editClipboard.getCopyMaskMaxColors());
        if (isCopyMultiSelected) {
            for (int ctr = 0; ctr < this.roiBuffer.getMaximumColors(); ++ctr) {
                if ((copyMask >> ctr & 1L) != 1L) continue;
                this.willUseROI(ctr);
            }
        } else {
            this.willUseROI(this.currentROI);
        }
        long pastedMask = 0L;
        if (sliceDirection == 0) {
            zMin = zMax = this.user.getSliceNumber();
            double thisXSize = this.user.getBaseVolume().getXSize();
            double thisYSize = this.user.getBaseVolume().getYSize();
            double xRatio = thisXSize / pastedXSize;
            double yRatio = thisYSize / pastedYSize;
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, zMin, zMax), this.isUsing4dROI(), sliceDirection);
            byte[] pasteBuffer = this.editClipboard.makePasteBuffer(pastedX * pastedY);
            this.editClipboard.get(pasteBuffer);
            for (int ctrY = yMin; ctrY < this.yDim - 1; ++ctrY) {
                for (int ctrX = xMin; ctrX < this.xDim - 1; ++ctrX) {
                    long pasteMask;
                    int offset = ctrX + this.xDim * ctrY + this.xDim * this.yDim * zMin;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    int pasteIndexY = (int)((double)ctrY * yRatio);
                    int pasteIndexX = (int)((double)ctrX * xRatio);
                    if (pasteIndexX < pastedX && pasteIndexY < pastedY) {
                        pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                        pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                    } else {
                        pasteMask = 0L;
                    }
                    pastedMask |= pasteMask;
                    this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                }
            }
        } else if (sliceDirection == 1) {
            yMin = yMax = this.user.getSliceNumber();
            double thisXSize = this.user.getBaseVolume().getXSize();
            double thisYSize = this.user.getBaseVolume().getZSize();
            double xRatio = thisXSize / pastedXSize;
            double yRatio = thisYSize / pastedYSize;
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, yMin, yMax, 0, this.zDim - 2), this.isUsing4dROI(), sliceDirection);
            byte[] pasteBuffer = this.editClipboard.makePasteBuffer(pastedX * pastedY);
            this.editClipboard.get(pasteBuffer);
            for (int ctrZ = zMin; ctrZ < this.zDim - 1; ++ctrZ) {
                for (int ctrX = xMin; ctrX < this.xDim - 1; ++ctrX) {
                    long pasteMask;
                    int offset = ctrX + this.xDim * yMin + this.xDim * this.yDim * ctrZ;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    int pasteIndexY = (int)((double)ctrZ * yRatio);
                    int pasteIndexX = (int)((double)ctrX * xRatio);
                    if (pasteIndexX < pastedX && pasteIndexY < pastedY) {
                        pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                        pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                    } else {
                        pasteMask = 0L;
                    }
                    pastedMask |= pasteMask;
                    this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                }
            }
        } else if (sliceDirection == 2) {
            xMin = xMax = this.user.getSliceNumber();
            double thisXSize = this.user.getBaseVolume().getYSize();
            double thisYSize = this.user.getBaseVolume().getZSize();
            double xRatio = thisXSize / pastedXSize;
            double yRatio = thisYSize / pastedYSize;
            this.willChangeROI(new ImageBounds(xMin, xMax, 0, this.yDim - 2, 0, this.zDim - 2), this.isUsing4dROI(), sliceDirection);
            byte[] pasteBuffer = this.editClipboard.makePasteBuffer(pastedX * pastedY);
            this.editClipboard.get(pasteBuffer);
            for (int ctrZ = zMin; ctrZ < this.zDim - 1; ++ctrZ) {
                for (int ctrY = yMin; ctrY < this.yDim - 1; ++ctrY) {
                    long pasteMask;
                    int offset = xMin + this.xDim * ctrY + this.xDim * this.yDim * ctrZ;
                    long oldMaskData = this.roiBuffer.getCurrent(offset);
                    this.undoClipboard.put(oldMaskData);
                    int pasteIndexY = (int)((double)ctrZ * yRatio);
                    int pasteIndexX = (int)((double)ctrY * xRatio);
                    if (pasteIndexX < pastedX && pasteIndexY < pastedY) {
                        pasteMask = this.editClipboard.getPasteValue(pasteIndexY * pastedX + pasteIndexX);
                        pasteMask = isCopyMultiSelected ? (pasteMask &= copyMask) : ((pasteMask & copyMask) != 0L ? currentColorPasteMask : 0L);
                    } else {
                        pasteMask = 0L;
                    }
                    pastedMask |= pasteMask;
                    this.roiBuffer.putCurrent(offset, oldMaskData | pasteMask);
                }
            }
        }
        this.editClipboard.finishGetting();
        this.finishedChangingROI(MESSAGE_PASTED, pastedMask, -1);
        this.deselectAll();
    }

    private void pasteVolume() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doPasteVolume();
            }
        }, "ROIManager.pasteVolume() Thread");
        workThread.start();
    }

    private void reflect(final ImageBounds bounds, final int direction, final int axis, final boolean isVertical) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doReflection(bounds, direction, axis, isVertical);
            }
        }, "ROIManager.reflect() Thread");
        workThread.start();
    }

    private ImageBounds selectedComponentAction2D(Point startPoint, int sliceDirection, int sliceNum, boolean removeThis, boolean dilate, boolean erode, boolean copy, boolean isRange, boolean isSmart, double min, double max) {
        if (sliceDirection == 0) {
            return this.selectedComponentAction2DAxial(startPoint, sliceDirection, sliceNum, removeThis, dilate, erode, copy, isRange, isSmart, min, max);
        }
        if (sliceDirection == 1) {
            return this.selectedComponentAction2DCoronal(startPoint, sliceDirection, sliceNum, removeThis, dilate, erode, copy, isRange, isSmart, min, max);
        }
        return this.selectedComponentAction2DSagittal(startPoint, sliceDirection, sliceNum, removeThis, dilate, erode, copy, isRange, isSmart, min, max);
    }

    private ImageBounds selectedComponentAction2DAxial(Point startPoint, int sliceDirection, int sliceNum, boolean removeThis, boolean dilate, boolean erode, boolean copy, boolean isRange, boolean isSmart, double min, double max) {
        if ((this.roiBuffer.getCurrent(startPoint.x + this.xDim * startPoint.y + this.xDim * this.yDim * sliceNum) & MASKS[this.currentROI]) == 0L) {
            return null;
        }
        if (!copy && !isRange) {
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, sliceNum, sliceNum), false, sliceDirection);
        }
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.xyBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        int offsetROIZ = this.xDim * this.yDim * sliceNum;
        for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
            int offsetROIY = this.xDim * ctrY;
            int offsetROIYMinusY = this.xDim * (ctrY - 1);
            for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                int offsetROI = ctrX + offsetROIY;
                int offsetROIMinusX = ctrX - 1 + offsetROIY;
                int offsetROIMinusY = ctrX + offsetROIYMinusY;
                slice[offsetROI] = 0;
                if ((this.roiBuffer.getCurrent(ctrX + this.xDim * ctrY + this.xDim * this.yDim * sliceNum) & MASKS[this.currentROI]) == 0L) continue;
                if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (ctrY == 0 || slice[offsetROIMinusY] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (ctrX == 0 || slice[offsetROIMinusX] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
                equivSetManager.addPair(slice[offsetROI], slice[offsetROI]);
            }
        }
        int seed = slice[startPoint.x + this.xDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        if (copy) {
            this.editClipboard.setCurrentUser((ROIClipboardUser)((Object)this.user));
            this.editClipboard.setCopyMask(MASKS[this.currentROI], this.roiBuffer.getMaximumColors());
            this.editClipboard.setDimensions(this.xDim, this.yDim, this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getYSize());
            this.editClipboard.initializePutting();
            this.roiBuffer.rewind();
            this.editClipboard.setCopyType(0);
        }
        int xLimit = copy ? this.xDim : this.xDim - 1;
        int yLimit = copy ? this.yDim : this.yDim - 1;
        int rangeXmin = this.xDim;
        int rangeXmax = 0;
        int rangeYmin = this.yDim;
        int rangeYmax = 0;
        VolumeData volData = new VolumeData(this.user);
        ImageBounds ib = null;
        for (int ctrY = 0; ctrY < yLimit; ++ctrY) {
            int offsetROIY = this.xDim * ctrY;
            for (int ctrX = 0; ctrX < xLimit; ++ctrX) {
                double current;
                int offsetROI = ctrX + offsetROIY;
                int offsetROIByteArray = offsetROI + offsetROIZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (!copy && !isRange) {
                    this.undoClipboard.put(oldMaskData);
                }
                if (dilate) {
                    if (isSmart) {
                        current = volData.getValue(ctrX, ctrY, sliceNum);
                        if (contains[slice[offsetROI]]) continue;
                        if (ctrX > 0 && contains[slice[offsetROI - 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrY > 0 && contains[slice[offsetROI - this.xDim]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrY >= this.yDim - 1 || !contains[slice[offsetROI + this.xDim]] || !(current >= min) || !(current <= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (contains[slice[offsetROI]]) continue;
                    if (ctrX > 0 && contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrY > 0 && contains[slice[offsetROI - this.xDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrY >= this.yDim - 1 || !contains[slice[offsetROI + this.xDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                if (erode) {
                    if (isSmart) {
                        current = volData.getValue(ctrX, ctrY, sliceNum);
                        if (!contains[slice[offsetROI]]) continue;
                        if ((ctrX == 0 || ctrY == 0) && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX > 0 && !contains[slice[offsetROI - 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY > 0 && !contains[slice[offsetROI - this.xDim]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY >= this.yDim - 1 || contains[slice[offsetROI + this.xDim]] || !(current <= min) && !(current >= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrX == 0 || ctrY == 0) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrX > 0 && !contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrY > 0 && !contains[slice[offsetROI - this.xDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrY >= this.yDim - 1 || contains[slice[offsetROI + this.xDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (copy) {
                    if (contains[slice[offsetROI]]) {
                        this.editClipboard.put(oldMaskData);
                        continue;
                    }
                    this.editClipboard.put(0L);
                    continue;
                }
                if (isRange) {
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrX < rangeXmin) {
                        rangeXmin = ctrX;
                    }
                    if (ctrX > rangeXmax) {
                        rangeXmax = ctrX;
                    }
                    if (ctrY < rangeYmin) {
                        rangeYmin = ctrY;
                    }
                    if (ctrY <= rangeYmax) continue;
                    rangeYmax = ctrY;
                    continue;
                }
                if (!removeThis && !contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (!removeThis || !contains[slice[offsetROI]]) continue;
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (copy) {
            this.editClipboard.finishPutting();
        } else {
            if (dilate) {
                this.finishedChangingROI(MESSAGE_DILATED, MASKS[this.currentROI], -1);
            } else if (erode) {
                this.finishedChangingROI(MESSAGE_ERODED, MASKS[this.currentROI], -1);
            } else if (removeThis) {
                this.finishedChangingROI(MESSAGE_REMOVED, MASKS[this.currentROI], -1);
            } else {
                this.finishedChangingROI(MESSAGE_PRESERVED, MASKS[this.currentROI], -1);
            }
            this.updateUsedROIs(this.roiBuffer.getSelected());
        }
        if (isRange) {
            ib = new ImageBounds(rangeXmin, rangeXmax, rangeYmin, rangeYmax, sliceNum, sliceNum);
        }
        return ib;
    }

    private ImageBounds selectedComponentAction2DCoronal(Point startPoint, int sliceDirection, int sliceNum, boolean removeThis, boolean dilate, boolean erode, boolean copy, boolean isRange, boolean isSmart, double min, double max) {
        if ((this.roiBuffer.getCurrent(startPoint.x + this.xDim * sliceNum + this.xDim * this.yDim * startPoint.y) & MASKS[this.currentROI]) == 0L) {
            return null;
        }
        if (!copy && !isRange) {
            this.willChangeROI(new ImageBounds(0, this.xDim - 2, sliceNum, sliceNum, 0, this.zDim - 2), false, sliceDirection);
        }
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.xzBuffer;
        for (int ctr = 0; ctr < this.xzBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        int offsetROIY = sliceNum * this.xDim;
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            int offsetROIZ = ctrZ * this.xDim;
            int offsetROIZMinusZ = (ctrZ - 1) * this.xDim;
            for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                int offsetROI = ctrX + offsetROIZ;
                int offsetROIMinusX = ctrX - 1 + offsetROIZ;
                int offsetROIMinusZ = ctrX + offsetROIZMinusZ;
                slice[offsetROI] = 0;
                if ((this.roiBuffer.getCurrent(ctrX + this.xDim * sliceNum + this.xDim * this.yDim * ctrZ) & MASKS[this.currentROI]) == 0L) continue;
                if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (ctrZ == 0 || slice[offsetROIMinusZ] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusZ];
                    if (ctrX == 0 || slice[offsetROIMinusX] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
                equivSetManager.addPair(slice[offsetROI], slice[offsetROI]);
            }
        }
        int seed = slice[startPoint.x + this.xDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        if (copy) {
            this.editClipboard.setCurrentUser((ROIClipboardUser)((Object)this.user));
            this.editClipboard.setCopyMask(MASKS[this.currentROI], this.roiBuffer.getMaximumColors());
            this.editClipboard.setDimensions(this.xDim, this.zDim, this.user.getBaseVolume().getXSize(), this.user.getBaseVolume().getZSize());
            this.editClipboard.initializePutting();
            this.roiBuffer.rewind();
            this.editClipboard.setCopyType(0);
        }
        int xLimit = copy ? this.xDim : this.xDim - 1;
        int zLimit = copy ? this.zDim : this.zDim - 1;
        int rangeXmin = this.xDim;
        int rangeXmax = 0;
        int rangeZmin = this.zDim;
        int rangeZmax = 0;
        VolumeData volData = new VolumeData(this.user);
        ImageBounds ib = null;
        for (int ctrZ = 0; ctrZ < zLimit; ++ctrZ) {
            int offsetROIZ = this.xDim * ctrZ;
            int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
            for (int ctrX = 0; ctrX < xLimit; ++ctrX) {
                double current;
                int offsetROI = ctrX + offsetROIZ;
                int offsetROIByteArray = ctrX + offsetROIY + offsetROIByteArrayZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (!copy && !isRange) {
                    this.undoClipboard.put(oldMaskData);
                }
                if (dilate) {
                    if (isSmart) {
                        current = volData.getValue(ctrX, sliceNum, ctrZ);
                        if (contains[slice[offsetROI]]) continue;
                        if (ctrX > 0 && contains[slice[offsetROI - 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ > 0 && contains[slice[offsetROI - this.xDim]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || !contains[slice[offsetROI + this.xDim]] || !(current >= min) || !(current <= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (contains[slice[offsetROI]]) continue;
                    if (ctrX > 0 && contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrX < this.xDim - 1 && contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrZ > 0 && contains[slice[offsetROI - this.xDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrZ >= this.zDim - 1 || !contains[slice[offsetROI + this.xDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                if (erode) {
                    if (isSmart) {
                        current = volData.getValue(ctrX, sliceNum, ctrZ);
                        if (!contains[slice[offsetROI]]) continue;
                        if ((ctrX == 0 || ctrZ == 0) && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX > 0 && !contains[slice[offsetROI - 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ > 0 && !contains[slice[offsetROI - this.xDim]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || contains[slice[offsetROI + this.xDim]] || !(current <= min) && !(current >= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrX == 0 || ctrZ == 0) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrX > 0 && !contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrX < this.xDim - 1 && !contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrZ > 0 && !contains[slice[offsetROI - this.xDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrZ >= this.zDim - 1 || contains[slice[offsetROI + this.xDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (copy) {
                    if (contains[slice[offsetROI]]) {
                        this.editClipboard.put(oldMaskData);
                        continue;
                    }
                    this.editClipboard.put(0L);
                    continue;
                }
                if (isRange) {
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrX < rangeXmin) {
                        rangeXmin = ctrX;
                    }
                    if (ctrX > rangeXmax) {
                        rangeXmax = ctrX;
                    }
                    if (ctrZ < rangeZmin) {
                        rangeZmin = ctrZ;
                    }
                    if (ctrZ <= rangeZmax) continue;
                    rangeZmax = ctrZ;
                    continue;
                }
                if (!removeThis && !contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (!removeThis || !contains[slice[offsetROI]]) continue;
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (copy) {
            this.editClipboard.finishPutting();
        } else {
            if (dilate) {
                this.finishedChangingROI(MESSAGE_DILATED, MASKS[this.currentROI], -1);
            } else if (erode) {
                this.finishedChangingROI(MESSAGE_ERODED, MASKS[this.currentROI], -1);
            } else if (removeThis) {
                this.finishedChangingROI(MESSAGE_REMOVED, MASKS[this.currentROI], -1);
            } else {
                this.finishedChangingROI(MESSAGE_PRESERVED, MASKS[this.currentROI], -1);
            }
            this.updateUsedROIs(this.roiBuffer.getSelected());
        }
        if (isRange) {
            ib = new ImageBounds(rangeXmin, rangeXmax, sliceNum, sliceNum, rangeZmin, rangeZmax);
        }
        return ib;
    }

    private ImageBounds selectedComponentAction2DSagittal(Point startPoint, int sliceDirection, int sliceNum, boolean removeThis, boolean dilate, boolean erode, boolean copy, boolean isRange, boolean isSmart, double min, double max) {
        if ((this.roiBuffer.getCurrent(sliceNum + this.xDim * startPoint.x + this.xDim * this.yDim * startPoint.y) & MASKS[this.currentROI]) == 0L) {
            return null;
        }
        if (!copy && !isRange) {
            this.willChangeROI(new ImageBounds(sliceNum, sliceNum, 0, this.yDim - 2, 0, this.zDim - 2), false, sliceDirection);
        }
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.yzBuffer;
        for (int ctr = 0; ctr < this.yzBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            int offsetROIZ = this.yDim * ctrZ;
            int offsetROIZMinusZ = this.yDim * (ctrZ - 1);
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROI = ctrY + offsetROIZ;
                int offsetROIMinusY = ctrY - 1 + offsetROIZ;
                int offsetROIMinusZ = ctrY + offsetROIZMinusZ;
                slice[offsetROI] = 0;
                if ((this.roiBuffer.getCurrent(sliceNum + this.xDim * ctrY + this.xDim * this.yDim * ctrZ) & MASKS[this.currentROI]) == 0L) continue;
                if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (ctrZ == 0 || slice[offsetROIMinusZ] == 0 || slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusZ];
                    if (ctrY == 0 || slice[offsetROIMinusY] == 0 || slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
                equivSetManager.addPair(slice[offsetROI], slice[offsetROI]);
            }
        }
        int seed = slice[startPoint.x + this.yDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        if (copy) {
            this.editClipboard.setCurrentUser((ROIClipboardUser)((Object)this.user));
            this.editClipboard.setCopyMask(MASKS[this.currentROI], this.roiBuffer.getMaximumColors());
            this.editClipboard.setDimensions(this.yDim, this.zDim, this.user.getBaseVolume().getYSize(), this.user.getBaseVolume().getZSize());
            this.editClipboard.initializePutting();
            this.roiBuffer.rewind();
            this.editClipboard.setCopyType(0);
        }
        int yLimit = copy ? this.yDim : this.yDim - 1;
        int zLimit = copy ? this.zDim : this.zDim - 1;
        int rangeYmin = this.yDim;
        int rangeYmax = 0;
        int rangeZmin = this.zDim;
        int rangeZmax = 0;
        VolumeData volData = new VolumeData(this.user);
        ImageBounds ib = null;
        for (int ctrZ = 0; ctrZ < zLimit; ++ctrZ) {
            int offsetROIZ = this.yDim * ctrZ;
            int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
            for (int ctrY = 0; ctrY < yLimit; ++ctrY) {
                double current;
                int offsetROI = ctrY + offsetROIZ;
                int offsetROIByteArray = sliceNum + this.xDim * ctrY + offsetROIByteArrayZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (!copy && !isRange) {
                    this.undoClipboard.put(oldMaskData);
                }
                if (dilate) {
                    if (isSmart) {
                        current = volData.getValue(sliceNum, ctrY, ctrZ);
                        if (contains[slice[offsetROI]]) continue;
                        if (ctrY > 0 && contains[slice[offsetROI - 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrY < this.yDim - 1 && contains[slice[offsetROI + 1]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ > 0 && contains[slice[offsetROI - this.yDim]] && current >= min && current <= max) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || !contains[slice[offsetROI + this.yDim]] || !(current >= min) || !(current <= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (contains[slice[offsetROI]]) continue;
                    if (ctrY > 0 && contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrY < this.yDim - 1 && contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrZ > 0 && contains[slice[offsetROI - this.yDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                        continue;
                    }
                    if (ctrZ >= this.zDim - 1 || !contains[slice[offsetROI + this.yDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                if (erode) {
                    if (isSmart) {
                        current = volData.getValue(sliceNum, ctrY, ctrZ);
                        if (!contains[slice[offsetROI]]) continue;
                        if ((ctrY == 0 || ctrZ == 0) && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY > 0 && !contains[slice[offsetROI - 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrY < this.yDim - 1 && !contains[slice[offsetROI + 1]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ > 0 && !contains[slice[offsetROI - this.yDim]] && (current <= min || current >= max)) {
                            this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                            continue;
                        }
                        if (ctrZ >= this.zDim - 1 || contains[slice[offsetROI + this.yDim]] || !(current <= min) && !(current >= max)) continue;
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrY == 0 || ctrZ == 0) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrY > 0 && !contains[slice[offsetROI - 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrY < this.yDim - 1 && !contains[slice[offsetROI + 1]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrZ > 0 && !contains[slice[offsetROI - this.yDim]]) {
                        this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    if (ctrZ >= this.zDim - 1 || contains[slice[offsetROI + this.yDim]]) continue;
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (copy) {
                    if (contains[slice[offsetROI]]) {
                        this.editClipboard.put(oldMaskData);
                        continue;
                    }
                    this.editClipboard.put(0L);
                    continue;
                }
                if (isRange) {
                    if (!contains[slice[offsetROI]]) continue;
                    if (ctrY < rangeYmin) {
                        rangeYmin = ctrY;
                    }
                    if (ctrY > rangeYmax) {
                        rangeYmax = ctrY;
                    }
                    if (ctrZ < rangeZmin) {
                        rangeZmin = ctrZ;
                    }
                    if (ctrZ <= rangeZmax) continue;
                    rangeZmax = ctrZ;
                    continue;
                }
                if (!removeThis && !contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                if (!removeThis || !contains[slice[offsetROI]]) continue;
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData & (MASKS[this.currentROI] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (copy) {
            this.editClipboard.finishPutting();
        } else {
            if (dilate) {
                this.finishedChangingROI(MESSAGE_DILATED, MASKS[this.currentROI], -1);
            } else if (erode) {
                this.finishedChangingROI(MESSAGE_ERODED, MASKS[this.currentROI], -1);
            } else if (removeThis) {
                this.finishedChangingROI(MESSAGE_REMOVED, MASKS[this.currentROI], -1);
            } else {
                this.finishedChangingROI(MESSAGE_PRESERVED, MASKS[this.currentROI], -1);
            }
            this.updateUsedROIs(this.roiBuffer.getSelected());
        }
        if (isRange) {
            ib = new ImageBounds(sliceNum, sliceNum, rangeYmin, rangeYmax, rangeZmin, rangeZmax);
        }
        return ib;
    }

    private void selectedComponentAction2DValueAxial(Point startPoint, int sliceDirection, int sliceNum, double min, double max) {
        VolumeData volData = new VolumeData(this.user);
        double current = volData.getValue(startPoint.x, startPoint.y, sliceNum);
        if (current < min && current > max) {
            return;
        }
        this.willUseROI(this.currentROI);
        this.willChangeROI(new ImageBounds(0, this.xDim - 2, 0, this.yDim - 2, sliceNum, sliceNum), false, sliceDirection);
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.xyBuffer;
        for (int ctr = 0; ctr < this.xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        int offsetROIZ = this.xDim * this.yDim * sliceNum;
        for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
            int offsetROIY = this.xDim * ctrY;
            int offsetROIYMinusY = this.xDim * (ctrY - 1);
            for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                int offsetROI = ctrX + offsetROIY;
                int offsetROIMinusX = ctrX - 1 + offsetROIY;
                int offsetROIMinusY = ctrX + offsetROIYMinusY;
                slice[offsetROI] = 0;
                current = volData.getValue(ctrX, ctrY, sliceNum);
                if (!(current >= min) || !(current <= max)) continue;
                if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (ctrY == 0 || slice[offsetROIMinusY] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (ctrX == 0 || slice[offsetROIMinusX] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
            }
        }
        int seed = slice[startPoint.x + this.xDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        int xLimit = this.xDim - 1;
        int yLimit = this.yDim - 1;
        for (int ctrY = 0; ctrY < yLimit; ++ctrY) {
            int offsetROIY = this.xDim * ctrY;
            for (int ctrX = 0; ctrX < xLimit; ++ctrX) {
                int offsetROI = ctrX + offsetROIY;
                int offsetROIByteArray = offsetROI + offsetROIZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData);
            }
        }
        this.finishedChangingROI(MESSAGE_GREW, MASKS[this.currentROI], -1);
        this.updateUsedROIs(this.roiBuffer.getSelected());
    }

    private void selectedComponentAction2DValueCoronal(Point startPoint, int sliceDirection, int sliceNum, double min, double max) {
        VolumeData volData = new VolumeData(this.user);
        double current = volData.getValue(startPoint.x, sliceNum, startPoint.y);
        if (current < min && current > max) {
            return;
        }
        this.willUseROI(this.currentROI);
        this.willChangeROI(new ImageBounds(0, this.xDim - 2, sliceNum, sliceNum, 0, this.zDim - 2), false, sliceDirection);
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.xzBuffer;
        for (int ctr = 0; ctr < this.xzBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        int offsetROIY = sliceNum * this.xDim;
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            int offsetROIZ = ctrZ * this.xDim;
            int offsetROIZMinusZ = (ctrZ - 1) * this.xDim;
            for (int ctrX = 0; ctrX < this.xDim - 1; ++ctrX) {
                int offsetROI = ctrX + offsetROIZ;
                int offsetROIMinusX = ctrX - 1 + offsetROIZ;
                int offsetROIMinusZ = ctrX + offsetROIZMinusZ;
                slice[offsetROI] = 0;
                current = volData.getValue(ctrX, sliceNum, ctrZ);
                if (!(current >= min) || !(current <= max)) continue;
                if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusX];
                    if (ctrZ == 0 || slice[offsetROIMinusZ] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusZ];
                    if (ctrX == 0 || slice[offsetROIMinusX] == 0 || slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
            }
        }
        int seed = slice[startPoint.x + this.xDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        int xLimit = this.xDim - 1;
        int zLimit = this.zDim - 1;
        for (int ctrZ = 0; ctrZ < zLimit; ++ctrZ) {
            int offsetROIZ = this.xDim * ctrZ;
            int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
            for (int ctrX = 0; ctrX < xLimit; ++ctrX) {
                int offsetROI = ctrX + offsetROIZ;
                int offsetROIByteArray = ctrX + offsetROIY + offsetROIByteArrayZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData);
            }
        }
        this.finishedChangingROI(MESSAGE_GREW, MASKS[this.currentROI], -1);
        this.updateUsedROIs(this.roiBuffer.getSelected());
    }

    private void selectedComponentAction2DValueSagittal(Point startPoint, int sliceDirection, int sliceNum, double min, double max) {
        VolumeData volData = new VolumeData(this.user);
        double current = volData.getValue(sliceNum, startPoint.x, startPoint.y);
        if (current < min && current > max) {
            return;
        }
        this.willUseROI(this.currentROI);
        this.willChangeROI(new ImageBounds(sliceNum, sliceNum, 0, this.yDim - 2, 0, this.zDim - 2), false, sliceDirection);
        EquivalentSetManager equivSetManager = new EquivalentSetManager(false);
        equivSetManager.addStartVal(0);
        int componentCtr = 0;
        int[] slice = this.yzBuffer;
        for (int ctr = 0; ctr < this.yzBuffer.length; ++ctr) {
            slice[ctr] = 0;
        }
        for (int ctrZ = 0; ctrZ < this.zDim - 1; ++ctrZ) {
            int offsetROIZ = this.yDim * ctrZ;
            int offsetROIZMinusZ = this.yDim * (ctrZ - 1);
            for (int ctrY = 0; ctrY < this.yDim - 1; ++ctrY) {
                int offsetROI = ctrY + offsetROIZ;
                int offsetROIMinusY = ctrY - 1 + offsetROIZ;
                int offsetROIMinusZ = ctrY + offsetROIZMinusZ;
                slice[offsetROI] = 0;
                current = volData.getValue(sliceNum, ctrY, ctrZ);
                if (!(current >= min) || !(current <= max)) continue;
                if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusY];
                    if (ctrZ == 0 || slice[offsetROIMinusZ] == 0 || slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                if (ctrZ != 0 && slice[offsetROIMinusZ] != 0) {
                    slice[offsetROI] = slice[offsetROIMinusZ];
                    if (ctrY == 0 || slice[offsetROIMinusY] == 0 || slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                    equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                    continue;
                }
                equivSetManager.incrementSetMap();
                slice[offsetROI] = ++componentCtr;
            }
        }
        int seed = slice[startPoint.x + this.yDim * startPoint.y];
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, seed);
        int yLimit = this.yDim - 1;
        int zLimit = this.zDim - 1;
        for (int ctrZ = 0; ctrZ < zLimit; ++ctrZ) {
            int offsetROIZ = this.yDim * ctrZ;
            int offsetROIByteArrayZ = this.xDim * this.yDim * ctrZ;
            for (int ctrY = 0; ctrY < yLimit; ++ctrY) {
                int offsetROI = ctrY + offsetROIZ;
                int offsetROIByteArray = sliceNum + this.xDim * ctrY + offsetROIByteArrayZ;
                long oldMaskData = this.roiBuffer.getCurrent(offsetROIByteArray);
                if (contains[slice[offsetROI]]) {
                    this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData | MASKS[this.currentROI]);
                    continue;
                }
                this.roiBuffer.putCurrent(offsetROIByteArray, oldMaskData);
            }
        }
        this.finishedChangingROI(MESSAGE_GREW, MASKS[this.currentROI], -1);
        this.updateUsedROIs(this.roiBuffer.getSelected());
    }

    private void selectedComponentAction3D(final Coordinate coordinate, final boolean isInValueRange, final boolean removeThis, final boolean dilate, final boolean erode, final boolean copy, final boolean isSmart, final double min, final double max) {
        double value;
        VolumeData volData = new VolumeData(this.user);
        if (isInValueRange ? isSmart && ((value = volData.getValue(coordinate.xInt, coordinate.yInt, coordinate.zInt)) < min || value > max) : ((value = this.roiBuffer.getCurrent(coordinate.xInt + this.xDim * coordinate.yInt + this.xDim * this.yDim * coordinate.zInt)) & MASKS[this.currentROI]) == 0L) {
            return;
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIManager.this.doSelectedComponentAction3D(coordinate, isInValueRange, removeThis, dilate, erode, copy, isSmart, min, max);
            }
        }, "ROIManager.doSelectedComponentAction3D() Thread");
        workThread.start();
    }

    public void setSelectedState(int num, boolean bool) {
        if (bool) {
            this.roiBuffer.addSelected(MASKS[num]);
        } else {
            this.roiBuffer.removeSelected(MASKS[num]);
        }
        if (this.listener != null) {
            this.listener.roiSelectionHasChanged();
        }
    }

    private void setUndoBounds(ImageBounds bounds, int direction) {
        this.undoBounds = new ImageBounds(bounds);
        this.undoDirection = direction;
    }

    private void setUsedROIs(long usedMask, boolean update) {
        long oldUsedMask;
        long usedROIs = oldUsedMask = this.roiBuffer.getUsed();
        long selectedROIs = this.roiBuffer.getSelected();
        usedROIs = usedMask;
        this.roiBuffer.setUsed(usedROIs);
        this.roiBuffer.setSelected(selectedROIs &= usedMask);
        if (oldUsedMask != usedROIs) {
            this.setDirty(true);
        }
        if (update && usedROIs == 0L) {
            this.updateROIBufferSeries(false);
        }
    }

    private void updateUsedROIs(long testMask) {
        long oldUsedMask;
        long stillUsedMask = this.roiBuffer.isEmptyOf(testMask);
        long nowEmptyMask = testMask & (stillUsedMask ^ 0xFFFFFFFFFFFFFFFFL);
        long usedFilterMask = nowEmptyMask ^ 0xFFFFFFFFFFFFFFFFL;
        long usedROIs = oldUsedMask = this.roiBuffer.getUsed();
        long selectedROIs = this.roiBuffer.getSelected();
        this.roiBuffer.setUsed(usedROIs &= usedFilterMask);
        this.roiBuffer.setSelected(selectedROIs &= usedFilterMask);
        if (oldUsedMask != usedROIs) {
            this.setDirty(true);
        }
        if (usedROIs == 0L) {
            this.updateROIBufferSeries(false);
        }
    }

    private void willChangeROI(ImageBounds bounds, boolean isSeries, int sliceDirection) {
        this.willChangeROI(bounds, isSeries, sliceDirection, false, false);
    }

    private void willChangeROI(ImageBounds bounds, boolean isSeries, int sliceDirection, boolean skipClipboard) {
        this.willChangeROI(bounds, isSeries, sliceDirection, skipClipboard, false);
    }

    private void willChangeROI(ImageBounds bounds, boolean isSeries, int sliceDirection, boolean skipClipboard, boolean skipReset) {
        this.roiBuffer.rewind();
        if (!this.user.isShowingROI()) {
            this.user.setShowROI(true);
        }
        if (isSeries) {
            bounds.setRangeT(0, this.user.getCurrentVolume().getSeriesLength() - 1);
        } else {
            bounds.setRangeT(this.user.getCurrentVolume().getCurrentSeriesPoint(), this.user.getCurrentVolume().getCurrentSeriesPoint());
        }
        if (!skipClipboard) {
            if (!skipReset && this.listener != null) {
                this.listener.resetAllClipboardsUndo();
            }
            this.setUndoBounds(bounds, sliceDirection);
            this.undoClipboard.initializePutting();
        }
        this.hasUndo = true;
        this.hasRedo = false;
        this.setDirty(true);
        this.editingDisabled = true;
        this.solidShapeMap.remove(this.currentROI);
    }

    private void willUseROI(int roiIndex) {
        long usedROIs;
        if (!this.roiBuffer.hasBuffer()) {
            this.makeROIBuffer();
        }
        if (((usedROIs = this.roiBuffer.getUsed()) & MASKS[roiIndex]) == 0L) {
            this.roiBuffer.addUsed(MASKS[roiIndex]);
            this.initROI(roiIndex);
        }
    }

    public String[] getLabelModel() {
        return this.labels.getLabelModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveROI(File file, int selectedSaveIndex) {
        ProgressMeter progress = this.user.makeProgressMeter();
        progress.setIndeterminateMode(true);
        progress.start(0, 0, 100);
        Volume volume = (Volume)this.user.getBaseVolume();
        boolean isLittleEndian = volume.getImageType().isLittleEndian();
        long saveMask = selectedSaveIndex != -1 ? 1L << selectedSaveIndex : -1L;
        byte[] extData = null;
        int extSize = 0;
        try {
            extData = Metadata.writeMetadata((MetadataUser)((Object)this.user), selectedSaveIndex).getBytes("utf-8");
            extSize = extData.length;
            extSize += 8;
            int diffIntegral = 16 - (extSize += 20) % 16;
            extSize += diffIntegral;
        }
        catch (ParserConfigurationException e) {
            AppLogger.error((Throwable)e);
        }
        catch (TransformerException e) {
            AppLogger.error((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            AppLogger.error((Throwable)e);
        }
        byte[] extensionData = null;
        if (extSize > 0) {
            extensionData = new byte[extSize];
            ByteBuffer extensionBuf = ByteBuffer.wrap(extensionData);
            extensionBuf.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            extensionBuf.putInt(extSize);
            extensionBuf.putInt(0);
            extensionBuf.putInt(0);
            extensionBuf.putInt(0);
            extensionBuf.putInt(0);
            extensionBuf.putInt(0);
            extensionBuf.putInt(0);
            extensionBuf.put(extData);
        }
        int xDim = volume.getXDim();
        int yDim = volume.getYDim();
        int zDim = volume.getZDim();
        double xSize = volume.getXSize();
        double ySize = volume.getYSize();
        double zSize = volume.getZSize();
        long maxBitValue = 0L;
        maxBitValue = this.findMaxBitValue();
        boolean success = false;
        try {
            ImageDimensions id = new ImageDimensions(xDim + 1, yDim + 1, zDim + 1, this.getBuffer().getSeriesLength());
            VoxelDimensions vd = new VoxelDimensions(xSize, ySize, zSize, 0.0);
            vd.setSpatialUnit(volume.getVoxelDimensions().getSpatialUnit());
            vd.setTemporalUnit(volume.getVoxelDimensions().getTemporalUnit());
            ImageType it = new ImageType(this.getBuffer().getMaximumColors() / 8, 3, this.getBuffer().getMaximumColors(), isLittleEndian);
            Header header = new Header(it, id, vd);
            header.setImageFile(file);
            header.setOrientation("XYZ+--");
            header.getImageRange().setDisplayMax((double)maxBitValue);
            header.getImageRange().setDisplayMin(0.0);
            header.getImageRange().setImageMax((double)maxBitValue);
            header.getImageRange().setImageMin(0.0);
            it.setCompressionType(1);
            if (!this.user.isWorldMode()) {
                header.copyNIFTIOrientation(volume.getNIFTIObject());
            }
            Volume vol = null;
            vol = this.getBuffer().getByteBuffers() != null ? new Volume(header, true, this.getBuffer().getByteBuffers()) : new Volume(header, true, null);
            vol.setExtension(extensionData);
            vol.setAsNativeIntegerBuffer();
            vol.setOrigin(volume.getOrigin());
            vol.setNativeDataTypeSaveMask(saveMask);
            ImageBounds ib = new ImageBounds(0, xDim - 1, 0, yDim - 1, 0, zDim - 1);
            if (this.isUsing4dROI()) {
                ib.setRangeT(0, this.getBuffer().getSeriesLength() - 1);
            }
            vol.setImageDescription(MANGO_ROI_DESCRIPTION);
            int precisionNeeded = BitUtilities.findNeededPrecision((long)this.getBuffer().getUsed());
            ImageType itSaved = new ImageType(precisionNeeded / 8, 3, precisionNeeded, isLittleEndian);
            itSaved.setCompressionType(1);
            vol.writeFilesAs(file, itSaved, 0, volume.getOrientationString(), volume.getOrigin(), true, "NIFTI", false, false, null, false, -1, true, false, false, false, 0.0, false, false, false, ib, xSize, ySize, zSize, 0.0, true);
            vol.setNativeDataTypeSaveMask(-1L);
            success = true;
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.user.showErrorMessage("Problem writing file! \n" + ex.getMessage(), "ROI Export Error");
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.user.showErrorMessage("Problem writing file! \n" + ex.getMessage(), "ROI Export Error");
        }
        finally {
            progress.setIndeterminateMode(false);
            progress.setValue(progress.getMax());
            if (this.listener != null) {
                this.listener.roiSaved(success, file);
            }
        }
    }
}

