/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.display;

import edu.uthscsa.ric.roi.ROICalculator;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class ROIPathIterator
implements PathIterator {
    private AffineTransform transform;
    private boolean close;
    private boolean done;
    private boolean forceClose;
    private boolean move;
    private boolean pointFound;
    private boolean startFromNewPoint;
    private int area;
    private int arrivalDirection;
    private int centroidX;
    private int centroidY;
    private int xPtr;
    private int yPtr;
    private final Point currentPoint;
    private final Point startingPoint;
    private final Point transformedPoint;
    private final ROICalculator calculator;
    private final byte[] data;
    private final float[] tempFloats = new float[2];
    private final int xDim;
    private final int yDim;
    private static final byte DOWN = -128;
    private static final byte MARKER = 32;
    private static final byte MASK = 16;
    private static final byte RIGHT = 64;
    private static final byte PATH_DATA = -64;
    private static final int ARRIVED_GOING_DOWN = 1;
    private static final int ARRIVED_GOING_LEFT = 4;
    private static final int ARRIVED_GOING_NOWHERE = 0;
    private static final int ARRIVED_GOING_NULL = -1;
    private static final int ARRIVED_GOING_RIGHT = 3;
    private static final int ARRIVED_GOING_UP = 2;

    protected ROIPathIterator(int dimX, int dimY, byte[] someData, AffineTransform aTransform, ROICalculator aCalculator) {
        this.xDim = dimX;
        this.yDim = dimY;
        this.centroidY = 0;
        this.centroidX = 0;
        this.startingPoint = new Point();
        this.currentPoint = new Point();
        this.transformedPoint = new Point();
        this.data = someData;
        this.transform = aTransform;
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        this.calculator = aCalculator;
        this.calculator.reset();
        this.init();
    }

    @Override
    public int currentSegment(double[] coords) {
        int type = this.currentSegment(this.tempFloats);
        coords[0] = this.tempFloats[0];
        coords[1] = this.tempFloats[1];
        return type;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.close || this.forceClose) {
            this.close = false;
            this.move = true;
            if (!this.pointFound || this.forceClose) {
                this.done = true;
            }
            return 4;
        }
        if (this.move) {
            this.move = false;
            this.fillReturnCoordinates(coords);
            return 0;
        }
        this.fillReturnCoordinates(coords);
        return 1;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        if (this.done) {
            this.calculator.setStats(this.area, this.centroidX, this.centroidY);
        }
        return this.done;
    }

    @Override
    public final void next() {
        if (this.forceClose) {
            return;
        }
        if (this.startFromNewPoint) {
            this.currentPoint.setLocation(this.startingPoint);
            this.startFromNewPoint = false;
            this.arrivalDirection = 0;
        } else {
            if (this.arrivalDirection == 0) {
                this.doArrivedGoingNowhere();
            } else if (this.arrivalDirection == 3) {
                this.doArrivedGoingRight();
            } else if (this.arrivalDirection == 4) {
                this.doArrivedGoingLeft();
            } else if (this.arrivalDirection == 2) {
                this.doArrivedGoingUp();
            } else if (this.arrivalDirection == 1) {
                this.doArrivedGoingDown();
            }
            if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0xFFFFFFC0) == -64 && this.arrivalDirection != 1 && this.currentPoint.x + this.xDim * this.currentPoint.y >= this.xPtr + this.xDim * this.yPtr) {
                int n = this.currentPoint.x + this.xDim * this.currentPoint.y;
                this.data[n] = (byte)(this.data[n] | 0x20);
            }
            this.checkForClosing();
        }
    }

    protected void forceClose() {
        this.forceClose = true;
    }

    private void checkForClosing() {
        if (this.currentPoint.equals(this.startingPoint)) {
            this.close = true;
            this.startFromNewPoint = true;
            this.pointFound = this.findStartingPoint();
        }
    }

    private void doArrivedGoingDown() {
        if ((this.data[this.currentPoint.x - 1 + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doLeft();
        } else if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0xFFFFFF80) == -128) {
            this.doDown();
        } else if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doRight();
        } else {
            this.forceClose = true;
        }
    }

    private void doArrivedGoingLeft() {
        if ((this.data[this.currentPoint.x + this.xDim * (this.currentPoint.y - 1)] & 0xFFFFFF80) == -128) {
            this.doUp();
        } else if ((this.data[this.currentPoint.x - 1 + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doLeft();
        } else if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0xFFFFFF80) == -128) {
            this.doDown();
        } else {
            this.forceClose = true;
        }
    }

    private void doArrivedGoingNowhere() {
        boolean hasDown;
        boolean hasMask = (this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0x10) == 16;
        boolean hasRight = (this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0x40) == 64;
        boolean bl = hasDown = (this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0xFFFFFF80) == -128;
        if (hasMask) {
            if (hasRight && hasDown) {
                this.doArrivedGoingUp();
            } else if (hasRight) {
                this.doArrivedGoingRight();
            } else if (hasDown) {
                this.doArrivedGoingUp();
            } else {
                this.forceClose = true;
            }
        } else if (hasRight && hasDown) {
            this.doArrivedGoingDown();
        } else if (hasRight) {
            this.doArrivedGoingLeft();
        } else if (hasDown) {
            this.doArrivedGoingDown();
        } else {
            this.forceClose = true;
        }
    }

    private void doArrivedGoingRight() {
        if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0xFFFFFF80) == -128) {
            this.doDown();
        } else if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doRight();
        } else if ((this.data[this.currentPoint.x + this.xDim * (this.currentPoint.y - 1)] & 0xFFFFFF80) == -128) {
            this.doUp();
        } else {
            this.forceClose = true;
        }
    }

    private void doArrivedGoingUp() {
        if ((this.data[this.currentPoint.x + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doRight();
        } else if ((this.data[this.currentPoint.x + this.xDim * (this.currentPoint.y - 1)] & 0xFFFFFF80) == -128) {
            this.doUp();
        } else if ((this.data[this.currentPoint.x - 1 + this.xDim * this.currentPoint.y] & 0x40) == 64) {
            this.doLeft();
        } else {
            this.forceClose = true;
        }
    }

    private void doDown() {
        this.currentPoint.setLocation(this.currentPoint.x, this.currentPoint.y + 1);
        this.arrivalDirection = 1;
    }

    private void doLeft() {
        this.currentPoint.setLocation(this.currentPoint.x - 1, this.currentPoint.y);
        this.arrivalDirection = 4;
    }

    private void doRight() {
        this.currentPoint.setLocation(this.currentPoint.x + 1, this.currentPoint.y);
        this.arrivalDirection = 3;
    }

    private void doUp() {
        this.currentPoint.setLocation(this.currentPoint.x, this.currentPoint.y - 1);
        this.arrivalDirection = 2;
    }

    private void fillReturnCoordinates(float[] coords) {
        this.transform.transform(this.currentPoint, this.transformedPoint);
        coords[0] = this.transformedPoint.x;
        coords[1] = this.transformedPoint.y;
        if (this.currentPoint.x == this.xDim - 1) {
            coords[0] = coords[0] - 1.0f;
        }
        if (this.currentPoint.y == this.yDim - 1) {
            coords[1] = coords[1] - 1.0f;
        }
    }

    private boolean findStartingPoint() {
        while (this.yPtr < this.yDim) {
            while (this.xPtr < this.xDim) {
                if ((this.data[this.xPtr + this.xDim * this.yPtr] & 0x10) == 16) {
                    ++this.area;
                    this.centroidX += this.xPtr;
                    this.centroidY += this.yPtr;
                }
                if ((this.data[this.xPtr + this.xDim * this.yPtr] & 0xFFFFFFC0) == -64 && (this.data[this.xPtr + this.xDim * this.yPtr] & 0x20) == 0) {
                    this.startingPoint.setLocation(this.xPtr, this.yPtr);
                    ++this.xPtr;
                    return true;
                }
                int n = this.xPtr + this.xDim * this.yPtr;
                this.data[n] = (byte)(this.data[n] & 0xFFFFFFDF);
                ++this.xPtr;
            }
            this.xPtr = 0;
            ++this.yPtr;
        }
        return false;
    }

    private void init() {
        this.pointFound = this.findStartingPoint();
        if (this.pointFound) {
            this.startFromNewPoint = true;
            this.next();
        } else {
            this.done = true;
            this.arrivalDirection = -1;
        }
        this.move = true;
    }
}

