/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.clipboard;

import edu.uthscsa.ric.roi.mask.clipboard.AbstractROIClipboardHelper;
import edu.uthscsa.ric.utilities.ByteUtilities;

public class ROIShortClipboardHelper
extends AbstractROIClipboardHelper {
    private final byte[] convertBuffer;
    public static final int BYTES_PER_UNIT = 2;
    public static final int MAX_COLORS = 16;

    public ROIShortClipboardHelper() {
        this.buffer = new byte[4096];
        this.convertBuffer = new byte[2];
    }

    @Override
    public long getData() {
        return ByteUtilities.getShort((byte[])this.buffer, (int)this.bufCtr) & 0xFFFF;
    }

    @Override
    public int getMaxColors() {
        return 16;
    }

    @Override
    public int getNumBytes() {
        return 2;
    }

    @Override
    public void increment() {
        this.bufCtr += 2;
        this.totalBytesCtr += 2;
    }

    @Override
    public void putData(long data) {
        ByteUtilities.shortToBytes((short)((short)data), (byte[])this.convertBuffer);
        this.buffer[this.bufCtr] = this.convertBuffer[0];
        this.buffer[this.bufCtr + 1] = this.convertBuffer[1];
    }
}

