/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.clipboard;

import edu.uthscsa.ric.roi.mask.clipboard.AbstractROIClipboardHelper;
import edu.uthscsa.ric.utilities.ByteUtilities;

public class ROILongClipboardHelper
extends AbstractROIClipboardHelper {
    private final byte[] convertBuffer;
    public static final int BYTES_PER_UNIT = 8;
    public static final int MAX_COLORS = 64;

    public ROILongClipboardHelper() {
        this.buffer = new byte[16384];
        this.convertBuffer = new byte[8];
    }

    @Override
    public long getData() {
        return ByteUtilities.getLong((byte[])this.buffer, (int)this.bufCtr);
    }

    @Override
    public int getMaxColors() {
        return 64;
    }

    @Override
    public int getNumBytes() {
        return 8;
    }

    @Override
    public void increment() {
        this.bufCtr += 8;
        this.totalBytesCtr += 8;
    }

    @Override
    public void putData(long data) {
        ByteUtilities.longToBytes((long)data, (byte[])this.convertBuffer);
        this.buffer[this.bufCtr] = this.convertBuffer[0];
        this.buffer[this.bufCtr + 1] = this.convertBuffer[1];
        this.buffer[this.bufCtr + 2] = this.convertBuffer[2];
        this.buffer[this.bufCtr + 3] = this.convertBuffer[3];
        this.buffer[this.bufCtr + 4] = this.convertBuffer[4];
        this.buffer[this.bufCtr + 5] = this.convertBuffer[5];
        this.buffer[this.bufCtr + 6] = this.convertBuffer[6];
        this.buffer[this.bufCtr + 7] = this.convertBuffer[7];
    }
}

