/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.clipboard;

import edu.uthscsa.ric.roi.mask.clipboard.AbstractROIClipboardHelper;
import edu.uthscsa.ric.utilities.ByteUtilities;

public class ROIIntClipboardHelper
extends AbstractROIClipboardHelper {
    private final byte[] convertBuffer;
    public static final int BYTES_PER_UNIT = 4;
    public static final int MAX_COLORS = 32;

    public ROIIntClipboardHelper() {
        this.buffer = new byte[8192];
        this.convertBuffer = new byte[4];
    }

    @Override
    public long getData() {
        return (long)ByteUtilities.getInt((byte[])this.buffer, (int)this.bufCtr) & 0xFFFFFFFFL;
    }

    @Override
    public int getMaxColors() {
        return 32;
    }

    @Override
    public int getNumBytes() {
        return 4;
    }

    @Override
    public void increment() {
        this.bufCtr += 4;
        this.totalBytesCtr += 4;
    }

    @Override
    public void putData(long data) {
        ByteUtilities.intToBytes((int)((int)data), (byte[])this.convertBuffer);
        this.buffer[this.bufCtr] = this.convertBuffer[0];
        this.buffer[this.bufCtr + 1] = this.convertBuffer[1];
        this.buffer[this.bufCtr + 2] = this.convertBuffer[2];
        this.buffer[this.bufCtr + 3] = this.convertBuffer[3];
    }
}

