/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.buffers;

import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.buffers.ROIByteBuffer;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageBounds;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public final class ROIShortBuffer
extends AbstractROIBuffer {
    private ByteBuffer[] byteBuffers;
    private ShortBuffer copyBuffer;
    private ShortBuffer[] buffers;
    private byte[] sliceBuffer;
    private int seriesIndex;
    private short[] workBuffer;
    public static final int BYTES_PER_UNIT = 2;
    public static final int MAX_COLORS = 16;

    public ROIShortBuffer(int xDim, int yDim, int zDim) {
        super(xDim, yDim, zDim);
    }

    public ROIShortBuffer(ROIByteBuffer byteBuffer) {
        super(byteBuffer.getX(), byteBuffer.getY(), byteBuffer.getZ());
        this.copyByteBuffersToShortBuffers(byteBuffer);
        this.seriesIndex = byteBuffer.getSeriesIndex();
        this.setUsed(byteBuffer.getUsed() & 0xFFL);
        this.setSelected(byteBuffer.getSelected() & 0xFFL);
        this.setHighlighted(byteBuffer.getHighlighted() & 0xFFL);
        this.setInited(byteBuffer.getInited() & 0xFFL);
    }

    @Override
    public void clear() {
        this.byteBuffers = null;
        this.buffers = null;
        this.workBuffer = null;
        this.sliceBuffer = null;
    }

    @Override
    public void clearCopyBuffer() {
        this.clearSliceBuffers();
        int length = this.copyBuffer.capacity();
        int iterations = length / this.workBuffer.length;
        this.copyBuffer.rewind();
        for (int ctr = 0; ctr < iterations; ++ctr) {
            this.copyBuffer.put(this.workBuffer, 0, this.workBuffer.length);
        }
    }

    @Override
    public long findMaxBitValue() {
        long max = 0L;
        if (this.hasBuffer()) {
            for (ShortBuffer buffer : this.buffers) {
                int length = buffer.limit();
                for (int ctr = 0; ctr < length; ++ctr) {
                    long value = buffer.get(ctr) & 0xFFFF;
                    if (value <= max) continue;
                    max = value;
                }
            }
        }
        return max;
    }

    @Override
    public long get(int offset, int index) {
        return this.buffers[index].get(offset);
    }

    @Override
    public ByteBuffer[] getByteBuffers() {
        return this.byteBuffers;
    }

    @Override
    public long getCopy(int offset) {
        return this.copyBuffer.get(offset);
    }

    @Override
    public long getCurrent(int offset) {
        return this.get(offset, this.seriesIndex);
    }

    @Override
    public int getMaximumColors() {
        return 16;
    }

    public ShortBuffer[] getNaturalBuffers() {
        return this.buffers;
    }

    public short[] getNaturalWorkBuffer() {
        return this.workBuffer;
    }

    @Override
    public byte[] getNextSlice(int index) {
        this.byteBuffers[index].get(this.sliceBuffer);
        return this.sliceBuffer;
    }

    @Override
    public byte[] getNextSliceCurrent() {
        return this.getNextSlice(this.seriesIndex);
    }

    @Override
    public ImageBounds getROIBounds(long mask, int indexVal) {
        int index = indexVal;
        this.rewind();
        if (index >= this.buffers.length) {
            index = this.buffers.length - 1;
        }
        int xMin = this.xDim - 1;
        int xMax = 0;
        int yMin = this.yDim - 1;
        int yMax = 0;
        int zMin = this.zDim - 1;
        int zMax = 0;
        for (int ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
            this.buffers[index].get(this.workBuffer);
            for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    if (((long)this.workBuffer[ctrX + this.xDim * ctrY] & mask) == 0L) continue;
                    if (yMin > ctrY) {
                        yMin = ctrY;
                    }
                    if (yMax < ctrY) {
                        yMax = ctrY;
                    }
                    if (xMin > ctrX) {
                        xMin = ctrX;
                    }
                    if (xMax < ctrX) {
                        xMax = ctrX;
                    }
                    if (zMin > ctrZ) {
                        zMin = ctrZ;
                    }
                    if (zMax >= ctrZ) continue;
                    zMax = ctrZ;
                }
            }
        }
        return new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax);
    }

    @Override
    public ImageBounds getROIBoundsCurrent(long mask) {
        return this.getROIBounds(mask, this.seriesIndex);
    }

    @Override
    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    @Override
    public int getSeriesLength() {
        return this.buffers != null ? this.buffers.length : 0;
    }

    @Override
    public boolean hasBuffer() {
        return this.buffers != null;
    }

    @Override
    public boolean isEmpty() {
        int tDim = this.getSeriesLength();
        this.rewind();
        for (int ctrT = 0; ctrT < tDim; ++ctrT) {
            for (int ctrBuf = 0; ctrBuf < this.zDim; ++ctrBuf) {
                this.buffers[ctrT].get(this.workBuffer, 0, this.workBuffer.length);
                for (short element : this.workBuffer) {
                    if (element == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isEmptyOf(int roiNum) {
        int tDim = this.getSeriesLength();
        this.rewind();
        for (int ctrT = 0; ctrT < tDim; ++ctrT) {
            for (int ctrBuf = 0; ctrBuf < this.zDim; ++ctrBuf) {
                this.buffers[ctrT].get(this.workBuffer, 0, this.workBuffer.length);
                for (short element : this.workBuffer) {
                    if (((long)element & AbstractROIBuffer.MASKS[roiNum]) == 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public long isEmptyOf(long roiMask) {
        int tDim = this.getSeriesLength();
        long returnMask = 0L;
        this.rewind();
        for (int ctrT = 0; ctrT < tDim; ++ctrT) {
            for (int ctrBuf = 0; ctrBuf < this.zDim; ++ctrBuf) {
                this.buffers[ctrT].get(this.workBuffer, 0, this.workBuffer.length);
                for (short element : this.workBuffer) {
                    if (((returnMask |= (long)element) & roiMask) != roiMask) continue;
                    return roiMask;
                }
            }
        }
        return returnMask & roiMask;
    }

    @Override
    public void makeBuffer(int volSize, int sliceSize) {
        this.makeBufferSeries(1, volSize, sliceSize);
    }

    @Override
    public void makeBufferSeries(int timepoints, int volSize, int sliceSize) {
        this.buffers = new ShortBuffer[timepoints];
        this.byteBuffers = new ByteBuffer[timepoints];
        for (int ctr = 0; ctr < timepoints; ++ctr) {
            this.byteBuffers[ctr] = Image.makeBuffer(volSize * 2);
            this.buffers[ctr] = this.byteBuffers[ctr].asShortBuffer();
        }
        this.sliceBuffer = new byte[sliceSize * 2];
        this.workBuffer = new short[sliceSize];
    }

    @Override
    public void makeCopyBuffer(int volSize) {
        if (this.copyBuffer == null) {
            this.copyBuffer = Image.makeBuffer(volSize * 2).asShortBuffer();
        }
    }

    @Override
    public void put(int offset, int index, long val) {
        this.buffers[index].put(offset, (short)val);
    }

    @Override
    public void putCopy(int offset, long val) {
        this.copyBuffer.put(offset, (short)val);
    }

    @Override
    public void putCurrent(int offset, long val) {
        this.put(offset, this.seriesIndex, val);
    }

    @Override
    public void rewind() {
        if (this.buffers != null) {
            for (int ctr = 0; ctr < this.buffers.length; ++ctr) {
                this.buffers[ctr].rewind();
                this.byteBuffers[ctr].rewind();
            }
        }
        if (this.copyBuffer != null) {
            this.copyBuffer.rewind();
        }
        this.clearSliceBuffers();
    }

    @Override
    public void setSeriesIndex(int index) {
        if (index < this.buffers.length) {
            this.seriesIndex = index;
        }
    }

    private void clearSliceBuffers() {
        int ctr;
        for (ctr = 0; ctr < this.sliceBuffer.length; ++ctr) {
            this.sliceBuffer[ctr] = 0;
        }
        for (ctr = 0; ctr < this.workBuffer.length; ++ctr) {
            this.workBuffer[ctr] = 0;
        }
    }

    private void copyByteBuffersToShortBuffers(ROIByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer[] fromBuffers = byteBuffer.getNaturalBuffers();
        byte[] fromWorkBuffer = byteBuffer.getNaturalWorkBuffer();
        int timepoints = fromBuffers.length;
        int sliceSize = byteBuffer.getX() * byteBuffer.getY();
        int volSize = sliceSize * byteBuffer.getZ();
        this.makeBufferSeries(timepoints, volSize, sliceSize);
        this.rewind();
        for (int ctrT = 0; ctrT < timepoints; ++ctrT) {
            for (int ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                fromBuffers[ctrT].get(fromWorkBuffer);
                for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        this.workBuffer[ctrX + this.xDim * ctrY] = (short)(fromWorkBuffer[ctrX + this.xDim * ctrY] & 0xFF);
                    }
                }
                this.buffers[ctrT].put(this.workBuffer);
            }
        }
    }
}

