/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.manager;

import edu.uthscsa.ric.roi.ShapesSpecialManager;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;

public class LOISpecialManager
implements ShapesSpecialManager {
    private LOIShape staticShapes;
    private final LOIShape[] shapes;
    private final LineListener listener;
    private final LineUser user;
    private final int sliceDirection;

    public LOISpecialManager(int numSlices, int sliceDirection, LineListener listener, LineUser user) {
        this.shapes = new LOIShape[numSlices];
        this.sliceDirection = sliceDirection;
        this.listener = listener;
        this.user = user;
    }

    public LOIShape addImmutableShape(Shape aShape, int slice, Color aColor, Stroke stroke) {
        LOIShape shape = new LOIShape(aShape.getPathIterator(null), slice, -1, this.listener, this.user);
        shape.setImmutable(true);
        shape.setSpecialColor(aColor);
        shape.setSpecialStroke(stroke);
        this.addLOI(shape);
        return shape;
    }

    public LOIShape addShape(Shape aShape, int slice, Color aColor, Stroke stroke) {
        LOIShape shape = new LOIShape(aShape.getPathIterator(null), slice, -1, this.listener, this.user);
        shape.setSpecialColor(aColor);
        shape.setSpecialStroke(stroke);
        this.addLOI(shape);
        return shape;
    }

    public LOIShape addStaticShape(Shape aShape, Color aColor, Stroke stroke) {
        LOIShape shape = new LOIShape(aShape.getPathIterator(null), -1, -1, this.listener, this.user);
        shape.setImmutable(true);
        shape.setPermanent(true);
        shape.setSpecialColor(aColor);
        shape.setSpecialStroke(stroke);
        this.addStaticLOI(shape);
        return shape;
    }

    public LOIShape getShape(int slice) {
        return this.shapes[slice];
    }

    public Shape[] getShapes(int slice, Color aColor) {
        Shape[] shapesToReturn = null;
        int num = 0;
        for (LOIShape current = this.shapes[slice]; current != null; current = current.getNext()) {
            if (current.getSpecialColor() != aColor) continue;
            ++num;
        }
        if (num > 0) {
            shapesToReturn = new Shape[num];
            int ctr = 0;
            for (LOIShape current = this.shapes[slice]; current != null; current = current.getNext()) {
                if (current.getSpecialColor() != aColor) continue;
                shapesToReturn[ctr++] = current;
            }
        }
        return shapesToReturn;
    }

    public LOIShape getStaticShape() {
        return this.staticShapes;
    }

    public Shape[] getStaticShapes(Color aColor) {
        Shape[] shapesToReturn = null;
        int num = 0;
        for (LOIShape current = this.staticShapes; current != null; current = current.getNext()) {
            if (current.getSpecialColor() != aColor) continue;
            ++num;
        }
        if (num > 0) {
            shapesToReturn = new Shape[num];
            int ctr = 0;
            for (LOIShape current = this.staticShapes; current != null; current = current.getNext()) {
                if (current.getSpecialColor() != aColor) continue;
                shapesToReturn[ctr++] = current;
            }
        }
        return shapesToReturn;
    }

    public boolean hasShapes() {
        return this.shapes != null;
    }

    public boolean hasStaticShapes() {
        return this.staticShapes != null;
    }

    public void removeShape(Shape aShape) {
        if (aShape instanceof LOIShape) {
            this.removeLOI((LOIShape)aShape);
        }
    }

    public void setShapeHighlightState(Shape shape, boolean highlight) {
        block4: {
            if (!(shape instanceof LOIShape)) break block4;
            LOIShape aLOI = (LOIShape)shape;
            boolean isStatic = aLOI.isPermanent();
            if (isStatic) {
                for (LOIShape currentLOI = this.staticShapes; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    if (currentLOI != aLOI) continue;
                    currentLOI.setHighlighted(highlight);
                }
            } else {
                int slice = aLOI.getSliceNum();
                for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    if (currentLOI != aLOI) continue;
                    currentLOI.setHighlighted(highlight);
                }
            }
        }
    }

    private void addLOI(LOIShape aLOI) {
        aLOI.setSliceDirection(this.sliceDirection);
        int slice = aLOI.getSliceNum();
        if (this.shapes[slice] == null) {
            this.shapes[slice] = aLOI;
        } else {
            LOIShape current = this.shapes[slice];
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(aLOI);
        }
    }

    private void addStaticLOI(LOIShape aLOI) {
        aLOI.setSliceDirection(this.sliceDirection);
        if (this.staticShapes == null) {
            this.staticShapes = aLOI;
        } else {
            LOIShape current = this.staticShapes;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(aLOI);
        }
    }

    private void removeLOI(LOIShape aLOI) {
        boolean isStatic = aLOI.isPermanent();
        LOIShape previousLOI = null;
        if (isStatic) {
            for (LOIShape currentLOI = this.staticShapes; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (currentLOI == aLOI) {
                    if (previousLOI != null) {
                        previousLOI.setNext(currentLOI.getNext());
                    } else {
                        this.staticShapes = currentLOI.getNext();
                    }
                }
                previousLOI = currentLOI;
            }
        } else {
            int slice = aLOI.getSliceNum();
            for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (currentLOI == aLOI) {
                    if (previousLOI != null) {
                        previousLOI.setNext(currentLOI.getNext());
                    } else {
                        this.shapes[slice] = currentLOI.getNext();
                    }
                }
                previousLOI = currentLOI;
            }
        }
    }
}

