/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.manager;

import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.ShapesManager;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class LOIManager
implements ShapesManager {
    private boolean hasRedo;
    private boolean hasUndo;
    private boolean isDirty;
    private boolean isUsed;
    private final LineListener listener;
    private final LineUser user;
    private final LOIShape[] shapes;
    private final LOIShape[] undoShapes;
    private final int sliceDirection;
    private final int numSlices;
    public static final int LOI_HEADER_SIZE = 4;
    public static final short LOI_HEADER = -9999;

    public LOIManager(int numSlices, int sliceDirection, LineListener listener, LineUser user) {
        this.numSlices = numSlices;
        this.sliceDirection = sliceDirection;
        this.listener = listener;
        this.user = user;
        this.shapes = new LOIShape[numSlices];
        this.undoShapes = new LOIShape[numSlices];
    }

    public void addLOI(LOIShape aLOI) {
        this.addLOI(aLOI, true);
    }

    public void addLOI(LOIShape aLOI, boolean storeUndo) {
        this.addLOI(aLOI, storeUndo, false);
    }

    public void addLOI(LOIShape aLOI, boolean storeUndo, boolean notify) {
        int slice;
        aLOI.setSliceDirection(this.sliceDirection);
        if (storeUndo) {
            this.storeUndoCopy();
            this.hasUndo = true;
            this.hasRedo = false;
        }
        if (this.shapes[slice = aLOI.getSliceNum()] == null) {
            this.shapes[slice] = aLOI;
        } else {
            LOIShape current = this.shapes[slice];
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(aLOI);
        }
        if (notify) {
            this.listener.shapeAdded(aLOI);
        }
        this.isDirty = true;
        this.isUsed = true;
    }

    public Shape addShape(Shape aShape, int aSlice, int aColor) {
        return this.addShape(aShape, aSlice, aColor, true);
    }

    public void clearSelectedLOIs() {
        this.storeUndoCopy();
        this.hasUndo = true;
        this.hasRedo = false;
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape currentLOI = this.shapes[ctr]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (!currentLOI.isSelected()) continue;
                this.removeLOI(currentLOI);
            }
        }
        this.isDirty = true;
        if (this.listener != null) {
            this.listener.shapeSelectionChanged();
        }
    }

    public void clearSelectedLOIsInSlice(int slice) {
        this.storeUndoCopy();
        this.hasUndo = true;
        this.hasRedo = false;
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (!currentLOI.isSelected()) continue;
            this.removeLOI(currentLOI);
        }
        this.isDirty = true;
        if (this.listener != null) {
            this.listener.shapeSelectionChanged();
        }
    }

    public boolean containsLOI(LOIShape loi) {
        int slice = loi.getSliceNum();
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (currentLOI != loi) continue;
            return true;
        }
        return false;
    }

    public void convexHull(LOIShape line) {
        this.storeUndoCopy();
        this.hasUndo = true;
        this.hasRedo = false;
        line.convexHull();
        this.isDirty = true;
        this.isUsed = true;
    }

    public void deleteLine(LOIShape line) {
        this.storeUndoCopy();
        this.hasUndo = true;
        this.hasRedo = false;
        this.removeLOI(line, true);
        this.isDirty = true;
        this.isUsed = true;
    }

    public void deselectAll() {
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape currentLOI = this.shapes[ctr]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                currentLOI.setSelectedState(false);
            }
        }
    }

    public Vector<LOIShape> findAllLOIsWithinBounds(Rectangle bounds, int slice) {
        Vector<LOIShape> lois = new Vector<LOIShape>();
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (!bounds.contains(currentLOI.getBounds())) continue;
            lois.add(currentLOI);
        }
        return lois;
    }

    public LOIShape[][] getAll() {
        LOIShape[][] returningLOIs = new LOIShape[this.numSlices][];
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            returningLOIs[ctr] = this.getAllInSlice(ctr);
        }
        return returningLOIs;
    }

    public String getAllLabelsForColor(int colorIndex) {
        StringBuffer sb = new StringBuffer("");
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape current = this.shapes[ctr]; current != null; current = current.getNext()) {
                if (current.getColor() != colorIndex) continue;
                sb.append(current.getLabel(true));
                sb.append("<br>");
            }
        }
        return sb.toString();
    }

    public LOIShape[] getAllSelected() {
        int count = 0;
        LOIShape[][] returningLOIs = new LOIShape[this.numSlices][];
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            returningLOIs[ctr] = this.getAllSelectedInSlice(ctr);
            if (returningLOIs[ctr] == null) continue;
            count += returningLOIs[ctr].length;
        }
        LOIShape[] allSelected = null;
        if (count > 0) {
            allSelected = new LOIShape[count];
            int index = 0;
            for (int ctr = 0; ctr < this.numSlices; ++ctr) {
                if (returningLOIs[ctr] == null) continue;
                for (int ctrInner = 0; ctrInner < returningLOIs[ctr].length; ++ctrInner) {
                    allSelected[index++] = returningLOIs[ctr][ctrInner];
                }
            }
        }
        return allSelected;
    }

    public LOIShape[] getAllSelectedClone() {
        LOIShape[] allSelected = new LOIShape[this.numSlices];
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            allSelected[ctr] = this.getAllSelectedCloneInSlice(ctr);
        }
        return allSelected;
    }

    public LOIShape[] getAllSelectedInSlice(int slice) {
        LOIShape[] returningLOIs = null;
        int num = 0;
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (!currentLOI.isSelected()) continue;
            ++num;
        }
        if (num > 0) {
            int ctr = 0;
            returningLOIs = new LOIShape[num];
            for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (!currentLOI.isSelected()) continue;
                returningLOIs[ctr++] = currentLOI;
            }
        }
        return returningLOIs;
    }

    public int getCount(int aSlice, int aColor) {
        int num = 0;
        for (LOIShape current = this.shapes[aSlice]; current != null; current = current.getNext()) {
            if (current.getColor() != aColor) continue;
            ++num;
        }
        return num;
    }

    public byte[] getData() {
        if (!this.hasShapes()) {
            return null;
        }
        ByteBuffer buffer = null;
        try {
            int n;
            int count = 0;
            LOIShape[] lOIShapeArray = this.shapes;
            int n2 = lOIShapeArray.length;
            for (n = 0; n < n2; ++n) {
                LOIShape shape;
                for (LOIShape currentLOI = shape = lOIShapeArray[n]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    count += currentLOI.getNumPoints() * 2 + 3;
                }
            }
            buffer = ByteBuffer.allocate(count * 2);
            double[] segment = new double[4];
            LOIShape[] lOIShapeArray2 = this.shapes;
            n = lOIShapeArray2.length;
            for (int i = 0; i < n; ++i) {
                LOIShape shape;
                for (LOIShape currentLOI = shape = lOIShapeArray2[i]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    buffer.putShort((short)-9999);
                    buffer.putShort((short)currentLOI.getSliceNum());
                    buffer.putShort((short)(currentLOI.getColor() | (currentLOI.isClosed() ? 256 : 0) | (currentLOI.isPOI() ? 512 : 0)));
                    if (!currentLOI.isPOI()) {
                        PathIterator it = currentLOI.getPathIterator(null);
                        while (!it.isDone()) {
                            boolean closed;
                            boolean bl = closed = it.currentSegment(segment) == 4;
                            if (!closed) {
                                buffer.putShort((short)segment[0]);
                                buffer.putShort((short)segment[1]);
                            }
                            it.next();
                        }
                        continue;
                    }
                    Point startPoint = currentLOI.getStartPoint();
                    buffer.putShort((short)startPoint.x);
                    buffer.putShort((short)startPoint.y);
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return buffer.array();
    }

    public LOIShape getFirstShape(int color) {
        LOIShape[] lOIShapeArray = this.shapes;
        int n = lOIShapeArray.length;
        for (int i = 0; i < n; ++i) {
            LOIShape shape;
            for (LOIShape currentLOI = shape = lOIShapeArray[i]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (color != currentLOI.getColor()) continue;
                return currentLOI;
            }
        }
        return null;
    }

    public int getMainSliceDirection() {
        return this.user.getSliceDirection();
    }

    public int getMainSliceNumber() {
        return this.user.getSliceNumber();
    }

    public LOIShape getNextShape(int startSlice, LOIShape shape) {
        int foundIndex = -1;
        for (int ctr = 0; ctr < this.shapes.length; ++ctr) {
            for (LOIShape currentLOI = this.shapes[ctr]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (foundIndex != -1 && shape.getColor() == currentLOI.getColor()) {
                    return currentLOI;
                }
                if (currentLOI != shape) continue;
                foundIndex = ctr;
            }
        }
        return null;
    }

    public List<Line> getUsedLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            LOIShape[] shapes = this.getAllInSlice(ctr);
            if (!CollectionUtilities.isNotEmpty((Object)shapes)) continue;
            for (LOIShape shape : shapes) {
                lines.add(shape);
            }
        }
        return lines;
    }

    public List<Line> getSelectedLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            LOIShape[] shapes = this.getAllSelectedInSlice(ctr);
            if (!CollectionUtilities.isNotEmpty((Object)shapes)) continue;
            for (LOIShape shape : shapes) {
                lines.add(shape);
            }
        }
        return lines;
    }

    public LOIShape getShape(int slice) {
        if (slice < 0 || slice >= this.shapes.length) {
            return null;
        }
        return this.shapes[slice];
    }

    public Shape[] getShapes(int aSlice, int aColor) {
        Shape[] shapesToReturn = null;
        int num = this.getCount(aSlice, aColor);
        if (num > 0) {
            shapesToReturn = new Shape[num];
            int ctr = 0;
            for (LOIShape current = this.shapes[aSlice]; current != null; current = current.getNext()) {
                if (current.getColor() != aColor) continue;
                shapesToReturn[ctr++] = current;
            }
        }
        return shapesToReturn;
    }

    public int getSlices() {
        return this.numSlices;
    }

    public LineListener getListener() {
        return this.listener;
    }

    public LineUser getUser() {
        return this.user;
    }

    public double getXSize() {
        return this.user.getXSize(this.sliceDirection);
    }

    public double getYSize() {
        return this.user.getYSize(this.sliceDirection);
    }

    public boolean hasLabels() {
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape current = this.shapes[ctr]; current != null; current = current.getNext()) {
                if (!StringUtils.isNotBlank((CharSequence)current.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRedo() {
        return this.hasRedo;
    }

    public boolean hasSelectedShapes() {
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape currentLOI = this.shapes[ctr]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                if (!currentLOI.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasShapes() {
        for (LOIShape shape : this.shapes) {
            if (shape == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasShapes(int slice) {
        return this.shapes[slice] != null;
    }

    public boolean hasUndo() {
        return this.hasUndo;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void notifySelectionChanged() {
        this.listener.shapeSelectionChanged();
    }

    public void putData(byte[] someData) {
        Path2D path = null;
        short slice = 0;
        int color = 0;
        boolean isClosed = false;
        short current = 0;
        ByteBuffer buffer = ByteBuffer.wrap(someData);
        try {
            while (buffer.hasRemaining()) {
                current = buffer.getShort();
                if (current == -9999) {
                    if (path == null) {
                        path = new GeneralPath();
                    } else {
                        LOIShape aShape = null;
                        if (isClosed) {
                            path.closePath();
                        }
                        aShape = new LOIShape(((Path2D.Float)path).getPathIterator(null), slice, color, this.listener, this.user);
                        this.addLOI(aShape);
                        path = new GeneralPath();
                    }
                    slice = buffer.getShort();
                    short temp = buffer.getShort();
                    color = temp & 0xFF;
                    isClosed = (temp >>> 8 & 1) == 1;
                    ((Path2D.Float)path).moveTo(buffer.getShort(), buffer.getShort());
                    continue;
                }
                ((Path2D.Float)path).lineTo(current, buffer.getShort());
            }
            LOIShape aShape = null;
            if (isClosed) {
                path.closePath();
            }
            aShape = new LOIShape(((Path2D.Float)path).getPathIterator(null), slice, color, this.listener, this.user);
            this.addLOI(aShape);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public static int countData(byte[] someData) {
        Path2D path = null;
        boolean isClosed = false;
        short current = 0;
        int count = 0;
        ByteBuffer buffer = ByteBuffer.wrap(someData);
        try {
            while (buffer.hasRemaining()) {
                current = buffer.getShort();
                if (current == -9999) {
                    if (path == null) {
                        path = new GeneralPath();
                    } else {
                        if (isClosed) {
                            path.closePath();
                        }
                        ++count;
                        path = new GeneralPath();
                    }
                    buffer.getShort();
                    short temp = buffer.getShort();
                    isClosed = (temp >>> 8 & 1) == 1;
                    ((Path2D.Float)path).moveTo(buffer.getShort(), buffer.getShort());
                    continue;
                }
                ((Path2D.Float)path).lineTo(current, buffer.getShort());
            }
            if (isClosed) {
                path.closePath();
            }
            ++count;
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return count;
    }

    public void redoLOI() {
        int ctr;
        this.hasUndo = true;
        this.hasRedo = false;
        LOIShape[] oldUndoShapes = new LOIShape[this.numSlices];
        for (ctr = 0; ctr < this.numSlices; ++ctr) {
            oldUndoShapes[ctr] = this.undoShapes[ctr];
        }
        this.storeUndoCopy();
        for (ctr = 0; ctr < this.numSlices; ++ctr) {
            this.shapes[ctr] = oldUndoShapes[ctr];
        }
        this.isDirty = true;
        this.deselectAll();
        if (this.listener != null) {
            this.listener.shapeSelectionChanged();
        }
        if (this.user != null) {
            this.user.updateAllLines();
        }
    }

    public void removeLOI(LOIShape aLOI, boolean notify) {
        int slice = aLOI.getSliceNum();
        LOIShape previousLOI = null;
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (currentLOI == aLOI) {
                if (previousLOI != null) {
                    previousLOI.setNext(currentLOI.getNext());
                } else {
                    this.shapes[slice] = currentLOI.getNext();
                }
            }
            previousLOI = currentLOI;
        }
        this.isDirty = true;
        if (notify && this.listener != null) {
            this.listener.shapeDeleted(aLOI);
        }
    }

    public void removeShape(Shape aShape) {
        if (aShape instanceof LOIShape) {
            this.removeLOI((LOIShape)aShape);
        }
    }

    public void resetClipboards() {
        this.hasRedo = false;
        this.hasUndo = false;
    }

    public void selectAll() {
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            for (LOIShape currentLOI = this.shapes[ctr]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                currentLOI.setSelectedState(true);
            }
        }
    }

    public void setDirty(boolean bool) {
        this.isDirty = bool;
    }

    public void smoothLine(LOIShape line) {
        this.storeUndoCopy();
        this.hasUndo = true;
        this.hasRedo = false;
        line.smooth();
        this.isDirty = true;
        this.isUsed = true;
    }

    public void storeUndoCopy() {
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            if (this.shapes[ctr] != null) {
                this.undoShapes[ctr] = new LOIShape(this.shapes[ctr]);
                LOIShape currentUndoShapes = this.undoShapes[ctr];
                for (LOIShape currentLOI = this.shapes[ctr].getNext(); currentLOI != null; currentLOI = currentLOI.getNext()) {
                    currentUndoShapes.setNext(new LOIShape(currentLOI));
                    currentUndoShapes = currentUndoShapes.getNext();
                }
                continue;
            }
            this.undoShapes[ctr] = null;
        }
    }

    public void translate(int aSlice, int xTrans, int yTrans, int aColor) {
        boolean storedCopy = false;
        LOIShape[] someLOIs = this.getAllSelectedInSlice(aSlice);
        if (someLOIs != null) {
            for (LOIShape someLOI : someLOIs) {
                if (someLOI.getColor() != aColor) continue;
                if (!storedCopy) {
                    this.storeUndoCopy();
                    storedCopy = true;
                    this.hasUndo = true;
                    this.hasRedo = false;
                    this.isDirty = true;
                }
                someLOI.translate(xTrans, yTrans);
                if (this.listener == null) continue;
                this.listener.shapeSelectionChanged();
            }
        }
    }

    public void undoLOI() {
        int ctr;
        this.hasUndo = false;
        this.hasRedo = true;
        LOIShape[] oldUndoShapes = new LOIShape[this.numSlices];
        for (ctr = 0; ctr < this.numSlices; ++ctr) {
            oldUndoShapes[ctr] = this.undoShapes[ctr];
        }
        this.storeUndoCopy();
        for (ctr = 0; ctr < this.numSlices; ++ctr) {
            this.shapes[ctr] = oldUndoShapes[ctr];
        }
        this.isDirty = true;
        this.deselectAll();
        if (this.listener != null) {
            this.listener.shapeSelectionChanged();
        }
        if (this.user != null) {
            this.user.updateAllLines();
        }
    }

    public void updateStateLOIChanged() {
        this.isDirty = true;
        this.hasUndo = true;
        this.hasRedo = false;
        this.isUsed = true;
    }

    private LOIShape addShape(Shape aShape, int aSlice, int aColor, boolean storeUndo) {
        LOIShape shape = new LOIShape(aShape.getPathIterator(null), aSlice, aColor, this.listener, this.user);
        this.addLOI(shape, storeUndo);
        return shape;
    }

    private LOIShape[] getAllInSlice(int slice) {
        LOIShape[] returningLOIs = null;
        int num = 0;
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            ++num;
        }
        if (num > 0) {
            int ctr = 0;
            returningLOIs = new LOIShape[num];
            for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                returningLOIs[ctr++] = currentLOI;
            }
        }
        return returningLOIs;
    }

    private LOIShape getAllSelectedCloneInSlice(int slice) {
        LOIShape returningLOIs = null;
        LOIShape currentReturningLOI = null;
        for (LOIShape currentLOI = this.shapes[slice]; currentLOI != null; currentLOI = currentLOI.getNext()) {
            if (!currentLOI.isSelected()) continue;
            if (returningLOIs == null) {
                currentReturningLOI = returningLOIs = new LOIShape(currentLOI);
                continue;
            }
            LOIShape tempLOIShape = new LOIShape(currentLOI);
            currentReturningLOI.setNext(tempLOIShape);
            currentReturningLOI = tempLOIShape;
        }
        return returningLOIs;
    }

    private void removeLOI(LOIShape aLOI) {
        this.removeLOI(aLOI, true);
    }

    public void reflect(int axis, boolean vertical, int color, boolean onlySelected) {
        Vector<LOIShape> shapesNew = new Vector<LOIShape>();
        int xScale = vertical ? -1 : 1;
        int yScale = vertical ? 1 : -1;
        int xTrans = vertical ? axis * 2 : 0;
        int yTrans = vertical ? 0 : axis * 2;
        AffineTransform reflection = new AffineTransform(xScale, 0.0f, 0.0f, yScale, xTrans, yTrans);
        for (int ctr = 0; ctr < this.numSlices; ++ctr) {
            if (!this.hasShapes(ctr)) continue;
            for (LOIShape shape = this.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                LOIShape shapeNew = new LOIShape(reflection.createTransformedShape(shape).getPathIterator(null), ctr, color, this.getListener(), this.getUser());
                shape.setSelectedState(true);
                shapeNew.setSelectedState(false);
                shapesNew.add(shapeNew);
            }
        }
        this.storeUndoCopy();
        this.updateStateLOIChanged();
        int size = shapesNew.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            this.addLOI((LOIShape)shapesNew.elementAt(ctr), false);
        }
    }

    public void reflectSlice(int axis, boolean vertical, int sliceNum, int color, boolean onlySelected) {
        Vector<LOIShape> shapesNew = new Vector<LOIShape>();
        int xScale = vertical ? -1 : 1;
        int yScale = vertical ? 1 : -1;
        int xTrans = vertical ? axis * 2 : 0;
        int yTrans = vertical ? 0 : axis * 2;
        AffineTransform reflection = new AffineTransform(xScale, 0.0f, 0.0f, yScale, xTrans, yTrans);
        if (this.hasShapes(sliceNum)) {
            for (LOIShape shape = this.getShape(sliceNum); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                LOIShape shapeNew = new LOIShape(reflection.createTransformedShape(shape).getPathIterator(null), sliceNum, color, this.getListener(), this.getUser());
                shape.setSelectedState(true);
                shapeNew.setSelectedState(false);
                shapesNew.add(shapeNew);
            }
        }
        this.storeUndoCopy();
        this.updateStateLOIChanged();
        int size = shapesNew.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            this.addLOI((LOIShape)shapesNew.elementAt(ctr), false);
        }
    }
}

