/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import edu.uthscsa.ric.roi.ROIColor;
import java.util.Vector;

public final class ROIDefaultLabels {
    public static final String TEXT_OF = " of ";
    public static final String TEXT_COLOR = "Color ";
    public static final Vector<ROIColor> COLORS_8BIT = ROIColor.getColorsDisplayOrder(1);
    public static final Vector<ROIColor> COLORS_16BIT = ROIColor.getColorsDisplayOrder(2);
    public static final Vector<ROIColor> COLORS_32BIT = ROIColor.getColorsDisplayOrder(4);
    public static final Vector<ROIColor> COLORS_64BIT = ROIColor.getColorsDisplayOrder(8);

    private ROIDefaultLabels() {
    }

    public static String getDefaultLabelBitPlaneOrder(int color, int maxColors) {
        if (maxColors == 8) {
            return TEXT_COLOR + (ROIDefaultLabels.findColorPosition(COLORS_8BIT, color) + 1) + TEXT_OF + maxColors;
        }
        if (maxColors == 16) {
            return TEXT_COLOR + (ROIDefaultLabels.findColorPosition(COLORS_16BIT, color) + 1) + TEXT_OF + maxColors;
        }
        if (maxColors == 32) {
            return TEXT_COLOR + (ROIDefaultLabels.findColorPosition(COLORS_32BIT, color) + 1) + TEXT_OF + maxColors;
        }
        if (maxColors == 64) {
            return TEXT_COLOR + (ROIDefaultLabels.findColorPosition(COLORS_64BIT, color) + 1) + TEXT_OF + maxColors;
        }
        return "";
    }

    public static String getDefaultLabelDisplayOrder(int index, int maxColors) {
        return TEXT_COLOR + (index + 1) + TEXT_OF + maxColors;
    }

    private static int findColorPosition(Vector<ROIColor> colors, int color) {
        for (ROIColor roiColor : colors) {
            if (roiColor.getIndex() != color) continue;
            return colors.indexOf(roiColor);
        }
        return -1;
    }
}

