/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import edu.uthscsa.ric.roi.EquivalentSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class EquivalentSetManager {
    protected Vector<EquivalentSet> allSets = new Vector();
    protected Vector<EquivalentSet> setMap = new Vector();
    protected Vector<Integer> counts;

    public EquivalentSetManager() {
        this(false);
    }

    public EquivalentSetManager(boolean doCounts) {
        if (doCounts) {
            this.counts = new Vector();
        }
    }

    public void addPair(int first, int second) {
        EquivalentSet foundFirst = this.setMap.get(first);
        EquivalentSet foundSecond = this.setMap.get(second);
        if (foundFirst != null && foundSecond != null) {
            if (foundFirst != foundSecond) {
                foundFirst.unionSets(foundSecond, this);
                int index = -1;
                for (int ctr = 0; ctr < this.allSets.size(); ++ctr) {
                    if (this.allSets.get(ctr) != foundSecond) continue;
                    index = ctr;
                    break;
                }
                foundSecond = null;
                if (index != -1) {
                    this.allSets.remove(index);
                }
            }
        } else if (foundFirst != null) {
            foundFirst.addLabel(second);
            this.setMap.set(second, foundFirst);
        } else if (foundSecond != null) {
            foundSecond.addLabel(first);
            this.setMap.set(first, foundSecond);
        } else {
            EquivalentSet set = new EquivalentSet();
            if (first == second) {
                set.labels.add(first);
                this.setMap.set(first, set);
            } else {
                if (first < second) {
                    set.labels.add(first);
                    set.labels.add(second);
                } else {
                    set.labels.add(second);
                    set.labels.add(first);
                }
                this.setMap.set(first, set);
                this.setMap.set(second, set);
            }
            this.allSets.add(set);
        }
    }

    public void addStartVal(int val) {
        EquivalentSet set = new EquivalentSet();
        set.labels.add(val);
        this.allSets.add(set);
        this.setMap.add(null);
        this.setMap.add(null);
        if (this.counts != null) {
            this.counts.add(0);
            this.counts.add(0);
        }
        this.setMap.set(val, set);
    }

    public void count(int val) {
        if (this.counts != null) {
            this.counts.set(val, this.counts.get(val) + 1);
        }
    }

    public Vector<EquivalentSet> getAllSets() {
        return this.allSets;
    }

    public Vector<EquivalentSet> getAllSetsOrdered() {
        Vector<EquivalentSet> orderedSet = new Vector<EquivalentSet>(this.allSets);
        Collections.sort(orderedSet, new EquivalentSetComparator());
        return orderedSet;
    }

    public int getCountsInSet(EquivalentSet es) {
        int sum = 0;
        Iterator<Integer> it = es.labels.iterator();
        while (it.hasNext()) {
            sum += this.counts.get(it.next()).intValue();
        }
        return sum;
    }

    public int getLargestClusterSize() {
        int size = 0;
        for (EquivalentSet es : this.allSets) {
            int count = this.getCountsInSet(es);
            if (count <= size) continue;
            size = count;
        }
        return size;
    }

    public int getNumClusters() {
        return this.setMap.size();
    }

    public int getNumLabels() {
        return this.counts.size();
    }

    public int getNumNonZeroClusters() {
        int size = 0;
        for (EquivalentSet es : this.allSets) {
            int count = this.getCountsInSet(es);
            if (count <= 0) continue;
            ++size;
        }
        return size;
    }

    public EquivalentSet getSeedSet(int seed) {
        return this.setMap.get(seed);
    }

    public void incrementSetMap() {
        this.setMap.add(null);
        if (this.counts != null) {
            this.counts.add(0);
        }
    }

    class EquivalentSetComparator
    implements Comparator<EquivalentSet> {
        EquivalentSetComparator() {
        }

        @Override
        public int compare(EquivalentSet o1, EquivalentSet o2) {
            return EquivalentSetManager.this.getCountsInSet(o2) - EquivalentSetManager.this.getCountsInSet(o1);
        }
    }
}

