/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.screen;

import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.primitives.Overlay;
import java.nio.FloatBuffer;

public class SurfaceOverlay
implements Overlay {
    private FloatBuffer[] scalars;
    private ScreenVolume overlay;
    private String colorTableName;
    private boolean building;
    private int alpha;
    private float max;
    private float min;
    private final int numParts;

    public SurfaceOverlay(FloatBuffer scalars, float min, float max, String colorTableName) {
        this.numParts = 1;
        this.min = min;
        this.max = max;
        this.scalars = new FloatBuffer[]{scalars};
        this.colorTableName = colorTableName;
    }

    public SurfaceOverlay(FloatBuffer[] scalars, float min, float max, String colorTableName) {
        this.numParts = scalars.length;
        this.min = min;
        this.max = max;
        this.scalars = scalars;
        this.colorTableName = colorTableName;
    }

    public SurfaceOverlay(ScreenVolume overlay, int numParts) {
        this.numParts = numParts;
        this.overlay = overlay;
        this.scalars = new FloatBuffer[numParts];
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String getColorTableName() {
        if (this.overlay != null) {
            return this.overlay.getLookupTableManager().getName();
        }
        return this.colorTableName;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public ScreenVolume getOverlay() {
        return this.overlay;
    }

    public FloatBuffer[] getScalars() {
        return this.scalars;
    }

    public FloatBuffer getScalars(int index) {
        return this.scalars[index];
    }

    public FloatIterator getScalarsIterator() {
        return new FloatIterator(this.scalars);
    }

    public int getScalarsSize() {
        int count = 0;
        for (int ctr = 0; ctr < this.numParts; ++ctr) {
            count += this.scalars[ctr].capacity();
        }
        return count;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setBuilding(boolean building) {
        this.building = building;
    }

    public void setColorTableName(String colorTableName) {
        this.colorTableName = colorTableName;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setOverlay(ScreenVolume overlay) {
        this.overlay = overlay;
    }

    public void setScalars(FloatBuffer buf, int index) {
        this.scalars[index] = buf;
    }

    public void clear() {
        this.overlay = null;
        this.scalars = null;
    }
}

