/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats.vtk;

import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.NormalsGenerator;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.DateUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.io.IndexIterator;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VTKFormat
implements SurfaceFormat,
Cloneable {
    private FloatBuffer normalsBuffer;
    private FloatBuffer pointsBuffer;
    private IntBuffer indicesBuffer;
    private JComboBox<Surface> volBox;
    private JRadioButton binButton;
    private JRadioButton textButton;
    private String dataset;
    private String description;
    private String imageTitle = "Surface";
    private String vtkFileFormatVersion;
    private boolean ascii;
    private float threshold = Float.MIN_VALUE;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final String[] FLOAT = new String[]{"float"};
    private static final int MAX_DESCRIPTION_SIZE = 256;
    public static final String ASCII = "ASCII";
    public static final String BINARY = "BINARY";
    public static final String COLOR_SCALARS = "COLOR_SCALARS";
    public static final String DATASET = "DATASET";
    public static final String DESCRIPTION_DEFAULT = "vtk output";
    public static final String EXTENSION = "vtk";
    public static final String FORMAT_6G = "%.6g ";
    public static final String LOOKUP_TABLE = "LOOKUP_TABLE";
    public static final String LOOKUP_TABLE_DEFAULT = "default";
    public static final String MAGIC_NUMBER = "# vtk DataFile Version";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_IMAGETHRESHOLD = "ImageThreshold";
    public static final String METADATA_IMAGETITLE = "ImageTitle";
    public static final String METADATA_MANGOVERSION = "MangoVersion";
    public static final String MIN_MANGO_SUPPORTED = "3";
    public static final String NAME = "VTK";
    public static final String NORMALS = "NORMALS";
    public static final String POINTS = "POINTS";
    public static final String POINT_DATA = "POINT_DATA";
    public static final String POLYDATA = "POLYDATA";
    public static final String POLYGONS = "POLYGONS";
    public static final String SCALARS = "SCALARS";
    public static final String VERSION = "1";
    public static final String VTK_VERSION_DEFAULT = "3.0";

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOptions() {
        StringBuffer sb = new StringBuffer();
        sb.append("Text=").append(this.textButton.isSelected());
        return sb.toString();
    }

    @Deprecated
    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, SurfaceController controller) {
        return this.getOptionsPanel(data, shapes, (VolumeManager)controller.getViewerController());
    }

    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, VolumeManager controller) {
        this.volBox = new JComboBox<Surface>(data);
        JPanel volPanel = new JPanel();
        volPanel.setLayout(new BoxLayout(volPanel, 0));
        volPanel.add(Box.createHorizontalStrut(4));
        volPanel.add(new JLabel("Select Surface:"));
        volPanel.add(this.volBox);
        volPanel.add(Box.createHorizontalStrut(4));
        JPanel optionsPanel = new JPanel();
        this.textButton = new JRadioButton("Text");
        this.binButton = new JRadioButton("Binary");
        JLabel formatLabel = new JLabel("Select Format:");
        ButtonGroup group = new ButtonGroup();
        group.add(this.textButton);
        group.add(this.binButton);
        this.textButton.setSelected(true);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.add(Box.createHorizontalStrut(4));
        optionsPanel.add(formatLabel);
        optionsPanel.add(this.textButton);
        optionsPanel.add(this.binButton);
        optionsPanel.add(Box.createHorizontalStrut(4));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(volPanel);
        mainPanel.add(optionsPanel);
        return mainPanel;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return EXTENSION;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getVtkFileFormatVersion() {
        return this.vtkFileFormatVersion;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            if (line == null || line.indexOf(MAGIC_NUMBER) == -1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return true;
    }

    @Deprecated
    public Surface[] readSurfaceFile(File file, ViewerController controller, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException {
        return this.readSurface(file, (VolumeManager)controller, false);
    }

    public Surface[] readSurfaceFile(File file, VolumeManager controller, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException {
        return this.readSurface(file, controller, false);
    }

    public Surface[] readSurfaceHeader(File file, Vector<Shape> shapes) throws SurfaceFormatException {
        return this.readSurface(file, null, true);
    }

    public void setOptions(String options) {
        boolean value = Boolean.parseBoolean(options.substring(options.indexOf(61) + 1));
        this.textButton.setSelected(value);
        this.binButton.setSelected(!value);
    }

    @Deprecated
    public void writeSurfaceFile(File file, Surface[] data, Shape[] shapes, SurfaceController controller) {
        this.writeSurfaceFile(file, data, shapes, (VolumeManager)controller.getViewerController());
    }

    public void writeSurfaceFile(File file, Surface[] data, Shape[] shapes, VolumeManager controller) {
        Surface surface = (Surface)this.volBox.getSelectedItem();
        try {
            boolean ascii = this.textButton.isSelected();
            this.writeHeader(file, ascii, surface, controller);
            float[] offsets = this.calculateFreeSurferOffsets(controller);
            this.writePoints(file, controller, surface, ascii, offsets[0], offsets[1], offsets[2]);
            this.writeTriangles(file, surface, ascii);
            this.writePointDataHeader(file, surface);
            this.writeNormals(file, surface, ascii);
            if (surface.getOverlays() != null && surface.getOverlays().length > 0) {
                this.writeScalarsData(file, surface, ascii);
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private float[] calculateFreeSurferOffsets(VolumeManager controller) {
        Coordinate offsets = controller.getBaseVolume().getCenter();
        String orientation = controller.getBaseVolume().getOrientationString();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int colFlip = (orientation.charAt(3) == '-' ? 1 : -1) * (vd.isFlip() ? -1 : 1);
        int rowFlip = orientation.charAt(4) == '-' ? 1 : -1;
        int sliceFlip = orientation.charAt(5) == '-' ? 1 : -1;
        double xDiff = (double)colFlip * offsets.xDbl * vd.getXSize();
        double yDiff = (double)rowFlip * offsets.yDbl * vd.getYSize();
        double zDiff = (double)sliceFlip * offsets.zDbl * vd.getZSize();
        return new float[]{(float)xDiff, (float)yDiff, (float)zDiff};
    }

    private String createDescription(Surface baseSurface, VolumeManager controller) {
        String description = "vtk output ImageThreshold=" + baseSurface.getThreshold() + " " + METADATA_IMAGETITLE + "=" + controller.toString() + " " + METADATA_DATE + "=" + DateUtilities.today() + " " + METADATA_MANGOVERSION + "=" + controller.getVersion();
        if (description.length() > 256) {
            description = description.substring(0, 256);
        }
        return description;
    }

    private boolean isNormalsHeader(String line) {
        return line.startsWith(NORMALS);
    }

    private boolean isPointsHeader(String line) {
        return line.startsWith(POINTS);
    }

    private boolean isPolygonsHeader(String line) {
        return line.startsWith(POLYGONS);
    }

    private void parseDataset(String line) {
        this.dataset = line.substring(DATASET.length() + 1);
    }

    private void parseDescription(String line) {
        int titleIndex;
        this.description = line;
        int thresholdIndex = this.description.indexOf(METADATA_IMAGETHRESHOLD);
        if (thresholdIndex != -1) {
            try {
                int start = thresholdIndex + METADATA_IMAGETHRESHOLD.length() + 1;
                String thresholdStr = this.description.substring(start, this.description.indexOf(32, start));
                this.threshold = Float.parseFloat(thresholdStr);
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
        }
        if ((titleIndex = this.description.indexOf(METADATA_IMAGETITLE)) != -1) {
            int start = titleIndex + METADATA_IMAGETITLE.length() + 1;
            this.imageTitle = this.description.substring(start, this.description.indexOf(32, start));
        }
    }

    private void parseFileType(String line) {
        this.ascii = line.indexOf(ASCII) != -1;
    }

    private int parsePointsHeader(String line) {
        Vector tokens = StringUtilities.makeStringTokens((String)line);
        return Integer.parseInt((String)tokens.get(1));
    }

    private int parsePolygonsHeader(String line) {
        Vector tokens = StringUtilities.makeStringTokens((String)line);
        return Integer.parseInt((String)tokens.get(1));
    }

    private void parseVersion(String line) {
        this.vtkFileFormatVersion = line.substring(MAGIC_NUMBER.length() + 1);
    }

    private void readBinary(File file, VolumeManager controller, boolean headerOnly, int[] numData) throws SurfaceFormatException {
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer inputBuffer = outputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            this.parseVersion(this.readString(inputBuffer));
            this.parseDescription(this.readString(inputBuffer));
            this.readString(inputBuffer);
            this.parseDataset(this.readString(inputBuffer));
            if (!POLYDATA.equals(this.dataset)) {
                throw new SurfaceFormatException("Only POLYDATA format is currently supported");
            }
            int pos = 0;
            int capacity = inputBuffer.capacity();
            while (inputBuffer.position() < capacity) {
                String string = this.readString(inputBuffer);
                if (this.isPointsHeader(string)) {
                    numData[0] = this.parsePointsHeader(string);
                    if (headerOnly) {
                        break;
                    }
                    float[] offsets = this.calculateFreeSurferOffsets(controller);
                    pos = this.readPointsBinary(inputBuffer.asFloatBuffer(), controller, numData[0], offsets[0], offsets[1], offsets[2]);
                    inputBuffer.position(pos * 4 + inputBuffer.position());
                    continue;
                }
                if (this.isPolygonsHeader(string)) {
                    numData[1] = this.parsePolygonsHeader(string);
                    if (headerOnly) {
                        break;
                    }
                    pos = this.readPolygonsBinary(inputBuffer.asIntBuffer(), numData[1]);
                    inputBuffer.position(pos * 4 + inputBuffer.position());
                    continue;
                }
                if (!this.isNormalsHeader(string)) continue;
                pos = this.readNormalsBinary(inputBuffer.asFloatBuffer(), numData[0]);
                inputBuffer.position(pos * 4 + inputBuffer.position());
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                if (outputChannel != null) {
                    outputChannel.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    private void readNormals(BufferedReader reader, int numPoints) throws IOException {
        int index = 0;
        int compIndex = 0;
        String line = reader.readLine();
        int numPointValues = numPoints * 3;
        ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
        normalsBufferByte.order(ByteOrder.nativeOrder());
        this.normalsBuffer = normalsBufferByte.asFloatBuffer();
        while (line != null) {
            Vector tokens = StringUtilities.makeStringTokens((String)line);
            for (String str : tokens) {
                float value = Float.parseFloat(str);
                if (compIndex == 0) {
                    value *= 1.0f;
                } else if (compIndex == 1) {
                    value *= -1.0f;
                } else if (compIndex == 2) {
                    value *= -1.0f;
                }
                this.normalsBuffer.put(value);
                ++compIndex;
                compIndex %= 3;
                ++index;
            }
            if (index == numPointValues) break;
            line = reader.readLine();
        }
    }

    private int readNormalsBinary(FloatBuffer buffer, int numPoints) throws IOException {
        int compIndex = 0;
        int numPointValues = numPoints * 3;
        ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
        normalsBufferByte.order(ByteOrder.nativeOrder());
        this.normalsBuffer = normalsBufferByte.asFloatBuffer();
        for (int ctr = 0; ctr < numPointValues; ++ctr) {
            float value = buffer.get();
            if (compIndex == 0) {
                value *= 1.0f;
            } else if (compIndex == 1) {
                value *= -1.0f;
            } else if (compIndex == 2) {
                value *= -1.0f;
            }
            this.normalsBuffer.put(value);
            ++compIndex;
            compIndex %= 3;
        }
        return buffer.position();
    }

    private void readPoints(BufferedReader reader, VolumeManager controller, int numPoints, float xDiff, float yDiff, float zDiff) throws IOException {
        int index = 0;
        int compIndex = 0;
        String line = reader.readLine();
        String orientation = controller.getBaseVolume().getOrientationString();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int colFlip = (orientation.charAt(3) == '-' ? 1 : -1) * (vd.isFlip() ? -1 : 1);
        int rowFlip = orientation.charAt(4) == '-' ? 1 : -1;
        int sliceFlip = orientation.charAt(5) == '-' ? 1 : -1;
        int xIndex = orientation.indexOf(88);
        int yIndex = orientation.indexOf(89);
        int zIndex = orientation.indexOf(90);
        int numPointValues = numPoints * 3;
        ByteBuffer pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
        pointsBufferByte.order(ByteOrder.nativeOrder());
        this.pointsBuffer = pointsBufferByte.asFloatBuffer();
        float[] comps = new float[3];
        while (line != null) {
            Vector tokens = StringUtilities.makeStringTokens((String)line);
            for (String str : tokens) {
                Float value = Float.valueOf(Float.parseFloat(str));
                comps[compIndex] = value.floatValue();
                if (compIndex == 2) {
                    this.pointsBuffer.put((float)colFlip * comps[xIndex] - xDiff);
                    this.pointsBuffer.put((float)rowFlip * comps[yIndex] - yDiff);
                    this.pointsBuffer.put((float)sliceFlip * comps[zIndex] - zDiff);
                }
                ++compIndex;
                compIndex %= 3;
                ++index;
            }
            if (index == numPointValues) break;
            line = reader.readLine();
        }
    }

    private int readPointsBinary(FloatBuffer buffer, VolumeManager controller, int numPoints, float xDiff, float yDiff, float zDiff) throws IOException {
        int compIndex = 0;
        String orientation = controller.getBaseVolume().getOrientationString();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int colFlip = (orientation.charAt(3) == '-' ? 1 : -1) * (vd.isFlip() ? -1 : 1);
        int rowFlip = orientation.charAt(4) == '-' ? 1 : -1;
        int sliceFlip = orientation.charAt(5) == '-' ? 1 : -1;
        int xIndex = orientation.indexOf(88);
        int yIndex = orientation.indexOf(89);
        int zIndex = orientation.indexOf(90);
        int numPointValues = numPoints * 3;
        ByteBuffer pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
        pointsBufferByte.order(ByteOrder.nativeOrder());
        this.pointsBuffer = pointsBufferByte.asFloatBuffer();
        float[] comps = new float[3];
        for (int ctr = 0; ctr < numPointValues; ++ctr) {
            float value;
            comps[compIndex] = value = buffer.get();
            if (compIndex == 2) {
                this.pointsBuffer.put((float)colFlip * comps[xIndex] - xDiff);
                this.pointsBuffer.put((float)rowFlip * comps[yIndex] - yDiff);
                this.pointsBuffer.put((float)sliceFlip * comps[zIndex] - zDiff);
            }
            ++compIndex;
            compIndex %= 3;
        }
        return buffer.position();
    }

    private void readPolygons(BufferedReader reader, int numTriangles) throws IOException, SurfaceFormatException {
        int triangleIndex = 0;
        String line = reader.readLine();
        ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numTriangles * 3 * 4);
        normalsBufferByte.order(ByteOrder.nativeOrder());
        this.indicesBuffer = normalsBufferByte.asIntBuffer();
        while (line != null) {
            Vector tokens = StringUtilities.makeStringTokens((String)line);
            int numVertices = Integer.parseInt((String)tokens.get(0));
            if (numVertices != 3) {
                throw new SurfaceFormatException("Only triangle data is currently supported");
            }
            this.indicesBuffer.put(Integer.parseInt((String)tokens.get(1)));
            this.indicesBuffer.put(Integer.parseInt((String)tokens.get(2)));
            this.indicesBuffer.put(Integer.parseInt((String)tokens.get(3)));
            if (++triangleIndex == numTriangles) break;
            line = reader.readLine();
        }
    }

    private int readPolygonsBinary(IntBuffer buffer, int numTriangles) throws IOException, SurfaceFormatException {
        ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numTriangles * 3 * 4);
        normalsBufferByte.order(ByteOrder.nativeOrder());
        this.indicesBuffer = normalsBufferByte.asIntBuffer();
        int[] comps = new int[3];
        for (int ctr = 0; ctr < numTriangles; ++ctr) {
            int numVertices = buffer.get();
            if (numVertices != 3) {
                throw new SurfaceFormatException("Only triangle data is currently supported");
            }
            comps[0] = buffer.get();
            comps[1] = buffer.get();
            comps[2] = buffer.get();
            this.indicesBuffer.put(comps[0]);
            this.indicesBuffer.put(comps[1]);
            this.indicesBuffer.put(comps[2]);
        }
        return buffer.position();
    }

    private String readString(ByteBuffer buf) {
        StringBuffer sb = new StringBuffer();
        byte b = buf.get();
        while ((char)b != '\n' && b != 0) {
            sb.append((char)b);
            b = buf.get();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readSurface(File file, VolumeManager controller, boolean headerOnly) throws SurfaceFormatException {
        BufferedReader reader = null;
        Surface[] sd = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            this.parseVersion(reader.readLine());
            this.parseDescription(reader.readLine());
            this.parseFileType(reader.readLine());
            int[] numData = new int[2];
            if (this.ascii) {
                this.parseDataset(reader.readLine());
                if (!POLYDATA.equals(this.dataset)) {
                    throw new SurfaceFormatException("Only POLYDATA format is currently supported");
                }
                String line = reader.readLine();
                while (line != null) {
                    if (this.isPointsHeader(line)) {
                        numData[0] = this.parsePointsHeader(line);
                        if (headerOnly) break;
                        float[] offsets = this.calculateFreeSurferOffsets(controller);
                        this.readPoints(reader, controller, numData[0], offsets[0], offsets[1], offsets[2]);
                    } else if (this.isPolygonsHeader(line)) {
                        numData[1] = this.parsePolygonsHeader(line);
                        if (headerOnly) break;
                        this.readPolygons(reader, numData[1]);
                    } else if (this.isNormalsHeader(line)) {
                        this.readNormals(reader, numData[0]);
                    }
                    line = reader.readLine();
                }
            } else {
                this.readBinary(file, controller, headerOnly, numData);
            }
            sd = new Surface[1];
            if (!headerOnly && this.normalsBuffer == null) {
                NormalsGenerator ng = new NormalsGenerator(this.pointsBuffer, this.indicesBuffer);
                this.normalsBuffer = ng.generateNormals();
            }
            sd[0] = new SurfaceData(this.imageTitle, this.description, this.pointsBuffer, this.normalsBuffer, this.indicesBuffer);
            ((SurfaceData)sd[0]).setNumPoints(numData[0]);
            ((SurfaceData)sd[0]).setNumTriangles(numData[1]);
            ((SurfaceData)sd[0]).setThreshold(this.threshold);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(File file, boolean ascii, Surface surface, VolumeManager controller) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write("# vtk DataFile Version 3.0\n");
            writer.write(this.createDescription(surface, controller) + "\n");
            writer.write((ascii ? ASCII : BINARY) + "\n");
            writer.write("DATASET POLYDATA\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNormals(File file, Surface surface, boolean ascii) throws IOException {
        int numPoints = surface.getNumPoints();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.append("NORMALS normals " + FLOAT[0] + "\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (ascii) {
            BufferedWriter br = null;
            try {
                br = new BufferedWriter(new FileWriter(file, true));
                int index = 0;
                int compIndex = 0;
                StringBuffer sb = new StringBuffer();
                FloatIterator normalsIterator = surface.getNormalsIterator();
                while (normalsIterator.hasNext()) {
                    if (compIndex == 0) {
                        sb.append(String.format(FORMAT_6G, Float.valueOf(1.0f * normalsIterator.next())));
                    } else if (compIndex == 1) {
                        sb.append(String.format(FORMAT_6G, Float.valueOf(-1.0f * normalsIterator.next())));
                    } else if (compIndex == 2) {
                        sb.append(String.format(FORMAT_6G, Float.valueOf(-1.0f * normalsIterator.next())));
                    }
                    if (++index % 9 == 0) {
                        br.write(sb.toString() + "\n");
                        sb.delete(0, sb.length());
                        index = 0;
                    }
                    ++compIndex;
                    compIndex %= 3;
                }
                if (index != 0) {
                    br.write(sb.toString());
                }
                br.write("\n");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, outputChannel.size(), numPoints * 3 * 4);
            FloatIterator normalsIterator = surface.getNormalsIterator();
            int compIndex = 0;
            while (normalsIterator.hasNext()) {
                if (compIndex == 0) {
                    outputBuffer.putFloat(1.0f * normalsIterator.next());
                } else if (compIndex == 1) {
                    outputBuffer.putFloat(-1.0f * normalsIterator.next());
                } else if (compIndex == 2) {
                    outputBuffer.putFloat(-1.0f * normalsIterator.next());
                }
                ++compIndex;
                compIndex %= 3;
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePointDataHeader(File file, Surface surface) throws IOException {
        int numPoints = surface.getNumPoints();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.append("POINT_DATA " + numPoints + "\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePoints(File file, VolumeManager controller, Surface surface, boolean ascii, float xDiff, float yDiff, float zDiff) throws IOException {
        int numPoints = surface.getNumPoints();
        String orientation = controller.getBaseVolume().getOrientationString();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int colFlip = (orientation.charAt(3) == '-' ? 1 : -1) * (vd.isFlip() ? -1 : 1);
        int rowFlip = orientation.charAt(4) == '-' ? 1 : -1;
        int sliceFlip = orientation.charAt(5) == '-' ? 1 : -1;
        int xIndex = orientation.indexOf(88);
        int yIndex = orientation.indexOf(89);
        int zIndex = orientation.indexOf(90);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.append("POINTS " + numPoints + " " + FLOAT[0] + "\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (ascii) {
            BufferedWriter br = null;
            try {
                br = new BufferedWriter(new FileWriter(file, true));
                int index = 0;
                int compIndex = 0;
                StringBuffer sb = new StringBuffer();
                FloatIterator pointsIterator = surface.getPointsIterator();
                float[] comps = new float[3];
                while (pointsIterator.hasNext()) {
                    if (compIndex == 0) {
                        comps[xIndex] = (float)colFlip * (pointsIterator.next() + xDiff);
                    } else if (compIndex == 1) {
                        comps[yIndex] = (float)rowFlip * (pointsIterator.next() + yDiff);
                    } else if (compIndex == 2) {
                        comps[zIndex] = (float)sliceFlip * (pointsIterator.next() + zDiff);
                    }
                    if (compIndex == 2) {
                        sb.append(String.format(FORMAT_6G, Float.valueOf(comps[0])));
                        sb.append(String.format(FORMAT_6G, Float.valueOf(comps[1])));
                        sb.append(String.format(FORMAT_6G, Float.valueOf(comps[2])));
                    }
                    if (++index % 9 == 0) {
                        br.write(sb.toString() + "\n");
                        sb.delete(0, sb.length());
                        index = 0;
                    }
                    ++compIndex;
                    compIndex %= 3;
                }
                if (index != 0) {
                    br.write(sb.toString());
                }
                br.write("\n");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, outputChannel.size(), numPoints * 3 * 4);
            FloatIterator pointsIterator = surface.getPointsIterator();
            int compIndex = 0;
            float[] comps = new float[3];
            while (pointsIterator.hasNext()) {
                if (compIndex == 0) {
                    comps[xIndex] = (float)colFlip * (pointsIterator.next() + xDiff);
                } else if (compIndex == 1) {
                    comps[yIndex] = (float)rowFlip * (pointsIterator.next() + yDiff);
                } else if (compIndex == 2) {
                    comps[zIndex] = (float)sliceFlip * (pointsIterator.next() + zDiff);
                }
                if (compIndex == 2) {
                    outputBuffer.putFloat(comps[0]);
                    outputBuffer.putFloat(comps[1]);
                    outputBuffer.putFloat(comps[2]);
                }
                ++compIndex;
                compIndex %= 3;
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeScalarsData(File file, Surface surface, boolean ascii) throws IOException {
        int numPoints = surface.getNumPoints();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.append("COLOR_SCALARS overlay 4\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (ascii) {
            BufferedWriter br = null;
            try {
                br = new BufferedWriter(new FileWriter(file, true));
                int index = 0;
                int compIndex = 0;
                StringBuffer sb = new StringBuffer();
                FloatIterator colorsIterator = surface.getColorsIterator();
                while (colorsIterator.hasNext()) {
                    float value = 0.0f;
                    value = compIndex == 3 ? colorsIterator.next() : colorsIterator.next() / 1.5f;
                    ++compIndex;
                    compIndex %= 4;
                    sb.append(FORMATTER.format(value) + " ");
                    if (++index % 12 != 0) continue;
                    br.write(sb.toString() + "\n");
                    sb.delete(0, sb.length());
                    index = 0;
                }
                if (index != 0) {
                    br.write(sb.toString());
                }
                br.write("\n\n");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, outputChannel.size(), numPoints * 4);
            FloatIterator scalarsIterator = surface.getColorsIterator();
            int compIndex = 0;
            while (scalarsIterator.hasNext()) {
                if (compIndex == 3) {
                    outputBuffer.put((byte)(255.0f * scalarsIterator.next()));
                } else {
                    outputBuffer.put((byte)(255.0f * (scalarsIterator.next() / 1.5f)));
                }
                ++compIndex;
                compIndex %= 4;
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTriangles(File file, Surface surface, boolean ascii) throws IOException {
        int numTriangles = surface.getNumTriangles();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.append("POLYGONS " + numTriangles + " " + numTriangles * 4 + "\n");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (ascii) {
            BufferedWriter br = null;
            try {
                br = new BufferedWriter(new FileWriter(file, true));
                int[] comps = new int[3];
                IndexIterator indicesIterator = surface.getIndiciesIterator();
                while (indicesIterator.hasNext()) {
                    comps[0] = indicesIterator.next();
                    comps[1] = indicesIterator.next();
                    comps[2] = indicesIterator.next();
                    br.write("3 " + comps[0] + " " + comps[1] + " " + comps[2] + " \n");
                }
                br.write("\n");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, outputChannel.size(), numTriangles * 4 * 4);
            int[] comps = new int[3];
            IndexIterator indicesIterator = surface.getIndiciesIterator();
            while (indicesIterator.hasNext()) {
                outputBuffer.putInt(3);
                comps[0] = indicesIterator.next();
                comps[1] = indicesIterator.next();
                comps[2] = indicesIterator.next();
                outputBuffer.putInt(comps[0]);
                outputBuffer.putInt(comps[1]);
                outputBuffer.putInt(comps[2]);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }
}

