/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.NormalsGenerator;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti.GIFTIColorMapper;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.DateUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.DataArray;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GIFTI;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiFormatException;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiReader;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiTransform;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiWriter;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.Label;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GiftiFormat
implements SurfaceFormat {
    private JCheckBox allowLineBreaksBox;
    private JCheckBox allowNormals;
    private JCheckBox selectAllAddedShapes;
    private JRadioButton allowRGB;
    private JRadioButton allowFileLabel;
    private JRadioButton allowFileRGBA;
    private JRadioButton excludeColors;
    private JComboBox<Surface> volBox;
    public static final String EXTENSION = "surf.gii";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_IMAGETHRESHOLD = "ImageThreshold";
    public static final String METADATA_IMAGETITLE = "ImageTitle";
    public static final String METADATA_MANGOVERSION = "MangoVersion";
    public static final String MIN_MANGO_SUPPORTED = "3";
    public static final String NAME = "GIFTI";
    public static final String OPTION_ALLOW_LINE_BREAKS = "Allow line breaks";
    public static final String OPTION_INCLUDE_NORMALS = "Include normals";
    public static final String OPTION_INCLUDE_RGB = "Include RGB data";
    public static final String OPTION_INCLUDE_COLORS_LABEL = "Save colors as .label.gii";
    public static final String OPTION_INCLUDE_COLORS_RGBA = "Save colors as .rgba.gii";

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOptions() {
        StringBuffer sb = new StringBuffer();
        sb.append(OPTION_ALLOW_LINE_BREAKS).append('=').append(this.allowLineBreaksBox.isSelected()).append(',').append(OPTION_INCLUDE_NORMALS).append('=').append(this.allowNormals.isSelected()).append(',').append(OPTION_INCLUDE_RGB).append('=').append(this.allowRGB.isSelected()).append(',').append(OPTION_INCLUDE_COLORS_LABEL).append('=').append(this.allowFileLabel.isSelected()).append(',').append(OPTION_INCLUDE_COLORS_RGBA).append('=').append(this.allowFileRGBA.isSelected());
        return sb.toString();
    }

    public void setOptions(String options) {
        String[] tokens;
        this.allowLineBreaksBox.setSelected(false);
        this.allowNormals.setSelected(false);
        this.allowFileLabel.setSelected(false);
        this.allowFileRGBA.setSelected(false);
        this.allowRGB.setSelected(false);
        this.excludeColors.setSelected(true);
        for (String option : tokens = options.split(",")) {
            if (option.indexOf(OPTION_ALLOW_LINE_BREAKS) != -1) {
                this.allowLineBreaksBox.setSelected(Boolean.parseBoolean(option.substring(option.indexOf(61) + 1)));
                continue;
            }
            if (option.indexOf(OPTION_INCLUDE_NORMALS) != -1) {
                this.allowNormals.setSelected(Boolean.parseBoolean(option.substring(option.indexOf(61) + 1)));
                continue;
            }
            if (option.indexOf(OPTION_INCLUDE_COLORS_LABEL) != -1) {
                this.allowFileLabel.setSelected(Boolean.parseBoolean(option.substring(option.indexOf(61) + 1)));
                continue;
            }
            if (option.indexOf(OPTION_INCLUDE_COLORS_RGBA) != -1) {
                this.allowFileRGBA.setSelected(Boolean.parseBoolean(option.substring(option.indexOf(61) + 1)));
                continue;
            }
            if (option.indexOf(OPTION_INCLUDE_RGB) == -1) continue;
            this.allowRGB.setSelected(Boolean.parseBoolean(option.substring(option.indexOf(61) + 1)));
        }
    }

    @Deprecated
    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, SurfaceController controller) {
        return this.getOptionsPanel(data, shapes, (VolumeManager)controller.getViewerController());
    }

    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, VolumeManager controller) {
        this.volBox = new JComboBox<Surface>(data);
        JPanel volPanel = new JPanel();
        volPanel.setLayout(new BoxLayout(volPanel, 0));
        volPanel.add(Box.createHorizontalStrut(4));
        volPanel.add(new JLabel("Select Surface:"));
        volPanel.add(this.volBox);
        volPanel.add(Box.createHorizontalStrut(4));
        this.selectAllAddedShapes = new JCheckBox("Select all added shapes");
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new BoxLayout(allPanel, 0));
        allPanel.add(Box.createHorizontalStrut(4));
        allPanel.add(this.selectAllAddedShapes);
        allPanel.add(Box.createHorizontalStrut(4));
        this.selectAllAddedShapes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftiFormat.this.volBox.setEnabled(!GiftiFormat.this.selectAllAddedShapes.isSelected());
            }
        });
        this.allowLineBreaksBox = new JCheckBox(OPTION_ALLOW_LINE_BREAKS);
        JPanel lineBreakPanel = new JPanel();
        lineBreakPanel.setLayout(new BoxLayout(lineBreakPanel, 0));
        lineBreakPanel.add(Box.createHorizontalStrut(4));
        lineBreakPanel.add(this.allowLineBreaksBox);
        lineBreakPanel.add(Box.createHorizontalStrut(4));
        this.allowNormals = new JCheckBox(OPTION_INCLUDE_NORMALS);
        JPanel normalsPanel = new JPanel();
        normalsPanel.setLayout(new BoxLayout(normalsPanel, 0));
        normalsPanel.add(Box.createHorizontalStrut(4));
        normalsPanel.add(this.allowNormals);
        normalsPanel.add(Box.createHorizontalStrut(4));
        this.excludeColors = new JRadioButton("Exclude Colors");
        JPanel excludePanel = new JPanel();
        excludePanel.setLayout(new BoxLayout(excludePanel, 0));
        excludePanel.add(Box.createHorizontalStrut(4));
        excludePanel.add(this.excludeColors);
        excludePanel.add(Box.createHorizontalStrut(4));
        this.allowRGB = new JRadioButton("Include RGBA data");
        JPanel rgbPanel = new JPanel();
        rgbPanel.setLayout(new BoxLayout(rgbPanel, 0));
        rgbPanel.add(Box.createHorizontalStrut(4));
        rgbPanel.add(this.allowRGB);
        rgbPanel.add(Box.createHorizontalStrut(4));
        this.allowFileLabel = new JRadioButton(OPTION_INCLUDE_COLORS_LABEL);
        JPanel colorsPanelLabel = new JPanel();
        colorsPanelLabel.setLayout(new BoxLayout(colorsPanelLabel, 0));
        colorsPanelLabel.add(Box.createHorizontalStrut(4));
        colorsPanelLabel.add(this.allowFileLabel);
        colorsPanelLabel.add(Box.createHorizontalStrut(4));
        this.allowFileRGBA = new JRadioButton(OPTION_INCLUDE_COLORS_RGBA);
        JPanel colorsPanelRGB = new JPanel();
        colorsPanelRGB.setLayout(new BoxLayout(colorsPanelRGB, 0));
        colorsPanelRGB.add(Box.createHorizontalStrut(4));
        colorsPanelRGB.add(this.allowFileRGBA);
        colorsPanelRGB.add(Box.createHorizontalStrut(4));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.excludeColors);
        bg.add(this.allowRGB);
        bg.add(this.allowFileLabel);
        bg.add(this.allowFileRGBA);
        if (((CompositeSurface)data[0]).hasColors()) {
            this.allowRGB.setSelected(true);
        } else {
            this.excludeColors.setSelected(true);
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(volPanel);
        mainPanel.add(allPanel);
        mainPanel.add(lineBreakPanel);
        mainPanel.add(normalsPanel);
        mainPanel.add(excludePanel);
        mainPanel.add(rgbPanel);
        mainPanel.add(colorsPanelLabel);
        mainPanel.add(colorsPanelRGB);
        return mainPanel;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return EXTENSION;
    }

    public String getVersion() {
        return null;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        boolean isThisFormat = file.toString().endsWith(".gii");
        if (!isThisFormat) {
            BufferedInputStream input = null;
            try {
                String startOfFile;
                input = new BufferedInputStream(new FileInputStream(file));
                byte[] magicNum = new byte[50];
                int bytesRead = input.read(magicNum);
                if (bytesRead > 0 && (startOfFile = new String(magicNum, "UTF-8")).indexOf("DOCTYPE GIFTI") != -1) {
                    isThisFormat = true;
                }
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return isThisFormat;
    }

    @Deprecated
    public Surface[] readSurfaceFile(File file, ViewerController controller, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException {
        return this.readSurface(file, (VolumeManager)controller, false);
    }

    public Surface[] readSurfaceFile(File file, VolumeManager controller, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException {
        return this.readSurface(file, controller, false);
    }

    public Surface[] readSurfaceHeader(File file, Vector<Shape> shapes) throws SurfaceFormatException {
        return this.readSurface(file, null, true);
    }

    @Deprecated
    public void writeSurfaceFile(File file, Surface[] surfaces, Shape[] shapes, SurfaceController controller) throws SurfaceFormatException {
        this.writeSurfaceFile(file, surfaces, shapes, (VolumeManager)controller.getViewerController());
    }

    public void writeSurfaceFile(File file, Surface[] surfaces, Shape[] shapes, VolumeManager controller) throws SurfaceFormatException {
        if (this.selectAllAddedShapes.isSelected()) {
            this.writeAllAddedFiles(file, surfaces, shapes, controller);
            return;
        }
        Surface surface = this.volBox != null ? (Surface)this.volBox.getSelectedItem() : surfaces[0];
        int numPoints = surface.getNumPoints();
        int numTriangles = surface.getNumTriangles();
        HashMap<String, String> giftiAtts = new HashMap<String, String>();
        GIFTI gifti = new GIFTI(giftiAtts);
        int numDataArrays = 0;
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_DATE, DateUtilities.today());
        metadata.put(METADATA_MANGOVERSION, controller.getVersion());
        metadata.put(METADATA_IMAGETITLE, controller.toString());
        metadata.put(METADATA_IMAGETHRESHOLD, String.valueOf(surface.getThreshold()));
        gifti.addMetadata(metadata);
        HashMap<String, String> pointsAtts = new HashMap<String, String>();
        pointsAtts.put("Intent", "NIFTI_INTENT_POINTSET");
        pointsAtts.put("ArrayIndexingOrder", "RowMajorOrder");
        pointsAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
        pointsAtts.put("Dimensionality", "2");
        pointsAtts.put("Dim0", String.valueOf(numPoints));
        pointsAtts.put("Dim1", MIN_MANGO_SUPPORTED);
        pointsAtts.put("Encoding", "GZipBase64Binary");
        pointsAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
        pointsAtts.put("Encoding", "GZipBase64Binary");
        boolean includeNormals = this.allowNormals.isSelected();
        float[] offsets = this.calculateFreeSurferOffsets(controller);
        float[] scales = new float[]{1.0f, -1.0f, -1.0f};
        FloatBuffer originalPointsBuffer = ((CompositeSurface)surface).getPointsBuffer(0);
        FloatBuffer originalNormalsBuffer = ((CompositeSurface)surface).getNormalsBuffer(0);
        ByteBuffer pointsByteBuffer = Buffers.newDirectByteBuffer((int)(originalPointsBuffer.capacity() * 4));
        FloatBuffer pointsBuffer = pointsByteBuffer.asFloatBuffer();
        ByteBuffer normalsByteBuffer = null;
        FloatBuffer normalsBuffer = null;
        if (includeNormals) {
            normalsByteBuffer = Buffers.newDirectByteBuffer((int)(originalPointsBuffer.capacity() * 4));
            normalsBuffer = normalsByteBuffer.asFloatBuffer();
        }
        int numElements = originalPointsBuffer.capacity() / 3;
        for (int ctr = 0; ctr < numElements; ++ctr) {
            int index = ctr * 3;
            pointsBuffer.put(index, (originalPointsBuffer.get(index) + offsets[0]) * scales[0]);
            pointsBuffer.put(index + 1, (originalPointsBuffer.get(index + 1) + offsets[1]) * scales[1]);
            pointsBuffer.put(index + 2, (originalPointsBuffer.get(index + 2) + offsets[2]) * scales[2]);
            if (normalsBuffer == null) continue;
            normalsBuffer.put(index, originalNormalsBuffer.get(index) * scales[0]);
            normalsBuffer.put(index + 1, originalNormalsBuffer.get(index + 1) * scales[1]);
            normalsBuffer.put(index + 2, originalNormalsBuffer.get(index + 2) * scales[2]);
        }
        DataArray pointsData = new DataArray(pointsAtts, (Buffer)pointsByteBuffer);
        gifti.addDataArray(pointsData);
        ++numDataArrays;
        pointsData.addTransform(GiftiTransform.buildDefaultTransform());
        if (this.allowNormals.isSelected()) {
            HashMap<String, String> normalsAtts = new HashMap<String, String>();
            normalsAtts.put("Intent", "NIFTI_INTENT_VECTOR");
            normalsAtts.put("ArrayIndexingOrder", "RowMajorOrder");
            normalsAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
            normalsAtts.put("Dimensionality", "2");
            normalsAtts.put("Dim0", String.valueOf(numPoints));
            normalsAtts.put("Dim1", MIN_MANGO_SUPPORTED);
            normalsAtts.put("Encoding", "GZipBase64Binary");
            normalsAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
            normalsAtts.put("Encoding", "GZipBase64Binary");
            DataArray normalsData = new DataArray(normalsAtts, (Buffer)normalsByteBuffer);
            gifti.addDataArray(normalsData);
            ++numDataArrays;
        }
        if (this.allowRGB.isSelected()) {
            HashMap<String, String> colorAtts = new HashMap<String, String>();
            colorAtts.put("Intent", "NIFTI_INTENT_RGBA_VECTOR");
            colorAtts.put("ArrayIndexingOrder", "RowMajorOrder");
            colorAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
            colorAtts.put("Dimensionality", "2");
            colorAtts.put("Dim0", String.valueOf(numPoints));
            colorAtts.put("Dim1", "4");
            colorAtts.put("Encoding", "GZipBase64Binary");
            colorAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
            colorAtts.put("Encoding", "GZipBase64Binary");
            FloatBuffer colors = null;
            if (((CompositeSurface)surface).hasColors()) {
                colors = ((CompositeSurface)surface).getColorsBuffer(0);
            } else {
                float[] color = surface.getColor();
                int numVertices = surface.getNumPoints();
                colors = Buffers.newDirectFloatBuffer((int)(numVertices * 4));
                for (int ctr = 0; ctr < numVertices; ++ctr) {
                    colors.put(ctr * 4 + 0, color[0]);
                    colors.put(ctr * 4 + 1, color[1]);
                    colors.put(ctr * 4 + 2, color[2]);
                    colors.put(ctr * 4 + 3, 1.0f);
                }
            }
            DataArray colorData = new DataArray(colorAtts, (Buffer)colors);
            gifti.addDataArray(colorData);
            ++numDataArrays;
        }
        HashMap<String, String> indicesAtts = new HashMap<String, String>();
        indicesAtts.put("Intent", "NIFTI_INTENT_TRIANGLE");
        indicesAtts.put("ArrayIndexingOrder", "RowMajorOrder");
        indicesAtts.put("DataType", "NIFTI_TYPE_INT32");
        indicesAtts.put("Dimensionality", "2");
        indicesAtts.put("Dim0", String.valueOf(numTriangles));
        indicesAtts.put("Dim1", MIN_MANGO_SUPPORTED);
        indicesAtts.put("Encoding", "GZipBase64Binary");
        indicesAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
        indicesAtts.put("Encoding", "GZipBase64Binary");
        DataArray trianglesData = new DataArray(indicesAtts, (Buffer)((CompositeSurface)surface).getIndicesBuffer(0));
        gifti.addDataArray(trianglesData);
        giftiAtts.put("NumberOfDataArrays", String.valueOf(++numDataArrays));
        giftiAtts.put("Version", "1.0");
        GiftiWriter writer = new GiftiWriter(gifti, file, this.allowLineBreaksBox.isSelected());
        try {
            writer.writeGiftiXML();
        }
        catch (GiftiFormatException gfe) {
            AppLogger.error((Throwable)gfe);
            throw new SurfaceFormatException((Throwable)gfe);
        }
        if (((CompositeSurface)surface).hasColors()) {
            HashMap<String, String> colorAtts;
            String dir = file.getParent();
            String filename = FileUtilities.getNameWithoutExtension((File)file);
            File colorFile = null;
            HashMap<String, String> giftiColorAtts = new HashMap<String, String>();
            giftiColorAtts.put("NumberOfDataArrays", String.valueOf(1));
            giftiColorAtts.put("Version", "1.0");
            GIFTI giftiColors = new GIFTI(giftiColorAtts);
            if (this.allowFileLabel.isSelected()) {
                colorFile = new File(dir, filename + ".label.gii");
                colorAtts = new HashMap<String, String>();
                colorAtts.put("Intent", "NIFTI_INTENT_LABEL");
                colorAtts.put("ArrayIndexingOrder", "RowMajorOrder");
                colorAtts.put("DataType", "NIFTI_TYPE_INT32");
                colorAtts.put("Dimensionality", "1");
                colorAtts.put("Dim0", String.valueOf(numPoints));
                colorAtts.put("Encoding", "GZipBase64Binary");
                colorAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
                colorAtts.put("Encoding", "GZipBase64Binary");
                GIFTIColorMapper mapper = new GIFTIColorMapper((SliceViewer)controller, ((CompositeSurface)surface).getSurfaceOverlays(), (CompositeSurface)surface);
                TreeMap<Integer, Label> map = new TreeMap<Integer, Label>();
                IntBuffer buf = mapper.mapColors(map);
                DataArray colorData = new DataArray(colorAtts, (Buffer)buf);
                giftiColors.addDataArray(colorData);
                giftiColors.setLabelTable(map);
            } else if (this.allowFileRGBA.isSelected()) {
                colorFile = new File(dir, filename + ".rgba.gii");
                colorAtts = new HashMap();
                colorAtts.put("Intent", "NIFTI_INTENT_RGBA_VECTOR");
                colorAtts.put("ArrayIndexingOrder", "RowMajorOrder");
                colorAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
                colorAtts.put("Dimensionality", "2");
                colorAtts.put("Dim0", String.valueOf(numPoints));
                colorAtts.put("Dim1", "4");
                colorAtts.put("Encoding", "GZipBase64Binary");
                colorAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
                colorAtts.put("Encoding", "GZipBase64Binary");
                DataArray colorData = new DataArray(colorAtts, (Buffer)((CompositeSurface)surface).getColorsBuffer(0));
                giftiColors.addDataArray(colorData);
            }
            if (colorFile != null) {
                GiftiWriter writerColor = new GiftiWriter(giftiColors, colorFile, this.allowLineBreaksBox.isSelected());
                try {
                    writerColor.writeGiftiXML();
                }
                catch (GiftiFormatException gfe) {
                    AppLogger.error((Throwable)gfe);
                    throw new SurfaceFormatException((Throwable)gfe);
                }
            }
        }
    }

    public void writeAllAddedFiles(File file, Surface[] surfaces, Shape[] shapes, VolumeManager controller) throws SurfaceFormatException {
        HashMap<String, String> giftiAtts = new HashMap<String, String>();
        GIFTI gifti = new GIFTI(giftiAtts);
        int numDataArrays = 0;
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_DATE, DateUtilities.today());
        metadata.put(METADATA_MANGOVERSION, controller.getVersion());
        metadata.put(METADATA_IMAGETITLE, controller.toString());
        gifti.addMetadata(metadata);
        float[] offsets = this.calculateFreeSurferOffsets(controller);
        float[] scales = new float[]{1.0f, -1.0f, -1.0f};
        int numPoints = 0;
        int numTriangles = 0;
        for (Surface surf : surfaces) {
            if (surf.isBaseSurface()) continue;
            numPoints += surf.getNumPoints();
            numTriangles += surf.getNumTriangles();
        }
        ByteBuffer pointsByteBuffer = Buffers.newDirectByteBuffer((int)(numPoints * 3 * 4));
        FloatBuffer pointsBuffer = pointsByteBuffer.asFloatBuffer();
        pointsBuffer.rewind();
        HashMap<String, String> pointsAtts = new HashMap<String, String>();
        pointsAtts.put("Intent", "NIFTI_INTENT_POINTSET");
        pointsAtts.put("ArrayIndexingOrder", "RowMajorOrder");
        pointsAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
        pointsAtts.put("Dimensionality", "2");
        pointsAtts.put("Dim0", String.valueOf(numPoints));
        pointsAtts.put("Dim1", MIN_MANGO_SUPPORTED);
        pointsAtts.put("Encoding", "GZipBase64Binary");
        pointsAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
        pointsAtts.put("Encoding", "GZipBase64Binary");
        boolean includeNormals = this.allowNormals.isSelected();
        HashMap<String, String> normalsAtts = null;
        FloatBuffer normalsBuffer = null;
        if (includeNormals) {
            normalsAtts = new HashMap<String, String>();
            normalsAtts.put("Intent", "NIFTI_INTENT_VECTOR");
            normalsAtts.put("ArrayIndexingOrder", "RowMajorOrder");
            normalsAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
            normalsAtts.put("Dimensionality", "2");
            normalsAtts.put("Dim0", String.valueOf(numPoints));
            normalsAtts.put("Dim1", MIN_MANGO_SUPPORTED);
            normalsAtts.put("Encoding", "GZipBase64Binary");
            normalsAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
            normalsAtts.put("Encoding", "GZipBase64Binary");
            ByteBuffer normalsByteBuffer = Buffers.newDirectByteBuffer((int)(numPoints * 3 * 4));
            normalsBuffer = normalsByteBuffer.asFloatBuffer();
            normalsBuffer.rewind();
        }
        ByteBuffer triangleByteBuffer = Buffers.newDirectByteBuffer((int)(numTriangles * 3 * 4));
        IntBuffer triangleBuffer = triangleByteBuffer.asIntBuffer();
        triangleBuffer.rewind();
        HashMap<String, String> indicesAtts = new HashMap<String, String>();
        indicesAtts.put("Intent", "NIFTI_INTENT_TRIANGLE");
        indicesAtts.put("ArrayIndexingOrder", "RowMajorOrder");
        indicesAtts.put("DataType", "NIFTI_TYPE_INT32");
        indicesAtts.put("Dimensionality", "2");
        indicesAtts.put("Dim0", String.valueOf(numTriangles));
        indicesAtts.put("Dim1", MIN_MANGO_SUPPORTED);
        indicesAtts.put("Encoding", "GZipBase64Binary");
        indicesAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
        indicesAtts.put("Encoding", "GZipBase64Binary");
        HashMap<String, String> colorAtts = null;
        FloatBuffer colorBuffer = null;
        if (this.allowRGB.isSelected()) {
            colorAtts = new HashMap<String, String>();
            colorAtts.put("Intent", "NIFTI_INTENT_RGBA_VECTOR");
            colorAtts.put("ArrayIndexingOrder", "RowMajorOrder");
            colorAtts.put("DataType", "NIFTI_TYPE_FLOAT32");
            colorAtts.put("Dimensionality", "2");
            colorAtts.put("Dim0", String.valueOf(numPoints));
            colorAtts.put("Dim1", "4");
            colorAtts.put("Encoding", "GZipBase64Binary");
            colorAtts.put("Endian", ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "LittleEndian" : "BigEndian");
            colorAtts.put("Encoding", "GZipBase64Binary");
            colorBuffer = Buffers.newDirectFloatBuffer((int)(numPoints * 4));
            colorBuffer.rewind();
        }
        int count = 0;
        for (Surface surf : surfaces) {
            if (surf.isBaseSurface()) continue;
            IntBuffer triangles = (IntBuffer)((CompositeSurface)surf).getIndicesBuffer(0).rewind();
            int num = triangles.capacity();
            for (int ctr = 0; ctr < num; ++ctr) {
                triangleBuffer.put(triangles.get(ctr) + count);
            }
            FloatBuffer originalPointsBuffer = ((CompositeSurface)surf).getPointsBuffer(0);
            FloatBuffer originalNormalsBuffer = ((CompositeSurface)surf).getNormalsBuffer(0);
            int numElements = originalPointsBuffer.capacity() / 3;
            for (int ctr = 0; ctr < numElements; ++ctr) {
                int index = ctr * 3;
                pointsBuffer.put((originalPointsBuffer.get(index) + offsets[0]) * scales[0]);
                pointsBuffer.put((originalPointsBuffer.get(index + 1) + offsets[1]) * scales[1]);
                pointsBuffer.put((originalPointsBuffer.get(index + 2) + offsets[2]) * scales[2]);
                if (normalsBuffer != null) {
                    normalsBuffer.put(originalNormalsBuffer.get(index) * scales[0]);
                    normalsBuffer.put(originalNormalsBuffer.get(index + 1) * scales[1]);
                    normalsBuffer.put(originalNormalsBuffer.get(index + 2) * scales[2]);
                }
                ++count;
            }
            if (!this.allowRGB.isSelected()) continue;
            if (((CompositeSurface)surf).hasColors()) {
                colorBuffer.put((FloatBuffer)((CompositeSurface)surf).getColorsBuffer(0).rewind());
                continue;
            }
            float[] color = surf.getColor();
            int numVertices = surf.getNumPoints();
            for (int ctr = 0; ctr < numVertices; ++ctr) {
                colorBuffer.put(color[0]);
                colorBuffer.put(color[1]);
                colorBuffer.put(color[2]);
                colorBuffer.put(1.0f);
            }
        }
        DataArray pointsData = new DataArray(pointsAtts, (Buffer)pointsByteBuffer);
        gifti.addDataArray(pointsData);
        ++numDataArrays;
        pointsData.addTransform(GiftiTransform.buildDefaultTransform());
        if (this.allowNormals.isSelected()) {
            DataArray normalsData = new DataArray(normalsAtts, (Buffer)normalsBuffer);
            gifti.addDataArray(normalsData);
            ++numDataArrays;
        }
        DataArray trianglesData = new DataArray(indicesAtts, (Buffer)triangleBuffer);
        gifti.addDataArray(trianglesData);
        ++numDataArrays;
        if (this.allowRGB.isSelected()) {
            DataArray colorData = new DataArray(colorAtts, colorBuffer);
            gifti.addDataArray(colorData);
            ++numDataArrays;
        }
        giftiAtts.put("NumberOfDataArrays", String.valueOf(numDataArrays));
        giftiAtts.put("Version", "1.0");
        GiftiWriter writer = new GiftiWriter(gifti, file, this.allowLineBreaksBox.isSelected());
        try {
            writer.writeGiftiXML();
        }
        catch (GiftiFormatException gfe) {
            AppLogger.error((Throwable)gfe);
            throw new SurfaceFormatException((Throwable)gfe);
        }
    }

    private float[] calculateFreeSurferOffsets(VolumeManager controller) {
        if (controller != null) {
            ImageDimensions id = controller.getBaseVolume().getImageDimensions();
            VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
            Coordinate offsets = controller.getBaseVolume().getOriginNativeOffsets();
            String orientation = controller.getBaseVolume().getOrientationString();
            int colFlip = orientation.charAt(3) == '-' ? -1 : 1;
            int rowFlip = orientation.charAt(4) == '-' ? -1 : 1;
            int sliceFlip = orientation.charAt(5) == '-' ? -1 : 1;
            int colDim = id.getCols();
            int rowDim = id.getRows();
            int sliceDim = id.getSlices();
            double colSize = vd.getColSize(true);
            double rowSize = vd.getRowSize(true);
            double sliceSize = vd.getSliceThickness(true);
            double xDiff = 1.0 * ((double)colDim * colSize / 2.0 * (double)colFlip + offsets.xDbl);
            double yDiff = -1.0 * ((double)rowDim * rowSize / 2.0 * (double)rowFlip + offsets.yDbl);
            double zDiff = -1.0 * ((double)sliceDim * sliceSize / 2.0 * (double)sliceFlip + offsets.zDbl);
            return new float[]{(float)xDiff, (float)yDiff, (float)zDiff};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    private Surface[] readSurface(File file, VolumeManager controller, boolean headerOnly) throws SurfaceFormatException {
        GiftiReader reader = new GiftiReader(file);
        GIFTI gifti = null;
        try {
            gifti = reader.parseGiftiXML(headerOnly);
        }
        catch (GiftiFormatException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        Surface[] sd = null;
        if (gifti != null) {
            sd = new Surface[1];
            FloatBuffer points = gifti.getPoints();
            FloatBuffer normals = gifti.getNormals();
            FloatBuffer rgba = gifti.getRGBA();
            if (!headerOnly) {
                float[] offsets = this.calculateFreeSurferOffsets(controller);
                float[] scales = new float[]{1.0f, -1.0f, -1.0f};
                int numElements = points.capacity() / 3;
                for (int ctr = 0; ctr < numElements; ++ctr) {
                    int index = ctr * 3;
                    points.put(index, points.get(index) * scales[0] - offsets[0]);
                    points.put(index + 1, points.get(index + 1) * scales[1] - offsets[1]);
                    points.put(index + 2, points.get(index + 2) * scales[2] - offsets[2]);
                    if (normals == null) continue;
                    normals.put(index, normals.get(index) * scales[0]);
                    normals.put(index + 1, normals.get(index + 1) * scales[1]);
                    normals.put(index + 2, normals.get(index + 2) * scales[2]);
                }
                points.rewind();
            }
            if (normals != null) {
                normals.rewind();
            }
            IntBuffer indices = gifti.getIndices();
            if (!headerOnly && normals == null) {
                NormalsGenerator ng = new NormalsGenerator(gifti.getPoints(), gifti.getIndices());
                normals = ng.generateNormals();
            }
            String name = "Surface";
            if (gifti.getMetadata().get(METADATA_IMAGETITLE) != null) {
                name = (String)gifti.getMetadata().get(METADATA_IMAGETITLE);
            }
            float threshold = Float.MIN_VALUE;
            if (gifti.getMetadata().get(METADATA_IMAGETHRESHOLD) != null) {
                try {
                    threshold = Float.parseFloat(((String)gifti.getMetadata().get(METADATA_IMAGETHRESHOLD)).trim());
                }
                catch (NumberFormatException ex) {
                    AppLogger.info((Throwable)ex);
                }
            }
            sd[0] = new SurfaceData(name, gifti.getDescription(), points, normals, indices);
            ((SurfaceData)sd[0]).setThreshold(threshold);
            ((SurfaceData)sd[0]).setNumPoints(gifti.getNumPoints());
            if (rgba != null) {
                ((SurfaceData)sd[0]).setColorsBuffer(rgba);
            }
        }
        return sd;
    }

    public void readLabelFile(File file, SurfaceController controllerSurface, VolumeManager controller) throws SurfaceFormatException {
        GiftiReader reader = new GiftiReader(file);
        GIFTI gifti = null;
        try {
            gifti = reader.parseGiftiXML(false);
        }
        catch (GiftiFormatException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        if (gifti != null) {
            DataArray dataArray = (DataArray)gifti.getDataArrays().get(0);
            int numElements = dataArray.getNumElements();
            Surface surface = null;
            for (Surface surf : controllerSurface.getSurfaces()) {
                if (numElements != surf.getNumPoints()) continue;
                surface = surf;
                break;
            }
            if (surface == null) {
                throw new SurfaceFormatException("No loaded surface matches this label file!");
            }
            Map labelTable = gifti.getLabelTable();
            if (labelTable == null) {
                throw new SurfaceFormatException("No label table found in this label file!");
            }
            IntBuffer scalars = dataArray.getAsIntBuffer();
            FloatBuffer colors = Buffers.newDirectFloatBuffer((int)(surface.getNumPoints() * 4));
            for (int ctr = 0; ctr < numElements; ++ctr) {
                Label label = (Label)labelTable.get(scalars.get(ctr));
                colors.put(ctr * 4, (float)label.getRed());
                colors.put(ctr * 4 + 1, (float)label.getGreen());
                colors.put(ctr * 4 + 2, (float)label.getBlue());
                colors.put(ctr * 4 + 3, (float)label.getAlpha());
            }
            ((CompositeSurface)surface).setColorsData(colors);
            controllerSurface.updateSurface();
        }
    }

    public void readRGBAFile(File file, SurfaceController controllerSurface, VolumeManager controller) throws SurfaceFormatException {
        GiftiReader reader = new GiftiReader(file);
        GIFTI gifti = null;
        try {
            gifti = reader.parseGiftiXML(false);
        }
        catch (GiftiFormatException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        if (gifti != null) {
            DataArray dataArray = (DataArray)gifti.getDataArrays().get(0);
            int numElements = dataArray.getNumElements();
            Surface surface = null;
            for (Surface surf : controllerSurface.getSurfaces()) {
                if (numElements != surf.getNumPoints()) continue;
                surface = surf;
                break;
            }
            if (surface == null) {
                throw new SurfaceFormatException("No loaded surface matches this label file!");
            }
            ((CompositeSurface)surface).setColorsData(gifti.getRGBA());
            controllerSurface.updateSurface();
        }
    }
}

