/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceIOListener;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.bv.BrainVisaMeshFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti.GiftiFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.mango.MangoFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.vtk.VTKFormat;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class SurfaceReader {
    private static String[] formatExtensions;
    private static final TreeMap<String, SurfaceFormat> LOADED_FORMATS;

    public static void addFormat(SurfaceFormat aFormat) {
        LOADED_FORMATS.put(PluginManagerDialog.getPluginName(aFormat), aFormat);
        SurfaceReader.updateFormatExtensions();
    }

    public static String[] getFormatExtensions() {
        return Arrays.copyOf(formatExtensions, formatExtensions.length);
    }

    public static Map<String, SurfaceFormat> getLoadedFormats() {
        return LOADED_FORMATS;
    }

    private static void updateFormatExtensions() {
        Collection<SurfaceFormat> values = LOADED_FORMATS.values();
        Iterator<SurfaceFormat> it = values.iterator();
        formatExtensions = new String[values.size() + 1];
        int index = 0;
        SurfaceReader.formatExtensions[index++] = ".surf";
        while (it.hasNext()) {
            SurfaceFormat aFormat = it.next();
            if (index >= formatExtensions.length) continue;
            SurfaceReader.formatExtensions[index++] = "." + aFormat.getPreferredFileExtension();
        }
    }

    public void readFile(final File file, final VolumeManager controller, final SurfaceIOListener listener, final boolean baseSurface) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceReader.this.doReadFile(file, controller, listener, baseSurface, null);
            }
        }, "SurfaceReader.readFile() Thread");
        workThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface[] doReadFile(File file, VolumeManager controller, SurfaceIOListener listener, boolean baseSurface, Vector<Shape> shapesArg) {
        Vector<Object> shapes;
        String message;
        Surface[] surfaces;
        boolean success;
        block14: {
            success = false;
            surfaces = null;
            message = null;
            shapes = shapesArg;
            ProgressMeter meter = controller.makeProgressMeter();
            meter.start(0, 0, 100);
            meter.setIndeterminateMode(true);
            try {
                boolean found = false;
                if (LOADED_FORMATS.size() <= 0) break block14;
                Collection<SurfaceFormat> values = LOADED_FORMATS.values();
                for (SurfaceFormat aFormat : values) {
                    if (!aFormat.isThisFormat(file)) continue;
                    found = true;
                    SurfaceFormat aFormatNew = null;
                    try {
                        Class<?> aClass = Class.forName(aFormat.getClass().getName());
                        aFormatNew = (SurfaceFormat)aClass.newInstance();
                    }
                    catch (Exception ex) {
                        AppLogger.error((Throwable)ex);
                        message = ex.getMessage();
                    }
                    catch (Error err) {
                        AppLogger.error((Throwable)err);
                        message = err.getMessage();
                    }
                    if (aFormatNew == null) break;
                    if (shapes == null) {
                        shapes = new Vector();
                    }
                    success = (surfaces = aFormatNew.readSurfaceFile(file, controller, shapes, baseSurface)) != null;
                    break;
                }
                if (!found) {
                    message = "This format is not recognized!";
                }
            }
            catch (SurfaceFormatException sfe) {
                AppLogger.error((Throwable)sfe);
                message = sfe.getMessage();
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                message = ex.getMessage();
            }
            finally {
                meter.setValue(100);
                meter.setIndeterminateMode(false);
            }
        }
        if (listener != null) {
            listener.surfaceFileRead(success, surfaces, shapes, message);
        }
        return surfaces;
    }

    public Surface[] readHeader(File file, Vector<Shape> shapesVal, StringBuffer surfaceType) {
        Surface[] surfaces;
        block8: {
            surfaces = null;
            Vector<Object> shapes = shapesVal;
            try {
                if (LOADED_FORMATS.size() <= 0) break block8;
                Collection<SurfaceFormat> values = LOADED_FORMATS.values();
                for (SurfaceFormat aFormat : values) {
                    if (!aFormat.isThisFormat(file)) continue;
                    SurfaceFormat aFormatNew = null;
                    try {
                        Class<?> aClass = Class.forName(aFormat.getClass().getName());
                        aFormatNew = (SurfaceFormat)aClass.newInstance();
                    }
                    catch (Exception ex) {
                        AppLogger.error((Throwable)ex);
                    }
                    catch (Error err) {
                        AppLogger.error((Throwable)err);
                    }
                    if (aFormatNew != null) {
                        shapes = new Vector();
                        surfaces = aFormatNew.readSurfaceHeader(file, shapes);
                        surfaceType.append(aFormat.getPluginName());
                    }
                    break;
                }
            }
            catch (SurfaceFormatException sfe) {
                AppLogger.error((Throwable)sfe);
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return surfaces;
    }

    static {
        LOADED_FORMATS = new TreeMap();
        SurfaceReader.addFormat(new MangoFormat());
        SurfaceReader.addFormat(new BrainVisaMeshFormat());
        SurfaceReader.addFormat(new VTKFormat());
        SurfaceReader.addFormat(new GiftiFormat());
        SurfaceReader.updateFormatExtensions();
    }
}

