/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io;

import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.io.IndexIterator;
import edu.uthscsa.ric.visualization.surface.primitives.Overlay;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Vector;

public final class SurfaceData
implements Surface {
    private BufferedImage previewImage;
    private FloatBuffer normalsBuffer;
    private FloatBuffer pointsBuffer;
    private FloatBuffer scalarsBuffer;
    private FloatBuffer colorsBuffer;
    private IntBuffer indicesBuffer;
    private String description;
    private String name;
    private boolean baseSurface;
    private float threshold;
    private float[] color;
    private int numPoints;
    private int numTriangles;
    private final Vector<Overlay> overlays;

    public SurfaceData(String name, String description, FloatBuffer pointsBuffer) {
        this.setName(name);
        this.setDescription(description);
        this.setPointsBuffer(pointsBuffer);
        this.overlays = new Vector();
        this.color = Surface.DEFAULT_COLOR;
    }

    public SurfaceData(String name, String description, FloatBuffer pointsBuffer, FloatBuffer normalsBuffer, IntBuffer intBuffer) {
        this(name, description, pointsBuffer);
        this.setNormalsBuffer(normalsBuffer);
        this.setIndicesBuffer(intBuffer);
    }

    public float[] getColor() {
        return this.color;
    }

    public FloatIterator getColorsIterator() {
        return new FloatIterator(new FloatBuffer[]{this.colorsBuffer});
    }

    public String getDescription() {
        return this.description;
    }

    public IntBuffer getIndicesBuffer() {
        return this.indicesBuffer;
    }

    public IndexIterator getIndiciesIterator() {
        return new IndexIterator(new IntBuffer[]{this.indicesBuffer}, new int[]{this.getNumPoints()});
    }

    public String getName() {
        return this.name;
    }

    public FloatBuffer getNormalsBuffer() {
        return this.normalsBuffer;
    }

    public FloatIterator getNormalsIterator() {
        return new FloatIterator(new FloatBuffer[]{this.normalsBuffer});
    }

    public int getNumPoints() {
        if (this.pointsBuffer != null) {
            return this.pointsBuffer.capacity() / 3;
        }
        return this.numPoints;
    }

    public int getNumTriangles() {
        if (this.pointsBuffer != null) {
            return this.pointsBuffer.capacity() / 9;
        }
        return this.numTriangles;
    }

    public Overlay[] getOverlays() {
        return this.overlays.toArray(new Overlay[this.overlays.size()]);
    }

    public FloatBuffer getPointsBuffer() {
        return this.pointsBuffer;
    }

    public FloatIterator getPointsIterator() {
        return new FloatIterator(new FloatBuffer[]{this.pointsBuffer});
    }

    public BufferedImage getPreviewImage() {
        return this.previewImage;
    }

    public FloatBuffer getScalarsBuffer() {
        return this.scalarsBuffer;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public boolean isBaseSurface() {
        return this.baseSurface;
    }

    public void setBaseSurface(boolean baseSurface) {
        this.baseSurface = baseSurface;
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIndicesBuffer(IntBuffer indicesBuffer) {
        this.indicesBuffer = indicesBuffer;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNormalsBuffer(FloatBuffer normalsBuffer) {
        this.normalsBuffer = normalsBuffer;
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
    }

    public void setNumTriangles(int numTriangles) {
        this.numTriangles = numTriangles;
    }

    public void setPointsBuffer(FloatBuffer pointsBuffer) {
        this.pointsBuffer = pointsBuffer;
    }

    public void setPreviewImage(BufferedImage previewImage) {
        this.previewImage = previewImage;
    }

    public void setScalarsBuffer(FloatBuffer scalarsBuffer) {
        this.scalarsBuffer = scalarsBuffer;
    }

    public void setThreshold(float val) {
        this.threshold = val;
    }

    public boolean isHidden() {
        return false;
    }

    public void setHidden(boolean hidden) {
    }

    public boolean isUseTransform() {
        return false;
    }

    public void setUseTransform(boolean useTransform) {
    }

    public FloatBuffer getColorsBuffer() {
        return this.colorsBuffer;
    }

    public void setColorsBuffer(FloatBuffer colorsBuffer) {
        this.colorsBuffer = colorsBuffer;
    }
}

