/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io;

import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import javax.vecmath.Point3d;

public class ShapeData
implements Shape {
    private String surfaceName;
    private boolean isOnSurface;
    private boolean visible;
    private final Point3d[] points;
    private final float[] colorArray;

    public ShapeData(Point3d[] points, float[] color) {
        this.points = points;
        this.colorArray = color;
    }

    public float[] getColor() {
        return this.colorArray;
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public String getSurfaceName() {
        return this.surfaceName;
    }

    public boolean isOnSurface() {
        return this.isOnSurface;
    }

    public void setOnSurface(boolean bool) {
        this.isOnSurface = bool;
    }

    public void setSurfaceName(String surfaceName) {
        this.surfaceName = surfaceName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public double getDistance() {
        double distance = 0.0;
        for (int ctr = 0; ctr < this.points.length; ctr += 2) {
            Point3d p1 = this.points[ctr];
            Point3d p2 = this.points[ctr + 1];
            distance += p1.distance(p2);
        }
        return distance;
    }

    public String toString() {
        if (this.points.length == 1) {
            return "Point (" + this.points[0].hashCode() + ")";
        }
        if (this.isOnSurface()) {
            return "Surface Line (" + this.points[0].hashCode() + ", " + this.points[this.points.length - 1].hashCode() + ")";
        }
        return "Line (" + this.points[0].hashCode() + ", " + this.points[this.points.length - 1].hashCode() + ")";
    }
}

