/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.building;

import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantBuilder;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantRunner;

public class OctantBuilderThread
extends Thread {
    private final OctantBuilder builder;
    private final OctantRunner runner;
    private final int numProcesses;
    private final int threadIndex;
    private final int[] processes;

    protected OctantBuilderThread(OctantBuilder builder, OctantRunner runner, int threadIndex, int numProcesses, int[] processes) {
        this.builder = builder;
        this.runner = runner;
        this.threadIndex = threadIndex;
        this.numProcesses = numProcesses;
        this.processes = processes;
    }

    @Override
    public void run() {
        this.doRun();
    }

    public void doRun() {
        for (int ctr = 0; ctr < this.numProcesses; ++ctr) {
            this.runner.process(this.numProcesses, this.threadIndex, ctr, this.processes[ctr]);
            this.builder.incrementOctantProcessedCount();
            if (!this.builder.checkDoneStatus()) continue;
            this.builder.setProgressAsIndeterminate();
            this.runner.finishProcess(this.builder.isSync());
            this.builder.finishProgress();
        }
    }
}

