/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.building;

import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantBuilderThread;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantRunner;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;

public class OctantBuilder {
    private ProgressBar progressBar;
    private int octantsProcessed;
    private boolean sync;
    private final OctantRunner runner;
    private final int numProcessors;
    private final int[] numProcessesPerThread;
    public static final int OCTANTS_MAX_THREADS = 8;
    public static final int OCTANTS_NUM = 8;

    public OctantBuilder(OctantRunner runner, boolean manageProgress) {
        this.runner = runner;
        int numProcessorsTotal = Platform.PROCESSOR_COUNT;
        this.numProcessors = Math.min(numProcessorsTotal, 8);
        this.numProcessesPerThread = new int[this.numProcessors];
        for (int ctr = 0; ctr < 8; ++ctr) {
            int n = ctr % this.numProcessesPerThread.length;
            this.numProcessesPerThread[n] = this.numProcessesPerThread[n] + 1;
        }
        if (manageProgress) {
            this.progressBar = new ProgressBar(SurfaceViewer.getProgressBarListener(), "Building Surface");
            this.progressBar.setForceStart();
            this.progressBar.init(0, 0, 8);
        }
    }

    public void finishProgress() {
        if (this.progressBar != null) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    OctantBuilder.this.progressBar.setValue(OctantBuilder.this.progressBar.getMax());
                }
            });
        }
    }

    public void start() {
        int processIndex = 0;
        if (this.runner.testProcess()) {
            for (int ctr = 0; ctr < this.numProcessors; ++ctr) {
                int[] processes = new int[this.numProcessesPerThread[ctr]];
                for (int ctrP = 0; ctrP < processes.length; ++ctrP) {
                    processes[ctrP] = processIndex++;
                }
                OctantBuilderThread workThread = new OctantBuilderThread(this, this.runner, ctr, this.numProcessesPerThread[ctr], processes);
                if (this.sync) {
                    workThread.doRun();
                    continue;
                }
                workThread.start();
            }
        } else {
            this.runner.finishProcess(this.sync);
            this.finishProgress();
        }
    }

    protected synchronized boolean checkDoneStatus() {
        if (this.octantsProcessed == 8) {
            this.octantsProcessed = 0;
            return true;
        }
        return false;
    }

    protected synchronized void incrementOctantProcessedCount() {
        ++this.octantsProcessed;
        if (this.progressBar != null) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    OctantBuilder.this.progressBar.setValue(OctantBuilder.this.octantsProcessed);
                }
            });
        }
    }

    protected void setProgressAsIndeterminate() {
        if (this.progressBar != null) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    OctantBuilder.this.progressBar.setIndeterminateMode(true);
                }
            });
        }
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }
}

