/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.menus.context;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SurfaceContextMenuActions
extends AbstractAction {
    private final SurfaceViewer renderer;
    private final CompositeSurface surface;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_MEASURE = "Measure";
    public static final String ACTION_HIDE = "Hide";
    public static final String ACTION_REMOVE = "Remove";

    protected SurfaceContextMenuActions(SurfaceViewer renderer, CompositeSurface surface, String actionName) {
        super(actionName);
        this.renderer = renderer;
        this.surface = surface;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_MEASURE)) {
            this.renderer.measureSurfaceArea(this.surface);
            this.renderer.measureSurfaceVolume(this.surface);
        } else if (command.equals(ACTION_HIDE)) {
            this.surface.setHidden(!this.surface.isHidden());
            this.renderer.updateSurface();
        } else if (command.equals(ACTION_REMOVE)) {
            this.renderer.removeShape(String.valueOf(this.surface.hashCode()));
            this.renderer.updateSurface();
        }
    }
}

