/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoPreferences;
import edu.uthscsa.ric.mango.components.menus.MangoCheckBoxMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoMenu;
import edu.uthscsa.ric.mango.components.menus.MangoMenuItem;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.viewersurface.SurfacePreferences;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.mango.viewersurface.menus.SurfaceViewerMenuAction;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.apache.commons.lang3.StringUtils;

public class SurfaceViewerMenu
implements MenuListener {
    private JMenuItem[] currentPlugins;
    private MangoMenu fileExportMenu;
    private MangoMenu fileImportMenu;
    private JCheckBoxMenuItem viewMenuOrientation;
    private JCheckBoxMenuItem viewMenuCrosshairs;
    private JCheckBoxMenuItem viewMenuAllSlicePlanes;
    private JCheckBoxMenuItem viewMenuMainSlicePlane;
    private JCheckBoxMenuItem viewMenuShapes;
    private JCheckBoxMenuItem viewMenuSurface;
    private JCheckBoxMenuItem viewMenuSlices;
    private JCheckBoxMenuItem viewMenuROIs;
    private JCheckBoxMenuItem viewMenuRuler;
    private JCheckBoxMenuItem viewMenuAngle;
    private JCheckBoxMenuItem surfaceMenuAnimate;
    private JMenuItem surfaceMenuMeasure;
    private JCheckBoxMenuItem surfaceMenuAllCutPlanes;
    private MangoMenu surfaceMenuAxialCutPlaneMenu;
    private JCheckBoxMenuItem surfaceMenuAxialCutPlaneMenuSup;
    private JCheckBoxMenuItem surfaceMenuAxialCutPlaneMenuInf;
    private MangoMenu surfaceMenuCoronalCutPlaneMenu;
    private JCheckBoxMenuItem surfaceMenuCoronalCutPlaneMenuAnt;
    private JCheckBoxMenuItem surfaceMenuCoronalCutPlaneMenuPos;
    private MangoMenu surfaceMenuSagittalCutPlaneMenu;
    private JCheckBoxMenuItem surfaceMenuSagittalCutPlaneMenuLeft;
    private JCheckBoxMenuItem surfaceMenuSagittalCutPlaneMenuRight;
    private JCheckBoxMenuItem surfaceMenuObliqueCutPlane;
    private MangoMenu shapesMenu;
    private JMenuItem shapesMenuHideAll;
    private JMenuItem shapesMenuRemoveAll;
    private JMenuItem shapesMenuMeasureAll;
    private MangoMenu pluginsMenu;
    private JCheckBoxMenuItem windowMenuSticky;
    private final SurfaceViewer renderer;
    private final int fontSize;
    static final Map<String, JMenuItem> MENU_ACTION_MAP = new TreeMap<String, JMenuItem>();
    static final Map<String, JMenuItem> MENU_NAME_MAP = new TreeMap<String, JMenuItem>();

    public SurfaceViewerMenu(SurfaceViewer renderer) {
        this.renderer = renderer;
        this.fontSize = 11;
    }

    public void addPluginMenuItem(String string) {
        MangoMenuItem tempItem = new MangoMenuItem(new SurfaceViewerMenuAction(string, this.renderer), "Plugin - " + string + " (Surface)", this.fontSize, false);
        tempItem.setText(string);
        tempItem.setActionCommand("Plugin| " + string);
        this.pluginsMenu.add((Component)tempItem, 1);
        if (Mango.getSurfacePluginMap().size() == 1) {
            this.pluginsMenu.add((Component)new JToolBar.Separator(new Dimension(0, 8)), 2);
        }
        this.currentPlugins = new MangoMenuItem[this.pluginsMenu.getItemCount()];
        for (int ctr = 0; ctr < this.currentPlugins.length; ++ctr) {
            this.currentPlugins[ctr] = this.pluginsMenu.getItem(ctr);
        }
    }

    public JMenuBar create() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(BorderFactory.createLineBorder((Color)UIManager.get("MenuItem.background")));
        menuBar.add(this.makeFileMenu(this.renderer));
        menuBar.add(this.makeViewMenu(this.renderer));
        menuBar.add(this.makeSurfaceMenu(this.renderer));
        menuBar.add(this.makeShapesMenu());
        menuBar.add(this.makePluginsMenu(this.renderer));
        menuBar.add(this.makeWindowMenu(this.renderer));
        this.updateMenu(this.renderer);
        this.createMenuItemMap();
        return menuBar;
    }

    @Override
    public void menuCanceled(MenuEvent me) {
    }

    @Override
    public void menuDeselected(MenuEvent me) {
        this.renderer.getFrame().requestFocus();
        this.renderer.getCanvas().requestFocusInWindow();
    }

    @Override
    public void menuSelected(MenuEvent me) {
        this.updateMenu(this.renderer);
    }

    private MangoMenu makeFileMenu(SurfaceViewer renderer) {
        MangoMenu fileMenu = new MangoMenu("File", this.fontSize, false);
        MangoMenuItem fileSaveAs = new MangoMenuItem(new SurfaceViewerMenuAction("Save As...", renderer), "Save As (Surface)", this.fontSize, true);
        this.fileExportMenu = new MangoMenu("Export", this.fontSize, true);
        this.updateExportMenu();
        this.fileImportMenu = new MangoMenu("Import", this.fontSize, true);
        this.updateImportMenu();
        fileMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem fileMenuInfo = new MangoMenuItem(new SurfaceViewerMenuAction("Surface Info", renderer), "Surface Info (Surface)", this.fontSize, false);
        fileMenu.add(fileMenuInfo);
        if (!renderer.getViewer().getMango().isApplet()) {
            fileMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            fileMenu.add(fileSaveAs);
            fileMenu.add(this.fileExportMenu);
            fileMenu.add(this.fileImportMenu);
        }
        fileMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        fileMenu.addMenuListener(this);
        return fileMenu;
    }

    private MangoMenu makePluginsMenu(SurfaceViewer renderer) {
        this.pluginsMenu = new MangoMenu("Plugins", this.fontSize, true);
        MangoMenuItem pluginMenuGetMore = new MangoMenuItem(new SurfaceViewerMenuAction("Get More Plugins...", renderer), null, true, this.fontSize, false);
        this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.pluginsMenu.add(pluginMenuGetMore);
        if (Mango.getSurfacePluginMap().size() > 0) {
            this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            Set<String> names = Mango.getSurfacePluginMap().keySet();
            for (String name : names) {
                MangoMenuItem tempItem = new MangoMenuItem(new SurfaceViewerMenuAction("Plugin| " + name, renderer), "Plugin - " + name + " (Surface)", this.fontSize, false);
                tempItem.setText(name);
                tempItem.setActionCommand("Plugin| " + name);
                this.pluginsMenu.add(tempItem);
            }
        }
        this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.currentPlugins = new MangoMenuItem[this.pluginsMenu.getItemCount()];
        for (int ctr = 0; ctr < this.currentPlugins.length; ++ctr) {
            this.currentPlugins[ctr] = this.pluginsMenu.getItem(ctr);
        }
        this.pluginsMenu.addMenuListener(this);
        return this.pluginsMenu;
    }

    private MangoMenu makeShapesMenu() {
        this.shapesMenu = new MangoMenu("Shapes", this.fontSize, false);
        this.shapesMenu.addMenuListener(this);
        return this.shapesMenu;
    }

    private MangoMenu makeSurfaceMenu(SurfaceViewer renderer) {
        MangoMenu surfaceMenu = new MangoMenu("Surface", this.fontSize, false);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem surfaceMenuAppearanceMenuBackground = new MangoMenuItem(new SurfaceViewerMenuAction("Background...", renderer), "Background (Surface)", this.fontSize, false);
        surfaceMenu.add(surfaceMenuAppearanceMenuBackground);
        MangoMenuItem surfaceMenuAppearanceMenuColor = new MangoMenuItem(new SurfaceViewerMenuAction("Material...", renderer), "Material (Surface)", this.fontSize, false);
        surfaceMenu.add(surfaceMenuAppearanceMenuColor);
        MangoMenuItem surfaceMenuAppearanceMenuLighting = new MangoMenuItem(new SurfaceViewerMenuAction("Lighting...", renderer), "Lighting (Surface)", this.fontSize, false);
        surfaceMenu.add(surfaceMenuAppearanceMenuLighting);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenu surfaceMenuPositionMenu = new MangoMenu("View", this.fontSize, false);
        surfaceMenu.add(surfaceMenuPositionMenu);
        MangoMenuItem surfaceMenuPositionMenuReset = new MangoMenuItem(new SurfaceViewerMenuAction("Default", renderer), "Position Default (Surface)", this.fontSize, false);
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuReset);
        surfaceMenuPositionMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem surfaceMenuPositionMenuSuperior = new MangoMenuItem(new SurfaceViewerMenuAction("View Superior", renderer), "Position Superior (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuSuperior.setText("Superior");
        surfaceMenuPositionMenuSuperior.setActionCommand("View Superior");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuSuperior);
        MangoMenuItem surfaceMenuPositionMenuInferior = new MangoMenuItem(new SurfaceViewerMenuAction("View Inferior", renderer), "Position Inferior (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuInferior.setText("Inferior");
        surfaceMenuPositionMenuInferior.setActionCommand("View Inferior");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuInferior);
        MangoMenuItem surfaceMenuPositionMenuAnterior = new MangoMenuItem(new SurfaceViewerMenuAction("View Anterior", renderer), "Position Anterior (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuAnterior.setText("Anterior");
        surfaceMenuPositionMenuAnterior.setActionCommand("View Anterior");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuAnterior);
        MangoMenuItem surfaceMenuPositionMenuPosterior = new MangoMenuItem(new SurfaceViewerMenuAction("View Posterior", renderer), "Position Posterior (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuPosterior.setText("Posterior");
        surfaceMenuPositionMenuPosterior.setActionCommand("View Posterior");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuPosterior);
        MangoMenuItem surfaceMenuPositionMenuLeft = new MangoMenuItem(new SurfaceViewerMenuAction("View Left", renderer), "Position Left (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuLeft.setText("Left");
        surfaceMenuPositionMenuLeft.setActionCommand("View Left");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuLeft);
        MangoMenuItem surfaceMenuPositionMenuRight = new MangoMenuItem(new SurfaceViewerMenuAction("View Right", renderer), "Position Right (Surface)", this.fontSize, false);
        surfaceMenuPositionMenuRight.setText("Right");
        surfaceMenuPositionMenuRight.setActionCommand("View Right");
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuRight);
        surfaceMenuPositionMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem surfaceMenuPositionMenuSave = new MangoMenuItem(new SurfaceViewerMenuAction("Save", renderer), "Position Save (Surface)", this.fontSize, false);
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuSave);
        MangoMenuItem surfaceMenuPositionMenuGoto = new MangoMenuItem(new SurfaceViewerMenuAction("Go To Saved", renderer), "Position Goto (Surface)", this.fontSize, false);
        surfaceMenuPositionMenu.add(surfaceMenuPositionMenuGoto);
        this.surfaceMenuMeasure = new MangoMenuItem(new SurfaceViewerMenuAction("Surface Measure", renderer), "Measure Surface (Surface)", this.fontSize, false);
        this.surfaceMenuMeasure.setText("Measure");
        this.surfaceMenuMeasure.setActionCommand("Surface Measure");
        surfaceMenu.add(this.surfaceMenuMeasure);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.surfaceMenuAllCutPlanes = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("All Cut Planes", renderer), "Toggle All Cut Planes (Surface)", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuAllCutPlanes);
        this.surfaceMenuAxialCutPlaneMenu = new MangoMenu("Axial Cut Plane", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuAxialCutPlaneMenu);
        this.surfaceMenuAxialCutPlaneMenuSup = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Superior", renderer), "View Axial Superior Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuAxialCutPlaneMenu.add(this.surfaceMenuAxialCutPlaneMenuSup);
        this.surfaceMenuAxialCutPlaneMenuInf = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Inferior", renderer), "View Axial Inferior Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuAxialCutPlaneMenu.add(this.surfaceMenuAxialCutPlaneMenuInf);
        this.surfaceMenuCoronalCutPlaneMenu = new MangoMenu("Coronal Cut Plane", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuCoronalCutPlaneMenu);
        this.surfaceMenuCoronalCutPlaneMenuAnt = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Anterior", renderer), "View Coronal Anterior Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuCoronalCutPlaneMenu.add(this.surfaceMenuCoronalCutPlaneMenuAnt);
        this.surfaceMenuCoronalCutPlaneMenuPos = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Posterior", renderer), "View Coronal Posterior Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuCoronalCutPlaneMenu.add(this.surfaceMenuCoronalCutPlaneMenuPos);
        this.surfaceMenuSagittalCutPlaneMenu = new MangoMenu("Sagittal Cut Plane", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuSagittalCutPlaneMenu);
        this.surfaceMenuSagittalCutPlaneMenuLeft = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Left", renderer), "View Sagittal Left Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuSagittalCutPlaneMenu.add(this.surfaceMenuSagittalCutPlaneMenuLeft);
        this.surfaceMenuSagittalCutPlaneMenuRight = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Right", renderer), "View Sagittal Right Cut Plane (Surface)", this.fontSize, false);
        this.surfaceMenuSagittalCutPlaneMenu.add(this.surfaceMenuSagittalCutPlaneMenuRight);
        this.surfaceMenuObliqueCutPlane = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Oblique Cut Plane", renderer), "Toggle Oblique Cut Plane (Surface)", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuObliqueCutPlane);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.surfaceMenuAnimate = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Animate", renderer), "Animate (Surface)", this.fontSize, false);
        surfaceMenu.add(this.surfaceMenuAnimate);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem surfaceMenuSnapshot = new MangoMenuItem(new SurfaceViewerMenuAction("Create Snapshot...", renderer), null, this.fontSize, true);
        surfaceMenu.add(surfaceMenuSnapshot);
        MangoMenuItem surfaceMenuCine = new MangoMenuItem(new SurfaceViewerMenuAction("Create Video...", renderer), "Create Video (Surface)", this.fontSize, true);
        surfaceMenu.add(surfaceMenuCine);
        surfaceMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        surfaceMenu.addMenuListener(this);
        return surfaceMenu;
    }

    private MangoMenu makeViewMenu(SurfaceViewer renderer) {
        MangoMenu viewMenu = new MangoMenu("View", this.fontSize, false);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.viewMenuOrientation = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Orientation", renderer), "Toggle Orientation (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuOrientation);
        MangoCheckBoxMenuItem viewMenuPosition = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Position", renderer), "Toggle Position (Surface)", this.fontSize, false);
        viewMenu.add(viewMenuPosition);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.viewMenuRuler = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Ruler", renderer), "Toggle Ruler (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuRuler);
        this.viewMenuAngle = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Angle", renderer), "Toggle Angle (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuAngle);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.viewMenuCrosshairs = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Crosshairs", renderer), "Toggle Crosshairs (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuCrosshairs);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.viewMenuAllSlicePlanes = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("All Slice Planes", renderer), "View All Slice Planes (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuAllSlicePlanes);
        this.viewMenuMainSlicePlane = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Main Slice Plane", renderer), "View Main Slice Plane (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuMainSlicePlane);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.viewMenuSurface = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Surface", renderer), "Toggle Surface (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuSurface);
        this.viewMenuShapes = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Shapes", renderer), "Toggle Shapes (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuShapes);
        this.viewMenuSlices = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Slices", renderer), "Toggle Slices (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuSlices);
        this.viewMenuROIs = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("ROIs", renderer), "Toggle ROIs (Surface)", this.fontSize, false);
        viewMenu.add(this.viewMenuROIs);
        viewMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        viewMenu.addMenuListener(this);
        return viewMenu;
    }

    private MangoMenu makeWindowMenu(SurfaceViewer renderer) {
        MangoMenu windowMenu = new MangoMenu("Window", this.fontSize, true);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem windowMenuMaximize = new MangoMenuItem(new SurfaceViewerMenuAction("Maximize", renderer), "Maximize Window (Surface)", this.fontSize, false);
        windowMenu.add(windowMenuMaximize);
        MangoMenuItem windowMenuMinimize = new MangoMenuItem(new SurfaceViewerMenuAction("Dock", renderer), null, this.fontSize, false);
        windowMenuMinimize.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuMinimize);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem windowMenuZoomIn = new MangoMenuItem(new SurfaceViewerMenuAction("Zoom In", renderer), null, this.fontSize, false);
        windowMenuZoomIn.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuZoomIn);
        MangoMenuItem windowMenuZoomOut = new MangoMenuItem(new SurfaceViewerMenuAction("Zoom Out", renderer), null, this.fontSize, false);
        windowMenuZoomOut.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuZoomOut);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowMenuSticky = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Stick to Slice Viewer", renderer), "Sticky Window (Surface)", this.fontSize, true);
        windowMenu.add(this.windowMenuSticky);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        windowMenu.addMenuListener(this);
        return windowMenu;
    }

    private void updateExportMenu() {
        this.fileExportMenu.removeAll();
        Map<String, SurfaceFormat> allFormats = SurfaceReader.getLoadedFormats();
        if (allFormats.size() > 1) {
            Collection<SurfaceFormat> values = allFormats.values();
            for (SurfaceFormat aFormat : values) {
                String name = PluginManagerDialog.getPluginName(aFormat);
                if (name.equals("Mango Surface")) continue;
                MangoMenuItem formatItem = new MangoMenuItem(new SurfaceViewerMenuAction("As " + name + "...", this.renderer), "Export As " + name + " (Surface)", this.fontSize, false);
                formatItem.setActionCommand("Export As" + name);
                formatItem.setText("As " + name + "...");
                this.fileExportMenu.add(formatItem);
            }
        } else {
            MangoMenuItem formatItem = new MangoMenuItem("No formats loaded", null, this.fontSize, false);
            formatItem.setEnabled(false);
            this.fileExportMenu.add(formatItem);
        }
    }

    private void updateImportMenu() {
        this.fileImportMenu.removeAll();
        MangoMenuItem formatItem = new MangoMenuItem(new SurfaceViewerMenuAction("Colors As GIFTI Labels...", this.renderer), "Import Colors As GIFTI Labels... (Surface)", this.fontSize, false);
        formatItem.setActionCommand("Import AsGIFTI Labels");
        formatItem.setText("Colors As GIFTI (Labels)...");
        this.fileImportMenu.add(formatItem);
        formatItem = new MangoMenuItem(new SurfaceViewerMenuAction("Colors As GIFTI RGBA...", this.renderer), "Import Colors As GIFTI RGBA... (Surface)", this.fontSize, false);
        formatItem.setActionCommand("Import AsGIFTI RGBA");
        formatItem.setText("Colors as GIFTI (RGBA)...");
        this.fileImportMenu.add(formatItem);
    }

    private void updateMenu(SurfaceViewer renderer) {
        this.updateViewMenu(renderer);
        this.updateSurfaceMenu(renderer);
        this.updateShapesMenu(renderer);
        this.updateWindowMenu(renderer);
        this.updateExportMenu();
    }

    private void updateShapesMenu(SurfaceViewer renderer) {
        this.shapesMenu.removeAll();
        this.shapesMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        boolean hasOverlays = renderer.getViewer().hasOverlays();
        boolean hasROI = renderer.getViewer().getROIManager().hasROI();
        boolean hasLogical = renderer.getViewer().getLogicalManager() != null && renderer.getViewer().getLogicalManager().hasLogicals();
        MangoMenuItem shapesMenuLoad = new MangoMenuItem(new SurfaceViewerMenuAction("Load from File...", renderer), "Load Shape From File (Surface)", this.fontSize, true);
        this.shapesMenu.add(shapesMenuLoad);
        MangoMenuItem shapesMenuAddOverlay = new MangoMenuItem(new SurfaceViewerMenuAction("Add Overlay...", renderer), "Add Overlay (Surface)", this.fontSize, false);
        shapesMenuAddOverlay.setEnabled(hasOverlays);
        this.shapesMenu.add(shapesMenuAddOverlay);
        MangoMenuItem shapesMenuAddLogical = new MangoMenuItem(new SurfaceViewerMenuAction("Add Logical...", renderer), "Add Logical (Surface)", this.fontSize, false);
        shapesMenuAddLogical.setEnabled(hasLogical);
        this.shapesMenu.add(shapesMenuAddLogical);
        MangoMenuItem shapesMenuAddROI = new MangoMenuItem(new SurfaceViewerMenuAction("Add ROI...", renderer), "Add ROI (Surface)", this.fontSize, false);
        shapesMenuAddROI.setEnabled(hasROI);
        this.shapesMenu.add(shapesMenuAddROI);
        Vector<CompositeSurface> shapes = renderer.getShapes();
        Iterator<CompositeSurface> it = shapes.iterator();
        this.shapesMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        boolean addedShapes = false;
        boolean measureableAddedShapes = false;
        while (it.hasNext()) {
            CompositeSurface shape = it.next();
            if (shape.isBaseSurface()) continue;
            addedShapes = true;
            measureableAddedShapes = true;
            String name = shape.getName();
            MangoMenu nameMenu = new MangoMenu(name, this.fontSize, false);
            MangoMenuItem color = new MangoMenuItem(new SurfaceViewerMenuAction("Material Shape" + shape.hashCode(), renderer), null, this.fontSize, false);
            color.setText("Material...");
            color.setActionCommand("Material Shape" + shape.hashCode());
            MangoMenuItem areaItem = new MangoMenuItem(new SurfaceViewerMenuAction("Measure" + shape.hashCode(), renderer), null, this.fontSize, false);
            areaItem.setText("Measure");
            areaItem.setActionCommand("Measure" + shape.hashCode());
            MangoCheckBoxMenuItem useTransform = new MangoCheckBoxMenuItem(new SurfaceViewerMenuAction("Transform" + shape.hashCode(), renderer), null, this.fontSize, false);
            useTransform.setText("Transform");
            useTransform.setActionCommand("Transform" + shape.hashCode());
            useTransform.setSelected(shape.isUseTransform());
            MangoMenuItem hide = new MangoMenuItem("", null, this.fontSize, false);
            ((AbstractButton)hide).setAction(new SurfaceViewerMenuAction("Hide Shape" + shape.hashCode(), renderer));
            hide.setText(shape.isVisible() ? "Hide" : "Show");
            hide.setActionCommand("Hide Shape" + shape.hashCode());
            MangoMenuItem remove = new MangoMenuItem(new SurfaceViewerMenuAction("Remove Shape" + shape.hashCode(), renderer), null, this.fontSize, false);
            remove.setText("Remove");
            remove.setActionCommand("Remove Shape" + shape.hashCode());
            nameMenu.add(color);
            nameMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            nameMenu.add(useTransform);
            nameMenu.add(areaItem);
            nameMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            nameMenu.add(hide);
            nameMenu.add(remove);
            this.shapesMenu.add(nameMenu);
        }
        Collection<Marker> markers = renderer.getMarkers();
        Iterator<Marker> itMarkers = markers.iterator();
        while (itMarkers.hasNext()) {
            addedShapes = true;
            Marker marker = itMarkers.next();
            String coorStr = marker.toString();
            MangoMenu nameMenu = new MangoMenu(coorStr, this.fontSize, false);
            nameMenu.setItalic(marker.getSyncObject() == null);
            MangoMenuItem gotoItem = new MangoMenuItem(new SurfaceViewerMenuAction("Marker Goto" + coorStr, renderer), null, this.fontSize, false);
            gotoItem.setText("Go To");
            gotoItem.setActionCommand("Marker Goto" + coorStr);
            MangoMenu lineMenu = new MangoMenu("Line To", this.fontSize, false);
            for (Marker markerLine : markers) {
                String markerStr = markerLine.toString();
                if (markerStr.equals(coorStr)) continue;
                MangoMenuItem lineItem = new MangoMenuItem(new SurfaceViewerMenuAction(markerStr, renderer), null, this.fontSize, false);
                lineItem.setActionCommand("Marker Line To" + coorStr + "|" + markerStr);
                lineItem.setEnabled(!renderer.hasLine(marker.getPoint(), markerLine.getPoint()));
                lineMenu.add(lineItem);
            }
            MangoMenu lineSurfaceMenu = new MangoMenu("Surface To", this.fontSize, false);
            Iterator<Marker> itMarkersLine = markers.iterator();
            boolean surfacePointsAdded = false;
            while (itMarkersLine.hasNext()) {
                Marker markerLine = itMarkersLine.next();
                String markerStr = markerLine.toString();
                if (!markerLine.isFromSurface() || markerStr.equals(coorStr)) continue;
                MangoMenuItem lineItem = new MangoMenuItem(new SurfaceViewerMenuAction(markerStr, renderer), null, this.fontSize, false);
                lineItem.setActionCommand("Marker Surface To" + coorStr + "|" + markerStr);
                lineItem.setEnabled(!renderer.hasSurfaceLine(marker.getPoint(), markerLine.getPoint()));
                surfacePointsAdded = true;
                lineSurfaceMenu.add(lineItem);
            }
            MangoMenuItem lineSelect = new MangoMenuItem(new SurfaceViewerMenuAction("Marker Line To Current" + coorStr, renderer), null, this.fontSize, false);
            lineSelect.setText("Current Coordinate");
            lineSelect.setActionCommand("Marker Line To Current" + coorStr);
            lineMenu.add(lineSelect);
            MangoMenuItem hide = new MangoMenuItem("", null, this.fontSize, false);
            ((AbstractButton)hide).setAction(new SurfaceViewerMenuAction("Marker Hide" + coorStr, renderer));
            hide.setText(marker.isVisible() ? "Hide" : "Show");
            hide.setActionCommand("Marker Hide" + coorStr);
            MangoMenuItem remove = new MangoMenuItem(new SurfaceViewerMenuAction("Marker Remove" + coorStr, renderer), null, this.fontSize, false);
            remove.setText("Remove");
            remove.setActionCommand("Marker Remove" + coorStr);
            nameMenu.add(gotoItem);
            nameMenu.add(lineMenu);
            if (marker.isFromSurface() && surfacePointsAdded) {
                nameMenu.add(lineSurfaceMenu);
            }
            nameMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            nameMenu.add(hide);
            nameMenu.add(remove);
            this.shapesMenu.add(nameMenu);
        }
        Collection<MarkerLine> markerLines = renderer.getMarkerLines();
        Iterator<MarkerLine> itMarkerLines = markerLines.iterator();
        while (itMarkerLines.hasNext()) {
            addedShapes = true;
            measureableAddedShapes = true;
            MarkerLine ml = itMarkerLines.next();
            Point3d endPoint = ml.getEndPoint();
            String coorStr = ml.toString();
            MangoMenu nameMenu = new MangoMenu(coorStr, this.fontSize, false);
            nameMenu.setItalic(ml.getSyncObject() == null);
            MangoMenuItem gotoItem = new MangoMenuItem(new SurfaceViewerMenuAction("MarkerLine Goto Next" + coorStr, renderer), null, this.fontSize, false);
            gotoItem.setText("Go To Next");
            gotoItem.setActionCommand("MarkerLine Goto Next" + coorStr);
            MangoMenu lineMenu = new MangoMenu("Line To", this.fontSize, false);
            for (Marker markerLine : markers) {
                String markerStr = markerLine.toString();
                if (endPoint.equals((Tuple3d)markerLine.getPoint())) continue;
                MangoMenuItem lineItem = new MangoMenuItem(new SurfaceViewerMenuAction(markerStr, renderer), null, this.fontSize, false);
                lineItem.setActionCommand("MarkerLine Line To" + coorStr + "|" + markerStr);
                lineItem.setEnabled(!renderer.hasLine(ml.getEndPoint(), markerLine.getPoint()));
                lineMenu.add(lineItem);
            }
            MangoMenuItem lineSelect = new MangoMenuItem(new SurfaceViewerMenuAction("MarkerLine Line To Current" + coorStr, renderer), null, this.fontSize, false);
            lineSelect.setText("Current Coordinate");
            lineSelect.setActionCommand("MarkerLine Line To Current" + coorStr);
            lineMenu.add(lineSelect);
            MangoMenuItem measure = new MangoMenuItem(new SurfaceViewerMenuAction("MarkerLine Measure" + coorStr, renderer), null, this.fontSize, false);
            measure.setText("Measure");
            measure.setActionCommand("MarkerLine Measure" + coorStr);
            MangoMenuItem hide = new MangoMenuItem("", null, this.fontSize, false);
            ((AbstractButton)hide).setAction(new SurfaceViewerMenuAction("MarkerLine Hide" + coorStr, renderer));
            hide.setText(ml.isVisible() ? "Hide" : "Show");
            hide.setActionCommand("MarkerLine Hide" + coorStr);
            MangoMenuItem remove = new MangoMenuItem(new SurfaceViewerMenuAction("MarkerLine Remove" + coorStr, renderer), null, this.fontSize, false);
            remove.setText("Remove");
            remove.setActionCommand("MarkerLine Remove" + coorStr);
            nameMenu.add(gotoItem);
            nameMenu.add(lineMenu);
            nameMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            nameMenu.add(measure);
            nameMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            nameMenu.add(hide);
            nameMenu.add(remove);
            this.shapesMenu.add(nameMenu);
        }
        if (addedShapes) {
            boolean hasVisibleShapes = renderer.hasVisibleShapes();
            this.shapesMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            this.shapesMenuHideAll = new MangoMenuItem(new SurfaceViewerMenuAction("Hide All", renderer), "Hide All Shapes (Surface)", this.fontSize, false);
            this.shapesMenuHideAll.setText(hasVisibleShapes ? "Hide All" : "Show All");
            this.shapesMenuHideAll.setActionCommand("Hide All");
            this.shapesMenu.add(this.shapesMenuHideAll);
            this.shapesMenuRemoveAll = new MangoMenuItem(new SurfaceViewerMenuAction("Remove All", renderer), "Remove All Shapes (Surface)", this.fontSize, false);
            this.shapesMenu.add(this.shapesMenuRemoveAll);
            if (measureableAddedShapes) {
                this.shapesMenuMeasureAll = new MangoMenuItem(new SurfaceViewerMenuAction("Measure All", renderer), "Measure All Shapes (Surface)", this.fontSize, false);
                this.shapesMenu.add(this.shapesMenuMeasureAll);
            }
            this.shapesMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        }
    }

    private void updateSurfaceMenu(SurfaceViewer renderer) {
        SurfacePreferences viewPrefs = renderer.getPreferences();
        this.surfaceMenuAxialCutPlaneMenuSup.setSelected(viewPrefs.getAxialCutPlane() == -1);
        this.surfaceMenuAxialCutPlaneMenuInf.setSelected(viewPrefs.getAxialCutPlane() == 1);
        this.surfaceMenuAxialCutPlaneMenu.setItalic(viewPrefs.isUsingAxialCutPlane());
        this.surfaceMenuCoronalCutPlaneMenuAnt.setSelected(viewPrefs.getCoronalCutPlane() == 1);
        this.surfaceMenuCoronalCutPlaneMenuPos.setSelected(viewPrefs.getCoronalCutPlane() == -1);
        this.surfaceMenuCoronalCutPlaneMenu.setItalic(viewPrefs.isUsingCoronalCutPlane());
        this.surfaceMenuSagittalCutPlaneMenuLeft.setSelected(viewPrefs.getSagittalCutPlane() == -1);
        this.surfaceMenuSagittalCutPlaneMenuRight.setSelected(viewPrefs.getSagittalCutPlane() == 1);
        this.surfaceMenuSagittalCutPlaneMenu.setItalic(viewPrefs.isUsingSagittalCutPlane());
        this.surfaceMenuAllCutPlanes.setSelected(viewPrefs.isUsingAxialCutPlane() && viewPrefs.isUsingCoronalCutPlane() && viewPrefs.isUsingSagittalCutPlane());
        this.surfaceMenuObliqueCutPlane.setSelected(viewPrefs.isUsingObliqueCutPlane());
        this.surfaceMenuAnimate.setSelected(renderer.isAnimating());
        this.surfaceMenuMeasure.setEnabled(!renderer.isObliqueCutPlane());
    }

    private void updateViewMenu(SurfaceViewer renderer) {
        SurfacePreferences viewPrefs = renderer.getPreferences();
        this.viewMenuCrosshairs.setSelected(viewPrefs.isShowCrosshairs());
        if (viewPrefs.getShowActivePlanes() == 0) {
            this.viewMenuAllSlicePlanes.setSelected(false);
            this.viewMenuMainSlicePlane.setSelected(false);
        } else if (viewPrefs.getShowActivePlanes() == 2) {
            this.viewMenuAllSlicePlanes.setSelected(true);
            this.viewMenuMainSlicePlane.setSelected(false);
        } else if (viewPrefs.getShowActivePlanes() == 1) {
            this.viewMenuAllSlicePlanes.setSelected(false);
            this.viewMenuMainSlicePlane.setSelected(true);
        }
        this.viewMenuOrientation.setSelected(viewPrefs.isShowOrientation());
        this.viewMenuShapes.setSelected(viewPrefs.isShowShapes());
        this.viewMenuSurface.setSelected(renderer.getBaseSurface() != null && !renderer.getBaseSurface().isHidden());
        this.viewMenuSlices.setSelected(viewPrefs.isShowSlices());
        this.viewMenuROIs.setSelected(viewPrefs.isShowDynamicROI());
        this.viewMenuRuler.setSelected(viewPrefs.isShowRuler());
        this.viewMenuAngle.setSelected(viewPrefs.isShowAngle());
    }

    private void updateWindowMenu(SurfaceViewer renderer) {
        this.windowMenuSticky.setSelected(renderer.getFrame() != null && renderer.getFrame().isSticky());
    }

    private void createMenuItemMap() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            String text;
            String name;
            JMenuItem item;
            if (field.getType().isAssignableFrom(JMenuItem.class)) {
                item = null;
                try {
                    item = (JMenuItem)field.get(this);
                }
                catch (IllegalArgumentException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    AppLogger.error((Throwable)ex);
                }
                if (item == null) continue;
                name = item.getName();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    MENU_ACTION_MAP.put(name, item);
                }
                if (!StringUtils.isNotBlank((CharSequence)(text = item.getText()))) continue;
                MENU_NAME_MAP.put(text, item);
                continue;
            }
            if (!field.getType().isAssignableFrom(JCheckBoxMenuItem.class)) continue;
            item = null;
            try {
                item = (JCheckBoxMenuItem)field.get(this);
            }
            catch (IllegalArgumentException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            if (item == null) continue;
            name = item.getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                MENU_ACTION_MAP.put(name, item);
            }
            if (!StringUtils.isNotBlank((CharSequence)(text = item.getText()))) continue;
            MENU_NAME_MAP.put(text, item);
        }
    }

    private void clearAllAccelerators() {
        Collection<JMenuItem> items = MENU_ACTION_MAP.values();
        for (JMenuItem item : items) {
            item.setAccelerator(null);
        }
    }

    public void updateAllAccelerators(String[] actions) {
        this.clearAllAccelerators();
        for (int ctr = 0; ctr < actions.length; ++ctr) {
            String actionLabel = actions[ctr];
            JMenuItem item = MENU_ACTION_MAP.get(actionLabel);
            if (item == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(MangoPreferences.FUNCTION_KEY_CODES.get(ctr), 0));
        }
    }

    public JMenuItem getMenuItem(String action) {
        JMenuItem item = MENU_ACTION_MAP.get(action);
        if (item == null) {
            item = MENU_NAME_MAP.get(action);
        }
        return item;
    }
}

