/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceUpdater;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LightingDialog
extends JPanel
implements ChangeListener,
ActionListener {
    private final JSlider ambientSlider;
    private final JSlider diffuseSlider;
    private final JSlider directionXSlider;
    private final JSlider directionYSlider;
    private final JSlider specularSlider;
    private final JTextField ambientText;
    private final JTextField diffuseText;
    private final JTextField directionXText;
    private final JTextField directionYText;
    private final JTextField specularText;
    private final Lighting tempLighting;
    private final SurfaceUpdater updater;
    private final boolean inited;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final long serialVersionUID = 1L;

    public LightingDialog(Lighting lighting, SurfaceUpdater updater) {
        this.updater = updater;
        this.tempLighting = new Lighting(lighting);
        lighting.setTempLighting(this.tempLighting);
        JLabel ambientLabel = new JLabel("Ambient");
        this.ambientSlider = new JSlider(0, 100, Math.round(this.tempLighting.getAmbient() * 100.0f));
        this.ambientSlider.addChangeListener(this);
        this.ambientSlider.setMaximumSize(this.ambientSlider.getPreferredSize());
        this.ambientSlider.setMinimumSize(this.ambientSlider.getPreferredSize());
        this.ambientText = new MangoTextField(FORMATTER.format(this.tempLighting.getAmbient()), 4);
        this.ambientText.setMaximumSize(this.ambientText.getPreferredSize());
        this.ambientText.setMinimumSize(this.ambientText.getPreferredSize());
        this.ambientText.addActionListener(this);
        JPanel ambientPanel = new JPanel();
        ambientPanel.setLayout(new BoxLayout(ambientPanel, 0));
        ambientPanel.add(Box.createHorizontalStrut(8));
        ambientPanel.add(ambientLabel);
        ambientPanel.add(Box.createHorizontalGlue());
        ambientPanel.add(this.ambientSlider);
        ambientPanel.add(Box.createHorizontalStrut(4));
        ambientPanel.add(this.ambientText);
        ambientPanel.add(Box.createHorizontalStrut(8));
        JLabel diffuseLabel = new JLabel("Diffuse");
        this.diffuseSlider = new JSlider(0, 100, Math.round(this.tempLighting.getDiffuse() * 100.0f));
        this.diffuseSlider.addChangeListener(this);
        this.diffuseSlider.setMaximumSize(this.diffuseSlider.getPreferredSize());
        this.diffuseSlider.setMinimumSize(this.diffuseSlider.getPreferredSize());
        this.diffuseText = new MangoTextField(FORMATTER.format(this.tempLighting.getDiffuse()), 4);
        this.diffuseText.setMaximumSize(this.diffuseText.getPreferredSize());
        this.diffuseText.setMinimumSize(this.diffuseText.getPreferredSize());
        this.diffuseText.addActionListener(this);
        JPanel diffusePanel = new JPanel();
        diffusePanel.setLayout(new BoxLayout(diffusePanel, 0));
        diffusePanel.add(Box.createHorizontalStrut(8));
        diffusePanel.add(diffuseLabel);
        diffusePanel.add(Box.createHorizontalGlue());
        diffusePanel.add(this.diffuseSlider);
        diffusePanel.add(Box.createHorizontalStrut(4));
        diffusePanel.add(this.diffuseText);
        diffusePanel.add(Box.createHorizontalStrut(8));
        JLabel specularLabel = new JLabel("Specular");
        this.specularSlider = new JSlider(0, 100, Math.round(this.tempLighting.getSpecular() * 100.0f));
        this.specularSlider.addChangeListener(this);
        this.specularSlider.setMaximumSize(this.specularSlider.getPreferredSize());
        this.specularSlider.setMinimumSize(this.specularSlider.getPreferredSize());
        this.specularText = new MangoTextField(FORMATTER.format(this.tempLighting.getSpecular()), 4);
        this.specularText.setMaximumSize(this.specularText.getPreferredSize());
        this.specularText.setMinimumSize(this.specularText.getPreferredSize());
        this.specularText.addActionListener(this);
        JPanel specularPanel = new JPanel();
        specularPanel.setLayout(new BoxLayout(specularPanel, 0));
        specularPanel.add(Box.createHorizontalStrut(8));
        specularPanel.add(specularLabel);
        specularPanel.add(Box.createHorizontalGlue());
        specularPanel.add(this.specularSlider);
        specularPanel.add(Box.createHorizontalStrut(4));
        specularPanel.add(this.specularText);
        specularPanel.add(Box.createHorizontalStrut(8));
        JPanel directionXSliderPanel = new JPanel();
        this.directionXSlider = new JSlider(-100, 100, Math.round(this.tempLighting.getDirection()[0] * 100.0f));
        this.directionXSlider.addChangeListener(this);
        this.directionXSlider.setMaximumSize(this.directionXSlider.getPreferredSize());
        this.directionXSlider.setMinimumSize(this.directionXSlider.getPreferredSize());
        this.directionXText = new MangoTextField(FORMATTER.format(this.tempLighting.getDirection()[0]), 4);
        this.directionXText.setMaximumSize(this.directionXText.getPreferredSize());
        this.directionXText.setMinimumSize(this.directionXText.getPreferredSize());
        this.directionXText.addActionListener(this);
        directionXSliderPanel.setLayout(new BoxLayout(directionXSliderPanel, 0));
        directionXSliderPanel.add(Box.createHorizontalStrut(8));
        directionXSliderPanel.add(Box.createHorizontalGlue());
        directionXSliderPanel.add(new JLabel("Horizontal"));
        directionXSliderPanel.add(Box.createHorizontalGlue());
        directionXSliderPanel.add(this.directionXSlider);
        directionXSliderPanel.add(Box.createHorizontalStrut(4));
        directionXSliderPanel.add(this.directionXText);
        directionXSliderPanel.add(Box.createHorizontalStrut(8));
        JPanel directionYSliderPanel = new JPanel();
        this.directionYSlider = new JSlider(-100, 100, Math.round(this.tempLighting.getDirection()[1] * 100.0f));
        this.directionYSlider.addChangeListener(this);
        this.directionYSlider.setMaximumSize(this.directionYSlider.getPreferredSize());
        this.directionYSlider.setMinimumSize(this.directionYSlider.getPreferredSize());
        this.directionYText = new MangoTextField(FORMATTER.format(this.tempLighting.getDirection()[1]), 4);
        this.directionYText.setMaximumSize(this.directionYText.getPreferredSize());
        this.directionYText.setMinimumSize(this.directionYText.getPreferredSize());
        this.directionYText.addActionListener(this);
        directionYSliderPanel.setLayout(new BoxLayout(directionYSliderPanel, 0));
        directionYSliderPanel.add(Box.createHorizontalStrut(8));
        directionYSliderPanel.add(Box.createHorizontalGlue());
        directionYSliderPanel.add(new JLabel("Vertical"));
        directionYSliderPanel.add(Box.createHorizontalGlue());
        directionYSliderPanel.add(this.directionYSlider);
        directionYSliderPanel.add(Box.createHorizontalStrut(4));
        directionYSliderPanel.add(this.directionYText);
        directionYSliderPanel.add(Box.createHorizontalStrut(8));
        JPanel directionLabelPanel = new JPanel();
        directionLabelPanel.setLayout(new BoxLayout(directionLabelPanel, 0));
        directionLabelPanel.add(Box.createHorizontalGlue());
        directionLabelPanel.add(new JLabel("Position"));
        directionLabelPanel.add(Box.createHorizontalGlue());
        JPanel directionPanel = new JPanel();
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        directionPanel.add(Box.createHorizontalGlue());
        directionPanel.add(directionLabelPanel);
        directionPanel.add(Box.createHorizontalStrut(8));
        directionPanel.add(directionXSliderPanel);
        directionPanel.add(Box.createHorizontalStrut(4));
        directionPanel.add(directionYSliderPanel);
        directionPanel.add(Box.createHorizontalStrut(4));
        directionPanel.add(Box.createHorizontalStrut(4));
        directionPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(ambientPanel);
        this.add(Box.createVerticalStrut(2));
        this.add(diffusePanel);
        this.add(Box.createVerticalStrut(2));
        this.add(specularPanel);
        this.add(Box.createVerticalStrut(12));
        this.add(directionPanel);
        this.inited = true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        float value = 0.2f;
        try {
            value = Float.parseFloat(this.ambientText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.ambientText.setText(FORMATTER.format(0.2f));
        }
        this.ambientSlider.setValue(Math.round(value * 100.0f));
        value = 0.9f;
        try {
            value = Float.parseFloat(this.diffuseText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.diffuseText.setText(FORMATTER.format(0.9f));
        }
        this.diffuseSlider.setValue(Math.round(value * 100.0f));
        value = 0.4f;
        try {
            value = Float.parseFloat(this.specularText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.specularText.setText(FORMATTER.format(0.4f));
        }
        this.specularSlider.setValue(Math.round(value * 100.0f));
        value = Lighting.DEFAULT_DIRECTION.get(0).floatValue();
        try {
            value = Float.parseFloat(this.directionXText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.directionXText.setText(FORMATTER.format(Lighting.DEFAULT_DIRECTION.get(0).floatValue()));
        }
        this.directionXSlider.setValue(Math.round(value * 100.0f));
        value = Lighting.DEFAULT_DIRECTION.get(1).floatValue();
        try {
            value = Float.parseFloat(this.directionYText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.directionXText.setText(FORMATTER.format(Lighting.DEFAULT_DIRECTION.get(0).floatValue()));
        }
        this.directionYSlider.setValue(Math.round(value * 100.0f));
    }

    public float getAmbient() {
        return (float)this.ambientSlider.getValue() / 100.0f;
    }

    public float getDiffuse() {
        return (float)this.diffuseSlider.getValue() / 100.0f;
    }

    public float[] getDirection() {
        float[] value = new float[]{(float)this.directionXSlider.getValue() / 100.0f, (float)this.directionYSlider.getValue() / 100.0f, 1.0f};
        return value;
    }

    public Lighting getLighting() {
        return this.tempLighting;
    }

    public float getSpecular() {
        return (float)this.specularSlider.getValue() / 100.0f;
    }

    public void setToDefault() {
        this.ambientSlider.setValue(Math.round(20.0f));
        this.diffuseSlider.setValue(Math.round(90.0f));
        this.specularSlider.setValue(Math.round(40.0f));
        this.directionXSlider.setValue(Math.round(Lighting.DEFAULT_DIRECTION.get(0).floatValue() * 100.0f));
        this.directionYSlider.setValue(Math.round(Lighting.DEFAULT_DIRECTION.get(1).floatValue() * 100.0f));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.inited) {
            this.tempLighting.setLightingParameters(this.getAmbient(), this.getDiffuse(), this.getSpecular());
            this.tempLighting.setLightingDirection(this.getDirection());
            this.ambientText.setText(FORMATTER.format((float)this.ambientSlider.getValue() / 100.0f));
            this.diffuseText.setText(FORMATTER.format((float)this.diffuseSlider.getValue() / 100.0f));
            this.specularText.setText(FORMATTER.format((float)this.specularSlider.getValue() / 100.0f));
            this.directionXText.setText(FORMATTER.format((float)this.directionXSlider.getValue() / 100.0f));
            this.directionYText.setText(FORMATTER.format((float)this.directionYSlider.getValue() / 100.0f));
            this.updater.updateSurface();
        }
    }
}

