/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs.modal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class BackgroundDialog
extends JPanel
implements ActionListener {
    private Color currentColor;
    private JColorChooser colorChooser;
    private final Color defaultColor;
    private final JPanel colorSwatchPanel;
    private static final long serialVersionUID = 1L;
    public static final int SWATCH_SIZE = 25;

    public BackgroundDialog(Color currentColor, Color defaultColor) {
        this.currentColor = currentColor;
        this.defaultColor = defaultColor;
        JButton colorButton = new JButton("Select Color...");
        colorButton.setFocusable(false);
        colorButton.addActionListener(this);
        this.colorSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(BackgroundDialog.this.currentColor.getRed(), BackgroundDialog.this.currentColor.getGreen(), BackgroundDialog.this.currentColor.getBlue()));
                g.fillRect(0, 0, 25, 25);
            }
        };
        this.colorSwatchPanel.setPreferredSize(new Dimension(25, 25));
        this.colorSwatchPanel.setMaximumSize(this.colorSwatchPanel.getPreferredSize());
        this.colorSwatchPanel.setMinimumSize(this.colorSwatchPanel.getPreferredSize());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(colorButton);
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(this.colorSwatchPanel);
        colorPanel.add(Box.createHorizontalStrut(8));
        JPanel colorPanel2 = new JPanel();
        colorPanel2.setLayout(new BoxLayout(colorPanel2, 1));
        colorPanel2.add(colorPanel);
        colorPanel2.add(Box.createVerticalStrut(4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(colorPanel2);
        this.add(Box.createVerticalStrut(8));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Select Color...")) {
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, "Colors", true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (actionCommand.equals("OK")) {
            this.currentColor = this.colorChooser.getColor();
            this.colorSwatchPanel.repaint();
        } else if (actionCommand.equals("Update")) {
            this.colorSwatchPanel.repaint();
        }
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setToDefault() {
        this.currentColor = this.defaultColor;
        this.colorSwatchPanel.repaint();
    }
}

