/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs.cine;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.dialogs.cine.AbstractCine;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CineSurface
extends AbstractCine {
    private final SurfaceViewer renderer;
    private static final long serialVersionUID = 1L;

    public CineSurface(SliceViewer viewer, VideoCaptureManager videoCaptureManager) {
        this(viewer, videoCaptureManager, false);
    }

    public CineSurface(SliceViewer viewer, VideoCaptureManager videoCaptureManager, boolean silent) {
        super(viewer, videoCaptureManager, silent);
        this.renderer = viewer.getSurfaceRender();
    }

    @Override
    public void animate() {
        this.viewer.setNavigationDisabled(true);
        this.viewer.setStopPaintingState(true);
        this.storeRecordingParameters();
        this.recordButton.setEnabled(false);
        this.recordButton.setText("Animating");
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CineSurface.this.doAnimate();
            }
        });
        workThread.start();
    }

    @Override
    public Recordable getRecordable() {
        return this.renderer;
    }

    private void doAnimate() {
        final Vector<BufferedImage> frames = new Vector<BufferedImage>();
        final ProgressMeter progressBar = this.viewer.makeProgressMeter();
        progressBar.setDescription("Recording Animation");
        progressBar.start(0, 0, 360);
        this.renderer.setAnimating(true);
        this.viewer.updateSurfaceTextures(true);
        for (int ctr = 0; ctr < 360; ++ctr) {
            frames.add(this.renderer.captureImage());
            this.renderer.getPosition().rotateX();
            progressBar.setValue(ctr);
        }
        if (this.isSilent()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setValue(progressBar.getMax());
                        CineSurface.this.renderer.setAnimating(false);
                        CineSurface.this.viewer.setStopPaintingState(false);
                        CineSurface.this.viewer.setNavigationDisabled(false);
                        CineSurface.this.viewer.updateViewer();
                    }
                });
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.stopSilently(frames);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    progressBar.setValue(progressBar.getMax());
                    CineSurface.this.renderer.setAnimating(false);
                    CineSurface.this.viewer.setStopPaintingState(false);
                    CineSurface.this.viewer.setNavigationDisabled(false);
                    CineSurface.this.viewer.updateViewer();
                    if (CineSurface.this.isSilent()) {
                        CineSurface.this.stopSilently(frames);
                    } else {
                        CineSurface.this.stop(frames);
                    }
                }
            });
        }
    }

    @Override
    public void updateLabels() {
        this.autoSlicesLabel.setText("surface view");
        this.recorderLabel.setText("Record surface view ");
        this.infoLabel.setText("<html><center>Creates a video of the surface view either as an automated<br>animation or a freeform recording.</center></html>");
    }

    @Override
    public void videoCaptureEnded() {
        this.stop();
    }

    @Override
    public double getFrameRateAdjuster(boolean isAnimate) {
        if (isAnimate) {
            return 2.0;
        }
        return 1.0;
    }

    @Override
    public void animateSilently() {
        this.viewer.setNavigationDisabled(true);
        this.viewer.setStopPaintingState(true);
        this.doAnimate();
    }
}

