/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs;

import Jama.Matrix;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.utilities.SurfaceUtils;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageTransform;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import javax.vecmath.Vector4d;

public class SurfaceObliquePlaneDialog
extends JFrame
implements ViewerAssociated,
ChangeListener,
ActionListener {
    private Coordinate[] coords;
    private ImageTransform obliqueTrans;
    private JLabel sliderRotXLabel;
    private JLabel sliderRotYLabel;
    private JLabel sliderRotZLabel;
    private JRadioButton axialButton;
    private JRadioButton coronalButton;
    private JRadioButton sagittalButton;
    private JSlider sliderRotX;
    private JSlider sliderRotY;
    private JSlider sliderRotZ;
    private JSlider sliderTrans;
    private Matrix sizeThis;
    private Matrix tempCoord;
    private Matrix tempMatrix;
    private double[][] center;
    private double[][] centerInverse;
    private double[][] obliqueTransform;
    private double[][] rotationX;
    private double[][] rotationY;
    private double[][] rotationZ;
    private double[][] transformTemp2;
    private double[][] transformTemp;
    private double[][] translation;
    private int direction;
    private final SliceViewer viewer;
    private final SurfaceViewer render;
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private static final long serialVersionUID = 1L;
    public static final String DESCRIPTION = "Oblique";
    public static final int ROT_MAX = 90;
    public static final int ROT_MIN = -90;
    public static final int TRANS_MAX = 50;
    public static final int TRANS_MIN = -50;

    public SurfaceObliquePlaneDialog(SurfaceViewer render) {
        this.render = render;
        this.viewer = render.getViewer();
        this.initializeTransforms();
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Axial")) {
            if (this.axialButton.isSelected()) {
                this.updateToAxial();
                this.updateTransform();
                this.render.updateSurface();
            }
        } else if (actionCommand.equals("Coronal")) {
            if (this.coronalButton.isSelected()) {
                this.updateToCoronal();
                this.updateTransform();
                this.render.updateSurface();
            }
        } else if (actionCommand.equals("Sagittal") && this.sagittalButton.isSelected()) {
            this.updateToSagittal();
            this.updateTransform();
            this.render.updateSurface();
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public int getDirection() {
        return this.direction;
    }

    public ImageTransform getImageTransform() {
        return this.obliqueTrans;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.updateTransform();
        this.render.updateSurface();
    }

    public boolean updateCutPlaneDirectionOptions() {
        this.axialButton.setEnabled(this.render.getPreferences().isUsingAxialCutPlane());
        this.coronalButton.setEnabled(this.render.getPreferences().isUsingCoronalCutPlane());
        this.sagittalButton.setEnabled(this.render.getPreferences().isUsingSagittalCutPlane());
        boolean needsChange = false;
        if (this.render.getObliqueCutPlaneDirection() == 0 && !this.axialButton.isEnabled()) {
            needsChange = true;
        } else if (this.render.getObliqueCutPlaneDirection() == 1 && !this.coronalButton.isEnabled()) {
            needsChange = true;
        } else if (this.render.getObliqueCutPlaneDirection() == 2 && !this.sagittalButton.isEnabled()) {
            needsChange = true;
        }
        return needsChange;
    }

    public void updateToAxial() {
        this.axialButton.setSelected(true);
        if (!this.render.getPreferences().isUsingAxialCutPlane()) {
            this.render.getPreferences().setAxialCutPlane(-1);
        }
        this.resetSliders();
        this.direction = 0;
        double[] points = this.render.getAxialPoints();
        this.coords[0].setValues(points[0], points[1], points[2]);
        this.coords[1].setValues(points[3], points[4], points[5]);
        this.coords[2].setValues(points[6], points[7], points[8]);
        this.updateSliderVisibility();
    }

    public void updateToCoronal() {
        this.coronalButton.setSelected(true);
        if (!this.render.getPreferences().isUsingCoronalCutPlane()) {
            this.render.getPreferences().setCoronalCutPlane(-1);
        }
        this.resetSliders();
        this.direction = 1;
        double[] points = this.render.getCoronalPoints();
        this.coords[0].setValues(points[0], points[1], points[2]);
        this.coords[1].setValues(points[3], points[4], points[5]);
        this.coords[2].setValues(points[6], points[7], points[8]);
        this.updateSliderVisibility();
    }

    public void updateToSagittal() {
        this.sagittalButton.setSelected(true);
        if (!this.render.getPreferences().isUsingSagittalCutPlane()) {
            this.render.getPreferences().setSagittalCutPlane(-1);
        }
        this.resetSliders();
        this.direction = 2;
        double[] points = this.render.getSagittalPoints();
        this.coords[0].setValues(points[0], points[1], points[2]);
        this.coords[1].setValues(points[3], points[4], points[5]);
        this.coords[2].setValues(points[6], points[7], points[8]);
        this.updateSliderVisibility();
    }

    public final void updateTransform() {
        int ctrIn;
        int ctrOut;
        this.clearTransforms();
        this.updateCenterTransforms();
        double theta = (double)this.sliderRotX.getValue() * Math.PI / 180.0;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        this.rotationX[1][1] = cosTheta;
        this.rotationX[1][2] = sinTheta;
        this.rotationX[2][1] = -1.0 * sinTheta;
        this.rotationX[2][2] = cosTheta;
        theta = (double)this.sliderRotY.getValue() * Math.PI / 180.0;
        cosTheta = Math.cos(theta);
        sinTheta = Math.sin(theta);
        this.rotationY[0][0] = cosTheta;
        this.rotationY[0][2] = -1.0 * sinTheta;
        this.rotationY[2][0] = sinTheta;
        this.rotationY[2][2] = cosTheta;
        theta = (double)this.sliderRotZ.getValue() * Math.PI / 180.0;
        cosTheta = Math.cos(theta);
        sinTheta = Math.sin(theta);
        this.rotationZ[0][0] = cosTheta;
        this.rotationZ[0][1] = sinTheta;
        this.rotationZ[1][0] = -1.0 * sinTheta;
        this.rotationZ[1][1] = cosTheta;
        if (this.direction == 0) {
            this.translation[2][3] = this.sliderTrans.getValue();
        } else if (this.direction == 1) {
            this.translation[1][3] = this.sliderTrans.getValue();
        } else if (this.direction == 2) {
            this.translation[0][3] = this.sliderTrans.getValue();
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.centerInverse[ctrOut][0] * this.rotationX[0][ctrIn] + this.centerInverse[ctrOut][1] * this.rotationX[1][ctrIn] + this.centerInverse[ctrOut][2] * this.rotationX[2][ctrIn] + this.centerInverse[ctrOut][3] * this.rotationX[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp2[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.rotationY[0][ctrIn] + this.transformTemp[ctrOut][1] * this.rotationY[1][ctrIn] + this.transformTemp[ctrOut][2] * this.rotationY[2][ctrIn] + this.transformTemp[ctrOut][3] * this.rotationY[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.transformTemp2[ctrOut][0] * this.rotationZ[0][ctrIn] + this.transformTemp2[ctrOut][1] * this.rotationZ[1][ctrIn] + this.transformTemp2[ctrOut][2] * this.rotationZ[2][ctrIn] + this.transformTemp2[ctrOut][3] * this.rotationZ[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp2[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.translation[0][ctrIn] + this.transformTemp[ctrOut][1] * this.translation[1][ctrIn] + this.transformTemp[ctrOut][2] * this.translation[2][ctrIn] + this.transformTemp[ctrOut][3] * this.translation[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.transformTemp2[ctrOut][0] * this.center[0][ctrIn] + this.transformTemp2[ctrOut][1] * this.center[1][ctrIn] + this.transformTemp2[ctrOut][2] * this.center[2][ctrIn] + this.transformTemp2[ctrOut][3] * this.center[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.obliqueTransform[ctrOut][ctrIn] = this.transformTemp[ctrOut][ctrIn];
            }
        }
        Matrix texturePlaneTransform = new Matrix(this.render.getPosition().convertTransformOrientation(this.obliqueTransform));
        double[][] cutPlaneTransform = this.sizeThis.times(new Matrix(this.obliqueTransform)).times(this.sizeThis.inverse()).getArrayCopy();
        double[][] cutPlaneImageTransform = new Matrix(this.viewer.getVolume().getImageTransform().getMatrixCopy()).times(new Matrix(cutPlaneTransform)).getArray();
        this.obliqueTrans.updateTransform(cutPlaneImageTransform);
        double[] points = this.render.getTexturePlanePoints(this.direction);
        Point3d p1 = this.transformPoint(points[0], points[1], points[2], texturePlaneTransform);
        Point3d p2 = this.transformPoint(points[3], points[4], points[5], texturePlaneTransform);
        Point3d p3 = this.transformPoint(points[6], points[7], points[8], texturePlaneTransform);
        Point3d p4 = this.transformPoint(points[9], points[10], points[11], texturePlaneTransform);
        this.render.setTexturePlane(p1, p2, p3, p4, this.direction);
        this.render.updateObliqueCutPlane(this.checkFlipping(SurfaceUtils.createPlane(p1, p2, p3, this.tempMatrix)), this.direction);
    }

    private Vector4d checkFlipping(Vector4d planeVal) {
        Vector4d plane = planeVal;
        if (this.axialButton.isSelected() && this.isAxialFlipped() || this.coronalButton.isSelected() && this.isCoronalFlipped() || this.sagittalButton.isSelected() && this.isSagittalFlipped()) {
            plane = SurfaceUtils.flipPlane(plane);
        }
        return plane;
    }

    private void clearTransforms() {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                double d = ctrOut == ctrIn ? 1 : 0;
                this.translation[ctrOut][ctrIn] = d;
                this.rotationZ[ctrOut][ctrIn] = d;
                this.rotationY[ctrOut][ctrIn] = d;
                this.rotationX[ctrOut][ctrIn] = d;
            }
        }
    }

    private void createUI() {
        this.sliderRotX = this.makeSlider(true);
        this.sliderRotXLabel = new JLabel("X");
        JPanel sliderRotXPanel = this.makeSliderPanel(this.sliderRotX, this.sliderRotXLabel);
        this.sliderRotY = this.makeSlider(true);
        this.sliderRotYLabel = new JLabel("Y");
        JPanel sliderRotYPanel = this.makeSliderPanel(this.sliderRotY, this.sliderRotYLabel);
        this.sliderRotZ = this.makeSlider(true);
        this.sliderRotZLabel = new JLabel("Z");
        JPanel sliderRotZPanel = this.makeSliderPanel(this.sliderRotZ, this.sliderRotZLabel);
        JLabel rotationLabel = new JLabel("Rotate");
        JPanel rotationLabelPanel = new JPanel();
        rotationLabelPanel.setLayout(new BoxLayout(rotationLabelPanel, 0));
        rotationLabelPanel.add(rotationLabel);
        JPanel rotationPanel = new JPanel();
        rotationPanel.setLayout(new BoxLayout(rotationPanel, 1));
        rotationPanel.add(rotationLabelPanel);
        rotationPanel.add(sliderRotXPanel);
        rotationPanel.add(sliderRotYPanel);
        rotationPanel.add(sliderRotZPanel);
        rotationPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.sliderTrans = this.makeSlider(false);
        JPanel sliderTransXPanel = this.makeSliderPanel(this.sliderTrans, new JLabel());
        JLabel translationLabel = new JLabel("Translate");
        JPanel translationLabelPanel = new JPanel();
        translationLabelPanel.setLayout(new BoxLayout(translationLabelPanel, 0));
        translationLabelPanel.add(translationLabel);
        JPanel translationPanel = new JPanel();
        translationPanel.setLayout(new BoxLayout(translationPanel, 1));
        translationPanel.add(translationLabelPanel);
        translationPanel.add(sliderTransXPanel);
        translationPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.add(rotationPanel);
        sliderPanel.add(translationPanel);
        sliderPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.axialButton = new JRadioButton("Axial");
        this.axialButton.setSelected(true);
        this.axialButton.addActionListener(this);
        this.coronalButton = new JRadioButton("Coronal");
        this.coronalButton.addActionListener(this);
        this.sagittalButton = new JRadioButton("Sagittal");
        this.sagittalButton.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.axialButton);
        bg.add(this.coronalButton);
        bg.add(this.sagittalButton);
        JPanel buttonLabelPanel = new JPanel();
        buttonLabelPanel.setLayout(new BoxLayout(buttonLabelPanel, 0));
        buttonLabelPanel.add(Box.createHorizontalGlue());
        buttonLabelPanel.add(new JLabel("Oblique Cut Plane"));
        buttonLabelPanel.add(Box.createHorizontalGlue());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.axialButton);
        buttonPanel.add(this.coronalButton);
        buttonPanel.add(this.sagittalButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(sliderPanel);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(buttonLabelPanel);
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.updateSliderVisibility();
        this.updateTransform();
        this.setTitle("Oblique: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setLocation(DisplayUtils.getNextWindowLocation(this.render.getFrame(), this.getSize(), null, true, false, false));
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(true);
        this.validate();
        this.requestFocus();
        this.toFront();
        this.repaint();
        this.viewer.associateWindow(this);
    }

    private void initializeTransforms() {
        this.tempMatrix = new Matrix(new double[3][3]);
        this.coords = new Coordinate[3];
        this.coords[0] = new Coordinate();
        this.coords[1] = new Coordinate();
        this.coords[2] = new Coordinate();
        this.tempCoord = new Matrix(4, 1);
        this.rotationX = new double[4][4];
        this.rotationY = new double[4][4];
        this.rotationZ = new double[4][4];
        this.translation = new double[4][4];
        this.center = new double[4][4];
        this.centerInverse = new double[4][4];
        this.transformTemp = new double[4][4];
        this.transformTemp2 = new double[4][4];
        this.obliqueTransform = new double[4][4];
        double[][] sizeThisArray = new double[4][4];
        sizeThisArray[0][0] = 1.0 / this.viewer.getXSize();
        sizeThisArray[1][1] = 1.0 / this.viewer.getYSize();
        sizeThisArray[2][2] = 1.0 / this.viewer.getZSize();
        sizeThisArray[3][3] = 1.0;
        this.sizeThis = new Matrix(sizeThisArray);
        this.obliqueTrans = this.viewer.getVolume().createTransform(new Matrix(IDENTITY));
    }

    private boolean isAxialFlipped() {
        return this.render.getPreferences().getAxialCutPlane() == 1;
    }

    private boolean isCoronalFlipped() {
        return this.render.getPreferences().getCoronalCutPlane() == 1;
    }

    private boolean isSagittalFlipped() {
        return this.render.getPreferences().getSagittalCutPlane() == 1;
    }

    private JSlider makeSlider(boolean isRotation) {
        JSlider slider = null;
        slider = isRotation ? new JSlider(-90, 90, 0) : new JSlider(-50, 50, 0);
        slider.addChangeListener(this);
        slider.setFocusable(false);
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(10);
        return slider;
    }

    private JPanel makeSliderPanel(JSlider slider, JLabel label) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label);
        panel.add(slider);
        return panel;
    }

    private void resetSliders() {
        this.sliderRotX.setValue(0);
        this.sliderRotY.setValue(0);
        this.sliderRotZ.setValue(0);
        this.sliderTrans.setValue(0);
    }

    private Point3d transformPoint(double xLoc, double yLoc, double zLoc, Matrix finalTrans) {
        this.tempCoord = new Matrix(4, 1);
        this.tempCoord.set(0, 0, xLoc);
        this.tempCoord.set(1, 0, yLoc);
        this.tempCoord.set(2, 0, zLoc);
        this.tempCoord.set(3, 0, 1.0);
        this.tempCoord = finalTrans.times(this.tempCoord);
        double xPos = this.tempCoord.get(0, 0);
        double yPos = this.tempCoord.get(1, 0);
        double zPos = this.tempCoord.get(2, 0);
        return new Point3d(xPos, yPos, zPos);
    }

    private void updateCenterTransforms() {
        double sagittalPos = (double)this.viewer.getXDim() / 2.0 * this.viewer.getXSize();
        double coronalPos = (double)this.viewer.getYDim() / 2.0 * this.viewer.getYSize();
        double axialPos = (double)this.viewer.getZDim() / 2.0 * this.viewer.getZSize();
        this.center[3][3] = 1.0;
        this.center[2][2] = 1.0;
        this.center[1][1] = 1.0;
        this.center[0][0] = 1.0;
        this.center[0][3] = -1.0 * sagittalPos;
        this.center[1][3] = -1.0 * coronalPos;
        this.center[2][3] = -1.0 * axialPos;
        this.centerInverse[3][3] = 1.0;
        this.centerInverse[2][2] = 1.0;
        this.centerInverse[1][1] = 1.0;
        this.centerInverse[0][0] = 1.0;
        this.centerInverse[0][3] = sagittalPos;
        this.centerInverse[1][3] = coronalPos;
        this.centerInverse[2][3] = axialPos;
    }

    private void updateSliderVisibility() {
        this.sliderRotX.setVisible(this.direction != 2);
        this.sliderRotY.setVisible(this.direction != 1);
        this.sliderRotZ.setVisible(this.direction != 0);
        this.sliderRotXLabel.setVisible(this.direction != 2);
        this.sliderRotYLabel.setVisible(this.direction != 1);
        this.sliderRotZLabel.setVisible(this.direction != 0);
    }
}

