/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.core.Triangle;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertexLoop;
import edu.uthscsa.ric.utilities.AppLogger;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class TriangleVertex {
    private boolean boundary;
    private boolean nearEdge;
    private int hashCode;
    protected Point3f averageCenter;
    protected Triangle[] triangles;
    protected Vector3f averageNormal;
    protected boolean isOrdered;
    protected float area;
    protected float distance;
    protected int countTri;
    protected int currentSize;
    protected int edgeCount;
    public Point3f point;
    public int index;
    public static final int DEFAULT_SIZE = 6;

    private static double distance(TriangleVertex pointA, TriangleVertex pointB) {
        double disX = pointA.point.x - pointB.point.x;
        double disY = pointA.point.y - pointB.point.y;
        double disZ = pointA.point.z - pointB.point.z;
        return Math.sqrt(disX * disX + disY * disY + disZ * disZ);
    }

    public TriangleVertex(Point3f point) {
        this(point.x, point.y, point.z);
    }

    private TriangleVertex(float x, float y, float z) {
        this.point = new Point3f(x, y, z);
        this.distance = -1.0f;
        this.hash();
    }

    public synchronized void addTriangle(Triangle tri) {
        if (this.triangles == null) {
            this.currentSize = 6;
            this.triangles = new Triangle[this.currentSize];
            this.triangles[0] = tri;
            ++this.countTri;
        } else {
            if (this.countTri == this.currentSize) {
                this.growTriangleArray();
            }
            this.triangles[this.countTri] = tri;
            ++this.countTri;
        }
    }

    public boolean equals(Object ob) {
        if (ob instanceof TriangleVertex) {
            TriangleVertex vert = (TriangleVertex)ob;
            return this.point.equals((Tuple3f)vert.point);
        }
        return false;
    }

    public float getAreaOfTriangles() {
        return this.area;
    }

    public Point3f getAveragePlaneCenter(boolean force) {
        if (this.averageCenter == null || force) {
            this.packAndCountTriangles();
            this.calculateAveragePlane();
        }
        return this.averageCenter;
    }

    public Vector3f getAveragePlaneNormal() {
        if (this.averageNormal == null) {
            this.packAndCountTriangles();
            this.calculateAveragePlane();
        }
        return this.averageNormal;
    }

    public Triangle[] getTriangles() {
        return this.triangles;
    }

    public TriangleVertexLoop getVertexLoop() {
        TriangleVertex[] loop = new TriangleVertex[this.countTri];
        for (int ctr = 0; ctr < this.countTri; ++ctr) {
            loop[ctr] = this.triangles[ctr].getCommonVertex(this.triangles[(ctr + 1) % this.countTri], this);
        }
        if (this.averageNormal == null) {
            this.calculateAveragePlane();
        }
        if (this.averageCenter == null) {
            this.calculateAveragePlane();
        }
        return new TriangleVertexLoop(loop, this.averageNormal, this.averageCenter);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isBoundary() {
        return !this.isComplex() && !this.triangles[this.countTri - 1].hasVertex(this.triangles[0].getOtherVertexClockwise(this)) && !this.triangles[this.countTri - 1].hasVertex(this.triangles[0].getOtherVertexCounterClockwise(this));
    }

    public boolean isComplex() {
        return !this.isOrdered || this.countTri < 3;
    }

    public boolean isCorner() {
        return this.edgeCount == 1 || this.edgeCount > 2;
    }

    public boolean isInteriorEdge() {
        return this.edgeCount == 2;
    }

    public boolean isNearOctantEdge() {
        return this.nearEdge;
    }

    public boolean isOctantBoundary() {
        return this.boundary;
    }

    public boolean isSimple() {
        return !this.isComplex() && (this.triangles[this.countTri - 1].hasVertex(this.triangles[0].getOtherVertexClockwise(this)) || this.triangles[this.countTri - 1].hasVertex(this.triangles[0].getOtherVertexCounterClockwise(this)));
    }

    public void setNearOctantEdge(boolean nearEdge) {
        this.nearEdge = nearEdge;
    }

    public void setOctantBoundary(boolean boundary) {
        this.boundary = boundary;
    }

    public String toString() {
        return "(" + this.point.x + ", " + this.point.y + ", " + this.point.z + ")";
    }

    protected void doFeatureCount(double featureAngle) {
        this.edgeCount = 0;
        for (int ctr = 0; ctr < this.countTri; ++ctr) {
            Vector3f vec2;
            Vector3f vec1 = this.triangles[ctr].getSurfaceNormal();
            double angle = vec1.angle(vec2 = this.triangles[(ctr + 1) % this.countTri].getSurfaceNormal());
            if (!(angle > featureAngle)) continue;
            ++this.edgeCount;
        }
    }

    protected float getFeatureDistance(double featureAngle) {
        if (this.distance == -1.0f) {
            this.calculateFeatureDistance(featureAngle);
        }
        return this.distance;
    }

    protected void getFeatureVertices(int[] indices, double featureAngle) {
        indices[0] = -1;
        indices[1] = -1;
        for (int ctr = 0; ctr < this.countTri; ++ctr) {
            Vector3f vec2;
            Vector3f vec1 = this.triangles[ctr].getSurfaceNormal();
            double angle = vec1.angle(vec2 = this.triangles[(ctr + 1) % this.countTri].getSurfaceNormal());
            if (!(angle > featureAngle)) continue;
            if (indices[0] == -1) {
                indices[0] = ctr;
                continue;
            }
            if (indices[1] != -1) continue;
            indices[1] = ctr;
        }
    }

    protected void orderTriangles() {
        try {
            int index = this.addCounterClockwise(0, this.addClockwise(0) + 1);
            this.isOrdered = index == this.countTri;
        }
        catch (StackOverflowError soe) {
            AppLogger.error((Throwable)soe);
        }
    }

    protected int packAndCountTriangles() {
        int index = 0;
        for (int ctr = 0; ctr < this.triangles.length; ++ctr) {
            if (this.triangles[ctr] == null) continue;
            Triangle tempTri = this.triangles[ctr];
            this.triangles[ctr] = null;
            this.triangles[index++] = tempTri;
        }
        this.countTri = index;
        return this.countTri;
    }

    protected boolean removeTriangle(Triangle tri) {
        for (int ctr = 0; ctr < this.triangles.length; ++ctr) {
            if (this.triangles[ctr] != tri) continue;
            this.triangles[ctr] = null;
            return true;
        }
        return false;
    }

    private int addClockwise(int index) {
        int ctr;
        if (index == this.countTri) {
            return index;
        }
        Triangle tri = this.triangles[index];
        TriangleVertex vertCW = tri.getOtherVertexClockwise(this);
        Triangle foundTri = null;
        int newIndex = index + 1;
        int foundIndex = -1;
        for (ctr = index + 1; ctr < this.countTri; ++ctr) {
            Triangle currentTri = this.triangles[ctr];
            TriangleVertex vertCCW = currentTri.getOtherVertexCounterClockwise(this);
            if (vertCCW != vertCW) continue;
            foundTri = this.triangles[ctr];
            foundIndex = ctr;
            break;
        }
        if (foundTri != null) {
            for (ctr = foundIndex; ctr > newIndex; --ctr) {
                this.triangles[ctr] = this.triangles[ctr - 1];
            }
            this.triangles[newIndex] = foundTri;
            return this.addClockwise(newIndex);
        }
        return index;
    }

    private int addCounterClockwise(int index, int start) {
        int ctr;
        Triangle tri = this.triangles[index];
        TriangleVertex vertCCW = tri.getOtherVertexCounterClockwise(this);
        Triangle foundTri = null;
        int newIndex = index;
        int foundIndex = -1;
        for (ctr = start; ctr < this.countTri; ++ctr) {
            Triangle currentTri = this.triangles[ctr];
            TriangleVertex vertCW = currentTri.getOtherVertexClockwise(this);
            if (vertCW != vertCCW) continue;
            foundTri = this.triangles[ctr];
            foundIndex = ctr;
            break;
        }
        if (foundTri != null) {
            for (ctr = foundIndex; ctr > newIndex; --ctr) {
                this.triangles[ctr] = this.triangles[ctr - 1];
            }
            this.triangles[newIndex] = foundTri;
            return this.addCounterClockwise(newIndex, start + 1);
        }
        return start;
    }

    private void calculateAveragePlane() {
        this.area = 0.0f;
        this.averageCenter = new Point3f();
        this.averageNormal = new Vector3f();
        for (int ctr = 0; ctr < this.countTri; ++ctr) {
            Point3f center = this.triangles[ctr].getCenter();
            Vector3f normal = this.triangles[ctr].getSurfaceNormal();
            double areaCurrent = this.triangles[ctr].getArea();
            this.averageCenter.x = (float)((double)this.averageCenter.x + (double)center.x * areaCurrent);
            this.averageCenter.y = (float)((double)this.averageCenter.y + (double)center.y * areaCurrent);
            this.averageCenter.z = (float)((double)this.averageCenter.z + (double)center.z * areaCurrent);
            this.averageNormal.x = (float)((double)this.averageNormal.x + (double)normal.x * areaCurrent);
            this.averageNormal.y = (float)((double)this.averageNormal.y + (double)normal.y * areaCurrent);
            this.averageNormal.z = (float)((double)this.averageNormal.z + (double)normal.z * areaCurrent);
            this.area = (float)((double)this.area + areaCurrent);
        }
        this.averageCenter.x /= this.area;
        this.averageCenter.y /= this.area;
        this.averageCenter.z /= this.area;
        this.averageNormal.x /= this.area;
        this.averageNormal.y /= this.area;
        this.averageNormal.z /= this.area;
    }

    private void calculateDistanceToAveragePlane() {
        this.calculateAveragePlane();
        double disX = this.checkNaN(this.averageNormal.x * (this.point.x - this.averageCenter.x) / Math.abs(this.averageNormal.x));
        double disY = this.checkNaN(this.averageNormal.y * (this.point.y - this.averageCenter.y) / Math.abs(this.averageNormal.y));
        double disZ = this.checkNaN(this.averageNormal.z * (this.point.z - this.averageCenter.z) / Math.abs(this.averageNormal.z));
        this.distance = (float)Math.abs(disX + disY + disZ);
    }

    private void calculateDistanceToFeatureEdge(double featureAngle) {
        TriangleVertex baseVert1 = null;
        TriangleVertex baseVert2 = null;
        TriangleVertex topVert = this;
        for (int ctr = 0; ctr < this.countTri; ++ctr) {
            Vector3f vec2;
            Vector3f vec1 = this.triangles[ctr].getSurfaceNormal();
            double angle = vec1.angle(vec2 = this.triangles[(ctr + 1) % this.countTri].getSurfaceNormal());
            if (!(angle > featureAngle)) continue;
            if (baseVert1 == null) {
                baseVert1 = this.triangles[ctr].getCommonVertex(this.triangles[(ctr + 1) % this.countTri], this);
                continue;
            }
            if (baseVert2 != null) continue;
            baseVert2 = this.triangles[ctr].getCommonVertex(this.triangles[(ctr + 1) % this.countTri], this);
        }
        Triangle tri = new Triangle(baseVert1, baseVert2, topVert);
        double baseLength = TriangleVertex.distance(baseVert1, baseVert2);
        this.distance = (float)((double)(2.0f * tri.getArea()) / baseLength);
    }

    private void calculateFeatureDistance(double featureAngle) {
        if (this.isInteriorEdge()) {
            this.calculateDistanceToFeatureEdge(featureAngle);
        } else {
            this.calculateDistanceToAveragePlane();
        }
    }

    private double checkNaN(double val) {
        if (Double.isNaN(val)) {
            return 0.0;
        }
        return val;
    }

    private void growTriangleArray() {
        this.currentSize *= 2;
        Triangle[] trianglesNew = new Triangle[this.currentSize];
        for (int ctr = 0; ctr < this.triangles.length; ++ctr) {
            trianglesNew[ctr] = this.triangles[ctr];
        }
        this.triangles = trianglesNew;
    }

    private void hash() {
        this.hashCode = Math.abs(Float.floatToIntBits(this.point.x + this.point.y + this.point.z));
    }
}

