/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.core.PointComparator;
import edu.uthscsa.ric.mango.viewersurface.core.Triangle;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertexLoop;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class TriangleData {
    private TreeMap<Point3f, TriangleVertex> vertices;
    private TreeSet<Triangle> triangles;
    private final int id;
    public static final double ANGLE_THRESHOLD = 1.0;
    public static final double AREA_RATIO_THRESHOLD = 0.05;
    public static final double TINY_TRIANGLE_FACTOR = 0.1;

    private static boolean doDecimation(TriangleVertexLoop loop, Vector<Triangle> trianglesToAdd) {
        return TriangleData.doDecimation(loop, trianglesToAdd, -1, -1);
    }

    private static boolean doDecimation(TriangleVertexLoop loop, Vector<Triangle> trianglesToAdd, int start, int end) {
        TriangleVertexLoop[] loops = null;
        loops = start == -1 || end == -1 ? loop.split() : loop.split(start, end);
        boolean valid = true;
        if (loops != null) {
            valid &= TriangleData.doDecimation(loops[0], trianglesToAdd);
            valid &= TriangleData.doDecimation(loops[1], trianglesToAdd);
        } else if (loop.verts.length != 3) {
            valid = false;
        } else {
            Triangle tri = new Triangle(loop.verts[2], loop.verts[1], loop.verts[0]);
            trianglesToAdd.add(tri);
        }
        return valid;
    }

    public TriangleData(int id) {
        this.id = id;
        this.triangles = new TreeSet();
        this.vertices = new TreeMap(new PointComparator());
    }

    public synchronized boolean addTriangle(Triangle tri) {
        return this.triangles.add(tri);
    }

    public synchronized void addVertex(Point3f key, TriangleVertex value) {
        this.vertices.put(key, value);
    }

    public void clear() {
        this.triangles.clear();
        this.triangles = null;
        this.vertices.clear();
        this.vertices = null;
    }

    public synchronized boolean containsVertex(Point3f point) {
        return this.vertices.containsKey(point);
    }

    public void decimate(double errorThresholdVal, double featureAngle, double voxelSize, int iteration) {
        double errorThreshold = errorThresholdVal;
        errorThreshold += (double)iteration * (errorThreshold * 0.5);
        Collection<TriangleVertex> values = this.vertices.values();
        Iterator<TriangleVertex> it = values.iterator();
        Vector<Triangle> trianglesToAdd = new Vector<Triangle>();
        Vector<TriangleVertex> verticesToRemove = new Vector<TriangleVertex>();
        int[] featureIndices = new int[2];
        Vector3f tempVec = new Vector3f();
        while (it.hasNext()) {
            boolean validSplit;
            double distance;
            TriangleVertex vertex = it.next();
            if (vertex.isNearOctantEdge()) continue;
            int count = vertex.packAndCountTriangles();
            if (count == 0) {
                verticesToRemove.add(vertex);
                continue;
            }
            vertex.orderTriangles();
            vertex.doFeatureCount(featureAngle);
            if (!vertex.isSimple() || !((distance = (double)vertex.getFeatureDistance(featureAngle)) < errorThreshold)) continue;
            TriangleVertexLoop loop = vertex.getVertexLoop();
            trianglesToAdd.clear();
            if (vertex.isInteriorEdge()) {
                vertex.getFeatureVertices(featureIndices, featureAngle);
                validSplit = TriangleData.doDecimation(loop, trianglesToAdd, featureIndices[0], featureIndices[1]);
            } else {
                validSplit = TriangleData.doDecimation(loop, trianglesToAdd);
            }
            if (!validSplit) continue;
            double areaThreshold = voxelSize * voxelSize * 0.1;
            boolean tinyTriangleFound = false;
            double newSurfaceArea = 0.0;
            tempVec.z = 0.0f;
            tempVec.y = 0.0f;
            tempVec.x = 0.0f;
            Enumeration<Triangle> enNew = trianglesToAdd.elements();
            while (enNew.hasMoreElements()) {
                Triangle tri = enNew.nextElement();
                double area = tri.getArea();
                if (area < areaThreshold) {
                    tinyTriangleFound = true;
                    break;
                }
                Vector3f triVec = tri.getSurfaceNormal();
                tempVec.x += triVec.x;
                tempVec.y += triVec.y;
                tempVec.z += triVec.z;
                newSurfaceArea += (double)tri.getArea();
            }
            tempVec.normalize();
            double oldSurfaceArea = vertex.getAreaOfTriangles();
            double areaRatio = (newSurfaceArea - oldSurfaceArea) / oldSurfaceArea;
            double angle = vertex.getAveragePlaneNormal().angle(tempVec);
            if (areaRatio > 0.05 || angle > 1.0 || tinyTriangleFound) continue;
            for (Triangle tri : vertex.triangles) {
                if (tri == null) continue;
                this.triangles.remove(tri);
                tri.vert1.removeTriangle(tri);
                tri.vert2.removeTriangle(tri);
                tri.vert3.removeTriangle(tri);
            }
            verticesToRemove.add(vertex);
            Enumeration<Triangle> en = trianglesToAdd.elements();
            while (en.hasMoreElements()) {
                Triangle tri = en.nextElement();
                this.triangles.add(tri);
                tri.vert1.addTriangle(tri);
                tri.vert2.addTriangle(tri);
                tri.vert3.addTriangle(tri);
            }
        }
        Enumeration en = verticesToRemove.elements();
        while (en.hasMoreElements()) {
            TriangleVertex vert = (TriangleVertex)en.nextElement();
            this.vertices.remove(vert.point);
        }
    }

    public int getId() {
        return this.id;
    }

    public Set<Triangle> getTriangles() {
        return this.triangles;
    }

    public synchronized TriangleVertex getVertex(Point3f point) {
        return this.vertices.get(point);
    }

    public TreeMap<Point3f, TriangleVertex> getVertices() {
        return this.vertices;
    }

    public void merge(TriangleData triDataNew) {
        if (triDataNew != null) {
            Set<Triangle> triangles = triDataNew.getTriangles();
            for (Triangle tri : triangles) {
                Point3f tempPoint = tri.vert1.point;
                TriangleVertex vert1 = null;
                if (this.containsVertex(tempPoint)) {
                    vert1 = this.getVertex(tempPoint);
                } else {
                    vert1 = new TriangleVertex(tempPoint);
                    this.addVertex(vert1.point, vert1);
                }
                tempPoint = tri.vert2.point;
                TriangleVertex vert2 = null;
                if (this.containsVertex(tempPoint)) {
                    vert2 = this.getVertex(tempPoint);
                } else {
                    vert2 = new TriangleVertex(new Point3f(tempPoint));
                    this.addVertex(vert2.point, vert2);
                }
                tempPoint = tri.vert3.point;
                TriangleVertex vert3 = null;
                if (this.containsVertex(tempPoint)) {
                    vert3 = this.getVertex(tempPoint);
                } else {
                    vert3 = new TriangleVertex(new Point3f(tempPoint));
                    this.addVertex(vert3.point, vert3);
                }
                Triangle tris = new Triangle(vert1, vert2, vert3);
                this.addTriangle(tris);
                vert1.addTriangle(tris);
                vert2.addTriangle(tris);
                vert3.addTriangle(tris);
            }
        }
    }
}

