/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import edu.uthscsa.ric.utilities.MathUtilities;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Triangle
implements Comparable<Triangle> {
    private Point3f center;
    private Vector3f normal;
    private boolean removed;
    private float area;
    public TriangleVertex vert1;
    public TriangleVertex vert2;
    public TriangleVertex vert3;

    public Triangle(TriangleVertex aVert1, TriangleVertex aVert2, TriangleVertex aVert3) {
        this.vert1 = aVert1;
        this.vert2 = aVert2;
        this.vert3 = aVert3;
        this.area = -1.0f;
    }

    @Override
    public int compareTo(Triangle that) {
        Point3f centerThis = this.getCenter();
        Point3f centerThat = that.getCenter();
        if (Double.compare(centerThis.z, centerThat.z) != 0) {
            return Double.compare(centerThis.z, centerThat.z);
        }
        if (Double.compare(centerThis.y, centerThat.y) != 0) {
            return Double.compare(centerThis.y, centerThat.y);
        }
        return Double.compare(centerThis.x, centerThat.x);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Triangle other = (Triangle)obj;
        return this.hasVertex(other.vert1) && this.hasVertex(other.vert2) && this.hasVertex(other.vert3);
    }

    public float getArea() {
        if (this.area == -1.0f) {
            this.calculateArea();
        }
        return this.area;
    }

    public Point3f getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    public TriangleVertex getCommonVertex(Triangle tri, TriangleVertex vert) {
        TriangleVertex vert1a = this.getOtherVertexClockwise(vert);
        TriangleVertex vert2a = this.getOtherVertexCounterClockwise(vert);
        TriangleVertex vert1b = tri.getOtherVertexClockwise(vert);
        TriangleVertex vert2b = tri.getOtherVertexCounterClockwise(vert);
        if (vert1a == vert1b || vert1a == vert2b) {
            return vert1a;
        }
        return vert2a;
    }

    public Vector3f getSurfaceNormal() {
        if (this.normal == null) {
            this.calculateSurfaceNormal();
        }
        return this.normal;
    }

    public int hashCode() {
        return this.vert1.point.hashCode() + this.vert2.point.hashCode() + this.vert3.point.hashCode();
    }

    public boolean isOctantBoundaryTriangle() {
        return this.vert1.isOctantBoundary() || this.vert2.isOctantBoundary() || this.vert3.isOctantBoundary();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public String toString() {
        return "Triangle [ " + this.vert1 + " " + this.vert2 + " " + this.vert3 + " ] " + this.getArea() + " " + this.getSurfaceNormal();
    }

    protected TriangleVertex getOtherVertexClockwise(TriangleVertex vert) {
        if (vert == this.vert1) {
            return this.vert2;
        }
        if (vert == this.vert2) {
            return this.vert3;
        }
        return this.vert1;
    }

    protected TriangleVertex getOtherVertexCounterClockwise(TriangleVertex vert) {
        if (vert == this.vert1) {
            return this.vert3;
        }
        if (vert == this.vert2) {
            return this.vert1;
        }
        return this.vert2;
    }

    protected boolean hasVertex(TriangleVertex vert) {
        return vert.equals(this.vert1) || vert.equals(this.vert2) || vert.equals(this.vert3);
    }

    private void calculateArea() {
        double disA = Math.sqrt(MathUtilities.pow((double)(this.vert1.point.x - this.vert2.point.x), (double)2.0) + MathUtilities.pow((double)(this.vert1.point.y - this.vert2.point.y), (double)2.0) + MathUtilities.pow((double)(this.vert1.point.z - this.vert2.point.z), (double)2.0));
        double disB = Math.sqrt(MathUtilities.pow((double)(this.vert2.point.x - this.vert3.point.x), (double)2.0) + MathUtilities.pow((double)(this.vert2.point.y - this.vert3.point.y), (double)2.0) + MathUtilities.pow((double)(this.vert2.point.z - this.vert3.point.z), (double)2.0));
        double disC = Math.sqrt(MathUtilities.pow((double)(this.vert3.point.x - this.vert1.point.x), (double)2.0) + MathUtilities.pow((double)(this.vert3.point.y - this.vert1.point.y), (double)2.0) + MathUtilities.pow((double)(this.vert3.point.z - this.vert1.point.z), (double)2.0));
        double halfPerim = (disA + disB + disC) / 2.0;
        this.area = (float)Math.sqrt(halfPerim * (halfPerim - disA) * (halfPerim - disB) * (halfPerim - disC));
    }

    private void calculateCenter() {
        this.center = new Point3f((this.vert1.point.x + this.vert2.point.x + this.vert3.point.x) / 3.0f, (this.vert1.point.y + this.vert2.point.y + this.vert3.point.y) / 3.0f, (this.vert1.point.z + this.vert2.point.z + this.vert3.point.z) / 3.0f);
    }

    private void calculateSurfaceNormal() {
        float qx = this.vert2.point.x - this.vert1.point.x;
        float qy = this.vert2.point.y - this.vert1.point.y;
        float qz = this.vert2.point.z - this.vert1.point.z;
        float px = this.vert3.point.x - this.vert1.point.x;
        float py = this.vert3.point.y - this.vert1.point.y;
        float pz = this.vert3.point.z - this.vert1.point.z;
        this.normal = new Vector3f(py * qz - pz * qy, pz * qx - px * qz, px * qy - py * qx);
    }
}

