/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.EditListener;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.roi.ROIColor;
import javax.vecmath.Point3d;

public class RulerTool
implements EditListener {
    private final Marker first;
    private final Marker second;
    private final MarkerLine line;
    private final SurfaceViewer viewer;

    public RulerTool(SurfaceViewer viewer) {
        this.viewer = viewer;
        this.first = new Marker(viewer, new Point3d(), ROIColor.getColor(5));
        this.first.setSpecial(false);
        this.first.setTransparent(false);
        this.second = new Marker(viewer, new Point3d(), ROIColor.getColor(5));
        this.second.setSpecial(false);
        this.second.setTransparent(false);
        this.first.setListener(this);
        this.second.setListener(this);
        this.line = new MarkerLine(viewer, new Point3d[]{new Point3d(), new Point3d()}, -1, ROIColor.getColor(5));
    }

    public Marker getFirst() {
        return this.first;
    }

    public Marker getSecond() {
        return this.second;
    }

    public MarkerLine getLine() {
        return this.line;
    }

    @Override
    public void edited() {
        this.line.editLine(new Point3d[]{this.first.getPoint(), this.second.getPoint()});
    }

    public SurfaceViewer getViewer() {
        return this.viewer;
    }

    public boolean containsMarker(Object obj) {
        return obj == this.first || obj == this.second;
    }
}

