/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.Quad;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import java.awt.geom.PathIterator;
import java.util.Vector;
import javax.vecmath.Point3f;

public class ROISlice {
    private ROISlice next;
    private boolean bottom;
    private boolean top;
    private byte[] maskData;
    private final Vector<Quad> quads;
    private final int direction;
    private final int slice;
    private final int xDim;
    private final int yDim;

    protected ROISlice(int xDim, int yDim, int slice, int direction) {
        this.xDim = xDim + 1;
        this.yDim = yDim + 1;
        this.slice = slice;
        this.direction = direction;
        this.quads = new Vector();
    }

    public byte[] getMaskData() {
        return this.maskData;
    }

    public ROISlice getNext() {
        return this.next;
    }

    public int getQuadCount() {
        return this.quads.size();
    }

    public Vector<Quad> getQuads() {
        return this.quads;
    }

    public int getSlice() {
        return this.slice;
    }

    public boolean isBottom() {
        return this.bottom;
    }

    public boolean isTop() {
        return this.top;
    }

    public void setBottom(boolean bottom) {
        this.bottom = bottom;
    }

    public void setMaskData(byte[] maskData) {
        this.maskData = maskData;
    }

    public void setNext(ROISlice next) {
        this.next = next;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public String toString() {
        return "ROISlice [next=" + (this.next != null ? this.next.slice : -1) + ", top=" + this.top + ", bottom=" + this.bottom + ", slice=" + this.slice + "]";
    }

    protected void copyMaskData(byte[] roiMaskData) {
        System.arraycopy(roiMaskData, 0, this.maskData, 0, roiMaskData.length);
    }

    protected void makeQuads(ROIShape roi, SurfaceViewer renderer) {
        this.reset();
        if (this.direction == 0) {
            this.makeAxialPlaneQuads(roi, renderer);
        } else if (this.direction == 1) {
            this.makeCoronalPlaneQuads(roi, renderer);
        } else if (this.direction == 2) {
            this.makeSagittalPlaneQuads(roi, renderer);
        }
        this.makeAcrossPlaneQuads(roi, renderer);
        if (this.next != null) {
            this.next.setMaskData(this.maskData);
        }
    }

    private void reset() {
        this.quads.clear();
    }

    private void makeAcrossPlaneQuads(ROIShape roi, SurfaceViewer renderer) {
        int ctrX;
        int ctrY;
        byte[] roiMaskData = roi.getMaskData();
        if (this.top) {
            for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    if ((roiMaskData[ctrX + ctrY * this.xDim] & 0x10) == 0) continue;
                    this.quads.add(this.makeQuad(renderer, ctrX, ctrY));
                }
            }
            this.maskData = new byte[this.xDim * this.yDim];
            System.arraycopy(roiMaskData, 0, this.maskData, 0, roiMaskData.length);
        } else {
            for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    if ((roiMaskData[ctrX + ctrY * this.xDim] & 0x10) == (this.maskData[ctrX + ctrY * this.xDim] & 0x10)) continue;
                    this.quads.add(this.makeQuad(renderer, ctrX, ctrY));
                }
            }
            System.arraycopy(roiMaskData, 0, this.maskData, 0, roiMaskData.length);
        }
        if (this.bottom) {
            for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    if ((roiMaskData[ctrX + ctrY * this.xDim] & 0x10) == 0) continue;
                    this.quads.add(this.makeQuad(renderer, ctrX, ctrY));
                }
            }
        }
    }

    private void makeAxialPlaneQuads(ROIShape roi, SurfaceViewer renderer) {
        SurfacePosition position = renderer.getPosition();
        double xSize = renderer.getViewer().getXSize();
        double ySize = renderer.getViewer().getYSize();
        double zSize = renderer.getViewer().getZSize();
        float[] coords = new float[3];
        float[] current = new float[3];
        float[] previous = new float[3];
        float[] first = new float[3];
        float axialZoffset = (float)(zSize / 2.0);
        float coronalZoffset = (float)(ySize / 2.0);
        float sagittalZoffset = (float)(xSize / 2.0);
        PathIterator pi = roi.getPathIterator();
        while (!pi.isDone()) {
            Quad quad;
            float nextSlice;
            int type = pi.currentSegment(coords);
            if (type == 4) {
                current[0] = position.convertX(coords[0]) - sagittalZoffset;
                current[1] = position.convertY(coords[1]) - coronalZoffset;
                current[2] = position.convertZ(this.slice) - axialZoffset;
                nextSlice = position.convertZ(this.slice + 1) - axialZoffset;
                quad = new Quad((int)coords[0], (int)coords[1], this.slice);
                quad.p1 = new Point3f(current[0], current[1], current[2]);
                quad.p2 = new Point3f(first[0], first[1], first[2]);
                quad.p3 = new Point3f(first[0], first[1], nextSlice);
                quad.p4 = new Point3f(current[0], current[1], nextSlice);
                this.quads.add(quad);
            } else if (type == 0) {
                first[0] = position.convertX(coords[0]) - sagittalZoffset;
                first[1] = position.convertY(coords[1]) - coronalZoffset;
                first[2] = position.convertZ(this.slice) - axialZoffset;
                previous[0] = first[0];
                previous[1] = first[1];
                previous[2] = first[2];
            } else if (type == 1) {
                current[0] = position.convertX(coords[0]) - sagittalZoffset;
                current[1] = position.convertY(coords[1]) - coronalZoffset;
                current[2] = position.convertZ(this.slice) - axialZoffset;
                nextSlice = position.convertZ(this.slice + 1) - axialZoffset;
                quad = new Quad((int)coords[0], (int)coords[1], this.slice);
                quad.p1 = new Point3f(previous[0], previous[1], previous[2]);
                quad.p2 = new Point3f(current[0], current[1], current[2]);
                quad.p3 = new Point3f(current[0], current[1], nextSlice);
                quad.p4 = new Point3f(previous[0], previous[1], nextSlice);
                this.quads.add(quad);
                previous[0] = current[0];
                previous[1] = current[1];
                previous[2] = current[2];
            }
            pi.next();
        }
    }

    private void makeCoronalPlaneQuads(ROIShape roi, SurfaceViewer renderer) {
        SurfacePosition position = renderer.getPosition();
        double xSize = renderer.getViewer().getXSize();
        double ySize = renderer.getViewer().getYSize();
        double zSize = renderer.getViewer().getZSize();
        float[] coords = new float[3];
        float[] current = new float[3];
        float[] previous = new float[3];
        float[] first = new float[3];
        float axialZoffset = (float)(zSize / 2.0);
        float coronalZoffset = (float)(ySize / 2.0);
        float sagittalZoffset = (float)(xSize / 2.0);
        PathIterator pi = roi.getPathIterator();
        while (!pi.isDone()) {
            Quad quad;
            float nextSlice;
            int type = pi.currentSegment(coords);
            if (type == 4) {
                current[0] = position.convertX(coords[0]) - sagittalZoffset;
                current[1] = position.convertY(this.slice) - coronalZoffset;
                current[2] = position.convertZ(coords[1]) - axialZoffset;
                nextSlice = position.convertY(this.slice + 1) - coronalZoffset;
                quad = new Quad((int)coords[0], this.slice, (int)coords[1]);
                quad.p1 = new Point3f(current[0], current[1], current[2]);
                quad.p2 = new Point3f(first[0], first[1], first[2]);
                quad.p3 = new Point3f(first[0], nextSlice, first[2]);
                quad.p4 = new Point3f(current[0], nextSlice, current[2]);
                this.quads.add(quad);
            } else if (type == 0) {
                first[0] = position.convertX(coords[0]) - sagittalZoffset;
                first[1] = position.convertY(this.slice) - coronalZoffset;
                first[2] = position.convertZ(coords[1]) - axialZoffset;
                previous[0] = first[0];
                previous[1] = first[1];
                previous[2] = first[2];
            } else if (type == 1) {
                current[0] = position.convertX(coords[0]) - sagittalZoffset;
                current[1] = position.convertY(this.slice) - coronalZoffset;
                current[2] = position.convertZ(coords[1]) - axialZoffset;
                nextSlice = position.convertY(this.slice + 1) - coronalZoffset;
                quad = new Quad((int)coords[0], this.slice, (int)coords[1]);
                quad.p1 = new Point3f(previous[0], previous[1], previous[2]);
                quad.p2 = new Point3f(current[0], current[1], current[2]);
                quad.p3 = new Point3f(current[0], nextSlice, current[2]);
                quad.p4 = new Point3f(previous[0], nextSlice, previous[2]);
                this.quads.add(quad);
                previous[0] = current[0];
                previous[1] = current[1];
                previous[2] = current[2];
            }
            pi.next();
        }
    }

    private Quad makeQuad(SurfaceViewer renderer, int ctrX, int ctrY) {
        Quad quad = null;
        SurfacePosition position = renderer.getPosition();
        double xSize = renderer.getViewer().getXSize();
        double ySize = renderer.getViewer().getYSize();
        double zSize = renderer.getViewer().getZSize();
        float axialZoffset = (float)(zSize / 2.0);
        float coronalZoffset = (float)(ySize / 2.0);
        float sagittalZoffset = (float)(xSize / 2.0);
        if (this.direction == 0) {
            quad = new Quad(ctrX, ctrY, this.slice);
            float xLoc = position.convertX(ctrX);
            float yLoc = position.convertY(ctrY);
            float zLoc = position.convertZ(this.slice) - axialZoffset;
            quad.p1 = new Point3f(xLoc - sagittalZoffset, yLoc - coronalZoffset, zLoc);
            quad.p2 = new Point3f(xLoc - sagittalZoffset, yLoc + coronalZoffset, zLoc);
            quad.p3 = new Point3f(xLoc + sagittalZoffset, yLoc + coronalZoffset, zLoc);
            quad.p4 = new Point3f(xLoc + sagittalZoffset, yLoc - coronalZoffset, zLoc);
        } else if (this.direction == 1) {
            quad = new Quad(ctrX, this.slice, ctrY);
            float xLoc = position.convertX(ctrX);
            float yLoc = position.convertY(this.slice) - coronalZoffset;
            float zLoc = position.convertZ(ctrY);
            quad.p1 = new Point3f(xLoc - sagittalZoffset, yLoc, zLoc - axialZoffset);
            quad.p2 = new Point3f(xLoc - sagittalZoffset, yLoc, zLoc + axialZoffset);
            quad.p3 = new Point3f(xLoc + sagittalZoffset, yLoc, zLoc + axialZoffset);
            quad.p4 = new Point3f(xLoc + sagittalZoffset, yLoc, zLoc - axialZoffset);
        } else if (this.direction == 2) {
            quad = new Quad(this.slice, ctrX, ctrY);
            float xLoc = position.convertX(this.slice) - sagittalZoffset;
            float yLoc = position.convertY(ctrX);
            float zLoc = position.convertZ(ctrY);
            quad.p1 = new Point3f(xLoc, yLoc - coronalZoffset, zLoc - axialZoffset);
            quad.p2 = new Point3f(xLoc, yLoc - coronalZoffset, zLoc + axialZoffset);
            quad.p3 = new Point3f(xLoc, yLoc + coronalZoffset, zLoc + axialZoffset);
            quad.p4 = new Point3f(xLoc, yLoc + coronalZoffset, zLoc - axialZoffset);
        }
        return quad;
    }

    private void makeSagittalPlaneQuads(ROIShape roi, SurfaceViewer renderer) {
        SurfacePosition position = renderer.getPosition();
        double xSize = renderer.getViewer().getXSize();
        double ySize = renderer.getViewer().getYSize();
        double zSize = renderer.getViewer().getZSize();
        float[] coords = new float[3];
        float[] current = new float[3];
        float[] previous = new float[3];
        float[] first = new float[3];
        float axialZoffset = (float)(zSize / 2.0);
        float coronalZoffset = (float)(ySize / 2.0);
        float sagittalZoffset = (float)(xSize / 2.0);
        PathIterator pi = roi.getPathIterator();
        while (!pi.isDone()) {
            Quad quad;
            float nextSlice;
            int type = pi.currentSegment(coords);
            if (type == 4) {
                current[0] = position.convertX(this.slice) - sagittalZoffset;
                current[1] = position.convertY(coords[0]) - coronalZoffset;
                current[2] = position.convertZ(coords[1]) - axialZoffset;
                nextSlice = position.convertX(this.slice + 1) - sagittalZoffset;
                quad = new Quad(this.slice, (int)coords[0], (int)coords[1]);
                quad.p1 = new Point3f(current[0], current[1], current[2]);
                quad.p2 = new Point3f(first[0], first[1], first[2]);
                quad.p3 = new Point3f(nextSlice, first[1], first[2]);
                quad.p4 = new Point3f(nextSlice, current[1], current[2]);
                this.quads.add(quad);
            } else if (type == 0) {
                first[0] = position.convertX(this.slice) - sagittalZoffset;
                first[1] = position.convertY(coords[0]) - coronalZoffset;
                first[2] = position.convertZ(coords[1]) - axialZoffset;
                previous[0] = first[0];
                previous[1] = first[1];
                previous[2] = first[2];
            } else if (type == 1) {
                current[0] = position.convertX(this.slice) - sagittalZoffset;
                current[1] = position.convertY(coords[0]) - coronalZoffset;
                current[2] = position.convertZ(coords[1]) - axialZoffset;
                nextSlice = position.convertX(this.slice + 1) - sagittalZoffset;
                quad = new Quad(this.slice, (int)coords[0], (int)coords[1]);
                quad.p1 = new Point3f(previous[0], previous[1], previous[2]);
                quad.p2 = new Point3f(current[0], current[1], current[2]);
                quad.p3 = new Point3f(nextSlice, current[1], current[2]);
                quad.p4 = new Point3f(nextSlice, previous[1], previous[2]);
                this.quads.add(quad);
                previous[0] = current[0];
                previous[1] = current[1];
                previous[2] = current[2];
            }
            pi.next();
        }
    }
}

