/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.PickableSurface;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Color;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.apache.commons.lang3.StringUtils;

public final class MarkerLine
implements PickableSurface,
Shape {
    private Coordinate pickedImageCoordinate;
    private LOIShape syncObj;
    private Marker cutPlanePoint;
    private Point3d pickedSurfaceCoordinate;
    private Point3d[] points;
    private boolean cutPlaneVisible;
    private boolean visible;
    private double pickDistance;
    private float[] color;
    private int number;
    private final SurfaceViewer render;
    private final double epsilon;
    public static final double NEAREST_SEARCH_MIN_MULTIPLIER = 20.0;
    public static final int NEAREST_SEARCH_MIN = 2;
    public static final int NEAREST_SEARCH_STEP = 50;

    public MarkerLine(SurfaceViewer render, Point3d[] points, int number, Color color) {
        this.render = render;
        this.number = number;
        this.points = points;
        this.pickedSurfaceCoordinate = new Point3d();
        this.pickedImageCoordinate = new Coordinate();
        this.setVisible(true);
        this.setColor(color);
        this.epsilon = render.getScaleFactor() * 1.75 / 10.0;
    }

    public void addLineSegment(Point3d start, Point3d end) {
        Point3d[] points = this.getPoints();
        Point3d[] pointsNew = new Point3d[points.length + 2];
        for (int ctr = 0; ctr < points.length; ++ctr) {
            pointsNew[ctr] = points[ctr];
        }
        pointsNew[ctr++] = start;
        pointsNew[ctr] = end;
        this.editLine(pointsNew);
    }

    public boolean containsLine(Point3d start, Point3d end) {
        int startIndex = this.containsPoint(start);
        int endIndex = this.containsPoint(end);
        if (startIndex == -1 || endIndex == -1) {
            return false;
        }
        for (int ctr = 0; ctr < this.points.length; ctr += 2) {
            if ((!this.points[ctr].equals((Tuple3d)start) || !this.points[ctr + 1].equals((Tuple3d)end)) && (!this.points[ctr].equals((Tuple3d)end) || !this.points[ctr + 1].equals((Tuple3d)start))) continue;
            return true;
        }
        return false;
    }

    public int containsPoint(Point3d point) {
        int ctr;
        Point3d[] points = this.getPoints();
        for (ctr = 0; ctr < points.length; ctr += 2) {
            if (!points[ctr].epsilonEquals((Tuple3d)point, this.epsilon)) continue;
            return ctr;
        }
        if (points[--ctr].epsilonEquals((Tuple3d)point, this.epsilon)) {
            return ctr;
        }
        return -1;
    }

    public void editLine(Point3d[] pointsNew) {
        this.points = pointsNew;
    }

    public void editPoint(Point3d pointOld, Point3d pointNew) {
        Point3d[] points = this.getPoints();
        for (int ctr = 0; ctr < points.length; ++ctr) {
            if (!points[ctr].epsilonEquals((Tuple3d)pointOld, 1.0E-6)) continue;
            points[ctr] = new Point3d(pointNew);
        }
        this.editLine(points);
    }

    public Point3d findMidpoint() {
        return new Point3d((this.points[0].x + this.points[1].x) / 2.0, (this.points[0].y + this.points[1].y) / 2.0, (this.points[0].z + this.points[1].z) / 2.0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MarkerLine) {
            MarkerLine ml = (MarkerLine)obj;
            int count = this.getNumPoints();
            if (ml.getNumPoints() == count) {
                Point3d[] pointsA = ml.getPoints();
                Point3d[] pointsB = this.getPoints();
                for (int ctr = 0; ctr < count; ++ctr) {
                    if (pointsA[ctr].equals((Tuple3d)pointsB[ctr])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public double getAlpha() {
        return 1.0;
    }

    public Color getColorObj() {
        return new Color(this.color[0], this.color[1], this.color[2]);
    }

    public float[] getColor() {
        return this.color;
    }

    public Marker getCutPlanePoint() {
        return this.cutPlanePoint;
    }

    public double getDistance() {
        Point3d[] points = this.getPointsCopy();
        double distance = 0.0;
        for (int ctr = 0; ctr < points.length; ctr += 2) {
            Point3d p1 = points[ctr];
            Point3d p2 = points[ctr + 1];
            distance += p1.distance(p2);
        }
        return distance;
    }

    public Point3d getAveragePoint() {
        Point3d[] points = this.getPointsCopy();
        double xSum = 0.0;
        double ySum = 0.0;
        double zSum = 0.0;
        for (Point3d p1 : points) {
            xSum += p1.x;
            ySum += p1.y;
            zSum += p1.z;
        }
        return new Point3d(xSum / (double)points.length, ySum / (double)points.length, zSum / (double)points.length);
    }

    public Point3d getEndPoint() {
        return this.points[this.points.length - 1];
    }

    @Override
    public String getName() {
        return null;
    }

    public int getNumber() {
        return this.number;
    }

    public int getNumPoints() {
        return this.points.length;
    }

    public Point3d getOppositeEndPoint(Point3d point) {
        Point3d[] points = this.getPoints();
        if (points[0].epsilonEquals((Tuple3d)point, 1.0E-6)) {
            return points[points.length - 1];
        }
        if (points[points.length - 1].epsilonEquals((Tuple3d)point, 1.0E-6)) {
            return points[0];
        }
        return null;
    }

    @Override
    public double getPickDistance() {
        return this.pickDistance;
    }

    @Override
    public Coordinate getPickedImageCoordinate() {
        return this.pickedImageCoordinate;
    }

    @Override
    public Point3d getPickedSurfaceCoordinate() {
        return this.pickedSurfaceCoordinate;
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public Point3d[] getPointsCopy() {
        Point3d[] pointsCopy = new Point3d[this.points.length];
        for (int ctr = 0; ctr < pointsCopy.length; ++ctr) {
            pointsCopy[ctr] = new Point3d(this.points[ctr]);
        }
        return pointsCopy;
    }

    public Point3d getStartPoint() {
        return this.points[0];
    }

    public LOIShape getSyncObject() {
        return this.syncObj;
    }

    public int hashCode() {
        return this.getStartPoint().hashCode();
    }

    @Override
    public boolean isBaseSurface() {
        return false;
    }

    public boolean isCutPlaneVisible() {
        return this.cutPlaneVisible;
    }

    public boolean isEndPoint(Point3d point) {
        Point3d[] points = this.getPoints();
        return points[0].epsilonEquals((Tuple3d)point, 1.0E-6) || points[points.length - 1].epsilonEquals((Tuple3d)point, 1.0E-6);
    }

    public boolean isSurfaceLine() {
        return this.cutPlanePoint != null;
    }

    public boolean isUsingTransform() {
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setColor(Color col) {
        this.color = col.getColorComponents(null);
    }

    public void setColorComponents(float[] color) {
        this.color = color;
    }

    public void setCutPlanePoint(Marker marker) {
        this.cutPlanePoint = marker;
    }

    public void setCutPlaneVisible(boolean bool) {
        this.cutPlaneVisible = bool;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    @Override
    public void setPickDistance(double val) {
        this.pickDistance = val;
    }

    @Override
    public void setPickedImageCoordinate(Coordinate pickedImageCoordinate) {
        this.pickedImageCoordinate = pickedImageCoordinate;
    }

    @Override
    public void setPickedSurfaceCoordinate(Point3d pickedSurfaceCoordinate) {
        this.pickedSurfaceCoordinate = pickedSurfaceCoordinate;
    }

    public void setSyncObject(LOIShape syncObj) {
        this.syncObj = syncObj;
    }

    public void setVisible(boolean bool) {
        this.visible = bool;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.isSurfaceLine() ? "Surface Line " : "Line ");
        sb.append(this.number).append(' ');
        String label = null;
        if (this.syncObj != null) {
            label = this.syncObj.getLabel(false);
        }
        if (StringUtils.isNotBlank(label)) {
            sb.append("(" + label + ")");
        } else {
            Point3d[] points = this.getPoints();
            Point3d startPoint = points[0];
            Point3d nextPoint = points[points.length - 1];
            Marker startMarker = this.render.findMarker(startPoint);
            Marker nextMarker = this.render.findMarker(nextPoint);
            if (startMarker != null) {
                sb.append("(" + startMarker.toString(true) + ")");
            } else {
                sb.append(this.render.getPointString(startPoint));
            }
            sb.append(" to ");
            if (nextMarker != null) {
                sb.append("(" + nextMarker.toString(true) + ")");
            } else {
                sb.append(this.render.getPointString(nextPoint));
            }
        }
        return sb.toString();
    }
}

