/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.EditListener;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.mango.viewersurface.core.PickableSurface;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Color;
import java.awt.Point;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.apache.commons.lang3.StringUtils;

public final class Marker
implements PickableSurface,
Shape {
    private Coordinate pickedImageCoordinate;
    private MarkerLine surfaceLine;
    private POI syncObj;
    private PickableSurface surfaceShape;
    private Point3d pickedSurfaceCoordinate;
    private Point3d point;
    private boolean fromSurface;
    private boolean special;
    private boolean transparent;
    private boolean visible;
    private double pickDistance;
    private double radius;
    private int number;
    private float[] color;
    private EditListener listener;
    private final SurfaceViewer renderer;
    public static final float RADIUS = 1.75f;
    public static final int DEFAULT_SLICES = 20;
    public static final int DEFAULT_STACKS = 20;

    public Marker(SurfaceViewer render, Point3d point, Color color) {
        this.renderer = render;
        this.pickedSurfaceCoordinate = new Point3d();
        this.pickedImageCoordinate = new Coordinate();
        this.setSpecial(true);
        this.setTransparent(true);
        this.setNumber(-1);
        this.setPoint(point);
        this.createMarker(color, this.renderer.getScaleFactor());
    }

    public Marker(SurfaceViewer renderer, Point3d point, int num, Color color) {
        this.renderer = renderer;
        this.pickedSurfaceCoordinate = new Point3d();
        this.pickedImageCoordinate = new Coordinate();
        this.setVisible(true);
        this.setNumber(num);
        this.setPoint(point);
        this.createMarker(color, renderer.getScaleFactor());
    }

    public void editMarker(Point3d pointNew) {
        this.setPoint(pointNew);
        if (this.syncObj != null) {
            Coordinate coord = this.renderer.getPosition().convertPointToCoordinate(pointNew);
            this.syncObj.updatePOI(new Point(coord.xInt, coord.yInt), coord.zInt, 0);
            this.renderer.getViewer().getPOIManager().updatePOI(this.syncObj);
            this.renderer.getViewer().updateViewer();
        }
        if (this.listener != null) {
            this.listener.edited();
        }
    }

    public void editMarker2(Point3d pointNew) {
        this.point.set((Tuple3d)pointNew);
        if (this.listener != null) {
            this.listener.edited();
        }
    }

    public double getAlpha() {
        if (this.transparent) {
            return 0.5;
        }
        return 1.0;
    }

    public Color getColorObj() {
        return new Color(this.color[0], this.color[1], this.color[2]);
    }

    public float[] getColor() {
        return this.color;
    }

    @Override
    public String getName() {
        return null;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public double getPickDistance() {
        return this.pickDistance;
    }

    @Override
    public Coordinate getPickedImageCoordinate() {
        return this.pickedImageCoordinate;
    }

    @Override
    public Point3d getPickedSurfaceCoordinate() {
        return this.pickedSurfaceCoordinate;
    }

    public Point3d getPoint() {
        return this.point;
    }

    public Point3d[] getPoints() {
        return new Point3d[]{this.point};
    }

    public double getRadius() {
        return this.radius;
    }

    public MarkerLine getSurfaceLine() {
        return this.surfaceLine;
    }

    public PickableSurface getSurfaceShape() {
        return this.surfaceShape;
    }

    public POI getSyncObject() {
        return this.syncObj;
    }

    @Override
    public boolean isBaseSurface() {
        return false;
    }

    public boolean isFromSurface() {
        return this.fromSurface;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isUsingTransform() {
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setColor(Color col) {
        this.color = col.getColorComponents(null);
    }

    public void setColorComponents(float[] color) {
        this.color = color;
    }

    public void setFromSurface(boolean fromSurface) {
        this.fromSurface = fromSurface;
    }

    public void setNumber(int val) {
        this.number = val;
    }

    @Override
    public void setPickDistance(double val) {
        this.pickDistance = val;
    }

    @Override
    public void setPickedImageCoordinate(Coordinate pickedImageCoordinate) {
        this.pickedImageCoordinate = pickedImageCoordinate;
    }

    @Override
    public void setPickedSurfaceCoordinate(Point3d pickedSurfaceCoordinate) {
        this.pickedSurfaceCoordinate = pickedSurfaceCoordinate;
    }

    public void setPoint(Point3d pnt) {
        this.point = pnt;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public void setSurfaceLine(MarkerLine line) {
        this.surfaceLine = line;
    }

    public void setSurfaceShape(PickableSurface ss) {
        this.surfaceShape = ss;
    }

    public void setSyncObject(POI syncObj) {
        this.syncObj = syncObj;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean shortLabel) {
        if (this.number == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Point ");
        sb.append(this.number);
        String label = null;
        if (this.syncObj != null) {
            label = this.syncObj.getLabel(false);
        }
        if (StringUtils.isNotBlank(label)) {
            sb.append(shortLabel ? "" : " (" + label + ")");
        } else {
            sb.append(shortLabel ? "" : " " + this.renderer.getPointString(this.point));
        }
        return sb.toString();
    }

    private void createMarker(Color color, double scaleFactor) {
        this.setColor(color);
        this.setRadius(1.75 * scaleFactor);
    }

    public double getDistance() {
        return 0.0;
    }

    public EditListener getListener() {
        return this.listener;
    }

    public void setListener(EditListener listener) {
        this.listener = listener;
    }
}

