/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class LineSegment
implements Comparable<LineSegment> {
    private final Point3d[] points = new Point3d[2];
    public static final double EPSILON = 1.0E-8;

    public void addPoint(Point3d aPoint) {
        if (this.points[0] == null) {
            this.points[0] = aPoint;
        } else {
            this.points[1] = aPoint;
        }
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LineSegment) {
            LineSegment ls = (LineSegment)obj;
            Point3d[] lsPoints = ls.getPoints();
            if (this.points[0].epsilonEquals((Tuple3d)lsPoints[0], 1.0E-8) && this.points[1].epsilonEquals((Tuple3d)lsPoints[1], 1.0E-8)) {
                return true;
            }
            return this.points[1].epsilonEquals((Tuple3d)lsPoints[0], 1.0E-8) && this.points[0].epsilonEquals((Tuple3d)lsPoints[1], 1.0E-8);
        }
        return false;
    }

    @Override
    public int compareTo(LineSegment ls) {
        double length = ls.getPoints()[0].distance(ls.getPoints()[1]);
        double lengthThis = this.getPoints()[0].distance(this.getPoints()[1]);
        return Double.compare(lengthThis, length);
    }

    protected boolean connects(LineSegment ls) {
        return this.connects(ls.getPoints()[0]) ^ this.connects(ls.getPoints()[1]);
    }

    public boolean connects(Point3d point) {
        if (this.points[0].epsilonEquals((Tuple3d)point, 1.0E-8)) {
            return true;
        }
        return this.points[1].epsilonEquals((Tuple3d)point, 1.0E-8);
    }

    public Point3d getOppositePoint(Point3d point) {
        if (point.epsilonEquals((Tuple3d)this.points[0], 1.0E-8)) {
            return this.points[1];
        }
        if (point.epsilonEquals((Tuple3d)this.points[1], 1.0E-8)) {
            return this.points[0];
        }
        return null;
    }

    public String toString() {
        return "(" + this.points[0].toString() + " " + this.points[1].toString() + ")";
    }

    public int hashCode() {
        return this.points[0].hashCode() + this.points[1].hashCode();
    }
}

