/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.EditListener;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.roi.ROIColor;
import javax.vecmath.Point3d;

public class AngleTool
implements EditListener {
    private final Marker third;
    private final Marker first;
    private final Marker second;
    private final MarkerLine lineFirst;
    private final MarkerLine lineSecond;
    private final SurfaceViewer viewer;
    private Point3d averagePoint;
    public static final float THIRD_POINT_COLOR_1 = 0.9f;
    public static final float THIRD_POINT_COLOR_2 = 0.25f;
    public static final float THIRD_POINT_COLOR_3 = 0.9f;

    public AngleTool(SurfaceViewer viewer) {
        this.viewer = viewer;
        this.first = new Marker(viewer, new Point3d(), ROIColor.getColor(4));
        this.first.setSpecial(false);
        this.first.setTransparent(false);
        this.first.setListener(this);
        this.second = new Marker(viewer, new Point3d(), ROIColor.getColor(4));
        this.second.setSpecial(false);
        this.second.setTransparent(false);
        this.second.setListener(this);
        this.third = new Marker(viewer, new Point3d(), ROIColor.getColor(4));
        this.third.setSpecial(false);
        this.third.setTransparent(false);
        this.third.setListener(this);
        this.lineFirst = new MarkerLine(viewer, new Point3d[]{new Point3d(), new Point3d()}, -1, ROIColor.getColor(4));
        this.lineSecond = new MarkerLine(viewer, new Point3d[]{new Point3d(), new Point3d()}, -1, ROIColor.getColor(4));
    }

    public Marker getFirst() {
        return this.first;
    }

    public Marker getSecond() {
        return this.second;
    }

    public MarkerLine getFirstLine() {
        return this.lineFirst;
    }

    public MarkerLine getSecondLine() {
        return this.lineSecond;
    }

    public Marker getThird() {
        return this.third;
    }

    @Override
    public void edited() {
        this.lineFirst.editLine(new Point3d[]{this.first.getPoint(), this.third.getPoint()});
        this.lineSecond.editLine(new Point3d[]{this.second.getPoint(), this.third.getPoint()});
        this.averagePoint = new Point3d((this.first.getPoint().x + this.second.getPoint().x + this.third.getPoint().x) / 3.0, (this.first.getPoint().y + this.second.getPoint().y + this.third.getPoint().y) / 3.0, (this.first.getPoint().z + this.second.getPoint().z + this.third.getPoint().z) / 3.0);
    }

    public double getAngle() {
        double disA = this.first.getPoint().distance(this.third.getPoint());
        double disB = this.third.getPoint().distance(this.second.getPoint());
        double disC = this.second.getPoint().distance(this.first.getPoint());
        return Math.acos((disA * disA + disB * disB - disC * disC) / (2.0 * disA * disB)) * 180.0 / Math.PI;
    }

    public SurfaceViewer getViewer() {
        return this.viewer;
    }

    public Point3d getAveragePoint() {
        return this.averagePoint;
    }

    public boolean containsMarker(Object obj) {
        return obj == this.first || obj == this.second || obj == this.third;
    }
}

