/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface;

import Jama.Matrix;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import edu.uthscsa.ric.cli.ScriptablePlugin;
import edu.uthscsa.ric.mango.BasicController;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.core.StickyWindow;
import edu.uthscsa.ric.mango.core.Version;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureListener;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.NodesTransferable;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayListener;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManagerListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenSlice;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewersurface.SurfaceManager;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfacePreferences;
import edu.uthscsa.ric.mango.viewersurface.core.AngleTool;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.mango.viewersurface.core.PickableSurface;
import edu.uthscsa.ric.mango.viewersurface.core.ROI;
import edu.uthscsa.ric.mango.viewersurface.core.RulerTool;
import edu.uthscsa.ric.mango.viewersurface.dialogs.SurfaceInfoDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.SurfaceObliquePlaneDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.cine.CineSurface;
import edu.uthscsa.ric.mango.viewersurface.menus.context.SurfaceContextMenu;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceFactory;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceScalarsBuilder;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceScalarsBuilderListener;
import edu.uthscsa.ric.mango.viewersurface.operations.io.ShapeData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceIOListener;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.mango.MangoFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceArea;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceStatistic;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceStatisticListener;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceVolume;
import edu.uthscsa.ric.mango.viewersurface.screen.Background;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import edu.uthscsa.ric.mango.viewersurface.screen.Material;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceOverlay;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceUpdater;
import edu.uthscsa.ric.mango.viewersurface.utilities.SurfaceUtils;
import edu.uthscsa.ric.mango.viewersurface.window.SurfaceFrame;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.SurfacePlugin;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class SurfaceViewer
implements Capturable,
DropTargetListener,
GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
OverlayListener,
OverlayManagerListener,
Recordable,
StickyWindow,
SurfaceController,
SurfaceIOListener,
SurfaceManager,
SurfaceScalarsBuilderListener,
SurfaceStatisticListener,
SurfaceUpdater,
VideoCaptureManager {
    private final Map<String, ScriptablePlugin> scriptablePlugins = new HashMap<String, ScriptablePlugin>();
    private CineSurface cine;
    private BufferedImage currentVideoFrame;
    private BufferedImage screenCapture;
    private BufferedImage textureImageAxial;
    private BufferedImage textureImageCoronal;
    private BufferedImage textureImageSagittal;
    private CompositeSurface addedShape;
    private CompositeSurface baseSurface;
    private CompositeSurface clearedShape;
    private CompositeSurface resetBaseSurface;
    private FPSAnimator animator;
    private GLCanvas canvas;
    private GLCapabilities caps;
    private GLU glu;
    private Marker grabbedMarker;
    private Object textRenderer;
    private Point mouse;
    private SliceViewer viewer;
    private Surface captureImageSurface;
    private SurfaceFactory factory;
    private SurfaceFrame frame;
    private SurfaceInfoDialog surfaceInfo;
    private SurfaceObliquePlaneDialog obliquePlaneDialog;
    private SurfacePlugin pluginToAdd;
    private SurfacePlugin pluginToRemove;
    private SurfacePosition position;
    private Texture axialTexture;
    private Texture coronalTexture;
    private Texture sagittalTexture;
    private Timer syncOverlaysTimer;
    private Timer upateROIShapeTimer;
    private Timer videoCaptureTimer;
    private Timer warningTimer;
    private Vector4d axialModClipTransformed;
    private Vector4d coronalModClipTransformed;
    private Vector4d sagittalModClipTransformed;
    private Vector<BufferedImage> videoFrames;
    private Vector<CompositeSurface> surfacesToLoad;
    private Vector<Shape> loadingShapeData;
    private VideoCaptureListener videoCaptureListener;
    private boolean findRulerLocation;
    private boolean findRulerLocationAngle;
    private boolean canUseShaders;
    private boolean canUseVBO;
    private boolean cannotRenderText;
    private boolean captureImage;
    private boolean captureImageShowLinesAndPoints;
    private boolean clearAllShapes;
    private boolean inited;
    private boolean markerMode;
    private boolean measureMode;
    private boolean mouseDoubleClicked;
    private boolean needsShowCapableWarning;
    private boolean needsShowError;
    private boolean needsShowIncapableWarning;
    private boolean needsSyncColors;
    private boolean needsVideoCapture;
    private boolean rebindPoints;
    private boolean syncingOverlays;
    private boolean texturesDirty;
    private boolean triedRenderText;
    private boolean updatingROIShape;
    private boolean videoAnimating;
    private boolean zoomMode;
    private boolean mouseDragged;
    private double averageSize;
    private double scaleFactor;
    private double xHalf;
    private double xSize;
    private double yHalf;
    private double ySize;
    private double zHalf;
    private double zSize;
    private double[] axialTextureCoors;
    private double[] coronalTextureCoors;
    private double[] sagittalTextureCoors;
    private final Background background;
    private float cutPlaneThreshold = Float.MIN_VALUE;
    private int lastFps;
    private int lineCounter = 1;
    private int mainDirection;
    private int pointCounter = 1;
    private int shaderProgram;
    private int textureXdim;
    private int textureYdim;
    private int textureZdim;
    private int videoCaptureFps;
    private int xDim;
    private int xSlice;
    private int yDim;
    private int ySlice;
    private int zDim;
    private int zSlice;
    private int[] uniforms;
    private long needROIUpdateMask;
    private RulerTool ruler;
    private AngleTool rulerAngle;
    private final GLUT glut;
    private final ROI[] roiShapes;
    private final SurfacePreferences preferences;
    private final TreeMap<Integer, Marker> allMarkers;
    private final TreeMap<Integer, MarkerLine> allMarkerLines;
    private final Vector<CompositeSurface> surfaces;
    private final Vector<SurfacePlugin> plugins;
    private final VolumeData volData;
    private final double[] activePlaneVertsAxial;
    private final double[] activePlaneVertsAxialTexture;
    private final double[] activePlaneVertsCoronal;
    private final double[] activePlaneVertsCoronalTexture;
    private final double[] activePlaneVertsSagittal;
    private final double[] activePlaneVertsSagittalTexture;
    private final double[] axialModClip;
    private final double[] axialTextureModClip;
    private final double[] axialTextureModClipOblique;
    private final double[] coronalModClip;
    private final double[] coronalTextureModClip;
    private final double[] coronalTextureModClipOblique;
    private final double[] crosshairLineVertsX;
    private final double[] crosshairLineVertsY;
    private final double[] crosshairLineVertsZ;
    private final double[] obliqueModClip;
    private final double[] sagittalModClip;
    private final double[] sagittalTextureModClip;
    private final double[] sagittalTextureModClipOblique;
    private static ProgressBarListener progressBarListener;
    private static boolean alreadyWarnedAboutUsingBetterGraphics;
    private static boolean useShadersStatic;
    private static final MangoNumberFormatter FORMATTER;
    public static final Color3f CROSSHAIR_COLOR;
    public static final String TEXT_OFFSCREEN = "Offscreen";
    public static final Version BETTER_GRAPHICS_SHADER_VERSION_MIN;
    public static final Version BETTER_GRAPHICS_VERSION_MIN;
    public static final Version VBO_VERSION_MIN;
    public static final double ORIENTATION_OFFSET = 1.1;
    public static final float ACTIVE_PLANE_COLOR = 0.85f;
    public static final float DEFAULT_LINE_THICKNESS = 2.0f;
    public static final float DEFAULT_TRANSPARENCY = 0.25f;
    public static final float ORIENTATION_SCALE_FACTOR = 0.2f;
    public static final int DEFAULT_ANIMATION_FPS = 60;
    public static final int DEFAULT_ANIMATION_FPS_UPDATE = 5;
    public static final int FPS_OUTPUT_CHANGE_DEFAULT = 5;
    public static final int UNIFORMS_NUM = 8;
    public static final int UNIFORM_AXIAL_CLIP_PLANE_INDEX = 0;
    public static final int UNIFORM_AXIAL_CLIP_PLANE_USE_INDEX = 3;
    public static final int UNIFORM_BASE_SURFACE_USE_INDEX = 7;
    public static final int UNIFORM_CORONAL_CLIP_PLANE_INDEX = 1;
    public static final int UNIFORM_CORONAL_CLIP_PLANE_USE_INDEX = 4;
    public static final int UNIFORM_SAGITTAL_CLIP_PLANE_INDEX = 2;
    public static final int UNIFORM_SAGITTAL_CLIP_PLANE_USE_INDEX = 5;
    public static final int UNIFORM_TRANSPARENT_USE_INDEX = 6;
    public static final long SYNC_OVERLAYS_TIMER_DELAY = 750L;

    public static ProgressBarListener getProgressBarListener() {
        return progressBarListener;
    }

    public static boolean isAlreadyWarnedAboutUsingBetterGraphics() {
        return alreadyWarnedAboutUsingBetterGraphics;
    }

    public static boolean isUseShaders() {
        return useShadersStatic;
    }

    public static void setAlreadyWarnedAboutUsingBetterGraphics(boolean alreadyWarnedAboutUsingBetterGraphics) {
        SurfaceViewer.alreadyWarnedAboutUsingBetterGraphics = alreadyWarnedAboutUsingBetterGraphics;
    }

    public static void setUseShaders(boolean bool) {
        useShadersStatic = bool;
    }

    private static boolean checkShaderOperation(GL2 gl, int shaderObj, int status, String label) {
        int[] statusShader = new int[1];
        gl.glGetShaderiv(shaderObj, status, IntBuffer.wrap(statusShader));
        if (statusShader[0] == 0) {
            int[] infoLogLenght = new int[1];
            gl.glGetShaderiv(shaderObj, 35716, IntBuffer.wrap(infoLogLenght));
            ByteBuffer infoLog = Buffers.newDirectByteBuffer((int)infoLogLenght[0]);
            gl.glGetShaderInfoLog(shaderObj, infoLog.limit(), IntBuffer.wrap(infoLogLenght), infoLog);
            byte[] infoBytes = new byte[infoLogLenght[0]];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            AppLogger.warn((String)(label + ": " + out));
            return false;
        }
        return true;
    }

    private static boolean checkShaderProgramOperation(GL2 gl, int programObj, int status, String label) {
        int[] statusProgram = new int[1];
        gl.glGetProgramiv(programObj, status, IntBuffer.wrap(statusProgram));
        if (statusProgram[0] == 0) {
            int[] infoLogLenght = new int[1];
            gl.glGetProgramiv(programObj, 35716, IntBuffer.wrap(infoLogLenght));
            ByteBuffer infoLog = Buffers.newDirectByteBuffer((int)infoLogLenght[0]);
            gl.glGetProgramInfoLog(programObj, infoLog.limit(), IntBuffer.wrap(infoLogLenght), infoLog);
            byte[] infoBytes = new byte[infoLogLenght[0]];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            AppLogger.warn((String)(label + ": " + out));
            return false;
        }
        return true;
    }

    private static void copySrcIntoDstAt(BufferedImage src, BufferedImage dst) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = 0;
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromStream(InputStream ins) throws IOException {
        if (ins == null) {
            throw new IOException("Could not read from stream.");
        }
        StringBuffer buffer = new StringBuffer();
        try (Scanner scanner = new Scanner(ins);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                buffer.append(line);
                buffer.append('\n');
            }
        }
        return buffer.toString();
    }

    public SurfaceViewer(SliceViewer viewer) {
        this.viewer = viewer;
        this.volData = new VolumeData(viewer);
        Mango.getInstance().getSurfaceSyncer().addViewer(this);
        this.canUseShaders = SurfaceViewer.isUseShaders();
        GLProfile glp = null;
        try {
            glp = GLProfile.getDefault();
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
        if (glp == null) {
            try {
                glp = GLProfile.getMaxFixedFunc((boolean)true);
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (glp == null || !glp.isGL2()) {
            glp = GLProfile.get((String)"GL2");
        }
        this.caps = new GLCapabilities(glp);
        this.setCapabilities(this.caps);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)this.caps);
        this.canvas.setSurfaceScale(new float[]{1.0f, 1.0f});
        this.glu = new GLU();
        this.glut = new GLUT();
        this.position = new SurfacePosition(viewer, this.glu);
        this.preferences = new SurfacePreferences(viewer.getMango());
        this.crosshairLineVertsZ = new double[6];
        this.crosshairLineVertsY = new double[6];
        this.crosshairLineVertsX = new double[6];
        this.activePlaneVertsAxial = new double[12];
        this.activePlaneVertsCoronal = new double[12];
        this.activePlaneVertsSagittal = new double[12];
        this.axialTextureCoors = new double[8];
        this.coronalTextureCoors = new double[8];
        this.sagittalTextureCoors = new double[8];
        this.activePlaneVertsAxialTexture = new double[12];
        this.activePlaneVertsCoronalTexture = new double[12];
        this.activePlaneVertsSagittalTexture = new double[12];
        this.axialModClip = new double[4];
        this.coronalModClip = new double[4];
        this.sagittalModClip = new double[4];
        this.obliqueModClip = new double[4];
        this.axialTextureModClip = new double[4];
        this.coronalTextureModClip = new double[4];
        this.sagittalTextureModClip = new double[4];
        this.axialTextureModClipOblique = new double[4];
        this.coronalTextureModClipOblique = new double[4];
        this.sagittalTextureModClipOblique = new double[4];
        this.surfaces = new Vector();
        this.background = new Background();
        this.allMarkers = new TreeMap();
        this.allMarkerLines = new TreeMap();
        this.plugins = new Vector();
        this.canvas.addGLEventListener((GLEventListener)this);
        this.canvas.addMouseMotionListener((MouseMotionListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
        new DropTarget((Component)this.canvas, 1, this, true);
        viewer.getOverlayManager().addListener(this);
        this.roiShapes = new ROI[64];
        this.createProgressListener();
    }

    public Marker addMarker(POI poi) {
        return this.addMarker(new Coordinate((double)poi.getX(), (double)poi.getY(), (double)poi.getZ()), poi.getColor(), poi, false);
    }

    public void addMarkerLine(LOIShape loi) {
        this.addMarkerLine(this.createPointsForMarkerLine(loi, loi.getSliceNum(), loi.getSliceDirection()), loi.getColor(), loi);
        this.updateSurface();
    }

    public MarkerLine addMarkerLine(Point3d[] points, int colorIndex, LOIShape syncObj) {
        Color color = ROIColor.getColor(colorIndex);
        MarkerLine ml = new MarkerLine(this, points, this.lineCounter, color);
        ml.setSyncObject(syncObj);
        if (!this.allMarkerLines.containsValue(ml)) {
            this.allMarkerLines.put(this.lineCounter, ml);
            ++this.lineCounter;
        }
        return ml;
    }

    public void addROILineInSliceViewer(MarkerLine ml) {
        Coordinate current;
        Point3d[] points = ml.getPoints();
        boolean contains = true;
        for (int ctr = 0; contains && ctr < points.length; contains &= this.viewer.containsIndex(current), ++ctr) {
            current = this.position.convertPointToCoordinate(points[ctr]);
        }
        if (contains) {
            Coordinate end;
            Coordinate start = this.position.convertPointToCoordinate(points[0]);
            int slicePlane = this.findLinePlane(start, end = this.position.convertPointToCoordinate(points[1]));
            if (slicePlane != -1) {
                ml.setSyncObject(this.viewer.addLineFromSurface(start, end, this.getColorIndex(ml.getColorObj()), slicePlane));
                this.viewer.updateViewer();
            }
            this.viewer.updateViewer();
        }
    }

    public void addShape(CompositeSurface surface) {
        this.clearFactory();
        this.addedShape = surface;
        surface.getMaterial().setDistance(SurfaceScalarsBuilder.getDistanceDefault(this));
        surface.getMaterial().setDistanceDefault(SurfaceScalarsBuilder.getDistanceDefault(this));
        if (surface.hasColors()) {
            surface.updateColors(this.viewer);
        }
        if (surface.getMaterial().isShowOverlayColors()) {
            this.syncOverlays(surface);
        }
        this.viewer.updateSurface();
    }

    public void addToDisplay(SurfacePlugin plugin) {
        this.pluginToAdd = plugin;
        this.updateSurface();
    }

    public Surface buildSurface(SurfaceBuildParameters params, boolean sameThread) {
        this.factory = new SurfaceFactory(params, this.viewer.getBaseVolume());
        this.factory.setSameThread(sameThread);
        return this.factory.createSurface(this);
    }

    @Override
    public void calculationFinished(final SurfaceStatistic ss, boolean sync) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ss.getCentroid() != null) {
                    SurfaceViewer.this.viewer.getMango().getResultsManager().addPoint(SurfaceViewer.this.viewer, null, new Coordinate4D(SurfaceViewer.this.position.convertPointToCoordinate(ss.getCentroid()), SurfaceViewer.this.viewer.getVolume().getCurrentSeriesPoint()), Double.NaN, "Centroid", ((AnalysisImpl)ss.getVisibleSurfaceStat()).getColor());
                }
                SurfaceViewer.this.viewer.getMango().getResultsManager().addStatistic(SurfaceViewer.this.viewer, null, (AnalysisImpl)ss.getVisibleSurfaceStat());
                if (SurfaceViewer.this.preferences.isUsingCutPlane() && ss.getSurface().isBaseSurface()) {
                    SurfaceViewer.this.viewer.getMango().getResultsManager().addStatistic(SurfaceViewer.this.viewer, null, (AnalysisImpl)ss.getCutAwaySurfaceStat());
                }
            }
        };
        if (sync) {
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runnable);
        }
    }

    public final boolean canUseShaders() {
        return this.canUseShaders;
    }

    @Override
    public BufferedImage captureImage() {
        return this.captureImage(null, true);
    }

    public BufferedImage captureImage(Surface surface, boolean showLinesAndPoints) {
        this.captureImageSurface = surface;
        this.captureImageShowLinesAndPoints = showLinesAndPoints;
        this.captureImage = true;
        this.updateSurface();
        while (this.captureImage) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.updateSurface();
        }
        return this.screenCapture;
    }

    public BufferedImage captureVideoFrame(GLAutoDrawable drawable) {
        return new AWTGLReadBufferUtil(drawable.getGLProfile(), false).readPixelsToBufferedImage(drawable.getGL(), true);
    }

    public Point3d convertViewerCoordinateToSurfacePoint(Coordinate coor, boolean isWorld) {
        if (isWorld) {
            this.volData.convertWorldToIndexCoordinate(coor);
        }
        return this.position.convertCoordinateToPoint(coor);
    }

    public GLAutoDrawable createOffscreenDrawable() {
        GLProfile glp = GLProfile.getDefault();
        if (!glp.isGL2()) {
            glp = GLProfile.get((String)"GL2");
        }
        GLCapabilities caps = new GLCapabilities(glp);
        this.setCapabilities(caps);
        GLDrawableFactory drawableFactory = GLDrawableFactory.getFactory((GLProfile)glp);
        GLOffscreenAutoDrawable offscreenDrawable = drawableFactory.createOffscreenAutoDrawable(drawableFactory.getDefaultDevice(), (GLCapabilitiesImmutable)caps, (GLCapabilitiesChooser)new DefaultGLCapabilitiesChooser(), this.canvas.getWidth(), this.canvas.getHeight());
        offscreenDrawable.display();
        offscreenDrawable.getContext().makeCurrent();
        return offscreenDrawable;
    }

    public void deleteROILine(LOIShape loi) {
        for (MarkerLine ml : this.allMarkerLines.values()) {
            LOIShape syncedLOI = ml.getSyncObject();
            if (!loi.equals(syncedLOI)) continue;
            this.removeMarkerLine(ml.getNumber(), false);
            break;
        }
        this.updateSurface();
    }

    public void deleteROIPoint(POI poi) {
        for (Marker marker : this.allMarkers.values()) {
            POI syncedPOI = marker.getSyncObject();
            if (!poi.equals(syncedPOI)) continue;
            this.removeMarker(marker.getNumber(), false);
            break;
        }
        this.updateSurface();
    }

    public void deleteShaders(GL2 gl, int shaderprogram) {
        gl.glDeleteProgram(shaderprogram);
    }

    public void display(GLAutoDrawable drawable) {
        this.display(drawable, false, this.uniforms, this.shaderProgram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable drawable, boolean animation, int[] shaderUniforms, int shaderprogram) {
        int showActivePlanes;
        GL2 gl = drawable.getGL().getGL2();
        if (this.isAnimating()) {
            this.position.rotateX();
        }
        if (this.addedShape != null && this.addedShape.bindData(gl, this.canUseVBO)) {
            this.surfaces.add(this.addedShape);
            this.addedShape = null;
        }
        if (this.clearedShape != null) {
            this.surfaces.remove(this.clearedShape);
            this.clearedShape.clear(gl, this, this.canUseVBO);
            this.clearedShape = null;
        }
        if (this.rebindPoints) {
            this.rebindPoints = false;
            this.baseSurface.rebindPoints(gl);
        }
        if (this.clearAllShapes) {
            Vector<CompositeSurface> surfacesToRemove = new Vector<CompositeSurface>();
            for (int ctr = 0; ctr < this.surfaces.size(); ++ctr) {
                CompositeSurface surface = this.surfaces.get(ctr);
                if (surface.isBaseSurface()) continue;
                surface.clear(gl, this, this.canUseVBO);
                surfacesToRemove.add(surface);
            }
            this.surfaces.removeAll(surfacesToRemove);
            this.clearAllShapes = false;
        }
        if (this.resetBaseSurface != null) {
            this.baseSurface.clear(gl, this, this.canUseVBO);
            this.surfaces.remove(this.baseSurface);
            this.baseSurface = this.resetBaseSurface;
            this.baseSurface.bindData(gl, this.canUseVBO);
            this.surfaces.insertElementAt(this.baseSurface, 0);
            this.resetBaseSurface = null;
            this.needsSyncColors = true;
        }
        gl.glEnable(2929);
        gl.glLineWidth(2.0f);
        gl.glClearColor(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), 1.0f);
        gl.glClear(17664);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, 1.0, 10.0 * this.scaleFactor, 100000.0);
        this.glu.gluLookAt(0.0f, 0.0f, (float)this.position.getZoom(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glEnable(2896);
        this.baseSurface.getLighting().apply(gl);
        this.position.apply(gl, this.scaleFactor);
        if (this.preferences.isShowPosition()) {
            double[] decomp = this.position.decomposeModelTransform();
            this.frame.updatePositionInfo(decomp[0], decomp[1], decomp[2], decomp[3], decomp[4], decomp[5]);
        }
        for (CompositeSurface surface : this.surfaces) {
            if (this.captureImage && this.captureImageSurface != surface && this.captureImageSurface != null || !surface.getMaterial().isOpaque()) continue;
            if (surface.isBaseSurface()) {
                if (this.preferences.isUsingCutPlane()) {
                    if (surface.getMaterial().getPolygonStyle() != 0) {
                        if (this.isUsingShaders() && this.baseSurface.isVisible()) {
                            this.renderSurfaceAndSlices(gl, false, false, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                            if (surface.getMaterial().getPolygonStyle() == 2) {
                                this.renderSurfaceAndSlices(gl, false, true, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                            }
                            this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
                        } else {
                            this.renderSurfaceAndSlicesOld(gl, false, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                        }
                    } else if (this.isUsingShaders() && this.baseSurface.isVisible()) {
                        this.renderSurfaceAndSlices(gl, true, false, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                    } else {
                        this.renderSurfaceAndSlicesOld(gl, false, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                    }
                    if (this.mouse == null) continue;
                    this.position.pickPoint(gl, this.mouse, surface, this.measureMode);
                    continue;
                }
                this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
                continue;
            }
            if (!this.preferences.isShowShapes()) continue;
            this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
        }
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glDisable(2896);
        if (!this.captureImage || this.captureImageShowLinesAndPoints) {
            for (Marker marker : this.allMarkers.values()) {
                if (!marker.isVisible()) continue;
                this.renderMarker(marker, gl, false, false);
                if (marker == this.grabbedMarker || this.mouse == null) continue;
                this.position.pickPoint(gl, this.mouse, marker, this.measureMode);
            }
            for (MarkerLine markerLine : this.allMarkerLines.values()) {
                if (!markerLine.isVisible()) continue;
                this.renderMarkerLine(markerLine, gl, false);
            }
        }
        boolean hasTranslucentSurface = this.hasTranslucentSurface();
        if (this.preferences.isShowRuler()) {
            if (this.findRulerLocation) {
                this.findRulerLocation = !this.position.findRulerStartLocation(gl, this.ruler);
            }
            this.renderMarkerLine(this.ruler.getLine(), gl, true);
            this.renderMarker(this.ruler.getFirst(), gl, false, true);
            if ((this.grabbedMarker == null || hasTranslucentSurface) && this.mouse != null) {
                this.position.pickPoint(gl, this.mouse, this.ruler.getFirst(), this.measureMode);
            }
            this.renderMarker(this.ruler.getSecond(), gl, false, true);
            if ((this.grabbedMarker == null || hasTranslucentSurface) && this.mouse != null) {
                this.position.pickPoint(gl, this.mouse, this.ruler.getSecond(), this.measureMode);
            }
        }
        if (this.preferences.isShowAngle()) {
            if (this.findRulerLocationAngle) {
                this.findRulerLocationAngle = !this.position.findAngleStartLocation(gl, this.rulerAngle);
                this.rulerAngle.edited();
            }
            this.renderMarkerLine(this.rulerAngle.getFirstLine(), gl, true);
            this.renderMarkerLine(this.rulerAngle.getSecondLine(), gl, true);
            this.renderMarker(this.rulerAngle.getFirst(), gl, false, true);
            if ((this.grabbedMarker == null || hasTranslucentSurface) && this.mouse != null) {
                this.position.pickPoint(gl, this.mouse, this.rulerAngle.getFirst(), this.measureMode);
            }
            this.renderMarker(this.rulerAngle.getSecond(), gl, false, true);
            if ((this.grabbedMarker == null || hasTranslucentSurface) && this.mouse != null) {
                this.position.pickPoint(gl, this.mouse, this.rulerAngle.getSecond(), this.measureMode);
            }
            this.renderMarker(this.rulerAngle.getThird(), gl, true, true);
            if ((this.grabbedMarker == null || hasTranslucentSurface) && this.mouse != null) {
                this.position.pickPoint(gl, this.mouse, this.rulerAngle.getThird(), this.measureMode);
            }
        }
        if (this.preferences.isShowRuler() || this.preferences.isShowAngle()) {
            double rulerLength = this.preferences.isShowRuler() ? this.ruler.getLine().getDistance() : 0.0;
            double angle = this.preferences.isShowAngle() ? this.rulerAngle.getAngle() : 0.0;
            this.frame.updateMeasurementIInfo(rulerLength, angle);
        }
        if (this.grabbedMarker != null) {
            this.renderMarker(this.grabbedMarker, gl, true, this.ruler.containsMarker(this.grabbedMarker) || this.rulerAngle.containsMarker(this.grabbedMarker));
        }
        if (this.preferences.isShowCrosshairs()) {
            gl.glColor3f(SurfaceViewer.CROSSHAIR_COLOR.x, SurfaceViewer.CROSSHAIR_COLOR.y, SurfaceViewer.CROSSHAIR_COLOR.z);
            gl.glLineWidth(2.0f);
            gl.glBegin(1);
            gl.glVertex3d(this.crosshairLineVertsZ[0], this.crosshairLineVertsZ[1], this.crosshairLineVertsZ[2]);
            gl.glVertex3d(this.crosshairLineVertsZ[3], this.crosshairLineVertsZ[4], this.crosshairLineVertsZ[5]);
            gl.glEnd();
            gl.glBegin(1);
            gl.glVertex3d(this.crosshairLineVertsY[0], this.crosshairLineVertsY[1], this.crosshairLineVertsY[2]);
            gl.glVertex3d(this.crosshairLineVertsY[3], this.crosshairLineVertsY[4], this.crosshairLineVertsY[5]);
            gl.glEnd();
            gl.glBegin(1);
            gl.glVertex3d(this.crosshairLineVertsX[0], this.crosshairLineVertsX[1], this.crosshairLineVertsX[2]);
            gl.glVertex3d(this.crosshairLineVertsX[3], this.crosshairLineVertsX[4], this.crosshairLineVertsX[5]);
            gl.glEnd();
        }
        gl.glDisable(3042);
        boolean showEdge = this.viewer.isShowingROIEdge();
        if (this.viewer.isShowingROI() && this.preferences.isShowDynamicROI()) {
            this.renderROIShape(gl, showEdge && !this.baseSurface.getMaterial().isTransparent(), true);
        }
        gl.glEnable(2896);
        boolean renderedTranslucent = false;
        for (int ctr = this.surfaces.size() - 1; ctr >= 0; --ctr) {
            CompositeSurface surface = this.surfaces.get(ctr);
            if (this.captureImage && this.captureImageSurface != surface && this.captureImageSurface != null || !surface.getMaterial().isTransparent()) continue;
            renderedTranslucent = true;
            if (surface.isBaseSurface()) {
                if (this.preferences.isUsingCutPlane()) {
                    if (this.isUsingShaders()) {
                        this.renderSurfaceAndSlices(gl, false, false, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                        this.renderSurfaceAndSlices(gl, false, true, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                        this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
                        continue;
                    }
                    this.renderSurfaceAndSlicesOld(gl, true, this.preferences.isUsingAxialCutPlane(), this.preferences.isUsingCoronalCutPlane(), this.preferences.isUsingSagittalCutPlane(), shaderUniforms, shaderprogram);
                    continue;
                }
                this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
                continue;
            }
            if (!this.preferences.isShowShapes()) continue;
            this.renderSurface(surface, gl, false, false, shaderUniforms, shaderprogram);
        }
        if (this.findRulerLocation) {
            this.findRulerLocation = false;
            this.position.findRulerStartLocation(gl, this.ruler);
        }
        if (this.findRulerLocationAngle) {
            this.findRulerLocationAngle = false;
            this.position.findAngleStartLocation(gl, this.rulerAngle);
            this.rulerAngle.edited();
        }
        gl.glDisable(2896);
        gl.glDisable(3042);
        gl.glDisable(12291);
        gl.glDisable(12292);
        gl.glDisable(12293);
        if (showEdge && renderedTranslucent && this.preferences.isShowDynamicROI()) {
            this.renderROIShape(gl, !this.baseSurface.getMaterial().isTransparent(), true);
        }
        if ((showActivePlanes = this.preferences.getShowActivePlanes()) != 0) {
            this.renderActivePlanes(gl, showActivePlanes);
        }
        if (this.preferences.isShowOrientation()) {
            gl.glDisableClientState(32884);
            ((TextRenderer)this.textRenderer).begin3DRendering();
            this.renderText(gl, "S", (double)this.xSlice * this.xSize - this.xHalf, (double)this.ySlice * this.ySize - this.yHalf, 1.1 * -this.zHalf);
            this.renderText(gl, "I", (double)this.xSlice * this.xSize - this.xHalf, (double)this.ySlice * this.ySize - this.yHalf, 1.1 * this.zHalf);
            this.renderText(gl, "A", (double)this.xSlice * this.xSize - this.xHalf, 1.1 * -this.yHalf, (double)this.zSlice * this.zSize - this.zHalf);
            this.renderText(gl, "P", (double)this.xSlice * this.xSize - this.xHalf, 1.1 * this.yHalf, (double)this.zSlice * this.zSize - this.zHalf);
            this.renderText(gl, "L", 1.1 * -this.xHalf, (double)this.ySlice * this.ySize - this.yHalf, (double)this.zSlice * this.zSize - this.zHalf);
            this.renderText(gl, "R", 1.1 * this.xHalf, (double)this.ySlice * this.ySize - this.yHalf, (double)this.zSlice * this.zSize - this.zHalf);
            ((TextRenderer)this.textRenderer).end3DRendering();
        }
        if (this.isAnimating()) {
            int diff;
            int fps = Math.round(drawable.getAnimator().getLastFPS());
            if (fps > 0 && (diff = Math.abs(fps - this.lastFps)) > 5) {
                AppLogger.info((String)("FPS = " + fps));
            }
            this.lastFps = fps;
        }
        gl.glDisable(2929);
        gl.glDisable(32823);
        if (this.captureImage) {
            this.captureImage = false;
            this.screenCapture = new AWTGLReadBufferUtil(drawable.getGLProfile(), false).readPixelsToBufferedImage((GL)gl, true);
            this.captureImageSurface = null;
        }
        if (this.needsVideoCapture) {
            this.needsVideoCapture = false;
            SurfaceViewer fps = this;
            synchronized (fps) {
                this.currentVideoFrame = new AWTGLReadBufferUtil(drawable.getGLProfile(), false).readPixelsToBufferedImage((GL)gl, true);
            }
        }
        if (this.surfacesToLoad != null) {
            this.loadNext();
        } else if (this.loadingShapeData != null) {
            this.loadShapeData();
        }
        this.texturesDirty = false;
        this.mouse = null;
        if (this.needsSyncColors) {
            this.needsSyncColors = false;
            this.startSyncOverlays();
        }
        if (this.pluginToAdd != null) {
            this.plugins.add(this.pluginToAdd);
            this.pluginToAdd = null;
        }
        if (this.pluginToRemove != null) {
            this.plugins.remove(this.pluginToRemove);
            this.pluginToRemove = null;
        }
        if (this.plugins.size() > 0) {
            gl.glEnable(2929);
            for (SurfacePlugin plugin : this.plugins) {
                plugin.display(drawable);
            }
            gl.glDisable(2929);
        }
    }

    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        this.clear(gl);
    }

    public void doUpdateROIShape(final boolean all, final int color, final int slice, final int direction) {
        if (this.updatingROIShape) {
            this.startUpdateROIShapeTimer(all, color, slice, direction);
        } else {
            this.updatingROIShape = true;
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (all) {
                        SurfaceViewer.this.updateAllROIShapeVolumes(direction);
                    } else if (slice >= 0) {
                        SurfaceViewer.this.doUpdateROIShapeSlice(color, slice, direction);
                    } else {
                        SurfaceViewer.this.updateROIShapeVolume(color, direction);
                    }
                    SurfaceViewer.this.updatingROIShape = false;
                }
            });
            workThread.start();
        }
    }

    public void doUpdateROIShapeSlice(int color, int slice, int direction) {
        if (this.roiShapes[color] == null) {
            this.roiShapes[color] = new ROI(this.viewer.getXDim(), this.viewer.getYDim(), this.viewer.getZDim(), direction);
            this.updateROIShapeVolume(color, direction);
            return;
        }
        if (this.roiShapes[color].getDirection() != direction) {
            this.roiShapes[color].reset(direction);
            this.updateROIShapeVolume(color, direction);
            return;
        }
        ScreenSlice screenSlice = this.viewer.getScreenSlice(direction);
        int numSlices = screenSlice.getNumSlices();
        if (this.viewer.getROIManager().hasROI(color)) {
            ROIShape[] roi = null;
            byte[] maskData = null;
            if (slice > 0) {
                ROIShape[] above = this.viewer.getROIManager().getShape(slice - 1, direction, screenSlice.getFinalTransform(), color, true);
                maskData = new byte[above[color].getMaskData().length];
                System.arraycopy(above[color].getMaskData(), 0, maskData, 0, above[color].getMaskData().length);
                roi = this.viewer.getROIManager().getShape(slice, direction, screenSlice.getFinalTransform(), color, true);
                this.roiShapes[color].replaceQuads(maskData, roi[color], this, slice);
            } else {
                roi = this.viewer.getROIManager().getShape(slice, direction, screenSlice.getFinalTransform(), color, true);
                this.roiShapes[color].replaceQuads(null, roi[color], this, slice);
            }
            if (slice < numSlices - 1) {
                System.arraycopy(roi[color].getMaskData(), 0, maskData, 0, roi[color].getMaskData().length);
                ROIShape[] below = this.viewer.getROIManager().getShape(slice + 1, direction, screenSlice.getFinalTransform(), color, true);
                this.roiShapes[color].replaceQuads(maskData, below[color], this, slice + 1);
            }
            this.roiShapes[color].createQuadBuffer();
        } else {
            this.roiShapes[color] = null;
        }
        this.updateSurface();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            FileNode[] nodes = (FileNode[])dtde.getTransferable().getTransferData(NodesTransferable.getDataFlavor());
            if (nodes == null) {
                dtde.rejectDrag();
                return;
            }
            boolean foundImage = false;
            for (FileNode node : nodes) {
                if (node.getHeaderInfo() != null) {
                    foundImage = true;
                    break;
                }
                if (node.getSurfaceInfo() == null) continue;
                foundImage = true;
                break;
            }
            if (!foundImage) {
                dtde.rejectDrag();
            }
        }
        catch (UnsupportedFlavorException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drawSurfaceLine(Marker start, Marker end, Marker third) {
        this.redrawSurfaceLine(start, end, third, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            FileNode[] nodes = (FileNode[])dtde.getTransferable().getTransferData(NodesTransferable.getDataFlavor());
            dtde.acceptDrop(3);
            SurfaceReader sr = new SurfaceReader();
            sr.readFile(nodes[0].getFile(), this.viewer, this, false);
        }
        catch (UnsupportedFlavorException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public synchronized Vector<BufferedImage> endVideoCapture() {
        this.stopVideoCaptureTimer();
        return this.videoFrames;
    }

    public int findLinePlane(Coordinate start, Coordinate end) {
        if (start.xInt == end.xInt) {
            return 2;
        }
        if (start.yInt == end.yInt) {
            return 1;
        }
        if (start.zInt == end.zInt) {
            return 0;
        }
        return -1;
    }

    public Marker findMarker(Point3d point) {
        for (Marker marker : this.allMarkers.values()) {
            if (!point.epsilonEquals((Tuple3d)marker.getPoint(), 1.0E-6)) continue;
            return marker;
        }
        return null;
    }

    public void finishedBuild(CompositeSurface surface) {
        this.clearFactory();
        surface.getMaterial().setDistance(SurfaceScalarsBuilder.getDistanceDefault(this));
        surface.getMaterial().setDistanceDefault(SurfaceScalarsBuilder.getDistanceDefault(this));
        if (this.inited) {
            this.frame.setVisible(true);
            this.resetBaseSurface = surface;
            if (this.resetBaseSurface.getParams() != null) {
                this.cutPlaneThreshold = this.resetBaseSurface.getParams().getThreshold();
            }
        } else {
            this.baseSurface = this.addedShape = surface;
            if (this.baseSurface.getParams() != null) {
                this.cutPlaneThreshold = this.baseSurface.getParams().getThreshold();
            }
            this.makeFrame();
            this.startSyncOverlays();
        }
        if (surface.hasColors()) {
            surface.updateColors(this.viewer);
        }
        this.updateModelClipTransforms();
        this.viewer.updateSurface();
        this.viewer.updateSurfaceTextures(true);
        this.updateAllROIShapeVolumes(this.viewer.getMainSliceDirection());
    }

    public List<Surface> getAddedShapes() {
        ArrayList<Surface> list = new ArrayList<Surface>();
        list.addAll(this.surfaces);
        list.remove(this.baseSurface);
        return list;
    }

    public double[] getAxialPoints() {
        return this.activePlaneVertsAxial;
    }

    public double[] getAxialTexturePlane() {
        this.viewer.updateActivePlanes(false);
        return this.activePlaneVertsAxialTexture;
    }

    public Color getBackgroundColor() {
        return new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue());
    }

    public Color getBackgroundColorOpposite() {
        return new Color(this.background.getOpposite(this.background.getRed()), this.background.getOpposite(this.background.getGreen()), this.background.getOpposite(this.background.getBlue()));
    }

    public CompositeSurface getBaseSurface() {
        return this.baseSurface;
    }

    public GLCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public File getCaptureDir() {
        return null;
    }

    @Override
    public String getCaptureName() {
        return null;
    }

    @Override
    public String getCaptureType() {
        return "surface";
    }

    public int getColorIndex(Color col) {
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (!ROIColor.getColor(ctr).equals(col)) continue;
            return ctr;
        }
        return -1;
    }

    public double[] getCoronalPoints() {
        return this.activePlaneVertsCoronal;
    }

    public double[] getCoronalTexturePlane() {
        this.viewer.updateActivePlanes(false);
        return this.activePlaneVertsCoronalTexture;
    }

    public Color getDefaultBackgroundColor() {
        return new Color(0.35f, 0.35f, 0.35f);
    }

    @Override
    public SurfaceFrame getFrame() {
        return this.frame;
    }

    public float[] getLightingValues() {
        Lighting lighting = this.baseSurface.getLighting();
        float[] values = new float[]{lighting.getAmbient(), lighting.getDiffuse(), lighting.getSpecular(), lighting.getDirection()[0], lighting.getDirection()[1], lighting.getDirection()[2]};
        return values;
    }

    public List<Shape> getLines() {
        ArrayList<Shape> list = new ArrayList<Shape>();
        list.addAll(this.getMarkerLines());
        return list;
    }

    public Marker getMarker(int key) {
        return this.allMarkers.get(key);
    }

    public MarkerLine getMarkerLine(int key) {
        return this.allMarkerLines.get(key);
    }

    public Collection<MarkerLine> getMarkerLines() {
        return this.allMarkerLines.values();
    }

    public Collection<Marker> getMarkers() {
        return this.allMarkers.values();
    }

    public float[] getMaterialValues(Surface surface) {
        float[] values = new float[6];
        for (CompositeSurface cs : this.surfaces) {
            if (cs != surface) continue;
            Material material = cs.getMaterial();
            values[0] = material.getColorComponents()[0];
            values[1] = material.getColorComponents()[1];
            values[2] = material.getColorComponents()[2];
            values[3] = material.getShininess();
            values[4] = material.getEmissivity();
            values[5] = material.getTransparency();
            break;
        }
        return values;
    }

    public int getObliqueCutPlaneDirection() {
        return this.position.getObliqueDirection();
    }

    public ImageTransform getObliqueCutPlaneTransform() {
        if (this.obliquePlaneDialog != null) {
            return this.obliquePlaneDialog.getImageTransform();
        }
        return null;
    }

    public List<Shape> getPoints() {
        ArrayList<Shape> list = new ArrayList<Shape>();
        list.addAll(this.getMarkers());
        return list;
    }

    public List<Shape> getAllPointsAndLines() {
        ArrayList<Shape> list = new ArrayList<Shape>();
        list.addAll(this.getMarkers());
        list.addAll(this.getMarkerLines());
        return list;
    }

    public String getPointString(Point3d point) {
        Coordinate coor = this.position.convertPointToCoordinate(point);
        if (this.viewer.getToolBox().isWorldMode()) {
            this.volData.convertIndexToWorldCoordinate(coor);
            return "(" + FORMATTER.format(coor.xDbl) + ", " + FORMATTER.format(coor.yDbl) + ", " + FORMATTER.format(coor.zDbl) + ")";
        }
        return "(" + FORMATTER.format(this.viewer.convertCoordinateOriginX(coor.xInt)) + ", " + FORMATTER.format(this.viewer.convertCoordinateOriginY(coor.yInt)) + ", " + FORMATTER.format(this.viewer.convertCoordinateOriginZ(coor.zInt)) + ")";
    }

    public SurfacePosition getPosition() {
        return this.position;
    }

    public SurfacePreferences getPreferences() {
        return this.preferences;
    }

    public double[] getSagittalPoints() {
        return this.activePlaneVertsSagittal;
    }

    public double[] getSagittalTexturePlane() {
        this.viewer.updateActivePlanes(false);
        return this.activePlaneVertsSagittalTexture;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public CompositeSurface getShape(String thatHash) {
        for (CompositeSurface shape : this.surfaces) {
            String thisHash = String.valueOf(shape.hashCode());
            if (!thisHash.equals(thatHash)) continue;
            return shape;
        }
        return null;
    }

    public Shape[] getShapeData() {
        Vector<ShapeData> shapeDataVec = new Vector<ShapeData>();
        for (Marker marker : this.allMarkers.values()) {
            PickableSurface ps;
            ShapeData sd = new ShapeData(new Point3d[]{marker.getPoint()}, marker.getColor());
            if (marker.isFromSurface() && (ps = marker.getSurfaceShape()) != null) {
                sd.setOnSurface(true);
                if (ps.isBaseSurface()) {
                    sd.setSurfaceName("BASESURFACE");
                } else {
                    sd.setSurfaceName(ps.getName());
                }
            }
            shapeDataVec.add(sd);
        }
        for (MarkerLine marker : this.allMarkerLines.values()) {
            ShapeData sd = new ShapeData(marker.getPoints(), marker.getColor());
            sd.setOnSurface(marker.isSurfaceLine());
            shapeDataVec.add(sd);
        }
        ShapeData[] shapeData = null;
        if (shapeDataVec.size() > 0) {
            shapeData = shapeDataVec.toArray(new ShapeData[shapeDataVec.size()]);
        }
        return shapeData;
    }

    public Vector<CompositeSurface> getShapes() {
        return this.surfaces;
    }

    public SurfaceInfoDialog getSurfaceInfo() {
        return this.surfaceInfo;
    }

    public Surface[] getSurfaces() {
        return this.surfaces.toArray(new Surface[this.surfaces.size()]);
    }

    public JFrame getSurfaceViewerFrame() {
        return this.frame;
    }

    public double[] getTexturePlanePoints(int direction) {
        double[] points = null;
        points = direction == 0 ? this.getAxialTexturePlane() : (direction == 1 ? this.getCoronalTexturePlane() : this.getSagittalTexturePlane());
        return points;
    }

    public float getThreshold() {
        if (MathUtilities.essentiallyEqual((float)this.cutPlaneThreshold, (float)Float.MIN_VALUE)) {
            return (float)this.viewer.getScreenVolume().getDynamicScreenMin();
        }
        return this.cutPlaneThreshold;
    }

    @Override
    public Dimension getVideoFrameDimensions() {
        return this.getCanvas().getSize();
    }

    public SliceViewer getViewer() {
        return this.viewer;
    }

    public BasicController getViewerController() {
        return this.viewer;
    }

    public double[] getViewTransform() {
        return this.position.getViewTransform();
    }

    public void goToPosition(double[] mat) {
        this.position.apply(this.canvas.getGL().getGL2(), mat);
        this.updateSurface();
    }

    public void goToSavedPosition() {
        this.position.goToSaved();
        this.updateSurface();
    }

    public boolean hasLine(Point3d start, Point3d end) {
        for (MarkerLine line : this.allMarkerLines.values()) {
            if (!line.containsLine(start, end)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSurfaceLine(Point3d start, Point3d end) {
        for (MarkerLine line : this.allMarkerLines.values()) {
            if (!line.isSurfaceLine() || (!line.getStartPoint().equals((Tuple3d)start) || !line.getEndPoint().equals((Tuple3d)end)) && (!line.getStartPoint().equals((Tuple3d)end) || !line.getEndPoint().equals((Tuple3d)start))) continue;
            return true;
        }
        return false;
    }

    public boolean hasVisibleShapes() {
        for (CompositeSurface shape : this.surfaces) {
            if (shape.isBaseSurface() || !shape.isVisible()) continue;
            return true;
        }
        for (Marker marker : this.allMarkers.values()) {
            if (!marker.isVisible()) continue;
            return true;
        }
        for (MarkerLine marker : this.allMarkerLines.values()) {
            if (!marker.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        AppLogger.info((String)"");
        AppLogger.info((String)("Graphics: " + gl.glGetString(7936) + ", " + gl.glGetString(7937)));
        AppLogger.info((String)("OpenGL Version: " + gl.glGetString(7938) + " (GLSL Version " + gl.glGetString(35724) + ")"));
        AppLogger.info((String)("JOGL Version: " + JoglVersion.getInstance().getImplementationVersion()));
        AppLogger.info((String)("Surface Options: " + (this.canUseShaders() ? "Better Graphics" : "Default Graphics")));
        AppLogger.info((String)"");
        this.checkCompatibility(gl);
        this.updateDimensionContingentInfo();
        this.ruler = new RulerTool(this);
        this.rulerAngle = new AngleTool(this);
        this.position.setDefaultZoom(gl, (int)Math.round(1.5 * ((double)this.yDim * this.ySize)), this.scaleFactor);
        this.makeTextureImages();
        gl.setSwapInterval(1);
        if (this.canUseShaders()) {
            this.uniforms = new int[8];
            this.shaderProgram = this.initShaders(gl, this.uniforms, false);
        }
        this.textRenderer = new TextRenderer(new Font("SansSerif", 0, 72));
        ((TextRenderer)this.textRenderer).setUseVertexArrays(false);
        this.inited = true;
        this.viewer.updateAllPoints();
        this.viewer.updateAllLines();
        if (this.baseSurface != null && this.baseSurface.getInitialViewTransform() != null) {
            this.position.setViewTransform(this.baseSurface.getInitialViewTransform());
            this.savePosition();
            this.goToSavedPosition();
        }
        this.viewer.updateSurface();
        if (Mango.getInstance().getSurfaceSyncer().isSynced()) {
            Mango.getInstance().getSurfaceSyncer().syncThis(this);
        }
    }

    public int initShaders(GL2 gl, int[] shaderUniforms, boolean offscreen) {
        int shaderprogram = 0;
        try {
            int v = gl.glCreateShader(35633);
            String vsrc = SurfaceViewer.readFromStream(this.getClass().getResourceAsStream("vert" + (offscreen ? "offscreen" : "") + ".glsl"));
            gl.glShaderSource(v, 1, new String[]{vsrc}, (int[])null, 0);
            gl.glCompileShader(v);
            if (!SurfaceViewer.checkShaderOperation(gl, v, 35713, "Vertex shader compile error")) {
                this.canUseShaders = false;
                return 0;
            }
            int f = gl.glCreateShader(35632);
            String fsrc = SurfaceViewer.readFromStream(this.getClass().getResourceAsStream("frag" + (offscreen ? "offscreen" : "") + ".glsl"));
            gl.glShaderSource(f, 1, new String[]{fsrc}, (int[])null, 0);
            gl.glCompileShader(f);
            if (!SurfaceViewer.checkShaderOperation(gl, f, 35713, "Fragment shader compile error")) {
                this.canUseShaders = false;
                return 0;
            }
            shaderprogram = gl.glCreateProgram();
            if (shaderprogram == 0) {
                AppLogger.info((String)"Shader program could not be created (returned 0).");
                this.canUseShaders = false;
                return 0;
            }
            gl.glAttachShader(shaderprogram, v);
            gl.glAttachShader(shaderprogram, f);
            gl.glLinkProgram(shaderprogram);
            if (!SurfaceViewer.checkShaderProgramOperation(gl, shaderprogram, 35714, "Link shaders error")) {
                this.canUseShaders = false;
                return 0;
            }
            gl.glValidateProgram(shaderprogram);
            if (!SurfaceViewer.checkShaderProgramOperation(gl, shaderprogram, 35715, "Validate shaders error")) {
                this.canUseShaders = false;
                return 0;
            }
            shaderUniforms[0] = gl.glGetUniformLocation(shaderprogram, "axialClipPlane" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[1] = gl.glGetUniformLocation(shaderprogram, "coronalClipPlane" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[2] = gl.glGetUniformLocation(shaderprogram, "sagittalClipPlane" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[3] = gl.glGetUniformLocation(shaderprogram, "axialClipPlaneUse" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[4] = gl.glGetUniformLocation(shaderprogram, "coronalClipPlaneUse" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[5] = gl.glGetUniformLocation(shaderprogram, "sagittalClipPlaneUse" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[6] = gl.glGetUniformLocation(shaderprogram, "transparentUse" + (offscreen ? TEXT_OFFSCREEN : ""));
            shaderUniforms[7] = gl.glGetUniformLocation(shaderprogram, "baseSurfaceUse" + (offscreen ? TEXT_OFFSCREEN : ""));
            gl.glDetachShader(shaderprogram, v);
            gl.glDetachShader(shaderprogram, f);
            gl.glDeleteShader(v);
            gl.glDeleteShader(f);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return shaderprogram;
    }

    public boolean isAnimating() {
        return this.animator != null;
    }

    public boolean isApplet() {
        return this.viewer.getMango().isApplet();
    }

    public boolean isBackgroundColorDark() {
        return this.background.isDark();
    }

    public boolean isBaseSurfaceTransparent() {
        if (this.baseSurface != null && this.baseSurface.getMaterial() != null) {
            return this.baseSurface.getMaterial().isTransparent() || this.baseSurface.getMaterial().getPolygonStyle() == 2 || this.baseSurface.isHidden();
        }
        return false;
    }

    public boolean isBuilding() {
        if (this.factory != null) {
            return this.factory.isBuilding();
        }
        return false;
    }

    public boolean isFrameVisible() {
        return this.frame != null && this.frame.isVisible();
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public boolean isObliqueAxial() {
        return this.preferences.isUsingObliqueCutPlane() && this.position.getObliqueDirection() == 0;
    }

    public boolean isObliqueCoronal() {
        return this.preferences.isUsingObliqueCutPlane() && this.position.getObliqueDirection() == 1;
    }

    public boolean isObliqueCutPlane() {
        return this.isObliqueAxial() || this.isObliqueCoronal() || this.isObliqueSagittal();
    }

    public boolean isObliqueSagittal() {
        return this.preferences.isUsingObliqueCutPlane() && this.position.getObliqueDirection() == 2;
    }

    @Override
    public boolean isSticky() {
        return this.frame.isSticky();
    }

    public boolean isSyncingShapes() {
        return true;
    }

    public boolean isUsingShaders() {
        return this.canUseShaders() && (this.position != null && this.position.isImageTransformIdentity() || !this.isObliqueCutPlane());
    }

    public boolean isVisible() {
        return this.canvas.isVisible();
    }

    public Analysis measureLine(MarkerLine ml) {
        AnalysisImpl analysis = new AnalysisImpl();
        analysis.setRegionSize(ml.getDistance());
        analysis.setType(7);
        analysis.setDescription(ml.toString());
        analysis.setName("Surface");
        analysis.setColor(ml.getColorObj());
        this.viewer.getMango().getResultsManager().addStatistic(this.viewer, this.viewer.getVolume(), analysis);
        return analysis;
    }

    public void measureSurfaceArea(CompositeSurface surface) {
        SurfaceArea sa = new SurfaceArea(this.viewer, surface, this.position, this.preferences);
        sa.calculateSurfaceArea(this);
    }

    public void measureSurfaceVolume(CompositeSurface surface) {
        SurfaceVolume sv = new SurfaceVolume(this.viewer, surface, this.position, this.preferences);
        sv.calculateSurfaceVolume(this);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.videoAnimating || me.isMetaDown()) {
            return;
        }
        this.mouseDragged = true;
        if (!this.measureMode) {
            this.position.updateDynamic(me.getPoint(), this.scaleFactor);
        }
        this.mouse = me.getPoint();
        this.updateSurface();
        if (this.measureMode && this.position.foundPickedSurface()) {
            PickableSurface pickedSurface = this.position.getPickedSurface();
            this.position.resetPick();
            if (pickedSurface instanceof CompositeSurface) {
                this.grabbedMarker.setSurfaceShape(pickedSurface);
                this.grabbedMarker.editMarker2(pickedSurface.getPickedSurfaceCoordinate());
            }
        }
        if (Mango.getInstance().getSurfaceSyncer().isSynced()) {
            Mango.getInstance().getSurfaceSyncer().syncDynamic(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.videoAnimating) {
            return;
        }
        this.updateCursor();
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.videoAnimating) {
            return;
        }
        if (!this.mouseDoubleClicked && !this.isAnimating()) {
            this.mouse = me.getPoint();
            this.updateSurface();
            if (this.position.foundPickedSurface()) {
                PickableSurface pickedSurface = this.position.getPickedSurface();
                this.position.resetPick();
                this.pick(pickedSurface);
            } else {
                this.viewer.getMango().getToolBox().updateMouseLabelOutOfBounds();
            }
        }
    }

    public void pauseScriptForUserInput() {
        this.viewer.pauseScriptForUserInput();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.videoAnimating) {
            return;
        }
        this.mouseDragged = false;
        this.recordAction("pauseScriptForUserInput");
        Point point = me.getPoint();
        this.zoomMode = me.isAltDown();
        this.mouse = me.getPoint();
        this.mouseDoubleClicked = me.getClickCount() == 2 || this.viewer.isPOIMode() && this.grabbedMarker == null;
        this.markerMode = me.isShiftDown() || this.viewer.isPOIMode();
        this.grabbedMarker = null;
        if (this.isAnimating()) {
            this.stopAnimation();
        }
        this.position.setDynamicStart(point, this.getDynamicMode(me));
        this.updateCursor();
        this.updateSurface();
        if (this.ruler.containsMarker(this.position.getPickedSurface())) {
            this.grabbedMarker = (Marker)this.position.getPickedSurface();
            this.measureMode = true;
        } else if (this.rulerAngle.containsMarker(this.position.getPickedSurface())) {
            this.grabbedMarker = (Marker)this.position.getPickedSurface();
            this.measureMode = true;
        } else if (this.viewer.isPOIMode() && this.position.getPickedSurface() instanceof Marker) {
            this.grabbedMarker = (Marker)this.position.getPickedSurface();
            this.measureMode = true;
        }
        if (this.measureMode) {
            this.updateSurface();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.videoAnimating) {
            return;
        }
        this.position.updateCurrent();
        if (this.measureMode) {
            this.grabbedMarker = null;
        }
        if (me.isMetaDown()) {
            this.mouse = me.getPoint();
            this.updateSurface();
            if (this.position.foundPickedSurface()) {
                PickableSurface pickedSurface = this.position.getPickedSurface();
                this.position.resetPick();
                if (pickedSurface instanceof CompositeSurface) {
                    SurfaceContextMenu.doPop(this, (CompositeSurface)pickedSurface, (Component)this.canvas, me.getPoint());
                }
            }
        } else if (!(!this.position.foundPickedSurface() || this.mouseDragged && this.viewer.isPOIMode())) {
            PickableSurface pickedSurface = this.position.getPickedSurface();
            this.position.resetPick();
            this.pick(pickedSurface);
        }
        this.mouseDoubleClicked = false;
        this.measureMode = false;
        this.updateCursor();
        if (Mango.getInstance().getSurfaceSyncer().isSynced()) {
            Mango.getInstance().getSurfaceSyncer().sync(this);
        }
        this.viewer.updateSurface();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.videoAnimating) {
            return;
        }
        int wheelRotation = mwe.getWheelRotation();
        if (this.viewer.isScrollwheelDirectionFlip()) {
            wheelRotation *= -1;
        }
        this.position.updateScroll(wheelRotation, 2, this.scaleFactor);
        this.updateSurface();
        this.position.updateCurrent();
    }

    @Override
    public void overlayAdded(ScreenVolume vol) {
        vol.addOverlayListener(this);
        for (CompositeSurface surface : this.surfaces) {
            if (!surface.getMaterial().isShowOverlayColors()) continue;
            SurfaceOverlay so = surface.addOverlay(vol);
            if (this.viewer.hasOverlayTimeseries()) {
                this.startSyncOverlays();
                continue;
            }
            SurfaceScalarsBuilder scalarsBuilder = new SurfaceScalarsBuilder(this.viewer, this.position, surface, this.viewer.getBaseVolume(), so);
            scalarsBuilder.buildScalars(this, surface.getMaterial().getDistance(), SurfaceScalarsBuilder.getStepSizeDefault(this));
        }
    }

    @Override
    public void overlayChanged(Object overlay, boolean overlaySelected) {
        for (CompositeSurface surface : this.surfaces) {
            if (!surface.getMaterial().isShowOverlayColors()) continue;
            surface.updateColors(this.viewer);
        }
        this.updateSurface();
    }

    @Override
    public void overlayRemoved(Object overlay) {
        if (overlay instanceof ScreenVolume) {
            this.overlayRemoved((ScreenVolume)overlay);
        }
    }

    @Override
    public void overlayRemoved(ScreenVolume vol) {
        for (CompositeSurface surface : this.surfaces) {
            if (!surface.getMaterial().isShowOverlayColors()) continue;
            surface.removeOverlay(vol);
            surface.updateColors(this.viewer);
        }
        this.updateSurface();
    }

    public void pickOctant(int val) {
        this.position.setPickedOctant(val);
        this.updateObliqueCutPlaneDialog();
        this.updateModelClips();
        this.viewer.updateActivePlanes(false);
    }

    public void removeAllMarkerLines() {
        Collection<MarkerLine> markers = this.getMarkerLines();
        for (MarkerLine marker : markers) {
            if (marker.getSyncObject() == null) continue;
            this.viewer.removeLineFromSurface(marker.getSyncObject());
            this.viewer.updateViewer();
        }
        this.lineCounter = 1;
        this.allMarkerLines.clear();
    }

    public void removeAllMarkers() {
        Collection<Marker> markers = this.getMarkers();
        for (Marker marker : markers) {
            if (marker.getSyncObject() == null) continue;
            this.viewer.removePointFromSurface(marker.getSyncObject());
            this.viewer.updateViewer();
        }
        this.pointCounter = 1;
        this.allMarkers.clear();
    }

    public void removeFromDisplay(SurfacePlugin plugin) {
        this.pluginToRemove = plugin;
        this.updateSurface();
    }

    public void removeMarker(int num, boolean fromSliceViewer) {
        Marker marker = this.allMarkers.get(num);
        if (fromSliceViewer && marker.getSyncObject() != null) {
            this.viewer.removePointFromSurface(marker.getSyncObject());
            this.viewer.updateViewer();
        }
        Point3d point = marker.getPoint();
        Vector<MarkerLine> linesToRemove = new Vector<MarkerLine>();
        for (MarkerLine ml : this.allMarkerLines.values()) {
            if (ml.containsPoint(point) == -1) continue;
            linesToRemove.add(ml);
        }
        for (MarkerLine ml : linesToRemove) {
            this.removeMarkerLine(ml.getNumber(), true);
        }
        this.allMarkers.remove(num);
    }

    public void removeMarkerLine(int num, boolean fromSliceViewer) {
        MarkerLine marker = this.allMarkerLines.get(num);
        if (fromSliceViewer && marker.getSyncObject() != null) {
            this.viewer.removeLineFromSurface(marker.getSyncObject());
            this.viewer.updateViewer();
        }
        this.allMarkerLines.remove(num);
    }

    public void removeShape(String hash) {
        CompositeSurface shape = this.getShape(hash);
        if (shape != null) {
            this.clearedShape = shape;
        }
        this.updateSurface();
    }

    public void renderAnimationFrame(GLAutoDrawable drawable, int[] shaderUniforms, int shaderprogram) {
        this.display(drawable, true, shaderUniforms, shaderprogram);
    }

    public void reorderSurfaceOverlays() {
        for (CompositeSurface surface : this.surfaces) {
            this.reorderSurfaceOverlays(surface);
            surface.updateColors(this.viewer);
        }
        this.updateSurface();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int w, int h) {
    }

    public void savePosition() {
        this.position.save();
    }

    @Override
    public synchronized void scalarBuildFinished(final CompositeSurface surface) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                surface.updateColors(SurfaceViewer.this.viewer);
                SurfaceViewer.this.updateSurface();
            }
        });
    }

    public void setAnimating(boolean animating) {
        this.videoAnimating = animating;
    }

    public void setBackgroundColor(Color color) {
        this.recordAction("setBackground", new String[]{String.valueOf(color.getRGB())});
        float[] comps = color.getColorComponents(null);
        this.background.setRed(comps[0]);
        this.background.setGreen(comps[1]);
        this.background.setBlue(comps[2]);
    }

    public void setColor(Color colorMin, Color colorMax) {
        if (colorMin.getRed() == colorMin.getGreen() && colorMin.getGreen() == colorMin.getBlue()) {
            if (colorMax.getRed() == colorMax.getGreen() && colorMax.getGreen() == colorMax.getBlue()) {
                this.baseSurface.getMaterial().setColor(Color.WHITE);
            } else {
                this.baseSurface.getMaterial().setColor(colorMax);
            }
        } else {
            this.baseSurface.getMaterial().setColor(colorMin);
        }
    }

    public void setLightingValues(float ambient, float diffuse, float specular, float[] direction) {
        Lighting lighting = this.baseSurface.getLighting();
        lighting.setLightingParameters(ambient, diffuse, specular);
        lighting.setLightingDirection(direction);
        this.updateSurface();
    }

    public void setMaterialValues(Surface surface, float[] color, float shininess, float emissivity, float transparency) {
        for (CompositeSurface cs : this.surfaces) {
            if (cs != surface) continue;
            Material material = cs.getMaterial();
            material.setColorComponents(color);
            material.setShininess(shininess);
            material.setEmissivity(emissivity);
            material.setTransparency(transparency);
            break;
        }
    }

    public void setRemoveAllShapes() {
        this.clearAllShapes = true;
    }

    public void setSurfaceFromFile(Surface[] surfaces, Vector<Shape> shapes) {
        if (surfaces != null) {
            this.setRemoveAllShapes();
            CompositeSurface cs = this.makeCompositeSurface(surfaces[0]);
            if (cs != null) {
                cs.setBaseSurface(true);
                cs.getMaterial().setShowOverlayColors(true);
                this.cutPlaneThreshold = cs.getThreshold();
                this.loadingShapeData = shapes;
                this.finishedBuild(cs);
                if (surfaces.length > 1) {
                    this.surfacesToLoad = new Vector();
                    for (int ctr = 1; ctr < surfaces.length; ++ctr) {
                        cs = this.makeCompositeSurface(surfaces[ctr]);
                        if (cs.hasColors()) {
                            cs.getMaterial().setShowOverlayColors(true);
                            cs.getMaterial().setShowOnlyThisOverlayColors(true);
                        }
                        this.surfacesToLoad.add(cs);
                    }
                }
            }
        }
    }

    public void setSurfaceInfo(SurfaceInfoDialog surfaceInfo) {
        this.surfaceInfo = surfaceInfo;
    }

    public void setTexturePlane(Point3d p1, Point3d p2, Point3d p3, Point3d p4, int direction) {
        if (direction == 0) {
            this.setAxialTexturePlane(p1, p2, p3, p4);
        } else if (direction == 1) {
            this.setCoronalTexturePlane(p1, p2, p3, p4);
        } else if (direction == 2) {
            this.setSagittalTexturePlane(p1, p2, p3, p4);
        }
    }

    public void setThreshold(float val) {
        this.cutPlaneThreshold = val;
    }

    public void setViewTransform(double[] xform) {
        this.position.setViewTransform(xform);
    }

    public void showErrorDialog(String message, String title) {
        this.viewer.getMango().showErrorDialog(message, title);
    }

    public void showObliquePlaneDialog(boolean show) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Oblique Cut Plane"), ScriptUtils.convertBoolean(show)});
        if (show) {
            if (this.obliquePlaneDialog == null) {
                this.obliquePlaneDialog = new SurfaceObliquePlaneDialog(this);
            }
            this.obliquePlaneDialog.setVisible(true);
            if (this.preferences.isUsingCutPlane()) {
                if (this.preferences.isUsingAxialCutPlane()) {
                    this.position.setObliqueDirection(0);
                    this.obliquePlaneDialog.updateToAxial();
                } else if (this.preferences.isUsingCoronalCutPlane()) {
                    this.position.setObliqueDirection(1);
                    this.obliquePlaneDialog.updateToCoronal();
                } else if (this.preferences.isUsingSagittalCutPlane()) {
                    this.position.setObliqueDirection(2);
                    this.obliquePlaneDialog.updateToSagittal();
                }
            } else {
                this.preferences.setAxialCutPlane(1);
                this.position.setObliqueDirection(0);
                this.obliquePlaneDialog.updateToAxial();
            }
            this.obliquePlaneDialog.updateTransform();
        } else {
            if (this.obliquePlaneDialog != null) {
                this.obliquePlaneDialog.setVisible(false);
            }
            this.position.setObliqueDirection(-1);
        }
        this.preferences.setUsingObliqueCutPlane(show);
        this.updateObliqueCutPlaneDialog();
        this.viewer.updateActivePlanes(true);
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void startAnimation() {
        if (!this.isAnimating()) {
            this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Animate"), ScriptUtils.convertBoolean(true)});
            this.lastFps = 0;
            this.animator = new FPSAnimator((GLAutoDrawable)this.canvas, 60);
            this.animator.setUpdateFPSFrames(5, null);
            this.animator.start();
        }
    }

    public void startUpdateROIShapeTimer(final boolean all, final int color, final int slice, final int direction) {
        if (this.upateROIShapeTimer != null) {
            this.upateROIShapeTimer.cancel();
            this.upateROIShapeTimer = null;
        }
        this.upateROIShapeTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SurfaceViewer.this.doUpdateROIShape(all, color, slice, direction);
                    }
                });
            }
        };
        this.upateROIShapeTimer.schedule(task, 5000L);
    }

    @Override
    public synchronized void startVideoCapture(int fps, VideoCaptureListener videoCaptureListener) {
        this.videoCaptureListener = videoCaptureListener;
        this.videoCaptureFps = fps;
        this.videoFrames = new Vector();
        this.captureVideo();
        this.startVideoCaptureTimer();
    }

    public void stopAnimation() {
        if (this.animator != null) {
            this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Animate"), ScriptUtils.convertBoolean(false)});
            this.animator.remove((GLAutoDrawable)this.canvas);
            this.animator.stop();
            this.animator = null;
        }
    }

    @Override
    public void surfaceFileRead(final boolean success, final Surface[] surfaces, final Vector<Shape> shapes, final String message) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (success) {
                    SurfaceViewer.this.addSurfaceFromFile(surfaces, shapes);
                    SurfaceViewer.this.updateSurface();
                } else {
                    SurfaceViewer.this.showErrorDialog(message, "Surface Import Error");
                }
            }
        });
    }

    @Override
    public void surfaceFileWritten(final boolean success, final File file, final String message) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!success) {
                    SurfaceViewer.this.showErrorDialog(message, "Surface Export Error");
                }
                Mango.getInstance().updateImageBrowser(file);
            }
        });
    }

    public void syncOverlays(CompositeSurface surface) {
        this.doSyncOverlays(surface);
    }

    public void transformPoints(float[][] xform) {
        int numParts = this.baseSurface.getNumParts();
        for (int ctr = 0; ctr < numParts; ++ctr) {
            FloatBuffer points = this.baseSurface.getPointsBuffer(ctr);
            int numPointValues = points.capacity();
            for (int ctrP = 0; ctrP < numPointValues; ctrP += 3) {
                float xLoc = points.get(ctrP);
                float yLoc = points.get(ctrP + 1);
                float zLoc = points.get(ctrP + 2);
                float xTrans = xLoc * xform[0][0] + yLoc * xform[0][1] + zLoc * xform[0][2] + xform[0][3];
                float yTrans = xLoc * xform[1][0] + yLoc * xform[1][1] + zLoc * xform[1][2] + xform[1][3];
                float zTrans = xLoc * xform[2][0] + yLoc * xform[2][1] + zLoc * xform[2][2] + xform[2][3];
                points.put(ctrP, xTrans);
                points.put(ctrP + 1, yTrans);
                points.put(ctrP + 2, zTrans);
            }
        }
        this.rebindPoints = true;
    }

    public void updateActivePlanes(int sliceX, int sliceY, int sliceZ, int mainSliceDir, boolean updateSurface) {
        this.xSlice = sliceX;
        this.ySlice = sliceY;
        this.zSlice = sliceZ;
        double axialZoffset = Math.max(0.1, 0.1 * this.zSize);
        double coronalZoffset = Math.min(0.1, 0.1 * this.ySize);
        double sagittalZoffset = Math.max(0.1, 0.1 * this.xSize);
        if ((this.position.getLastPickedOctant() & 4) != 0) {
            axialZoffset *= -1.0;
        }
        if ((this.position.getLastPickedOctant() & 2) == 0) {
            coronalZoffset *= -1.0;
        }
        if ((this.position.getLastPickedOctant() & 1) != 0) {
            sagittalZoffset *= -1.0;
        }
        this.position.setCurrentCoordinate((double)this.xSlice * this.xSize - this.xHalf, (double)this.ySlice * this.ySize - this.yHalf, (double)this.zSlice * this.zSize - this.zHalf);
        this.mainDirection = mainSliceDir;
        this.crosshairLineVertsZ[0] = (double)this.xSlice * this.xSize - this.xHalf + sagittalZoffset;
        this.crosshairLineVertsZ[1] = (double)this.ySlice * this.ySize - this.yHalf + coronalZoffset;
        this.crosshairLineVertsZ[2] = -this.zHalf;
        this.crosshairLineVertsZ[3] = (double)this.xSlice * this.xSize - this.xHalf + sagittalZoffset;
        this.crosshairLineVertsZ[4] = (double)this.ySlice * this.ySize - this.yHalf + coronalZoffset;
        this.crosshairLineVertsZ[5] = this.zHalf;
        this.crosshairLineVertsY[0] = (double)this.xSlice * this.xSize - this.xHalf + sagittalZoffset;
        this.crosshairLineVertsY[1] = -this.yHalf;
        this.crosshairLineVertsY[2] = (double)this.zSlice * this.zSize - this.zHalf + axialZoffset;
        this.crosshairLineVertsY[3] = (double)this.xSlice * this.xSize - this.xHalf + sagittalZoffset;
        this.crosshairLineVertsY[4] = this.yHalf;
        this.crosshairLineVertsY[5] = (double)this.zSlice * this.zSize - this.zHalf + axialZoffset;
        this.crosshairLineVertsX[0] = -this.xHalf;
        this.crosshairLineVertsX[1] = (double)this.ySlice * this.ySize - this.yHalf + coronalZoffset;
        this.crosshairLineVertsX[2] = (double)this.zSlice * this.zSize - this.zHalf + axialZoffset;
        this.crosshairLineVertsX[3] = this.xHalf;
        this.crosshairLineVertsX[4] = (double)this.ySlice * this.ySize - this.yHalf + coronalZoffset;
        this.crosshairLineVertsX[5] = (double)this.zSlice * this.zSize - this.zHalf + axialZoffset;
        this.activePlaneVertsAxial[0] = -this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsAxial[1] = -this.yHalf + this.ySize / 2.0;
        this.activePlaneVertsAxial[2] = (double)this.zSlice * this.zSize - this.zHalf - axialZoffset;
        this.activePlaneVertsAxial[3] = -this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsAxial[4] = this.yHalf + this.ySize / 2.0;
        this.activePlaneVertsAxial[5] = (double)this.zSlice * this.zSize - this.zHalf - axialZoffset;
        this.activePlaneVertsAxial[6] = this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsAxial[7] = this.yHalf + this.ySize / 2.0;
        this.activePlaneVertsAxial[8] = (double)this.zSlice * this.zSize - this.zHalf - axialZoffset;
        this.activePlaneVertsAxial[9] = this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsAxial[10] = -this.yHalf + this.ySize / 2.0;
        this.activePlaneVertsAxial[11] = (double)this.zSlice * this.zSize - this.zHalf - axialZoffset;
        this.activePlaneVertsCoronal[0] = -this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsCoronal[1] = (double)this.ySlice * this.ySize - this.yHalf - coronalZoffset;
        this.activePlaneVertsCoronal[2] = -this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsCoronal[3] = -this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsCoronal[4] = (double)this.ySlice * this.ySize - this.yHalf - coronalZoffset;
        this.activePlaneVertsCoronal[5] = this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsCoronal[6] = this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsCoronal[7] = (double)this.ySlice * this.ySize - this.yHalf - coronalZoffset;
        this.activePlaneVertsCoronal[8] = this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsCoronal[9] = this.xHalf - this.xSize / 2.0;
        this.activePlaneVertsCoronal[10] = (double)this.ySlice * this.ySize - this.yHalf - coronalZoffset;
        this.activePlaneVertsCoronal[11] = -this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsSagittal[0] = (double)this.xSlice * this.xSize - this.xHalf - sagittalZoffset;
        this.activePlaneVertsSagittal[1] = -this.yHalf - this.ySize / 2.0;
        this.activePlaneVertsSagittal[2] = -this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsSagittal[3] = (double)this.xSlice * this.xSize - this.xHalf - sagittalZoffset;
        this.activePlaneVertsSagittal[4] = -this.yHalf - this.ySize / 2.0;
        this.activePlaneVertsSagittal[5] = this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsSagittal[6] = (double)this.xSlice * this.xSize - this.xHalf - sagittalZoffset;
        this.activePlaneVertsSagittal[7] = this.yHalf - this.ySize / 2.0;
        this.activePlaneVertsSagittal[8] = this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsSagittal[9] = (double)this.xSlice * this.xSize - this.xHalf - sagittalZoffset;
        this.activePlaneVertsSagittal[10] = this.yHalf - this.ySize / 2.0;
        this.activePlaneVertsSagittal[11] = -this.zHalf + this.zSize / 2.0;
        this.activePlaneVertsAxialTexture[0] = -this.xHalf + -this.xSize;
        this.activePlaneVertsAxialTexture[1] = -this.yHalf + -this.ySize;
        this.activePlaneVertsAxialTexture[2] = (double)this.zSlice * this.zSize - this.zHalf;
        this.activePlaneVertsAxialTexture[3] = this.xHalf + -this.xSize;
        this.activePlaneVertsAxialTexture[4] = -this.yHalf + -this.ySize;
        this.activePlaneVertsAxialTexture[5] = (double)this.zSlice * this.zSize - this.zHalf;
        this.activePlaneVertsAxialTexture[6] = this.xHalf + -this.xSize;
        this.activePlaneVertsAxialTexture[7] = this.yHalf + -this.ySize;
        this.activePlaneVertsAxialTexture[8] = (double)this.zSlice * this.zSize - this.zHalf;
        this.activePlaneVertsAxialTexture[9] = -this.xHalf + -this.xSize;
        this.activePlaneVertsAxialTexture[10] = this.yHalf + -this.ySize;
        this.activePlaneVertsAxialTexture[11] = (double)this.zSlice * this.zSize - this.zHalf;
        this.activePlaneVertsCoronalTexture[0] = -this.xHalf + -this.xSize;
        this.activePlaneVertsCoronalTexture[1] = (double)this.ySlice * this.ySize - this.yHalf;
        this.activePlaneVertsCoronalTexture[2] = -this.zHalf + -this.zSize;
        this.activePlaneVertsCoronalTexture[3] = this.xHalf + -this.xSize;
        this.activePlaneVertsCoronalTexture[4] = (double)this.ySlice * this.ySize - this.yHalf;
        this.activePlaneVertsCoronalTexture[5] = -this.zHalf + -this.zSize;
        this.activePlaneVertsCoronalTexture[6] = this.xHalf + -this.xSize;
        this.activePlaneVertsCoronalTexture[7] = (double)this.ySlice * this.ySize - this.yHalf;
        this.activePlaneVertsCoronalTexture[8] = this.zHalf + -this.zSize;
        this.activePlaneVertsCoronalTexture[9] = -this.xHalf + -this.xSize;
        this.activePlaneVertsCoronalTexture[10] = (double)this.ySlice * this.ySize - this.yHalf;
        this.activePlaneVertsCoronalTexture[11] = this.zHalf + -this.zSize;
        this.activePlaneVertsSagittalTexture[0] = (double)this.xSlice * this.xSize - this.xHalf;
        this.activePlaneVertsSagittalTexture[1] = -this.yHalf + -this.ySize;
        this.activePlaneVertsSagittalTexture[2] = this.zHalf + -this.zSize;
        this.activePlaneVertsSagittalTexture[3] = (double)this.xSlice * this.xSize - this.xHalf;
        this.activePlaneVertsSagittalTexture[4] = -this.yHalf + -this.ySize;
        this.activePlaneVertsSagittalTexture[5] = -this.zHalf + -this.zSize;
        this.activePlaneVertsSagittalTexture[6] = (double)this.xSlice * this.xSize - this.xHalf;
        this.activePlaneVertsSagittalTexture[7] = this.yHalf + -this.ySize;
        this.activePlaneVertsSagittalTexture[8] = -this.zHalf + -this.zSize;
        this.activePlaneVertsSagittalTexture[9] = (double)this.xSlice * this.xSize - this.xHalf;
        this.activePlaneVertsSagittalTexture[10] = this.yHalf + -this.ySize;
        this.activePlaneVertsSagittalTexture[11] = this.zHalf + -this.zSize;
        if (updateSurface) {
            this.updateSurface();
        }
    }

    public void updateAllROILines(LOIShape[] allLOIs) {
        Vector<MarkerLine> syncedMarkers = new Vector<MarkerLine>();
        Vector<MarkerLine> unsyncedMarkers = new Vector<MarkerLine>();
        for (MarkerLine ml : this.allMarkerLines.values()) {
            if (ml.getSyncObject() != null) {
                syncedMarkers.add(ml);
                continue;
            }
            unsyncedMarkers.add(ml);
        }
        for (MarkerLine ml : syncedMarkers) {
            this.allMarkerLines.remove(ml.getNumber());
        }
        this.lineCounter = 1;
        for (MarkerLine ml : unsyncedMarkers) {
            this.allMarkerLines.remove(ml.getNumber());
            ml.setNumber(this.lineCounter);
            this.allMarkerLines.put(this.lineCounter, ml);
            ++this.lineCounter;
        }
        if (allLOIs != null) {
            for (LOIShape allLOI : allLOIs) {
                this.addMarkerLine(allLOI);
            }
        }
    }

    public void updateAllROIPoints(POI[] allPOIs) {
        Vector<Marker> syncedMarkers = new Vector<Marker>();
        Vector<Marker> unsyncedMarkers = new Vector<Marker>();
        for (Marker marker : this.allMarkers.values()) {
            if (marker.getSyncObject() != null) {
                syncedMarkers.add(marker);
                continue;
            }
            unsyncedMarkers.add(marker);
        }
        for (Marker marker : syncedMarkers) {
            this.allMarkers.remove(marker.getNumber());
        }
        this.pointCounter = 1;
        for (Marker marker : unsyncedMarkers) {
            this.allMarkers.remove(marker.getNumber());
            marker.setNumber(this.pointCounter);
            this.allMarkers.put(this.pointCounter, marker);
            ++this.pointCounter;
        }
        if (allPOIs != null) {
            for (POI poi : allPOIs) {
                this.addMarker(poi);
            }
        }
    }

    public void updateCursor() {
        if (this.grabbedMarker != null) {
            this.canvas.setCursor(ScreenSlice.CUSTOM_CURSOR_EMPTY);
        } else {
            this.canvas.setCursor(ScreenSlice.CUSTOM_CURSOR);
        }
    }

    public void updateModelClips() {
        if (this.position.getLastPickedOctant() == -1) {
            return;
        }
        if (this.preferences.isUsingObliqueCutPlane()) {
            this.obliquePlaneDialog.updateTransform();
        }
        if (this.isUsingShaders()) {
            if ((this.position.getLastPickedOctant() & 4) != 0) {
                this.axialModClip[0] = 0.0;
                this.axialModClip[1] = 0.0;
                this.axialModClip[2] = 1.0;
                this.axialModClip[3] = (float)((double)this.zSlice * this.zSize - this.zHalf);
            } else {
                this.axialModClip[0] = 0.0;
                this.axialModClip[1] = 0.0;
                this.axialModClip[2] = -1.0;
                this.axialModClip[3] = (float)((double)this.zSlice * -this.zSize + this.zHalf);
            }
            if ((this.position.getLastPickedOctant() & 2) != 0) {
                this.coronalModClip[0] = 0.0;
                this.coronalModClip[1] = -1.0;
                this.coronalModClip[2] = 0.0;
                this.coronalModClip[3] = (float)((double)this.ySlice * -this.ySize + this.yHalf);
            } else {
                this.coronalModClip[0] = 0.0;
                this.coronalModClip[1] = 1.0;
                this.coronalModClip[2] = 0.0;
                this.coronalModClip[3] = (float)((double)this.ySlice * this.ySize - this.yHalf);
            }
            if ((this.position.getLastPickedOctant() & 1) != 0) {
                this.sagittalModClip[0] = 1.0;
                this.sagittalModClip[1] = 0.0;
                this.sagittalModClip[2] = 0.0;
                this.sagittalModClip[3] = (float)((double)this.xSlice * this.xSize - this.xHalf);
            } else {
                this.sagittalModClip[0] = -1.0;
                this.sagittalModClip[1] = 0.0;
                this.sagittalModClip[2] = 0.0;
                this.sagittalModClip[3] = (float)((double)this.xSlice * -this.xSize + this.xHalf);
            }
        } else {
            if ((this.position.getLastPickedOctant() & 4) == 0) {
                this.axialModClip[0] = 0.0;
                this.axialModClip[1] = 0.0;
                this.axialModClip[2] = -1.0;
                this.axialModClip[3] = (float)((double)this.zSlice * this.zSize - this.zHalf);
            } else {
                this.axialModClip[0] = 0.0;
                this.axialModClip[1] = 0.0;
                this.axialModClip[2] = 1.0;
                this.axialModClip[3] = (float)((double)this.zSlice * -this.zSize + this.zHalf);
            }
            if ((this.position.getLastPickedOctant() & 2) == 0) {
                this.coronalModClip[0] = 0.0;
                this.coronalModClip[1] = 1.0;
                this.coronalModClip[2] = 0.0;
                this.coronalModClip[3] = (float)((double)this.ySlice * -this.ySize + this.yHalf);
            } else {
                this.coronalModClip[0] = 0.0;
                this.coronalModClip[1] = -1.0;
                this.coronalModClip[2] = 0.0;
                this.coronalModClip[3] = (float)((double)this.ySlice * this.ySize - this.yHalf);
            }
            if ((this.position.getLastPickedOctant() & 1) == 0) {
                this.sagittalModClip[0] = -1.0;
                this.sagittalModClip[1] = 0.0;
                this.sagittalModClip[2] = 0.0;
                this.sagittalModClip[3] = (float)((double)this.xSlice * this.xSize - this.xHalf);
            } else {
                this.sagittalModClip[0] = 1.0;
                this.sagittalModClip[1] = 0.0;
                this.sagittalModClip[2] = 0.0;
                this.sagittalModClip[3] = (float)((double)this.xSlice * -this.xSize + this.xHalf);
            }
        }
        if ((this.position.getLastPickedOctant() & 4) == 0) {
            this.axialTextureModClip[0] = 0.0;
            this.axialTextureModClip[1] = 0.0;
            this.axialTextureModClip[2] = 1.0;
            this.axialTextureModClip[3] = (double)this.zSlice * -this.zSize + this.zHalf;
        } else {
            this.axialTextureModClip[0] = 0.0;
            this.axialTextureModClip[1] = 0.0;
            this.axialTextureModClip[2] = -1.0;
            this.axialTextureModClip[3] = (double)this.zSlice * this.zSize - this.zHalf;
        }
        if ((this.position.getLastPickedOctant() & 2) != 0) {
            this.coronalTextureModClip[0] = 0.0;
            this.coronalTextureModClip[1] = 1.0;
            this.coronalTextureModClip[2] = 0.0;
            this.coronalTextureModClip[3] = (double)this.ySlice * -this.ySize + this.yHalf;
        } else {
            this.coronalTextureModClip[0] = 0.0;
            this.coronalTextureModClip[1] = -1.0;
            this.coronalTextureModClip[2] = 0.0;
            this.coronalTextureModClip[3] = (double)this.ySlice * this.ySize - this.yHalf;
        }
        if ((this.position.getLastPickedOctant() & 1) != 0) {
            this.sagittalTextureModClip[0] = -1.0;
            this.sagittalTextureModClip[1] = 0.0;
            this.sagittalTextureModClip[2] = 0.0;
            this.sagittalTextureModClip[3] = (double)this.xSlice * this.xSize - this.xHalf;
        } else {
            this.sagittalTextureModClip[0] = 1.0;
            this.sagittalTextureModClip[1] = 0.0;
            this.sagittalTextureModClip[2] = 0.0;
            this.sagittalTextureModClip[3] = (double)this.xSlice * -this.xSize + this.xHalf;
        }
        this.updateModelClipTransforms();
    }

    public void updateObliqueCutPlane(Vector4d cutPlane, int direction) {
        this.position.setObliqueDirection(direction);
        this.obliqueModClip[0] = (float)cutPlane.x;
        this.obliqueModClip[1] = (float)cutPlane.y;
        this.obliqueModClip[2] = (float)cutPlane.z;
        this.obliqueModClip[3] = (float)cutPlane.w;
        if (direction == 0) {
            Vector4d plane = SurfaceUtils.flipPlane(cutPlane);
            this.sagittalTextureModClipOblique[0] = plane.x;
            this.sagittalTextureModClipOblique[1] = plane.y;
            this.sagittalTextureModClipOblique[2] = plane.z;
            this.sagittalTextureModClipOblique[3] = plane.w;
            this.coronalTextureModClipOblique[0] = cutPlane.x;
            this.coronalTextureModClipOblique[1] = cutPlane.y;
            this.coronalTextureModClipOblique[2] = cutPlane.z;
            this.coronalTextureModClipOblique[3] = cutPlane.w;
            this.axialTextureModClipOblique[0] = cutPlane.x;
            this.axialTextureModClipOblique[1] = cutPlane.y;
            this.axialTextureModClipOblique[2] = cutPlane.z;
            this.axialTextureModClipOblique[3] = cutPlane.w;
        } else if (direction == 1) {
            Vector4d plane = SurfaceUtils.flipPlane(cutPlane);
            this.sagittalTextureModClipOblique[0] = plane.x;
            this.sagittalTextureModClipOblique[1] = plane.y;
            this.sagittalTextureModClipOblique[2] = plane.z;
            this.sagittalTextureModClipOblique[3] = plane.w;
            this.coronalTextureModClipOblique[0] = cutPlane.x;
            this.coronalTextureModClipOblique[1] = cutPlane.y;
            this.coronalTextureModClipOblique[2] = cutPlane.z;
            this.coronalTextureModClipOblique[3] = cutPlane.w;
            cutPlane.y *= -1.0;
            this.axialTextureModClipOblique[0] = cutPlane.x;
            this.axialTextureModClipOblique[1] = cutPlane.y;
            this.axialTextureModClipOblique[2] = cutPlane.z;
            this.axialTextureModClipOblique[3] = cutPlane.w;
        } else if (direction == 2) {
            Vector4d plane = SurfaceUtils.flipPlane(cutPlane);
            this.sagittalTextureModClipOblique[0] = plane.x;
            this.sagittalTextureModClipOblique[1] = plane.y;
            this.sagittalTextureModClipOblique[2] = plane.z;
            this.sagittalTextureModClipOblique[3] = plane.w;
            cutPlane.x *= -1.0;
            cutPlane.y *= -1.0;
            this.axialTextureModClipOblique[0] = cutPlane.x;
            this.axialTextureModClipOblique[1] = cutPlane.y;
            this.axialTextureModClipOblique[2] = cutPlane.z;
            this.axialTextureModClipOblique[3] = cutPlane.w;
            cutPlane.y *= -1.0;
            this.coronalTextureModClipOblique[0] = cutPlane.x;
            this.coronalTextureModClipOblique[1] = cutPlane.y;
            this.coronalTextureModClipOblique[2] = cutPlane.z;
            this.coronalTextureModClipOblique[3] = cutPlane.w;
        }
        this.viewer.updateSurfaceTextures(false);
    }

    public void updateROILine(LOIShape loi) {
        for (MarkerLine ml : this.allMarkerLines.values()) {
            LOIShape syncedLOI = ml.getSyncObject();
            if (!loi.equals(syncedLOI) || loi.getNumPoints() <= 1) continue;
            Point3d[] points = this.createPointsForMarkerLine(syncedLOI, syncedLOI.getSliceNum(), syncedLOI.getSliceDirection());
            ml.editLine(points);
            break;
        }
    }

    public void updateROILineInSliceViewer(Point3d startPoint, Point3d currentLoc, MarkerLine line) {
        if (this.isSyncingShapes()) {
            if (this.allPointsInSlicePlane(line)) {
                GeneralPath path = new GeneralPath();
                Coordinate start = this.position.convertPointToCoordinate(startPoint);
                Coordinate end = this.position.convertPointToCoordinate(currentLoc);
                LOIShape syncShape = line.getSyncObject();
                if (syncShape.getSliceDirection() == 0) {
                    path.moveTo(start.xInt, start.yInt);
                    path.lineTo(end.xInt, end.yInt);
                    syncShape.connect(new LOIShape(path.getPathIterator(null), start.zInt, syncShape.getColor(), this.viewer, this.viewer), new Point(start.xInt, start.yInt));
                } else if (syncShape.getSliceDirection() == 1) {
                    path.moveTo(start.xInt, start.zInt);
                    path.lineTo(end.xInt, end.zInt);
                    syncShape.connect(new LOIShape(path.getPathIterator(null), start.yInt, syncShape.getColor(), this.viewer, this.viewer), new Point(start.xInt, start.zInt));
                } else {
                    path.moveTo(start.yInt, start.zInt);
                    path.lineTo(end.yInt, end.zInt);
                    syncShape.connect(new LOIShape(path.getPathIterator(null), start.xInt, syncShape.getColor(), this.viewer, this.viewer), new Point(start.yInt, start.zInt));
                }
            } else {
                LOIShape syncShape = line.getSyncObject();
                line.setSyncObject(null);
                this.viewer.removeLineFromSurface(syncShape);
            }
        }
        this.getViewer().updateViewer();
    }

    public void updateROIPoint(POI poi) {
        Iterator<Marker> markerIt = this.allMarkers.values().iterator();
        Coordinate coor = new Coordinate();
        while (markerIt.hasNext()) {
            Marker marker = markerIt.next();
            POI syncedPOI = marker.getSyncObject();
            if (!poi.equals(syncedPOI)) continue;
            coor.xDbl = poi.getX();
            coor.yDbl = poi.getY();
            coor.zDbl = poi.getZ();
            Point3d point = this.position.convertCoordinateToPoint(coor);
            this.updateMarker(marker, marker.getPoint(), point, true, true);
            break;
        }
    }

    public void updateROIShape(long changedMask, int slice, int direction) {
        this.needROIUpdateMask |= changedMask;
        boolean all = Long.bitCount(this.needROIUpdateMask) > 1;
        int color = all ? -1 : BitUtilities.findHighestOneBitIndex((long)this.needROIUpdateMask);
        this.needROIUpdateMask = 0L;
        this.doUpdateROIShape(all, color, slice, direction);
    }

    @Override
    public void updateSurface() {
        if (this.canvas != null) {
            this.canvas.display();
        }
    }

    public void updateSurfaceColorAtTimepoint() {
        this.startSyncOverlays();
    }

    @Override
    public void updateSurfaceTextures() {
        this.viewer.updateSurfaceTextures(true);
    }

    public void updateTextures(BufferedImage axialTextureImg, BufferedImage coronalTextureImg, BufferedImage sagittalTextureImg) {
        this.texturesDirty = true;
        SurfaceViewer.copySrcIntoDstAt(axialTextureImg, this.textureImageAxial);
        SurfaceViewer.copySrcIntoDstAt(coronalTextureImg, this.textureImageCoronal);
        SurfaceViewer.copySrcIntoDstAt(sagittalTextureImg, this.textureImageSagittal);
    }

    public void updateTransform(double[][] xform, boolean forceUpdate) {
        boolean changed = this.position.updateImageTransform(xform);
        if (changed || forceUpdate) {
            for (CompositeSurface surface : this.surfaces) {
                if (!surface.getMaterial().isShowOverlayColors()) continue;
                this.startSyncOverlays();
            }
            this.updateModelClipTransforms();
        }
    }

    private Marker addMarker(Coordinate coor, int color, POI syncObj, boolean setFromSurface) {
        return this.addMarker(this.position.convertCoordinateToPoint(coor), color, syncObj, setFromSurface);
    }

    private Marker addMarker(Point3d point, int colorIndex, POI syncObj, boolean setFromSurface) {
        Color color = ROIColor.getColor(colorIndex);
        Coordinate coor = this.position.convertPointToCoordinate(point);
        boolean isWorld = this.viewer.getMango().getToolBox().isWorldMode();
        if (isWorld) {
            this.volData.convertIndexToWorldCoordinate(coor);
        }
        Marker marker = new Marker(this, point, this.pointCounter, color);
        marker.setFromSurface(setFromSurface);
        marker.setSyncObject(syncObj);
        if (!this.allMarkers.containsKey(this.pointCounter)) {
            this.allMarkers.put(this.pointCounter, marker);
            ++this.pointCounter;
        }
        return marker;
    }

    private void addROIPointInSliceViewer(Marker marker) {
        Coordinate current = this.position.convertPointToCoordinate(marker.getPoint(), true);
        if (this.viewer.containsIndex(current)) {
            POI poi = this.viewer.addPointFromSurface(current, this.getColorIndex(marker.getColorObj()));
            marker.setSyncObject(poi);
            this.viewer.updateViewer();
        }
    }

    private void addSurfaceFromFile(Surface[] surfaces, Vector<Shape> shapes) {
        if (surfaces != null) {
            this.loadingShapeData = shapes;
            this.surfacesToLoad = new Vector();
            for (Surface surface : surfaces) {
                this.surfacesToLoad.add(this.makeCompositeSurface(surface));
            }
        }
    }

    private boolean allPointsInSlicePlane(MarkerLine ml) {
        LOIShape syncObj = ml.getSyncObject();
        if (syncObj != null) {
            Point3d[] points;
            int dir = syncObj.getSliceDirection();
            int slice = syncObj.getSliceNum();
            for (Point3d point : points = ml.getPoints()) {
                Coordinate coor = this.position.convertPointToCoordinate(point);
                if (!(dir == 0 ? coor.zInt != slice : (dir == 1 ? coor.yInt != slice : coor.xInt != slice))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private synchronized void captureVideo() {
        this.needsVideoCapture = true;
        if (this.currentVideoFrame != null) {
            this.videoFrames.add(this.currentVideoFrame);
            if (this.videoFrames.size() >= 1200) {
                this.videoCaptureListener.videoCaptureEnded();
            }
        }
    }

    private void checkCompatibility(GL2 gl) {
        boolean shouldPrompt = !alreadyWarnedAboutUsingBetterGraphics && !this.viewer.getMango().isApplet();
        Version glVersion = this.getVersion(gl, 7938);
        Version glslVersion = this.getVersion(gl, 35724);
        boolean capableGL2 = gl.isGL2();
        boolean capableGLSL = gl.hasGLSL();
        boolean capableBetterGraphics = glVersion.isGreaterThanOrEqualTo(BETTER_GRAPHICS_VERSION_MIN) && glslVersion.isGreaterThanOrEqualTo(BETTER_GRAPHICS_SHADER_VERSION_MIN);
        this.canUseVBO = glVersion.isGreaterThanOrEqualTo(VBO_VERSION_MIN);
        this.needsShowError = !capableGL2;
        this.needsShowCapableWarning = capableGL2 && capableGLSL && capableBetterGraphics && !this.canUseShaders() && shouldPrompt;
        boolean bl = this.needsShowIncapableWarning = (!capableGL2 || !capableGLSL || !capableBetterGraphics) && this.canUseShaders() && shouldPrompt;
        if (this.needsShowError || this.needsShowCapableWarning || this.needsShowIncapableWarning) {
            this.warningTimer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SurfaceViewer.this.showWarning();
                        }
                    });
                }
            };
            this.warningTimer.schedule(task, 10000L);
        }
    }

    private void clear(GL2 gl) {
        if (this.canUseShaders()) {
            this.deleteShaders(gl, this.shaderProgram);
            this.shaderProgram = 0;
        }
        for (CompositeSurface surface : this.surfaces) {
            if (surface == null) continue;
            surface.clear(gl, this, this.canUseVBO);
            Object var3_3 = null;
        }
        if (this.warningTimer != null) {
            this.warningTimer.cancel();
            this.warningTimer = null;
        }
        this.caps = null;
        this.factory = null;
        this.position = null;
        this.textureImageAxial = null;
        this.textureImageCoronal = null;
        this.textureImageSagittal = null;
        this.axialTexture = null;
        this.coronalTexture = null;
        this.sagittalTexture = null;
        this.glu = null;
        this.canvas = null;
        this.frame.clear();
        this.frame = null;
        this.viewer.getViewerFrame().removeStickyWindow(this);
        this.viewer = null;
    }

    private void clearFactory() {
        if (this.factory != null) {
            this.factory.clear();
            this.factory = null;
        }
    }

    private Point3d createPointForMarkerLine(Point point, int slice, int direction) {
        if (direction == 0) {
            return this.position.convertCoordinateToPoint(new Coordinate((double)point.x, (double)point.y, (double)slice));
        }
        if (direction == 1) {
            return this.position.convertCoordinateToPoint(new Coordinate((double)point.x, (double)slice, (double)point.y));
        }
        return this.position.convertCoordinateToPoint(new Coordinate((double)slice, (double)point.x, (double)point.y));
    }

    private Point3d[] createPointsForMarkerLine(LOIShape shape, int slice, int direction) {
        boolean isClosed = shape.isClosed();
        Vector<Point> points = shape.getPointsCopy();
        int numPoints = (points.size() - (isClosed ? 0 : 1)) * 2;
        Point3d[] points3d = new Point3d[numPoints];
        Iterator<Point> it = points.iterator();
        int ctr3d = 0;
        Point point = it.next();
        int n = ctr3d++;
        Point3d point3d = this.createPointForMarkerLine(point, slice, direction);
        points3d[n] = point3d;
        Point3d startPoint = point3d;
        point = it.next();
        int n2 = ctr3d++;
        Point3d point3d2 = this.createPointForMarkerLine(point, slice, direction);
        points3d[n2] = point3d2;
        Point3d previousPoint = point3d2;
        while (it.hasNext()) {
            point = it.next();
            points3d[ctr3d++] = previousPoint;
            int n3 = ctr3d++;
            Point3d point3d3 = this.createPointForMarkerLine(point, slice, direction);
            points3d[n3] = point3d3;
            previousPoint = point3d3;
        }
        if (isClosed) {
            points3d[ctr3d++] = previousPoint;
            points3d[ctr3d] = startPoint;
        }
        return points3d;
    }

    private synchronized void createProgressListener() {
        if (progressBarListener == null) {
            progressBarListener = this.viewer.getMango().getToolBox();
        }
    }

    private void doRenderText(GL2 gl, String text, double xLoc, double yLoc, double zLoc, float[] color, boolean drawShadow) {
        gl.glPushMatrix();
        gl.glLoadIdentity();
        if (color != null) {
            gl.glColor4d((double)color[0], (double)color[1], (double)color[2], 1.0);
        } else if (this.viewer.getOrientationCertainty() == 2) {
            gl.glColor4d((double)this.background.getOpposite(this.background.getRed()), (double)this.background.getOpposite(this.background.getGreen()), (double)this.background.getOpposite(this.background.getBlue()), 1.0);
        } else if (this.viewer.getOrientationCertainty() == 1) {
            gl.glColor4d((double)Background.LOW_ORIENTATION_CERTAINTY_BACKGROUND.get(0).floatValue(), (double)Background.LOW_ORIENTATION_CERTAINTY_BACKGROUND.get(1).floatValue(), (double)Background.LOW_ORIENTATION_CERTAINTY_BACKGROUND.get(2).floatValue(), 1.0);
        } else {
            gl.glColor4d((double)Background.UNKNOWN_ORIENTATION_CERTAINTY_BACKGROUND.get(0).floatValue(), (double)Background.UNKNOWN_ORIENTATION_CERTAINTY_BACKGROUND.get(1).floatValue(), (double)Background.UNKNOWN_ORIENTATION_CERTAINTY_BACKGROUND.get(2).floatValue(), 1.0);
        }
        double[] coord = this.position.applyModelTransform(xLoc, yLoc, zLoc);
        Rectangle2D bounds = ((TextRenderer)this.textRenderer).getBounds(text);
        double alignOffset = (double)-0.2f * this.scaleFactor * bounds.getWidth() / 2.0;
        double heightOffset = (double)-0.2f * this.scaleFactor * bounds.getHeight() / 2.0;
        ((TextRenderer)this.textRenderer).draw3D(text, (float)(alignOffset + coord[0]) - (drawShadow ? 0.75f : 0.0f), (float)(heightOffset + coord[1]) - (drawShadow ? 0.75f : 0.0f), (float)coord[2] - (float)(drawShadow ? 1 : 0), (float)((double)0.2f * this.scaleFactor));
        gl.glDisableClientState(32884);
        ((TextRenderer)this.textRenderer).flush();
        gl.glPopMatrix();
    }

    private void doSyncOverlays(CompositeSurface surface) {
        if (this.syncingOverlays) {
            return;
        }
        this.syncingOverlays = true;
        if (this.viewer != null && !this.viewer.isClosing()) {
            ScreenVolume[] overlays;
            for (ScreenVolume sv : overlays = this.viewer.getOverlayManager().getAllOverlays()) {
                if (sv == null || surface.getMaterial().isShowOnlyThisOverlayColors() && surface.getAssociatedOvelray() != sv.getVolume()) continue;
                sv.addOverlayListener(this);
                SurfaceOverlay overlay = surface.getOverlay(sv);
                if (overlay == null) {
                    overlay = surface.addOverlay(sv);
                }
                SurfaceScalarsBuilder scalarsBuilder = new SurfaceScalarsBuilder(this.viewer, this.position, surface, this.viewer.getBaseVolume(), overlay);
                scalarsBuilder.buildScalars(this, surface.getMaterial().getDistance(), SurfaceScalarsBuilder.getStepSizeDefault(this));
            }
        }
        this.syncingOverlays = false;
        this.syncOverlaysTimer = null;
    }

    private void drawAxialTexture(GL2 gl, boolean flipCullFace, boolean clip) {
        if (clip) {
            gl.glEnable(2884);
        }
        if (flipCullFace) {
            gl.glCullFace(1029);
        } else {
            gl.glCullFace(1028);
        }
        gl.glPolygonMode(1028, 6914);
        if (this.texturesDirty) {
            TextureData td = AWTTextureIO.newTextureData((GLProfile)gl.getGLProfile(), (BufferedImage)this.textureImageAxial, (boolean)false);
            if (this.axialTexture != null) {
                this.axialTexture.updateImage((GL)gl, td);
            } else {
                this.axialTexture = TextureIO.newTexture((TextureData)td);
            }
        }
        if (this.axialTexture != null) {
            if (this.preferences.isUsingCoronalCutPlane()) {
                if (this.isObliqueCoronal()) {
                    gl.glClipPlane(12292, this.coronalTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12292, this.coronalTextureModClip, 0);
                }
                gl.glEnable(12292);
            }
            if (this.preferences.isUsingSagittalCutPlane()) {
                if (this.isObliqueSagittal()) {
                    gl.glClipPlane(12293, this.sagittalTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12293, this.sagittalTextureModClip, 0);
                }
                gl.glEnable(12293);
            }
            gl.glEnableClientState(32888);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3008);
            gl.glAlphaFunc(516, 0.0f);
            this.axialTexture.enable((GL)gl);
            this.axialTexture.bind((GL)gl);
            if (Mango.isVoxelDisplay()) {
                this.axialTexture.setTexParameteri((GL)gl, 10240, 9728);
                this.axialTexture.setTexParameteri((GL)gl, 10241, 9728);
            } else {
                this.axialTexture.setTexParameteri((GL)gl, 10240, 9729);
                this.axialTexture.setTexParameteri((GL)gl, 10241, 9729);
            }
            if (this.preferences.isShowSlices()) {
                gl.glTexEnvi(8960, 8704, 7681);
                gl.glBegin(7);
                gl.glTexCoord2d(this.axialTextureCoors[0], this.axialTextureCoors[1]);
                gl.glVertex3d(this.activePlaneVertsAxialTexture[0], this.activePlaneVertsAxialTexture[1], this.activePlaneVertsAxialTexture[2]);
                gl.glTexCoord2d(this.axialTextureCoors[2], this.axialTextureCoors[3]);
                gl.glVertex3d(this.activePlaneVertsAxialTexture[3], this.activePlaneVertsAxialTexture[4], this.activePlaneVertsAxialTexture[5]);
                gl.glTexCoord2d(this.axialTextureCoors[4], this.axialTextureCoors[5]);
                gl.glVertex3d(this.activePlaneVertsAxialTexture[6], this.activePlaneVertsAxialTexture[7], this.activePlaneVertsAxialTexture[8]);
                gl.glTexCoord2d(this.axialTextureCoors[6], this.axialTextureCoors[7]);
                gl.glVertex3d(this.activePlaneVertsAxialTexture[9], this.activePlaneVertsAxialTexture[10], this.activePlaneVertsAxialTexture[11]);
                gl.glEnd();
            }
            this.axialTexture.disable((GL)gl);
            gl.glDisableClientState(32888);
            gl.glDisable(3042);
            gl.glDisable(3008);
            gl.glDisable(12291);
            gl.glDisable(12292);
            gl.glDisable(12293);
        }
        gl.glDisable(2884);
    }

    private void drawCoronalTexture(GL2 gl, boolean flipCullFace, boolean clip) {
        if (clip) {
            gl.glEnable(2884);
        }
        if (flipCullFace) {
            gl.glCullFace(1029);
        } else {
            gl.glCullFace(1028);
        }
        gl.glPolygonMode(1028, 6914);
        if (this.texturesDirty) {
            TextureData td = AWTTextureIO.newTextureData((GLProfile)gl.getGLProfile(), (BufferedImage)this.textureImageCoronal, (boolean)false);
            if (this.coronalTexture != null) {
                this.coronalTexture.updateImage((GL)gl, td);
            } else {
                this.coronalTexture = TextureIO.newTexture((TextureData)td);
            }
        }
        if (this.coronalTexture != null) {
            if (this.preferences.isUsingAxialCutPlane()) {
                if (this.isObliqueAxial()) {
                    gl.glClipPlane(12291, this.axialTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12291, this.axialTextureModClip, 0);
                }
                gl.glEnable(12291);
            }
            if (this.preferences.isUsingSagittalCutPlane()) {
                if (this.isObliqueSagittal()) {
                    gl.glClipPlane(12293, this.sagittalTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12293, this.sagittalTextureModClip, 0);
                }
                gl.glEnable(12293);
            }
            gl.glEnableClientState(32888);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3008);
            gl.glAlphaFunc(516, 0.5f);
            this.coronalTexture.enable((GL)gl);
            this.coronalTexture.bind((GL)gl);
            if (Mango.isVoxelDisplay()) {
                this.coronalTexture.setTexParameteri((GL)gl, 10240, 9728);
                this.coronalTexture.setTexParameteri((GL)gl, 10241, 9728);
            } else {
                this.coronalTexture.setTexParameteri((GL)gl, 10240, 9729);
                this.coronalTexture.setTexParameteri((GL)gl, 10241, 9729);
            }
            if (this.preferences.isShowSlices()) {
                gl.glTexEnvi(8960, 8704, 7681);
                gl.glBegin(7);
                gl.glTexCoord2d(this.coronalTextureCoors[0], this.coronalTextureCoors[1]);
                gl.glVertex3d(this.activePlaneVertsCoronalTexture[0], this.activePlaneVertsCoronalTexture[1], this.activePlaneVertsCoronalTexture[2]);
                gl.glTexCoord2d(this.coronalTextureCoors[2], this.coronalTextureCoors[3]);
                gl.glVertex3d(this.activePlaneVertsCoronalTexture[3], this.activePlaneVertsCoronalTexture[4], this.activePlaneVertsCoronalTexture[5]);
                gl.glTexCoord2d(this.coronalTextureCoors[4], this.coronalTextureCoors[5]);
                gl.glVertex3d(this.activePlaneVertsCoronalTexture[6], this.activePlaneVertsCoronalTexture[7], this.activePlaneVertsCoronalTexture[8]);
                gl.glTexCoord2d(this.coronalTextureCoors[6], this.coronalTextureCoors[7]);
                gl.glVertex3d(this.activePlaneVertsCoronalTexture[9], this.activePlaneVertsCoronalTexture[10], this.activePlaneVertsCoronalTexture[11]);
                gl.glEnd();
            }
            this.coronalTexture.disable((GL)gl);
            gl.glDisableClientState(32888);
            gl.glDisable(3042);
            gl.glDisable(3008);
            gl.glDisable(12291);
            gl.glDisable(12292);
            gl.glDisable(12293);
        }
        gl.glDisable(2884);
    }

    private void drawSagittalTexture(GL2 gl, boolean flipCullFace, boolean clip) {
        if (clip) {
            gl.glEnable(2884);
        }
        if (flipCullFace) {
            gl.glCullFace(1029);
        } else {
            gl.glCullFace(1028);
        }
        gl.glPolygonMode(1028, 6914);
        if (this.texturesDirty) {
            TextureData td = AWTTextureIO.newTextureData((GLProfile)gl.getGLProfile(), (BufferedImage)this.textureImageSagittal, (boolean)false);
            if (this.sagittalTexture != null) {
                this.sagittalTexture.updateImage((GL)gl, td);
            } else {
                this.sagittalTexture = TextureIO.newTexture((TextureData)td);
            }
        }
        if (this.sagittalTexture != null) {
            if (this.preferences.isUsingAxialCutPlane()) {
                if (this.isObliqueAxial()) {
                    gl.glClipPlane(12291, this.axialTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12291, this.axialTextureModClip, 0);
                }
                gl.glEnable(12291);
            }
            if (this.preferences.isUsingCoronalCutPlane()) {
                if (this.isObliqueCoronal()) {
                    gl.glClipPlane(12292, this.coronalTextureModClipOblique, 0);
                } else {
                    gl.glClipPlane(12292, this.coronalTextureModClip, 0);
                }
                gl.glEnable(12292);
            }
            gl.glEnableClientState(32888);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3008);
            gl.glAlphaFunc(516, 0.0f);
            this.sagittalTexture.enable((GL)gl);
            this.sagittalTexture.bind((GL)gl);
            if (Mango.isVoxelDisplay()) {
                this.sagittalTexture.setTexParameteri((GL)gl, 10240, 9728);
                this.sagittalTexture.setTexParameteri((GL)gl, 10241, 9728);
            } else {
                this.sagittalTexture.setTexParameteri((GL)gl, 10240, 9729);
                this.sagittalTexture.setTexParameteri((GL)gl, 10241, 9729);
            }
            if (this.preferences.isShowSlices()) {
                gl.glTexEnvi(8960, 8704, 7681);
                gl.glBegin(7);
                gl.glTexCoord2d(this.sagittalTextureCoors[0], this.sagittalTextureCoors[1]);
                gl.glVertex3d(this.activePlaneVertsSagittalTexture[0], this.activePlaneVertsSagittalTexture[1], this.activePlaneVertsSagittalTexture[2]);
                gl.glTexCoord2d(this.sagittalTextureCoors[2], this.sagittalTextureCoors[3]);
                gl.glVertex3d(this.activePlaneVertsSagittalTexture[3], this.activePlaneVertsSagittalTexture[4], this.activePlaneVertsSagittalTexture[5]);
                gl.glTexCoord2d(this.sagittalTextureCoors[4], this.sagittalTextureCoors[5]);
                gl.glVertex3d(this.activePlaneVertsSagittalTexture[6], this.activePlaneVertsSagittalTexture[7], this.activePlaneVertsSagittalTexture[8]);
                gl.glTexCoord2d(this.sagittalTextureCoors[6], this.sagittalTextureCoors[7]);
                gl.glVertex3d(this.activePlaneVertsSagittalTexture[9], this.activePlaneVertsSagittalTexture[10], this.activePlaneVertsSagittalTexture[11]);
                gl.glEnd();
            }
            this.sagittalTexture.disable((GL)gl);
            gl.glDisableClientState(32888);
            gl.glDisable(3042);
            gl.glDisable(3008);
            gl.glDisable(12291);
            gl.glDisable(12292);
            gl.glDisable(12293);
        }
        gl.glDisable(2884);
    }

    private CompositeSurface findSurface(String name) {
        Iterator<CompositeSurface> it = this.surfaces.iterator();
        it.next();
        while (it.hasNext()) {
            CompositeSurface surface = it.next();
            if (!surface.getName().startsWith(name)) continue;
            return surface;
        }
        return null;
    }

    private int getDynamicMode(MouseEvent me) {
        if (me.isAltDown()) {
            if (me.isShiftDown()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private Version getVersion(GL2 gl, int code) {
        String versionStr = gl.glGetString(code);
        if (versionStr != null) {
            int firstDotIndex = (versionStr = versionStr.trim()).indexOf(46);
            if (firstDotIndex != -1) {
                int secondDotIndex = versionStr.indexOf(".", firstDotIndex + 1);
                int firstSpaceIndex = versionStr.indexOf(" ", firstDotIndex + 1);
                int secondIndex = -1;
                if (secondDotIndex != -1 && firstSpaceIndex != -1) {
                    secondIndex = Math.min(secondDotIndex, firstSpaceIndex);
                } else if (secondDotIndex != -1) {
                    secondIndex = secondDotIndex;
                } else if (firstSpaceIndex != -1) {
                    secondIndex = firstSpaceIndex;
                }
                if (secondIndex != -1) {
                    versionStr = versionStr.substring(0, secondIndex);
                }
            }
            if (!versionStr.matches("[0-9.]+")) {
                if (versionStr.length() > 2) {
                    versionStr = versionStr.substring(0, 3);
                } else if (versionStr.length() > 0) {
                    versionStr = versionStr.substring(0, 1);
                }
            }
        }
        return new Version(versionStr);
    }

    private void loadNext() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SurfaceViewer.this.surfacesToLoad != null) {
                    CompositeSurface surface = (CompositeSurface)SurfaceViewer.this.surfacesToLoad.remove(0);
                    if (SurfaceViewer.this.surfacesToLoad.size() == 0) {
                        SurfaceViewer.this.surfacesToLoad = null;
                    }
                    SurfaceViewer.this.addShape(surface);
                }
            }
        });
    }

    private void loadShapeData() {
        final Vector<Shape> shapes = this.loadingShapeData;
        this.loadingShapeData = null;
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                SurfaceViewer.this.removeAllMarkers();
                SurfaceViewer.this.removeAllMarkerLines();
                if (shapes != null) {
                    for (Shape shape : shapes) {
                        ShapeData shapeData = null;
                        shapeData = shape instanceof ShapeData ? (ShapeData)shape : new ShapeData(shape.getPoints(), shape.getColor());
                        if (shapeData.getPoints().length == 1) {
                            Marker marker = SurfaceViewer.this.addMarker(shapeData.getPoints()[0], 0, null, shapeData.isOnSurface());
                            marker.setColorComponents(shapeData.getColor());
                            if (marker.isFromSurface()) {
                                if ("BASESURFACE".equals(shapeData.getSurfaceName())) {
                                    marker.setSurfaceShape(SurfaceViewer.this.baseSurface);
                                } else {
                                    CompositeSurface surface = SurfaceViewer.this.findSurface(shapeData.getSurfaceName());
                                    if (surface != null) {
                                        marker.setSurfaceShape(surface);
                                    } else {
                                        marker.setFromSurface(false);
                                    }
                                }
                            }
                            SurfaceViewer.this.addROIPointInSliceViewer(marker);
                            continue;
                        }
                        MarkerLine line = SurfaceViewer.this.addMarkerLine(shapeData.getPoints(), 0, null);
                        line.setColorComponents(shapeData.getColor());
                        if (!shapeData.isOnSurface()) continue;
                        Point3d[] points = line.getPoints();
                        float[] comps = shapeData.getColor();
                        Color color = new Color(comps[0], comps[1], comps[2]);
                        Marker cutPlanePoint = new Marker(SurfaceViewer.this, points[points.length / 2], color);
                        line.setCutPlanePoint(cutPlanePoint);
                        SurfaceViewer.this.addROILineInSliceViewer(line);
                    }
                    SurfaceViewer.this.updateSurface();
                }
            }
        });
    }

    private CompositeSurface makeCompositeSurface(Surface surface) {
        CompositeSurface cs = null;
        if (surface instanceof CompositeSurface) {
            cs = (CompositeSurface)surface;
        } else if (surface instanceof SurfaceData) {
            cs = new CompositeSurface((SurfaceData)surface);
        }
        return cs;
    }

    private void makeFrame() {
        int size = this.viewer.isOrthoWide() ? this.viewer.getViewerSize().height : this.viewer.getViewerSize().width;
        Dimension startDim = new Dimension(size, size);
        Point loc = DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), startDim, this.viewer.getMango().getAllViewerAndToolboxArea(), this.viewer.getMango().isApplet());
        this.frame = new SurfaceFrame(this, loc, startDim, this.viewer.getNiceImageTitle());
        if (!this.viewer.getMango().isApplet()) {
            Mango.getInstance().updateAllFunctionHotKeys();
        }
        this.viewer.associateWindow(this.frame);
    }

    private void makeTextureImages() {
        this.textureXdim = this.xDim <= 2 ? 2 : (this.xDim <= 4 ? 4 : (this.xDim <= 8 ? 8 : (this.xDim <= 16 ? 16 : (this.xDim <= 32 ? 32 : (this.xDim <= 64 ? 64 : (this.xDim <= 128 ? 128 : (this.xDim <= 256 ? 256 : (this.xDim <= 512 ? 512 : (this.xDim <= 1024 ? 1024 : this.xDim)))))))));
        this.textureYdim = this.yDim <= 2 ? 2 : (this.yDim <= 4 ? 4 : (this.yDim <= 8 ? 8 : (this.yDim <= 16 ? 16 : (this.yDim <= 32 ? 32 : (this.yDim <= 64 ? 64 : (this.yDim <= 128 ? 128 : (this.yDim <= 256 ? 256 : (this.yDim <= 512 ? 512 : (this.yDim <= 1024 ? 1024 : this.yDim)))))))));
        this.textureZdim = this.zDim <= 2 ? 2 : (this.zDim <= 4 ? 4 : (this.zDim <= 8 ? 8 : (this.zDim <= 16 ? 16 : (this.zDim <= 32 ? 32 : (this.zDim <= 64 ? 64 : (this.zDim <= 128 ? 128 : (this.zDim <= 256 ? 256 : (this.zDim <= 512 ? 512 : (this.zDim <= 1024 ? 1024 : this.zDim)))))))));
        this.textureImageAxial = new BufferedImage(this.textureXdim, this.textureYdim, 2);
        this.textureImageCoronal = new BufferedImage(this.textureXdim, this.textureZdim, 2);
        this.textureImageSagittal = new BufferedImage(this.textureYdim, this.textureZdim, 2);
        this.viewer.setSurfaceTextureImage(this.textureImageAxial, this.textureImageCoronal, this.textureImageSagittal);
        this.axialTextureCoors = new double[8];
        this.axialTextureCoors[0] = 0.0;
        this.axialTextureCoors[1] = 0.0;
        this.axialTextureCoors[2] = (double)(this.xDim - 1) / (double)this.textureXdim;
        this.axialTextureCoors[3] = 0.0;
        this.axialTextureCoors[4] = (double)(this.xDim - 1) / (double)this.textureXdim;
        this.axialTextureCoors[5] = (double)(this.yDim - 1) / (double)this.textureYdim;
        this.axialTextureCoors[6] = 0.0;
        this.axialTextureCoors[7] = (double)(this.yDim - 1) / (double)this.textureYdim;
        this.coronalTextureCoors = new double[8];
        this.coronalTextureCoors[0] = 0.0;
        this.coronalTextureCoors[1] = 0.0;
        this.coronalTextureCoors[2] = (double)(this.xDim - 1) / (double)this.textureXdim;
        this.coronalTextureCoors[3] = 0.0;
        this.coronalTextureCoors[4] = (double)(this.xDim - 1) / (double)this.textureXdim;
        this.coronalTextureCoors[5] = (double)(this.zDim - 1) / (double)this.textureZdim;
        this.coronalTextureCoors[6] = 0.0;
        this.coronalTextureCoors[7] = (double)(this.zDim - 1) / (double)this.textureZdim;
        this.sagittalTextureCoors = new double[8];
        this.sagittalTextureCoors[2] = 0.0;
        this.sagittalTextureCoors[3] = 0.0;
        this.sagittalTextureCoors[4] = (double)(this.yDim - 1) / (double)this.textureYdim;
        this.sagittalTextureCoors[5] = 0.0;
        this.sagittalTextureCoors[6] = (double)(this.yDim - 1) / (double)this.textureYdim;
        this.sagittalTextureCoors[7] = (double)(this.zDim - 1) / (double)this.textureZdim;
        this.sagittalTextureCoors[0] = 0.0;
        this.sagittalTextureCoors[1] = (double)(this.zDim - 1) / (double)this.textureZdim;
    }

    private void pick(PickableSurface selectedShape) {
        if (this.position.isPickDirty()) {
            Coordinate current;
            boolean validSurface = false;
            Vector3d p3p1Vec = new Vector3d();
            Vector3d p3p2Vec = new Vector3d();
            Vector3d crossVec = new Vector3d();
            if (!validSurface && this.preferences.isUsingCutPlane() && this.baseSurface.getMaterial().isOpaque()) {
                Point3d surfacePoint;
                Vector3d pointToPlane;
                boolean isClipped;
                if (this.preferences.isUsingAxialCutPlane()) {
                    isClipped = false;
                    Point3d axialP1 = new Point3d();
                    Point3d axialP2 = new Point3d();
                    Point3d axialP3 = new Point3d();
                    axialP1.set(this.activePlaneVertsAxial[0], this.activePlaneVertsAxial[1], this.activePlaneVertsAxial[2]);
                    axialP2.set(this.activePlaneVertsAxial[3], this.activePlaneVertsAxial[4], this.activePlaneVertsAxial[5]);
                    axialP3.set(this.activePlaneVertsAxial[6], this.activePlaneVertsAxial[7], this.activePlaneVertsAxial[8]);
                    p3p1Vec.set(axialP3.x - axialP1.x, axialP3.y - axialP1.y, axialP3.z - axialP1.z);
                    p3p2Vec.set(axialP3.x - axialP2.x, axialP3.y - axialP2.y, axialP3.z - axialP2.z);
                    crossVec.cross(p3p1Vec, p3p2Vec);
                    crossVec.normalize();
                    if (selectedShape == this.baseSurface) {
                        pointToPlane = p3p1Vec;
                        surfacePoint = selectedShape.getPickedSurfaceCoordinate();
                        pointToPlane.set(surfacePoint.x - axialP1.x, surfacePoint.y - axialP1.y, surfacePoint.z - axialP1.z);
                        if ((this.position.getLastPickedOctant() & 4) != 0) {
                            isClipped = pointToPlane.dot(crossVec) < this.averageSize;
                        } else {
                            boolean bl = isClipped = pointToPlane.dot(crossVec) > -this.averageSize;
                        }
                    }
                    if (!isClipped) {
                        validSurface = true;
                    }
                }
                if (!validSurface && this.preferences.isUsingCoronalCutPlane()) {
                    isClipped = false;
                    Point3d coronalP1 = new Point3d();
                    Point3d coronalP2 = new Point3d();
                    Point3d coronalP3 = new Point3d();
                    coronalP1.set(this.activePlaneVertsCoronal[0], this.activePlaneVertsCoronal[1], this.activePlaneVertsCoronal[2]);
                    coronalP2.set(this.activePlaneVertsCoronal[3], this.activePlaneVertsCoronal[4], this.activePlaneVertsCoronal[5]);
                    coronalP3.set(this.activePlaneVertsCoronal[6], this.activePlaneVertsCoronal[7], this.activePlaneVertsCoronal[8]);
                    p3p1Vec.set(coronalP3.x - coronalP1.x, coronalP3.y - coronalP1.y, coronalP3.z - coronalP1.z);
                    p3p2Vec.set(coronalP3.x - coronalP2.x, coronalP3.y - coronalP2.y, coronalP3.z - coronalP2.z);
                    crossVec.cross(p3p1Vec, p3p2Vec);
                    crossVec.normalize();
                    if (selectedShape == this.baseSurface) {
                        pointToPlane = p3p1Vec;
                        surfacePoint = selectedShape.getPickedSurfaceCoordinate();
                        pointToPlane.set(surfacePoint.x - coronalP1.x, surfacePoint.y - coronalP1.y, surfacePoint.z - coronalP1.z);
                        if ((this.position.getLastPickedOctant() & 2) != 0) {
                            isClipped = pointToPlane.dot(crossVec) < this.averageSize;
                        } else {
                            boolean bl = isClipped = pointToPlane.dot(crossVec) > -this.averageSize;
                        }
                    }
                    if (!isClipped) {
                        validSurface = true;
                    }
                }
                if (!validSurface && this.preferences.isUsingSagittalCutPlane()) {
                    isClipped = false;
                    Point3d sagittalP1 = new Point3d();
                    Point3d sagittalP2 = new Point3d();
                    Point3d sagittalP3 = new Point3d();
                    sagittalP1.set(this.activePlaneVertsSagittal[0], this.activePlaneVertsSagittal[1], this.activePlaneVertsSagittal[2]);
                    sagittalP2.set(this.activePlaneVertsSagittal[3], this.activePlaneVertsSagittal[4], this.activePlaneVertsSagittal[5]);
                    sagittalP3.set(this.activePlaneVertsSagittal[6], this.activePlaneVertsSagittal[7], this.activePlaneVertsSagittal[8]);
                    p3p1Vec.set(sagittalP3.x - sagittalP1.x, sagittalP3.y - sagittalP1.y, sagittalP3.z - sagittalP1.z);
                    p3p2Vec.set(sagittalP3.x - sagittalP2.x, sagittalP3.y - sagittalP2.y, sagittalP3.z - sagittalP2.z);
                    crossVec.cross(p3p1Vec, p3p2Vec);
                    crossVec.normalize();
                    if (selectedShape == this.baseSurface) {
                        pointToPlane = p3p1Vec;
                        surfacePoint = selectedShape.getPickedSurfaceCoordinate();
                        pointToPlane.set(surfacePoint.x - sagittalP1.x, surfacePoint.y - sagittalP1.y, surfacePoint.z - sagittalP1.z);
                        if ((this.position.getLastPickedOctant() & 1) != 0) {
                            isClipped = pointToPlane.dot(crossVec) < this.averageSize;
                        } else {
                            boolean bl = isClipped = pointToPlane.dot(crossVec) > -this.averageSize;
                        }
                    }
                    if (!isClipped) {
                        validSurface = true;
                    }
                }
            } else {
                validSurface = true;
            }
            if (this.grabbedMarker != null) {
                if (selectedShape instanceof CompositeSurface) {
                    this.grabbedMarker.setSurfaceShape(selectedShape);
                    this.updateMarker(this.grabbedMarker, this.grabbedMarker.getPoint(), this.position.convertCoordinateToPoint(selectedShape.getPickedImageCoordinate()), true, true);
                }
            } else if (this.markerMode) {
                if (this.mouseDoubleClicked) {
                    if (selectedShape instanceof Marker) {
                        this.grabbedMarker = (Marker)selectedShape;
                    } else {
                        Marker marker = this.addMarker(selectedShape.getPickedImageCoordinate(), this.viewer.getRoiColor(), null, validSurface);
                        marker.setFromSurface(validSurface);
                        marker.setSurfaceShape(selectedShape);
                        this.addROIPointInSliceViewer(marker);
                    }
                    this.mouseDoubleClicked = false;
                }
            } else if (this.mouseDoubleClicked) {
                boolean pickedOctantChanged = false;
                if (!this.zoomMode) {
                    current = selectedShape.getPickedImageCoordinate();
                    this.viewer.setCurrentIndex(current);
                    this.viewer.updateSync();
                }
                this.mouseDoubleClicked = false;
            } else {
                Coordinate imageOrigin = this.viewer.getOrigin();
                current = selectedShape.getPickedImageCoordinate();
                if (imageOrigin != null && this.viewer.getMango().getToolBox().getCoordinateType() != 0) {
                    current.setValues((double)(current.xInt - imageOrigin.xInt) * this.xSize, (double)(imageOrigin.yInt - current.yInt) * this.ySize, (double)(imageOrigin.zInt - current.zInt) * this.zSize);
                }
                String[] currentLabels = null;
                currentLabels = this.viewer.getMango().getToolBox().getCurrentAtlas() != null ? this.viewer.getMango().getToolBox().getCurrentAtlas().getLabel(current.xDbl, current.yDbl, current.zDbl) : null;
                this.viewer.getMango().getToolBox().formatAtlasLabels(currentLabels);
                this.viewer.getMango().getToolBox().formatLabels(current.xDbl, current.yDbl, current.zDbl);
            }
            this.position.setPickDirty(false);
            this.updateSurface();
        }
    }

    private void redrawSurfaceLine(Marker start, Marker end, Marker third, int replacingLine) {
        PickableSurface sse;
        if (start == null || end == null) {
            return;
        }
        int color = this.getColorIndex(start.getColorObj());
        CompositeSurface surface = null;
        PickableSurface sss = start.getSurfaceShape();
        if (sss == (sse = end.getSurfaceShape())) {
            Point3d[] surfaceLinePointsArray;
            surface = sss == null ? this.getBaseSurface() : (CompositeSurface)sss;
            Point3d thirdPoint = null;
            if (third != null) {
                thirdPoint = third.getPoint();
            }
            if ((surfaceLinePointsArray = SurfaceUtils.findSurfaceLine(this, surface, start.getPoint(), end.getPoint(), thirdPoint)) != null) {
                MarkerLine ml = null;
                ml = replacingLine != -1 ? this.replaceMarkerLine(replacingLine, color, surfaceLinePointsArray, null) : this.addMarkerLine(surfaceLinePointsArray, color, null);
                Point3d[] points = ml.getPoints();
                Marker cutPlanePoint = new Marker(this, points[points.length / 2], ROIColor.getColor(color));
                ml.setCutPlanePoint(cutPlanePoint);
                cutPlanePoint.setSurfaceLine(ml);
            }
        } else {
            this.showErrorDialog("Points are not on the same surface! ", "Surface Line Error");
        }
    }

    private void renderActivePlanes(GL2 gl, int showActivePlanes) {
        gl.glDepthMask(false);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        if (showActivePlanes == 2 || this.mainDirection == 0) {
            gl.glColor4f(SurfaceViewer.CROSSHAIR_COLOR.x, SurfaceViewer.CROSSHAIR_COLOR.y, SurfaceViewer.CROSSHAIR_COLOR.z, 0.25f);
            gl.glBegin(7);
            gl.glVertex3d(this.activePlaneVertsAxial[0], this.activePlaneVertsAxial[1], this.activePlaneVertsAxial[2]);
            gl.glVertex3d(this.activePlaneVertsAxial[3], this.activePlaneVertsAxial[4], this.activePlaneVertsAxial[5]);
            gl.glVertex3d(this.activePlaneVertsAxial[6], this.activePlaneVertsAxial[7], this.activePlaneVertsAxial[8]);
            gl.glVertex3d(this.activePlaneVertsAxial[9], this.activePlaneVertsAxial[10], this.activePlaneVertsAxial[11]);
            gl.glEnd();
            gl.glColor3f(0.85f, 0.85f, 0.85f);
            gl.glLineWidth(2.0f);
            gl.glBegin(1);
            gl.glVertex3d(this.activePlaneVertsAxial[0], this.activePlaneVertsAxial[1], this.activePlaneVertsAxial[2]);
            gl.glVertex3d(this.activePlaneVertsAxial[3], this.activePlaneVertsAxial[4], this.activePlaneVertsAxial[5]);
            gl.glVertex3d(this.activePlaneVertsAxial[3], this.activePlaneVertsAxial[4], this.activePlaneVertsAxial[5]);
            gl.glVertex3d(this.activePlaneVertsAxial[6], this.activePlaneVertsAxial[7], this.activePlaneVertsAxial[8]);
            gl.glVertex3d(this.activePlaneVertsAxial[6], this.activePlaneVertsAxial[7], this.activePlaneVertsAxial[8]);
            gl.glVertex3d(this.activePlaneVertsAxial[9], this.activePlaneVertsAxial[10], this.activePlaneVertsAxial[11]);
            gl.glVertex3d(this.activePlaneVertsAxial[9], this.activePlaneVertsAxial[10], this.activePlaneVertsAxial[11]);
            gl.glVertex3d(this.activePlaneVertsAxial[0], this.activePlaneVertsAxial[1], this.activePlaneVertsAxial[2]);
            gl.glEnd();
        }
        if (showActivePlanes == 2 || this.mainDirection == 1) {
            gl.glColor4f(SurfaceViewer.CROSSHAIR_COLOR.x, SurfaceViewer.CROSSHAIR_COLOR.y, SurfaceViewer.CROSSHAIR_COLOR.z, 0.25f);
            gl.glBegin(7);
            gl.glVertex3d(this.activePlaneVertsCoronal[0], this.activePlaneVertsCoronal[1], this.activePlaneVertsCoronal[2]);
            gl.glVertex3d(this.activePlaneVertsCoronal[3], this.activePlaneVertsCoronal[4], this.activePlaneVertsCoronal[5]);
            gl.glVertex3d(this.activePlaneVertsCoronal[6], this.activePlaneVertsCoronal[7], this.activePlaneVertsCoronal[8]);
            gl.glVertex3d(this.activePlaneVertsCoronal[9], this.activePlaneVertsCoronal[10], this.activePlaneVertsCoronal[11]);
            gl.glEnd();
            gl.glColor3f(0.85f, 0.85f, 0.85f);
            gl.glLineWidth(2.0f);
            gl.glBegin(1);
            gl.glVertex3d(this.activePlaneVertsCoronal[0], this.activePlaneVertsCoronal[1], this.activePlaneVertsCoronal[2]);
            gl.glVertex3d(this.activePlaneVertsCoronal[3], this.activePlaneVertsCoronal[4], this.activePlaneVertsCoronal[5]);
            gl.glVertex3d(this.activePlaneVertsCoronal[3], this.activePlaneVertsCoronal[4], this.activePlaneVertsCoronal[5]);
            gl.glVertex3d(this.activePlaneVertsCoronal[6], this.activePlaneVertsCoronal[7], this.activePlaneVertsCoronal[8]);
            gl.glVertex3d(this.activePlaneVertsCoronal[6], this.activePlaneVertsCoronal[7], this.activePlaneVertsCoronal[8]);
            gl.glVertex3d(this.activePlaneVertsCoronal[9], this.activePlaneVertsCoronal[10], this.activePlaneVertsCoronal[11]);
            gl.glVertex3d(this.activePlaneVertsCoronal[9], this.activePlaneVertsCoronal[10], this.activePlaneVertsCoronal[11]);
            gl.glVertex3d(this.activePlaneVertsCoronal[0], this.activePlaneVertsCoronal[1], this.activePlaneVertsCoronal[2]);
            gl.glEnd();
        }
        if (showActivePlanes == 2 || this.mainDirection == 2) {
            gl.glColor4f(SurfaceViewer.CROSSHAIR_COLOR.x, SurfaceViewer.CROSSHAIR_COLOR.y, SurfaceViewer.CROSSHAIR_COLOR.z, 0.25f);
            gl.glBegin(7);
            gl.glVertex3d(this.activePlaneVertsSagittal[0], this.activePlaneVertsSagittal[1], this.activePlaneVertsSagittal[2]);
            gl.glVertex3d(this.activePlaneVertsSagittal[3], this.activePlaneVertsSagittal[4], this.activePlaneVertsSagittal[5]);
            gl.glVertex3d(this.activePlaneVertsSagittal[6], this.activePlaneVertsSagittal[7], this.activePlaneVertsSagittal[8]);
            gl.glVertex3d(this.activePlaneVertsSagittal[9], this.activePlaneVertsSagittal[10], this.activePlaneVertsSagittal[11]);
            gl.glEnd();
            gl.glColor3f(0.85f, 0.85f, 0.85f);
            gl.glLineWidth(2.0f);
            gl.glBegin(1);
            gl.glVertex3d(this.activePlaneVertsSagittal[0], this.activePlaneVertsSagittal[1], this.activePlaneVertsSagittal[2]);
            gl.glVertex3d(this.activePlaneVertsSagittal[3], this.activePlaneVertsSagittal[4], this.activePlaneVertsSagittal[5]);
            gl.glVertex3d(this.activePlaneVertsSagittal[3], this.activePlaneVertsSagittal[4], this.activePlaneVertsSagittal[5]);
            gl.glVertex3d(this.activePlaneVertsSagittal[6], this.activePlaneVertsSagittal[7], this.activePlaneVertsSagittal[8]);
            gl.glVertex3d(this.activePlaneVertsSagittal[6], this.activePlaneVertsSagittal[7], this.activePlaneVertsSagittal[8]);
            gl.glVertex3d(this.activePlaneVertsSagittal[9], this.activePlaneVertsSagittal[10], this.activePlaneVertsSagittal[11]);
            gl.glVertex3d(this.activePlaneVertsSagittal[9], this.activePlaneVertsSagittal[10], this.activePlaneVertsSagittal[11]);
            gl.glVertex3d(this.activePlaneVertsSagittal[0], this.activePlaneVertsSagittal[1], this.activePlaneVertsSagittal[2]);
            gl.glEnd();
        }
        gl.glDisable(3042);
        gl.glDepthMask(true);
    }

    private void renderMarker(Marker marker, GL2 gl, boolean special, boolean measuring) {
        boolean isGrabbed = marker == this.grabbedMarker;
        float[] color = marker.getColor();
        Point3d point = marker.getPoint();
        gl.glPushMatrix();
        gl.glTranslated(point.x, point.y, point.z);
        if (special) {
            gl.glColor4d((double)0.9f, 0.25, (double)0.9f, isGrabbed || measuring ? 0.5 : marker.getAlpha());
        } else {
            gl.glColor4d((double)color[0], (double)color[1], (double)color[2], isGrabbed || measuring ? 0.5 : marker.getAlpha());
        }
        this.glut.glutSolidSphere(marker.getRadius() * (isGrabbed ? 1.5 : 1.0) * (measuring ? 1.25 : 1.0), 20, 20);
        gl.glPopMatrix();
    }

    private void renderMarkerLine(MarkerLine markerLine, GL2 gl, boolean measure) {
        float[] color = markerLine.getColor();
        Point3d[] points = markerLine.getPoints();
        if (measure) {
            gl.glLineWidth(4.0f);
        } else {
            gl.glLineWidth(2.0f);
        }
        gl.glColor4d((double)color[0], (double)color[1], (double)color[2], markerLine.getAlpha());
        gl.glBegin(1);
        for (Point3d point : points) {
            gl.glVertex3d(point.x, point.y, point.z);
        }
        gl.glEnd();
        if (measure && points.length == 2) {
            this.renderMarkerLineTicks(markerLine, gl);
        }
    }

    private void renderMarkerLineTicks(MarkerLine markerLine, GL2 gl) {
        float[] color = markerLine.getColor();
        Point3d[] points = markerLine.getPoints();
        gl.glLineWidth(2.0f);
        gl.glColor4d((double)color[0], (double)color[1], (double)color[2], markerLine.getAlpha());
        Point3d point1 = points[0];
        Point3d point2 = points[1];
        Vector3d vec = new Vector3d(points[0].x - points[1].x, points[0].y - points[1].y, points[0].z - points[1].z);
        double[] mat = this.position.getViewTransform();
        Matrix mat2 = new Matrix(mat, 4);
        mat2 = mat2.transpose();
        double[] vecmat = new double[]{0.0, 0.0, 1.0, 1.0};
        Matrix vecmat2 = new Matrix(vecmat, 1);
        Matrix result = vecmat2.times(mat2);
        Vector3d vec2a = new Vector3d(result.get(0, 0), result.get(0, 1), result.get(0, 2));
        Vector3d vec2 = new Vector3d();
        vec2.cross(vec, vec2a);
        vec2.normalize();
        Point3d p1 = new Point3d((point1.x + point2.x) * 0.5, (point1.y + point2.y) * 0.5, (point1.z + point2.z) * 0.5);
        Point3d p2 = new Point3d((point1.x + p1.x) * 0.5, (point1.y + p1.y) * 0.5, (point1.z + p1.z) * 0.5);
        Point3d p3 = new Point3d((point2.x + p1.x) * 0.5, (point2.y + p1.y) * 0.5, (point2.z + p1.z) * 0.5);
        gl.glBegin(1);
        gl.glVertex3d(p1.x + 2.5 * this.scaleFactor * vec2.x, p1.y + 2.5 * this.scaleFactor * vec2.y, p1.z + 2.5 * this.scaleFactor * vec2.z);
        gl.glVertex3d(p1.x - 2.5 * this.scaleFactor * vec2.x, p1.y - 2.5 * this.scaleFactor * vec2.y, p1.z - 2.5 * this.scaleFactor * vec2.z);
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex3d(p2.x + 2.5 * this.scaleFactor * vec2.x, p2.y + 2.5 * this.scaleFactor * vec2.y, p2.z + 2.5 * this.scaleFactor * vec2.z);
        gl.glVertex3d(p2.x - 2.5 * this.scaleFactor * vec2.x, p2.y - 2.5 * this.scaleFactor * vec2.y, p2.z - 2.5 * this.scaleFactor * vec2.z);
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex3d(p3.x + 2.5 * this.scaleFactor * vec2.x, p3.y + 2.5 * this.scaleFactor * vec2.y, p3.z + 2.5 * this.scaleFactor * vec2.z);
        gl.glVertex3d(p3.x - 2.5 * this.scaleFactor * vec2.x, p3.y - 2.5 * this.scaleFactor * vec2.y, p3.z - 2.5 * this.scaleFactor * vec2.z);
        gl.glEnd();
    }

    private void renderROIShape(GL2 gl, boolean translucent, boolean depthDisable) {
        Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndicesCurrentLast();
        if (translucent) {
            Collections.reverse(usedROIs);
        }
        Iterator<Integer> it = usedROIs.iterator();
        float[] colorComps = new float[3];
        while (it.hasNext()) {
            int colorIndex = it.next();
            Color color = ROIColor.getColor(colorIndex);
            color.getColorComponents(colorComps);
            if (translucent) {
                if (depthDisable) {
                    gl.glDepthMask(false);
                }
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                gl.glColor4f(colorComps[0], colorComps[1], colorComps[2], 0.25f);
            } else {
                gl.glColor4f(colorComps[0], colorComps[1], colorComps[2], 1.0f);
            }
            gl.glPolygonMode(1032, 6914);
            ROI roiShape = this.roiShapes[colorIndex];
            FloatBuffer quadBuffer = null;
            if (roiShape != null) {
                if (roiShape.needsBufferSwitch()) {
                    roiShape.switchBuffered();
                }
                if ((quadBuffer = roiShape.getQuads()) != null) {
                    gl.glEnableClientState(32884);
                    gl.glVertexPointer(3, 5126, 0, quadBuffer.rewind());
                    gl.glDrawArrays(7, 0, roiShape.getNumQuads());
                    gl.glDisableClientState(32884);
                }
            }
            if (!translucent) continue;
            gl.glDisable(3042);
            if (!depthDisable) continue;
            gl.glDepthMask(true);
        }
    }

    private void renderSurface(CompositeSurface surface, GL2 gl, boolean flipCullFace, boolean stencilTest, int[] shaderUniforms, int shaderprogram) {
        if (this.isUsingShaders()) {
            this.startShaders(gl, shaderprogram);
            this.updateShaders(gl, stencilTest, surface.isBaseSurface(), shaderUniforms);
        }
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        if (!surface.isBaseSurface() && surface.getWorldTransform() != null) {
            gl.glMultTransposeMatrixd(surface.getWorldTransform(), 0);
        }
        if (surface.isBaseSurface() || surface.isUseTransform()) {
            if (!this.isUsingShaders()) {
                gl.glEnable(2977);
            }
            this.position.applyUserTransform(gl);
        }
        if (surface.isVisible() || stencilTest) {
            int ctr;
            int numVboElements = surface.getNumVboElements();
            surface.getMaterial().apply(gl, surface.getLighting());
            if (stencilTest) {
                gl.glPolygonMode(1028, 6914);
            } else {
                gl.glPolygonMode(1028, surface.getMaterial().getPolygonMode());
            }
            gl.glShadeModel(surface.getMaterial().getShadeModel());
            gl.glColorMaterial(1032, 4609);
            if (this.preferences.isShowSlices() || surface.getMaterial().isTransparent() || !surface.isBaseSurface()) {
                gl.glEnable(2884);
            } else if (!this.preferences.isShowSlices()) {
                gl.glEnable(16385);
            }
            if (surface.getMaterial().isTransparent()) {
                gl.glFrontFace(2305);
                gl.glCullFace(1028);
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                gl.glEnable(16385);
                for (ctr = 0; ctr < surface.getNumParts(); ++ctr) {
                    gl.glEnableClientState(32884);
                    gl.glEnableClientState(32885);
                    if (surface.hasColors() && surface.getMaterial().isShowOverlayColors()) {
                        if (surface.colorsAreDirty()) {
                            surface.bindColorData(gl, this.canUseVBO);
                        }
                        if (surface.colorsBound()) {
                            gl.glEnable(2903);
                            gl.glEnableClientState(32886);
                            if (this.canUseVBO) {
                                gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 2]);
                                gl.glColorPointer(4, 5126, 0, 0L);
                            } else {
                                gl.glColorPointer(4, 5126, 0, surface.getColorsBuffer(0).rewind());
                            }
                        }
                    }
                    if (this.canUseVBO) {
                        gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 0]);
                        gl.glVertexPointer(3, 5126, 0, 0L);
                        gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 1]);
                        gl.glNormalPointer(5126, 0, 0L);
                    } else {
                        gl.glVertexPointer(3, 5126, 0, surface.getPointsBuffer(0).rewind());
                        gl.glNormalPointer(5126, 0, surface.getNormalsBuffer(0).rewind());
                    }
                    if (surface.isUsingIndices() && (surface.getMaterial().getPolygonType() != 0 || stencilTest)) {
                        if (this.canUseVBO) {
                            gl.glBindBuffer(34963, surface.vbo[ctr * numVboElements + 3]);
                            gl.glDrawElements(4, surface.getNumTriangles(ctr) * 3, 5125, 0L);
                        } else {
                            gl.glDrawElements(4, surface.getNumTriangles(ctr) * 3, 5125, surface.getIndicesBuffer(0).rewind());
                        }
                    } else {
                        gl.glDrawArrays(surface.getMaterial().getPolygonType(), 0, surface.getNumPoints(ctr));
                    }
                    gl.glDisableClientState(32884);
                    gl.glDisableClientState(32885);
                    gl.glDisableClientState(32886);
                }
                gl.glDisable(16385);
            }
            if (flipCullFace) {
                gl.glFrontFace(2305);
                gl.glCullFace(1028);
                gl.glEnable(16385);
            } else {
                gl.glFrontFace(2305);
                gl.glCullFace(1029);
                gl.glEnable(16384);
            }
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            for (ctr = 0; ctr < surface.getNumParts(); ++ctr) {
                gl.glEnableClientState(32884);
                gl.glEnableClientState(32885);
                if (surface.hasColors() && surface.getMaterial().isShowOverlayColors()) {
                    if (surface.colorsAreDirty()) {
                        surface.bindColorData(gl, this.canUseVBO);
                    }
                    if (surface.colorsBound()) {
                        gl.glEnable(2903);
                        gl.glEnableClientState(32886);
                        if (this.canUseVBO) {
                            gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 2]);
                            gl.glColorPointer(4, 5126, 0, 0L);
                        } else {
                            gl.glColorPointer(4, 5126, 0, surface.getColorsBuffer(0).rewind());
                        }
                    }
                }
                if (this.canUseVBO) {
                    gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 0]);
                    gl.glVertexPointer(3, 5126, 0, 0L);
                    gl.glBindBuffer(34962, surface.vbo[ctr * numVboElements + 1]);
                    gl.glNormalPointer(5126, 0, 0L);
                } else {
                    gl.glVertexPointer(3, 5126, 0, surface.getPointsBuffer(0).rewind());
                    gl.glNormalPointer(5126, 0, surface.getNormalsBuffer(0).rewind());
                }
                if (surface.isUsingIndices() && (surface.getMaterial().getPolygonType() != 0 || stencilTest)) {
                    if (this.canUseVBO) {
                        gl.glBindBuffer(34963, surface.vbo[ctr * numVboElements + 3]);
                        gl.glDrawElements(4, surface.getNumTriangles(ctr) * 3, 5125, 0L);
                    } else {
                        gl.glDrawElements(4, surface.getNumTriangles(ctr) * 3, 5125, surface.getIndicesBuffer(0).rewind());
                    }
                } else {
                    gl.glDrawArrays(surface.getMaterial().getPolygonType(), 0, surface.getNumPoints(ctr));
                }
                gl.glDisableClientState(32884);
                gl.glDisableClientState(32885);
                gl.glDisableClientState(32886);
                gl.glDisable(2903);
            }
            gl.glDisable(16384);
            gl.glDisable(2884);
            gl.glDisable(3042);
            if (this.canUseVBO) {
                gl.glBindBuffer(34962, 0);
            }
        }
        if (this.isUsingShaders()) {
            this.stopShaders(gl);
        }
        if ((surface.isBaseSurface() || surface.isUseTransform()) && !this.isUsingShaders()) {
            gl.glDisable(2977);
        }
        this.position.apply(gl, this.scaleFactor);
        if (this.mouse != null && !flipCullFace) {
            this.position.pickPoint(gl, this.mouse, surface, this.measureMode);
        }
    }

    private void renderSurfaceAndSlices(GL2 gl, boolean drawSurfaceVal, boolean transparentTest, boolean axialSlice, boolean coronalSlice, boolean sagittalSlice, int[] shaderUniforms, int shaderprogram) {
        boolean ok;
        boolean drawSurface = drawSurfaceVal;
        drawSurface &= this.baseSurface.isVisible();
        boolean isOpaque = this.baseSurface.getMaterial().isOpaque();
        int stencilOpFirst = transparentTest ? 7683 : 7682;
        int stencilOpSecond = !transparentTest ? 7683 : 7682;
        int numCutPlanes = 0;
        if (axialSlice) {
            ++numCutPlanes;
        }
        if (coronalSlice) {
            ++numCutPlanes;
        }
        if (sagittalSlice) {
            ++numCutPlanes;
        }
        if (numCutPlanes > 0 && isOpaque && !transparentTest) {
            gl.glEnable(2960);
            gl.glDisable(2896);
            gl.glClearStencil(0);
            gl.glClear(1024);
            gl.glDepthMask(false);
            gl.glColorMask(false, false, false, false);
            gl.glStencilFunc(519, 1, 1);
            gl.glStencilOp(7680, stencilOpFirst, stencilOpFirst);
            this.renderSurface(this.baseSurface, gl, true, true, shaderUniforms, shaderprogram);
            if (drawSurface) {
                gl.glDepthMask(true);
                gl.glColorMask(true, true, true, true);
                gl.glEnable(2896);
            }
            gl.glStencilFunc(519, 1, 1);
            gl.glStencilOp(7680, stencilOpSecond, stencilOpSecond);
            this.renderSurface(this.baseSurface, gl, false, true, shaderUniforms, shaderprogram);
            gl.glStencilFunc(514, 1, 1);
            gl.glStencilOp(7680, 7680, 7680);
            if (!drawSurface) {
                gl.glDepthMask(true);
                gl.glColorMask(true, true, true, true);
                gl.glEnable(2896);
            }
        } else if (drawSurface) {
            this.renderSurface(this.baseSurface, gl, false, false, shaderUniforms, shaderprogram);
        }
        if (axialSlice) {
            boolean bl = ok = (this.position.getLastPickedOctant() & 4) == 0;
            if (transparentTest) {
                ok = !ok;
            }
            this.drawAxialTexture(gl, ok, true);
        }
        if (coronalSlice) {
            boolean bl = ok = (this.position.getLastPickedOctant() & 2) == 0;
            if (transparentTest) {
                ok = !ok;
            }
            this.drawCoronalTexture(gl, ok, true);
        }
        if (sagittalSlice) {
            boolean bl = ok = (this.position.getLastPickedOctant() & 1) == 0;
            if (transparentTest) {
                ok = !ok;
            }
            this.drawSagittalTexture(gl, ok, true);
        }
        gl.glDisable(2960);
    }

    private void renderSurfaceAndSlicesOld(GL2 gl, boolean transparent, boolean axialSlice, boolean coronalSlice, boolean sagittalSlice, int[] shaderUniforms, int shaderprogram) {
        boolean ok;
        boolean usingOblique = this.preferences.isUsingObliqueCutPlane();
        int obliqueDir = this.getObliqueCutPlaneDirection();
        if (axialSlice) {
            ok = (this.position.getLastPickedOctant() & 4) == 0;
            this.updateSliceAxial(gl, usingOblique && obliqueDir == 0);
            this.drawAxialTexture(gl, ok, !transparent && this.baseSurface.isVisible());
            if (!transparent) {
                this.setSliceAxial(gl);
                this.renderSurface(this.baseSurface, gl, false, false, shaderUniforms, shaderprogram);
                this.unsetSliceAxial(gl);
            }
        }
        if (coronalSlice) {
            ok = (this.position.getLastPickedOctant() & 2) == 0;
            this.updateSliceCoronal(gl, usingOblique && obliqueDir == 1);
            this.drawCoronalTexture(gl, ok, !transparent && this.baseSurface.isVisible());
            if (!transparent) {
                this.setSliceCoronal(gl);
                this.renderSurface(this.baseSurface, gl, false, false, shaderUniforms, shaderprogram);
                this.unsetSliceCoronal(gl);
            }
        }
        if (sagittalSlice) {
            ok = (this.position.getLastPickedOctant() & 1) == 0;
            this.updateSliceSagittal(gl, usingOblique && obliqueDir == 2);
            this.drawSagittalTexture(gl, ok, !transparent && this.baseSurface.isVisible());
            if (!transparent) {
                this.setSliceSagittal(gl);
                this.renderSurface(this.baseSurface, gl, false, false, shaderUniforms, shaderprogram);
                this.unsetSliceSagittal(gl);
            }
        }
        if (transparent) {
            this.renderSurface(this.baseSurface, gl, false, false, shaderUniforms, shaderprogram);
        }
    }

    private void renderText(GL2 gl, String text, double xLoc, double yLoc, double zLoc) {
        if (!this.triedRenderText) {
            try {
                this.doRenderText(gl, text, xLoc, yLoc, zLoc, null, false);
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.cannotRenderText = true;
            }
            this.triedRenderText = true;
        } else if (!this.cannotRenderText) {
            this.doRenderText(gl, text, xLoc, yLoc, zLoc, null, false);
        }
    }

    private void reorderSurfaceOverlays(CompositeSurface surface) {
        Vector<SurfaceOverlay> overlays = surface.getSurfaceOverlays();
        if (overlays != null && overlays.size() > 1) {
            SurfaceOverlay[] ovlyArr = overlays.toArray(new SurfaceOverlay[overlays.size()]);
            overlays.removeAllElements();
            ScreenVolume[] allVols = this.viewer.getOverlayManager().getAllOverlays();
            for (int ctr = 0; ctr < 8; ++ctr) {
                if (allVols[ctr] == null) continue;
                for (int ctrO = 0; ctrO < ovlyArr.length; ++ctrO) {
                    if (ovlyArr[ctrO] == null || allVols[ctr] != ovlyArr[ctrO].getOverlay()) continue;
                    overlays.add(ovlyArr[ctrO]);
                    ovlyArr[ctrO] = null;
                }
            }
        }
    }

    private MarkerLine replaceMarkerLine(int oldNum, int colorIndex, Point3d[] points, LOIShape syncObj) {
        this.removeMarkerLine(oldNum, false);
        Color color = ROIColor.getColor(colorIndex);
        MarkerLine ml = new MarkerLine(this, points, oldNum, color);
        ml.setSyncObject(syncObj);
        if (!this.allMarkerLines.containsValue(ml)) {
            this.allMarkerLines.put(oldNum, ml);
        }
        return ml;
    }

    private void setAxialTexturePlane(Point3d point1, Point3d point2, Point3d point3, Point3d point4) {
        this.activePlaneVertsAxialTexture[0] = (float)point1.x;
        this.activePlaneVertsAxialTexture[1] = (float)point1.y;
        this.activePlaneVertsAxialTexture[2] = (float)point1.z;
        this.activePlaneVertsAxialTexture[3] = (float)point2.x;
        this.activePlaneVertsAxialTexture[4] = (float)point2.y;
        this.activePlaneVertsAxialTexture[5] = (float)point2.z;
        this.activePlaneVertsAxialTexture[6] = (float)point3.x;
        this.activePlaneVertsAxialTexture[7] = (float)point3.y;
        this.activePlaneVertsAxialTexture[8] = (float)point3.z;
        this.activePlaneVertsAxialTexture[9] = (float)point4.x;
        this.activePlaneVertsAxialTexture[10] = (float)point4.y;
        this.activePlaneVertsAxialTexture[11] = (float)point4.z;
    }

    private final void setCapabilities(GLCapabilities caps) {
        if (this.canUseShaders()) {
            if (caps.getDepthBits() < 8) {
                caps.setDepthBits(8);
            }
            if (caps.getStencilBits() < 8) {
                caps.setStencilBits(8);
            }
        }
    }

    private void setCoronalTexturePlane(Point3d point1, Point3d point2, Point3d point3, Point3d point4) {
        this.activePlaneVertsCoronalTexture[0] = (float)point1.x;
        this.activePlaneVertsCoronalTexture[1] = (float)point1.y;
        this.activePlaneVertsCoronalTexture[2] = (float)point1.z;
        this.activePlaneVertsCoronalTexture[3] = (float)point2.x;
        this.activePlaneVertsCoronalTexture[4] = (float)point2.y;
        this.activePlaneVertsCoronalTexture[5] = (float)point2.z;
        this.activePlaneVertsCoronalTexture[6] = (float)point3.x;
        this.activePlaneVertsCoronalTexture[7] = (float)point3.y;
        this.activePlaneVertsCoronalTexture[8] = (float)point3.z;
        this.activePlaneVertsCoronalTexture[9] = (float)point4.x;
        this.activePlaneVertsCoronalTexture[10] = (float)point4.y;
        this.activePlaneVertsCoronalTexture[11] = (float)point4.z;
    }

    private void setSagittalTexturePlane(Point3d point1, Point3d point2, Point3d point3, Point3d point4) {
        this.activePlaneVertsSagittalTexture[0] = (float)point1.x;
        this.activePlaneVertsSagittalTexture[1] = (float)point1.y;
        this.activePlaneVertsSagittalTexture[2] = (float)point1.z;
        this.activePlaneVertsSagittalTexture[3] = (float)point2.x;
        this.activePlaneVertsSagittalTexture[4] = (float)point2.y;
        this.activePlaneVertsSagittalTexture[5] = (float)point2.z;
        this.activePlaneVertsSagittalTexture[6] = (float)point3.x;
        this.activePlaneVertsSagittalTexture[7] = (float)point3.y;
        this.activePlaneVertsSagittalTexture[8] = (float)point3.z;
        this.activePlaneVertsSagittalTexture[9] = (float)point4.x;
        this.activePlaneVertsSagittalTexture[10] = (float)point4.y;
        this.activePlaneVertsSagittalTexture[11] = (float)point4.z;
    }

    private void setSliceAxial(GL2 gl) {
        gl.glEnable(12288);
    }

    private void setSliceCoronal(GL2 gl) {
        gl.glEnable(12289);
    }

    private void setSliceSagittal(GL2 gl) {
        gl.glEnable(12290);
    }

    private void showWarning() {
        if (this.needsShowError) {
            this.showErrorDialog("This system does not appear to support OpenGL 2.", "OpenGL Error");
        } else if (this.needsShowCapableWarning) {
            String message = "This system appears capable of running in Better Graphics mode.";
            message = message + "\nYou can change this setting from the Toolbox > Preferences > Platform > OpenGL";
            this.showWarningDialog(message, "OpenGL Settings");
        } else if (this.needsShowIncapableWarning) {
            String message = "This system does not appear capable of running in Better Graphics mode.";
            message = message + "\nYou can change this setting in Preferences > Platform > OpenGL.";
            this.showWarningDialog(message, "OpenGL Settings");
        }
        this.needsShowIncapableWarning = false;
        this.needsShowCapableWarning = false;
        this.needsShowError = false;
        alreadyWarnedAboutUsingBetterGraphics = true;
    }

    private void showWarningDialog(String message, String title) {
        this.viewer.getMango().showWarningDialog(message, title);
    }

    private void startShaders(GL2 gl, int shaderprogram) {
        gl.glUseProgram(shaderprogram);
    }

    private void startSyncOverlays() {
        if (this.syncOverlaysTimer != null) {
            this.syncOverlaysTimer.cancel();
            this.syncOverlaysTimer = null;
        }
        this.syncOverlaysTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (CompositeSurface surface : SurfaceViewer.this.surfaces) {
                            if (!surface.getMaterial().isShowOverlayColors()) continue;
                            SurfaceViewer.this.doSyncOverlays(surface);
                        }
                    }
                });
            }
        };
        this.syncOverlaysTimer.schedule(task, 750L);
    }

    private synchronized void startVideoCaptureTimer() {
        this.stopVideoCaptureTimer();
        this.videoCaptureTimer = new Timer();
        TimerTask videoCaptureTask = new TimerTask(){

            @Override
            public void run() {
                SurfaceViewer.this.captureVideo();
            }
        };
        this.videoCaptureTimer.scheduleAtFixedRate(videoCaptureTask, 0L, (long)(1000 / this.videoCaptureFps));
    }

    private void stopShaders(GL2 gl) {
        gl.glUseProgram(0);
    }

    private synchronized void stopVideoCaptureTimer() {
        if (this.videoCaptureTimer != null) {
            this.videoCaptureTimer.cancel();
            this.videoCaptureTimer = null;
        }
    }

    private void unsetSliceAxial(GL2 gl) {
        gl.glDisable(12288);
    }

    private void unsetSliceCoronal(GL2 gl) {
        gl.glDisable(12289);
    }

    private void unsetSliceSagittal(GL2 gl) {
        gl.glDisable(12290);
    }

    private void updateAllROIShapeVolumes(int direction) {
        Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndicesCurrentLast();
        Integer[] usedIndices = usedROIs.toArray(new Integer[usedROIs.size()]);
        for (int ctrColor = 0; ctrColor < usedIndices.length; ++ctrColor) {
            if (this.roiShapes[usedIndices[ctrColor]] == null) {
                this.roiShapes[usedIndices[ctrColor].intValue()] = new ROI(this.viewer.getXDim(), this.viewer.getYDim(), this.viewer.getZDim(), direction);
                continue;
            }
            this.roiShapes[usedIndices[ctrColor]].reset(direction);
        }
        ScreenSlice screenSlice = this.viewer.getScreenSlice(direction);
        int numSlices = screenSlice.getNumSlices();
        ProgressBar progressBar = new ProgressBar(progressBarListener, "Building ROI");
        progressBar.init(0, 0, numSlices * usedIndices.length + 1);
        for (int ctr = 0; ctr < numSlices; ++ctr) {
            ROIShape[] roi = this.viewer.getROIManager().getShape(ctr, direction, this.viewer.getAxialScreenSlice().getFinalTransform(), -1, true);
            for (Integer usedIndice : usedIndices) {
                this.roiShapes[usedIndice].makeQuads(roi[usedIndice], this, ctr);
                progressBar.setValue(progressBar.getCurrent() + 1);
            }
        }
        for (Integer usedIndice : usedIndices) {
            this.roiShapes[usedIndice].createQuadBuffer();
        }
        progressBar.setValue(progressBar.getMax());
        this.updateSurface();
    }

    private void updateDimensionContingentInfo() {
        this.xDim = this.viewer.getXDim();
        this.yDim = this.viewer.getYDim();
        this.zDim = this.viewer.getZDim();
        this.xSize = this.viewer.getXSize();
        this.ySize = this.viewer.getYSize();
        this.zSize = this.viewer.getZSize();
        this.averageSize = (this.xSize + this.ySize + this.zSize) / 3.0;
        this.xHalf = (double)this.xDim * this.xSize / 2.0;
        this.yHalf = (double)this.yDim * this.ySize / 2.0;
        this.zHalf = (double)this.zDim * this.zSize / 2.0;
        double xRange = this.xSize * (double)this.xDim;
        double yRange = this.ySize * (double)this.yDim;
        double zRange = this.zSize * (double)this.zDim;
        double longestRange = xRange;
        if (yRange > longestRange) {
            longestRange = yRange;
        }
        if (zRange > longestRange) {
            longestRange = zRange;
        }
        this.scaleFactor = longestRange / 256.0;
    }

    private void updateLinesWithPoint(Point3d pointOld, Point3d pointNew, boolean updateViewer) {
        Iterator<MarkerLine> markerIt = this.allMarkerLines.values().iterator();
        Vector<MarkerLine> linesToChange = new Vector<MarkerLine>();
        while (markerIt.hasNext()) {
            MarkerLine ml = markerIt.next();
            if (ml.containsPoint(pointOld) == -1) continue;
            linesToChange.add(ml);
        }
        for (MarkerLine ml : linesToChange) {
            if (ml.isSurfaceLine()) {
                if (!ml.isEndPoint(pointOld)) continue;
                Marker start = this.findMarker(pointNew);
                Marker end = this.findMarker(ml.getOppositeEndPoint(pointOld));
                if (start == null || end == null) continue;
                this.redrawSurfaceLine(start, end, null, ml.getNumber());
                continue;
            }
            ml.editPoint(pointOld, pointNew);
            if (ml.getSyncObject() == null) continue;
            this.updateROILineInSliceViewerPoint(pointOld, pointNew, ml, updateViewer);
        }
    }

    private void updateMarker(Marker marker, Point3d grabPoint, Point3d point, boolean updateViewer, boolean updateLines) {
        marker.editMarker(point);
        if (updateLines) {
            this.updateLinesWithPoint(grabPoint, point, updateViewer);
        }
    }

    private void updateModelClipTransforms() {
        double[][] imageTransform = this.position.getImageTransformInverse();
        this.axialModClipTransformed = SurfaceUtils.transformPlane(this.axialModClip, imageTransform);
        this.coronalModClipTransformed = SurfaceUtils.transformPlane(this.coronalModClip, imageTransform);
        this.sagittalModClipTransformed = SurfaceUtils.transformPlane(this.sagittalModClip, imageTransform);
    }

    private void updateObliqueCutPlaneDialog() {
        boolean needsChange;
        if (this.obliquePlaneDialog != null && (needsChange = this.obliquePlaneDialog.updateCutPlaneDirectionOptions())) {
            if (this.preferences.isUsingCutPlane()) {
                if (this.preferences.isUsingAxialCutPlane()) {
                    this.position.setObliqueDirection(0);
                    this.obliquePlaneDialog.updateToAxial();
                } else if (this.preferences.isUsingCoronalCutPlane()) {
                    this.position.setObliqueDirection(1);
                    this.obliquePlaneDialog.updateToCoronal();
                } else if (this.preferences.isUsingSagittalCutPlane()) {
                    this.position.setObliqueDirection(2);
                    this.obliquePlaneDialog.updateToSagittal();
                }
            } else {
                this.showObliquePlaneDialog(false);
            }
        }
    }

    private void updateROILineInSliceViewerPoint(Point3d pointOld, Point3d pointNew, MarkerLine line, boolean updateViewer) {
        if (this.isSyncingShapes()) {
            Coordinate coorOld = this.position.convertPointToCoordinate(pointOld);
            Coordinate coorNew = this.position.convertPointToCoordinate(pointNew);
            LOIShape syncShape = line.getSyncObject();
            if (syncShape != null) {
                if (syncShape.getSliceDirection() == 0) {
                    Point editingPoint = syncShape.editLineAt(new Point(coorOld.xInt, coorOld.yInt), 3);
                    if (editingPoint != null) {
                        editingPoint.x = coorNew.xInt;
                        editingPoint.y = coorNew.yInt;
                    }
                } else if (syncShape.getSliceDirection() == 1) {
                    Point editingPoint = syncShape.editLineAt(new Point(coorOld.xInt, coorOld.zInt), 3);
                    if (editingPoint != null) {
                        editingPoint.x = coorNew.xInt;
                        editingPoint.y = coorNew.zInt;
                    }
                } else {
                    Point editingPoint = syncShape.editLineAt(new Point(coorOld.yInt, coorOld.zInt), 3);
                    if (editingPoint != null) {
                        editingPoint.x = coorNew.yInt;
                        editingPoint.y = coorNew.zInt;
                    }
                }
            }
            if (!this.allPointsInSlicePlane(line)) {
                line.setSyncObject(null);
                this.viewer.removeLineFromSurface(syncShape);
            }
        }
        if (updateViewer) {
            this.getViewer().updateViewer();
        }
    }

    private void updateROIShapeVolume(int color, int direction) {
        if (this.roiShapes[color] == null) {
            this.roiShapes[color] = new ROI(this.viewer.getXDim(), this.viewer.getYDim(), this.viewer.getZDim(), direction);
        } else if (this.roiShapes[color].getDirection() != direction) {
            this.roiShapes[color].reset(direction);
        }
        ScreenSlice screenSlice = this.viewer.getScreenSlice(direction);
        int numSlices = screenSlice.getNumSlices();
        ProgressBar progressBar = new ProgressBar(progressBarListener, "Building ROI");
        progressBar.init(0, 0, numSlices + 1);
        if (this.viewer.getROIManager().hasROI(color)) {
            for (int ctr = 0; ctr < numSlices; ++ctr) {
                ROIShape[] roi = this.viewer.getROIManager().getShape(ctr, direction, screenSlice.getFinalTransform(), color, true);
                this.roiShapes[color].makeQuads(roi[color], this, ctr);
                progressBar.setValue(ctr);
            }
            this.roiShapes[color].createQuadBuffer();
        } else {
            this.roiShapes[color] = null;
        }
        progressBar.setValue(progressBar.getMax());
        this.updateSurface();
    }

    private void updateShaders(GL2 gl, boolean stencilTest, boolean baseSurface, int[] shaderUniforms) {
        if (this.preferences.isUsingObliqueCutPlane()) {
            int sliceDirection = this.getObliqueCutPlaneDirection();
            if (sliceDirection == 0) {
                gl.glUniform4f(shaderUniforms[0], (float)this.obliqueModClip[0], (float)this.obliqueModClip[1], (float)this.obliqueModClip[2], (float)this.obliqueModClip[3]);
                gl.glUniform4f(shaderUniforms[1], (float)this.coronalModClipTransformed.x, (float)this.coronalModClipTransformed.y, (float)this.coronalModClipTransformed.z, (float)this.coronalModClipTransformed.w);
                gl.glUniform4f(shaderUniforms[2], (float)this.sagittalModClipTransformed.x, (float)this.sagittalModClipTransformed.y, (float)this.sagittalModClipTransformed.z, (float)this.sagittalModClipTransformed.w);
            } else if (sliceDirection == 1) {
                gl.glUniform4f(shaderUniforms[0], (float)this.axialModClipTransformed.x, (float)this.axialModClipTransformed.y, (float)this.axialModClipTransformed.z, (float)this.axialModClipTransformed.w);
                gl.glUniform4f(shaderUniforms[1], (float)this.obliqueModClip[0], (float)this.obliqueModClip[1], (float)this.obliqueModClip[2], (float)this.obliqueModClip[3]);
                gl.glUniform4f(shaderUniforms[2], (float)this.sagittalModClipTransformed.x, (float)this.sagittalModClipTransformed.y, (float)this.sagittalModClipTransformed.z, (float)this.sagittalModClipTransformed.w);
            } else if (sliceDirection == 2) {
                gl.glUniform4f(shaderUniforms[0], (float)this.axialModClipTransformed.x, (float)this.axialModClipTransformed.y, (float)this.axialModClipTransformed.z, (float)this.axialModClipTransformed.w);
                gl.glUniform4f(shaderUniforms[1], (float)this.coronalModClipTransformed.x, (float)this.coronalModClipTransformed.y, (float)this.coronalModClipTransformed.z, (float)this.coronalModClipTransformed.w);
                gl.glUniform4f(shaderUniforms[2], (float)this.obliqueModClip[0], (float)this.obliqueModClip[1], (float)this.obliqueModClip[2], (float)this.obliqueModClip[3]);
            }
        } else {
            gl.glUniform4f(shaderUniforms[0], (float)this.axialModClipTransformed.x, (float)this.axialModClipTransformed.y, (float)this.axialModClipTransformed.z, (float)this.axialModClipTransformed.w);
            gl.glUniform4f(shaderUniforms[1], (float)this.coronalModClipTransformed.x, (float)this.coronalModClipTransformed.y, (float)this.coronalModClipTransformed.z, (float)this.coronalModClipTransformed.w);
            gl.glUniform4f(shaderUniforms[2], (float)this.sagittalModClipTransformed.x, (float)this.sagittalModClipTransformed.y, (float)this.sagittalModClipTransformed.z, (float)this.sagittalModClipTransformed.w);
        }
        gl.glUniform1i(shaderUniforms[3], this.preferences.isUsingAxialCutPlane() ? 1 : 0);
        gl.glUniform1i(shaderUniforms[4], this.preferences.isUsingCoronalCutPlane() ? 1 : 0);
        gl.glUniform1i(shaderUniforms[5], this.preferences.isUsingSagittalCutPlane() ? 1 : 0);
        if (baseSurface) {
            gl.glUniform1i(shaderUniforms[6], this.baseSurface.getMaterial().isTransparent() && !stencilTest ? 1 : 0);
        } else {
            gl.glUniform1i(shaderUniforms[6], 0);
        }
        gl.glUniform1i(shaderUniforms[7], baseSurface ? 1 : 0);
    }

    private void updateSliceAxial(GL2 gl, boolean oblique) {
        if (oblique) {
            gl.glClipPlane(12288, this.obliqueModClip, 0);
        } else {
            gl.glClipPlane(12288, this.axialModClip, 0);
        }
    }

    private void updateSliceCoronal(GL2 gl, boolean oblique) {
        if (oblique) {
            gl.glClipPlane(12289, this.obliqueModClip, 0);
        } else {
            gl.glClipPlane(12289, this.coronalModClip, 0);
        }
    }

    private void updateSliceSagittal(GL2 gl, boolean oblique) {
        if (oblique) {
            gl.glClipPlane(12290, this.obliqueModClip, 0);
        } else {
            gl.glClipPlane(12290, this.sagittalModClip, 0);
        }
    }

    public void setMenuOption(final String name, final boolean value) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (name.equals("Superior")) {
                    SurfaceViewer.this.setSurfaceOptionAxialSuperiorCutPlane(value);
                } else if (name.equals("Inferior")) {
                    SurfaceViewer.this.setSurfaceOptionAxialInferiorCutPlane(value);
                } else if (name.equals("Anterior")) {
                    SurfaceViewer.this.setSurfaceOptionCoronalAnteriorCutPlane(value);
                } else if (name.equals("Posterior")) {
                    SurfaceViewer.this.setSurfaceOptionCoronalPosteriorCutPlane(value);
                } else if (name.equals("Left")) {
                    SurfaceViewer.this.setSurfaceOptionSagittalLeftCutPlane(value);
                } else if (name.equals("Right")) {
                    SurfaceViewer.this.setSurfaceOptionSagittalRightCutPlane(value);
                } else if (name.equals("All Cut Planes")) {
                    SurfaceViewer.this.setSurfaceOptionAllCutPlanes(value);
                } else if (name.equals("Oblique Cut Plane")) {
                    SurfaceViewer.this.showObliquePlaneDialog(value);
                } else if (name.equals("Animate")) {
                    if (value) {
                        SurfaceViewer.this.startAnimation();
                    } else {
                        SurfaceViewer.this.stopAnimation();
                    }
                } else if (name.equals("Orientation")) {
                    SurfaceViewer.this.setViewOptionOrientation(value);
                } else if (name.equals("Ruler")) {
                    SurfaceViewer.this.setViewOptionRuler(value);
                } else if (name.equals("Position")) {
                    SurfaceViewer.this.setViewOptionPosition(value);
                } else if (name.equals("Crosshairs")) {
                    SurfaceViewer.this.setViewOptionCrosshairs(value);
                } else if (name.equals("All Slice Planes")) {
                    SurfaceViewer.this.setViewOptionShowAllSlicePlanes(value);
                } else if (name.equals("Main Slice Plane")) {
                    SurfaceViewer.this.setViewOptionShowMainSlicePlanes(value);
                } else if (name.equals("Shapes")) {
                    SurfaceViewer.this.setViewOptionShapes(value);
                } else if (name.equals("Surface")) {
                    SurfaceViewer.this.setViewOptionSurface(value);
                } else if (name.equals("Slices")) {
                    SurfaceViewer.this.setViewOptionSlices(value);
                } else if (name.equals("ROIs")) {
                    SurfaceViewer.this.setViewOptionROIs(value);
                } else if (name.equals("Stick to Slice Viewer")) {
                    SurfaceViewer.this.setWindowMenuOptionStick(value);
                } else {
                    JMenuItem mi = SurfaceViewer.this.getFrame().getMenuItem(name);
                    if (mi != null) {
                        mi.doClick();
                    } else {
                        SurfaceViewer.this.viewer.doClickMenuItem(name);
                    }
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setSurfaceOptionAxialSuperiorCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Superior"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setAxialCutPlane(-1);
        } else {
            this.preferences.setAxialCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionAxialInferiorCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Inferior"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setAxialCutPlane(1);
        } else {
            this.preferences.setAxialCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionCoronalAnteriorCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Anterior"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setCoronalCutPlane(1);
        } else {
            this.preferences.setCoronalCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionCoronalPosteriorCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Posterior"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setCoronalCutPlane(-1);
        } else {
            this.preferences.setCoronalCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionSagittalLeftCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Left"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setSagittalCutPlane(-1);
        } else {
            this.preferences.setSagittalCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionSagittalRightCutPlane(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Right"), ScriptUtils.convertBoolean(value)});
        if (value) {
            this.preferences.setSagittalCutPlane(1);
        } else {
            this.preferences.setSagittalCutPlane(0);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    public void setSurfaceOptionAllCutPlanes(boolean value) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("All Cut Planes"), ScriptUtils.convertBoolean(value)});
        if (value) {
            int pickedOctant = this.position.getLastPickedOctant();
            if (!this.preferences.isUsingAxialCutPlane()) {
                if ((pickedOctant & 4) != 0) {
                    this.preferences.setAxialCutPlane(1);
                } else {
                    this.preferences.setAxialCutPlane(-1);
                }
            }
            if (!this.preferences.isUsingCoronalCutPlane()) {
                if ((pickedOctant & 2) != 0) {
                    this.preferences.setCoronalCutPlane(-1);
                } else {
                    this.preferences.setCoronalCutPlane(1);
                }
            }
            if (!this.preferences.isUsingSagittalCutPlane()) {
                if ((pickedOctant & 1) != 0) {
                    this.preferences.setSagittalCutPlane(1);
                } else {
                    this.preferences.setSagittalCutPlane(-1);
                }
            }
        } else {
            this.preferences.setAxialCutPlane(0);
            this.preferences.setCoronalCutPlane(0);
            this.preferences.setSagittalCutPlane(0);
            this.showObliquePlaneDialog(false);
        }
        this.pickOctant(this.preferences.getPickedOctant());
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    @Override
    public Method findRecordableMethod(String name, int numArgs) {
        try {
            Method[] methods;
            for (Method method : methods = SurfaceManager.class.getMethods()) {
                if (!method.getName().equals(name) || numArgs != method.getParameterTypes().length) continue;
                return method;
            }
        }
        catch (SecurityException ex) {
            AppLogger.error((Throwable)ex);
        }
        return null;
    }

    public void setViewOptionOrientation(boolean showOrientation) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Orientation"), ScriptUtils.convertBoolean(showOrientation)});
        this.preferences.setShowOrientation(showOrientation);
        this.updateSurface();
    }

    public void setViewOptionRuler(boolean showRuler) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Ruler"), ScriptUtils.convertBoolean(showRuler)});
        this.preferences.setShowRuler(showRuler);
        if (showRuler) {
            this.findRulerLocation = true;
        }
        this.frame.updateInfoPanel(this.preferences.isShowPosition(), this.preferences.isShowRuler() || this.preferences.isShowAngle());
        this.updateSurface();
    }

    public void setViewOptionAngle(boolean showAngle) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Angle"), ScriptUtils.convertBoolean(showAngle)});
        this.preferences.setShowAngle(showAngle);
        if (showAngle) {
            this.findRulerLocationAngle = true;
        }
        this.frame.updateInfoPanel(this.preferences.isShowPosition(), this.preferences.isShowRuler() || this.preferences.isShowAngle());
        this.updateSurface();
    }

    public void setViewOptionPosition(boolean showPosition) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Position"), ScriptUtils.convertBoolean(showPosition)});
        this.preferences.setShowPosition(showPosition);
        this.frame.updateInfoPanel(this.preferences.isShowPosition(), this.preferences.isShowRuler() || this.preferences.isShowAngle());
    }

    public void setViewOptionCrosshairs(boolean showCrosshairs) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Crosshairs"), ScriptUtils.convertBoolean(showCrosshairs)});
        this.preferences.setShowCrosshairs(showCrosshairs);
        this.updateSurface();
    }

    public void setViewOptionShowAllSlicePlanes(boolean showAllSlicePlanes) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("All Slice Planes"), ScriptUtils.convertBoolean(showAllSlicePlanes)});
        if (showAllSlicePlanes) {
            this.preferences.setShowActivePlanes(2);
        } else {
            this.preferences.setShowActivePlanes(0);
        }
        this.updateSurface();
    }

    public void setViewOptionShowMainSlicePlanes(boolean showMainSlicePlane) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Main Slice Plane"), ScriptUtils.convertBoolean(showMainSlicePlane)});
        if (showMainSlicePlane) {
            this.preferences.setShowActivePlanes(1);
        } else {
            this.preferences.setShowActivePlanes(0);
        }
        this.updateSurface();
    }

    public void setViewOptionShapes(boolean showShape) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Shapes"), ScriptUtils.convertBoolean(showShape)});
        this.preferences.setShowShapes(showShape);
        this.updateSurface();
    }

    public void setViewOptionSurface(boolean showSurface) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Surface"), ScriptUtils.convertBoolean(showSurface)});
        this.baseSurface.setHidden(showSurface);
        this.updateSurfaceTextures();
        this.updateSurface();
    }

    public void setViewOptionSlices(boolean showSlices) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Slices"), ScriptUtils.convertBoolean(showSlices)});
        this.preferences.setShowSlices(showSlices);
        this.updateSurface();
    }

    public void setViewOptionROIs(boolean showROIs) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("ROIs"), ScriptUtils.convertBoolean(showROIs)});
        this.preferences.setShowDynamicROI(showROIs);
        this.updateSurface();
    }

    @Override
    public String getScriptObjectName() {
        return this.viewer.getScriptObjectName() + ".surfaceManager";
    }

    @Override
    public void recordAction(String name) {
        this.recordAction(name, null);
    }

    @Override
    public void recordAction(String name, String[] argValues) {
        this.recordAction(name, argValues, false, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
        this.recordAction(name, argValues, forceNeedsUserInput, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput, Recordable recordable) {
        this.viewer.recordAction(name, argValues, forceNeedsUserInput, recordable);
    }

    public void setBackground(final int rgb) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SurfaceViewer.this.setBackgroundColor(new Color(rgb));
                SurfaceViewer.this.updateSurface();
                SurfaceViewer.this.getFrame().updateInfoPanelColors();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setLighting(final double ambient, final double diffuse, final double specular, final double horizontal, final double vertical) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SurfaceViewer.this.baseSurface.getLighting().setLightingParameters((float)ambient, (float)diffuse, (float)specular);
                SurfaceViewer.this.baseSurface.getLighting().setLightingDirection(new float[]{(float)horizontal, (float)vertical, 1.0f});
                SurfaceViewer.this.updateSurface();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setMaterial(final Surface surface, final int rgb, boolean showOverlayColors, final boolean showOnlyThisOverlayColors, final boolean flatShading, final int renderType, final double transparency, final double emmisivity, final double shininess, final double searchDistance) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompositeSurface cs = (CompositeSurface)surface;
                Material material = cs.getMaterial();
                material.setColor(new Color(rgb));
                material.setShowOverlayColors(true);
                material.setShowOnlyThisOverlayColors(showOnlyThisOverlayColors);
                if (flatShading) {
                    material.setShadeModel(7424);
                } else {
                    material.setShadeModel(7425);
                }
                material.setPolygonStyle(renderType);
                material.setTransparency((float)transparency);
                material.setEmissivity((float)emmisivity);
                material.setShininess((float)shininess);
                material.setDistance(searchDistance);
                SurfaceViewer.this.syncOverlays((CompositeSurface)surface);
                if (surface.isBaseSurface()) {
                    SurfaceViewer.this.viewer.updateSurfaceTextures(true);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void captureSnapshot(String saveLocation) {
        Snapshot.takeSnapshot(saveLocation, this);
    }

    public void captureVideoStart(String saveLocation, int videoFormat, int videoQuality, int fps, boolean animate) {
        this.cine = new CineSurface(this.viewer, this, true);
        this.cine.startSilentFreeRecording(fps, videoQuality, videoFormat, new File(saveLocation), animate);
    }

    public void captureVideoStop() {
        if (this.cine != null) {
            this.cine.stopSilentRecording();
            this.cine = null;
        }
    }

    public List<Analysis> runSurfaceAreaStats(Surface surface) {
        SurfaceArea sa = new SurfaceArea(this.viewer, (CompositeSurface)surface, this.position, this.preferences);
        sa.calculateSurfaceAreaSync(this);
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        list.add(sa.getVisibleSurfaceStat());
        if (this.preferences.isUsingCutPlane() && sa.getSurface().isBaseSurface()) {
            list.add(sa.getCutAwaySurfaceStat());
        }
        this.calculationFinished(sa, true);
        return list;
    }

    public List<Analysis> runSurfaceVolumeStats(Surface surface) {
        SurfaceVolume sa = new SurfaceVolume(this.viewer, (CompositeSurface)surface, this.position, this.preferences);
        sa.calculateSurfaceVolumeSync(this);
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        list.add(sa.getVisibleSurfaceStat());
        if (this.preferences.isUsingCutPlane() && sa.getSurface().isBaseSurface()) {
            list.add(sa.getCutAwaySurfaceStat());
        }
        this.calculationFinished(sa, true);
        return list;
    }

    public void selectWindowMenuOptionMaximize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Maximize")});
        this.frame.maximize();
    }

    public void selectWindowMenuOptionMinimize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Dock")});
        this.frame.setState(1);
    }

    public void selectWindowMenuOptionZoomIn() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom In")});
        this.frame.incrementSize();
    }

    public void selectWindowMenuOptionZoomOut() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom Out")});
        this.frame.decrementSize();
    }

    public void setWindowMenuOptionStick(boolean sticky) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Stick to Slice Viewer"), ScriptUtils.convertBoolean(sticky)});
        this.frame.setSticky(sticky);
        if (this.frame.isSticky()) {
            this.viewer.doSticky();
        }
    }

    public Object runPlugin(final String name, final String[] args) {
        final Object[] result = new Object[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Mango.isScriptablePlugin(name)) {
                        ScriptablePlugin sp = (ScriptablePlugin)Mango.findPlugin(name);
                        result[0] = sp.doOperation((MangoContext)Mango.getInstance(), (VolumeManager)SurfaceViewer.this.viewer, false, args);
                        SurfaceViewer.this.scriptablePlugins.put(name, sp);
                    } else {
                        Mango.usePlugin(SurfaceViewer.this.viewer, name);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            AppLogger.error((Throwable)ex);
        }
        return result[0];
    }

    public void selectMenuOption(final String name) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (name.equals("Surface Info")) {
                        SurfaceViewer.this.selectFileMenuSurfaceInfo();
                    } else if (name.equals("Default")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.DEFAULT_ROTATION));
                    } else if (name.equals("View Superior")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.SUPERIOR_ROTATION));
                    } else if (name.equals("View Inferior")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.INFERIOR_ROTATION));
                    } else if (name.equals("View Anterior")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.ANTERIOR_ROTATION));
                    } else if (name.equals("View Posterior")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.POSTERIOR_ROTATION));
                    } else if (name.equals("View Left")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.LEFT_ROTATION));
                    } else if (name.equals("View Right")) {
                        SurfaceViewer.this.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.RIGHT_ROTATION));
                    } else if (name.equals("Save")) {
                        SurfaceViewer.this.savePosition();
                    } else if (name.equals("Go To Saved")) {
                        SurfaceViewer.this.goToSavedPosition();
                    } else if (name.equals("Maximize")) {
                        SurfaceViewer.this.selectWindowMenuOptionMaximize();
                    } else if (name.equals("Dock")) {
                        SurfaceViewer.this.selectWindowMenuOptionMinimize();
                    } else if (name.equals("Zoom In")) {
                        SurfaceViewer.this.selectWindowMenuOptionZoomIn();
                    } else if (name.equals("Zoom Out")) {
                        SurfaceViewer.this.selectWindowMenuOptionZoomOut();
                    } else {
                        JMenuItem mi = SurfaceViewer.this.getFrame().getMenuItem(name);
                        if (mi != null) {
                            mi.doClick();
                        } else {
                            SurfaceViewer.this.viewer.doClickMenuItem(name);
                        }
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public void selectFileMenuSurfaceInfo() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Surface Info")});
        SurfaceInfoDialog info = this.getSurfaceInfo();
        if (info != null) {
            info.updateInfo();
            info.setVisible(true);
        } else {
            this.setSurfaceInfo(new SurfaceInfoDialog(this));
        }
    }

    public void saveAs(String saveLocation, Surface surface, boolean includeLinesAndPoints) {
        Surface[] surfaceArray;
        MangoFormat mangoFormat = new MangoFormat();
        File file = new File(saveLocation);
        if (surface != null) {
            Surface[] surfaceArray2 = new Surface[1];
            surfaceArray = surfaceArray2;
            surfaceArray2[0] = surface;
        } else {
            surfaceArray = this.getSurfaces();
        }
        mangoFormat.writeSurfaceFile(file, surfaceArray, includeLinesAndPoints ? this.getShapeData() : null, this.viewer);
    }

    public void exportTo(String saveLocation, String surfaceType, Surface surface, String options) {
        Collection<SurfaceFormat> values = SurfaceReader.getLoadedFormats().values();
        for (SurfaceFormat aFormat : values) {
            String formatName = PluginManagerDialog.getPluginName(aFormat);
            if (!surfaceType.equals(formatName)) continue;
            try {
                Class<?> aClass = Class.forName(aFormat.getClass().getName());
                SurfaceFormat surfaceWriter = (SurfaceFormat)aClass.newInstance();
                surfaceWriter.getOptionsPanel(this.getSurfaces(), this.getShapeData(), (SurfaceController)this);
                surfaceWriter.setOptions(options);
                if (surfaceWriter == null) break;
                try {
                    Surface[] surfaceArray;
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray2 = new Surface[1];
                        surfaceArray = surfaceArray2;
                        surfaceArray2[0] = surface;
                    } else {
                        surfaceArray = this.getSurfaces();
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (VolumeManager)this.viewer);
                }
                catch (AbstractMethodError err) {
                    Surface[] surfaceArray;
                    AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray3 = new Surface[1];
                        surfaceArray = surfaceArray3;
                        surfaceArray3[0] = surface;
                    } else {
                        surfaceArray = this.getSurfaces();
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (SurfaceController)this);
                }
                catch (NoSuchMethodError err) {
                    Surface[] surfaceArray;
                    AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray4 = new Surface[1];
                        surfaceArray = surfaceArray4;
                        surfaceArray4[0] = surface;
                    } else {
                        surfaceArray = this.getSurfaces();
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (SurfaceController)this);
                }
            }
            catch (ClassNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InstantiationException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (SurfaceFormatException ex) {
                AppLogger.error((Throwable)ex);
            }
            break;
        }
    }

    public List<Surface> addShapesFromFile(String openLocation) {
        SurfaceReader sr = new SurfaceReader();
        Vector<Shape> shapes = new Vector<Shape>();
        Surface[] surfaces = sr.doReadFile(new File(openLocation), this.viewer, null, false, shapes);
        this.addSurfaceFromFile(surfaces, shapes);
        this.updateSurface();
        return Arrays.asList(surfaces);
    }

    public Surface addShapeFromOverlay(ImageVolume overlay, String name, int rgb, double threshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(overlay);
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)threshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        SurfaceFactory factory = new SurfaceFactory(params, this.viewer.getBaseVolume());
        factory.setSameThread(true);
        return factory.createOverlaySurface(this, (Volume)overlay, name, new Color(rgb));
    }

    public Surface addShapeFromROI(int roiIndex, String name, int rgb, double threshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.viewer.getBaseVolume());
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)threshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        SurfaceFactory factory = new SurfaceFactory(params, this.viewer.getBaseVolume());
        factory.setSameThread(true);
        return factory.createROISurface(this, this.viewer.getROIManager(), roiIndex, name, new Color(rgb));
    }

    public Surface addShapeFromLogical(List<ImageVolume> overlays, String name, int rgb, double logicalThreshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.viewer.getBaseVolume());
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)logicalThreshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        Logical logical = new Logical(null);
        for (ImageVolume vol : overlays) {
            logical.addOverlay((Volume)vol);
        }
        SurfaceFactory factory = new SurfaceFactory(params, this.viewer.getBaseVolume());
        factory.setSameThread(true);
        return factory.createLogicalSurface(this, logical, name, new Color(rgb));
    }

    public void removeSurface(Surface surface) {
        if (surface != this.baseSurface) {
            if (surface != null) {
                this.clearedShape = (CompositeSurface)surface;
            }
            this.updateSurface();
        }
    }

    public void goToShape(Shape shape) {
        Point3d gotoPoint = null;
        if (shape != null) {
            Point3d[] points = shape.getPoints();
            int numPoints = points.length;
            if (numPoints > 1) {
                MarkerLine ml = (MarkerLine)shape;
                Point3d currentLoc = this.position.convertCoordinateToPoint(this.viewer.getCurrentCoordinate(null, null, null, false, true, false));
                int containsPoint = ml.containsPoint(currentLoc);
                gotoPoint = ml.isSurfaceLine() ? (containsPoint == 0 ? ml.getPoints()[numPoints - 1] : ml.getPoints()[0]) : (containsPoint != -1 ? ml.getPoints()[(containsPoint + 1) % numPoints] : ml.getPoints()[0]);
            } else {
                gotoPoint = shape.getPoints()[0];
            }
            Coordinate coor = this.position.convertPointToCoordinate(gotoPoint);
            this.viewer.setCurrentCoordinate(coor, true, -1);
            this.updateSurface();
        }
    }

    public void lineToShape(Shape fromShape, Shape toShape) {
        Point3d[] points = fromShape.getPoints();
        int numPoints = points.length;
        this.recordAction("lineToShape", new String[]{null, null}, true);
        if (numPoints > 1) {
            MarkerLine line = (MarkerLine)fromShape;
            if (toShape != null) {
                Marker point = (Marker)toShape;
                Point3d startPoint = line.getPoints()[numPoints - 1];
                Point3d endPoint = point.getPoint();
                line.addLineSegment(startPoint, endPoint);
                this.updateROILineInSliceViewer(startPoint, endPoint, line);
            } else {
                Point3d currentLoc = this.position.convertCoordinateToPoint(this.viewer.getCurrentCoordinate(null, null, null, false, true, false));
                Point3d startPoint = line.getPoints()[numPoints - 1];
                line.addLineSegment(startPoint, currentLoc);
                this.updateROILineInSliceViewer(startPoint, currentLoc, line);
            }
        } else {
            Marker start = (Marker)fromShape;
            if (toShape != null) {
                Marker end = (Marker)toShape;
                Point3d startPoint = start.getPoint();
                Point3d endPoint = end.getPoint();
                int color = this.getColorIndex(start.getColorObj());
                MarkerLine ml = this.addMarkerLine(new Point3d[]{startPoint, endPoint}, color, null);
                if (this.isSyncingShapes()) {
                    this.addROILineInSliceViewer(ml);
                }
            } else {
                Point3d currentLoc = this.position.convertCoordinateToPoint(this.viewer.getCurrentCoordinate(null, null, null, false, true, false));
                boolean samePlane = this.findLinePlane(this.position.convertPointToCoordinate(currentLoc), this.position.convertPointToCoordinate(start.getPoint())) != -1;
                MarkerLine ml = this.addMarkerLine(new Point3d[]{start.getPoint(), currentLoc}, this.getColorIndex(start.getColorObj()), null);
                if (this.isSyncingShapes() && samePlane) {
                    this.addROILineInSliceViewer(ml);
                }
            }
        }
        this.updateSurface();
    }

    public void surfaceToShape(Shape fromPoint, Shape toPoint) {
        this.recordAction("surfaceToShape", new String[]{null, null}, true);
        this.drawSurfaceLine((Marker)fromPoint, (Marker)toPoint, null);
        this.updateSurface();
    }

    public void removeShape(Shape shape) {
        this.recordAction("removeShape", new String[]{null}, true);
        if (shape.getPoints().length > 1) {
            this.removeMarkerLine(((MarkerLine)shape).getNumber(), true);
        } else {
            this.removeMarker(((Marker)shape).getNumber(), true);
        }
        this.updateSurface();
    }

    public void hideAll(boolean hidden) {
        this.recordAction("hideAll", new String[]{ScriptUtils.convertBoolean(hidden)});
        Vector<CompositeSurface> shapes = this.getShapes();
        for (CompositeSurface surface : shapes) {
            if (surface.isBaseSurface()) continue;
            surface.setHidden(hidden);
        }
        for (Marker marker : this.getMarkers()) {
            marker.setVisible(!hidden);
        }
        for (MarkerLine marker : this.getMarkerLines()) {
            marker.setVisible(!hidden);
        }
        this.updateSurface();
    }

    public void removeAll() {
        this.recordAction("removeAll");
        this.setRemoveAllShapes();
        this.removeAllMarkers();
        this.removeAllMarkerLines();
        this.updateSurface();
    }

    public List<Analysis> measureAll() {
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        Vector<CompositeSurface> shapes = this.getShapes();
        Collection<MarkerLine> markerLines = this.getMarkerLines();
        for (CompositeSurface addedShape : shapes) {
            if (addedShape.isBaseSurface()) continue;
            list.addAll(this.runSurfaceAreaStats(addedShape));
            list.addAll(this.runSurfaceVolumeStats(addedShape));
        }
        for (MarkerLine ml : markerLines) {
            list.add(this.measureLine(ml));
        }
        return list;
    }

    private boolean hasTranslucentSurface() {
        for (CompositeSurface surface : this.surfaces) {
            if (!surface.getMaterial().isTransparent()) continue;
            return true;
        }
        return false;
    }

    static {
        FORMATTER = new MangoNumberFormatter(0);
        CROSSHAIR_COLOR = new Color3f((float)MangoStyle.COLOR_CROSSHAIRS_BLUE.getRed() / 255.0f, (float)MangoStyle.COLOR_CROSSHAIRS_BLUE.getGreen() / 255.0f, (float)MangoStyle.COLOR_CROSSHAIRS_BLUE.getBlue() / 255.0f);
        BETTER_GRAPHICS_SHADER_VERSION_MIN = new Version("1.0");
        BETTER_GRAPHICS_VERSION_MIN = new Version("2.1");
        VBO_VERSION_MIN = new Version("1.4");
    }
}

