/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface;

import edu.uthscsa.ric.mango.Mango;

public class SurfacePreferences {
    private boolean showCrosshairs;
    private boolean showOrientation;
    private boolean showRuler;
    private boolean showPosition;
    private boolean showShapes;
    private boolean showSlices;
    private boolean showAngle;
    private boolean usingObliqueCutPlane;
    private boolean showDynamicROI;
    private int axialCutPlane;
    private int coronalCutPlane;
    private int sagittalCutPlane;
    private int showActivePlanes;
    private final Mango mango;
    public static final boolean DEFAULT_SHOW_CROSSHAIRS = true;
    public static final boolean DEFAULT_SHOW_ORIENTATION = false;
    public static final boolean DEFAULT_SHOW_POSITION = false;
    public static final boolean DEFAULT_SHOW_SHAPES = true;
    public static final boolean DEFAULT_SHOW_SLICES = true;
    public static final boolean DEFAULT_USE_OBLIQUE = false;
    public static final boolean DEFAULT_SHOW_DYNAMIC_ROI = true;
    public static final int CUT_PLANE_DIR_NEG = -1;
    public static final int CUT_PLANE_DIR_NONE = 0;
    public static final int CUT_PLANE_DIR_POS = 1;
    public static final int DEFAULT_SHOW_PLANES = 0;
    public static final int PLANES_ALL = 2;
    public static final int PLANES_MAIN = 1;
    public static final int PLANES_NONE = 0;

    protected SurfacePreferences(Mango mango) {
        this.mango = mango;
        this.showOrientation = mango.isViewStateOrientationSurface();
        this.showCrosshairs = mango.isViewStateCrosshairs();
        this.showActivePlanes = mango.isViewStateAllPlanes() ? 2 : (mango.isViewStateMainPlane() ? 1 : 0);
        this.setDefaults();
    }

    public int getAxialCutPlane() {
        return this.axialCutPlane;
    }

    public int getCoronalCutPlane() {
        return this.coronalCutPlane;
    }

    public int getPickedOctant() {
        int pickedOctant = 0;
        if (this.sagittalCutPlane == -1) {
            pickedOctant |= 1;
        }
        if (this.coronalCutPlane == -1) {
            pickedOctant |= 2;
        }
        if (this.axialCutPlane == -1) {
            pickedOctant |= 4;
        }
        return pickedOctant;
    }

    public int getSagittalCutPlane() {
        return this.sagittalCutPlane;
    }

    public int getShowActivePlanes() {
        return this.showActivePlanes;
    }

    public boolean isShowCrosshairs() {
        return this.showCrosshairs;
    }

    public boolean isShowOrientation() {
        return this.showOrientation;
    }

    public boolean isShowPosition() {
        return this.showPosition;
    }

    public boolean isShowShapes() {
        return this.showShapes;
    }

    public boolean isShowSlices() {
        return this.showSlices;
    }

    public boolean isUsingAxialCutPlane() {
        return this.axialCutPlane != 0;
    }

    public boolean isUsingCoronalCutPlane() {
        return this.coronalCutPlane != 0;
    }

    public boolean isUsingCutPlane() {
        return this.isUsingAxialCutPlane() || this.isUsingCoronalCutPlane() || this.isUsingSagittalCutPlane();
    }

    public boolean isUsingObliqueCutPlane() {
        return this.usingObliqueCutPlane;
    }

    public boolean isUsingSagittalCutPlane() {
        return this.sagittalCutPlane != 0;
    }

    public void setAxialCutPlane(int axialCutPlane) {
        this.axialCutPlane = axialCutPlane;
    }

    public void setCoronalCutPlane(int coronalCutPlane) {
        this.coronalCutPlane = coronalCutPlane;
    }

    public void setPickedOctant(int pickedOctant) {
        if (this.isUsingAxialCutPlane()) {
            this.axialCutPlane = (pickedOctant & 4) != 0 ? -1 : 1;
        }
        if (this.isUsingCoronalCutPlane()) {
            this.coronalCutPlane = (pickedOctant & 2) != 0 ? -1 : 1;
        }
        if (this.isUsingSagittalCutPlane()) {
            this.sagittalCutPlane = (pickedOctant & 1) != 0 ? -1 : 1;
        }
    }

    public void setSagittalCutPlane(int sagittalCutPlane) {
        this.sagittalCutPlane = sagittalCutPlane;
    }

    public void setShowActivePlanes(int showActivePlanes) {
        this.showActivePlanes = showActivePlanes;
        this.mango.setViewStateAllPlanes(showActivePlanes == 2);
        this.mango.setViewStateMainPlane(showActivePlanes == 1);
    }

    public void setShowCrosshairs(boolean showCrosshairs) {
        this.showCrosshairs = showCrosshairs;
        this.mango.setViewStateCrosshairs(showCrosshairs);
    }

    public void setShowOrientation(boolean showOrientation) {
        this.showOrientation = showOrientation;
        this.mango.setViewStateOrientationSurface(showOrientation);
    }

    public void setShowPosition(boolean showPosition) {
        this.showPosition = showPosition;
    }

    public void setShowShapes(boolean showShapes) {
        this.showShapes = showShapes;
    }

    public void setShowSlices(boolean showSlices) {
        this.showSlices = showSlices;
    }

    public void setUsingObliqueCutPlane(boolean usingObliqueCutPlane) {
        this.usingObliqueCutPlane = usingObliqueCutPlane;
    }

    private void setDefaults() {
        this.showCrosshairs = true;
        this.showOrientation = false;
        this.showPosition = false;
        this.showShapes = true;
        this.showSlices = true;
        this.usingObliqueCutPlane = false;
        this.axialCutPlane = 0;
        this.coronalCutPlane = 0;
        this.sagittalCutPlane = 0;
        this.showActivePlanes = DEFAULT_SHOW_PLANES;
        this.showDynamicROI = true;
    }

    public boolean isShowRuler() {
        return this.showRuler;
    }

    public void setShowRuler(boolean showRuler) {
        this.showRuler = showRuler;
    }

    public boolean isShowAngle() {
        return this.showAngle;
    }

    public void setShowAngle(boolean showAngle) {
        this.showAngle = showAngle;
    }

    public boolean isShowDynamicROI() {
        return this.showDynamicROI;
    }

    public void setShowDynamicROI(boolean showDynamicROI) {
        this.showDynamicROI = showDynamicROI;
    }
}

