/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.window;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.core.StickyWindow;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.components.labeleditor.SeriesLabelEditor;
import edu.uthscsa.ric.mango.viewerslice.components.seriesmanager.SeriesManager;
import edu.uthscsa.ric.mango.viewerslice.core.CurrentVolumeListener;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenu;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class ViewerFrame
extends JFrame
implements CurrentVolumeListener {
    private Mango mango;
    private SliceViewer viewer;
    private SeriesLabelEditor seriesLabelEditor;
    private SeriesManager seriesManager;
    private Vector<StickyWindow> stickyWindows = new Vector();
    private ViewerMenu menu;
    private int heightDecorationSize;
    private int widthDecorationSize;
    private static final long serialVersionUID = 1L;
    public static final double INCREMENT_FACTOR = 0.1;
    public static final double ORTHOGONAL_VIEWER_RATIO = 1.5;
    public static final int MENU_BAR_HEIGHT = 22;
    public static final int MINIMUM_WIDTH = 250;

    public ViewerFrame(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
    }

    public void addSeriesLabelEditor() {
        if (this.seriesManager != null) {
            this.removeSeriesManager();
        }
        if (this.seriesLabelEditor == null) {
            this.seriesLabelEditor = new SeriesLabelEditor(this.viewer);
            this.viewer.requestFocusInWindow();
            this.getContentPane().add((Component)this.seriesLabelEditor, "South");
            this.validate();
            this.pack();
        }
    }

    public void addSeriesManager() {
        if (this.seriesLabelEditor != null) {
            this.removeSeriesLabelEditor();
        }
        if (this.seriesManager == null) {
            this.seriesManager = new SeriesManager(this.viewer);
            this.viewer.requestFocusInWindow();
            this.getContentPane().add((Component)this.seriesManager, "South");
            this.validate();
            this.pack();
        }
    }

    public void addStickyWindow(StickyWindow sticky) {
        if (!this.stickyWindows.contains(sticky)) {
            this.stickyWindows.add(sticky);
        }
    }

    public void changeSize(int currentWidth) {
        this.doNewSize(this.checkSize(currentWidth), false);
    }

    public void decrementFrameSize() {
        if (this.viewer.isOrthoWide()) {
            this.doNewSize(this.checkSize((int)Math.round((double)this.viewer.getSize().height - (double)this.viewer.getSize().height * 0.1)), false);
        } else {
            this.doNewSize(this.checkSize((int)Math.round((double)this.viewer.getSize().width - (double)this.viewer.getSize().width * 0.1)), false);
        }
    }

    public SliceViewer getOrthogonalViewer() {
        return this.viewer;
    }

    public SliceViewer getViewer() {
        return this.viewer;
    }

    public ViewerMenu getViewerMenu() {
        return this.menu;
    }

    public void incrementFrameSize() {
        if (this.viewer.isOrthoWide()) {
            this.doNewSize(this.checkSize((int)Math.round((double)this.viewer.getSize().height + (double)this.viewer.getSize().height * 0.1)), false);
        } else {
            this.doNewSize(this.checkSize((int)Math.round((double)this.viewer.getSize().width + (double)this.viewer.getSize().width * 0.1)), false);
        }
    }

    public void maximize() {
        this.doNewSize(this.checkSize(Integer.MAX_VALUE), false);
        this.setLocation(new Point(this.getLocation().x, DisplayUtils.findInsetsOfDisplay((int)DisplayUtils.findCurrentDisplayIndex((Component)this)).top));
    }

    public void removeStickyWindow(StickyWindow sticky) {
        this.stickyWindows.remove(sticky);
    }

    private int checkSize(int currentWidthVal) {
        int currentWidth = currentWidthVal;
        if (this.heightDecorationSize == 0) {
            this.heightDecorationSize = this.getSize().height - this.viewer.getSize().height;
        }
        if (this.widthDecorationSize == 0) {
            this.widthDecorationSize = this.getSize().width - this.viewer.getSize().width;
        }
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(this);
        Dimension displaySize = DisplayUtils.findSizeOfDisplay(displayIndex);
        Insets displayInsets = DisplayUtils.findInsetsOfDisplay(displayIndex);
        int displayHeight = displaySize.height - (displayInsets.top + displayInsets.bottom);
        int maxOrthoTallWidth = (int)Math.round((double)(displayHeight - this.heightDecorationSize) / 1.5);
        int maxOrthoWideWidth = (int)Math.round((double)(displayHeight - this.heightDecorationSize) * 1.5);
        int maxSingleWidth = displayHeight - this.heightDecorationSize;
        if (this.viewer.isSingleSliceMode()) {
            if (currentWidth > maxSingleWidth) {
                currentWidth = maxSingleWidth;
            } else if (currentWidth < 250) {
                currentWidth = 250;
            }
        } else if (this.viewer.isOrthoWide()) {
            if ((double)currentWidth > (double)maxOrthoWideWidth / 1.5) {
                currentWidth = (int)((double)maxOrthoWideWidth / 1.5);
            } else if (currentWidth < 250) {
                currentWidth = 250;
            }
        } else if (currentWidth > maxOrthoTallWidth) {
            currentWidth = maxOrthoTallWidth;
        } else if (currentWidth < 250) {
            currentWidth = 250;
        }
        return currentWidth;
    }

    private void doNewSize(int currentWidth, boolean doPack) {
        int longDim = (int)((double)currentWidth * 1.5);
        int orthoFrameTallHeight = longDim + this.heightDecorationSize;
        int orthoFrameTallWidth = currentWidth + this.widthDecorationSize;
        int orthoFrameWideHeight = currentWidth + this.heightDecorationSize;
        int orthoFrameWideWidth = longDim + this.widthDecorationSize;
        int singleFrameHeight = currentWidth + this.heightDecorationSize;
        if (doPack) {
            this.updateViewerSize(currentWidth, longDim);
            this.pack();
        } else {
            if (this.viewer.isSingleSliceMode()) {
                this.setSize(new Dimension(currentWidth + this.widthDecorationSize, singleFrameHeight));
            } else if (this.viewer.isOrthoWide()) {
                this.setSize(new Dimension(orthoFrameWideWidth, orthoFrameWideHeight));
            } else {
                this.setSize(new Dimension(orthoFrameTallWidth, orthoFrameTallHeight));
            }
            this.updateViewerSize(currentWidth, longDim);
        }
    }

    private void doSticky(StickyWindow sticky, int index) {
        Point viewerLoc = this.getLocation();
        Dimension viewerDim = this.getSize();
        sticky.getFrame().setLocation(viewerLoc.x + viewerDim.width + 16 + index * 8, viewerLoc.y + index * 8);
    }

    private void updateMenu(boolean isInSwingThread) {
        if (isInSwingThread) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (ViewerFrame.this.menu != null) {
                        ViewerFrame.this.menu.updateMenu();
                    }
                }
            };
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
        } else if (this.menu != null) {
            this.menu.updateMenu();
        }
    }

    private void updateViewerSize(int smallDim, int longDim) {
        if (this.viewer.isSingleSliceMode()) {
            this.viewer.setPreferredSize(new Dimension(smallDim, smallDim));
        } else if (this.viewer.isOrthoWide()) {
            this.viewer.setPreferredSize(new Dimension(longDim, smallDim));
        } else {
            this.viewer.setPreferredSize(new Dimension(smallDim, longDim));
        }
        this.viewer.setMinimumSize(this.viewer.getPreferredSize());
        this.viewer.setMaximumSize(this.viewer.getPreferredSize());
        this.viewer.calculateScreenSliceTransforms();
        this.viewer.updateViewer();
    }

    public void clear() {
        this.viewer.removeCurrentVolumeListener(this);
        this.viewer = null;
        this.mango = null;
        this.menu.clear();
        this.menu = null;
        this.stickyWindows.clear();
        this.stickyWindows = null;
        this.setVisible(false);
        this.dispose();
    }

    public void doAllStickies() {
        Iterator<StickyWindow> it = this.stickyWindows.iterator();
        int index = 0;
        while (it.hasNext()) {
            StickyWindow sticky = it.next();
            if (!sticky.isSticky()) continue;
            this.doSticky(sticky, index++);
        }
    }

    public void initialize() {
        this.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.getRootPane().setDoubleBuffered(true);
        this.getRootPane().setOpaque(true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent we) {
                if (ViewerFrame.this.viewer != null) {
                    ViewerFrame.this.mango.setCurrentViewer(ViewerFrame.this.viewer);
                    Mango.getInstance().getToolBox().setCurrentViewer(ViewerFrame.this.viewer);
                    Mango.getInstance().getToolBox().updateFocusState();
                    Mango.getInstance().getToolBox().updateEnabledItems();
                    if (ViewerFrame.this.viewer.isReady()) {
                        Mango.getInstance().getToolBox().updateMouseLabelInfo();
                    }
                    ViewerFrame.this.updateMenu();
                    ViewerFrame.this.viewer.updateMainImageCursor();
                    ViewerFrame.this.viewer.repaint();
                    if (we.getOppositeWindow() instanceof ViewerFrame && we.getOppositeWindow() != ViewerFrame.this) {
                        SliceViewer oppViewer;
                        ViewerFrame oppFrame = (ViewerFrame)we.getOppositeWindow();
                        if (oppFrame.isVisible() && ViewerFrame.this.getSize().equals(oppFrame.getSize()) && (oppViewer = oppFrame.getViewer()) != null && !oppViewer.isDead()) {
                            Point compPosition = oppViewer.getCursorPosition();
                            Robot robot = null;
                            try {
                                robot = new Robot();
                            }
                            catch (Exception ex) {
                                AppLogger.error((Throwable)ex);
                            }
                            if (compPosition != null && robot != null) {
                                Point screenPosition = ViewerFrame.this.viewer.getPositionRelativeToMainSlice(compPosition);
                                robot.mouseMove(screenPosition.x, screenPosition.y);
                            }
                        }
                    } else if (!OpenFileDialog.isOpen() && !SaveFileDialog.isOpen()) {
                        ViewerFrame.this.viewer.getToolBox().toFront();
                    }
                    ViewerFrame.this.viewer.addCurrentVolumeListener(ViewerFrame.this);
                    ViewerFrame.this.updateSeriesManager();
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (ViewerFrame.this.viewer != null) {
                    ViewerFrame.this.viewer.close();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent we) {
                Mango.getInstance().getToolBox().updateTextFields();
                Mango.getInstance().getToolBox().closePopups();
                if (ViewerFrame.this.viewer != null) {
                    ViewerFrame.this.viewer.repaint();
                }
            }

            @Override
            public void windowDeiconified(WindowEvent we) {
                Mango.getInstance().getToolBox().setState(0);
                Mango.getInstance().getToolBox().toFront();
                Mango.getInstance().getToolBox().updateFocusState();
                Mango.getInstance().getToolBox().updateEnabledItems();
            }

            @Override
            public void windowIconified(WindowEvent we) {
                Mango.getInstance().getToolBox().updateFocusState();
                Mango.getInstance().getToolBox().updateEnabledItems();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent ce) {
                ViewerFrame.this.doAllStickies();
            }
        });
        this.menu = new ViewerMenu(this.mango, this.viewer);
        JMenuBar menuBar = this.menu.getMenuBar();
        menuBar.setPreferredSize(new Dimension(menuBar.getPreferredSize().width, 22));
        this.setJMenuBar(menuBar);
        this.getContentPane().add((Component)this.viewer, "Center");
        if (this.viewer.isOrthoWide()) {
            this.doNewSize(this.checkSize((int)((double)this.viewer.getStartSize().width / 1.5)), this.heightDecorationSize == 0);
        } else {
            this.doNewSize(this.checkSize(this.viewer.getStartSize().width), this.heightDecorationSize == 0);
        }
        this.menu.updateMenu();
        this.viewer.updateWindowTitle();
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setLocation(this.viewer.getStartLocation());
        this.setVisible(true);
        this.viewer.calculateScreenSliceTransforms();
        this.repaint();
        this.getRootPane().setFocusable(false);
        this.getRootPane().setRequestFocusEnabled(false);
        if (this.isActive()) {
            this.mango.setCurrentViewer(this.viewer);
            Mango.getInstance().getToolBox().setCurrentViewer(this.viewer);
        }
        this.viewer.frameCreated();
    }

    public void removeSeriesLabelEditor() {
        if (this.seriesLabelEditor != null) {
            this.getContentPane().remove(this.seriesLabelEditor);
            this.seriesLabelEditor = null;
            this.validate();
            this.pack();
        }
        if (this.viewer.hasTimeseries()) {
            this.addSeriesManager();
            this.seriesManager.setInitialized(true);
            this.seriesManager.updateSeriesManager();
        }
    }

    public void removeSeriesManager() {
        if (this.seriesManager != null) {
            this.getContentPane().remove(this.seriesManager);
            this.seriesManager = null;
            this.validate();
            this.pack();
        }
    }

    public void updateLabelSeriesEditor() {
        if (this.seriesLabelEditor != null) {
            this.seriesLabelEditor.updateEditor();
        }
    }

    public void updateSeriesManager() {
        if (this.seriesManager != null) {
            if (!this.viewer.hasTimeseries()) {
                this.removeSeriesManager();
            }
        } else if (this.seriesLabelEditor == null && this.viewer.hasTimeseries()) {
            this.addSeriesManager();
        }
        if (this.seriesManager != null) {
            this.seriesManager.updateSeriesManager();
        }
    }

    public void updateMenu() {
        this.updateMenu(false);
    }

    public boolean isShowingLabelSeriesEditor() {
        return this.seriesLabelEditor != null;
    }

    @Override
    public void currentVolumeChanged() {
        if (this.viewer.getCurrentVolume().getNumTimepoints() > 1) {
            this.updateSeriesManager();
        } else {
            this.removeSeriesManager();
        }
    }
}

