/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.screen.lut;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LUT;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableKnot;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import java.awt.Color;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class LookupTableManager {
    private ByteLookupTable lut;
    private LookupTableKnot knotMax;
    private LookupTableKnot knotMin;
    private LookupTableKnot[] knots;
    private String expression;
    private String name;
    private boolean isBaseImage;
    private byte[] lutArrayA;
    private byte[] lutArrayB;
    private byte[] lutArrayG;
    private byte[] lutArrayR;
    private double[] expressionValues;
    private double[] knotRangeRatios;
    private double[] knotThresholds;
    private int alpha;
    private int alphaMin;
    private int maxLUT;
    private int minLUT;
    private static Vector<LUT> allLUTs;
    private static AtomicReference<Integer> lastSetAlpha;
    protected LookupOp lutOp;
    public static final LookupTableManager DEFAULT_LUT;
    public static final String EXPORT_COMMENT = "Mango Color LUT";
    public static final String EXPORT_EXPRESSION = "Expression";
    public static final String EXPORT_KNOT = "Knot";
    public static final String EXPORT_NAME = "Name";
    public static final String EXPORT_NUMBER_OF_KNOTS = "NumberOfKnots";
    public static final String TYPE_BLUE_NAME = "Blue";
    public static final String TYPE_COMPRESSOR_NAME = "Grayscale (Compressed)";
    public static final String TYPE_GOLD_NAME = "Gold";
    public static final String TYPE_GREEN_NAME = "Green";
    public static final String TYPE_GREYSCALE_NAME = "Grayscale";
    public static final String TYPE_HOT2COLD_NAME = "Hot-and-Cold";
    public static final String TYPE_INVERTED_NAME = "Grayscale (Inverted)";
    public static final String TYPE_OVERLAY1_NAME = "Red Overlay";
    public static final String TYPE_OVERLAY2_NAME = "Green Overlay";
    public static final String TYPE_OVERLAY3_NAME = "Blue Overlay";
    public static final String TYPE_OVERLAY_NEGATIVES_NAME = "Overlay (Negatives)";
    public static final String TYPE_OVERLAY_POSITIVES_NAME = "Overlay (Positives)";
    public static final String TYPE_RED_NAME = "Red";
    public static final String TYPE_SPECTRUM_BW_NAME = "Spectrum";
    public static final String TYPE_FIRE_NAME = "Fire";
    public static final List<String> NAMES;
    public static final List<String> NAMES_PAPAYA_COMPATIBLE;
    public static final int LUT_MAX = 255;
    public static final int LUT_MIN = 0;
    public static final int TYPE_BLUE = 10;
    public static final int TYPE_COMPRESSOR = 2;
    public static final int TYPE_GOLD = 13;
    public static final int TYPE_GREEN = 9;
    public static final int TYPE_GREYSCALE = 0;
    public static final int TYPE_HOT2COLD = 12;
    public static final int TYPE_INVERTED = 1;
    public static final int TYPE_OVERLAY1 = 3;
    public static final int TYPE_OVERLAY2 = 4;
    public static final int TYPE_OVERLAY3 = 5;
    public static final int TYPE_OVERLAY_NEGATIVES = 7;
    public static final int TYPE_OVERLAY_POSITIVES = 6;
    public static final int TYPE_RED = 8;
    public static final int TYPE_SPECTRUM_BW = 11;
    public static final int TYPE_FIRE = 14;

    public static void clearLastAlpha() {
        lastSetAlpha.set(255);
    }

    public static LookupTableManager createLookupTableManager(int type, boolean baseImage) {
        if (type == 0) {
            return new LookupTableManager(NAMES.get(0), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 1) {
            return new LookupTableManager(NAMES.get(1), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 1.0, 1.0, 1.0, true), new LookupTableKnot(1.0, 0.0, 0.0, 0.0, false)});
        }
        if (type == 2) {
            LookupTableManager ltm = new LookupTableManager(NAMES.get(2), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
            ltm.setExpression("(1 - pow(2.71828, -5 * value)) / (1 - pow(2.71828, -5))");
            return ltm;
        }
        if (type == 13) {
            return new LookupTableManager(NAMES.get(13), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(0.13, 0.19, 0.03, 0.0, true), new LookupTableKnot(0.25, 0.39, 0.12, 0.0, true), new LookupTableKnot(0.38, 0.59, 0.26, 0.0, true), new LookupTableKnot(0.5, 0.8, 0.46, 0.08, true), new LookupTableKnot(0.63, 0.99, 0.71, 0.21, true), new LookupTableKnot(0.75, 0.99, 0.88, 0.34, true), new LookupTableKnot(0.88, 0.99, 0.99, 0.48, true), new LookupTableKnot(1.0, 0.9, 0.95, 0.61, false)});
        }
        if (type == 3) {
            return new LookupTableManager(NAMES.get(3), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.75, 0.0, 0.0, true), new LookupTableKnot(0.5, 1.0, 0.5, 0.0, true), new LookupTableKnot(0.95, 1.0, 1.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 4) {
            return new LookupTableManager(NAMES.get(4), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.75, 0.0, true), new LookupTableKnot(0.5, 0.5, 1.0, 0.0, true), new LookupTableKnot(0.95, 1.0, 1.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 5) {
            return new LookupTableManager(NAMES.get(5), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 1.0, true), new LookupTableKnot(0.5, 0.0, 0.5, 1.0, true), new LookupTableKnot(0.95, 0.0, 1.0, 1.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 6) {
            return new LookupTableManager(NAMES.get(6), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 1.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 0.0, false)});
        }
        if (type == 7) {
            return new LookupTableManager(NAMES.get(7), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 1.0, true), new LookupTableKnot(1.0, 0.0, 1.0, 0.0, false)});
        }
        if (type == 8) {
            return new LookupTableManager(NAMES.get(8), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 1.0, 0.0, 0.0, false), new LookupTableKnot(1.0, 1.0, 0.0, 0.0, false)});
        }
        if (type == 9) {
            return new LookupTableManager(NAMES.get(9), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 1.0, 0.0, false), new LookupTableKnot(1.0, 0.0, 1.0, 0.0, false)});
        }
        if (type == 10) {
            return new LookupTableManager(NAMES.get(10), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 1.0, false), new LookupTableKnot(1.0, 0.0, 0.0, 1.0, false)});
        }
        if (type == 11) {
            return new LookupTableManager(NAMES.get(11), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(0.1, 0.0, 0.0, 1.0, true), new LookupTableKnot(0.33, 0.0, 1.0, 1.0, true), new LookupTableKnot(0.5, 0.0, 1.0, 0.0, true), new LookupTableKnot(0.66, 1.0, 1.0, 0.0, true), new LookupTableKnot(0.9, 1.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 12) {
            return new LookupTableManager(NAMES.get(12), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 1.0, true), new LookupTableKnot(0.15, 0.0, 1.0, 1.0, true), new LookupTableKnot(0.3, 0.0, 1.0, 0.0, true), new LookupTableKnot(0.45, 0.0, 0.0, 0.0, false), new LookupTableKnot(0.5, 0.0, 0.0, 0.0, false), new LookupTableKnot(0.55, 0.0, 0.0, 0.0, true), new LookupTableKnot(0.7, 1.0, 1.0, 0.0, true), new LookupTableKnot(0.85, 1.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        if (type == 14) {
            return new LookupTableManager(NAMES.get(14), baseImage, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(0.06, 0.0, 0.0, 0.36, true), new LookupTableKnot(0.16, 0.29, 0.0, 0.75, true), new LookupTableKnot(0.22, 0.48, 0.0, 0.89, false), new LookupTableKnot(0.31, 0.68, 0.0, 0.6, false), new LookupTableKnot(0.37, 0.76, 0.0, 0.36, true), new LookupTableKnot(0.5, 0.94, 0.31, 0.0, true), new LookupTableKnot(0.56, 1.0, 0.45, 0.0, true), new LookupTableKnot(0.81, 1.0, 0.91, 0.0, true), new LookupTableKnot(0.88, 1.0, 1.0, 0.38, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        }
        return null;
    }

    public static int findIndex(String name) {
        for (int ctr = 0; ctr < NAMES.size(); ++ctr) {
            if (!NAMES.get(ctr).equals(name)) continue;
            return ctr;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupTableManager readLUT(URI uri) {
        LookupTableManager lut = null;
        InputStream input = null;
        try {
            ArrayList<LookupTableKnot> knots = new ArrayList<LookupTableKnot>();
            input = FileUtilities.getInputStream((URI)uri, (boolean)false);
            Properties props = new Properties();
            props.load(input);
            String name = props.getProperty(EXPORT_NAME);
            String numKnotsStr = props.getProperty(EXPORT_NUMBER_OF_KNOTS);
            if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)numKnotsStr)) {
                name = name.trim();
                int numKnots = Integer.parseInt(numKnotsStr.trim());
                String expression = props.getProperty(EXPORT_EXPRESSION);
                for (int ctr = 0; ctr < numKnots; ++ctr) {
                    String knot = props.getProperty(EXPORT_KNOT + ctr);
                    StringTokenizer st = new StringTokenizer(knot);
                    double value = Double.parseDouble(st.nextToken());
                    int red = Integer.parseInt(st.nextToken());
                    int green = Integer.parseInt(st.nextToken());
                    int blue = Integer.parseInt(st.nextToken());
                    boolean isGradient = false;
                    if (st.hasMoreTokens()) {
                        isGradient = Integer.parseInt(st.nextToken()) == 1;
                    }
                    LookupTableKnot knot2 = new LookupTableKnot();
                    knot2.setVal(value);
                    knot2.setRed(red);
                    knot2.setGreen(green);
                    knot2.setBlue(blue);
                    knot2.setGradient(isGradient);
                    knots.add(knot2);
                }
                Collections.sort(knots);
                lut = new LookupTableManager(name, false, knots.toArray(new LookupTableKnot[knots.size()]));
                lut.setExpression(expression);
            } else {
                lut = LookupTableManager.readLUTOldFormat(new File(uri));
            }
            if (lut == null) {
                AppLogger.warn((String)("Could not read that color table (" + uri.toString() + ")!"));
            }
        }
        catch (IOException ex) {
            if (FileUtilities.uriIsFile((URI)uri)) {
                lut = LookupTableManager.readLUTOldFormat(new File(uri));
            }
            if (lut == null) {
                AppLogger.error((Throwable)ex);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return lut;
    }

    public String makePapayaLUT() {
        StringBuffer sb = new StringBuffer(32);
        boolean multiple = false;
        sb.append("{name:\"" + this.getName() + "\",data:[");
        for (LookupTableKnot knot : this.knots) {
            if (multiple) {
                sb.append(',');
            } else {
                multiple = true;
            }
            sb.append('[');
            sb.append(knot.val + "," + (double)knot.rVal / 255.0 + "," + (double)knot.gVal / 255.0 + "," + (double)knot.bVal / 255.0);
            sb.append(']');
        }
        sb.append("]}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLUT(String lutName, LUT lut, File lutFile) {
        LookupTableKnot[] someKnots = lut.getKnots();
        String expression = lut.getExpression();
        FilterOutputStream output = null;
        try {
            Properties props = new Properties();
            props.setProperty(EXPORT_NAME, lutName);
            props.setProperty(EXPORT_NUMBER_OF_KNOTS, String.valueOf(someKnots.length));
            if (expression != null) {
                props.setProperty(EXPORT_EXPRESSION, expression);
            }
            for (int ctr = 0; ctr < someKnots.length; ++ctr) {
                props.setProperty(EXPORT_KNOT + ctr, someKnots[ctr].toString());
            }
            output = new BufferedOutputStream(new FileOutputStream(lutFile));
            props.store(output, EXPORT_COMMENT);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LookupTableManager readLUTOldFormat(File file) {
        BufferedReader reader = null;
        String line = null;
        LookupTableKnot[] knots = null;
        String lutName = null;
        String expression = null;
        LookupTableManager lut = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            line = reader.readLine();
            if (line != null) {
                int nameIndex = line.indexOf("Name=");
                int firstQuoteIndex = nameIndex + 5;
                int lastQuoteIndex = line.indexOf("\"", firstQuoteIndex + 1);
                lutName = line.substring(firstQuoteIndex + 1, lastQuoteIndex);
                int expressionIndex = line.indexOf(EXPORT_EXPRESSION);
                if (expressionIndex != -1) {
                    firstQuoteIndex = line.indexOf("\"", expressionIndex);
                    lastQuoteIndex = line.indexOf("\"", firstQuoteIndex + 1);
                    expression = line.substring(firstQuoteIndex + 1, lastQuoteIndex);
                }
                int numKnotsStartIndex = line.indexOf("NumberOfKnots=") + 14;
                int numKnotsEndIndex = line.indexOf(" ", numKnotsStartIndex);
                int numKnots = Integer.parseInt(line.substring(numKnotsStartIndex, numKnotsEndIndex));
                knots = new LookupTableKnot[numKnots];
                double val = 0.0;
                int blue = 0;
                int green = 0;
                int red = 0;
                boolean gradient = false;
                int lastKnotIndex = 0;
                for (int ctrKnots = 0; ctrKnots < numKnots; ++ctrKnots) {
                    int knotIndex = line.indexOf("Knot[", lastKnotIndex + 1);
                    int valIndex = line.indexOf("V", knotIndex);
                    int redIndex = line.indexOf("R", knotIndex);
                    int greenIndex = line.indexOf("G", knotIndex);
                    int blueIndex = line.indexOf("B", knotIndex);
                    int gradientIndex = line.indexOf("GRAD", knotIndex);
                    int endIndex = line.indexOf("]", knotIndex);
                    val = Double.parseDouble(line.substring(valIndex + 2, redIndex - 1));
                    red = Integer.parseInt(line.substring(redIndex + 2, greenIndex - 1));
                    green = Integer.parseInt(line.substring(greenIndex + 2, blueIndex - 1));
                    blue = Integer.parseInt(line.substring(blueIndex + 2, gradientIndex - 1));
                    gradient = Boolean.parseBoolean(line.substring(gradientIndex + 5, endIndex));
                    knots[ctrKnots] = new LookupTableKnot();
                    knots[ctrKnots].setVal(val);
                    knots[ctrKnots].setRed(red);
                    knots[ctrKnots].setGreen(green);
                    knots[ctrKnots].setBlue(blue);
                    knots[ctrKnots].setGradient(gradient);
                    lastKnotIndex = knotIndex;
                    lut = new LookupTableManager(lutName, false, knots);
                    lut.setExpression(expression);
                }
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return lut;
    }

    public LookupTableManager(String name, boolean baseImage, LookupTableKnot[] someKnots) {
        this.name = name;
        this.initializeManager(baseImage, someKnots);
    }

    public synchronized int getAlpha() {
        return this.alpha;
    }

    public String getExpression() {
        return this.expression;
    }

    public LookupTableKnot[] getKnots() {
        return this.knots;
    }

    public LookupOp getLookupOp() {
        return this.lutOp;
    }

    public LookupTable getLookupTable() {
        return this.lut;
    }

    public Color getMaximumColor() {
        return new Color((float)this.lookupRed(255) / 255.0f, (float)this.lookupGreen(255) / 255.0f, (float)this.lookupBlue(255) / 255.0f);
    }

    public int getMaxLUT() {
        return this.maxLUT;
    }

    public Color getMinimumColor() {
        return new Color((float)this.lookupRed(0) / 255.0f, (float)this.lookupGreen(0) / 255.0f, (float)this.lookupBlue(0) / 255.0f);
    }

    public Color getMinimumColor2() {
        return new Color((float)this.lookupRed(32) / 255.0f, (float)this.lookupGreen(32) / 255.0f, (float)this.lookupBlue(32) / 255.0f);
    }

    public int getMinLUT() {
        return this.minLUT;
    }

    public String getName() {
        return this.name;
    }

    public LookupOp getOp() {
        return this.lutOp;
    }

    public Color getTestColor() {
        return new Color((float)this.lookupRed(5) / 255.0f, (float)this.lookupGreen(5) / 255.0f, (float)this.lookupBlue(5) / 255.0f);
    }

    public void initLUT() {
        this.minLUT = 0;
        this.maxLUT = 255;
        byte[][] lutArray = new byte[4][];
        boolean useBigEndian = ByteOrder.nativeOrder().toString().equals("BIG_ENDIAN");
        if (Platform.UNIX && Platform.JAVA7) {
            useBigEndian = !useBigEndian;
        } else if (Platform.MAC && Platform.JAVA7) {
            boolean bl = useBigEndian = !useBigEndian;
        }
        if (useBigEndian) {
            this.lutArrayG = new byte[256];
            lutArray[0] = this.lutArrayG;
            this.lutArrayR = new byte[256];
            lutArray[1] = this.lutArrayR;
            this.lutArrayA = new byte[256];
            lutArray[2] = this.lutArrayA;
            this.lutArrayB = new byte[256];
            lutArray[3] = this.lutArrayB;
        } else {
            this.lutArrayG = new byte[256];
            lutArray[1] = this.lutArrayG;
            this.lutArrayR = new byte[256];
            lutArray[0] = this.lutArrayR;
            this.lutArrayA = new byte[256];
            lutArray[3] = this.lutArrayA;
            this.lutArrayB = new byte[256];
            lutArray[2] = this.lutArrayB;
        }
        this.lut = new ByteLookupTable(0, lutArray);
        this.lutOp = new LookupOp(this.lut, null);
        this.updateLUT(this.maxLUT, this.minLUT, true);
    }

    public int lookupBlue(int index) {
        if (index >= 0 && index < 256) {
            return this.lutArrayB[index] & 0xFF;
        }
        return 0;
    }

    public int lookupGreen(int index) {
        if (index >= 0 && index < 256) {
            return this.lutArrayG[index] & 0xFF;
        }
        return 0;
    }

    public int lookupRed(int index) {
        if (index >= 0 && index < 256) {
            return this.lutArrayR[index] & 0xFF;
        }
        return 0;
    }

    public void replaceKnots(LookupTableKnot[] someKnots) {
        this.knots = someKnots;
        this.knotThresholds = new double[this.knots.length];
        this.knotRangeRatios = new double[this.knots.length - 1];
        this.knotMin = this.knots[0];
        this.knotMax = this.knots[this.knots.length - 1];
    }

    public void setAlpha(int val) {
        if (this.isBaseImage) {
            this.alpha = 255;
        } else {
            this.alpha = val;
            lastSetAlpha.set(val);
        }
        this.updateLUT();
    }

    public void setExpression(String string) {
        if (this.knots.length > 2) {
            this.expression = null;
            this.expressionValues = null;
        } else {
            this.expression = string;
            if (this.expression != null) {
                this.updateExpressionValues();
            } else {
                this.expressionValues = null;
            }
        }
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String toString() {
        return this.name;
    }

    public void updateLUT() {
        this.updateLUT(this.maxLUT, this.minLUT, true);
    }

    public void updateLUT(int maxLUTnew, int minLUTnew) {
        this.updateLUT(maxLUTnew, minLUTnew, false);
    }

    public void updateLUT(int maxLUTnew, int minLUTnew, boolean forceDoBoth) {
        if (maxLUTnew == this.maxLUT && minLUTnew == this.minLUT && !forceDoBoth) {
            return;
        }
        if (maxLUTnew == this.maxLUT && minLUTnew != this.minLUT && !forceDoBoth) {
            this.updateMinLUT(minLUTnew);
        } else if (maxLUTnew != this.maxLUT && minLUTnew == this.minLUT && !forceDoBoth) {
            this.updateMaxLUT(maxLUTnew);
        } else {
            int ctr;
            this.maxLUT = maxLUTnew;
            this.minLUT = minLUTnew;
            double range = this.maxLUT - this.minLUT;
            for (ctr = 0; ctr < this.knots.length; ++ctr) {
                this.knotThresholds[ctr] = this.knots[ctr].val * range + (double)this.minLUT;
            }
            for (ctr = 0; ctr < this.knots.length - 1; ++ctr) {
                this.knotRangeRatios[ctr] = 255.0 / (this.knotThresholds[ctr + 1] - this.knotThresholds[ctr]);
            }
            for (ctr = 0; ctr < 256; ++ctr) {
                double valueG;
                double valueB;
                if (ctr <= this.minLUT) {
                    if (this.expressionValues != null) {
                        valueG = valueB = this.expressionValues[0];
                        double valueR = valueB;
                        this.lutArrayA[ctr] = (byte)this.alphaMin;
                        this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[0].rVal + valueR * (double)this.knots[1].rVal);
                        this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[0].gVal + valueG * (double)this.knots[1].gVal);
                        this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[0].bVal + valueB * (double)this.knots[1].bVal);
                        continue;
                    }
                    this.lutArrayA[ctr] = (byte)this.alphaMin;
                    this.lutArrayR[ctr] = (byte)this.knotMin.rVal;
                    this.lutArrayG[ctr] = (byte)this.knotMin.gVal;
                    this.lutArrayB[ctr] = (byte)this.knotMin.bVal;
                    continue;
                }
                if (ctr > this.maxLUT) {
                    if (this.expressionValues != null) {
                        valueG = valueB = this.expressionValues[255];
                        double valueR = valueB;
                        this.lutArrayA[ctr] = (byte)this.alpha;
                        this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[0].rVal + valueR * (double)this.knots[1].rVal);
                        this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[0].gVal + valueG * (double)this.knots[1].gVal);
                        this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[0].bVal + valueB * (double)this.knots[1].bVal);
                        continue;
                    }
                    this.lutArrayA[ctr] = (byte)this.alpha;
                    this.lutArrayR[ctr] = (byte)this.knotMax.rVal;
                    this.lutArrayG[ctr] = (byte)this.knotMax.gVal;
                    this.lutArrayB[ctr] = (byte)this.knotMax.bVal;
                    continue;
                }
                for (int ctrKnot = 0; ctrKnot < this.knots.length - 1; ++ctrKnot) {
                    if (!((double)ctr > this.knotThresholds[ctrKnot]) || !((double)ctr <= this.knotThresholds[ctrKnot + 1])) continue;
                    if (this.knots[ctrKnot].useGradation || this.expressionValues != null) {
                        double valueR;
                        double valueG2;
                        double valueB2;
                        if (this.expressionValues != null) {
                            valueG2 = valueB2 = this.expressionValues[(int)((double)(ctr - this.minLUT) * this.knotRangeRatios[0] + 0.5)];
                            valueR = valueB2;
                        } else {
                            valueR = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                            valueG2 = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                            valueB2 = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                        }
                        this.lutArrayA[ctr] = (byte)this.alpha;
                        this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[ctrKnot].rVal + valueR * (double)this.knots[ctrKnot + 1].rVal);
                        this.lutArrayG[ctr] = (byte)((1.0 - valueG2) * (double)this.knots[ctrKnot].gVal + valueG2 * (double)this.knots[ctrKnot + 1].gVal);
                        this.lutArrayB[ctr] = (byte)((1.0 - valueB2) * (double)this.knots[ctrKnot].bVal + valueB2 * (double)this.knots[ctrKnot + 1].bVal);
                        continue;
                    }
                    this.lutArrayA[ctr] = (byte)this.alpha;
                    this.lutArrayR[ctr] = (byte)this.knots[ctrKnot].rVal;
                    this.lutArrayG[ctr] = (byte)this.knots[ctrKnot].gVal;
                    this.lutArrayB[ctr] = (byte)this.knots[ctrKnot].bVal;
                }
            }
        }
    }

    private void initializeManager(boolean baseImage, LookupTableKnot[] someKnots) {
        this.isBaseImage = baseImage;
        this.alpha = this.isBaseImage || lastSetAlpha.get() == 0 ? 255 : lastSetAlpha.get();
        this.alphaMin = this.isBaseImage ? 255 : 0;
        this.replaceKnots(someKnots);
    }

    private void updateExpressionValues() {
        if (this.expressionValues == null) {
            this.expressionValues = new double[256];
        }
        StringBuffer operationString = new StringBuffer(this.expression);
        double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
        ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null, true);
        for (int ctr = 0; ctr < 256; ++ctr) {
            double temp = startNode.getLookupTableResultAtIndex(ctr, 0, 0, 0);
            if (temp > 1.0) {
                temp = 1.0;
            } else if (temp < 0.0) {
                temp = 0.0;
            }
            this.expressionValues[ctr] = temp;
        }
    }

    private void updateMaxLUT(int maxLUTnew) {
        int ctr;
        this.maxLUT = maxLUTnew;
        double range = this.maxLUT - this.minLUT;
        for (ctr = 0; ctr < this.knots.length; ++ctr) {
            this.knotThresholds[ctr] = this.knots[ctr].val * range + (double)this.minLUT;
        }
        for (ctr = 0; ctr < this.knots.length - 1; ++ctr) {
            this.knotRangeRatios[ctr] = 255.0 / (this.knotThresholds[ctr + 1] - this.knotThresholds[ctr]);
        }
        for (ctr = 0; ctr < 256; ++ctr) {
            if (ctr > this.maxLUT) {
                if (this.expressionValues != null) {
                    double valueB;
                    double valueG = valueB = this.expressionValues[255];
                    double valueR = valueB;
                    this.lutArrayA[ctr] = (byte)this.alpha;
                    this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[0].rVal + valueR * (double)this.knots[1].rVal);
                    this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[0].gVal + valueG * (double)this.knots[1].gVal);
                    this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[0].bVal + valueB * (double)this.knots[1].bVal);
                    continue;
                }
                this.lutArrayA[ctr] = (byte)this.alpha;
                this.lutArrayR[ctr] = (byte)this.knotMax.rVal;
                this.lutArrayG[ctr] = (byte)this.knotMax.gVal;
                this.lutArrayB[ctr] = (byte)this.knotMax.bVal;
                continue;
            }
            for (int ctrKnot = 0; ctrKnot < this.knots.length - 1; ++ctrKnot) {
                if (!((double)ctr > this.knotThresholds[ctrKnot]) || !((double)ctr <= this.knotThresholds[ctrKnot + 1])) continue;
                if (this.knots[ctrKnot].useGradation || this.expressionValues != null) {
                    double valueR;
                    double valueG;
                    double valueB;
                    if (this.expressionValues != null) {
                        valueG = valueB = this.expressionValues[(int)((double)(ctr - this.minLUT) * this.knotRangeRatios[0] + 0.5)];
                        valueR = valueB;
                    } else {
                        valueR = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                        valueG = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                        valueB = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                    }
                    this.lutArrayA[ctr] = (byte)this.alpha;
                    this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[ctrKnot].rVal + valueR * (double)this.knots[ctrKnot + 1].rVal);
                    this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[ctrKnot].gVal + valueG * (double)this.knots[ctrKnot + 1].gVal);
                    this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[ctrKnot].bVal + valueB * (double)this.knots[ctrKnot + 1].bVal);
                    continue;
                }
                this.lutArrayA[ctr] = (byte)this.alpha;
                this.lutArrayR[ctr] = (byte)this.knots[ctrKnot].rVal;
                this.lutArrayG[ctr] = (byte)this.knots[ctrKnot].gVal;
                this.lutArrayB[ctr] = (byte)this.knots[ctrKnot].bVal;
            }
        }
    }

    private void updateMinLUT(int minLUTnew) {
        int ctr;
        this.minLUT = minLUTnew;
        double range = this.maxLUT - this.minLUT;
        for (ctr = 0; ctr < this.knots.length; ++ctr) {
            this.knotThresholds[ctr] = this.knots[ctr].val * range + (double)this.minLUT;
        }
        for (ctr = 0; ctr < this.knots.length - 1; ++ctr) {
            this.knotRangeRatios[ctr] = 255.0 / (this.knotThresholds[ctr + 1] - this.knotThresholds[ctr]);
        }
        for (ctr = 0; ctr < 256; ++ctr) {
            if (ctr <= this.minLUT) {
                if (this.expressionValues != null) {
                    double valueB;
                    double valueG = valueB = this.expressionValues[0];
                    double valueR = valueB;
                    this.lutArrayA[ctr] = (byte)this.alphaMin;
                    this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[0].rVal + valueR * (double)this.knots[1].rVal);
                    this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[0].gVal + valueG * (double)this.knots[1].gVal);
                    this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[0].bVal + valueB * (double)this.knots[1].bVal);
                    continue;
                }
                this.lutArrayA[ctr] = (byte)this.alphaMin;
                this.lutArrayR[ctr] = (byte)this.knotMin.rVal;
                this.lutArrayG[ctr] = (byte)this.knotMin.gVal;
                this.lutArrayB[ctr] = (byte)this.knotMin.bVal;
                continue;
            }
            for (int ctrKnot = 0; ctrKnot < this.knots.length - 1; ++ctrKnot) {
                if (!((double)ctr > this.knotThresholds[ctrKnot]) || !((double)ctr <= this.knotThresholds[ctrKnot + 1])) continue;
                if (this.knots[ctrKnot].useGradation || this.expressionValues != null) {
                    double valueR;
                    double valueG;
                    double valueB;
                    if (this.expressionValues != null) {
                        valueG = valueB = this.expressionValues[(int)((double)(ctr - this.minLUT) * this.knotRangeRatios[0] + 0.5)];
                        valueR = valueB;
                    } else {
                        valueR = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                        valueG = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                        valueB = (((double)ctr - this.knotThresholds[ctrKnot]) * this.knotRangeRatios[ctrKnot] + 0.5) / 255.0;
                    }
                    this.lutArrayA[ctr] = (byte)this.alpha;
                    this.lutArrayR[ctr] = (byte)((1.0 - valueR) * (double)this.knots[ctrKnot].rVal + valueR * (double)this.knots[ctrKnot + 1].rVal);
                    this.lutArrayG[ctr] = (byte)((1.0 - valueG) * (double)this.knots[ctrKnot].gVal + valueG * (double)this.knots[ctrKnot + 1].gVal);
                    this.lutArrayB[ctr] = (byte)((1.0 - valueB) * (double)this.knots[ctrKnot].bVal + valueB * (double)this.knots[ctrKnot + 1].bVal);
                    continue;
                }
                this.lutArrayA[ctr] = (byte)this.alpha;
                this.lutArrayR[ctr] = (byte)this.knots[ctrKnot].rVal;
                this.lutArrayG[ctr] = (byte)this.knots[ctrKnot].gVal;
                this.lutArrayB[ctr] = (byte)this.knots[ctrKnot].bVal;
            }
        }
    }

    public static String getLUTExpression(String lutName) {
        LUT foundLUT = null;
        for (int ctr = 0; ctr < allLUTs.size(); ++ctr) {
            LUT currentLUT = allLUTs.get(ctr);
            if (!currentLUT.getName().equals(lutName)) continue;
            foundLUT = currentLUT;
            break;
        }
        if (foundLUT != null) {
            return foundLUT.getExpression();
        }
        return null;
    }

    public static LookupTableKnot[] getLUTKnots(String lutName) {
        LUT foundLUT = null;
        for (int ctr = 0; ctr < allLUTs.size(); ++ctr) {
            LUT currentLUT = allLUTs.get(ctr);
            if (!currentLUT.getName().equals(lutName)) continue;
            foundLUT = currentLUT;
            break;
        }
        if (foundLUT != null) {
            return foundLUT.getKnots();
        }
        return null;
    }

    public static LookupTableManager createLookupTableManager(String typeName, boolean bool) {
        for (int ctr = 0; ctr < NAMES.size(); ++ctr) {
            if (!typeName.equals(NAMES.get(ctr))) continue;
            return LookupTableManager.createLookupTableManager(ctr, bool);
        }
        LookupTableKnot[] someKnots = LookupTableManager.getLUTKnots(typeName);
        if (someKnots != null) {
            return new LookupTableManager(typeName, bool, someKnots);
        }
        return null;
    }

    public static LookupTableKnot[] getLUTKnotsCopy(String lutName) {
        LookupTableKnot[] knots = LookupTableManager.getLUTKnots(lutName);
        LookupTableKnot[] knotsCopy = new LookupTableKnot[knots.length];
        for (int ctr = 0; ctr < knots.length; ++ctr) {
            knotsCopy[ctr] = (LookupTableKnot)knots[ctr].clone();
        }
        return knotsCopy;
    }

    public static LUT[] getAllLUTs() {
        return allLUTs.toArray(new LUT[allLUTs.size()]);
    }

    public static String[] getAllLUTNames() {
        String[] strings = new String[allLUTs.size()];
        for (int ctr = 0; ctr < allLUTs.size(); ++ctr) {
            strings[ctr] = allLUTs.get(ctr).getName();
        }
        return strings;
    }

    public static LookupTableManager createLUTManager(String typeName, boolean bool) {
        return LookupTableManager.createLookupTableManager(typeName, bool);
    }

    private static void initializeLUTsMap() {
        allLUTs = new Vector();
        int numHardCodedLUTs = NAMES.size();
        for (int ctr = 0; ctr < numHardCodedLUTs; ++ctr) {
            LookupTableManager temp = LookupTableManager.createLookupTableManager(ctr, false);
            LUT tempLUT = new LUT(temp.getKnots(), temp.getName(), temp.getExpression());
            allLUTs.add(tempLUT);
        }
    }

    private static void addLUT(LookupTableManager lut) {
        LookupTableManager.addLUT(lut.getName(), lut.getKnots(), lut.getExpression(), false);
    }

    public static void addLUT(String lutName, String expression, LookupTableKnot[] someKnots) {
        LookupTableManager.addLUT(lutName, someKnots, expression, true);
    }

    public static void removeLUT(String lutName) {
        File lutDir = Platform.getLUTDir();
        if (!lutDir.exists()) {
            FileUtilities.mkdirs((File)lutDir);
        }
        File file = new File(lutDir, lutName + ".lut");
        FileUtilities.delete((File)file);
        file.deleteOnExit();
        LookupTableManager.initializeLUTsMap();
        LookupTableManager.addAllLUTs();
    }

    private static void addAllLUTs() {
        try {
            File lutDir = Platform.getLUTDir();
            File[] lutFiles = lutDir.listFiles();
            if (lutFiles != null) {
                for (File file : lutFiles) {
                    if (!file.toString().endsWith(".lut")) continue;
                    LookupTableManager.addLUT(LookupTableManager.readLUT(file.toURI()));
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((String)"There was a problem loading color tables!");
        }
    }

    private static void addLUT(String lutName, LookupTableKnot[] someKnots, String expression, boolean writeFile) {
        LUT tempLUT = new LUT(someKnots, lutName, expression);
        tempLUT.setKnots(someKnots);
        tempLUT.setExpression(expression);
        if (writeFile) {
            File lutDir = Platform.getLUTDir();
            if (!lutDir.exists()) {
                FileUtilities.mkdirs((File)lutDir);
            }
            File file = new File(lutDir, lutName + ".lut");
            LookupTableManager.writeLUT(lutName, tempLUT, file);
        }
        if (allLUTs.contains(tempLUT)) {
            allLUTs.remove(tempLUT);
        }
        allLUTs.add(tempLUT);
    }

    public void swapForBinaryColorTable() {
        if (this.name.equals(TYPE_OVERLAY1_NAME)) {
            this.replaceKnots(LookupTableManager.getLUTKnots(TYPE_RED_NAME));
            this.setName(TYPE_RED_NAME);
        } else if (this.name.equals(TYPE_OVERLAY2_NAME)) {
            this.replaceKnots(LookupTableManager.getLUTKnots(TYPE_GREEN_NAME));
            this.setName(TYPE_GREEN_NAME);
        } else if (this.name.equals(TYPE_OVERLAY3_NAME)) {
            this.replaceKnots(LookupTableManager.getLUTKnots(TYPE_BLUE_NAME));
            this.setName(TYPE_BLUE_NAME);
        }
        this.updateLUT();
    }

    static {
        lastSetAlpha = new AtomicReference();
        NAMES = CollectionUtilities.immutable((String[])new String[]{TYPE_GREYSCALE_NAME, TYPE_INVERTED_NAME, TYPE_COMPRESSOR_NAME, TYPE_OVERLAY1_NAME, TYPE_OVERLAY2_NAME, TYPE_OVERLAY3_NAME, TYPE_OVERLAY_POSITIVES_NAME, TYPE_OVERLAY_NEGATIVES_NAME, TYPE_RED_NAME, TYPE_GREEN_NAME, TYPE_BLUE_NAME, TYPE_SPECTRUM_BW_NAME, TYPE_HOT2COLD_NAME, TYPE_GOLD_NAME, TYPE_FIRE_NAME});
        NAMES_PAPAYA_COMPATIBLE = CollectionUtilities.immutable((String[])new String[]{TYPE_GREYSCALE_NAME, TYPE_OVERLAY1_NAME, TYPE_OVERLAY2_NAME, TYPE_OVERLAY3_NAME, TYPE_OVERLAY_POSITIVES_NAME, TYPE_OVERLAY_NEGATIVES_NAME, TYPE_SPECTRUM_BW_NAME, TYPE_HOT2COLD_NAME, TYPE_GOLD_NAME, TYPE_FIRE_NAME});
        lastSetAlpha.set(255);
        DEFAULT_LUT = LookupTableManager.createLookupTableManager(11, false);
        DEFAULT_LUT.initLUT();
        LookupTableManager.initializeLUTsMap();
        if (!Platform.isApplet()) {
            LookupTableManager.addAllLUTs();
        }
    }
}

