/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.operations;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.EquivalentSetManager;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public final class ShrinkWrapOperations {
    public static final String TEXT_SHRINK_WRAPPING = "Shrink Wrapping";

    private ShrinkWrapOperations() {
    }

    public static void doShrinkWrap(int[] data, int[] buffer, int numCols, int numRows, int threshold, int textureXdim) {
        int offset = 0;
        int offsetY = 0;
        int offsetMinusY = 0;
        int offsetYMinusY = 0;
        int offsetMinusX = 0;
        int offsetTextureY = 0;
        int offsetTexture = 0;
        int xDimDataMax = numCols - 1;
        int yDimDataMax = numRows - 1;
        float current = 0.0f;
        int componentCtr = 1;
        EquivalentSetManager equivManager = new EquivalentSetManager();
        equivManager.addStartVal(0);
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            offsetY = numCols * ctrR;
            offsetYMinusY = numCols * (ctrR - 1);
            offsetTextureY = textureXdim * ctrR;
            for (int ctrC = 0; ctrC < numCols; ++ctrC) {
                offset = ctrC + offsetY;
                offsetMinusX = ctrC - 1 + offsetY;
                offsetMinusY = ctrC + offsetYMinusY;
                offsetTexture = offsetTextureY + ctrC;
                buffer[offset] = 0;
                current = data[offsetTexture];
                if (current != (float)threshold) continue;
                if (ctrC == 0 || ctrR == 0) {
                    buffer[offset] = 1;
                    continue;
                }
                if (ctrC == xDimDataMax) {
                    buffer[offset] = 1;
                    if (buffer[offsetMinusX] == buffer[offset] || buffer[offsetMinusX] == 0) continue;
                    equivManager.addPair(buffer[offsetMinusX], buffer[offset]);
                    continue;
                }
                if (ctrR == yDimDataMax) {
                    buffer[offset] = 1;
                    if (buffer[offsetMinusY] == buffer[offset] || buffer[offsetMinusY] == 0) continue;
                    equivManager.addPair(buffer[offsetMinusY], buffer[offset]);
                    continue;
                }
                if (buffer[offsetMinusX] != 0 && buffer[offsetMinusY] != 0) {
                    buffer[offset] = buffer[offsetMinusX];
                    if (buffer[offsetMinusX] == buffer[offsetMinusY]) continue;
                    equivManager.addPair(buffer[offsetMinusX], buffer[offsetMinusY]);
                    continue;
                }
                if (buffer[offsetMinusX] != 0) {
                    buffer[offset] = buffer[offsetMinusX];
                    continue;
                }
                if (buffer[offsetMinusY] != 0) {
                    buffer[offset] = buffer[offsetMinusY];
                    continue;
                }
                equivManager.incrementSetMap();
                buffer[offset] = ++componentCtr;
            }
        }
        boolean notFound = componentCtr <= 1;
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivManager, 1);
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            offsetY = numCols * ctrR;
            offsetTextureY = textureXdim * ctrR;
            for (int ctrC = 0; ctrC < numCols; ++ctrC) {
                offset = ctrC + offsetY;
                offsetTexture = offsetTextureY + ctrC;
                if (notFound) {
                    data[offsetTexture] = 0;
                    continue;
                }
                if (!contains[buffer[offset]]) continue;
                data[offsetTexture] = 0;
            }
        }
    }

    public static ByteBuffer shrinkWrap2D(int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, VolumeManager manager, int sliceDirection, double thresholdMin, double thresholdMax, boolean isWorldMode, boolean useMMmodeTransform, int transformNumMM, boolean isROIOrLogical, boolean isBase) {
        if (sliceDirection == 0) {
            return ShrinkWrapOperations.doMakeShrinkWrapAxial(xSteps, ySteps, zSteps, xRes, yRes, zRes, renderVol, manager, thresholdMin, thresholdMax, isROIOrLogical);
        }
        if (sliceDirection == 1) {
            return ShrinkWrapOperations.doMakeShrinkWrapCoronal(xSteps, ySteps, zSteps, xRes, yRes, zRes, renderVol, manager, thresholdMin, thresholdMax, isROIOrLogical);
        }
        if (sliceDirection == 2) {
            return ShrinkWrapOperations.doMakeShrinkWrapSagittal(xSteps, ySteps, zSteps, xRes, yRes, zRes, renderVol, manager, thresholdMin, thresholdMax, isROIOrLogical);
        }
        return null;
    }

    public static ByteBuffer shrinkWrap3D(int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, ByteBuffer labelBuffer, VolumeManager manager, double thresholdMin, double thresholdMax, boolean isWorldMode, boolean useMMmodeTransform, int transformNumMM, boolean isROIOrLogical, boolean isBase) {
        ByteBuffer mask = Buffers.newDirectByteBuffer((int)(xSteps * ySteps * zSteps));
        boolean on = true;
        boolean off = false;
        IntBuffer storageBuffer = labelBuffer.asIntBuffer();
        int[] xyBuffer = new int[xSteps * ySteps];
        int[] axialBuffer = new int[xSteps * ySteps];
        int[] slice = xyBuffer;
        ProgressMeter pb = manager.makeProgressMeter();
        pb.setDescription("Finding Region");
        boolean[] contains = ShrinkWrapOperations.findSetOfConnectedLabelsShrinkWrap3D(manager, thresholdMin, thresholdMax, xSteps, ySteps, zSteps, xRes, yRes, zRes, renderVol, labelBuffer, xyBuffer, axialBuffer, pb, isROIOrLogical, isBase);
        storageBuffer.rewind();
        pb.setDescription(TEXT_SHRINK_WRAPPING);
        for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
            int offsetZ = ctrZ * xSteps * ySteps;
            pb.setValue(ctrZ);
            storageBuffer.get(slice);
            for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                int offsetROIY = xSteps * ctrY;
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    if (!contains[slice[offsetROI]]) {
                        mask.put(offsetROI + offsetZ, (byte)1);
                        continue;
                    }
                    mask.put(offsetROI + offsetZ, (byte)0);
                }
            }
        }
        pb.setValue(pb.getMax());
        return mask;
    }

    private static ByteBuffer doMakeShrinkWrapAxial(int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, VolumeManager manager, double thresholdMin, double thresholdMax, boolean isROIOrLogical) {
        VolumeData volData = new VolumeData(manager, renderVol);
        ByteBuffer mask = Buffers.newDirectByteBuffer((int)(xSteps * ySteps * zSteps));
        int[] slice = new int[xSteps * ySteps];
        boolean on = true;
        ProgressMeter pb = manager.makeProgressMeter();
        pb.setDescription(TEXT_SHRINK_WRAPPING);
        pb.start(0, 0, zSteps);
        for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
            int offsetROIY;
            int offsetZ = ctrZ * xSteps * ySteps;
            int componentCtr = 1;
            EquivalentSetManager equivSetManager = new EquivalentSetManager();
            equivSetManager.addStartVal(1);
            pb.setValue(ctrZ);
            for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                offsetROIY = xSteps * ctrY;
                int offsetROIYMinusY = xSteps * (ctrY - 1);
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    slice[offsetROI] = 0;
                    double current = volData.getValueMMTemp((double)ctrX * xRes, (double)ctrY * yRes, (double)ctrZ * zRes);
                    if (!(current < thresholdMin) && (isROIOrLogical || !(current > thresholdMax))) continue;
                    if (ctrX <= 0 || ctrY <= 0 || ctrX > xSteps || ctrY > ySteps) {
                        slice[offsetROI] = 1;
                        continue;
                    }
                    if (slice[offsetROIMinusX] != 0 && slice[offsetROIMinusY] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusX];
                        if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                        equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                        continue;
                    }
                    if (slice[offsetROIMinusX] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusX];
                        continue;
                    }
                    if (slice[offsetROIMinusY] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusY];
                        continue;
                    }
                    equivSetManager.incrementSetMap();
                    slice[offsetROI] = ++componentCtr;
                }
            }
            boolean[] contains = new boolean[componentCtr + 1];
            ROIManager.findConnectedLabels(contains, equivSetManager, 1);
            for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                offsetROIY = xSteps * ctrY;
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    int offset = ctrX + offsetROIY;
                    if (contains[slice[offset]]) continue;
                    mask.put(offset + offsetZ, (byte)1);
                }
            }
        }
        pb.setValue(pb.getMax());
        return mask;
    }

    private static ByteBuffer doMakeShrinkWrapCoronal(int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, VolumeManager manager, double thresholdMin, double thresholdMax, boolean isROIOrLogical) {
        VolumeData volData = new VolumeData(manager, renderVol);
        ByteBuffer mask = Buffers.newDirectByteBuffer((int)(xSteps * ySteps * zSteps));
        int[] slice = new int[xSteps * zSteps];
        boolean on = true;
        ProgressMeter pb = manager.makeProgressMeter();
        pb.setDescription(TEXT_SHRINK_WRAPPING);
        pb.start(0, 0, ySteps);
        for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
            int offsetROI;
            int offsetROIZ;
            int componentCtr = 1;
            EquivalentSetManager equivSetManager = new EquivalentSetManager();
            equivSetManager.addStartVal(1);
            int offsetROIY = ctrY * xSteps;
            pb.setValue(ctrY);
            for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
                offsetROIZ = ctrZ * xSteps;
                int offsetROIZMinusZ = (ctrZ - 1) * xSteps;
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    offsetROI = ctrX + offsetROIZ;
                    int offsetROIMinusX = ctrX - 1 + offsetROIZ;
                    int offsetROIMinusZ = ctrX + offsetROIZMinusZ;
                    slice[offsetROI] = 0;
                    double current = volData.getValueMMTemp((double)ctrX * xRes, (double)ctrY * yRes, (double)ctrZ * zRes);
                    if (!(current < thresholdMin) && (isROIOrLogical || !(current > thresholdMax))) continue;
                    if (ctrX <= 0 || ctrZ <= 0 || ctrX > xSteps || ctrZ > zSteps) {
                        slice[offsetROI] = 1;
                        continue;
                    }
                    if (slice[offsetROIMinusX] != 0 && slice[offsetROIMinusZ] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusX];
                        if (slice[offsetROIMinusX] == slice[offsetROIMinusZ]) continue;
                        equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusZ]);
                        continue;
                    }
                    if (slice[offsetROIMinusX] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusX];
                        continue;
                    }
                    if (slice[offsetROIMinusZ] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusZ];
                        continue;
                    }
                    equivSetManager.incrementSetMap();
                    slice[offsetROI] = ++componentCtr;
                }
            }
            boolean[] contains = new boolean[componentCtr + 1];
            ROIManager.findConnectedLabels(contains, equivSetManager, 1);
            for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
                offsetROIZ = xSteps * ctrZ;
                int offsetROIByteArrayZ = xSteps * ySteps * ctrZ;
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    offsetROI = ctrX + offsetROIZ;
                    int offsetROIByteArray = ctrX + offsetROIY + offsetROIByteArrayZ;
                    if (contains[slice[offsetROI]]) continue;
                    mask.put(offsetROIByteArray, (byte)1);
                }
            }
        }
        pb.setValue(pb.getMax());
        return mask;
    }

    private static ByteBuffer doMakeShrinkWrapSagittal(int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, VolumeManager manager, double thresholdMin, double thresholdMax, boolean isROIOrLogical) {
        VolumeData volData = new VolumeData(manager, renderVol);
        ByteBuffer mask = Buffers.newDirectByteBuffer((int)(xSteps * ySteps * zSteps));
        int[] slice = new int[xSteps * zSteps];
        boolean on = true;
        ProgressMeter pb = manager.makeProgressMeter();
        pb.setDescription(TEXT_SHRINK_WRAPPING);
        pb.start(0, 0, xSteps);
        for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
            int offsetROI;
            int offsetROIZ;
            int componentCtr = 1;
            EquivalentSetManager equivSetManager = new EquivalentSetManager();
            equivSetManager.addStartVal(1);
            pb.setValue(ctrX);
            for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
                offsetROIZ = ySteps * ctrZ;
                int offsetROIZMinusZ = ySteps * (ctrZ - 1);
                for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                    offsetROI = ctrY + offsetROIZ;
                    int offsetROIMinusY = ctrY - 1 + offsetROIZ;
                    int offsetROIMinusZ = ctrY + offsetROIZMinusZ;
                    slice[offsetROI] = 0;
                    double current = volData.getValueMMTemp((double)ctrX * xRes, (double)ctrY * yRes, (double)ctrZ * zRes);
                    if (!(current < thresholdMin) && (isROIOrLogical || !(current > thresholdMax))) continue;
                    if (ctrY <= 0 || ctrZ <= 0 || ctrY > ySteps || ctrZ > zSteps) {
                        slice[offsetROI] = 1;
                        continue;
                    }
                    if (slice[offsetROIMinusY] != 0 && slice[offsetROIMinusZ] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusY];
                        if (slice[offsetROIMinusY] == slice[offsetROIMinusZ]) continue;
                        equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROIMinusZ]);
                        continue;
                    }
                    if (slice[offsetROIMinusY] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusY];
                        continue;
                    }
                    if (slice[offsetROIMinusZ] != 0) {
                        slice[offsetROI] = slice[offsetROIMinusZ];
                        continue;
                    }
                    equivSetManager.incrementSetMap();
                    slice[offsetROI] = ++componentCtr;
                }
            }
            boolean[] contains = new boolean[componentCtr + 1];
            ROIManager.findConnectedLabels(contains, equivSetManager, 1);
            for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
                offsetROIZ = ySteps * ctrZ;
                int offsetROIByteArrayZ = xSteps * ySteps * ctrZ;
                for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                    offsetROI = ctrY + offsetROIZ;
                    int offsetROIByteArray = ctrX + xSteps * ctrY + offsetROIByteArrayZ;
                    if (contains[slice[offsetROI]]) continue;
                    mask.put(offsetROIByteArray, (byte)1);
                }
            }
        }
        pb.setValue(pb.getMax());
        return mask;
    }

    private static boolean[] findSetOfConnectedLabelsShrinkWrap3D(VolumeManager manager, double thresholdMin, double thresholdMax, int xSteps, int ySteps, int zSteps, double xRes, double yRes, double zRes, Volume renderVol, ByteBuffer labelBuffer, int[] xyBuffer, int[] axialBuffer, ProgressMeter pb, boolean isROIOrLogical, boolean isBase) {
        VolumeData volData = new VolumeData(manager, renderVol);
        if (isROIOrLogical) {
            volData.setWorldMode(false);
            volData.setUseDataScaleTemp(false);
        }
        if (isBase) {
            volData.setUsingTransform(false);
        }
        IntBuffer storageBuffer = labelBuffer.asIntBuffer();
        EquivalentSetManager equivSetManager = new EquivalentSetManager();
        equivSetManager.addStartVal(1);
        int componentCtr = 1;
        int[] sliceUpper = xyBuffer;
        int[] slice = axialBuffer;
        for (int ctr = 0; ctr < xyBuffer.length; ++ctr) {
            slice[ctr] = 0;
            sliceUpper[ctr] = 0;
        }
        pb.start(0, 0, zSteps);
        for (int ctrZ = 0; ctrZ < zSteps; ++ctrZ) {
            pb.setValue(ctrZ);
            for (int ctrY = 0; ctrY < ySteps; ++ctrY) {
                int offsetROIY = xSteps * ctrY;
                int offsetROIYMinusY = xSteps * (ctrY - 1);
                for (int ctrX = 0; ctrX < xSteps; ++ctrX) {
                    int offsetROI = ctrX + offsetROIY;
                    int offsetROIMinusX = ctrX - 1 + offsetROIY;
                    int offsetROIMinusY = ctrX + offsetROIYMinusY;
                    double current = volData.getValueMMTemp((double)ctrX * xRes, (double)ctrY * yRes, (double)ctrZ * zRes);
                    if (current < thresholdMin || !isROIOrLogical && current > thresholdMax) {
                        if (ctrX <= 0 || ctrY <= 0 || ctrZ <= 0) {
                            slice[offsetROI] = 1;
                            continue;
                        }
                        if (ctrX == xSteps - 1) {
                            slice[offsetROI] = 1;
                            if (slice[offsetROIMinusX] == slice[offsetROI] || slice[offsetROIMinusX] == 0) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROI]);
                            continue;
                        }
                        if (ctrY == ySteps - 1) {
                            slice[offsetROI] = 1;
                            if (slice[offsetROIMinusY] == slice[offsetROI] || slice[offsetROIMinusY] == 0) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], slice[offsetROI]);
                            continue;
                        }
                        if (ctrZ == zSteps - 1) {
                            slice[offsetROI] = 1;
                            if (sliceUpper[offsetROI] == slice[offsetROI] || sliceUpper[offsetROI] == 0) continue;
                            equivSetManager.addPair(sliceUpper[offsetROI], slice[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] != slice[offsetROIMinusY]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            }
                            if (slice[offsetROIMinusX] != sliceUpper[offsetROI]) {
                                equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            }
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == slice[offsetROIMinusY]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], slice[offsetROIMinusY]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            if (slice[offsetROIMinusX] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusX], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0 && ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            if (slice[offsetROIMinusY] == sliceUpper[offsetROI]) continue;
                            equivSetManager.addPair(slice[offsetROIMinusY], sliceUpper[offsetROI]);
                            continue;
                        }
                        if (ctrX != 0 && slice[offsetROIMinusX] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusX];
                            continue;
                        }
                        if (ctrY != 0 && slice[offsetROIMinusY] != 0) {
                            slice[offsetROI] = slice[offsetROIMinusY];
                            continue;
                        }
                        if (ctrZ != 0 && sliceUpper[offsetROI] != 0) {
                            slice[offsetROI] = sliceUpper[offsetROI];
                            continue;
                        }
                        equivSetManager.incrementSetMap();
                        slice[offsetROI] = ++componentCtr;
                        continue;
                    }
                    slice[offsetROI] = 0;
                }
            }
            storageBuffer.put(slice, 0, slice.length);
            int[] temp = sliceUpper;
            sliceUpper = slice;
            slice = temp;
        }
        boolean[] contains = new boolean[componentCtr + 1];
        ROIManager.findConnectedLabels(contains, equivSetManager, 1);
        return contains;
    }
}

